/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.control;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.PrintServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.session.SessionManager;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.EquipmentConstant;
import kd.imc.bdm.common.constant.FileType;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.constant.PrintTypeEnum;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleQueryUrlDTO;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.CancelRedEum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.DeviceHelper;
import kd.imc.bdm.common.helper.DownLoadCenterHelper;
import kd.imc.bdm.common.helper.EasBusinessHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.helper.RelationHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.FileUploadUtils;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.RequestUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.dto.allele.AllEleQueryUrlResponseDTO;
import kd.imc.sim.common.helper.CheckCurrentOrgHelper;
import kd.imc.sim.common.helper.FiArFinArBillHelper;
import kd.imc.sim.common.helper.allele.AllEleInvoiceFileHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.IssuedInvoiceWriteBackHelper;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.lang3.StringUtils;

@SdkDeprecated
public class InvoiceQueryControl {
    private static final Log LOG = LogFactory.getLog(InvoiceQueryControl.class);
    private static final String SIM_MESSAGE_RESEND = "sim_message_resend";
    private static final Set<String> INVOICE_STATUS_CAN_INVALID = Sets.newHashSet((Object[])new String[]{"0", "7"});
    public static final String MSG_RE_SEND = "msg_resend";
    public static final String MSG_RE_SEND_EMAIL = "msg_resend_email";
    public static final String SEARCH_DATE = "search_date";

    public static void reSend(AbstractListPlugin formPlugin) {
        BillList billList = (BillList)formPlugin.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u8981\u64cd\u4f5c\u7684\u6570\u636e\u884c", (String)"InvoiceQueryControl_0", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        if (primaryKeyValues.length > 200) {
            formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u5c11\u4e8e200\u6761\u8981\u64cd\u4f5c\u7684\u6570\u636e\u884c", (String)"InvoiceQueryControl_1", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
        int selLength = objects.length;
        CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)formPlugin, (ImcPermItemEnum)ImcPermItemEnum.BTN_RE_SEND, (DynamicObject[])objects);
        for (DynamicObject obj : objects) {
            if (!InvoiceUtils.isEtcInvoice((String)obj.getString("invoicetype")) && !InvoiceUtils.isVolumeInvCreatePdf((DynamicObject)obj)) {
                formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u7968\u79cd\u7c7b\u4e3a'\u7535\u5b50\u53d1\u7968'\u7684\u6570\u636e\u884c\u8fdb\u884c\u91cd\u53d1\u64cd\u4f5c", (String)"InvoiceQueryControl_2", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if ("8".equals(obj.getString("buyertype"))) {
                formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u8fc7excel\u5bfc\u5165\u7684\u53d1\u7968\u4fe1\u606f\u4e0d\u5141\u8bb8\u8fdb\u884c\u91cd\u53d1\u64cd\u4f5c", (String)"InvoiceQueryControl_3", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            String fileUrl = obj.getString("fileurl");
            if (!InvoiceUtils.isAllEInvoice((Object)obj.getString("invoicetype")) && StringUtils.isBlank((CharSequence)fileUrl)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s,\u53d1\u7968\u53f7\u7801\uff1a%2$s,\u7684\u53d1\u7968\u6587\u4ef6\u5730\u5740\u4e0d\u5b58\u5728\uff0c\u4e0d\u652f\u6301\u91cd\u53d1,\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceQueryControl_4", (String)"imc-sim-service", (Object[])new Object[0]), obj.getString("invoicecode"), obj.getString("invoiceno")));
            }
            if ("9".equals(obj.getString("buyertype"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542b\u8fdb\u9879\u4e0b\u8f7d\u6570\u636e\u4e0d\u5141\u8bb8\u91cd\u53d1", (String)"InvoiceQueryControl_5", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            if (InvoiceUtils.isAllEInvoice((Object)obj.getString("invoicetype")) && StringUtils.isNotBlank((CharSequence)fileUrl) && !fileUrl.startsWith("http")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a%s\u672a\u4e0a\u4f20\u516c\u7f51\uff0c\u65e0\u53ef\u8bbf\u95ee\u94fe\u63a5\uff0c\u4e0d\u652f\u6301\u91cd\u53d1,\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceQueryControl_6", (String)"imc-sim-service", (Object[])new Object[0]), obj.getString("invoiceno")));
            }
            if (StringUtils.isNotBlank((CharSequence)fileUrl) && !fileUrl.startsWith("http") && !"1".equals(ImcConfigUtil.getValue((String)"SendWithoutHttp", (String)"SendWithoutHttp"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\uff1a%s\u672a\u4e0a\u4f20\u516c\u7f51\uff0c\u65e0\u53ef\u8bbf\u95ee\u94fe\u63a5\uff0c\u4e0d\u652f\u6301\u91cd\u53d1,\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceQueryControl_6", (String)"imc-sim-service", (Object[])new Object[0]), obj.getString("invoiceno")));
            }
            if (selLength != 1 || !StringUtils.isBlank((CharSequence)obj.getString("fileurl"))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s,\u53d1\u7968\u53f7\u7801\uff1a%2$s,\u7684\u53d1\u7968\u6587\u4ef6\u5730\u5740\u4e0d\u5b58\u5728\uff0c\u4e0d\u652f\u6301\u91cd\u53d1,\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceQueryControl_4", (String)"imc-sim-service", (Object[])new Object[0]), obj.getString("invoicecode"), obj.getString("invoiceno")));
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        if (primaryKeyValues.length == 1) {
            customParams.put("pks", billList.getCurrentSelectedRowInfo().getPrimaryKeyValue());
            ViewUtil.openDialog((AbstractFormPlugin)formPlugin, customParams, (String)SIM_MESSAGE_RESEND, (String)MSG_RE_SEND);
            return;
        }
        customParams.put("pks", primaryKeyValues);
        ViewUtil.openDialog((AbstractFormPlugin)formPlugin, customParams, (String)"sim_message_resend_label", (String)MSG_RE_SEND_EMAIL);
    }

    public static void export(AbstractListPlugin formPlugin) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        BillList billList = (BillList)formPlugin.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            String searchDate = formPlugin.getPageCache().get(SEARCH_DATE);
            customParams.put(SEARCH_DATE, searchDate);
            String qfilterCache = formPlugin.getPageCache().get("exportFilters");
            customParams.put("exportFilters", qfilterCache);
        } else {
            int limitSize;
            Object[] ids = selectedRows.getPrimaryKeyValues();
            if (ids.length > (limitSize = InvoiceQueryControl.getLimitSize())) {
                formPlugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6309\u53d1\u7968\u5bfc\u51fa\u4e0d\u80fd\u8d85\u8fc71000\u6761\uff0c\u8d85\u8fc71000\u6761\u8bf7\u53d6\u6d88\u52fe\u9009\u540e\u6309\u65e5\u671f\u5bfc\u51fa", (String)"InvoiceQueryControl_57", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] invoiceArray = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
            CheckCurrentOrgHelper.checkSelectRowsCurrentAuthor((AbstractFormPlugin)formPlugin, (ImcPermItemEnum)ImcPermItemEnum.SIM_BDM_DERIVE, (DynamicObject[])invoiceArray);
            customParams.put("keys", selectedRows.getPrimaryKeyValues());
        }
        customParams.put("orgIdFilter", SerializationUtils.toJsonString((Object)billList.getMainOrgQFilter()));
        ViewUtil.openDialog((AbstractFormPlugin)formPlugin, customParams, (String)"sim_export_invoice_dialog", (String)"export_invoice_dialog");
    }

    private static int getLimitSize() {
        String exportLimit = ImcConfigUtil.getValue((String)"sim_vatinvoice", (String)"export_limit");
        if (StringUtils.isBlank((CharSequence)exportLimit)) {
            return 1000;
        }
        try {
            return Integer.parseInt(exportLimit);
        }
        catch (Exception e) {
            return 1000;
        }
    }

    public static void invoiceImport(AbstractListPlugin _this) {
        ViewUtil.openDialog((AbstractFormPlugin)_this, null, (String)"sim_invoice_import", (String)"invoice_import");
    }

    public static void invoicesync(AbstractListPlugin formPlugin) {
        ViewUtil.openDialog((AbstractFormPlugin)formPlugin, null, (String)"sim_sync_invoice_dialog", (String)"sync_invoice_dialog");
    }

    public static void invoiceStSync(AbstractListPlugin formPlugin, Map<String, Object> paramMap) {
        ViewUtil.openDialog((AbstractFormPlugin)formPlugin, paramMap, (String)"sim_sync_invoice_st_popup", (String)"sync_invoice_st_popup");
    }

    public static boolean download(AbstractListPlugin formPlugin) {
        BillList billList = (BillList)formPlugin.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        DynamicObject[] dObjects = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)billList.getListModel().getDataEntityType());
        CheckCurrentOrgHelper.checkSelectRowsCurrentAuthor((AbstractFormPlugin)formPlugin, (ImcPermItemEnum)ImcPermItemEnum.BTN_DOWNLOAD, (DynamicObject[])dObjects);
        ArrayList<Map<String, String>> ofdList = new ArrayList<Map<String, String>>(dObjects.length);
        boolean isChooseDownloadInvoiceType = false;
        StringBuilder errInvoiceNo = new StringBuilder();
        for (DynamicObject invoiceDynamicObject : dObjects) {
            if (!InvoiceUtils.isAllEInvoice((Object)invoiceDynamicObject.getString("invoicetype")) && !"1".equals(invoiceDynamicObject.getString("ofdstatus"))) {
                errInvoiceNo.append(invoiceDynamicObject.getString("invoiceno")).append(',');
                continue;
            }
            InvoiceQueryControl.putOfdMapData(ofdList, invoiceDynamicObject);
            if (!InvoiceUtils.isAllEInvoice((Object)invoiceDynamicObject.getString("invoicetype")) && !InvoiceUtils.isAllEVehicleOrAllEUsedCar((String)invoiceDynamicObject.getString("invoicetype"))) continue;
            isChooseDownloadInvoiceType = true;
        }
        if (errInvoiceNo.length() > 0) {
            formPlugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801:%s\u8fd8\u672a\u751f\u6210\u53d1\u7968\u6587\u4ef6\uff0c\u8bf7\u7a0d\u5019\u4e0b\u8f7d", (String)"InvoiceQueryControl_7", (String)"imc-sim-service", (Object[])new Object[0]), errInvoiceNo.toString()));
            return false;
        }
        if (isChooseDownloadInvoiceType) {
            ViewUtil.openDialog((AbstractFormPlugin)formPlugin, null, (String)"sim_choose_invoice_type", (String)"sim_choose_invoice_type");
            return false;
        }
        InvoiceQueryControl.downloadFile(formPlugin, dObjects, ofdList);
        return true;
    }

    public static void downloadAllEleFile(AbstractListPlugin formPlugin, String fileType) {
        BillList billList = (BillList)formPlugin.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        DynamicObject[] dObjects = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)billList.getListModel().getDataEntityType());
        ArrayList<Map<String, String>> ofdList = new ArrayList<Map<String, String>>(dObjects.length);
        Set splitType = Arrays.stream(fileType.split(",")).filter(o -> StringUtils.isNotBlank((CharSequence)o)).collect(Collectors.toSet());
        boolean isNeedLogin = false;
        for (String s : splitType) {
            for (DynamicObject invoice : dObjects) {
                if (!InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype")) && !InvoiceUtils.isAllEVehicleOrAllEUsedCar((String)invoice.getString("invoicetype"))) continue;
                if (s.equalsIgnoreCase("pdf") && StringUtils.isBlank((CharSequence)invoice.getString("pdffileurl"))) {
                    isNeedLogin = true;
                }
                if (s.equalsIgnoreCase("ofd") && StringUtils.isBlank((CharSequence)invoice.getString("fileurl"))) {
                    isNeedLogin = true;
                }
                if (!s.equalsIgnoreCase("xml") || !StringUtils.isBlank((CharSequence)invoice.getString("xmlfileurl"))) continue;
                isNeedLogin = true;
            }
        }
        if (isNeedLogin) {
            LOG.info("enterOpenLogin");
            String taxNo = dObjects[0].getString("salertaxno");
            String specialType = dObjects[0].getString("specialtype");
            if ("02".equals(specialType)) {
                taxNo = dObjects[0].getString("buyertaxno");
            }
            HashMap param = Maps.newHashMap();
            param.put("salertaxno", taxNo);
            boolean isNeedlogin = AllEleServiceHelper.isNeedLogin((AbstractFormPlugin)formPlugin, (Map)param);
            LOG.info("\u662f\u5426\u8fdb\u884c\u4e86\u767b\u5f55" + isNeedlogin);
            if (isNeedlogin) {
                formPlugin.getPageCache().put("fileType", fileType);
                return;
            }
        }
        for (String type : splitType) {
            for (DynamicObject invoice : dObjects) {
                InvoiceQueryControl.putAllEOfdMapData(ofdList, invoice, type);
            }
        }
        InvoiceQueryControl.downloadAllEleFile(formPlugin, dObjects, ofdList);
    }

    private static void downloadAllEleFile(AbstractListPlugin formPlugin, DynamicObject[] dObjects, List<Map<String, String>> ofdList) {
        boolean isUsedCarList;
        block16: {
            isUsedCarList = "kd.imc.sim.formplugin.vehicle.VehicleInvoiceListPlugin".equals(formPlugin.getPluginName());
            if (ofdList.size() == 1) {
                String fileName = DownLoadCenterHelper.warpDownloadFileName(ofdList.get(0));
                LOG.info("ofdList:" + JSONObject.toJSONString(ofdList));
                try (InputStream in = DownLoadCenterHelper.getDownloadPdfInputStream(ofdList.get(0));){
                    LOG.info("fileSize:" + in.available());
                    String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, in, 7200);
                    PermissionHelper.checkTempFilePermission((String)urls, (String)"sim", (String)"sim_vatinvoice", (String)ImcPermItemEnum.BTN_DOWNLOAD.getPermId());
                    formPlugin.getView().openUrl(urls);
                    break block16;
                }
                catch (Exception e) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38", (String)"InvoiceQueryControl_8", (String)"imc-sim-service", (Object[])new Object[0]));
                }
            }
            InvoiceQueryControl.downloadFile(formPlugin.getView(), ofdList, InvoiceUtils.isEtcInvoice((String)dObjects[0].getString("invoicetype")) ? "\u7535\u5b50" : "\u7eb8\u8d28");
            DownLoadCenterHelper.addDownloadItem((int)ofdList.size(), (String)"zip");
        }
        if (isUsedCarList) {
            return;
        }
        InvoiceQueryControl.saveDownloadLable(dObjects);
    }

    private static void saveDownloadLable(DynamicObject[] dObjects) {
        for (DynamicObject dObject : dObjects) {
            dObject.set("downloadflag", (Object)"2");
        }
        ImcSaveServiceHelper.save((DynamicObject[])dObjects);
    }

    public static void downloadFile(AbstractListPlugin formPlugin, DynamicObject[] dObjects, List<Map<String, String>> ofdList) {
        boolean isUsedCarList = "kd.imc.sim.formplugin.vehicle.VehicleInvoiceListPlugin".equals(formPlugin.getPluginName());
        if (ofdList.size() == 1) {
            InputStream in;
            String fileName;
            if (isUsedCarList) {
                Map<String, String> fileMap = ofdList.get(0);
                String invoiceNo = fileMap.get("fileInvoiceNo");
                String buyerName = fileMap.get("buyername");
                String invoiceAmount = fileMap.get("invoiceamount");
                String issueTime = fileMap.get("issuetime");
                String fileType = fileMap.get("fileType");
                fileName = String.format("dzfp_%s_%s_%s_%s.%s", invoiceNo, buyerName, invoiceAmount, issueTime.substring(0, 8), fileType);
            } else {
                fileName = DownLoadCenterHelper.warpDownloadFileName(ofdList.get(0));
            }
            try {
                in = DownLoadCenterHelper.getDownloadPdfInputStream(ofdList.get(0));
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38", (String)"InvoiceQueryControl_8", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, in, 7200);
            if (isUsedCarList) {
                PermissionHelper.checkTempFilePermission((String)urls, (String)"sim", (String)"sim_vatinvoice_vehicles", (String)ImcPermItemEnum.BTN_DOWNLOAD.getPermId());
            } else {
                PermissionHelper.checkTempFilePermission((String)urls, (String)"sim", (String)"sim_vatinvoice", (String)ImcPermItemEnum.BTN_DOWNLOAD.getPermId());
            }
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            formPlugin.getView().openUrl(urls);
        } else {
            InvoiceQueryControl.downloadFile(formPlugin.getView(), ofdList, InvoiceUtils.isEtcInvoice((String)dObjects[0].getString("invoicetype")) ? "\u7535\u5b50" : "\u7eb8\u8d28");
            DownLoadCenterHelper.addDownloadItem((int)ofdList.size(), (String)"zip");
        }
        if (isUsedCarList) {
            ImcSaveServiceHelper.save((DynamicObject[])dObjects);
            return;
        }
        InvoiceQueryControl.saveDownloadLable(dObjects);
    }

    public static void putAllEOfdMapData(List<Map<String, String>> ofdList, DynamicObject invoice, String fileType) {
        String fileUrl;
        String localFileUrl;
        QFilter qFilter;
        DynamicObject invoiceFile;
        if (StringUtils.isNotBlank((CharSequence)fileType) && InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype")) && !FileType.XML.getFileExtension().equals(fileType) && (invoiceFile = QueryServiceHelper.queryOne((String)"sim_vatinvoice_file", (String)"localfileurl", (QFilter[])(qFilter = new QFilter("invoiceno", "=", (Object)invoice.getString("invoiceno")).and("filetype", "=", (Object)fileType.toLowerCase())).toArray())) != null && StringUtils.isNotBlank((CharSequence)(localFileUrl = invoiceFile.getString("localfileurl")))) {
            LOG.info(String.format("\u53d1\u7968\u53f7\u7801[%s]\u6587\u4ef6\u7c7b\u578b[%s]\u4ece\u672c\u5730\u6587\u4ef6\u670d\u52a1\u5668\u4e0b\u8f7d\u6587\u4ef6", invoice.getString("invoiceno"), fileType));
            Map<String, String> ofdMap = InvoiceQueryControl.putOfdMapData(ofdList, invoice);
            ofdMap.put("fileType", fileType);
            ofdMap.put("fileUrl", localFileUrl);
            return;
        }
        if (!InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype")) && !InvoiceUtils.isAllEVehicleOrAllEUsedCar((String)invoice.getString("invoicetype"))) {
            fileUrl = invoice.getString("fileurl");
            fileType = EquipmentConstant.isOfdDevice((String)invoice.getString("issuesource")) ? "OFD" : "PDF";
        } else if ("PDF".equalsIgnoreCase(fileType)) {
            fileUrl = invoice.getString("pdffileurl");
            if (StringUtils.isBlank((CharSequence)fileUrl)) {
                fileUrl = InvoiceQueryControl.queryUrl(invoice, 2);
                invoice.set("pdffileurl", (Object)fileUrl);
                SaveServiceHelper.update((DynamicObject)invoice);
            }
        } else if ("OFD".equalsIgnoreCase(fileType)) {
            fileUrl = invoice.getString("fileurl");
            if (StringUtils.isBlank((CharSequence)fileUrl)) {
                fileUrl = InvoiceQueryControl.queryUrl(invoice, 1);
                invoice.set("fileurl", (Object)fileUrl);
                invoice.set("ofdstatus", (Object)"1");
                SaveServiceHelper.update((DynamicObject)invoice);
            }
        } else {
            fileUrl = invoice.getString("xmlfileurl");
            if (StringUtils.isBlank((CharSequence)fileUrl)) {
                fileUrl = InvoiceQueryControl.queryUrl(invoice, 3);
                invoice.set("xmlfileurl", (Object)fileUrl);
                SaveServiceHelper.update((DynamicObject)invoice);
            }
            boolean isLocalSave = StringUtils.isNotEmpty((CharSequence)fileUrl) && !fileUrl.startsWith("http");
            fileType = isLocalSave ? "xml" : "zip";
        }
        Map<String, String> ofdMap = InvoiceQueryControl.putOfdMapData(ofdList, invoice);
        ofdMap.put("fileType", fileType);
        ofdMap.put("fileUrl", fileUrl);
    }

    public static String queryUrl(DynamicObject invoice, int fileType) {
        AllEleQueryUrlDTO queryUrlDto = new AllEleQueryUrlDTO();
        Date issueTime = invoice.getDate("issuetime");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formatStr = format.format(issueTime);
        queryUrlDto.setInvoiceDate(formatStr);
        queryUrlDto.setInvoiceNo(invoice.getString("invoiceno"));
        queryUrlDto.setRequest_path(AllEleInterfaceTypeEnum.DOWN_FILE.getRequestPath());
        queryUrlDto.setFileType(Integer.valueOf(fileType));
        queryUrlDto.setFpdkType(Integer.valueOf(4));
        queryUrlDto.setSerialNo(invoice.getString("orderno"));
        String specialType = invoice.getString("specialtype");
        String taxNo = invoice.getString("salertaxno");
        if ("02".equals(specialType)) {
            taxNo = invoice.getString("buyertaxno");
        }
        LOG.info("queryUrlRequest:" + JSONObject.toJSONString((Object)queryUrlDto));
        AllEleResponseDTO response = AllEleServiceHelper.doPost((String)taxNo, (AllEleRequestDTO)queryUrlDto, AllEleQueryUrlResponseDTO.class);
        LOG.info("queryUrlResponse:" + JSONObject.toJSONString((Object)response));
        if (ErrorType.SUCCESS.getCode().equals(response.getErrcode())) {
            AllEleQueryUrlResponseDTO data = (AllEleQueryUrlResponseDTO)response.getData();
            return data.getUrl();
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff1a%1$s\u672a\u67e5\u8be2\u5230%2$s\u5730\u5740", (String)"InvoiceQueryControl_9", (String)"imc-sim-service", (Object[])new Object[0]), invoice.getString("invoiceno"), InvoiceQueryControl.fileType(fileType)));
    }

    private static String fileType(int fileTypeIntValue) {
        if (2 == fileTypeIntValue) {
            return "pdf";
        }
        if (1 == fileTypeIntValue) {
            return "ofd";
        }
        return "xml";
    }

    public static Map<String, String> putOfdMapData(List<Map<String, String>> ofdList, DynamicObject invoiceDynamicObject) {
        HashMap<String, String> ofdMap = new HashMap<String, String>(8);
        ofdMap.put("fileUrl", invoiceDynamicObject.getString("fileurl"));
        ofdMap.put("issueSource", invoiceDynamicObject.getString("issuesource"));
        ofdMap.put("fileOrderNo", invoiceDynamicObject.getString("orderno"));
        ofdMap.put("fileInvoiceNo", invoiceDynamicObject.getString("invoiceno"));
        if (EquipmentConstant.isOfdDevice((String)invoiceDynamicObject.getString("issuesource")) || InvoiceUtils.isAllEInvoice((Object)invoiceDynamicObject.getString("invoicetype"))) {
            ofdMap.put("fileType", "OFD");
        } else {
            ofdMap.put("fileType", "PDF");
        }
        ofdMap.put("pdffileurl", invoiceDynamicObject.getString("pdffileurl"));
        ofdMap.put("invoicetype", invoiceDynamicObject.getString("invoicetype"));
        ofdMap.put("orgid", String.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceDynamicObject.get("orgid"))));
        ofdMap.put("buyername", invoiceDynamicObject.getString("buyername"));
        ofdMap.put("invoiceamount", invoiceDynamicObject.getBigDecimal("invoiceamount").setScale(2, 4).toPlainString());
        ofdMap.put("issuetime", DateUtils.format((Date)invoiceDynamicObject.getDate("issuetime"), (String)"yyyyMMddHHmmss"));
        ofdList.add(ofdMap);
        return ofdMap;
    }

    private static void downloadFile(IFormView view, List<Map<String, String>> ofdUrls, String invoicetype) {
        block20: {
            String fileName = DownLoadCenterHelper.generateFileName((String)String.format(invoicetype, ResManager.loadKDString((String)"\u53d1\u7968\u4e0b\u8f7d%s", (String)"InvoiceQueryControl_10", (String)"imc-sim-service", (Object[])new Object[0])), (String)".zip");
            if (ofdUrls.size() <= Integer.parseInt(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.BDM_DOWNLOAD_LIMIT_FILE_NUM))) {
                File zipFile = DownLoadCenterHelper.createZipFile((String)fileName, ofdUrls);
                if (zipFile == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25", (String)"InvoiceQueryControl_11", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                try (FileInputStream in = new FileInputStream(zipFile);){
                    String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
                    view.openUrl(url);
                    break block20;
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25", (String)"InvoiceQueryControl_11", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                finally {
                    if (zipFile.exists() && !zipFile.delete()) {
                        LOG.error("\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25");
                    }
                }
            }
            DynamicObject obj = DownLoadCenterHelper.saveDownLoadCenter((IFormView)view, (String)fileName, (int)ofdUrls.size(), (Date)new Date());
            DownLoadCenterHelper.uploadFileByUrls((DynamicObject)obj, ofdUrls);
            DownLoadCenterHelper.showConfirmView((IFormView)view);
        }
    }

    public static void handleHyperLinkClick(AbstractFormPlugin formPlugin) {
        BillList billList = (BillList)formPlugin.getView().getControl("billlistap");
        ListSelectedRow row = billList.getCurrentSelectedRowInfo();
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("id", row.getPrimaryKeyValue());
        ViewUtil.openDialog((AbstractFormPlugin)formPlugin, (Map)map, (String)"sim_invoice_show", null);
    }

    public static void showInvoiceView(AbstractFormPlugin formPlugin, DynamicObject invoiceDynamicObject) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        map.put("id", invoiceDynamicObject.getPkValue());
        ViewUtil.openDialog((AbstractFormPlugin)formPlugin, (Map)map, (String)"sim_invoice_show", null);
    }

    public static void invPrint(AbstractListPlugin plugin, String printType) {
        List noCheckCodeList;
        List noSKMList;
        BillList billList = (BillList)plugin.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6253\u5370\u7684\u53d1\u7968", (String)"InvoiceQueryControl_12", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)billList.getEntityType());
        CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)plugin, (ImcPermItemEnum)ImcPermItemEnum.INVOICE_PRINT, (DynamicObject[])objects);
        ArrayList<BigDecimal> noList = new ArrayList<BigDecimal>(objects.length);
        HashSet<String> elePaperSet = new HashSet<String>(objects.length);
        boolean isLackSkm = false;
        boolean isLackCheckCode = false;
        for (DynamicObject dObject : objects) {
            noList.add(new BigDecimal(dObject.getString("invoiceno")));
            String invoiceType = dObject.getString("invoicetype");
            if ("8".equals(dObject.getString("buyertype"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u8fc7excel\u5bfc\u5165\u7684\u53d1\u7968\u4fe1\u606f\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d1\u7968\u6253\u5370\u64cd\u4f5c", (String)"InvoiceQueryControl_13", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if ("9".equals(dObject.getString("buyertype"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542b\u8fdb\u9879\u4e0b\u8f7d\u6570\u636e\u4e0d\u5141\u8bb8\u53d1\u7968\u6253\u5370", (String)"InvoiceQueryControl_14", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if ("10".equals(dObject.getString("buyertype"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542bAWS\u540c\u6b65\u6570\u636e\u4e0d\u5141\u8bb8\u53d1\u7968\u6253\u5370", (String)"InvoiceQueryControl_15", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if (!InvoiceUtils.isPaperInvoice((String)invoiceType)) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u7eb8\u8d28\u53d1\u7968\u8fdb\u884c\u6253\u5370\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceQueryControl_21", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if (AllEleAuthHelper.isElePaper((Object)dObject.getString("iselepaper"))) {
                if ("1".equals(printType)) {
                    plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6570\u7535\u7eb8\u8d28\u5957\u6253\u53d1\u7968\uff0c\u8bf7\u7535\u5b50\u7eb8\u7968\u6253\u5370\u3002", (String)"InvoiceQueryControl_16", (String)"imc-sim-service", (Object[])new Object[0]));
                    return;
                }
                elePaperSet.add("1");
                continue;
            }
            if ("1".equals(printType)) {
                if (StringUtils.isBlank((CharSequence)dObject.getString("checkcode")) && InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode().equals(invoiceType)) {
                    isLackCheckCode = true;
                    break;
                }
                if (StringUtils.isBlank((CharSequence)dObject.getString("skm"))) {
                    isLackSkm = true;
                    break;
                }
            }
            elePaperSet.add("0");
        }
        if (isLackSkm && (noSKMList = Arrays.stream(objects).filter(o -> StringUtils.isBlank((CharSequence)o.getString("skm"))).map(i -> i.getString("invoiceno")).collect(Collectors.toList())).size() > 0) {
            plugin.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u53d1\u7968\u7f3a\u5931\u5bc6\u7801\u533a\uff0c\u4e0d\u5141\u8bb8\u6253\u5370", (String)"InvoiceQueryControl_17", (String)"imc-sim-service", (Object[])new Object[0]), String.join((CharSequence)"\u3001", noSKMList), MessageBoxOptions.OK, ConfirmTypes.Default, null);
            return;
        }
        if (isLackCheckCode && (noCheckCodeList = Arrays.stream(objects).filter(o -> StringUtils.isBlank((CharSequence)o.getString("checkcode")) && InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode().equals(o.getString("invoicetype"))).map(i -> i.getString("invoiceno")).collect(Collectors.toList())).size() > 0) {
            plugin.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u666e\u901a\u7eb8\u8d28\u53d1\u7968\u7f3a\u5931\u6821\u9a8c\u7801\uff0c\u4e0d\u5141\u8bb8\u6253\u5370", (String)"InvoiceQueryControl_18", (String)"imc-sim-service", (Object[])new Object[0]), String.join((CharSequence)"\u3001", noCheckCodeList), MessageBoxOptions.OK, ConfirmTypes.Default, null);
            return;
        }
        Collections.sort(noList);
        if (((BigDecimal)noList.get(0)).add(new BigDecimal(objects.length - 1)).compareTo((BigDecimal)noList.get(objects.length - 1)) != 0) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u53d1\u7968\u53f7\u7801\u4e0d\u662f\u8fde\u7eed\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceQueryControl_19", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        if (elePaperSet.size() > 1) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u7535\u7eb8\u7968\u4e0d\u80fd\u4e0e\u975e\u6570\u7535\u7eb8\u7968\u4e00\u8d77\u6253\u5370\u3002", (String)"InvoiceQueryControl_56", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("keys", selectedRows.getPrimaryKeyValues());
        customParams.put("type", PrintTypeEnum.INVOICE_PRINT.getType());
        customParams.put("elePaper", elePaperSet.iterator().next());
        customParams.put("pageId", "1".equals(printType) ? "sim_labelape_print_select" : "sim_labelape_print");
        ViewUtil.openDialog((AbstractFormPlugin)plugin, (String)("1".equals(printType) ? ResManager.loadKDString((String)"\u5957\u6253\u53d1\u7968", (String)"InvoiceQueryControl_22", (String)"imc-sim-service", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7eb8\u7968\u6253\u5370", (String)"InvoiceQueryControl_23", (String)"imc-sim-service", (Object[])new Object[0])), customParams, (String)((String)customParams.get("pageId")), (String)((String)customParams.get("pageId")));
    }

    public static void listPrint(AbstractListPlugin plugin, String printType) {
        BillList billList = (BillList)plugin.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6253\u5370\u6e05\u5355\u7684\u53d1\u7968", (String)"InvoiceQueryControl_24", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)billList.getEntityType());
        CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)plugin, (ImcPermItemEnum)ImcPermItemEnum.PRINT_LIST, (DynamicObject[])objects);
        for (DynamicObject dObject : objects) {
            if ("8".equals(dObject.getString("buyertype"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u8fc7excel\u5bfc\u5165\u7684\u53d1\u7968\u4fe1\u606f\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d1\u7968\u6e05\u5355\u6253\u5370\u64cd\u4f5c", (String)"InvoiceQueryControl_25", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if ("0".equals(dObject.getString("inventorymark"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u6570\u636e\u4e2d\u5b58\u5728\u975e\u6e05\u5355\u53d1\u7968\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceQueryControl_26", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if ("8".equals(dObject.getString("buyertype"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u8fc7excel\u5bfc\u5165\u7684\u53d1\u7968\u4fe1\u606f\u4e0d\u5141\u8bb8\u8fdb\u884c\u53d1\u7968\u6e05\u5355\u6253\u5370\u64cd\u4f5c", (String)"InvoiceQueryControl_25", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if (InvoiceUtils.isEtcInvoice((String)dObject.getString("invoicetype"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u7eb8\u8d28\u53d1\u7968\u8fdb\u884c\u6253\u5370\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceQueryControl_21", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if ("9".equals(dObject.getString("buyertype"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542b\u8fdb\u9879\u4e0b\u8f7d\u6570\u636e\u4e0d\u5141\u8bb8\u6e05\u5355\u6253\u5370", (String)"InvoiceQueryControl_27", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if ("10".equals(dObject.getString("buyertype"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542bAWS\u540c\u6b65\u6570\u636e\u4e0d\u5141\u8bb8\u6e05\u5355\u6253\u5370", (String)"InvoiceQueryControl_28", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if (!AllEleAuthHelper.isElePaper((Object)dObject.getString("iselepaper"))) continue;
            plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6570\u7535\u7eb8\u8d28\u6e05\u5355\u6253\u5370\uff0c\u8bf7\u5728\u7535\u5b50\u7a0e\u5c40\u8fdb\u884c\u6253\u5370\u3002", (String)"InvoiceQueryControl_29", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put("keys", selectedRows.getPrimaryKeyValues());
        customParams.put("type", PrintTypeEnum.QD_PRINT.getType());
        customParams.put("pageId", "1".equals(printType) ? "sim_labelape_print_select" : "sim_labelape_print");
        ViewUtil.openDialog((AbstractFormPlugin)plugin, (String)("1".equals(printType) ? ResManager.loadKDString((String)"\u5957\u6253\u53d1\u7968", (String)"InvoiceQueryControl_22", (String)"imc-sim-service", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7eb8\u7968\u6253\u5370", (String)"InvoiceQueryControl_23", (String)"imc-sim-service", (Object[])new Object[0])), customParams, (String)((String)customParams.get("pageId")), (String)((String)customParams.get("pageId")));
    }

    public static void listAbolish(AbstractListPlugin plugin) {
        HashMap<String, Object[]> customParams = new HashMap<String, Object[]>(4);
        BillList billList = (BillList)plugin.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
        CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)plugin, (ImcPermItemEnum)ImcPermItemEnum.INV_ABOLISH, (DynamicObject[])objects);
        TaxUtils.getSaleInfoByOrg((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)objects[0].get("orgid")));
        String strDate = DateUtils.format((Date)new Date(), (String)"yyyyMM");
        List<String> statusList = Arrays.asList(BillStatusEnum.NO_APPROVAL_REQUIRED.getCode(), BillStatusEnum.AUDIT_SUCCESS.getCode());
        Boolean isFirstElePaper = null;
        for (DynamicObject dObject : objects) {
            String jqbh;
            if ("8".equals(dObject.getString("buyertype"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"Excel\u5bfc\u5165\u7684\u53d1\u7968\u4e0d\u5141\u8bb8\u88ab\u4f5c\u5e9f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceQueryControl_30", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if (null == isFirstElePaper) {
                isFirstElePaper = AllEleAuthHelper.isElePaper((Object)dObject.getString("iselepaper"));
            }
            boolean isCurrentElePaper = AllEleAuthHelper.isElePaper((Object)dObject.getString("iselepaper"));
            if (isFirstElePaper != isCurrentElePaper) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u53d1\u7968\u4e0d\u80fd\u540c\u65f6\u5305\u542b\u6570\u7535\u7eb8\u7968\u548c\u975e\u6570\u7535\u7eb8\u7968\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceQueryControl_31", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            Date issuetime = dObject.getDate("issuetime");
            if (!(strDate.equals(DateUtils.format((Date)issuetime, (String)"yyyyMM")) || InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(dObject.getString("invoicetype")) && "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.VOLUME_INVOICE_CREATE_PDF)))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5f53\u6708\u7684\u53d1\u7968\u624d\u5141\u8bb8\u4f5c\u5e9f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceQueryControl_32", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if (!INVOICE_STATUS_CAN_INVALID.contains(dObject.getString("invoicestatus"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u53d1\u7968\u72b6\u6001\u4e3a'\u6b63\u5e38'\u6216\u8005'\u4f5c\u5e9f\u4e2d'\u7684\u53d1\u7968\u624d\u5141\u8bb8\u4f5c\u5e9f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceQueryControl_33", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if (InvoiceUtils.isEtcInvoice((String)dObject.getString("invoicetype"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u7eb8\u8d28\u53d1\u7968\u8fdb\u884c\u4f5c\u5e9f\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceQueryControl_34", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if (!statusList.contains(dObject.getString("billstatus"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u53ef\u5bf9\u201c\u65e0\u9700\u5ba1\u6279\u201d\u3001\u201c\u5df2\u5ba1\u6838\u201d\u72b6\u6001\u7684\u53d1\u7968\u8fdb\u884c\u4f5c\u5e9f\u64cd\u4f5c", (String)"InvoiceQueryControl_35", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if ("9".equals(dObject.getString("buyertype"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542b\u8fdb\u9879\u4e0b\u8f7d\u6570\u636e\u4e0d\u5141\u8bb8\u4f5c\u5e9f", (String)"InvoiceQueryControl_36", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            if ("10".equals(dObject.getString("buyertype"))) {
                plugin.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542bAWS\u540c\u6b65\u6570\u636e\u4e0d\u5141\u8bb8\u4f5c\u5e9f", (String)"InvoiceQueryControl_37", (String)"imc-sim-service", (Object[])new Object[0]));
                return;
            }
            String sellerTaxNo = dObject.getString("salertaxno");
            if ("02".equals(dObject.getString("specialtype"))) {
                sellerTaxNo = dObject.getString("buyertaxno");
            }
            if (EquipmentHelper.isDisableJQBH((Object)sellerTaxNo, (Object)(jqbh = dObject.getString("jqbh")))) {
                plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u5305\u542b\u5df2\u7ecf\u7981\u7528\u7684\u8bbe\u5907\uff1a%s\uff0c\u4e0d\u5141\u8bb8\u4f5c\u5e9f", (String)"InvoiceQueryControl_38", (String)"imc-sim-service", (Object[])new Object[0]), jqbh));
                return;
            }
            String errmsg = FiArFinArBillHelper.isCanRedOrCancelNew((DynamicObject)dObject, (String)"");
            if (StringUtils.isNotBlank((CharSequence)errmsg)) {
                plugin.getView().showTipNotification(errmsg);
                return;
            }
            if (EasBusinessHelper.billCanCancel((DynamicObject)dObject)) continue;
            plugin.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s\uff0c\u53d1\u7968\u53f7\u7801\uff1a%2$s\u7684\u539f\u84dd\u7968\u5173\u8054\u7684\u5355\u636e\u4fe1\u606f\u5df2\u7ecf\u5173\u95ed\uff0c\u65e0\u6cd5\u4f5c\u5e9f\u3002", (String)"InvoiceQueryControl_40", (String)"imc-sim-service", (Object[])new Object[0]), dObject.getString("invoicecode"), dObject.getString("invoiceno")));
            return;
        }
        JSONObject param = BotpHelper.cancelOrRedArInvoice((DynamicObject[])objects, (CancelRedEum)CancelRedEum.CANCEL_INVOICE);
        Integer billPksSize = param.getInteger("billPksSize");
        if (billPksSize > 0) {
            if (isFirstElePaper.booleanValue()) {
                plugin.getPageCache().put("iselepaper", "iselepaper");
            }
            plugin.getPageCache().put("cancelOrRedArInvoiceBillPks", param.toJSONString());
            ViewUtil.openNormalConfirm((AbstractFormPlugin)plugin, (String)ResManager.loadKDString((String)"\u5f00\u7968\u7533\u8bf7\u5355\u5df2\u786e\u8ba4\u5e94\u6536\uff0c\u4f5c\u5e9f\u53d1\u7968\u5c06\u51b2\u9500\u5f00\u7968\u7533\u8bf7\u5355\u6240\u5173\u8054\u7684\u8d22\u52a1\u5e94\u6536\u5355\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InvoiceQueryControl_41", (String)"imc-sim-service", (Object[])new Object[0]), (String)"cancelOrRedArInvoice");
        } else {
            customParams.put("keys", selectedRows.getPrimaryKeyValues());
            if (isFirstElePaper.booleanValue()) {
                ViewUtil.openDialog((AbstractFormPlugin)plugin, customParams, (String)"sim_inv_prev_abolish_alle", (String)"msg_inv_abolish");
            } else {
                ViewUtil.openDialog((AbstractFormPlugin)plugin, customParams, (String)"sim_inv_prev_abolish", (String)"msg_inv_abolish");
            }
        }
    }

    public static Set<String> checkDownLoadData(DynamicObject[] objects, String desc, boolean isUsedCar) {
        boolean isElecPrint = ResManager.loadKDString((String)"\u7535\u7968\u6253\u5370", (String)"InvoiceQueryControl_42", (String)"imc-sim-service", (Object[])new Object[0]).equals(desc);
        HashSet typeSet = Sets.newHashSetWithExpectedSize((int)4);
        for (DynamicObject obj : objects) {
            String buyerType;
            String invType = obj.getString("invoicetype");
            if (InvoiceUtils.isEtcInvoice((String)invType)) {
                typeSet.add("0");
            } else {
                typeSet.add("1");
            }
            String invoiceCode = obj.getString("invoicecode");
            String invoiceNo = obj.getString("invoiceno");
            if (StringUtils.isBlank((CharSequence)obj.getString("orderno"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s\uff0c\u53d1\u7968\u53f7\u7801\uff1a%2$s\u7684\u53d1\u7968\u6ca1\u6709\u6d41\u6c34\u53f7\u4e0d\u652f\u6301%3$s", (String)"InvoiceQueryControl_43", (String)"imc-sim-service", (Object[])new Object[0]), invoiceCode, invoiceNo, desc));
            }
            if (isUsedCar) {
                if (!InvoiceUtils.isAllEVehicleOrAllEUsedCar((String)invType)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u673a\u52a8\u8f66/\u4e8c\u624b\u8f66\u53d1\u7968\u6682\u65f6\u4ec5\u652f\u6301\u7535\u7968\u4e0b\u8f7d", (String)"InvoiceQueryControl_58", (String)"imc-sim-service", (Object[])new Object[0]));
                }
                buyerType = obj.getString("billsource");
                if ("3".equals(buyerType)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s\uff0c\u53d1\u7968\u53f7\u7801\uff1a%2$s\u4e3aexcel\u5bfc\u5165\u7684\u53d1\u7968\uff0c\u4e0d\u652f\u6301%3$s", (String)"InvoiceQueryControl_44", (String)"imc-sim-service", (Object[])new Object[0]), invoiceCode, invoiceNo, desc));
                }
                if ("1".equals(buyerType)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s\uff0c\u53d1\u7968\u53f7\u7801\uff1a%2$s\u4e3a\u8fdb\u9879\u4e0b\u8f7d\u7684\u53d1\u7968\uff0c\u4e0d\u652f\u6301%3$s", (String)"InvoiceQueryControl_45", (String)"imc-sim-service", (Object[])new Object[0]), invoiceCode, invoiceNo, desc));
                }
            } else {
                buyerType = obj.getString("buyertype");
                if ("8".equals(buyerType)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s\uff0c\u53d1\u7968\u53f7\u7801\uff1a%2$s\u4e3aexcel\u5bfc\u5165\u7684\u53d1\u7968\uff0c\u4e0d\u652f\u6301%3$s", (String)"InvoiceQueryControl_44", (String)"imc-sim-service", (Object[])new Object[0]), invoiceCode, invoiceNo, desc));
                }
                if ("9".equals(buyerType)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s\uff0c\u53d1\u7968\u53f7\u7801\uff1a%2$s\u4e3a\u8fdb\u9879\u4e0b\u8f7d\u7684\u53d1\u7968\uff0c\u4e0d\u652f\u6301%3$s", (String)"InvoiceQueryControl_45", (String)"imc-sim-service", (Object[])new Object[0]), invoiceCode, invoiceNo, desc));
                }
                if ("10".equals(buyerType)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s\uff0c\u53d1\u7968\u53f7\u7801\uff1a%2$s\u4e3aAWS\u540c\u6b65\u7684\u53d1\u7968\uff0c\u4e0d\u652f\u6301%3$s", (String)"InvoiceQueryControl_46", (String)"imc-sim-service", (Object[])new Object[0]), invoiceCode, invoiceNo, desc));
                }
            }
            if (!isElecPrint || InvoiceUtils.isEtcInvoice((String)obj.getString("invoicetype"))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\uff1a%1$s\uff0c\u53d1\u7968\u53f7\u7801\uff1a%2$s\u975e\u7535\u7968\u4e0d\u80fd\u7535\u7968\u6253\u5370", (String)"InvoiceQueryControl_47", (String)"imc-sim-service", (Object[])new Object[0]), invoiceCode, invoiceNo));
        }
        if (!isElecPrint && typeSet.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u62e9\u6570\u636e\u4e2d\u5305\u542b\u4e86\u7eb8\u8d28\u53d1\u7968\u548c\u7535\u5b50\u53d1\u7968\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"InvoiceQueryControl_48", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        return typeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void elecPrint(AbstractListPlugin plugin) {
        byte[] bytes;
        BillList billList = (BillList)plugin.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
        CheckCurrentOrgHelper.checkPermissonAndIsSameOrg((AbstractFormPlugin)plugin, (ImcPermItemEnum)ImcPermItemEnum.INVOICE_PRINT, (DynamicObject[])objects);
        try {
            InvoiceQueryControl.checkDownLoadData(objects, ResManager.loadKDString((String)"\u7535\u7968\u6253\u5370", (String)"InvoiceQueryControl_42", (String)"imc-sim-service", (Object[])new Object[0]), false);
        }
        catch (KDBizException e) {
            plugin.getView().showTipNotification(e.getMessage());
            return;
        }
        String noPdfNo = Stream.of(objects).filter(dObject -> "0".equals(dObject.getString("ofdstatus")) && !DeviceHelper.isOfdDevice((String)dObject.getString("issuesource"))).map(dObject -> dObject.getString("invoiceno")).collect(Collectors.joining("\u3001"));
        if (StringUtils.isNotBlank((CharSequence)noPdfNo)) {
            plugin.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u53d1\u7968\u672a\u751f\u6210\u7248\u5f0f\u6587\u4ef6\uff0c\u65e0\u6cd5\u8fdb\u884c\u7535\u7968\u6253\u5370\uff0c\u70b9\u51fb\u53d1\u7968\u53f7\u7801\u53ef\u4ee5\u751f\u6210\u5bf9\u5e94\u7248\u5f0f\u6587\u4ef6", (String)"InvoiceQueryControl_49", (String)"imc-sim-service", (Object[])new Object[0]), noPdfNo, MessageBoxOptions.OK, ConfirmTypes.Default, null);
            return;
        }
        List sortInvoice = Stream.of(objects).sorted(Comparator.comparing(object -> object.getString("invoicecode") + "_" + object.getString("invoiceno"))).collect(Collectors.toList());
        ArrayList<Map<String, String>> ofdList = new ArrayList<Map<String, String>>(objects.length);
        for (DynamicObject invoiceDynamicObject : sortInvoice) {
            String issueSource = invoiceDynamicObject.getString("issuesource");
            if (!"1".equals(invoiceDynamicObject.getString("ofdstatus")) && !DeviceHelper.isOfdDevice((String)issueSource)) {
                plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%s\u8fd8\u672a\u751f\u6210PDF\uff0c\u8bf7\u7a0d\u5019\u4e0b\u8f7d", (String)"InvoiceQueryControl_50", (String)"imc-sim-service", (Object[])new Object[0]), invoiceDynamicObject.getString("invoiceno")));
                return;
            }
            InvoiceQueryControl.putOfdMapData(ofdList, invoiceDynamicObject);
        }
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        ArrayList<byte[]> list = new ArrayList<byte[]>(ofdList.size());
        for (Map map : ofdList) {
            if (InvoiceUtils.isAllEInvoice(map.get("invoicetype"))) {
                String pdfFileUrl = (String)map.get("pdffileurl");
                if (StringUtils.isBlank((CharSequence)pdfFileUrl)) {
                    plugin.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%s\u8fd8\u672a\u751f\u6210PDF\uff0c\u8bf7\u7a0d\u5019\u4e0b\u8f7d", (String)"InvoiceQueryControl_50", (String)"imc-sim-service", (Object[])new Object[0]), map.get("fileInvoiceNo")));
                    return;
                }
                InputStream inputStream = null;
                try {
                    inputStream = pdfFileUrl.startsWith("http") ? DownLoadCenterHelper.getInputStream((String)pdfFileUrl) : fileService.getInputStream(pdfFileUrl);
                    list.add(AllEleInvoiceFileHelper.inputStreamToByteArray((InputStream)inputStream));
                    continue;
                }
                catch (Exception e) {
                    plugin.getView().showErrorNotification(e.getMessage());
                    return;
                }
                finally {
                    try {
                        if (inputStream == null) continue;
                        inputStream.close();
                        continue;
                    }
                    catch (Exception exception) {}
                }
            }
            JSONArray jsonArray = DownLoadCenterHelper.getOrderNoJson((String)((String)map.get("fileOrderNo")));
            JSONObject json = (JSONObject)jsonArray.get(0);
            json.put("SimDownloadOnlyPdf", (Object)"SimDownloadOnlyPdf");
            MsgResponse msgResponse = RequestUtils.doRequest((String)UUID.next(), (String)"SimDownloadPdf", (Object)jsonArray);
            if (!ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) continue;
            String respData = msgResponse.getRespData();
            if ("3".equals(respData)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25\uff1a \u7eb8\u8d28\u53d1\u7968\u4e0d\u5b58\u5728PDF\u6587\u4ef6\uff0c\u4f9d\u636e\u7a0e\u5c40\u89c4\u5b9a\uff0c\u53ea\u6709\u7535\u5b50\u53d1\u7968\u624d\u6709PDF\u677f\u5f0f\u6587\u4ef6", (String)"InvoiceQueryControl_51", (String)"imc-sim-service", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)respData)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%s\u83b7\u53d6PDF\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u751f\u6210pdf", (String)"InvoiceQueryControl_52", (String)"imc-sim-service", (Object[])new Object[0]), map.get("fileInvoiceNo")));
            }
            byte[] decodeOfdBytes = Base64.getDecoder().decode(respData);
            list.add(decodeOfdBytes);
        }
        try {
            bytes = PrintServiceHelper.mergeMultiPdf(list);
        }
        catch (Exception exception) {
            plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u5408\u5e76pdf\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5pdf\u662f\u5426\u6b63\u5e38", (String)"InvoiceQueryControl_53", (String)"imc-sim-service", (Object[])new Object[0]));
            LOG.error("\u5408\u5e76pdf\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5pdf\u662f\u5426\u6b63\u5e38", (Throwable)exception);
            return;
        }
        String string = RequestContext.get().getUserName() + "_preview.pdf";
        String uploadUrl = FileUploadUtils.upload((String)(FileUploadUtils.getInvoiceDir((String)"elecInvoicePrint/") + string), (String)string, (InputStream)new ByteArrayInputStream(bytes));
        if (StringUtils.isBlank((CharSequence)uploadUrl)) {
            plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210\u6253\u5370\u6570\u636e\u5931\u8d25", (String)"InvoiceQueryControl_54", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        plugin.getView().openUrl(InvoiceQueryControl.getFileUrl(uploadUrl));
    }

    public static void callback(AbstractListPlugin plugin) {
        BillList billList = (BillList)plugin.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])selectedRows.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
        InvoiceQueryControl.loopCallBack(objects);
        plugin.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u89e6\u53d1\u56de\u8c03\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u56de\u8c03\u7ed3\u679c\u3002\u53d1\u7968\u4e91\u300b\u7cfb\u7edf\u7ba1\u7406\u300b\u53d1\u7968\u56de\u63a8\u65e5\u5fd7", (String)"InvoiceQueryControl_55", (String)"imc-sim-service", (Object[])new Object[0]), Integer.valueOf(4000));
    }

    public static void loopCallBack(DynamicObject[] objects) {
        for (DynamicObject invoiceDynamicObject : objects) {
            String businessType = OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode();
            if ("BILL_CENTER".equals(invoiceDynamicObject.getString("systemsource"))) {
                LOG.info(String.format("\u5f00\u59cb\u56de\u8c03\u8d26\u5355\u4e2d\u5fc3\uff0c\u53d1\u7968\u6d41\u6c34\u53f7\u662f%s", invoiceDynamicObject.getString("orderno")));
                DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"BillCenterCallBackServiceImpl", (String)"callback", (Object[])new Object[]{invoiceDynamicObject.getPkValue()});
                continue;
            }
            String systemSource = invoiceDynamicObject.getString("systemsource");
            if (StringUtils.isBlank((CharSequence)systemSource) && "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.INVOICE_SYSTEMSOURCE_FROM_BUYER_RED_INFO))) {
                systemSource = RelationHelper.getSystemSourceFromBuyerDownloadRedInfo((DynamicObject)invoiceDynamicObject);
            }
            CallbackHelperUtil.sendCallbackMessage((DynamicObject)invoiceDynamicObject, (String)systemSource, (String)businessType);
        }
        ThreadPools.executeOnceIncludeRequestContext((String)"invoicequery_invoice_write_back", () -> {
            for (DynamicObject invoiceDynamicObject : objects) {
                IssuedInvoiceWriteBackHelper.writeBackIssueAmount2OriginBill((DynamicObject)invoiceDynamicObject);
            }
        });
    }

    public static String getFileUrl(String url) {
        String urlStr = UrlService.getAttachmentPreviewUrl((String)url) + "&kd_cs_ticket=" + SessionManager.getCSRFTokenValue((String)RequestContext.get().getGlobalSessionId());
        String previeInvoiceUrl = ImcConfigUtil.getValue((String)"preview_invoice", (String)"url");
        if (StringUtils.isNotBlank((CharSequence)previeInvoiceUrl)) {
            urlStr = previeInvoiceUrl + "/attachment/preview.do?path=/" + url + "&kd_cs_ticket=" + SessionManager.getCSRFTokenValue((String)RequestContext.get().getGlobalSessionId());
        }
        try {
            String previewtype;
            Method method = SystemParamServiceHelper.class.getMethod("loadPublicParametersFromCache", String.class);
            Map params = (Map)method.invoke(SystemParamServiceHelper.class.newInstance(), "bos_fileserverconfig");
            if (params != null && StringUtils.isNotBlank((CharSequence)(previewtype = (String)params.get("previewbuttongroup"))) && !"0".equals(previewtype)) {
                String responseStr = HttpUtil.doGet((String)(urlStr + "&access_token=" + RequestContext.get().getGlobalSessionId()), null, null, null);
                JSONObject urlJson = JSONObject.parseObject((String)responseStr);
                urlStr = urlJson.getString("url");
            }
        }
        catch (Throwable e) {
            LOG.error("\u83b7\u53d6\u9884\u89c8\u5730\u5740\u5931\u8d25" + e.getMessage(), e);
        }
        return urlStr;
    }
}

