/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRedApplyQueryAsyncRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleRedApplyQueryAsyncRequestItemDTO;
import kd.imc.bdm.common.dto.allele.AllEleRedApplyQueryAsyncResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleRedApplyQueryAsyncResponseItemDTO;
import kd.imc.bdm.common.dto.allele.AllEleRedApplyQueryRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleRedApplyQueryResponseDTO;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.NumberGenerateUtil;
import kd.imc.bdm.file.util.ErrorType;
import kd.imc.bdm.lqpt.model.request.collect.InvoiceStatusQueryRequest;
import kd.imc.bdm.lqpt.service.collect.InvoiceCollectionService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DataSyncHelper {
    private static final Log log = LogFactory.getLog(DataSyncHelper.class);
    private static final String BATCH_NO_PRE = "PST";

    public static boolean setAccount(AbstractFormPlugin formPlugin, String taxNo, String field, boolean isIssue) {
        boolean accountIsNotEmpty = false;
        DynamicObject accountDO = AllEleAuthHelper.getAccountByTaxNo((String)taxNo);
        if (accountDO != null) {
            Map accountMap;
            Pair accountPair = AllEleAuthHelper.getBusinessAccountList((DynamicObject)accountDO, (boolean)true, (boolean)isIssue);
            String defaultAccount = (String)accountPair.getLeft();
            if (StringUtils.isNotEmpty((CharSequence)defaultAccount)) {
                formPlugin.getView().getModel().setValue(field, (Object)defaultAccount);
            }
            if ((accountMap = (Map)accountPair.getRight()) != null && !accountMap.isEmpty()) {
                ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(8);
                for (Map.Entry accountEntry : accountMap.entrySet()) {
                    String accountStr = (String)accountEntry.getValue();
                    if (!StringUtils.isNotEmpty((CharSequence)accountStr)) continue;
                    ComboItem comboItem = new ComboItem();
                    comboItem.setCaption(new LocaleString(accountStr));
                    comboItem.setValue(accountStr);
                    comboItems.add(comboItem);
                }
                ComboEdit comboEdit = (ComboEdit)formPlugin.getControl(field);
                comboEdit.setComboItems(comboItems);
                accountIsNotEmpty = true;
            }
        }
        return accountIsNotEmpty;
    }

    public static boolean setAccount(AbstractFormPlugin formPlugin, String taxNo, String field) {
        return DataSyncHelper.setAccount(formPlugin, taxNo, field, true);
    }

    public static JSONObject queryRedInfoPreRpa(String applicant, String sellerTaxNo, String buyerTaxNo, String account, String invoiceCode, String invoiceNo, String invoiceType, String invoiceDate, Object invoiceId) {
        int success = 0;
        String failMsg = null;
        try {
            String taxNo = "1".equalsIgnoreCase(applicant) ? sellerTaxNo : buyerTaxNo;
            AllEleRedApplyQueryRequestDTO dto = new AllEleRedApplyQueryRequestDTO();
            dto.setRequest_path(AllEleInterfaceTypeEnum.QUERY_INVOICE_RED_PRE.getRequestPath());
            dto.setAccount(account);
            dto.setSalerTaxNo(sellerTaxNo);
            dto.setBuyerTaxNo(buyerTaxNo);
            dto.setKeyLabel(applicant);
            dto.setOriginalInvoiceCode(invoiceCode);
            dto.setOriginalInvoiceNo(invoiceNo);
            dto.setOriginalInvoiceType(InvoiceType.getBaseCodeByInvoiceTypeCode((String)invoiceType));
            dto.setOriginalInvoiceDate(invoiceDate);
            dto.setHistorySync(true);
            log.info("queryRedInfoPreRpa start:{}", (Object)JSON.toJSONString((Object)dto));
            AllEleResponseDTO response = AllEleServiceHelper.doPost((String)taxNo, (AllEleRequestDTO)dto, AllEleRedApplyQueryResponseDTO.class);
            if (response.getSuccess().booleanValue()) {
                DynamicObject invoiceData;
                AllEleRedApplyQueryResponseDTO responseData = (AllEleRedApplyQueryResponseDTO)response.getData();
                if (responseData != null && (invoiceData = BusinessDataServiceHelper.loadSingle((Object)invoiceId, (String)"sim_vatinvoice")) != null) {
                    invoiceData.set("valueaddedtaxuses", (Object)responseData.getValueAddedTaxUses());
                    invoiceData.set("creditingstatus", (Object)responseData.getCreditingStatus());
                    invoiceData.set("excisetaxpurposes", (Object)responseData.getExciseTaxPurposes());
                    ImcSaveServiceHelper.update((DynamicObject)invoiceData);
                    success = 1;
                    failMsg = response.getDescription();
                }
                if (success == 0) {
                    failMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"DataSyncHelper_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), ErrorType.USER_ERROR_A0160.getDescription());
                }
            } else {
                failMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"DataSyncHelper_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), response.getDescription());
            }
        }
        catch (Exception e) {
            failMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"DataSyncHelper_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage());
        }
        JSONObject returnJson = new JSONObject();
        returnJson.put("success", (Object)success);
        returnJson.put("failMsg", (Object)failMsg);
        log.info("queryRedInfoPreRpa end:{}", (Object)returnJson.toJSONString());
        return returnJson;
    }

    public static void asyncQueryInvoicePurposeStatusReqToRpa(String optionAccountList, String taxNo, QFilter awaitQFilter) {
        DynamicObject[] dataArr;
        while ((dataArr = BusinessDataServiceHelper.load((String)"sim_his_inv_data_imp_st", (String)"id", (QFilter[])awaitQFilter.toArray(), (String)"id", (int)200)) != null && dataArr.length != 0) {
            String reqBatchNo = NumberGenerateUtil.generateByPrefixWithRandom((String)BATCH_NO_PRE, (int)3);
            ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(dataArr.length);
            ArrayList<AllEleRedApplyQueryAsyncRequestItemDTO> list = new ArrayList<AllEleRedApplyQueryAsyncRequestItemDTO>(dataArr.length);
            for (DynamicObject dataPri : dataArr) {
                DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)dataPri.getPkValue(), (String)"sim_his_inv_data_imp_st");
                AllEleRedApplyQueryAsyncRequestItemDTO reqItem = new AllEleRedApplyQueryAsyncRequestItemDTO();
                String invoiceType = data.getString("invoicetype");
                reqItem.setInvoiceCode(data.getString("invoicecode"));
                reqItem.setInvoiceNo(data.getString("invoiceno"));
                reqItem.setEtaxInvoiceNo(data.getString("alletaxinvoiceno"));
                reqItem.setInvoiceDate(data.getString("invoicedate"));
                reqItem.setSalerTaxNo(data.getString("salertaxno"));
                reqItem.setBuyerTaxNo(data.getString("buyertaxno"));
                reqItem.setKeyLabel(data.getString("keylabel"));
                reqItem.setInvoiceType(InvoiceType.getBaseCodeByInvoiceTypeCode((String)invoiceType));
                reqItem.setGovInvoiceType(InvoiceType.getRimLqptCodeByTypeCode((String)invoiceType));
                String specialTypeStr = data.getString("specialtype");
                if (StringUtils.isNotEmpty((CharSequence)specialTypeStr)) {
                    reqItem.setBusinessType(specialTypeStr);
                }
                list.add(reqItem);
                dataList.add(data);
            }
            if (list.isEmpty()) continue;
            AllEleRedApplyQueryAsyncRequestDTO dto = new AllEleRedApplyQueryAsyncRequestDTO();
            dto.setOptionAccountList(optionAccountList);
            dto.setBatchNo(reqBatchNo);
            dto.setList(list);
            DataSyncHelper.asyncQueryInvoicePurposeStatusReqToRpa(dto, taxNo, dataList);
        }
    }

    private static void asyncQueryInvoicePurposeStatusReqToRpa(AllEleRedApplyQueryAsyncRequestDTO dto, String taxNo, List<DynamicObject> dataList) {
        String failMsg = "";
        String batchNo = null;
        try {
            dto.setRequest_path(AllEleInterfaceTypeEnum.ASYNC_QUERY_INVOICE_PURPOSE_STATUS_REQ.getRequestPath());
            dto.setCombinePatch(AllEleInterfaceTypeEnum.ASYNC_QUERY_INVOICE_PURPOSE_STATUS_REQ.getRequestPath());
            dto.setChannelType("2");
            log.info("asyncQueryInvoicePurposeStatusReq start:{}", (Object)JSON.toJSONString((Object)dto));
            AllEleResponseDTO response = AllEleServiceHelper.doPost((String)taxNo, (AllEleRequestDTO)dto, JSONObject.class);
            log.info("asyncQueryInvoicePurposeStatusReq end:{}", (Object)JSON.toJSONString((Object)response));
            if (response.getSuccess().booleanValue()) {
                JSONObject responseData = (JSONObject)response.getData();
                if (responseData != null) {
                    batchNo = responseData.getString("batchNo");
                } else {
                    failMsg = ResManager.loadKDString((String)"\u8bf7\u6c42\u7a0e\u5c40\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5", (String)"DataSyncHelper_2", (String)"imc-sim-formplugin", (Object[])new Object[0]);
                }
            } else {
                failMsg = response.getDescription();
            }
        }
        catch (Exception e) {
            failMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"DataSyncHelper_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage());
        }
        for (DynamicObject dynamicObject : dataList) {
            if (StringUtils.isNotEmpty(batchNo)) {
                dynamicObject.set("batchno", batchNo);
                dynamicObject.set("executionstatus", (Object)"2");
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)failMsg)) continue;
            dynamicObject.set("executionstatus", (Object)"5");
            if (failMsg.length() > 200) {
                failMsg = failMsg.substring(0, 200);
            }
            dynamicObject.set("failreason", (Object)failMsg);
        }
        ImcSaveServiceHelper.update(dataList);
    }

    public static boolean asyncQueryInvoicePurposeStatusRespFromRpa(String optionAccountList, String taxNo, QFilter inProgressQFilter) {
        QFilter currentQ;
        DynamicObject[] dataArr;
        boolean isUpdating = false;
        HashMap<String, AllEleRedApplyQueryAsyncResponseItemDTO> resultMap = new HashMap<String, AllEleRedApplyQueryAsyncResponseItemDTO>(8);
        HashMap<String, String> failResultMap = new HashMap<String, String>(8);
        long maxId = 0L;
        while ((dataArr = BusinessDataServiceHelper.load((String)"sim_his_inv_data_imp_st", (String)"id", (QFilter[])(currentQ = new QFilter("id", ">", (Object)maxId).and(inProgressQFilter)).toArray(), (String)"id", (int)200)) != null && dataArr.length != 0) {
            for (DynamicObject dataPri : dataArr) {
                long currentId = dataPri.getLong("id");
                if (currentId > maxId) {
                    maxId = currentId;
                }
                DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)currentId, (String)"sim_his_inv_data_imp_st");
                String invoiceCode = DataSyncHelper.getEmptyStr(data.getString("invoicecode"));
                String invoiceNo = DataSyncHelper.getEmptyStr(data.getString("invoiceno"));
                String invoiceCodeNo = invoiceCode + invoiceNo;
                if (resultMap.get(invoiceCodeNo) == null && StringUtils.isBlank((CharSequence)((CharSequence)failResultMap.get(invoiceCodeNo)))) {
                    String batchNo = data.getString("batchno");
                    DataSyncHelper.queryInvoicePurposeStatusRespFromRpa(optionAccountList, resultMap, failResultMap, batchNo, taxNo);
                }
                AllEleRedApplyQueryAsyncResponseItemDTO dto = (AllEleRedApplyQueryAsyncResponseItemDTO)resultMap.get(invoiceCodeNo);
                String failMsg = (String)failResultMap.get(invoiceCodeNo);
                if (dto != null) {
                    DataSyncHelper.setInvoicePurposeStatusSuccessResult(dto, data);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)failMsg) && !failMsg.startsWith("1304")) {
                    DataSyncHelper.setInvoicePurposeStatusFailResult(data, (String)failResultMap.get(invoiceCodeNo));
                    continue;
                }
                isUpdating = Boolean.TRUE;
            }
        }
        return isUpdating;
    }

    private static boolean setInvoicePurposeStatusSuccessResult(AllEleRedApplyQueryAsyncResponseItemDTO dto, DynamicObject data) {
        if (dto == null) {
            return Boolean.FALSE;
        }
        if (dto.isSuccess()) {
            Object invoiceId = data.get("invoiceid");
            DynamicObject invoiceData = BusinessDataServiceHelper.loadSingle((Object)invoiceId, (String)"sim_vatinvoice");
            if (invoiceData != null) {
                invoiceData.set("valueaddedtaxuses", (Object)dto.getValueAddedTaxUses());
                invoiceData.set("creditingstatus", (Object)dto.getCreditingStatus());
                invoiceData.set("excisetaxpurposes", (Object)dto.getExciseTaxPurposes());
                ImcSaveServiceHelper.update((DynamicObject)invoiceData);
                data.set("executionstatus", (Object)"4");
                data.set("failreason", (Object)dto.getDescription());
            } else {
                data.set("executionstatus", (Object)"5");
                data.set("failreason", (Object)"data is not exist");
            }
            ImcSaveServiceHelper.update((DynamicObject)data);
            return Boolean.TRUE;
        }
        return DataSyncHelper.setInvoicePurposeStatusFailResult(data, dto.getDescription());
    }

    private static boolean setInvoicePurposeStatusFailResult(DynamicObject data, String failMsg) {
        if (StringUtils.isNotEmpty((CharSequence)failMsg)) {
            if (failMsg.startsWith("1304")) {
                return Boolean.TRUE;
            }
            data.set("executionstatus", (Object)"5");
            if (failMsg.length() > 200) {
                failMsg = failMsg.substring(0, 200);
            }
            data.set("failreason", (Object)failMsg);
            ImcSaveServiceHelper.update((DynamicObject)data);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void queryInvoicePurposeStatusRespFromRpa(String optionAccountList, Map<String, AllEleRedApplyQueryAsyncResponseItemDTO> successResultMap, Map<String, String> failResultMap, String batchNo, String taxNo) {
        AllEleRedApplyQueryAsyncRequestDTO dto = new AllEleRedApplyQueryAsyncRequestDTO();
        dto.setBatchNo(batchNo);
        dto.setOptionAccountList(optionAccountList);
        dto.setRequest_path(AllEleInterfaceTypeEnum.ASYNC_QUERY_INVOICE_PURPOSE_STATUS_RSP.getRequestPath());
        dto.setCombinePatch(AllEleInterfaceTypeEnum.ASYNC_QUERY_INVOICE_PURPOSE_STATUS_RSP.getRequestPath());
        dto.setChannelType("2");
        try {
            log.info("queryInvoicePurposeStatusRespFromRpa start:{}", (Object)JSON.toJSONString((Object)dto));
            AllEleResponseDTO response = AllEleServiceHelper.doPost((String)taxNo, (AllEleRequestDTO)dto, AllEleRedApplyQueryAsyncResponseDTO.class);
            log.info("queryInvoicePurposeStatusRespFromRpa end:{}", (Object)JSON.toJSONString((Object)response));
            if (response.getSuccess().booleanValue()) {
                AllEleRedApplyQueryAsyncResponseDTO data = (AllEleRedApplyQueryAsyncResponseDTO)response.getData();
                if (data != null) {
                    List successList = data.getSuccess();
                    DataSyncHelper.setRedApplyQueryAsyncToMap(successList, successResultMap);
                    List failList = data.getFail();
                    DataSyncHelper.setFailRedApplyQueryAsyncToMap(failList, failResultMap);
                } else {
                    failResultMap.put(batchNo, ResManager.loadKDString((String)"\u8bf7\u6c42\u7a0e\u5c40\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5", (String)"DataSyncHelper_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                }
            } else {
                failResultMap.put(batchNo, response.getErrcode() + response.getDescription());
            }
        }
        catch (Exception e) {
            log.error("queryInvoicePurposeStatusRespFromRpa exception:", (Throwable)e);
            failResultMap.put(batchNo, ResManager.loadKDString((String)"\u8bf7\u6c42\u7a0e\u5c40\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a\uff0c\u8bf7\u7a0d\u5019\u518d\u8bd5", (String)"DataSyncHelper_2", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        }
    }

    private static void setRedApplyQueryAsyncToMap(List<AllEleRedApplyQueryAsyncResponseItemDTO> list, Map<String, AllEleRedApplyQueryAsyncResponseItemDTO> resultMap) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (AllEleRedApplyQueryAsyncResponseItemDTO dto : list) {
            dto.setSuccess(Boolean.TRUE.booleanValue());
            String invoiceCodeNo = DataSyncHelper.getEmptyStr(dto.getInvoiceCode()) + DataSyncHelper.getEmptyStr(dto.getInvoiceNo());
            resultMap.put(invoiceCodeNo, dto);
        }
    }

    private static void setFailRedApplyQueryAsyncToMap(List<AllEleRedApplyQueryAsyncResponseItemDTO> list, Map<String, String> resultMap) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (AllEleRedApplyQueryAsyncResponseItemDTO dto : list) {
            dto.setSuccess(Boolean.FALSE.booleanValue());
            String invoiceCodeNo = DataSyncHelper.getEmptyStr(dto.getInvoiceCode()) + DataSyncHelper.getEmptyStr(dto.getInvoiceNo());
            String errorMsg = DataSyncHelper.getEmptyStr(dto.getErrcode()) + DataSyncHelper.getEmptyStr(dto.getDescription());
            resultMap.put(invoiceCodeNo, errorMsg);
        }
    }

    public static JSONObject queryRedInfoPreLeqi(String applicant, String sellerTaxNo, String buyerTaxNo, String invoiceCode, String invoiceNo, String invoiceType, String invoiceDate, Object invoiceId) {
        int success = 0;
        String failMsg = null;
        try {
            String taxNo;
            String string = taxNo = "1".equalsIgnoreCase(applicant) ? sellerTaxNo : buyerTaxNo;
            if (!EnterpriseHelper.isLqptChannel((String)taxNo)) {
                failMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u53f7\u6682\u4e0d\u652f\u6301\u4e50\u4f01\u901a\u9053\u67e5\u8be2\u5165\u8d26\u72b6\u6001\u3002", (String)"DataSyncHelper_1", (String)"imc-sim-formplugin", (Object[])new Object[0]);
            }
            if (invoiceDate != null && invoiceDate.length() > 8) {
                invoiceDate = invoiceDate.replace("-", "");
                invoiceDate = invoiceDate.substring(0, 8);
            }
            InvoiceStatusQueryRequest request = new InvoiceStatusQueryRequest();
            request.setNsrsbh(taxNo);
            request.setFpdm(invoiceCode);
            request.setFphm(invoiceNo);
            request.setFplx(InvoiceType.getRimLqptCodeByTypeCode((String)invoiceType));
            request.setKprq(invoiceDate);
            JSONObject json = JSONObject.parseObject((String)JSONObject.toJSONString((Object)request));
            json.put("api_type", (Object)"FPZTXXCX");
            log.info("queryRedInfoPreLeqi start:{}", (Object)json.toJSONString());
            JSONObject responseJson = new InvoiceCollectionService().send(json);
            String description = responseJson.getString("description");
            if (kd.imc.sim.common.constant.ErrorType.SUCCESS.getErrcode().equals(responseJson.getString("errcode"))) {
                DynamicObject invoiceData;
                JSONObject resultData = responseJson.getJSONObject("data");
                if (resultData != null && (invoiceData = BusinessDataServiceHelper.loadSingle((Object)invoiceId, (String)"sim_vatinvoice")) != null) {
                    String accountingStatus;
                    String vatStatus = resultData.getString("fpyt");
                    if ("0".equals(vatStatus)) {
                        vatStatus = "03";
                    }
                    if ("01".equals(accountingStatus = resultData.getString("rzzt"))) {
                        accountingStatus = "00";
                    } else if ("02".equals(accountingStatus)) {
                        accountingStatus = "01";
                    }
                    String ctStatus = resultData.getString("xfsyt");
                    if (StringUtils.isEmpty((CharSequence)ctStatus)) {
                        ctStatus = "00";
                    }
                    invoiceData.set("valueaddedtaxuses", (Object)vatStatus);
                    invoiceData.set("creditingstatus", (Object)accountingStatus);
                    invoiceData.set("excisetaxpurposes", (Object)ctStatus);
                    ImcSaveServiceHelper.update((DynamicObject)invoiceData);
                    success = 1;
                    failMsg = description;
                }
                if (success == 0) {
                    failMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"DataSyncHelper_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), ErrorType.USER_ERROR_A0160.getDescription());
                }
            } else {
                failMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"DataSyncHelper_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), description);
            }
        }
        catch (Exception e) {
            failMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"DataSyncHelper_0", (String)"imc-sim-formplugin", (Object[])new Object[0]), e.getMessage());
        }
        JSONObject returnJson = new JSONObject();
        returnJson.put("success", (Object)success);
        returnJson.put("failMsg", (Object)failMsg);
        log.info("queryRedInfoPreLeqi end:{}", (Object)returnJson.toJSONString());
        return returnJson;
    }

    private static String getEmptyStr(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        return str;
    }
}

