/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.helper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ExcelHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.sim.common.AsyncCheckDTO;
import kd.imc.sim.common.dto.vehicle.VehicleInvoiceCheckDTO;
import kd.imc.sim.common.utils.DeviceUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.VehicleInvoiceValidUtil;

public class VehicleImportHelper {
    private static Log LOGGER = LogFactory.getLog(VehicleImportHelper.class);

    public static boolean issuedCheck(ImportLogger logger, ImportBillData billData, AsyncCheckDTO checkDto, VehicleInvoiceCheckDTO totalCheckDto) {
        QFilter existFilter;
        boolean isValidSuccess = checkDto.isSuccess();
        JSONObject json = billData.getData();
        int index = billData.getStartIndex();
        String invoiceCode = json.getString("invoicecode");
        String invoiceNo = json.getString("invoiceno");
        String issueTime = json.getString("issuetime");
        String originalInvoiceCode = json.getString("originalinvoicecode");
        String originalInvoiceNo = json.getString("originalinvoiceno");
        String originalIssueTime = json.getString("originalissuetime");
        String issueType = json.getString("issuetype");
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)invoiceCode, (int)12, (String)ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801", (String)"VehicleImportHelper_8", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)invoiceNo, (int)8, (String)ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801", (String)"VehicleImportHelper_9", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        if (IssueType.RED_INVOICE.getTypeCode().equals(issueType)) {
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)originalInvoiceCode, (int)12, (String)ResManager.loadKDString((String)"\u539f\u53d1\u7968\u4ee3\u7801", (String)"VehicleImportHelper_10", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)originalInvoiceNo, (int)8, (String)ResManager.loadKDString((String)"\u539f\u53d1\u7968\u53f7\u7801", (String)"VehicleImportHelper_11", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)originalIssueTime, (int)10, (String)ResManager.loadKDString((String)"\u539f\u5f00\u7968\u65e5\u671f", (String)"VehicleImportHelper_12", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
            if (isValidSuccess) {
                if (!RegexUtil.isInvoiceCode((String)originalInvoiceCode)) {
                    isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u539f\u53d1\u7968\u4ee3\u7801\u683c\u5f0f\u6709\u8bef", (String)"VehicleImportHelper_13", (String)"imc-sim-service", (Object[])new Object[0]), isValidSuccess);
                }
                if (!RegexUtil.isInvoiceNo((String)originalInvoiceNo)) {
                    isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u539f\u53d1\u7968\u53f7\u7801\u683c\u5f0f\u6709\u8bef", (String)"VehicleImportHelper_14", (String)"imc-sim-service", (Object[])new Object[0]), isValidSuccess);
                }
                isValidSuccess = VehicleImportHelper.dealTime(index, logger, originalIssueTime, "originalissuetime", json, ResManager.loadKDString((String)"\u539f\u5f00\u7968\u65e5\u671f", (String)"VehicleImportHelper_15", (String)"imc-sim-service", (Object[])new Object[0]), isValidSuccess);
            }
        } else {
            json.put("originalinvoicecode", null);
            json.put("originalinvoiceno", null);
            json.put("originalissuetime", null);
        }
        if (isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)issueTime, (int)10, (String)String.format(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f%s", (String)"VehicleImportHelper_16", (String)"imc-sim-service", (Object[])new Object[0]), issueTime)), isValidSuccess)) {
            if (!RegexUtil.isInvoiceCode((String)invoiceCode)) {
                isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\u683c\u5f0f\u6709\u8bef", (String)"VehicleImportHelper_17", (String)"imc-sim-service", (Object[])new Object[0]), isValidSuccess);
            }
            if (!RegexUtil.isInvoiceNo((String)invoiceNo)) {
                isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u683c\u5f0f\u6709\u8bef", (String)"VehicleImportHelper_18", (String)"imc-sim-service", (Object[])new Object[0]), isValidSuccess);
            }
            isValidSuccess = VehicleImportHelper.dealTime(index, logger, issueTime, "issuetime", json, ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f", (String)"VehicleImportHelper_19", (String)"imc-sim-service", (Object[])new Object[0]), isValidSuccess);
        }
        if (isValidSuccess && QueryServiceHelper.exists((String)"sim_vatinvoice_vehicles", (QFilter[])(existFilter = new QFilter("invoicecode", "=", (Object)invoiceCode).and("invoiceno", "=", (Object)invoiceNo)).toArray())) {
            isValidSuccess = false;
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u4ee3\u7801%1$s\u53f7\u7801%2$s\u5728\u7cfb\u7edf\u4e2d\u5df2\u7ecf\u5b58\u5728", (String)"VehicleImportHelper_20", (String)"imc-sim-service", (Object[])new Object[0]), invoiceCode, invoiceNo));
        }
        if (!isValidSuccess) {
            checkDto.setSuccess(isValidSuccess);
            totalCheckDto.setCheckSuccess(isValidSuccess);
        }
        return isValidSuccess;
    }

    private static boolean dealTime(int index, ImportLogger logger, String timeStr, String key, JSONObject invoice, String description, boolean isValidSuccess) {
        try {
            Date issueDate = DateUtils.stringToDate((String)timeStr, (String)"yyyy-MM-dd");
            invoice.put(key, (Object)issueDate);
        }
        catch (Exception e) {
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"%s\u683c\u5f0f\u6709\u8bef", (String)"VehicleImportHelper_56", (String)"imc-sim-service", (Object[])new Object[0]), description));
            isValidSuccess = false;
        }
        return isValidSuccess;
    }

    public static boolean commonCheck(ImportLogger logger, ImportBillData billData, AsyncCheckDTO checkDto, VehicleInvoiceCheckDTO totalCheckDto) {
        boolean isValidSuccess = checkDto.isSuccess();
        JSONObject json = billData.getData();
        int index = billData.getStartIndex();
        String invoiceType = json.getString("invoicetype");
        String buyerTaxNo = json.getString("buyertaxno");
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullMessage((String)invoiceType, (String)ResManager.loadKDString((String)"\u53d1\u7968\u79cd\u7c7b", (String)"VehicleImportHelper_22", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)json.getString("buyername"), (int)100, (String)ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u540d\u79f0", (String)"VehicleImportHelper_21", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        String totalAmountValidMessage = VehicleInvoiceValidUtil.checkIsNumberMessage((String)json.getString("totalamount"), (String)ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1", (String)"VehicleImportHelper_23", (String)"imc-sim-service", (Object[])new Object[0]));
        json.put("invoicetype", (Object)InvoiceType.getCodeByDesc((String)invoiceType));
        if (InvoiceType.ALL_E_VEHICLE_NORMAL.getDescription().equals(invoiceType) || InvoiceType.ALL_E_VEHICLE_NORMAL_ELE.getDescription().equals(invoiceType)) {
            isValidSuccess = VehicleImportHelper.checkAllEVehicle(logger, totalCheckDto, isValidSuccess, json, index, buyerTaxNo, totalAmountValidMessage);
        } else if ("\u673a\u52a8\u8f66\u53d1\u7968".equals(invoiceType)) {
            isValidSuccess = VehicleImportHelper.checkTaxVehicleInvoice(logger, totalCheckDto, isValidSuccess, json, index, buyerTaxNo);
        } else if (InvoiceType.ALL_E_PAPER_USED_CAR.getDescription().equals(invoiceType) || InvoiceType.ALL_E_PAPER_USED_CAR_ELE.getDescription().equals(invoiceType)) {
            isValidSuccess = VehicleImportHelper.checkUsedCarInvoice(logger, totalCheckDto, isValidSuccess, json, index);
        } else {
            isValidSuccess = false;
            VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u53d1\u7968\u79cd\u7c7b\u4e0d\u5408\u6cd5", (String)"VehicleImportHelper_42", (String)"imc-sim-service", (Object[])new Object[0]), isValidSuccess);
        }
        if (InvoiceUtils.isVehicleInvoice((String)json.getString("invoicetype"))) {
            isValidSuccess = VehicleImportHelper.checkAllVehicle(logger, isValidSuccess, json, index);
        }
        if (!(isValidSuccess = VehicleImportHelper.checkCommonInfo(logger, isValidSuccess, json, index, totalAmountValidMessage))) {
            checkDto.setSuccess(isValidSuccess);
            totalCheckDto.setCheckSuccess(isValidSuccess);
        }
        return isValidSuccess;
    }

    private static boolean checkUsedCarInvoice(ImportLogger logger, VehicleInvoiceCheckDTO totalCheckDto, boolean isValidSuccess, JSONObject json, int index) {
        if (VehicleInvoiceCheckDTO.From.ISSUE.equals(totalCheckDto.getFrom())) {
            boolean isZeroZZSTSGL;
            Object salerCardType;
            Object buyerCardType;
            DynamicObject[] array;
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleImportHelper.checkAccount(json.getString("account"), json.getString("issuetaxno")), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("vehicleidcode"), (int)30, (String)ResManager.loadKDString((String)"\u8f66\u8f86\u8bc6\u522b\u4ee3\u53f7/\u8f66\u67b6\u53f7\u7801", (String)"VehicleInvoiceValidator_12", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("brandmodel"), (int)50, (String)ResManager.loadKDString((String)"\u5382\u724c\u578b\u53f7", (String)"VehicleInvoiceValidator_8", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("registernumber"), (int)50, (String)ResManager.loadKDString((String)"\u767b\u8bb0\u8bc1\u53f7", (String)"VehicleInvoiceValidator_45", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("vehicleadminname"), (int)100, (String)ResManager.loadKDString((String)"\u8f6c\u5165\u5730\u8f66\u7ba1\u6240", (String)"VehicleInvoiceValidator_46", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("licenseplatenumber"), (int)100, (String)ResManager.loadKDString((String)"\u8f66\u724c\u7167\u53f7", (String)"VehicleInvoiceValidator_47", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("vehicletype"), (int)40, (String)ResManager.loadKDString((String)"\u8f66\u8f86\u7c7b\u578b", (String)"VehicleInvoiceValidator_7", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)json.getString("drawer"), (int)10, (String)ResManager.loadKDString((String)"\u5f00\u7968\u4eba", (String)"VehicleImportHelper_37", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("issuename"), (int)100, (String)ResManager.loadKDString((String)"\u5f00\u7968\u65b9\u5355\u4f4d", (String)"VehicleInvoiceValidator_48", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("issuetaxno"), (int)20, (String)ResManager.loadKDString((String)"\u5f00\u7968\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"VehicleInvoiceValidator_49", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("issueaddress"), (int)80, (String)ResManager.loadKDString((String)"\u5f00\u7968\u65b9\u5355\u4f4d\u5730\u5740", (String)"VehicleInvoiceValidator_50", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("issuephone"), (int)50, (String)ResManager.loadKDString((String)"\u5f00\u7968\u65b9\u7535\u8bdd", (String)"VehicleInvoiceValidator_51", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("issuebankname"), (int)80, (String)ResManager.loadKDString((String)"\u5f00\u7968\u65b9\u5f00\u6237\u884c", (String)"VehicleInvoiceValidator_52", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("issuebankaccount"), (int)50, (String)ResManager.loadKDString((String)"\u5f00\u7968\u65b9\u5f00\u6237\u94f6\u884c\u8d26\u53f7", (String)"VehicleInvoiceValidator_53", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            String issueWay = json.getString("issueway");
            isValidSuccess = "0".equals(issueWay) ? VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullMessage((String)json.getString("buyerproperty"), (String)ResManager.loadKDString((String)"\u4e70\u65b9\u6027\u8d28", (String)"VehicleInvoiceValidator_65", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess) : VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullMessage((String)json.getString("salerproperty"), (String)ResManager.loadKDString((String)"\u5356\u65b9\u6027\u8d28", (String)"VehicleInvoiceValidator_70", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullMessage((String)json.getString("issueway"), (String)ResManager.loadKDString((String)"\u5f00\u7968\u65b9\u5f0f", (String)"VehicleInvoiceValidator_59", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullMessage((String)json.getString("usedcarenterprisenature"), (String)ResManager.loadKDString((String)"\u4f01\u4e1a\u8d44\u8d28", (String)"VehicleInvoiceValidator_64", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("salername"), (int)100, (String)ResManager.loadKDString((String)"\u5356\u65b9\u5355\u4f4d/\u4e2a\u4eba", (String)"VehicleInvoiceValidator_60", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("salertaxno"), (int)30, (String)ResManager.loadKDString((String)"\u5356\u65b9\u5355\u4f4d\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u7801(\u5356\u65b9\u81ea\u7136\u4eba\u8bc1\u4ef6\u53f7\u7801)", (String)"VehicleInvoiceValidator_61", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("saleraddress"), (int)100, (String)ResManager.loadKDString((String)"\u5356\u65b9\u5355\u4f4d/\u4e2a\u4eba\u4f4f\u5740", (String)"VehicleInvoiceValidator_62", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("salerphone"), (int)30, (String)ResManager.loadKDString((String)"\u5356\u65b9\u7535\u8bdd", (String)"VehicleInvoiceValidator_63", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("buyertaxno"), (int)30, (String)ResManager.loadKDString((String)"\u4e70\u65b9\u5355\u4f4d\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u7801", (String)"VehicleInvoiceValidator_66", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("buyeraddr"), (int)100, (String)ResManager.loadKDString((String)"\u4e70\u65b9\u5355\u4f4d/\u4e2a\u4eba\u4f4f\u5740", (String)"VehicleInvoiceValidator_67", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("buyerphone"), (int)50, (String)ResManager.loadKDString((String)"\u4e70\u65b9\u7535\u8bdd", (String)"VehicleInvoiceValidator_68", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            try {
                String buyerNationCode;
                JSONObject buyerNationJson = json.getJSONObject("buyernation");
                String string = buyerNationCode = null != buyerNationJson ? buyerNationJson.getString("number") : "";
                if (StringUtils.isNotBlank((CharSequence)buyerNationCode)) {
                    array = InvoiceUtils.queryNations((String)buyerNationCode);
                    json.put("buyernation", (Object)array[0]);
                } else if ("1".equals(json.getString("buyerproperty"))) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u4e3a\u4e2a\u4eba,\u5fc5\u987b\u586b\u5199\u56fd\u7c4d", (String)"VehicleInvoiceValidator_76", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    isValidSuccess = false;
                }
            }
            catch (Exception e) {
                logger.log(Integer.valueOf(index), e.getMessage());
                isValidSuccess = false;
            }
            try {
                String salerNationCode;
                JSONObject salerNationJson = json.getJSONObject("nation");
                String string = salerNationCode = null != salerNationJson ? salerNationJson.getString("number") : "";
                if (StringUtils.isNotBlank((CharSequence)salerNationCode)) {
                    array = InvoiceUtils.queryNations((String)salerNationCode);
                    json.put("nation", (Object)array[0]);
                } else if ("1".equals(json.getString("salerproperty"))) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u9500\u552e\u65b9\u4e3a\u4e2a\u4eba\uff0c\u5fc5\u987b\u586b\u5199\u56fd\u7c4d", (String)"VehicleInvoiceValidator_78", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                    isValidSuccess = false;
                }
            }
            catch (Exception e) {
                logger.log(Integer.valueOf(index), e.getMessage());
                isValidSuccess = false;
            }
            if ("1".equals(json.getString("buyerproperty")) && StringUtils.isBlank((Object)(buyerCardType = json.get((Object)"buyercardtype")))) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u4e3a\u4e2a\u4eba\uff0c\u5fc5\u987b\u586b\u5199\u8bc1\u4ef6\u7c7b\u578b", (String)"VehicleInvoiceValidator_77", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                isValidSuccess = false;
            }
            if ("1".equals(json.getString("salerproperty")) && StringUtils.isBlank((Object)(salerCardType = json.get((Object)"cardtype")))) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u9500\u552e\u65b9\u4e3a\u4e2a\u4eba\uff0c\u5fc5\u987b\u586b\u5199\u8bc1\u4ef6\u7c7b\u578b", (String)"VehicleInvoiceValidator_79", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                isValidSuccess = false;
            }
            if ("07".equals(json.get((Object)"usedcarenterprisenature")) && !"0".equals(json.getString("issueway"))) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u4e8c\u624b\u8f66\u5e02\u573a\u4f01\u4e1a\u53ea\u80fd\u9009\u62e9\u6b63\u5411\u5f00\u7968\uff0c\u4e0d\u652f\u6301\u53cd\u5411\u5f00\u7968", (String)"VehicleInvoiceValidator_109", (String)"imc-sim-formplugin", (Object[])new Object[0]));
                isValidSuccess = false;
            }
            VehicleImportHelper.checkAmount(json, logger, index, isValidSuccess);
            String zzstsgl = json.getString("zzstsgl");
            String taxRate = json.getString("taxrate");
            String taxPremark = json.getString("taxpremark");
            boolean isUse = "1".equalsIgnoreCase(taxPremark);
            boolean bl = isZeroZZSTSGL = "\u514d\u7a0e".equals(zzstsgl) || "\u4e0d\u5f81\u7a0e".equals(zzstsgl) || "\u666e\u901a\u96f6\u7a0e\u7387".equals(zzstsgl);
            if (isZeroZZSTSGL && isUse && !TaxRate.ZERO_PERCENT.getRateValue().equals(taxRate)) {
                isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u7a0e\u7387\u548c\u4f18\u60e0\u653f\u7b56\u4e0d\u5339\u914d", (String)"VehicleInvoiceValidator_69", (String)"imc-sim-formplugin", (Object[])new Object[0]), false);
            }
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkLengthMessage((String)json.getString("remark"), (int)200, (String)"\u5907\u6ce8"), isValidSuccess);
        }
        return isValidSuccess;
    }

    private static boolean checkCommonInfo(ImportLogger logger, boolean isValidSuccess, JSONObject json, int index, String totalAmountValidMessage) {
        String goodsCode = json.getString("goodscode");
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)goodsCode, (int)19, (String)ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"VehicleImportHelper_43", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        if (String.valueOf(goodsCode).length() != 19) {
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u957f\u5ea6\u5e94\u8be5\u4e3a19\u4f4d", (String)"VehicleImportHelper_44", (String)"imc-sim-service", (Object[])new Object[0]), isValidSuccess);
        } else {
            DynamicObject taxClassCode = TaxClassCodeCheckHelper.geTaxCode((String)goodsCode);
            if (null == taxClassCode) {
                isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, String.format(ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u6709\u8bef%s", (String)"VehicleImportHelper_45", (String)"imc-sim-service", (Object[])new Object[0]), goodsCode), isValidSuccess);
            }
        }
        String invoiceAmountValidMessage = VehicleInvoiceValidUtil.checkIsNumberMessage((String)json.getString("invoiceamount"), (String)ResManager.loadKDString((String)"\u5408\u8ba1\u91d1\u989d", (String)"VehicleImportHelper_46", (String)"imc-sim-service", (Object[])new Object[0]));
        String totalTaxValidMessage = VehicleInvoiceValidUtil.checkIsNumberMessage((String)json.getString("totaltax"), (String)ResManager.loadKDString((String)"\u5408\u8ba1\u7a0e\u989d", (String)"VehicleImportHelper_47", (String)"imc-sim-service", (Object[])new Object[0]));
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, invoiceAmountValidMessage, isValidSuccess);
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, totalAmountValidMessage, isValidSuccess);
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, totalTaxValidMessage, isValidSuccess);
        String taxRate = json.getString("taxrate");
        if (ExcelHelper.isNormalTaxRate((String)taxRate)) {
            String dbTaxRate = ExcelHelper.getDBTaxRate((String)taxRate);
            json.put("taxrate", (Object)dbTaxRate);
            if (StringUtils.isBlank((CharSequence)invoiceAmountValidMessage) && StringUtils.isBlank((CharSequence)totalAmountValidMessage) && StringUtils.isBlank((CharSequence)totalTaxValidMessage)) {
                isValidSuccess = VehicleImportHelper.checkAmount(json, logger, index, isValidSuccess);
            }
            isValidSuccess = VehicleImportHelper.checkZZSTSGL(json, logger, index, isValidSuccess);
        } else {
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u4f20\u5165\u7a0e\u7387\u6709\u8bef", (String)"VehicleImportHelper_48", (String)"imc-sim-service", (Object[])new Object[0]), isValidSuccess);
        }
        String taxPremark = json.getString("taxpremark");
        if ("\u4f7f\u7528".equals(taxPremark)) {
            json.put("taxpremark", (Object)"1");
        }
        if ("\u4e0d\u4f7f\u7528".equals(taxPremark) || StringUtils.isBlank((CharSequence)taxPremark)) {
            json.put("taxpremark", (Object)"0");
        }
        return isValidSuccess;
    }

    private static boolean checkAllVehicle(ImportLogger logger, boolean isValidSuccess, JSONObject json, int index) {
        String version = json.getString("version");
        if ("\u65e7\u7248".equals(version)) {
            json.put("version", (Object)"0");
        } else if ("\u65b0\u7248".equals(version)) {
            json.put("version", (Object)"1");
        }
        String invoiceType = json.getString("invoicetype");
        if (InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode().equals(invoiceType)) {
            String invoiceCopyType = json.getString("invoicecopytype");
            if (ResManager.loadKDString((String)"\u516d\u8054", (String)"VehicleImportHelper_64", (String)"imc-sim-service", (Object[])new Object[0]).equals(invoiceCopyType)) {
                json.put("invoicecopytype", (Object)"6");
            }
        } else {
            json.put("invoicecopytype", (Object)"6");
        }
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkLengthMessage((String)json.getString("importcertificate"), (int)36, (String)ResManager.loadKDString((String)"\u8fdb\u53e3\u8bc1\u660e\u4e66\u53f7", (String)"VehicleImportHelper_51", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkLengthMessage((String)json.getString("commodityinspectionnum"), (int)32, (String)ResManager.loadKDString((String)"\u5546\u68c0\u5355\u53f7", (String)"VehicleImportHelper_52", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        return isValidSuccess;
    }

    private static boolean checkTaxVehicleInvoice(ImportLogger logger, VehicleInvoiceCheckDTO totalCheckDto, boolean isValidSuccess, JSONObject json, int index, String buyerTaxNo) {
        String jqbh;
        json.put("invoicecopytype", null);
        json.put("invoicetype", (Object)InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode());
        String version = json.getString("version");
        boolean isOldVersion = "\u65e7\u7248".equals(version);
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullMessage((String)version, (String)ResManager.loadKDString((String)"\u7248\u672c\u53f7", (String)"VehicleImportHelper_25", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        if (VehicleInvoiceCheckDTO.From.ISSUE.equals(totalCheckDto.getFrom())) {
            if (StringUtils.isNotBlank((CharSequence)buyerTaxNo) && !RegexUtil.isNsrsbh((String)buyerTaxNo)) {
                isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u6709\u8bef", (String)"VehicleImportHelper_26", (String)"imc-sim-service", (Object[])new Object[0]), isValidSuccess);
            }
            VehicleImportHelper.concatDefaultRemark(json);
        } else {
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)buyerTaxNo, (int)20, (String)(isOldVersion ? ResManager.loadKDString((String)"\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", (String)"VehicleImportHelper_57", (String)"imc-sim-service", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7/\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801/\u8eab\u4efd\u8bc1\u53f7\u7801", (String)"VehicleImportHelper_58", (String)"imc-sim-service", (Object[])new Object[0]))), isValidSuccess);
            if (isValidSuccess && StringUtils.isNotBlank((CharSequence)buyerTaxNo) && !RegexUtil.isNsrsbh((String)buyerTaxNo)) {
                isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u8d2d\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u6709\u8bef", (String)"VehicleImportHelper_26", (String)"imc-sim-service", (Object[])new Object[0]), isValidSuccess);
            }
        }
        if (isOldVersion) {
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)json.getString("buyercardno"), (int)22, (String)ResManager.loadKDString((String)"\u7248\u672c\u53f7\u4e3a\u65e7\u7248\u65f6\uff0c\u8eab\u4efd\u8bc1\u53f7\u7801/\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801", (String)"VehicleImportHelper_59", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        }
        if (isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullMessage((String)(jqbh = json.getString("jqbh")), (String)ResManager.loadKDString((String)"\u8bbe\u5907\u7f16\u53f7", (String)"VehicleImportHelper_27", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess)) {
            Set jspSet = totalCheckDto.getJspEquipmentNoSet();
            if (null != jspSet && !jspSet.contains(jqbh)) {
                isValidSuccess = false;
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u8be5\u7ec4\u7ec7\u7ef4\u62a4\u7684\u91d1\u7a0e\u76d8\u5f00\u5177\u7684\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\u3002", (String)"VehicleImportHelper_28", (String)"imc-sim-service", (Object[])new Object[0]));
            } else {
                String equipmentType = DeviceUtil.getDevType((String)json.getString("jqbh"));
                if (!"2".equals(equipmentType) && !"3".equals(equipmentType)) {
                    isValidSuccess = false;
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u8be5\u7ec4\u7ec7\u7ef4\u62a4\u7684\u91d1\u7a0e\u76d8\u5f00\u5177\u7684\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\u3002", (String)"VehicleImportHelper_28", (String)"imc-sim-service", (Object[])new Object[0]));
                }
            }
        }
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)json.getString("vehicletype"), (int)40, (String)ResManager.loadKDString((String)"\u8f66\u8f86\u7c7b\u578b", (String)"VehicleImportHelper_30", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)json.getString("brandmodel"), (int)60, (String)ResManager.loadKDString((String)"\u5382\u724c\u578b\u53f7", (String)"VehicleImportHelper_32", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)json.getString("producingarea"), (int)32, (String)ResManager.loadKDString((String)"\u4ea7\u5730", (String)"VehicleImportHelper_33", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)json.getString("certificatenum"), (int)50, (String)ResManager.loadKDString((String)"\u5408\u683c\u8bc1\u53f7", (String)"VehicleImportHelper_34", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)json.getString("enginenum"), (int)60, (String)ResManager.loadKDString((String)"\u53d1\u52a8\u673a\u53f7", (String)"VehicleImportHelper_35", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)json.getString("vehicleidcode"), (int)23, (String)ResManager.loadKDString((String)"\u8f66\u8f86\u8bc6\u522b\u4ee3\u53f7/\u8f66\u67b6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (String)"VehicleImportHelper_36", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)json.getString("drawer"), (int)10, (String)ResManager.loadKDString((String)"\u5f00\u7968\u4eba", (String)"VehicleImportHelper_37", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)json.getString("producingname"), (int)40, (String)ResManager.loadKDString((String)"\u751f\u4ea7\u4f01\u4e1a\u540d\u79f0", (String)"VehicleImportHelper_38", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndLengthMessage((String)json.getString("producingname"), (int)40, (String)ResManager.loadKDString((String)"\u751f\u4ea7\u4f01\u4e1a\u540d\u79f0", (String)"VehicleImportHelper_38", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        if (StringUtils.isNotBlank((CharSequence)json.getString("limitepeople"))) {
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkIsNumberMessage((String)json.getString("limitepeople"), (String)ResManager.loadKDString((String)"\u9650\u4e58\u4eba\u6570", (String)"VehicleImportHelper_39", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        }
        if (StringUtils.isNotBlank((CharSequence)json.getString("totalton"))) {
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkIsNumberMessage((String)json.getString("totalton"), (String)ResManager.loadKDString((String)"\u5428\u4f4d", (String)"VehicleImportHelper_40", (String)"imc-sim-service", (Object[])new Object[0])), isValidSuccess);
        }
        return isValidSuccess;
    }

    private static void concatDefaultRemark(JSONObject json) {
        String remark = json.getString("remark");
        if (!String.valueOf(remark).contains("\u4e00\u8f66\u4e00\u7968")) {
            remark = StringUtils.isBlank((CharSequence)remark) ? "\u4e00\u8f66\u4e00\u7968" : "\u4e00\u8f66\u4e00\u7968 " + remark;
        }
        json.put("remark", (Object)remark);
    }

    private static boolean checkAllEVehicle(ImportLogger logger, VehicleInvoiceCheckDTO totalCheckDto, boolean isValidSuccess, JSONObject json, int index, String buyerTaxNo, String totalAmountValidMessage) {
        if (VehicleInvoiceCheckDTO.From.ISSUE.equals(totalCheckDto.getFrom())) {
            VehicleImportHelper.concatDefaultRemark(json);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleImportHelper.checkAccount(json.getString("account"), json.getString("salertaxno")), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("vehicleidcode"), (int)30, (String)ResManager.loadKDString((String)"\u8f66\u8f86\u8bc6\u522b\u4ee3\u53f7/\u8f66\u67b6\u53f7\u7801", (String)"VehicleInvoiceValidator_12", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("brandmodel"), (int)50, (String)ResManager.loadKDString((String)"\u5382\u724c\u578b\u53f7", (String)"VehicleInvoiceValidator_8", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("producingarea"), (int)50, (String)ResManager.loadKDString((String)"\u4ea7\u5730", (String)"VehicleInvoiceValidator_9", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("certificatenum"), (int)30, (String)ResManager.loadKDString((String)"\u5408\u683c\u8bc1\u53f7", (String)"VehicleInvoiceValidator_10", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("enginenum"), (int)50, (String)ResManager.loadKDString((String)"\u53d1\u52a8\u673a\u53f7", (String)"VehicleInvoiceValidator_11", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("vehicletype"), (int)20, (String)ResManager.loadKDString((String)"\u8f66\u8f86\u7c7b\u578b", (String)"VehicleInvoiceValidator_7", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("producingname"), (int)100, (String)ResManager.loadKDString((String)"\u751f\u4ea7\u4f01\u4e1a\u540d\u79f0", (String)"VehicleInvoiceValidator_13", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkNullAndCharLengthMsg((String)json.getString("uuid"), (int)30, (String)ResManager.loadKDString((String)"\u673a\u52a8\u8f66uuid", (String)"VehicleInvoiceValidator_39", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkCharLengthMsg((String)json.getString("importcertificate"), (int)30, (String)ResManager.loadKDString((String)"\u8fdb\u53e3\u8bc1\u660e\u4e66\u53f7", (String)"VehicleInvoiceValidator_24", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkCharLengthMsg((String)json.getString("commodityinspectionnum"), (int)30, (String)ResManager.loadKDString((String)"\u5546\u68c0\u5355\u53f7", (String)"VehicleInvoiceValidator_25", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkCharLengthMsg((String)json.getString("totalton"), (int)10, (String)ResManager.loadKDString((String)"\u5428\u4f4d", (String)"VehicleInvoiceValidator_37", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkCharLengthMsg((String)json.getString("limitepeople"), (int)5, (String)ResManager.loadKDString((String)"\u9650\u4e58\u4eba\u6570", (String)"VehicleInvoiceValidator_38", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            isValidSuccess = VehicleImportHelper.appendErrorMessage(index, logger, VehicleInvoiceValidUtil.checkCharLengthMsg((String)json.getString("overtaxcode"), (int)30, (String)ResManager.loadKDString((String)"\u5b8c\u7a0e\u51ed\u8bc1\u53f7\u7801", (String)"VehicleInvoiceValidator_40", (String)"imc-sim-formplugin", (Object[])new Object[0])), isValidSuccess);
            if (StringUtils.isNotBlank((CharSequence)buyerTaxNo) && !RegexUtil.isNsrsbh((String)buyerTaxNo, (boolean)true)) {
                VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u683c\u5f0f\u6709\u8bef", (String)"VehicleImportHelper_24", (String)"imc-sim-service", (Object[])new Object[0]), isValidSuccess);
                isValidSuccess = false;
            }
            if (InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode().equals(json.getString("invoicetype")) && StringUtils.isBlank((CharSequence)totalAmountValidMessage) && !BigDecimalUtil.greaterZero((BigDecimal)new BigDecimal(json.getString("totalamount")))) {
                VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968\uff08\u6570\u7535\u7eb8\u7968\uff09\u6682\u53ea\u652f\u6301\u5f00\u5177\u84dd\u5b57\u53d1\u7968", (String)"VehicleInvoiceValidator_44", (String)"imc-sim-formplugin", (Object[])new Object[0]), isValidSuccess);
                isValidSuccess = false;
            }
        }
        return isValidSuccess;
    }

    private static String checkAccount(String account, String taxNo) {
        if (StringUtils.isNotBlank((CharSequence)account)) {
            return AllEleAuthHelper.checkIssueAccount((String)taxNo, (String)account);
        }
        return ResManager.loadKDString((String)"\u6570\u7535\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"VehicleImportHelper_7", (String)"imc-sim-service", (Object[])new Object[0]);
    }

    private static boolean checkZZSTSGL(JSONObject json, ImportLogger logger, int index, boolean isValidSuccess) {
        String taxRate = json.getString("taxrate");
        String zzstsgl = json.getString("zzstsgl");
        String taxpremark = json.getString("taxpremark");
        if (BigDecimal.ZERO.compareTo(new BigDecimal(taxRate)) == 0) {
            if ("0".equals(taxpremark)) {
                zzstsgl = "\u666e\u901a\u96f6\u7a0e\u7387";
                json.put("zzstsgl", (Object)"\u666e\u901a\u96f6\u7a0e\u7387");
            } else if (!("\u514d\u7a0e".equals(zzstsgl) || "\u4e0d\u5f81\u7a0e".equals(zzstsgl) || "\u51fa\u53e3\u9000\u7a0e".equals(zzstsgl))) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u660e\u7ec6\u7a0e\u7387\u4e3a\u96f6, \u4eab\u53d7\u4f18\u60e0\u5185\u5bb9\u4e0d\u5408\u6cd5\uff0c\u53ea\u80fd\u4e3a[\u51fa\u53e3\u9000\u7a0e\uff0c\u514d\u7a0e\uff0c\u4e0d\u5f81\u7a0e]\u4e2d\u7684\u4e00\u79cd", (String)"VehicleImportHelper_60", (String)"imc-sim-service", (Object[])new Object[0]));
                isValidSuccess = false;
            }
        } else if ("1".equals(taxpremark) && ("\u514d\u7a0e".equals(zzstsgl) || "\u4e0d\u5f81\u7a0e".equals(zzstsgl) || "\u51fa\u53e3\u9000\u7a0e".equals(zzstsgl))) {
            logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u4eab\u53d7\u4f18\u60e0\u5185\u5bb9\u4e0d\u5408\u6cd5", (String)"VehicleImportHelper_61", (String)"imc-sim-service", (Object[])new Object[0]));
            isValidSuccess = false;
        }
        if ("1".equals(taxpremark)) {
            if (StringUtils.isBlank((CharSequence)zzstsgl)) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u65f6\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", (String)"VehicleImportHelper_62", (String)"imc-sim-service", (Object[])new Object[0]));
                isValidSuccess = false;
            }
        } else {
            if (BigDecimal.ZERO.compareTo(new BigDecimal(taxRate)) != 0) {
                json.put("taxpremark", (Object)"0");
                json.put("zzstsgl", (Object)"");
            }
            if (StringUtils.isNotBlank((CharSequence)zzstsgl) && !"\u666e\u901a\u96f6\u7a0e\u7387".equals(zzstsgl)) {
                logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u4e0d\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u65f6\uff0c\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u5fc5\u987b\u4e3a\u7a7a", (String)"VehicleImportHelper_63", (String)"imc-sim-service", (Object[])new Object[0]));
                isValidSuccess = false;
            }
        }
        return isValidSuccess;
    }

    private static boolean appendErrorMessage(int rowIndex, ImportLogger logger, String errorMessage, boolean isSuccess) {
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            logger.log(Integer.valueOf(rowIndex), errorMessage);
            return false;
        }
        return isSuccess;
    }

    private static boolean checkAmount(JSONObject json, ImportLogger logger, int index, boolean isSuccess) {
        String totalTaxStr = (String)json.get((Object)"totaltax");
        String totalAmountStr = (String)json.get((Object)"totalamount");
        String invoiceAmountStr = (String)json.get((Object)"invoiceamount");
        String taxRate = (String)json.get((Object)"taxrate");
        BigDecimal invoiceAmount = new BigDecimal(invoiceAmountStr);
        BigDecimal totalTax = new BigDecimal(totalTaxStr);
        BigDecimal totalAmount = new BigDecimal(totalAmountStr);
        if (totalAmount.compareTo(BigDecimal.ZERO) <= 0) {
            isSuccess = VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u91d1\u989d\u4e58\u4ee5\u7a0e\u7387\u6240\u5f97\u7a0e\u989d\u4e0e\u5bfc\u5165\u7a0e\u989d\u8bef\u5dee\u5927\u4e8e0.06;", (String)"VehicleImportHelper_0", (String)"imc-sim-service", (Object[])new Object[0]), isSuccess);
        }
        String dbTaxRate = ExcelHelper.getDBTaxRate((String)taxRate);
        json.put("taxrate", (Object)dbTaxRate);
        BigDecimal calTax = invoiceAmount.multiply(new BigDecimal(dbTaxRate)).setScale(2, RoundingMode.HALF_UP);
        BigDecimal taxDiff = calTax.subtract(totalTax).abs();
        if (taxDiff.compareTo(new BigDecimal("0.06")) > 0) {
            isSuccess = VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u91d1\u989d\u4e58\u4ee5\u7a0e\u7387\u6240\u5f97\u7a0e\u989d\u4e0e\u5bfc\u5165\u7a0e\u989d\u8bef\u5dee\u5927\u4e8e0.06;", (String)"VehicleImportHelper_0", (String)"imc-sim-service", (Object[])new Object[0]), isSuccess);
        }
        BigDecimal addAll = invoiceAmount.add(totalTax);
        if (BigDecimal.ZERO.compareTo(totalAmount) >= 0) {
            isSuccess = VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1\u5fc5\u987b\u5927\u4e8e0", (String)"VehicleImportHelper_1", (String)"imc-sim-service", (Object[])new Object[0]), isSuccess);
        }
        if (addAll.compareTo(totalAmount) != 0) {
            isSuccess = VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u5408\u8ba1\u91d1\u989d\u52a0\u5408\u8ba1\u7a0e\u989d\u4e0d\u7b49\u4e8e\u4ef7\u7a0e\u5408\u8ba1;", (String)"VehicleImportHelper_2", (String)"imc-sim-service", (Object[])new Object[0]), isSuccess);
        }
        if (MathUtils.isNullOrZero((BigDecimal)totalAmount)) {
            isSuccess = VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u80fd\u4e3a0;", (String)"VehicleImportHelper_3", (String)"imc-sim-service", (Object[])new Object[0]), isSuccess);
        }
        if (MathUtils.isNullOrZero((BigDecimal)totalAmount)) {
            isSuccess = VehicleImportHelper.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u5408\u8ba1\u91d1\u989d\u4e0d\u80fd\u4e3a0;", (String)"VehicleImportHelper_4", (String)"imc-sim-service", (Object[])new Object[0]), isSuccess);
        }
        String issueType = totalAmount.compareTo(BigDecimal.ZERO) > 0 ? IssueType.BLUE_INVOICE.getTypeCode() : IssueType.RED_INVOICE.getTypeCode();
        json.put("issuetype", (Object)issueType);
        return isSuccess;
    }

    public static Set<String> getJspSet(String epTaxNo, Set<String> jspEquipmentNos) {
        DynamicObject[] dynamicObject;
        if (null == jspEquipmentNos) {
            jspEquipmentNos = new HashSet<String>(4);
        }
        QFilter filter = new QFilter("epinfo.number", "=", (Object)epTaxNo).and("equipmenttype", "=", (Object)"2");
        for (DynamicObject equipment : dynamicObject = BusinessDataServiceHelper.load((String)"bdm_tax_equipment", (String)"equipmentno", (QFilter[])filter.toArray())) {
            jspEquipmentNos.add(equipment.getString("equipmentno"));
        }
        return jspEquipmentNos;
    }

    public static String getCurrentOrgTaxNo() {
        long orgId = RequestContext.get().getOrgId();
        QFilter[] filters = new QFilter("id", "=", (Object)orgId).toArray();
        LOGGER.info("currentorgid:" + orgId + "getCurrentOrgTaxNo" + SerializationUtils.toJsonString((Object)filters));
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"bdm_org", (String)"epinfo", (QFilter[])new QFilter("id", "=", (Object)RequestContext.get().getOrgId()).toArray());
        if (array.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u5f15\u5165\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5f15\u5165\u8be5\u7ec4\u7ec7!", (String)"VehicleImportHelper_5", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        DynamicObject epInfo = array[0].getDynamicObject("epinfo");
        if (null == epInfo) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u6dfb\u52a0\u4f01\u4e1a\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6dfb\u52a0\u4f01\u4e1a\u4fe1\u606f", (String)"VehicleImportHelper_6", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        return String.valueOf(epInfo.get("number"));
    }
}

