/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.issuing.invalid;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.service.InvoiceCheckService;

public class InvalidInvoiceControl {
    private static final Log logger = LogFactory.getLog(InvalidInvoiceControl.class);
    public static final String MSG_INV_ABOLISH = "msg_inv_abolish";
    public static final String CANCEL_OR_RED_AR_INVOICE = "cancelOrRedArInvoice";

    public static DynamicObject getReIssueInvoice(DynamicObject invoiceDynamicObject, String belongNo) {
        QFilter qFilter;
        DynamicObject reIssueInvoice;
        DynamicObject newReIssueInvoice = StringUtils.isEmpty((CharSequence)invoiceDynamicObject.getString("reorderno")) ? InvalidInvoiceControl.newReIssueInvoice(invoiceDynamicObject, belongNo) : ((reIssueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id", (QFilter[])(qFilter = new QFilter("orderno", "=", invoiceDynamicObject.get("reorderno"))).toArray())) == null ? InvalidInvoiceControl.newReIssueInvoice(invoiceDynamicObject, belongNo) : BusinessDataServiceHelper.loadSingle((Object)reIssueInvoice.getPkValue(), (String)"sim_vatinvoice"));
        return newReIssueInvoice;
    }

    private static DynamicObject newReIssueInvoice(DynamicObject invoiceDynamicObject, String belongNo) {
        String errorMsg = InvoiceCheckService.checkParams((DynamicObject)invoiceDynamicObject, (boolean)true);
        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
            throw new KDBizException(errorMsg);
        }
        DynamicObject newReIssueInvoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)invoiceDynamicObject, (DynamicObject)newReIssueInvoice);
        newReIssueInvoice.set("orgid", invoiceDynamicObject.get("orgid"));
        if (logger.isInfoEnabled()) {
            logger.info("copyNewReIssueInvoice_" + newReIssueInvoice.getString("salertaxno"));
        }
        if (StringUtils.isEmpty((CharSequence)invoiceDynamicObject.getString("billno"))) {
            newReIssueInvoice.set("billno", (Object)String.format("ZF_%d_%s", RequestContext.get().getOrgId(), UUID.getBatchNumber()));
        }
        String reOrderNo = UUID.next();
        newReIssueInvoice.set("orderno", (Object)reOrderNo);
        newReIssueInvoice.set("invoicecode", (Object)"");
        newReIssueInvoice.set("invoiceno", (Object)"");
        newReIssueInvoice.set("issuetime", (Object)"");
        newReIssueInvoice.set("invaliddate", (Object)"");
        newReIssueInvoice.set("issuestatus", (Object)IssueStatusEnum.none.getCode());
        newReIssueInvoice.set("batchbelong", (Object)belongNo);
        newReIssueInvoice.set("billdate", (Object)new Date());
        newReIssueInvoice.set("createtime", (Object)new Date());
        newReIssueInvoice.set("buyertype", (Object)"5");
        newReIssueInvoice.set("thirdserialno", (Object)"");
        try (TXHandle tx = TX.required();){
            try {
                ImcSaveServiceHelper.save((DynamicObject)newReIssueInvoice);
                invoiceDynamicObject.set("reorderno", (Object)reOrderNo);
                invoiceDynamicObject.set("reissuestatus", (Object)"2");
                ImcSaveServiceHelper.save((DynamicObject)invoiceDynamicObject);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        return newReIssueInvoice;
    }

    public static void checkInvalidData(DynamicObject invoiceDynamicObject) {
        if (!"6".equals(invoiceDynamicObject.getString("invoicestatus"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u4f5c\u5e9f\u72b6\u6001\u7684\u53d1\u7968\u8fdb\u884c\u91cd\u5f00", (String)"InvalidInvoiceControl_0", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if ("1".equals(invoiceDynamicObject.getString("abolishtype"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9'\u6570\u636e\u6765\u6e90'\u4e3a\u975e'\u7a7a\u767d\u4f5c\u5e9f'\u72b6\u6001\u7684\u6570\u636e\u8fdb\u884c\u91cd\u5f00!", (String)"InvalidInvoiceControl_1", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if ("1".equals(invoiceDynamicObject.get("reissuestatus"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801 %s \u5df2\u91cd\u5f00\uff0c\u4e0d\u53ef\u7ee7\u7eed\u91cd\u5f00", (String)"InvalidInvoiceControl_2", (String)"imc-sim-service", (Object[])new Object[0]), invoiceDynamicObject.getString("invoiceno")));
        }
        if (CallbackHelperUtil.isFromArIssueBill((String)invoiceDynamicObject.getString("systemsource"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5e94\u6536\u5f00\u7968\u5355\u5f00\u5177\u7684\u53d1\u7968\uff0c\u8bf7\u5230\u5e94\u6536\u5f00\u7968\u5355\u8fdb\u884c\u91cd\u5f00", (String)"InvalidInvoiceControl_3", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }

    public static void handlerInvalidSuccessOrErrorReturn(AbstractFormPlugin plugin, Object returnData) {
        JSONObject objMsg = JSONObject.parseObject((String)returnData.toString());
        Integer success = Integer.parseInt(objMsg.getString("success"));
        Integer defeat = Integer.parseInt(objMsg.getString("defeat"));
        if (defeat == 0) {
            ViewUtil.openNormalConfirm((AbstractFormPlugin)plugin, (String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5171\u4f5c\u5e9f%1$s\u5f20\u53d1\u7968\uff1a\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20", (String)"InvalidInvoiceControl_4", (String)"imc-sim-service", (Object[])new Object[0]), success, success - defeat, defeat), (String)MSG_INV_ABOLISH);
        } else {
            String errMsg = objMsg.getString("errmsg");
            ViewUtil.openConfirm((String)MSG_INV_ABOLISH, (String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5171\u4f5c\u5e9f%1$s\u5f20\u53d1\u7968\uff1a\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20", (String)"InvalidInvoiceControl_4", (String)"imc-sim-service", (Object[])new Object[0]), success, success - defeat, defeat), (AbstractFormPlugin)plugin, (String)ResManager.loadKDString((String)"\u53d6\u6d88", (String)"InvalidInvoiceControl_5", (String)"imc-sim-service", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u786e\u8ba4", (String)"InvalidInvoiceControl_6", (String)"imc-sim-service", (Object[])new Object[0]), (String)errMsg);
        }
    }
}

