/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.match;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.table.RedReasonEnum;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.dto.minusbill.MatchInvoiceDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillItemDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillMatchConfig;
import kd.imc.sim.common.dto.minusbill.QueryInvoiceDTO;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.service.WideInvoiceSevice;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractMinusBillMatchHelper {
    private static final Log logger = LogFactory.getLog(AbstractMinusBillMatchHelper.class);
    protected int pageSize = 100;
    protected int singleQuerySize = 50;
    protected int queryDetailType = 0;
    protected int wideQueryDetailType = 0;
    protected int queryTimes = 6;
    protected boolean detailLog = true;
    protected Set<String> matchInvoiceItems;
    protected boolean openThreadMatch = false;
    protected int corePoolSize = Runtime.getRuntime().availableProcessors();
    protected int maxPoolSize = this.corePoolSize << 1;
    protected MinusBillMatchConfig config;
    protected MinusBillDTO minusBillDTO;
    protected Map<String, Boolean> originalInvoiceMap;
    private static final String queryFields = String.join((CharSequence)",", "id", "orderno", "salertaxno", "invoicecode", "invoiceno", "issuetime", "invoiceamount", "invoicetype") + ",items.id as itemid,items.seq as itemseq,items.goodscode as goodscode,items.goodsname as goodsname,items.rowtype as rowtype,items.unitprice as unitprice,items.taxunitprice as taxunitprice,items.redprice as redprice,items.itemremainrednum as itemremainrednum,items.num as num,items.itemremainredamount as itemremainredamount,items.amount as amount,items.remaindiscountamount as remaindiscountamount,items.itemremainredtax as itemremainredtax,items.taxrate as taxrate,items.specification as specification,items.spbm as spbm,items.unit as unit";
    private static final String wideQueryFields = String.join((CharSequence)",", "invoiceid as id", "orderno", "salertaxno", "invoicecode", "invoiceno", "issuetime", "invoiceamount", "invoicetype", "id as itemid", "itemseq", "goodscode", "goodsname", "rowtype", "unitprice", "taxunitprice", "redprice", "itemremainrednum", "num", "itemremainredamount", "amount", "remaindiscountamount", "itemremainredtax", "taxrate", "specification", "spbm", "unit");

    protected void setParam(MinusBillDTO billDTO) {
        this.minusBillDTO = billDTO;
        this.originalInvoiceMap = new HashMap<String, Boolean>(10);
        this.config = this.minusBillDTO.getConfig();
        String randomEq = ImcConfigUtil.getValue((String)"sim_minusbill", (String)"param");
        if (!StringUtils.isEmpty((CharSequence)randomEq)) {
            try {
                JSONObject obj = JSONObject.parseObject((String)randomEq);
                this.pageSize = BigDecimalUtil.transDecimal((Object)obj.getString("pageSize")).intValue();
                this.detailLog = "1".equals(obj.getString("detailLog"));
                this.singleQuerySize = BigDecimalUtil.transDecimal((Object)obj.getString("singleQuerySize")).intValue();
                this.queryDetailType = BigDecimalUtil.transDecimal((Object)obj.getString("queryDetailType")).intValue();
                this.wideQueryDetailType = BigDecimalUtil.transDecimal((Object)obj.getString("wideQueryDetailType")).intValue();
                this.queryTimes = BigDecimalUtil.transDecimal((Object)obj.getString("queryTimes")).intValue();
                String openThreadMatchTaxNo = obj.getString("openThreadMatch");
                boolean bl = this.openThreadMatch = StringUtils.isNotBlank((CharSequence)openThreadMatchTaxNo) && openThreadMatchTaxNo.contains(billDTO.getSalerTaxNo());
                if (this.openThreadMatch) {
                    int localMaxPoolSize;
                    int locakCorePoolSize = BigDecimalUtil.transDecimal((Object)obj.getString("corePoolSize")).intValue();
                    if (locakCorePoolSize != 0) {
                        this.corePoolSize = locakCorePoolSize;
                    }
                    if ((localMaxPoolSize = BigDecimalUtil.transDecimal((Object)obj.getString("maxPoolSize")).intValue()) != 0) {
                        this.maxPoolSize = localMaxPoolSize;
                    }
                }
                if (this.pageSize < 1) {
                    this.pageSize = 100;
                }
                if (1 == this.queryDetailType || this.wideQueryDetailType == 1) {
                    this.pageSize *= 5;
                }
                if (this.singleQuerySize < 1) {
                    this.singleQuerySize = 50;
                }
                if (this.queryTimes < 1) {
                    this.queryTimes = 6;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void check(MinusBillDTO minusBillDTO) {
        if (StringUtils.isEmpty((CharSequence)minusBillDTO.getSalerTaxNo())) {
            throw new MsgException("4001", ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"MinusBillMatchHelper_2", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)minusBillDTO.getBuyerTaxNo()) && StringUtils.isEmpty((CharSequence)minusBillDTO.getBuyerName())) {
            throw new MsgException("4003", ResManager.loadKDString((String)"\u8d2d\u65b9\u7a0e\u53f7\u4e0e\u8d2d\u65b9\u540d\u79f0\u4e0d\u80fd\u5168\u4e3a\u7a7a", (String)"MinusBillMatchHelper_4", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (minusBillDTO.getItems() == null || minusBillDTO.getItems().isEmpty()) {
            throw new MsgException("4004", ResManager.loadKDString((String)"\u660e\u7ec6\u884c\u4e0d\u80fd\u4e3a\u7a7a", (String)"MinusBillMatchHelper_5", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (this.config == null) {
            throw new MsgException("4010", ResManager.loadKDString((String)"\u89c4\u5219\u914d\u7f6e\u4e3a\u7a7a", (String)"MinusBillMatchHelper_0", (String)"imc-sim-service", (Object[])new Object[0]));
        }
    }

    protected String[] getBlueInvoiceType(MinusBillDTO minusBillDTO, MinusBillMatchConfig config) {
        if (InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode().equals(minusBillDTO.getInvoiceType())) {
            return new String[]{InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode()};
        }
        if (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(minusBillDTO.getInvoiceType())) {
            return new String[]{InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode()};
        }
        if (InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode().equals(minusBillDTO.getInvoiceType())) {
            return new String[]{InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode(), InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode()};
        }
        if (InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(minusBillDTO.getInvoiceType())) {
            return new String[]{InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode(), InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode()};
        }
        if (InvoiceType.ALL_E_SPECIAL.getTypeCode().equals(minusBillDTO.getInvoiceType())) {
            if (config.getMatchSkp().booleanValue()) {
                return new String[]{InvoiceType.ALL_E_SPECIAL.getTypeCode(), InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode(), InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode()};
            }
            return new String[]{InvoiceType.ALL_E_SPECIAL.getTypeCode()};
        }
        if (InvoiceType.ALL_E_NORMAL.getTypeCode().equals(minusBillDTO.getInvoiceType())) {
            if (config.getMatchSkp().booleanValue()) {
                return new String[]{InvoiceType.ALL_E_NORMAL.getTypeCode(), InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode(), InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode()};
            }
            return new String[]{InvoiceType.ALL_E_NORMAL.getTypeCode()};
        }
        return new String[]{minusBillDTO.getInvoiceType()};
    }

    protected Pair<Date, Date> getInvoceDate(Date invoiceDate) {
        int start = Math.abs(this.config.getStart());
        int end = Math.abs(this.config.getEnd());
        if ("month".equals(this.config.getTimeType())) {
            Date firstDate = DateUtils.trunc((Date)DateUtils.getFirstDateOfMonth((Date)invoiceDate));
            Date startDate = DateUtils.addMonth((Date)firstDate, (int)(1 - start));
            Date endDate = DateUtils.addMonth((Date)firstDate, (int)(1 - end));
            return Pair.of((Object)endDate, (Object)startDate);
        }
        Date startDate = DateUtils.trunc((Date)DateUtils.addDay((Date)invoiceDate, (int)(1 - start)));
        Date endDate = DateUtils.trunc((Date)DateUtils.addDay((Date)invoiceDate, (int)(1 - end)));
        return Pair.of((Object)endDate, (Object)startDate);
    }

    protected String getOrderBy() {
        switch (this.config.getBlueOrder()) {
            case "timefar": {
                return "issuetime ";
            }
            case "timenear": {
                return "issuetime desc ";
            }
            case "amountsmall": {
                return "items.amount";
            }
            case "amountbig": {
                return "items.amount desc";
            }
        }
        return "";
    }

    protected Pair<BigDecimal, BigDecimal> getUnitPriceAffect(BigDecimal unitPrice) {
        if (this.config.getUnitPriceAffect() == null) {
            return null;
        }
        if ("none".equals(this.config.getUnitPriceAffectType())) {
            return null;
        }
        if ("percent".equals(this.config.getUnitPriceAffectType())) {
            BigDecimal hundred = new BigDecimal("100");
            BigDecimal maxRate = this.config.getUnitPriceAffect().abs().add(hundred).divide(hundred, 100, 4);
            BigDecimal minRate = hundred.subtract(this.config.getUnitPriceAffect().abs()).divide(hundred, 100, 4);
            return Pair.of((Object)unitPrice.multiply(minRate), (Object)unitPrice.multiply(maxRate));
        }
        return Pair.of((Object)unitPrice.subtract(this.config.getUnitPriceAffect().abs()), (Object)unitPrice.add(this.config.getUnitPriceAffect().abs()));
    }

    protected DataSet queryInvoice(ORM orm, int page, String order, QFilter itemFilter, boolean isQueryWideTable) {
        String orderBy;
        int from = (page - 1) * this.pageSize;
        String table = "sim_vatinvoice";
        String fields = queryFields;
        if (isQueryWideTable) {
            orderBy = StringUtils.isEmpty((CharSequence)order) ? "id" : order.replaceAll("items.", "") + ",id";
            table = WideInvoiceSevice.WIDE_INVOICE;
            fields = wideQueryFields;
        } else {
            orderBy = StringUtils.isEmpty((CharSequence)order) ? "items.id" : order + ",items.id";
        }
        return orm.queryDataSet("MinusBill.sim_vatinvoice", table, fields, itemFilter.toArray(), orderBy, from, this.pageSize);
    }

    protected DataSet queryInvoiceHead(ORM orm, String orderBy, int page, QFilter filter, boolean isQueryWideTable) {
        if (StringUtils.isBlank((CharSequence)orderBy) || !orderBy.contains("issuetime")) {
            orderBy = "id";
        }
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        if (isQueryWideTable) {
            qFilter = new QFilter("issuetype", "=", (Object)IssueType.BLUE_INVOICE.getTypeCode());
        }
        return orm.queryDataSet("MinusBill.sim_vatinvoice_head", "sim_vatinvoice", "id", new QFilter[]{filter, qFilter}, orderBy, (page - 1) * this.pageSize, this.pageSize);
    }

    protected DataSet queryInvoiceDetail(ORM orm, String orderBy, Set<Object> invoiceIdSet, QFilter itemFilter, boolean isQueryWideTable) {
        QFilter idFilter = new QFilter("salertaxno", "=", (Object)this.minusBillDTO.getSalerTaxNo());
        String tableId = "sim_vatinvoice";
        String field = queryFields;
        if (isQueryWideTable) {
            tableId = WideInvoiceSevice.WIDE_INVOICE;
            field = wideQueryFields;
            idFilter.and("buyertaxno", "=", (Object)this.minusBillDTO.getBuyerTaxNo());
            idFilter.and("invoiceid", "in", invoiceIdSet);
        } else {
            idFilter.and("id", "in", invoiceIdSet);
        }
        if (StringUtils.isNotBlank((CharSequence)orderBy) && orderBy.contains("amount")) {
            return orm.queryDataSet("MinusBill.sim_vatinvoice_detail1", tableId, field, new QFilter[]{idFilter, itemFilter}, orderBy);
        }
        return orm.queryDataSet("MinusBill.sim_vatinvoice_detail2", tableId, field, new QFilter[]{idFilter, itemFilter});
    }

    protected QueryInvoiceDTO createQueryInvoiceDTO(DynamicObject obj, boolean salesDiscount) {
        QueryInvoiceDTO invoiceDto = new QueryInvoiceDTO();
        invoiceDto.setInvoiceid(Long.valueOf(obj.getLong("id")));
        invoiceDto.setOrderno(obj.getString("orderno"));
        invoiceDto.setInvoicecode(StringUtils.trimToEmpty((String)obj.getString("invoicecode")));
        invoiceDto.setInvoiceno(StringUtils.trimToEmpty((String)obj.getString("invoiceno")));
        invoiceDto.setIssueTime(obj.getDate("issuetime"));
        invoiceDto.setInvoiceAmount(obj.getBigDecimal("invoiceamount"));
        invoiceDto.setItemid(Long.valueOf(obj.getLong("itemid")));
        invoiceDto.setItemseq(Long.valueOf(obj.getLong("itemseq")));
        invoiceDto.setGoodscode(obj.getString("goodscode"));
        invoiceDto.setGoodsname(obj.getString("goodsname"));
        invoiceDto.setTaxrate(obj.getString("taxrate"));
        invoiceDto.setSpecification(obj.getString("specification"));
        invoiceDto.setUnit(obj.getString("unit"));
        invoiceDto.setSpbm(obj.getString("spbm"));
        invoiceDto.setItemCanRedAmount(obj.getBigDecimal("itemremainredamount"));
        invoiceDto.setItemCanRedTax(obj.getBigDecimal("itemremainredtax"));
        if (MathUtils.isNullOrZero((BigDecimal)obj.getBigDecimal("itemremainrednum")) && !MathUtils.isNullOrZero((BigDecimal)obj.getBigDecimal("unitprice")) && obj.getBigDecimal("itemremainredamount").compareTo(obj.getBigDecimal("amount")) == 0) {
            invoiceDto.setItemCanRedNum(obj.getBigDecimal("num"));
        } else {
            invoiceDto.setItemCanRedNum(obj.getBigDecimal("itemremainrednum"));
        }
        if (!MathUtils.isNullOrZero((BigDecimal)invoiceDto.getItemCanRedNum())) {
            BigDecimal canRedPrice = obj.getBigDecimal("redprice");
            if (!MathUtils.isNullOrZero((BigDecimal)canRedPrice)) {
                invoiceDto.setUnitprice(canRedPrice);
            } else {
                BigDecimal calcAmount;
                invoiceDto.setUnitprice(obj.getBigDecimal("unitprice"));
                if ("2".equals(obj.getString("rowtype"))) {
                    invoiceDto.setUnitprice(PriceHelper.calcPriceOrNum((BigDecimal)invoiceDto.getItemCanRedAmount(), (BigDecimal)invoiceDto.getItemCanRedNum(), (boolean)true));
                } else if (invoiceDto.getItemCanRedAmount().setScale(2, 4).compareTo(obj.getBigDecimal("amount").setScale(2, 4)) != 0 && BigDecimalUtil.compare((BigDecimal)(calcAmount = invoiceDto.getItemCanRedNum().multiply(obj.getBigDecimal("unitprice"))), (BigDecimal)invoiceDto.getItemCanRedAmount(), (BigDecimal)InvoiceConstant.DIFF_01)) {
                    invoiceDto.setUnitprice(PriceHelper.calcPriceOrNum((BigDecimal)invoiceDto.getItemCanRedAmount(), (BigDecimal)invoiceDto.getItemCanRedNum(), (boolean)true));
                }
            }
            invoiceDto.setTaxunitprice(PriceHelper.calcPriceOrNum((BigDecimal)invoiceDto.getItemCanRedAmount().add(invoiceDto.getItemCanRedTax()), (BigDecimal)invoiceDto.getItemCanRedNum(), (boolean)true));
        }
        invoiceDto.setItemCanRedAmountOrNum(obj.getBigDecimal("itemremainredamount"));
        if (salesDiscount) {
            if (!MathUtils.isNullOrZero((BigDecimal)obj.getBigDecimal("remaindiscountamount")) && obj.getBigDecimal("remaindiscountamount").compareTo(obj.getBigDecimal("itemremainredamount")) <= 0) {
                BigDecimal calcTax;
                invoiceDto.setItemCanRedAmountOrNum(obj.getBigDecimal(this.config.getMatchAmountField()));
                if ("remaindiscountamount".equals(this.config.getMatchAmountField()) && (calcTax = TaxCalcUtil.calTax((BigDecimal)obj.getBigDecimal("remaindiscountamount"), (BigDecimal)BigDecimal.ZERO, (String)obj.getString("taxrate"), (boolean)false)).compareTo(obj.getBigDecimal("itemremainredtax")) <= 0) {
                    invoiceDto.setItemCanRedTax(calcTax);
                }
            }
            invoiceDto.setItemCanRedNum(BigDecimal.ZERO);
            invoiceDto.setUnitprice(BigDecimal.ZERO);
            invoiceDto.setTaxunitprice(BigDecimal.ZERO);
        }
        if (!this.config.getAmountStandard().booleanValue()) {
            invoiceDto.setItemCanRedAmountOrNum(invoiceDto.getItemCanRedNum());
        }
        invoiceDto.setRemainMatchAmountOrNum(invoiceDto.getItemCanRedAmountOrNum());
        return invoiceDto;
    }

    protected BigDecimal recursionAmtsCut(BigDecimal amounts, BigDecimal price, int scale, int maxPointLength) {
        if (maxPointLength <= scale) {
            return amounts.divide(price, maxPointLength, 4).stripTrailingZeros();
        }
        BigDecimal amts = amounts.divide(price, scale, 4);
        if (amts.compareTo(BigDecimal.ZERO) == 0) {
            return amounts.divide(price, maxPointLength, 4).stripTrailingZeros();
        }
        if (BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)amts, (BigDecimal)price), (BigDecimal)amounts, (BigDecimal)InvoiceConstant.DIFF_01)) {
            return this.recursionAmtsCut(amounts, price, scale + 1, maxPointLength);
        }
        return amts;
    }

    protected MatchInvoiceDTO createMatchInvoiceDTO(MinusBillItemDTO matchBillItem, QueryInvoiceDTO invoiceDto, BigDecimal matchAmountOrNum, boolean isQueryWideTable) {
        MatchInvoiceDTO matchInvoice = new MatchInvoiceDTO();
        matchInvoice.setInvoiceid(invoiceDto.getInvoiceid());
        matchInvoice.setInvoicecode(invoiceDto.getInvoicecode());
        matchInvoice.setInvoiceno(invoiceDto.getInvoiceno());
        matchInvoice.setItemid(invoiceDto.getItemid());
        matchInvoice.setOrderno(invoiceDto.getOrderno());
        matchInvoice.setItemUnitprice(invoiceDto.getUnitprice());
        matchInvoice.setItemTaxUnitprice(invoiceDto.getTaxunitprice());
        matchInvoice.setGoodsName(invoiceDto.getGoodsname());
        matchInvoice.setSpecification(invoiceDto.getSpecification());
        matchInvoice.setUnit(invoiceDto.getUnit());
        matchInvoice.setSpbm(invoiceDto.getSpbm());
        if (this.config.getAmountStandard().booleanValue()) {
            matchInvoice.setItemAmount(matchAmountOrNum);
        } else {
            if (matchAmountOrNum.compareTo(invoiceDto.getItemCanRedNum()) == 0) {
                matchInvoice.setItemAmount(invoiceDto.getItemCanRedAmount());
            } else {
                matchInvoice.setItemAmount(matchAmountOrNum.multiply(invoiceDto.getUnitprice()).setScale(2, 4));
            }
            matchInvoice.setItemNum(matchAmountOrNum);
        }
        BigDecimal calcTax = matchInvoice.getItemAmount().multiply(BigDecimalUtil.transDecimal((Object)invoiceDto.getTaxrate())).setScale(2, 4);
        BigDecimal remainMatchTax = invoiceDto.getItemCanRedTax().subtract(invoiceDto.getCurrentMatchTax());
        matchInvoice.setItemTax(calcTax.compareTo(remainMatchTax) > 0 ? remainMatchTax : calcTax);
        if (this.config.getAmountStandard().booleanValue()) {
            this.setItemTaxAndNumByAmountStandard(matchInvoice, invoiceDto, calcTax);
            if (!MathUtils.isNullOrZero((BigDecimal)matchInvoice.getItemNum()) && BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)matchInvoice.getItemNum(), (BigDecimal)matchInvoice.getItemUnitprice()), (BigDecimal)matchInvoice.getItemAmount(), (BigDecimal)InvoiceConstant.DIFF_01)) {
                logger.info(String.format("\u8bbe\u7f6e\u7684\u5355\u4ef7\uff0c\u6570\u91cf\u4e0e\u91d1\u989d\u7684\u5dee\u8d85\u8fc70.01\uff0c\u5339\u914d\u5355\u660e\u7ec6[%s]\uff0c\u539f\u84dd\u7968\u660e\u7ec6[%s]\uff0c\u6784\u5efa\u7684\u5339\u914d\u53d1\u7968\u660e\u7ec6[%s]", SerializationUtils.toJsonString((Object)matchBillItem), SerializationUtils.toJsonString((Object)invoiceDto), SerializationUtils.toJsonString((Object)matchInvoice)));
                return null;
            }
        } else if (matchAmountOrNum.compareTo(invoiceDto.getItemCanRedNum()) == 0) {
            matchInvoice.setItemTax(invoiceDto.getItemCanRedTax());
        }
        if (matchInvoice.getItemTax().compareTo(BigDecimal.ZERO) < 0) {
            matchInvoice.setItemTax(BigDecimal.ZERO);
        }
        if (this.config.getAmountStandard().booleanValue() && this.checkCurrentMatchTaxOutOfInvoiceRemainTax(matchBillItem, invoiceDto, matchInvoice)) {
            return null;
        }
        if (!this.checkCurrentMatchInRange(invoiceDto, matchInvoice)) {
            return null;
        }
        String invoiceCode = invoiceDto.getInvoicecode();
        String invoiceNo = invoiceDto.getInvoiceno();
        Boolean startZero = this.originalInvoiceMap.get(invoiceCode + "\u25cf\u25c6\u25a0" + invoiceNo);
        if (startZero == null) {
            QFilter qFilter = new QFilter("salertaxno", "=", (Object)this.minusBillDTO.getSalerTaxNo());
            if (isQueryWideTable) {
                qFilter.and("longnumber", "=", (Object)(invoiceCode + invoiceNo));
                qFilter.and("itemseq", "=", (Object)0);
                startZero = QueryServiceHelper.exists((String)WideInvoiceSevice.WIDE_INVOICE, (QFilter[])qFilter.toArray());
            } else {
                qFilter.and(InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoiceCode, (String)invoiceNo));
                qFilter.and("items.seq", "=", (Object)0);
                startZero = QueryServiceHelper.exists((String)"sim_vatinvoice", (QFilter[])qFilter.toArray());
            }
            this.originalInvoiceMap.put(invoiceCode + "\u25cf\u25c6\u25a0" + invoiceNo, startZero);
        }
        matchInvoice.setItemseq(invoiceDto.getItemseq());
        if (startZero.booleanValue()) {
            matchInvoice.setItemseq(Long.valueOf(invoiceDto.getItemseq() + 1L));
        }
        return matchInvoice;
    }

    private void setItemTaxAndNumByAmountStandard(MatchInvoiceDTO matchInvoice, QueryInvoiceDTO invoiceDto, BigDecimal calcTax) {
        BigDecimal remainMatchTax = invoiceDto.getItemCanRedTax().subtract(invoiceDto.getCurrentMatchTax());
        if (calcTax.subtract(remainMatchTax).setScale(2, 4).abs().compareTo(InvoiceConstant.DIFFF_06) <= 0) {
            matchInvoice.setItemTax(remainMatchTax);
        }
        if (MathUtils.isNullOrZero((BigDecimal)matchInvoice.getItemUnitprice())) {
            return;
        }
        BigDecimal remainMatchAmount = invoiceDto.getItemCanRedAmountOrNum().subtract(invoiceDto.getCurrentMatchAmount());
        BigDecimal remainMatchNum = invoiceDto.getItemCanRedNum().subtract(invoiceDto.getCurrentMatchNum());
        if (matchInvoice.getItemAmount().compareTo(remainMatchAmount) == 0) {
            matchInvoice.setItemNum(remainMatchNum);
            return;
        }
        BigDecimal num = this.recursionAmtsCut(matchInvoice.getItemAmount(), matchInvoice.getItemUnitprice(), this.config.getQuantityLimit(), UnitPriceHelper.getMaxPointLength((BigDecimal)matchInvoice.getItemAmount(), (BigDecimal)matchInvoice.getItemUnitprice()));
        if (num.abs().compareTo(remainMatchNum) > 0) {
            matchInvoice.setItemNum(remainMatchNum);
        } else {
            matchInvoice.setItemNum(num);
        }
    }

    private boolean checkCurrentMatchTaxOutOfInvoiceRemainTax(MinusBillItemDTO matchBillItem, QueryInvoiceDTO invoiceDto, MatchInvoiceDTO matchInvoice) {
        boolean isBillTaxLess;
        boolean isItemMatchSuccess;
        BigDecimal matchAmountOrNum;
        BigDecimal compareAmountOrNum;
        if (this.config.getAmountStandard().booleanValue()) {
            compareAmountOrNum = matchBillItem.getAmount();
            matchAmountOrNum = matchBillItem.getMatchAmountOrNum().abs().add(matchInvoice.getItemAmount());
        } else {
            compareAmountOrNum = matchBillItem.getNum();
            matchAmountOrNum = matchBillItem.getMatchAmountOrNum().abs().add(matchInvoice.getItemNum());
        }
        boolean bl = isItemMatchSuccess = compareAmountOrNum.abs().compareTo(matchAmountOrNum) == 0;
        if (isItemMatchSuccess) {
            BigDecimal invoiceRemainTax;
            BigDecimal remainTax = matchBillItem.getTax().add(matchBillItem.getMatchTax()).abs();
            if (remainTax.compareTo(invoiceRemainTax = invoiceDto.getItemCanRedTax().subtract(invoiceDto.getCurrentMatchTax())) > 0) {
                if (this.detailLog) {
                    logger.info(String.format("\u8ba1\u7b97\u51fa\u7684\u7a0e\u989d\u5927\u4e8e\u539f\u84dd\u7968\u5bf9\u5e94\u884c\u5269\u4f59\u53ef\u4f7f\u7528\u7684\u7a0e\u989d\uff0c\u5339\u914d\u5355\u660e\u7ec6[%s]\uff0c\u539f\u84dd\u7968\u660e\u7ec6[%s]\uff0c\u6784\u5efa\u7684\u5339\u914d\u53d1\u7968\u660e\u7ec6[%s]", SerializationUtils.toJsonString((Object)matchBillItem), SerializationUtils.toJsonString((Object)invoiceDto), SerializationUtils.toJsonString((Object)matchInvoice)));
                }
                return true;
            }
            BigDecimal calcTax = TaxCalcUtil.calTax((BigDecimal)matchInvoice.getItemAmount(), (BigDecimal)BigDecimal.ZERO, (String)invoiceDto.getTaxrate(), (boolean)false, (int)6);
            boolean isMoreThan006 = BigDecimalUtil.compare((BigDecimal)calcTax, (BigDecimal)remainTax, (BigDecimal)InvoiceConstant.DIFFF_06);
            if (isMoreThan006) {
                if (this.detailLog) {
                    logger.info(String.format("\u8bbe\u7f6e\u7684\u7a0e\u989d\u4e0e\u8ba1\u7b97\u7684\u7a0e\u989d\u7684\u5c3e\u5dee\u8d85\u8fc70.06\uff0c\u5339\u914d\u5355\u660e\u7ec6[%s]\uff0c\u539f\u84dd\u7968\u660e\u7ec6[%s]\uff0c\u6784\u5efa\u7684\u5339\u914d\u53d1\u7968\u660e\u7ec6[%s]", SerializationUtils.toJsonString((Object)matchBillItem), SerializationUtils.toJsonString((Object)invoiceDto), SerializationUtils.toJsonString((Object)matchInvoice)));
                }
                return true;
            }
            matchInvoice.setItemTax(remainTax);
            return false;
        }
        BigDecimal matchTax = matchBillItem.getMatchTax().abs().add(matchInvoice.getItemTax());
        boolean bl2 = isBillTaxLess = matchBillItem.getTax().abs().compareTo(matchTax) <= 0;
        if (isBillTaxLess) {
            logger.info(String.format("\u8be5\u884c\u5339\u914d\u5355\u660e\u7ec6\u7a0e\u989d\u5b8c\u5168\u5339\u914d\uff0c\u4f46\u662f\u91d1\u989d\u672a\u5339\u914d\u5b8c\uff0c\u5339\u914d\u5355\u660e\u7ec6[%s]\uff0c\u539f\u84dd\u7968\u660e\u7ec6[%s]\uff0c\u6784\u5efa\u7684\u5339\u914d\u53d1\u7968\u660e\u7ec6[%s]", SerializationUtils.toJsonString((Object)matchBillItem), SerializationUtils.toJsonString((Object)invoiceDto), SerializationUtils.toJsonString((Object)matchInvoice)));
        }
        return isBillTaxLess;
    }

    private boolean checkCurrentMatchInRange(QueryInvoiceDTO invoiceDto, MatchInvoiceDTO matchDto) {
        if (invoiceDto.getCurrentMatchAmount().compareTo(BigDecimal.ZERO) == 0) {
            return true;
        }
        BigDecimal afterMatchAmount = invoiceDto.getCurrentMatchAmount().add(matchDto.getItemAmount());
        BigDecimal calcTax = TaxCalcUtil.calTax((BigDecimal)afterMatchAmount, (BigDecimal)BigDecimal.ZERO, (String)invoiceDto.getTaxrate(), (boolean)false, (int)6);
        boolean isMoreThan006 = BigDecimalUtil.compare((BigDecimal)calcTax, (BigDecimal)invoiceDto.getCurrentMatchTax().add(matchDto.getItemTax()), (BigDecimal)InvoiceConstant.DIFFF_06);
        if (isMoreThan006) {
            if (this.detailLog) {
                logger.info(String.format("\u539f\u84dd\u7968\u88ab\u591a\u884c\u5339\u914d\u540e\u7d2f\u52a0\u7a0e\u989d\u8d85\u8fc70.06\u5c3e\u5dee\uff0c\u539f\u84dd\u7968\u660e\u7ec6[%s]\uff0c\u6784\u5efa\u7684\u5339\u914d\u53d1\u7968\u660e\u7ec6[%s]", SerializationUtils.toJsonString((Object)invoiceDto), SerializationUtils.toJsonString((Object)matchDto)));
            }
            return false;
        }
        boolean salesDiscount = RedReasonEnum.SALES_DISCOUNTS.getTypeCode().equals(this.minusBillDTO.getRedreason());
        if (salesDiscount || !this.config.getAmountStandard().booleanValue()) {
            return true;
        }
        BigDecimal afterMatchNum = invoiceDto.getCurrentMatchNum().add(matchDto.getItemNum());
        if (MathUtils.isNullOrZero((BigDecimal)afterMatchNum) || MathUtils.isNullOrZero((BigDecimal)invoiceDto.getUnitprice())) {
            return true;
        }
        if (BigDecimalUtil.compare((BigDecimal)afterMatchNum.multiply(invoiceDto.getUnitprice()), (BigDecimal)afterMatchAmount, (BigDecimal)InvoiceConstant.DIFF_01)) {
            BigDecimal num = this.recursionAmtsCut(afterMatchAmount, invoiceDto.getUnitprice(), this.config.getQuantityLimit(), UnitPriceHelper.getMaxPointLength((BigDecimal)afterMatchAmount, (BigDecimal)invoiceDto.getUnitprice()));
            if (num.abs().compareTo(invoiceDto.getItemCanRedNum()) > 0) {
                if (this.detailLog) {
                    logger.info(String.format("\u539f\u84dd\u7968\u88ab\u591a\u884c\u5339\u914d\u540e\u6570\u91cf\u8ba1\u7b97\u8d85\u8fc70.01\u5c3e\u5dee\uff0c\u539f\u84dd\u7968\u660e\u7ec6[%s]\uff0c\u6784\u5efa\u7684\u5339\u914d\u53d1\u7968\u660e\u7ec6[%s]", SerializationUtils.toJsonString((Object)invoiceDto), SerializationUtils.toJsonString((Object)matchDto)));
                }
                return false;
            }
            if (this.detailLog) {
                logger.info(String.format("\u91cd\u65b0\u8ba1\u7b97\u540e\u7684\u6570\u91cf\u4e3a[%s]\uff0c\u539f\u84dd\u7968\u660e\u7ec6[%s]\uff0c\u6784\u5efa\u7684\u5339\u914d\u53d1\u7968\u660e\u7ec6[%s]", num.subtract(invoiceDto.getCurrentMatchNum()), SerializationUtils.toJsonString((Object)invoiceDto), SerializationUtils.toJsonString((Object)matchDto)));
            }
            matchDto.setItemNum(num.subtract(invoiceDto.getCurrentMatchNum()));
        }
        return true;
    }
}

