/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.match;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.table.RemarkSettingConstant;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.SchemeHelper;
import kd.imc.bdm.common.model.DrawerInfo;
import kd.imc.bdm.common.model.DrawerStrategyDTO;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.formplugin.match.ConditionMatchHelper;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.lang3.StringUtils;

public class BillMatchHelper {
    private static final Log logger = LogFactory.getLog(BillMatchHelper.class);
    private static final String[] ctrlStrategy = new String[]{"7", "2", "1", "6", "5"};

    @SdkDeprecated
    public void matchAll(List<DynamicObject> bills, String source) {
        Map<Long, List<DynamicObject>> orgBillMap = bills.stream().collect(Collectors.groupingBy(k -> DynamicObjectUtil.getDynamicObjectLongValue((Object)k.get("orgid"))));
        orgBillMap.forEach((orgId, billList) -> {
            DynamicObject[] remarkArr = this.getRemarkArr((Long)orgId);
            Map<Object, List<DynamicObject>> remarkSchemeMap = this.getRemarkSchemeMap(remarkArr);
            if (remarkArr.length != 0) {
                for (DynamicObject bill : billList) {
                    this.matchRemark(bill, remarkArr, remarkSchemeMap);
                }
            }
        });
        this.matchSplitOrMergeRule(orgBillMap, source);
    }

    public DynamicObject[] getRemarkArr(Long orgId) {
        return BusinessDataServiceHelper.load((String)"bdm_remark", (String)String.join((CharSequence)",", "filter_tag", "separator", "namerule", "remarktype", "splittype"), (QFilter[])new QFilter("org", "=", (Object)orgId).toArray(), (String)"createdate desc");
    }

    public Map<Object, List<DynamicObject>> getRemarkSchemeMap(DynamicObject[] remarkArr) {
        if (remarkArr.length == 0) {
            return new HashMap<Object, List<DynamicObject>>(1);
        }
        QFilter remarkSchemeFilter = new QFilter("remarkid", "in", (Object)Stream.of(remarkArr).map(DataEntityBase::getPkValue).toArray()).and("selected", "=", (Object)"1");
        DynamicObject[] remarkSchemeArr = BusinessDataServiceHelper.load((String)"bdm_remark_select_setting", (String)String.join((CharSequence)",", "remarktype", "selectkey", "selectalias", "remarkid"), (QFilter[])remarkSchemeFilter.toArray());
        return Stream.of(remarkSchemeArr).collect(Collectors.groupingBy(k -> k.get("remarkid")));
    }

    public void matchRemark(DynamicObject bill, DynamicObject[] remarkArr, Map<Object, List<DynamicObject>> remarkSchemeMap) {
        boolean setBillRemark = false;
        boolean setItemRemark = false;
        for (DynamicObject remark : remarkArr) {
            if (!ConditionMatchHelper.verify((String)remark.getString("filter_tag"), (DynamicObject)bill)) continue;
            String[] fields = remark.getString("namerule").split(",");
            String separator = remark.getString("separator");
            if (StringUtils.isNotBlank((CharSequence)separator) && "\u6362\u884c".equals(separator)) {
                separator = System.lineSeparator();
            }
            if (RemarkSettingConstant.RemarkType.INVOICE_REMARK.getValue().equals(remark.getString("remarktype"))) {
                if (setBillRemark) continue;
                setBillRemark = true;
                String remarkStr = BillMatchHelper.getRemarkStr(bill, remarkSchemeMap.get(remark.getPkValue()), bill.getString("invoiceremark"), fields, separator, remark.getString("splittype"), 230);
                bill.set("invoiceremark", (Object)remarkStr);
                continue;
            }
            if (!setItemRemark) {
                setItemRemark = true;
                DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
                for (DynamicObject item : items) {
                    item.set("remark", (Object)BillMatchHelper.getRemarkStr(item, remarkSchemeMap.get(remark.getPkValue()), item.getString("remark"), fields, separator, remark.getString("splittype"), 200));
                }
            }
            if (setBillRemark) break;
        }
    }

    private static String getRemarkStr(DynamicObject bill, List<DynamicObject> remarkSelectList, String originalRemark, String[] fields, String separator, String splitType, int len) {
        boolean bl;
        Map<Object, Object> remarkSelectMap;
        ArrayList remarkList = Lists.newArrayListWithExpectedSize((int)fields.length);
        if (StringUtils.isNotBlank((CharSequence)originalRemark)) {
            remarkList.add(originalRemark);
        }
        if (CollectionUtils.isEmpty(remarkSelectList)) {
            remarkSelectMap = new HashMap(1);
        } else {
            String string = "sim_original_bill".equals(bill.getDynamicObjectType().getName()) ? RemarkSettingConstant.RemarkType.INVOICE_REMARK.getValue() : RemarkSettingConstant.RemarkType.LINE_REMARK.getValue();
            remarkSelectMap = remarkSelectList.stream().filter(select -> string.equals(select.getString("remarktype"))).collect(Collectors.toMap(k -> k.getString("selectkey"), v -> v.getString("selectalias"), (v1, v2) -> v2));
        }
        for (String field : fields) {
            String remarkValue = BillMatchHelper.getRemarkValue(bill.get(field), (String)remarkSelectMap.get(field));
            if (!StringUtils.isNotBlank((CharSequence)remarkValue)) continue;
            remarkList.add(remarkValue);
        }
        if (separator.equals("\u6362\u884c")) {
            separator = System.lineSeparator();
        }
        boolean bl2 = false;
        try {
            String invoiceType = bill.getString("invoicetype");
            String isElePaperStr = bill.getString("iselepaper");
            bl = InvoiceUtils.isAllEInvoice((Object)invoiceType) || "1".equals(isElePaperStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        len = bl ? 450 : 230;
        if (RemarkSettingConstant.SplitType.SPLIT_BY_LENGTH.getValue().equals(splitType)) {
            if (bl) {
                InvoiceUtils.cutRemarkChar((String)String.join((CharSequence)separator, remarkList), (int)len);
            } else {
                return GBKUtils.cutGBKString((String)String.join((CharSequence)separator, remarkList), (int)len);
            }
        }
        if (bl) {
            while (String.join((CharSequence)separator, remarkList).length() > len) {
                if (remarkList.size() != 1) {
                    remarkList.remove(remarkList.size() - 1);
                    continue;
                }
                remarkList.set(0, InvoiceUtils.cutRemarkChar((String)((String)remarkList.get(0)), (int)len));
            }
        } else {
            while (GBKUtils.getGBKLength((String)String.join((CharSequence)separator, remarkList)) > len) {
                if (remarkList.size() != 1) {
                    remarkList.remove(remarkList.size() - 1);
                    continue;
                }
                remarkList.set(0, GBKUtils.cutGBKString((String)((String)remarkList.get(0)), (int)len));
            }
        }
        return String.join((CharSequence)separator, remarkList);
    }

    private static String getRemarkValue(Object value, String selectAlias) {
        String val;
        if (value == null) {
            return "";
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigVal = (BigDecimal)value;
            int scale = (bigVal = bigVal.stripTrailingZeros()).scale();
            if (scale < 2) {
                bigVal = bigVal.setScale(2, 4);
            }
            val = bigVal.toString();
        } else {
            val = value instanceof Date ? DateUtils.format((Date)((Date)value), (String)"yyyy-MM-dd") : (value instanceof DynamicObject ? ((DynamicObject)value).getString("name") : String.valueOf(value));
        }
        if (StringUtils.isNotEmpty((CharSequence)selectAlias)) {
            return selectAlias.concat(val);
        }
        return val;
    }

    public void matchSplitOrMergeRule(Map<Long, List<DynamicObject>> orgBillMap, String source) {
        Set<Map.Entry<Long, List<DynamicObject>>> entries = orgBillMap.entrySet();
        for (Map.Entry<Long, List<DynamicObject>> entry : entries) {
            this.matchSplitOrMergeRule(entry.getKey(), entry.getValue(), source);
        }
    }

    public void matchSplitOrMergeRule(long orgId, List<DynamicObject> bills, String source) {
        try {
            boolean isBotp = "2".equals(source);
            Object defaultMergeRule = SchemeHelper.getDefaultMergeRuleByOrg((long)orgId);
            QFilter filter = new QFilter("org", "=", (Object)orgId);
            filter.and("datasource", "=", (Object)source);
            filter.and("status", "=", (Object)"0");
            DynamicObject[] schemes = BusinessDataServiceHelper.load((String)"bdm_scheme_setting", (String)String.join((CharSequence)",", "filter_tag", "splitrulecode", "mergerule", "name"), (QFilter[])filter.toArray(), (String)"priority2 asc");
            for (DynamicObject bill : bills) {
                boolean match = false;
                String billSplitRule = bill.getString("splitrule");
                long billMergeRule = DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("mergerule"));
                if (isBotp && StringUtils.isNotBlank((CharSequence)billSplitRule) && billMergeRule != 0L) {
                    logger.info(String.format("\u5355\u636e\u7f16\u53f7:[%s]\u4e0a\u6e38\u5355\u636e\u5df2\u643a\u5e26\u5408\u5e76\u89c4\u5219\u4e0e\u62c6\u5206\u89c4\u5219\uff0c\u4e0d\u5339\u914d", bill.getString("billno")));
                    continue;
                }
                for (DynamicObject scheme : schemes) {
                    if (!ConditionMatchHelper.verify((String)scheme.getString("filter_tag"), (DynamicObject)bill)) continue;
                    if (!isBotp || !StringUtils.isNotBlank((CharSequence)billSplitRule)) {
                        logger.info(String.format("\u5355\u636e\u7f16\u53f7:[%s]\u5339\u914d\u5230\u62c6\u5206\u65b9\u6848[%s]\uff0c\u62c6\u5206\u89c4\u5219[%s]", bill.getString("billno"), scheme.getString("name"), scheme.get("splitrulecode")));
                        bill.set("splitrule", scheme.get("splitrulecode"));
                    }
                    if (!isBotp || billMergeRule == 0L) {
                        DynamicObject mergeRule = scheme.getDynamicObject("mergerule");
                        if (isBotp) {
                            DynamicObject merge = BusinessDataServiceHelper.newDynamicObject((String)"bdm_merge_rule_strategy");
                            merge.set("id", mergeRule == null ? defaultMergeRule : mergeRule.getPkValue());
                            bill.set("mergerule", (Object)merge);
                        } else {
                            bill.set("mergerule", mergeRule == null ? defaultMergeRule : mergeRule.getPkValue());
                        }
                        logger.info(String.format("\u5355\u636e\u7f16\u53f7:[%s]\u5339\u914d\u5230\u5408\u5e76\u65b9\u6848[%s]\uff0c\u5408\u5e76\u89c4\u5219[%s]", bill.getString("billno"), scheme.getString("name"), DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("mergerule"))));
                    }
                    match = true;
                    break;
                }
                if (match) continue;
                if (!isBotp || !StringUtils.isNotBlank((CharSequence)billSplitRule)) {
                    logger.info(String.format("\u5355\u636e\u7f16\u53f7:[%s]\u672a\u5339\u914d\u5230\u62c6\u5206\u65b9\u6848\uff0c\u4f7f\u7528\u9ed8\u8ba4\u62c6\u5206\u89c4\u5219", bill.getString("billno")));
                    bill.set("splitrule", (Object)"000000_s");
                }
                if (isBotp && billMergeRule != 0L) continue;
                if (isBotp) {
                    DynamicObject merge = BusinessDataServiceHelper.newDynamicObject((String)"bdm_merge_rule_strategy");
                    merge.set("id", defaultMergeRule);
                    bill.set("mergerule", (Object)merge);
                } else {
                    bill.set("mergerule", defaultMergeRule);
                }
                logger.info(String.format("\u5355\u636e\u7f16\u53f7:[%s]\u672a\u5339\u914d\u5230\u5408\u5e76\u65b9\u6848\uff0c\u4f7f\u7528\u9ed8\u8ba4\u5408\u5e76\u89c4\u5219", DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("mergerule"))));
            }
        }
        catch (Exception e) {
            logger.error("\u5339\u914d\u62c6\u5206\u5408\u5e76\u89c4\u5219\u62a5\u9519" + e.getMessage(), (Throwable)e);
        }
    }

    public void matchInvoiceType(BillVo billVo, DynamicObject[] invoiceTypeManage) {
        try {
            if (StringUtils.isNotBlank((CharSequence)billVo.getInvoiceType())) {
                return;
            }
            DynamicObject bill = DynamicObjectUtil.bean2DynamicObject((Object)billVo, (DynamicObject)BusinessDataServiceHelper.newDynamicObject((String)"sim_original_bill"));
            for (DynamicObject manage : invoiceTypeManage) {
                if (!ConditionMatchHelper.verify((String)manage.getString("filter_tag"), (DynamicObject)bill)) continue;
                billVo.setInvoiceType(manage.getString("invoicetype"));
                break;
            }
        }
        catch (Exception e) {
            logger.error("\u5339\u914d\u7968\u79cd\u62a5\u9519" + e.getMessage(), (Throwable)e);
        }
    }

    public void matchBuyerAddrAndBank(DynamicObject bill, DynamicObjectCollection bankAddrCollect) {
        try {
            List bankAddrList = bankAddrCollect.stream().sorted(Comparator.comparing(o -> o.getInt("priority"))).collect(Collectors.toList());
            for (DynamicObject bankAddr2 : bankAddrList) {
                String filterStr = bankAddr2.getString("filter_tag");
                if (StringUtils.isBlank((CharSequence)filterStr) || !ConditionMatchHelper.verify((String)filterStr, (DynamicObject)bill)) continue;
                logger.info(String.format("\u8d2d\u65b9\u5730\u5740\u7535\u8bdd\u5df2\u5339\u914d\u5230\uff0c\u7b56\u7565id\u4e3a[%s]\uff0c\u7b56\u7565\u6761\u4ef6\u4e3a[%s]", bankAddr2.getPkValue(), filterStr));
                this.fillBuyerAddrAndBank(bill, bankAddr2);
                return;
            }
            bankAddrList.stream().filter(bank -> bank.getBoolean("isdefault")).findFirst().ifPresent(bankAddr -> {
                logger.info("\u8d2d\u65b9\u5730\u5740\u7535\u8bdd\u4f7f\u7528\u9ed8\u8ba4\u6761\u4ef6");
                this.fillBuyerAddrAndBank(bill, (DynamicObject)bankAddr);
            });
        }
        catch (Exception e) {
            logger.error("\u5339\u914d\u8d2d\u65b9\u5730\u5740\u7535\u8bdd\u62a5\u9519" + e.getMessage(), (Throwable)e);
        }
    }

    private void fillBuyerAddrAndBank(DynamicObject bill, DynamicObject bankAddr) {
        bill.set("buyerbank", (Object)bankAddr.getString("itemopeningbank"));
        bill.set("buyeraddr", (Object)bankAddr.getString("itemaddr"));
        bill.set("buyerphone", (Object)bankAddr.getString("itemmobilephone"));
        bill.set("buyeremail", (Object)bankAddr.getString("itememail"));
        bill.set("buyerredemail", (Object)bankAddr.getString("itemredemail"));
    }

    public void matchSalerAddrAndBank(DynamicObject bill, DynamicObject[] invoiceSettingArr) {
        try {
            List invoiceSettingList = Arrays.stream(invoiceSettingArr).sorted(Comparator.comparing(o -> o.getString("ischeck"))).collect(Collectors.toList());
            for (DynamicObject setting : invoiceSettingList) {
                if ("1".equals(setting.get("ischeck"))) {
                    logger.info("\u9500\u65b9\u5730\u5740\u7535\u8bdd\u4f7f\u7528\u9ed8\u8ba4\u6761\u4ef6");
                    this.fillSaleAddrAndBank(bill, setting);
                    return;
                }
                String filterStr = setting.getString("filter_tag");
                if (StringUtils.isBlank((CharSequence)filterStr) || !ConditionMatchHelper.verify((String)filterStr, (DynamicObject)bill)) continue;
                logger.info(String.format("\u9500\u65b9\u5730\u5740\u7535\u8bdd\u5df2\u5339\u914d\u5230\uff0c\u7b56\u7565id\u4e3a[%s]\uff0c\u7b56\u7565\u6761\u4ef6\u4e3a[%s]", setting.getPkValue(), filterStr));
                this.fillSaleAddrAndBank(bill, setting);
                return;
            }
        }
        catch (Exception e) {
            logger.error("\u5339\u914d\u9500\u65b9\u5730\u5740\u7535\u8bdd\u62a5\u9519" + e.getMessage(), (Throwable)e);
        }
    }

    private void fillSaleAddrAndBank(DynamicObject bill, DynamicObject setting) {
        bill.set("salerbank", (Object)setting.getString("openuserbank"));
        bill.set("saleraddr", (Object)setting.getString("invoiceaddr"));
    }

    @SdkDeprecated
    public void matchDrawer(DynamicObject bill, DynamicObject[] drawerStrategyArr, DynamicObject defaultDrawerStrategy) {
        try {
            for (DynamicObject drawerStrategy : drawerStrategyArr) {
                String filterStr = drawerStrategy.getString("filter_tag");
                if (!ConditionMatchHelper.verify((String)filterStr, (DynamicObject)bill)) continue;
                logger.info(String.format("\u5f00\u7968\u4eba\u7b56\u7565\u5df2\u5339\u914d\u5230\uff0c\u7b56\u7565id\u4e3a[%s]\uff0c\u7b56\u7565\u6761\u4ef6\u4e3a[%s]", drawerStrategy.getPkValue(), filterStr));
                this.setDrawersWithStrategy(drawerStrategy, bill);
                return;
            }
            logger.info("\u5f00\u7968\u4eba\u7b56\u7565\u4f7f\u7528\u9ed8\u8ba4\u7b56\u7565");
            this.setDrawersWithStrategy(defaultDrawerStrategy, bill);
        }
        catch (Exception e) {
            logger.error("\u5339\u914d\u7968\u79cd\u62a5\u9519" + e.getMessage(), (Throwable)e);
        }
    }

    private void setDrawersWithStrategy(DynamicObject strategy, DynamicObject bill) {
        DrawerStrategyDTO strategyDTO = DrawerStrategyHelper.getSpecialStrategy((DynamicObject)strategy);
        DrawerInfo drawerInfo = new DrawerInfo();
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("orgid"));
        String jqbh = bill.getString("jqbh");
        DynamicObject devObj = DrawerStrategyHelper.dealDrawer((Long)orgId, (Object)jqbh, (String)bill.getString("drawer"), (DrawerInfo)drawerInfo, (DrawerStrategyDTO)strategyDTO);
        devObj = DrawerStrategyHelper.dealPayee((Long)orgId, (Object)jqbh, (String)bill.getString("payee"), (DrawerInfo)drawerInfo, (DynamicObject)devObj, (DrawerStrategyDTO)strategyDTO);
        DrawerStrategyHelper.dealReviewer((Long)orgId, (Object)jqbh, (String)bill.getString("reviewer"), (DrawerInfo)drawerInfo, (DynamicObject)devObj, (DrawerStrategyDTO)strategyDTO);
        bill.set("drawer", (Object)drawerInfo.getDrawer());
        bill.set("payee", (Object)drawerInfo.getPayee());
        bill.set("reviewer", (Object)drawerInfo.getReviewer());
    }

    public static DynamicObject checkCtrlConfig(String redReason, long orgId) {
        QFilter qFilter = ImcBaseDataHelper.getBillMatchSettingFilter((Object)orgId);
        for (int i = 0; i < ctrlStrategy.length; ++i) {
            DynamicObject matchConfig = BillMatchHelper.findMatchConfig(qFilter, ctrlStrategy[i], redReason);
            if (matchConfig != null) {
                return matchConfig;
            }
            if (i != ctrlStrategy.length - 1) continue;
            return null;
        }
        return null;
    }

    private static DynamicObject findMatchConfig(QFilter qFilter, String ctrlstrategy, String redReason) {
        QFilter filter = new QFilter("ctrlstrategy", "=", (Object)ctrlstrategy);
        QFilter redReasonFilter = new QFilter("redreason", "like", (Object)("%" + redReason + "%"));
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"bdm_match_ori_inv_setting", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_match_ori_inv_setting"), (QFilter[])filter.and(qFilter).and(redReasonFilter).toArray(), (String)"modifytime DESC");
        if (configs.length == 0) {
            return null;
        }
        return configs[0];
    }

    private static DynamicObject[] findMatchOriInvConfig(QFilter qFilter, Boolean withFilterTag) {
        QFilter filter = withFilterTag != false ? new QFilter("filter_tag", "!=", (Object)" ").and("filter_tag", "is not null", null) : new QFilter("filter_tag", "=", (Object)" ").or("filter_tag", "is null", null);
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"bdm_match_ori_inv_setting", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_match_ori_inv_setting"), (QFilter[])filter.and(qFilter).toArray(), (String)"modifytime DESC");
        if (configs.length == 0) {
            return null;
        }
        return configs;
    }

    private static DynamicObject[] findMatchRedConfirmConfig(QFilter qFilter, Boolean withFilterTag) {
        QFilter filter = withFilterTag != false ? new QFilter("filter_tag", "!=", (Object)" ").and("filter_tag", "is not null", null) : new QFilter("filter_tag", "=", (Object)" ").or("filter_tag", "is null", null);
        DynamicObject[] configs = BusinessDataServiceHelper.load((String)"bdm_match_redconfirm", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_match_redconfirm"), (QFilter[])filter.and(qFilter).toArray(), (String)"modifytime DESC");
        if (configs.length == 0) {
            return null;
        }
        return configs;
    }

    public static Map<Object, DynamicObject> getMatchOriInvSettingConfig(List<DynamicObject> bills) {
        return BillMatchHelper.getMatchOriInvSettingConfig(bills, false);
    }

    public static Map<Object, DynamicObject> getMatchOriInvSettingConfig(List<DynamicObject> bills, boolean isInterface) {
        HashMap<Object, DynamicObject> matchMap = new HashMap<Object, DynamicObject>(bills.size());
        if (CollectionUtils.isEmpty(bills)) {
            return matchMap;
        }
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)bills.get(0).get("orgid"));
        QFilter qFilter = ImcBaseDataHelper.getBillMatchSettingFilter((Object)orgId);
        HashSet<String> alreadyMatchBills = new HashSet<String>(bills.size());
        DynamicObject[] withTagMatchConfigs = BillMatchHelper.findMatchOriInvConfig(qFilter, true);
        DynamicObject[] withTagSortedMatchConfigs = null;
        if (null != withTagMatchConfigs) {
            withTagSortedMatchConfigs = BillMatchHelper.sortArray(withTagMatchConfigs);
        }
        DynamicObject[] withoutTagMatchConfigs = BillMatchHelper.findMatchOriInvConfig(qFilter, false);
        DynamicObject[] withoutTagSortedMatchConfigs = null;
        if (null != withoutTagMatchConfigs) {
            withoutTagSortedMatchConfigs = BillMatchHelper.sortArray(withoutTagMatchConfigs);
        }
        DynamicObject[] sortedMatchConfigs = null;
        sortedMatchConfigs = null == withTagSortedMatchConfigs ? withoutTagSortedMatchConfigs : (null == withoutTagSortedMatchConfigs ? withTagSortedMatchConfigs : BillMatchHelper.mergeArray(withTagSortedMatchConfigs, withoutTagSortedMatchConfigs));
        if (sortedMatchConfigs != null) {
            BillMatchHelper.billVerifyConfig(bills, sortedMatchConfigs, matchMap, alreadyMatchBills, isInterface);
        }
        return matchMap;
    }

    public static Map<Object, DynamicObject> getMatchRedConfirmConfig(List<DynamicObject> bills) {
        HashMap<Object, DynamicObject> matchMap = new HashMap<Object, DynamicObject>(bills.size());
        if (CollectionUtils.isEmpty(bills)) {
            return matchMap;
        }
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)bills.get(0).get("orgid"));
        QFilter qFilter = ImcBaseDataHelper.getMatchRedConfirmConfigSettingFilter((Object)orgId);
        HashSet<String> alreadyMatchBills = new HashSet<String>(bills.size());
        DynamicObject[] withTagMatchConfigs = BillMatchHelper.findMatchRedConfirmConfig(qFilter, true);
        DynamicObject[] withTagSortedMatchConfigs = null;
        if (null != withTagMatchConfigs) {
            withTagSortedMatchConfigs = BillMatchHelper.sortArray(withTagMatchConfigs);
        }
        DynamicObject[] withoutTagMatchConfigs = BillMatchHelper.findMatchRedConfirmConfig(qFilter, false);
        DynamicObject[] withoutTagSortedMatchConfigs = null;
        if (null != withoutTagMatchConfigs) {
            withoutTagSortedMatchConfigs = BillMatchHelper.sortArray(withoutTagMatchConfigs);
        }
        DynamicObject[] sortedMatchConfigs = null;
        sortedMatchConfigs = null == withTagSortedMatchConfigs ? withoutTagSortedMatchConfigs : (null == withoutTagSortedMatchConfigs ? withTagSortedMatchConfigs : BillMatchHelper.mergeArray(withTagSortedMatchConfigs, withoutTagSortedMatchConfigs));
        if (sortedMatchConfigs != null) {
            BillMatchHelper.billVerifyConfig(bills, sortedMatchConfigs, matchMap, alreadyMatchBills, false);
        }
        return matchMap;
    }

    private static void billVerifyConfig(List<DynamicObject> bills, DynamicObject[] matchConfigs, Map<Object, DynamicObject> matchMap, Set<String> alreadyMatchBills, boolean isInterface) {
        for (DynamicObject matchConfig : matchConfigs) {
            for (DynamicObject bill : bills) {
                if (alreadyMatchBills.contains(bill.getString("billno"))) continue;
                if (matchConfig.getDynamicObjectType().getName().equals("bdm_match_ori_inv_setting")) {
                    if (!isInterface && "2".equals(matchConfig.getString("matchstandard"))) continue;
                    if (StringUtils.isEmpty((CharSequence)bill.getString("redreason")) || RedConfirmBillRedReasonEnum.INVOICE_ERR.getBillCode().equals(bill.getString("redreason"))) {
                        alreadyMatchBills.add(bill.getString("billno"));
                        continue;
                    }
                    if (StringUtils.isEmpty((CharSequence)matchConfig.getString("redreason")) || !matchConfig.getString("redreason").contains(bill.getString("redreason"))) continue;
                }
                if (StringUtils.isEmpty((CharSequence)matchConfig.getString("filter_tag"))) {
                    if (0L != bill.getLong("id")) {
                        matchMap.put(bill.getPkValue(), matchConfig);
                    } else {
                        matchMap.put(bill.get("billno"), matchConfig);
                    }
                    alreadyMatchBills.add(bill.getString("billno"));
                    continue;
                }
                if (!ConditionMatchHelper.verify((String)matchConfig.getString("filter_tag"), (DynamicObject)bill)) continue;
                if (0L != bill.getLong("id")) {
                    matchMap.put(bill.getPkValue(), matchConfig);
                } else {
                    matchMap.put(bill.get("billno"), matchConfig);
                }
                alreadyMatchBills.add(bill.getString("billno"));
            }
        }
    }

    private static DynamicObject[] sortArray(DynamicObject[] matchConfigs) {
        if (null == matchConfigs) {
            return null;
        }
        DynamicObject[] sortedMatchConfigs = (DynamicObject[])IntStream.range(0, matchConfigs.length).mapToObj(i -> matchConfigs[i]).sorted(Comparator.comparingInt(o -> Arrays.asList(ctrlStrategy).indexOf(o.getString("ctrlstrategy")))).toArray(DynamicObject[]::new);
        return sortedMatchConfigs;
    }

    private static DynamicObject[] mergeArray(DynamicObject[] matchConfigs1, DynamicObject[] matchConfigs2) {
        DynamicObject[] mergeMatchConfigs;
        if (null == matchConfigs1) {
            mergeMatchConfigs = matchConfigs2;
        } else if (null == matchConfigs2) {
            mergeMatchConfigs = matchConfigs1;
        } else {
            mergeMatchConfigs = new DynamicObject[matchConfigs1.length + matchConfigs2.length];
            System.arraycopy(matchConfigs1, 0, mergeMatchConfigs, 0, matchConfigs1.length);
            System.arraycopy(matchConfigs2, 0, mergeMatchConfigs, matchConfigs1.length, matchConfigs2.length);
        }
        for (int i = 0; i < mergeMatchConfigs.length; ++i) {
            logger.info("\u89c4\u5219\u7f16\u7801:" + mergeMatchConfigs[i].getString("number") + ";\u5339\u914d\u9879\u9762\u677f:" + mergeMatchConfigs[i].getString("filter_tag") + ";\u7ba1\u63a7\u7b56\u7565:" + mergeMatchConfigs[i].getString("ctrlStrategy"));
        }
        return mergeMatchConfigs;
    }
}

