/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.match;

import com.google.common.base.Splitter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.table.RedReasonEnum;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.dto.minusbill.MinusBillDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillMatchConfig;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.bill.originalbill.workbench.task.AutoBillMatchTask;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MatchBillOriInvoiceCheckPlugin
extends AbstractFormPlugin {
    private static final String invoiceQueryFields = String.join((CharSequence)",", "id", "orderno", "invoicecode", "invoiceno", "occupystatus", "invoiceamount", "remainredamount", "invoicetype", "issuetime");

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        if ("check".equals(evt.getItemKey())) {
            this.checkMatchBillAndOriInvoice();
        } else if ("querybill".equals(evt.getItemKey())) {
            this.queryBill();
        }
    }

    private void queryBill() {
        DynamicObject matchBill = this.getMatchBill();
        if (matchBill == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914d\u5355\u67e5\u8be2\u4e3a\u7a7a", (String)"MatchBillOriInvoiceCheckPlugin_0", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        if (MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(matchBill.getString("matchstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5339\u914d\u5355\u5df2\u5168\u90e8\u5339\u914d", (String)"MatchBillOriInvoiceCheckPlugin_1", (String)"imc-sim-service", (Object[])new Object[0]));
            return;
        }
        this.setMatchBillAndItem(matchBill);
        this.setOriInvoice(matchBill);
        this.getView().showSuccessNotification("success");
    }

    private DynamicObject getMatchBill() {
        Object org = this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"MatchBillOriInvoiceCheckPlugin_2", (String)"imc-sim-service", (Object[])new Object[0]));
            return null;
        }
        String billno = (String)this.getModel().getValue("billno");
        if (StringUtils.isBlank((CharSequence)billno)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"MatchBillOriInvoiceCheckPlugin_3", (String)"imc-sim-service", (Object[])new Object[0]));
            return null;
        }
        QFilter qFilter = new QFilter("org", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)org)).and("billno", "=", (Object)billno);
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)"sim_match_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_match_bill", (boolean)true), (QFilter[])qFilter.toArray());
        if (bill == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)"sim_match_bill");
    }

    private void setMatchBillAndItem(DynamicObject matchBill) {
        IDataModel model = this.getModel();
        model.setValue("salertaxno", matchBill.get("salertaxno"));
        model.setValue("buyername", matchBill.get("buyername"));
        model.setValue("buyertaxno", matchBill.get("buyertaxno"));
        model.setValue("bill_invoicetype", matchBill.get("invoicetype"));
        DynamicObjectCollection items = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        model.deleteEntryData("billitem");
        for (DynamicObject item : items) {
            if (MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(item.getString("itemmatchstatus"))) continue;
            int i = model.createNewEntryRow("billitem");
            model.setValue("billitemid", item.get("id"), i);
            model.setValue("bill_goodsname", item.get("goodsname"), i);
            model.setValue("bill_spbm", item.get("spbm"), i);
            model.setValue("bill_goodscode", item.get("goodscode"), i);
            model.setValue("bill_specification", item.get("specification"), i);
            model.setValue("bill_unit", item.get("unit"), i);
            model.setValue("bill_num", item.get("num"), i);
            model.setValue("bill_taxrate", item.get("taxrate"), i);
            model.setValue("bill_unitprice", item.get("unitprice"), i);
            model.setValue("bill_amount", item.get("amount"), i);
            model.setValue("bill_tax", item.get("tax"), i);
            BigDecimal amount = item.getBigDecimal("amount");
            DynamicObjectCollection oriItems = item.getDynamicObjectCollection("subentryentity");
            for (DynamicObject oriItem : oriItems) {
                amount = amount.add(oriItem.getBigDecimal("oriitemamount"));
            }
            model.setValue("unmatchamount", (Object)amount, i);
            model.setValue("itemmatchstatus", item.get("itemmatchstatus"), i);
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("billitem");
        entryGrid.selectRows(0);
    }

    private void setOriInvoice(DynamicObject matchBill) {
        Object filter;
        MinusBillMatchHelper minusBillMatchHelper = new MinusBillMatchHelper();
        DynamicObject matchRule = this.getMatchRule(matchBill);
        minusBillMatchHelper.config = AutoBillMatchTask.buildMatchConfigByDynamicObject(matchRule);
        MinusBillDTO minusBill = minusBillMatchHelper.createMinusBillByMatchBill(minusBillMatchHelper.config, matchBill);
        QFilter invoiceQfilter = minusBillMatchHelper.getInvoiceQFilterList(minusBill, false);
        MainEntityType matchBillObjectType = EntityMetadataCache.getDataEntityType((String)"sim_match_bill");
        List headKeyList = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)matchRule.getString("invoicematchkey"));
        String sb = String.format(ResManager.loadKDString((String)"\u5339\u914d\u89c4\u5219\u540d\u79f0\u4e3a[%1$s]\uff0c\u89c4\u5219\u7f16\u7801[%2$s]\uff0c\u5339\u914d\u8868\u5934\u5b57\u6bb5[%3$s]", (String)"MatchBillOriInvoiceCheckPlugin_4", (String)"imc-sim-service", (Object[])new Object[0]), matchRule.getString("name"), matchRule.getString("number"), headKeyList.stream().map(arg_0 -> MatchBillOriInvoiceCheckPlugin.lambda$setOriInvoice$0((DynamicObjectType)matchBillObjectType, arg_0)).collect(Collectors.joining(",")));
        IDataModel model = this.getModel();
        model.setValue("rule", (Object)sb);
        MainEntityType vatInvoiceObjectType = EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice");
        StringBuilder qFilterSb = new StringBuilder();
        qFilterSb.append(vatInvoiceObjectType.getProperty(invoiceQfilter.getProperty()).getDisplayName().getLocaleValue()).append(" ");
        qFilterSb.append(invoiceQfilter.getCP()).append(" ");
        qFilterSb.append(invoiceQfilter.getValue());
        List nests = invoiceQfilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            qFilterSb.append(" ").append(nest.getOp()).append(" ");
            filter = nest.getFilter();
            DynamicProperty property = vatInvoiceObjectType.getProperty(filter.getProperty());
            if (property == null || property.getDisplayName() == null) continue;
            qFilterSb.append(property.getDisplayName().getLocaleValue()).append(" ");
            qFilterSb.append(filter.getCP()).append(" ");
            if (property instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)property;
                List comboItems = comboProp.getComboItems();
                Object filterVal = filter.getValue();
                if (filterVal instanceof String[] || filterVal instanceof Set) {
                    ArrayList<String> list = new ArrayList<String>(8);
                    if (filterVal instanceof String[]) {
                        String[] filterArr = (String[])filterVal;
                        list.addAll(Arrays.asList(filterArr));
                    } else {
                        list.addAll((Set)filterVal);
                    }
                    String filterValStr = ((Object)list).toString();
                    for (ValueMapItem comboItem : comboItems) {
                        filterValStr = filterValStr.replace(comboItem.getValue(), comboItem.getName().getLocaleValue());
                    }
                    filterValStr = filterValStr.replace("[", "(");
                    filterValStr = filterValStr.replace("]", ")");
                    qFilterSb.append(filterValStr);
                    continue;
                }
                if (filterVal instanceof String) {
                    String filterValStr = (String)filterVal;
                    for (ValueMapItem comboItem : comboItems) {
                        filterValStr = filterValStr.replace(comboItem.getValue(), comboItem.getName().getLocaleValue());
                    }
                    qFilterSb.append(filterValStr);
                    continue;
                }
                qFilterSb.append(filterVal);
                continue;
            }
            if (property instanceof DateTimeProp) {
                Date date = (Date)filter.getValue();
                qFilterSb.append(DateUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
                continue;
            }
            qFilterSb.append(filter.getValue());
        }
        model.setValue("filter", (Object)invoiceQfilter.toString());
        model.setValue("filter_desc", (Object)qFilterSb.toString());
        model.deleteEntryData("invoice");
        ORM orm = ORM.create();
        DataSet ds = orm.queryDataSet("MatchBillOriInvoiceCheckPlugin.sim_vatinvoice", "sim_vatinvoice", invoiceQueryFields, invoiceQfilter.toArray(), "id");
        filter = null;
        try {
            while (ds.hasNext()) {
                Row obj = ds.next();
                int index = model.createNewEntryRow("invoice");
                model.setValue("invoiceid", obj.get("id"), index);
                model.setValue("orderno", obj.get("orderno"), index);
                model.setValue("invoicecode", obj.get("invoicecode"), index);
                model.setValue("invoiceno", obj.get("invoiceno"), index);
                model.setValue("invoiceamount", obj.get("invoiceamount"), index);
                model.setValue("remainredamount", obj.get("remainredamount"), index);
                model.setValue("inv_invoicetype", obj.get("invoicetype"), index);
                model.setValue("issuetime", obj.get("issuetime"), index);
            }
        }
        catch (Throwable throwable) {
            filter = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (filter != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)filter).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        int rowCount = model.getEntryRowCount("invoice");
        if (rowCount > 0) {
            EntryGrid invoiceGrid = (EntryGrid)this.getControl("invoice");
            invoiceGrid.selectRows(0);
        }
    }

    private DynamicObject getInvoice() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("invoice");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u539f\u84dd\u7968", (String)"MatchBillOriInvoiceCheckPlugin_16", (String)"imc-sim-service", (Object[])new Object[0]));
            return null;
        }
        Object id = this.getModel().getValue("invoiceid", selectRows[0]);
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)"sim_vatinvoice");
    }

    private void checkMatchBillAndOriInvoice() {
        DynamicObject matchBill = this.getMatchBill();
        DynamicObject invoice = this.getInvoice();
        if (matchBill == null || invoice == null) {
            return;
        }
        MinusBillMatchConfig config = AutoBillMatchTask.buildMatchConfigByDynamicObject(this.getMatchRule(matchBill));
        if (config.getIgnorePrice().booleanValue() || config.getDiscountMatchPrice().booleanValue() && RedReasonEnum.SALES_DISCOUNTS.getTypeCode().equals(matchBill.getString("redreason"))) {
            config.setUnitPriceAffectType("none");
        }
        boolean salesDiscount = RedReasonEnum.SALES_DISCOUNTS.getTypeCode().equals(matchBill.getString("redreason"));
        EntryProp itemsProp = (EntryProp)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice").getProperty("items");
        DynamicObjectType itemsObjectType = itemsProp.getDynamicCollectionItemPropertyType();
        Object billitemid = this.getModel().getValue("billitemid", ((EntryGrid)this.getControl("billitem")).getSelectRows()[0]);
        DynamicObject billItem = matchBill.getDynamicObjectCollection("sim_original_bill_item").stream().filter(item -> billitemid.equals(item.getLong("id"))).findFirst().orElse(null);
        if (billItem == null) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection invItems = invoice.getDynamicObjectCollection("items");
        model.deleteEntryData("invitem");
        model.batchCreateNewEntryRow("invitem", invItems.size());
        for (int i = 0; i < invItems.size(); ++i) {
            DynamicObject item2 = (DynamicObject)invItems.get(i);
            model.setValue("inv_goodsname", item2.get("goodsname"), i);
            model.setValue("inv_spbm", item2.get("spbm"), i);
            model.setValue("inv_goodscode", item2.get("goodscode"), i);
            model.setValue("inv_specification", item2.get("specification"), i);
            model.setValue("inv_unit", item2.get("unit"), i);
            model.setValue("inv_num", item2.get("num"), i);
            model.setValue("inv_taxrate", item2.get("taxrate"), i);
            model.setValue("inv_unitprice", item2.get("unitprice"), i);
            model.setValue("inv_amount", item2.get("amount"), i);
            model.setValue("inv_tax", item2.get("tax"), i);
            model.setValue("itemremainredamount", item2.get("itemremainredamount"), i);
            model.setValue("remaindiscountamount", item2.get("remaindiscountamount"), i);
            model.setValue("result", (Object)this.compareBillAndInvItem(config, salesDiscount, itemsObjectType, billItem, item2), i);
        }
        this.getView().showSuccessNotification("success");
    }

    private String compareBillAndInvItem(MinusBillMatchConfig config, boolean salesDiscount, DynamicObjectType itemsObjectType, DynamicObject billItem, DynamicObject invItem) {
        if (!billItem.getString("taxrate").equals(invItem.getString("taxrate"))) {
            return ResManager.loadKDString((String)"\u7a0e\u7387\u4e0d\u4e00\u81f4", (String)"MatchBillOriInvoiceCheckPlugin_5", (String)"imc-sim-service", (Object[])new Object[0]);
        }
        BigDecimal itemMatchAmount = billItem.getBigDecimal("amount");
        DynamicObjectCollection oriInvoiceItems = billItem.getDynamicObjectCollection("subentryentity");
        for (DynamicObject oriInvoiceItem : oriInvoiceItems) {
            itemMatchAmount = itemMatchAmount.add(oriInvoiceItem.getBigDecimal("oriitemamount"));
        }
        itemMatchAmount = itemMatchAmount.abs();
        if (!config.getMatchMultiRow().booleanValue() && !MathUtils.isNullOrZero((BigDecimal)itemMatchAmount)) {
            if (salesDiscount) {
                if (invItem.getBigDecimal("itemremainredamount").compareTo(BigDecimal.ZERO) <= 0) {
                    return ResManager.loadKDString((String)"\u660e\u7ec6\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d\u4e3a0", (String)"MatchBillOriInvoiceCheckPlugin_6", (String)"imc-sim-service", (Object[])new Object[0]);
                }
                if (invItem.getBigDecimal(config.getMatchAmountField()).compareTo(itemMatchAmount) < 0) {
                    return ResManager.loadKDString((String)"\u660e\u7ec6\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d(\u5269\u4f59\u53ef\u6298\u8ba9\u91d1\u989d)\u4e0d\u80fd\u5c0f\u4e8e\u5269\u4f59\u5f85\u5339\u914d\u91d1\u989d", (String)"MatchBillOriInvoiceCheckPlugin_7", (String)"imc-sim-service", (Object[])new Object[0]);
                }
            } else if (invItem.getBigDecimal("itemremainredamount").compareTo(itemMatchAmount) < 0) {
                return ResManager.loadKDString((String)"\u660e\u7ec6\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u5269\u4f59\u5f85\u5339\u914d\u91d1\u989d", (String)"MatchBillOriInvoiceCheckPlugin_8", (String)"imc-sim-service", (Object[])new Object[0]);
            }
        } else if (salesDiscount) {
            if (invItem.getBigDecimal("itemremainredamount").compareTo(BigDecimal.ZERO) <= 0) {
                return ResManager.loadKDString((String)"\u660e\u7ec6\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d\u4e3a0", (String)"MatchBillOriInvoiceCheckPlugin_6", (String)"imc-sim-service", (Object[])new Object[0]);
            }
            if (invItem.getBigDecimal(config.getMatchAmountField()).compareTo(BigDecimal.ZERO) < 0) {
                return ResManager.loadKDString((String)"\u660e\u7ec6\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d(\u5269\u4f59\u53ef\u6298\u8ba9\u91d1\u989d)\u4e0d\u80fd\u5c0f\u4e8e0", (String)"MatchBillOriInvoiceCheckPlugin_9", (String)"imc-sim-service", (Object[])new Object[0]);
            }
        } else if (invItem.getBigDecimal("itemremainredamount").compareTo(BigDecimal.ZERO) <= 0) {
            return ResManager.loadKDString((String)"\u660e\u7ec6\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0", (String)"MatchBillOriInvoiceCheckPlugin_10", (String)"imc-sim-service", (Object[])new Object[0]);
        }
        if (!"none".equals(config.getUnitPriceAffectType())) {
            if (MathUtils.isNullOrZero((BigDecimal)billItem.getBigDecimal("unitprice"))) {
                if (invItem.getBigDecimal(config.getMatchPriceField()).compareTo(BigDecimal.ZERO) != 0) {
                    return ResManager.loadKDString((String)"\u660e\u7ec6\u5269\u4f59\u5355\u4ef7\uff08\u5269\u4f59\u53ef\u7ea2\u51b2\u5355\u4ef7\uff09\u4e0d\u4e3a0", (String)"MatchBillOriInvoiceCheckPlugin_11", (String)"imc-sim-service", (Object[])new Object[0]);
                }
            } else {
                if (invItem.getBigDecimal(config.getMatchPriceField()).compareTo(BigDecimal.ZERO) == 0) {
                    return ResManager.loadKDString((String)"\u660e\u7ec6\u5269\u4f59\u5355\u4ef7\uff08\u5269\u4f59\u53ef\u7ea2\u51b2\u5355\u4ef7\uff09\u4e0d\u4e3a0", (String)"MatchBillOriInvoiceCheckPlugin_11", (String)"imc-sim-service", (Object[])new Object[0]);
                }
                Pair<BigDecimal, BigDecimal> priceAffect = this.getUnitPriceAffect(config, billItem.getBigDecimal("unitprice"));
                if (priceAffect != null) {
                    if (invItem.getBigDecimal(config.getMatchPriceField()).compareTo((BigDecimal)priceAffect.getLeft()) < 0) {
                        return String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u5269\u4f59\u5355\u4ef7\uff08\u5269\u4f59\u53ef\u7ea2\u51b2\u5355\u4ef7\uff09\u8981\u5927\u4e8e%s", (String)"MatchBillOriInvoiceCheckPlugin_12", (String)"imc-sim-service", (Object[])new Object[0]), ((BigDecimal)priceAffect.getLeft()).stripTrailingZeros().toPlainString());
                    }
                    if (invItem.getBigDecimal(config.getMatchPriceField()).compareTo((BigDecimal)priceAffect.getRight()) > 0) {
                        return String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u5269\u4f59\u5355\u4ef7\uff08\u5269\u4f59\u53ef\u7ea2\u51b2\u5355\u4ef7\uff09\u8981\u5c0f\u4e8e%s", (String)"MatchBillOriInvoiceCheckPlugin_13", (String)"imc-sim-service", (Object[])new Object[0]), ((BigDecimal)priceAffect.getRight()).stripTrailingZeros().toPlainString());
                    }
                }
            }
        }
        List itemFieldList = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)config.getItemField());
        for (String field : itemFieldList) {
            DynamicProperty property;
            if ("unitprice".equals(field) || "taxunitprice".equals(field) || "redprice".equals(field) || (property = itemsObjectType.getProperty(field)) == null) continue;
            Object billVal = billItem.get(field);
            Object invVal = invItem.get(field);
            if (billVal.getClass() != invVal.getClass()) {
                return String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4", (String)"MatchBillOriInvoiceCheckPlugin_14", (String)"imc-sim-service", (Object[])new Object[0]), property.getDisplayName().getLocaleValue());
            }
            if (!(BigDecimal.class == billVal.getClass() ? ((BigDecimal)billVal).compareTo((BigDecimal)invVal) != 0 : !billVal.equals(invVal))) continue;
            return String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u4e00\u81f4\uff0c\u5355\u636e\u503c%2$s\uff0c\u53d1\u7968\u503c%3$s", (String)"MatchBillOriInvoiceCheckPlugin_15", (String)"imc-sim-service", (Object[])new Object[0]), property.getDisplayName().getLocaleValue(), billVal, invVal);
        }
        return "";
    }

    protected Pair<BigDecimal, BigDecimal> getUnitPriceAffect(MinusBillMatchConfig config, BigDecimal unitPrice) {
        if (config.getUnitPriceAffect() == null) {
            return null;
        }
        if ("none".equals(config.getUnitPriceAffectType())) {
            return null;
        }
        if ("percent".equals(config.getUnitPriceAffectType())) {
            BigDecimal hundred = new BigDecimal("100");
            BigDecimal maxRate = config.getUnitPriceAffect().abs().add(hundred).divide(hundred, 100, 4);
            BigDecimal minRate = hundred.subtract(config.getUnitPriceAffect().abs()).divide(hundred, 100, 4);
            return Pair.of((Object)unitPrice.multiply(minRate), (Object)unitPrice.multiply(maxRate));
        }
        return Pair.of((Object)unitPrice.subtract(config.getUnitPriceAffect().abs()), (Object)unitPrice.add(config.getUnitPriceAffect().abs()));
    }

    private DynamicObject getMatchRule(DynamicObject matchBill) {
        DynamicObject matchRule = matchBill.getDynamicObject("matchrule");
        if (matchRule == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5339\u914d\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a", (String)"MatchBillOriInvoiceCheckPlugin_17", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        return BusinessDataServiceHelper.loadSingle((Object)matchRule.getPkValue(), (String)"bdm_match_ori_inv_setting");
    }

    private static /* synthetic */ String lambda$setOriInvoice$0(DynamicObjectType matchBillObjectType, String head) {
        return matchBillObjectType.getProperty(head).getDisplayName().getLocaleValue();
    }
}

