/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.match;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.ExtHelper;
import kd.imc.sim.common.helper.NegativeBillMatchHelper;
import kd.imc.sim.common.helper.RedInfoHelper;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.formplugin.bill.splitMerge.split.impl.AbstractSplitQuantityService;
import kd.imc.sim.formplugin.match.MatchBillRedHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MatchInvoiceRedHelper
extends MatchBillRedHelper {
    public void matchInvoiceRed(DynamicObject matchBill, Set<DynamicObject> redConfirms, List<DynamicObject> redInvoiceLit, OperationResult operationResult) {
        ArrayList<BillRelationDTO> relationList = new ArrayList<BillRelationDTO>(4);
        DynamicObjectCollection matchItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        HashMap<String, List<DynamicObject>> invoiceMap = new HashMap<String, List<DynamicObject>>(matchItems.size());
        HashMap<Long, DynamicObject> subItem2ItemMap = new HashMap<Long, DynamicObject>(matchItems.size());
        for (DynamicObject matchItem : matchItems) {
            DynamicObjectCollection subItems = matchItem.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subItem : subItems) {
                if ("1".equals(subItem.getString("pushstatus"))) continue;
                List dynamicObjects = invoiceMap.computeIfAbsent(subItem.getString("oriinvoicecode") + "\u25cf\u25c6\u25a0" + subItem.getString("oriinvoiceno"), k -> new ArrayList());
                dynamicObjects.add(subItem);
                subItem2ItemMap.putIfAbsent(subItem.getLong("id"), matchItem);
            }
        }
        if (invoiceMap.size() == 0) {
            return;
        }
        Map<String, DynamicObject> oriInvoiceMap = this.getOriInvoiceMap(matchBill, invoiceMap);
        Pair<List<String>, List<String>> headAndItemIsvField = this.getMatchBillHeadAndItemIsvField();
        String billNoPrefix = "200_" + UUID.getBatchNumber() + '_';
        int i = 1;
        String invoiceType = matchBill.getString("invoicetype");
        ArrayList<DynamicObject> redConfirmList = new ArrayList<DynamicObject>(16);
        Set entries = invoiceMap.entrySet();
        for (Map.Entry entry : entries) {
            DynamicObject blueInvoice = oriInvoiceMap.get(entry.getKey());
            if (blueInvoice == null) continue;
            if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                DynamicObject redConfirm2 = this.createRedConfirm(matchBill, blueInvoice, (List)entry.getValue(), subItem2ItemMap, relationList, headAndItemIsvField);
                redConfirm2.set("billno", (Object)(billNoPrefix + BillHelper.getBatchNumbersuffix((int)i++)));
                redConfirmList.add(redConfirm2);
                continue;
            }
            if (InvoiceUtils.isSpecialInvoice((String)invoiceType)) {
                this.createRedInfo(matchBill, blueInvoice, (List)entry.getValue(), subItem2ItemMap, relationList);
            } else {
                redInvoiceLit.add(this.createRedInvoice(matchBill, blueInvoice, (List)entry.getValue(), subItem2ItemMap, relationList));
            }
            List subItems = (List)entry.getValue();
            for (DynamicObject subItem : subItems) {
                subItem.set("pushstatus", (Object)"1");
            }
        }
        if (CollectionUtils.isNotEmpty(redConfirmList)) {
            OperationResult redConfirmSaveOpResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_red_confirm_bill", (DynamicObject[])redConfirmList.toArray(new DynamicObject[0]), null);
            List successPkIds = redConfirmSaveOpResult.getSuccessPkIds() == null ? new ArrayList(1) : redConfirmSaveOpResult.getSuccessPkIds();
            relationList.removeIf(relation -> !successPkIds.contains(relation.gettBillId()));
            List allErrorOrValidateInfo = redConfirmSaveOpResult.getAllErrorOrValidateInfo();
            Map<Object, Object> errMap = new HashMap(1);
            if (CollectionUtils.isNotEmpty((Collection)allErrorOrValidateInfo)) {
                errMap = allErrorOrValidateInfo.stream().collect(Collectors.toMap(IOperateInfo::getPkValue, IOperateInfo::getMessage, (v1, v2) -> v1));
            }
            for (DynamicObject redConfirm3 : redConfirmList) {
                if (successPkIds.contains(redConfirm3.getLong("id"))) continue;
                if (operationResult != null) {
                    operationResult.addErrorInfo((OperateErrorInfo)new ValidationErrorInfo("", matchBill.getPkValue(), 0, 0, ErrorType.FAIL.getCode(), "", (String)errMap.get(redConfirm3.getLong("id")), ErrorLevel.Error));
                    continue;
                }
                throw new KDBizException(OperationConstant.getErrorMsg((OperationResult)redConfirmSaveOpResult));
            }
            List successList = redConfirmList.stream().filter(redConfirm -> successPkIds.contains(redConfirm.getLong("id"))).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(successList)) {
                for (DynamicObject redConfirm4 : successList) {
                    List subItems = (List)invoiceMap.get(redConfirm4.getString("originalinvoicecode") + "\u25cf\u25c6\u25a0" + redConfirm4.getString("originalinvoiceno"));
                    for (DynamicObject subItem : subItems) {
                        subItem.set("pushstatus", (Object)"1");
                    }
                }
            }
            redConfirms.addAll(redConfirmList);
        }
        this.saveRelations(relationList, "0");
        NegativeBillMatchHelper.changePushStatus((DynamicObject)matchBill);
    }

    private Map<String, DynamicObject> getOriInvoiceMap(DynamicObject matchBill, Map<String, List<DynamicObject>> invoiceMap) {
        String selectField = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true);
        String taxNo = matchBill.getString("salertaxno");
        if ("02".equals(matchBill.getString("specialtype"))) {
            taxNo = matchBill.getString("buyertaxno");
        }
        QFilter taxNoFilter = new QFilter("salertaxno", "=", (Object)taxNo);
        Set<String> invoiceCodeNoSet = invoiceMap.keySet();
        List<Set<String>> invoiceCodeNoSetList = new ArrayList<Set<String>>(16);
        if (invoiceCodeNoSet.size() > 100) {
            int group = (invoiceCodeNoSet.size() + 100 - 1) / 100;
            invoiceCodeNoSetList = Stream.iterate(0, i -> i + 1).limit(group).map(i -> invoiceCodeNoSet.stream().skip(i * 100).limit(100L).collect(Collectors.toSet())).collect(Collectors.toList());
        } else {
            invoiceCodeNoSetList.add(invoiceCodeNoSet);
        }
        HashMap<String, DynamicObject> oriInvoiceMap = new HashMap<String, DynamicObject>(invoiceCodeNoSet.size());
        for (Set set : invoiceCodeNoSetList) {
            QFilter qFilter = new QFilter("invoicecode", "=", (Object)"-1").and("invoiceno", "=", (Object)"-1");
            for (String invoiceCodeNo : set) {
                String[] invoiceCodeNoArr = invoiceCodeNo.split("\u25cf\u25c6\u25a0");
                qFilter.or(InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoiceCodeNoArr[0], (String)invoiceCodeNoArr[1]));
            }
            DynamicObject[] blueInvoice = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)selectField, (QFilter[])new QFilter[]{taxNoFilter, qFilter});
            oriInvoiceMap.putAll(Arrays.stream(blueInvoice).collect(Collectors.toMap(k -> k.getString("invoicecode") + "\u25cf\u25c6\u25a0" + k.getString("invoiceno"), v -> v, (v1, v2) -> v1)));
        }
        return oriInvoiceMap;
    }

    private DynamicObject createRedConfirm(DynamicObject matchBill, DynamicObject blueInvoice, List<DynamicObject> oriItems, Map<Long, DynamicObject> subItem2ItemMap, List<BillRelationDTO> relationList, Pair<List<String>, List<String>> headAndItemIsvField) {
        DynamicObject redConfirm = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_confirm_bill");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)blueInvoice, (DynamicObject)redConfirm, (boolean)false, (boolean)true, (boolean)true);
        redConfirm.set("issuetime", null);
        ExtHelper.setExtField(matchBill, redConfirm, (List)headAndItemIsvField.getKey());
        redConfirm.set("id", (Object)DBServiceHelper.genGlobalLongId());
        redConfirm.set("issuestatus", (Object)"2");
        redConfirm.set("originalinvoicecode", blueInvoice.get("invoicecode"));
        redConfirm.set("originalinvoiceno", blueInvoice.get("invoiceno"));
        redConfirm.set("originalissuetime", blueInvoice.get("issuetime"));
        redConfirm.set("originalinvoiceamount", blueInvoice.get("invoiceamount"));
        redConfirm.set("originaltotaltax", blueInvoice.get("totaltax"));
        redConfirm.set("drawer", matchBill.get("drawer"));
        redConfirm.set("reviewer", matchBill.get("reviewer"));
        redConfirm.set("payee", matchBill.get("payee"));
        redConfirm.set("createtime", (Object)new Date());
        String invoiceType = matchBill.getString("invoicetype");
        if (!InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            redConfirm.set("paperflag", (Object)"Y");
            if (InvoiceUtils.isNormalInvoice((String)invoiceType)) {
                redConfirm.set("invoicetype", (Object)InvoiceType.ALL_E_NORMAL.getTypeCode());
            } else {
                redConfirm.set("invoicetype", (Object)InvoiceType.ALL_E_SPECIAL.getTypeCode());
            }
        }
        redConfirm.set("originalinvoicetype", blueInvoice.get("invoicetype"));
        redConfirm.set("originalEtaxInvoiceNo", blueInvoice.get("alletaxinvoiceno"));
        redConfirm.set("orderno", (Object)UUID.next());
        redConfirm.set("hsbz", (Object)"0");
        redConfirm.set("ctrlstrategy", (Object)"7");
        redConfirm.set("org", matchBill.get("org"));
        redConfirm.set("useorg", matchBill.get("org"));
        redConfirm.set("createorg", matchBill.get("org"));
        redConfirm.set("uploadstatus", (Object)"0");
        if ("02".equals(matchBill.getString("specialtype"))) {
            redConfirm.set("applicant", (Object)"1");
            redConfirm.set("enteridentity", (Object)"1");
        } else {
            redConfirm.set("applicant", (Object)"2");
            redConfirm.set("enteridentity", (Object)"0");
        }
        String redReason = matchBill.getString("redreason");
        if (StringUtils.isBlank((CharSequence)redReason)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u51b2\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"MatchInvoiceRedHelper_0", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        redConfirm.set("redreason", (Object)RedConfirmBillRedReasonEnum.getCodeByBillCode((String)redReason));
        redConfirm.set("status", (Object)BillHelper.getBillStatusByTableName((String)"sim_red_confirm_bill", (String)"10"));
        redConfirm.set("invoicetype", matchBill.get("invoicetype"));
        Map<Long, DynamicObject> itemIdMap = this.getItemIdMap(blueInvoice);
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        DynamicObjectCollection confirmItems = redConfirm.getDynamicObjectCollection("items");
        confirmItems.clear();
        Map<String, List<DynamicObject>> oriItemMap = oriItems.stream().collect(Collectors.groupingBy(oriItem -> oriItem.getLong("oriinvoiceid") + "\u25cf\u25c6\u25a0" + oriItem.getLong("oriitemid")));
        Set<Map.Entry<String, List<DynamicObject>>> entries = oriItemMap.entrySet();
        int seq = 1;
        for (Map.Entry<String, List<DynamicObject>> entry : entries) {
            List<DynamicObject> oriItemGroup = entry.getValue();
            DynamicObject firstOriItem = oriItemGroup.get(0);
            DynamicObject matchItem = subItem2ItemMap.get(firstOriItem.getLong("id"));
            DynamicObject confirmItem = confirmItems.addNew();
            DynamicObject invoiceItem = itemIdMap.get(firstOriItem.getLong("oriitemid"));
            DynamicObjectUtil.copyDynamicObject((DynamicObject)invoiceItem, (DynamicObject)confirmItem, (boolean)false, (boolean)true, (boolean)true);
            confirmItem.set("seq", (Object)seq);
            confirmItem.set("taxratecodeid", (Object)TaxClassCodeCheckHelper.geTaxCode((String)invoiceItem.getString("goodscode")));
            confirmItem.set("id", (Object)DBServiceHelper.genGlobalLongId());
            confirmItem.set("rowtype", (Object)"0");
            confirmItem.set("originseq", firstOriItem.get("oriitemseq"));
            BigDecimal amount = firstOriItem.getBigDecimal("oriitemamount").negate();
            confirmItem.set("amount", (Object)amount);
            BigDecimal tax = firstOriItem.getBigDecimal("oriitemtax").negate();
            confirmItem.set("tax", (Object)tax);
            confirmItem.set("taxamount", (Object)amount.add(tax));
            confirmItem.set("originalinvoiceitemid", firstOriItem.get("oriitemid"));
            confirmItem.set("num", (Object)firstOriItem.getBigDecimal("oriitemnum").negate());
            ExtHelper.setExtField(matchItem, confirmItem, (List)headAndItemIsvField.getValue());
            invoiceAmount = invoiceAmount.add(amount);
            totalTax = totalTax.add(tax);
            BillRelationDTO relation = new BillRelationDTO(Long.valueOf(matchBill.getLong("id")), matchBill.getString("billno"), Long.valueOf(matchItem.getLong("id")), Long.valueOf(redConfirm.getLong("id")), redConfirm.getString("billno"), Long.valueOf(confirmItem.getLong("id")), amount, tax, firstOriItem.getBigDecimal("oriitemnum").negate(), confirmItem.getBigDecimal("unitprice"), "sim_red_confirm_bill");
            relation.setsSubDetailId(Long.valueOf(firstOriItem.getLong("id")));
            relationList.add(relation);
            if (oriItemGroup.size() > 1) {
                for (int i = 1; i < oriItemGroup.size(); ++i) {
                    DynamicObject oriItem2 = oriItemGroup.get(i);
                    DynamicObject newMatchItem = subItem2ItemMap.get(oriItem2.getLong("id"));
                    BigDecimal beMergeAmount = oriItem2.getBigDecimal("oriitemamount").negate();
                    confirmItem.set("amount", (Object)confirmItem.getBigDecimal("amount").add(beMergeAmount));
                    BigDecimal beMergeTax = oriItem2.getBigDecimal("oriitemtax").negate();
                    confirmItem.set("tax", (Object)confirmItem.getBigDecimal("tax").add(beMergeTax));
                    confirmItem.set("taxamount", (Object)confirmItem.getBigDecimal("amount").add(confirmItem.getBigDecimal("tax")));
                    if (!RedConfirmBillRedReasonEnum.SALES_DISCOUNTS.getBillCode().equals(matchBill.getString("redreason"))) {
                        confirmItem.set("num", (Object)confirmItem.getBigDecimal("num").add(oriItem2.getBigDecimal("oriitemnum").negate()));
                    }
                    invoiceAmount = invoiceAmount.add(beMergeAmount);
                    totalTax = totalTax.add(beMergeTax);
                    BillRelationDTO mergeRelation = new BillRelationDTO(Long.valueOf(matchBill.getLong("id")), matchBill.getString("billno"), Long.valueOf(newMatchItem.getLong("id")), Long.valueOf(redConfirm.getLong("id")), redConfirm.getString("billno"), Long.valueOf(confirmItem.getLong("id")), beMergeAmount, beMergeTax, oriItem2.getBigDecimal("oriitemnum").negate(), confirmItem.getBigDecimal("unitprice"), "sim_red_confirm_bill");
                    mergeRelation.setsSubDetailId(Long.valueOf(oriItem2.getLong("id")));
                    relationList.add(mergeRelation);
                }
            }
            if (RedConfirmBillRedReasonEnum.SALES_DISCOUNTS.getBillCode().equals(matchBill.getString("redreason"))) {
                confirmItem.set("num", (Object)BigDecimal.ZERO);
                confirmItem.set("unitprice", (Object)BigDecimal.ZERO);
                confirmItem.set("taxunitprice", (Object)BigDecimal.ZERO);
            } else {
                this.calcUnitPriceAndNum(firstOriItem, confirmItem);
            }
            ++seq;
        }
        redConfirm.set("invoiceamount", (Object)invoiceAmount);
        redConfirm.set("totaltax", (Object)totalTax);
        redConfirm.set("totalamount", (Object)invoiceAmount.add(totalTax));
        redConfirm.set("invoiceno", (Object)"");
        redConfirm.set("issuestatus", (Object)"2");
        this.setMatchBillVal2RedConfirm(matchBill, redConfirm);
        return redConfirm;
    }

    private void createRedInfo(DynamicObject matchBill, DynamicObject blueInvoice, List<DynamicObject> oriItems, Map<Long, DynamicObject> subItem2ItemMap, List<BillRelationDTO> relationList) {
        DynamicObject redInfo = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_info");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)blueInvoice, (DynamicObject)redInfo, (boolean)false, (boolean)true, (boolean)true);
        redInfo.set("id", (Object)DBServiceHelper.genGlobalLongId());
        redInfo.set("org", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)matchBill.get("org")));
        redInfo.set("invoicecode", null);
        redInfo.set("invoiceno", null);
        redInfo.set("systemsource", (Object)matchBill.getString("systemsource"));
        redInfo.set("hsbz", (Object)"0");
        redInfo.set("infosource", (Object)"10");
        redInfo.set("jqbh", blueInvoice.get("jqbh"));
        redInfo.set("infodate", (Object)new Date());
        redInfo.set("infoserialno", (Object)RedInfoHelper.generateRedInfoSerialNo((String)this.getJqbh(blueInvoice, DynamicObjectUtil.getDynamicObjectLongValue((Object)matchBill.get("org")))));
        redInfo.set("orderno", (Object)UUID.next());
        redInfo.set("createtime", (Object)new Date());
        redInfo.set("status", (Object)"1");
        redInfo.set("originaldeduction", ObjectUtils.defaultIfNull((Object)blueInvoice.getBigDecimal("deduction"), (Object)0));
        redInfo.set("originalinvoicecode", blueInvoice.get("invoicecode"));
        redInfo.set("originalinvoiceno", blueInvoice.get("invoiceno"));
        redInfo.set("originalissuetime", blueInvoice.get("issuetime"));
        redInfo.set("applyreason", (Object)GBKUtils.cutGBKString((String)matchBill.getString("remark"), (int)100));
        redInfo.set("deduction", (Object)blueInvoice.getBigDecimal("deduction"));
        redInfo.set("applicant", (Object)RedInfoConstant.ApplicantEnum.SALER.getCode());
        redInfo.set("applytaxno", (Object)redInfo.getString("salertaxno"));
        if (StringUtils.isBlank((CharSequence)redInfo.getString("inventorymark"))) {
            redInfo.set("inventorymark", (Object)"0");
        }
        redInfo.set("taxorg", (Object)RedInfoHelper.getTaxOrgId((String)redInfo.getString("applytaxno")));
        redInfo.set("billstatus", (Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode());
        Map<Long, DynamicObject> itemIdMap = this.getItemIdMap(blueInvoice);
        DynamicObjectCollection redInfoItems = redInfo.getDynamicObjectCollection("items");
        redInfoItems.clear();
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        for (DynamicObject oriItem : oriItems) {
            DynamicObject redInfoItem = redInfoItems.addNew();
            DynamicObject invoiceItem = itemIdMap.get(oriItem.getLong("oriitemid"));
            DynamicObjectUtil.copyDynamicObject((DynamicObject)invoiceItem, (DynamicObject)redInfoItem, (boolean)false, (boolean)true, (boolean)true);
            redInfoItem.set("id", (Object)DBServiceHelper.genGlobalLongId());
            redInfoItem.set("rowtype", (Object)"0");
            BigDecimal amount = oriItem.getBigDecimal("oriitemamount").negate();
            redInfoItem.set("amount", (Object)amount);
            BigDecimal tax = oriItem.getBigDecimal("oriitemtax").negate();
            redInfoItem.set("tax", (Object)tax);
            redInfoItem.set("taxamount", (Object)amount.add(tax));
            redInfoItem.set("num", (Object)oriItem.getBigDecimal("oriitemnum").negate());
            this.calcUnitPriceAndNum(oriItem, redInfoItem);
            invoiceAmount = invoiceAmount.add(amount);
            totalTax = totalTax.add(tax);
            DynamicObject item = subItem2ItemMap.get(oriItem.getLong("id"));
            BillRelationDTO relation = new BillRelationDTO(Long.valueOf(matchBill.getLong("id")), matchBill.getString("billno"), Long.valueOf(item.getLong("id")), Long.valueOf(redInfo.getLong("id")), redInfo.getString("billno"), Long.valueOf(redInfoItem.getLong("id")), amount, tax, redInfoItem.getBigDecimal("num"), redInfoItem.getBigDecimal("unitprice"), "sim_red_confirm_bill");
            relation.setsSubDetailId(Long.valueOf(oriItem.getLong("id")));
            relationList.add(relation);
        }
        redInfo.set("invoiceamount", (Object)invoiceAmount);
        redInfo.set("totaltax", (Object)totalTax);
        redInfo.set("totalamount", (Object)invoiceAmount.add(totalTax));
        redInfo.set("submitter", null);
        redInfo.set("submitdate", null);
        redInfo.set("auditor", null);
        redInfo.set("auditdate", null);
        ImcSaveServiceHelper.save((DynamicObject)redInfo);
    }

    private DynamicObject createRedInvoice(DynamicObject matchBill, DynamicObject blueInvoice, List<DynamicObject> oriItems, Map<Long, DynamicObject> subItem2ItemMap, List<BillRelationDTO> relationList) {
        DynamicObject redInvoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)blueInvoice, (DynamicObject)redInvoice, (boolean)false, (boolean)true, (boolean)true);
        AbstractSplitQuantityService.buildMainInvoiceData((DynamicObject)redInvoice);
        redInvoice.set("id", (Object)DBServiceHelper.genGlobalLongId());
        redInvoice.set("originalinvoicecode", blueInvoice.get("invoicecode"));
        redInvoice.set("originalinvoiceno", blueInvoice.get("invoiceno"));
        redInvoice.set("originalissuetime", blueInvoice.get("issuetime"));
        redInvoice.set("originalinvoicetype", blueInvoice.get("invoicetype"));
        redInvoice.set("issuetype", (Object)IssueType.RED_INVOICE.getTypeCode());
        redInvoice.set("orgid", matchBill.get("org"));
        redInvoice.set("buyeraddr", matchBill.get("buyeraddr"));
        redInvoice.set("buyerbank", matchBill.get("buyerbank"));
        redInvoice.set("buyeremail", matchBill.get("buyeremail"));
        redInvoice.set("buyerphone", matchBill.get("buyerphone"));
        redInvoice.set("saleraddr", matchBill.get("saleraddr"));
        redInvoice.set("salerbank", matchBill.get("salerbank"));
        redInvoice.set("drawer", matchBill.get("drawer"));
        redInvoice.set("reviewer", matchBill.get("reviewer"));
        redInvoice.set("payee", matchBill.get("payee"));
        redInvoice.set("systemsource", matchBill.get("systemsource"));
        redInvoice.set("remark", matchBill.get("remark"));
        redInvoice.set("invoicetype", matchBill.get("invoicetype"));
        redInvoice.set("redreason", matchBill.get("redreason"));
        redInvoice.set("billno", (Object)("200_" + UUID.getBatchNumber() + "_0001"));
        redInvoice.set("batchbelong", (Object)matchBill.getString("billno"));
        redInvoice.set("invoicestatus", (Object)"");
        redInvoice.set("fileurl", (Object)"");
        redInvoice.set("pdffileurl", (Object)"");
        redInvoice.set("xmlfileurl", (Object)"");
        redInvoice.set("snapshoturl", (Object)"");
        redInvoice.set("ofdstatus", (Object)"");
        redInvoice.set("checkcode", (Object)"");
        redInvoice.set("taxedtype", (Object)TaxedTypeEnum.normal.getValue());
        redInvoice.set("invoicecopy", (Object)"");
        redInvoice.set("baseinvoicetype", (Object)0);
        redInvoice.set("result", (Object)"");
        redInvoice.set("datahash", (Object)"");
        redInvoice.set("invalider", (Object)"");
        redInvoice.set("invaliddate", null);
        redInvoice.set("remainredamount", (Object)BigDecimal.ZERO);
        redInvoice.set("canredtaxamount", (Object)BigDecimal.ZERO);
        redInvoice.set("downloadflag", (Object)"0");
        redInvoice.set("printflag", (Object)"0");
        redInvoice.set("skm", (Object)"");
        redInvoice.set("wxid", (Object)"");
        redInvoice.set("cardbagstatus", (Object)"-1");
        redInvoice.set("reissuestatus", (Object)"0");
        redInvoice.set("reorderno", (Object)"");
        redInvoice.set("abolishtype", (Object)"");
        redInvoice.set("abolishreason", (Object)"");
        redInvoice.set("uploadismcstatus", (Object)"0");
        redInvoice.set("thirdserialno", (Object)redInvoice.getString("orderno"));
        redInvoice.set("occupystatus", (Object)"0");
        redInvoice.set("modifier", (Object)RequestContext.get().getUserId());
        redInvoice.set("modifytime", (Object)new Date());
        redInvoice.set("hsbz", (Object)"0");
        Map<Long, DynamicObject> itemIdMap = this.getItemIdMap(blueInvoice);
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        DynamicObjectCollection redInvoiceItems = redInvoice.getDynamicObjectCollection("items");
        redInvoiceItems.clear();
        for (DynamicObject oriItem : oriItems) {
            DynamicObject redInvoiceItem = redInvoiceItems.addNew();
            DynamicObject invoiceItem = itemIdMap.get(oriItem.getLong("oriitemid"));
            DynamicObjectUtil.copyDynamicObject((DynamicObject)invoiceItem, (DynamicObject)redInvoiceItem, (boolean)false, (boolean)true, (boolean)true);
            redInvoiceItem.set("id", (Object)DBServiceHelper.genGlobalLongId());
            redInvoiceItem.set("rowtype", (Object)"0");
            BigDecimal amount = oriItem.getBigDecimal("oriitemamount").negate();
            redInvoiceItem.set("amount", (Object)amount);
            BigDecimal tax = oriItem.getBigDecimal("oriitemtax").negate();
            redInvoiceItem.set("tax", (Object)tax);
            redInvoiceItem.set("taxamount", (Object)amount.add(tax));
            redInvoiceItem.set("originalinvoiceitemid", oriItem.get("oriitemid"));
            redInvoiceItem.set("itemremainredamount", (Object)BigDecimal.ZERO);
            redInvoiceItem.set("itemremainredtax", (Object)BigDecimal.ZERO);
            redInvoiceItem.set("num", (Object)oriItem.getBigDecimal("oriitemnum").negate());
            this.calcUnitPriceAndNum(oriItem, redInvoiceItem);
            invoiceAmount = invoiceAmount.add(amount);
            totalTax = totalTax.add(tax);
            DynamicObject item = subItem2ItemMap.get(oriItem.getLong("id"));
            BillRelationDTO relation = new BillRelationDTO(Long.valueOf(matchBill.getLong("id")), matchBill.getString("billno"), Long.valueOf(item.getLong("id")), Long.valueOf(redInvoice.getLong("id")), redInvoice.getString("billno"), Long.valueOf(redInvoiceItem.getLong("id")), amount, tax, redInvoiceItem.getBigDecimal("num"), redInvoiceItem.getBigDecimal("unitprice"), "sim_vatinvoice");
            relation.setsSubDetailId(Long.valueOf(oriItem.getLong("id")));
            relationList.add(relation);
        }
        if (redInvoiceItems.size() <= 8 && "1".equals(redInvoice.getString("inventorymark"))) {
            DynamicObject equipment;
            redInvoice.set("inventorymark", (Object)"0");
            String jqbh = this.getJqbh(blueInvoice, DynamicObjectUtil.getDynamicObjectLongValue((Object)matchBill.get("org")));
            if (StringUtils.isNotBlank((CharSequence)jqbh) && (equipment = EquipmentUtil.getEquipmentDynamicObjectByDevNo((String)jqbh, (String)blueInvoice.getString("salertaxno"))) != null && "4".equals(equipment.getString("equipmenttype"))) {
                redInvoice.set("inventorymark", (Object)"1");
            }
        }
        redInvoice.set("invoiceamount", (Object)invoiceAmount);
        redInvoice.set("totaltax", (Object)totalTax);
        redInvoice.set("totalamount", (Object)invoiceAmount.add(totalTax));
        redInvoice.set("invoicecode", (Object)"");
        redInvoice.set("invoiceno", (Object)"");
        redInvoice.set("issuetime", null);
        redInvoice.set("contraststatus", (Object)"10");
        redInvoice.set("buyertype", (Object)"4");
        redInvoice.set("mergelable", (Object)"");
        ImcSaveServiceHelper.save((DynamicObject)redInvoice);
        return redInvoice;
    }

    private Map<Long, DynamicObject> getItemIdMap(DynamicObject blueInvoice) {
        DynamicObjectCollection invoiceItems = blueInvoice.getDynamicObjectCollection("items");
        HashMap<Long, DynamicObject> itemIdMap = new HashMap<Long, DynamicObject>(invoiceItems.size());
        for (DynamicObject invoiceItem : invoiceItems) {
            itemIdMap.putIfAbsent(invoiceItem.getLong("id"), invoiceItem);
        }
        return itemIdMap;
    }

    private String getJqbh(DynamicObject blueInvoice, Long orgId) {
        String jqbh = blueInvoice.getString("jqbh");
        if (StringUtils.isNotBlank((CharSequence)jqbh)) {
            return jqbh;
        }
        DynamicObject defaultDev = EquipmentUtil.getDefaultDev((Long)orgId);
        if (defaultDev != null) {
            return defaultDev.getString("equipmentno");
        }
        return "";
    }
}

