/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.vehicle.control;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.PermissionHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.utils.VehicleInvoiceValidUtil;

public class VehicleIssueControl {
    private static final ImmutableSet<String> jspEquipmentNos = ImmutableSet.of((Object)InvoiceType.ALL_E_PAPER_USED_CAR.getTypeCode(), (Object)InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode(), (Object)InvoiceType.ALL_E_PAPER_USED_CAR_ELE.getTypeCode(), (Object)InvoiceType.ALL_E_VEHICLE_NORMAL_ELE.getTypeCode());

    public static void issue(AbstractListPlugin that) {
        BillList billList = (BillList)that.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        DynamicObject[] invoiceArray = BusinessDataServiceHelper.load((String)"sim_vatinvoice_vehicles", (String)"salertaxno,invoicetype,jqbh,orgid", (QFilter[])new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues()).toArray());
        HashSet<Long> orgSet = new HashSet<Long>();
        HashSet<String> invoiceTypes = new HashSet<String>();
        for (DynamicObject inv : invoiceArray) {
            String invoiceType = inv.getString("invoicetype");
            if (jspEquipmentNos.contains((Object)invoiceType)) {
                invoiceTypes.add("alle");
            } else {
                invoiceTypes.add("tax");
            }
            orgSet.add(DynamicObjectUtil.getDynamicObjectLongValue((Object)inv.getDynamicObject("orgid")));
        }
        if (orgSet.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u4e2a\u7ec4\u7ec7\u7684\u6570\u636e", (String)"VehicleIssueControl_1", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (invoiceTypes.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u63a7\u53d1\u7968\u548c\u6570\u7535\u7968\u4e0d\u652f\u6301\u540c\u65f6\u63d0\u4ea4\u5f00\u7968\u3002", (String)"VehicleIssueControl_2", (String)"imc-sim-service", (Object[])new Object[0]));
        }
        if (InvoiceType.PAPER_VEHICLE_INVOICE.getTypeCode().equals(invoiceArray[0].getString("invoicetype"))) {
            EquipmentHelper.checkIssueJQBH((DynamicObject[])invoiceArray);
        }
        HashMap<String, Object[]> map = new HashMap<String, Object[]>(4);
        map.put("ids", selectedRows.getPrimaryKeyValues());
        ViewUtil.openDialog((AbstractFormPlugin)that, map, (String)"sim_vehicle_invoice_batch", (String)"sim_vehicle_invoice_batch");
    }

    public static void checkSelectedRowsPermission(AbstractFormPlugin that, ImcPermItemEnum permission) {
        DynamicObject[] invoiceArray;
        BillList billList = (BillList)that.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            return;
        }
        String fields = String.join((CharSequence)",", "orgid", "invoicetype");
        for (DynamicObject invoice : invoiceArray = BusinessDataServiceHelper.load((String)"sim_vatinvoice_vehicles", (String)fields, (QFilter[])new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues()).toArray())) {
            long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid"));
            if (!PermissionHelper.checkOrgPermission((AbstractFormPlugin)that, (ImcPermItemEnum)permission, (Long)orgId)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709%1$s\u7ec4\u7ec7\u7684%2$s\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e", (String)"VehicleIssueControl_0", (String)"imc-sim-service", (Object[])new Object[0]), invoiceArray[0].getDynamicObject("orgid").getString("name"), permission.getDescription()));
            }
            if (ImcPermItemEnum.IMC_SIM_CANCEL_INVOICE == permission) {
                VehicleInvoiceValidUtil.showNoSupportTip((DynamicObject)invoice, (String)ResManager.loadKDString((String)"\u4f5c\u5e9f", (String)"VehicleIssueControl_5", (String)"imc-sim-service", (Object[])new Object[0]), (AbstractFormPlugin)that);
            }
            if (ImcPermItemEnum.INVOICE_PRINT == permission) {
                VehicleInvoiceValidUtil.showNoSupportTip((DynamicObject)invoice, (String)ResManager.loadKDString((String)"\u6253\u5370", (String)"VehicleIssueControl_6", (String)"imc-sim-service", (Object[])new Object[0]), (AbstractFormPlugin)that);
            }
            if (ImcPermItemEnum.INVOICE_PRINT != permission) continue;
            VehicleInvoiceValidUtil.showNoSupportTip((DynamicObject)invoice, (String)ResManager.loadKDString((String)"\u4e0b\u8f7d", (String)"VehicleIssueControl_8", (String)"imc-sim-service", (Object[])new Object[0]), (AbstractFormPlugin)that);
        }
    }
}

