/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.imc.bdm.common.constant.BillRelateInvoicesConstant;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.ImcPermItemEnum;
import kd.imc.bdm.common.constant.table.RedInfoConstant;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BillArchiveHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.helper.SystemParameterHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.dto.ErrorMsgDTO;
import kd.imc.sim.common.helper.CheckCurrentOrgHelper;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BillHelper {
    public static final String SIM_SELECT_DEVICE = "sim_select_device";

    public static boolean isFilledBlue(DynamicObject obj) {
        String blueinvoicecode = obj.getString("blueinvoicecode");
        String blueinvoiceno = obj.getString("blueinvoiceno");
        Object blueIssueTime = obj.get("originalissuetime");
        String infocode = obj.getString("infocode");
        String invoiceType = obj.getString("invoicetype");
        String salerorbuyer = obj.getString("salerorbuyer");
        if ("02".equals(obj.get("specialtype"))) {
            salerorbuyer = "0";
        }
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            if (StringUtils.isNotBlank((CharSequence)infocode)) {
                return true;
            }
            if ("0".equals(salerorbuyer)) {
                return StringUtils.isNotBlank((CharSequence)blueinvoiceno) && blueIssueTime != null;
            }
            return false;
        }
        String applicant = obj.getString("applicant");
        if (!InvoiceUtils.isSpecialInvoice((String)invoiceType) || AllEleAuthHelper.isElePaper((Object)obj.getString("iselepaper"))) {
            return StringUtils.isNotBlank((CharSequence)blueinvoicecode) && StringUtils.isNotBlank((CharSequence)blueinvoiceno);
        }
        if (RedInfoConstant.ApplicantEnum.SALER.getCode().equals(applicant)) {
            return StringUtils.isNotBlank((CharSequence)infocode) || StringUtils.isNotBlank((CharSequence)blueinvoicecode) && StringUtils.isNotBlank((CharSequence)blueinvoiceno) && blueIssueTime != null;
        }
        if (StringUtils.isNotBlank((CharSequence)applicant)) {
            return StringUtils.isNotBlank((CharSequence)infocode);
        }
        return false;
    }

    @SdkDeprecated
    public static boolean isRedInfo(DynamicObject obj) {
        BigDecimal totalamount = obj.getBigDecimal("totalamount");
        String invoiceType = obj.getString("invoicetype");
        return totalamount.compareTo(new BigDecimal(0)) < 0 && InvoiceUtils.isSpecialInvoice((String)invoiceType) && !AllEleAuthHelper.isElePaper((Object)obj.get("iselepaper"));
    }

    public static boolean isAllERedConfirm(DynamicObject obj) {
        BigDecimal totalamount = obj.getBigDecimal("totalamount");
        String invoiceType = obj.getString("invoicetype");
        return totalamount.compareTo(new BigDecimal(0)) < 0 && (InvoiceUtils.isAllEInvoice((Object)invoiceType) || AllEleAuthHelper.isElePaper((Object)obj.get("iselepaper")));
    }

    public static void nextQuery(AbstractFormPlugin that, Object[] primaryKeyValues) {
        if (primaryKeyValues == null || primaryKeyValues.length == 0) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e", (String)"BillHelper_0", (String)"imc-sim-common", (Object[])new Object[0]));
            return;
        }
        IFormView view = that.getView();
        String entityId = view.getEntityId();
        if (view instanceof ListView) {
            entityId = ((ListView)view).getEntityTypeId();
        }
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet("BillHelper.sim_original_bill", entityId, String.join((CharSequence)",", "id", "billsourcetype", "invoicecode", "invoiceno", "matchstatus"), new QFilter("id", "in", (Object)primaryKeyValues).toArray(), "id");){
            boolean hasInvalidBill = false;
            boolean hasCommonBill = false;
            QFilter qFilter = new QFilter("invoicecode", "=", (Object)"-1").and("invoiceno", "=", (Object)"-1");
            ArrayList<Object> matchBillIds = new ArrayList<Object>(primaryKeyValues.length);
            ArrayList<Object> commonBillIds = new ArrayList<Object>(primaryKeyValues.length);
            while (ds.hasNext()) {
                Row obj = ds.next();
                if ("C".equals(obj.getString("billsourcetype"))) {
                    hasInvalidBill = true;
                    QFilter q = new QFilter("invoicecode", "=", obj.get("invoicecode")).and("invoiceno", "=", obj.get("invoiceno"));
                    qFilter.or(q);
                    continue;
                }
                hasCommonBill = true;
                String matchStatus = obj.getString("matchstatus");
                if (StringUtils.isNotBlank((CharSequence)matchStatus) && !MatchBillConstant.MatchStatusEnum.UN_PROCESS.getCode().equals(matchStatus)) {
                    matchBillIds.add(obj.getLong("id"));
                    continue;
                }
                commonBillIds.add(obj.getLong("id"));
            }
            if (hasCommonBill) {
                hasCommonBill = BillHelper.commonNextQuery(that, matchBillIds, commonBillIds);
            }
            if (hasInvalidBill) {
                hasInvalidBill = BillHelper.invalidNextQuery(that, qFilter);
            }
            if (!hasCommonBill && !hasInvalidBill) {
                that.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e", (String)"BillHelper_0", (String)"imc-sim-common", (Object[])new Object[0]));
            }
        }
    }

    private static boolean invalidNextQuery(AbstractFormPlugin that, QFilter qFilter) {
        if (qFilter.toString().equals(new QFilter("invoicecode", "=", (Object)"-1").and("invoiceno", "=", (Object)"-1").toString())) {
            return false;
        }
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"sim_vatinvoice", (String)"id", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)invoices)) {
            return false;
        }
        ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)"sim_invoice_valid_list", (Collection)invoices.stream().map(invoice -> invoice.get("id")).collect(Collectors.toList()));
        return true;
    }

    private static boolean commonNextQuery(AbstractFormPlugin that, List<Object> matchBillIds, List<Object> commonBillIds) {
        HashSet<Object> successInvIds = new HashSet<Object>(commonBillIds.size());
        HashSet<Object> unSuccessInvIds = new HashSet<Object>(commonBillIds.size());
        HashSet<Object> redInfoIds = new HashSet<Object>(commonBillIds.size());
        HashSet<Object> redConfirmBillIds = new HashSet<Object>(commonBillIds.size());
        HashSet botpTBillIds = new HashSet();
        if (!CollectionUtils.isEmpty(matchBillIds)) {
            BillHelper.matchBillTrackDown(matchBillIds, successInvIds, unSuccessInvIds, redInfoIds, redConfirmBillIds);
        }
        if (!CollectionUtils.isEmpty(commonBillIds)) {
            QFilter addfilter;
            DynamicObjectCollection array;
            DynamicObjectCollection relations = OrgHelper.getListByIds((String)"sim_bill_inv_relation", (String)String.join((CharSequence)",", "tbillid", "ttable", "tbillno"), commonBillIds, (String)"sbillid");
            List list = relations.stream().filter(relation -> StringUtils.isNotBlank((CharSequence)relation.getString("tbillno"))).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(list)) {
                List billNos = list.stream().map(o -> o.getString("tbillno")).distinct().collect(Collectors.toList());
                List tbillIdFilter = list.stream().map(o -> o.getLong("tbillid")).distinct().collect(Collectors.toList());
                QFilter qFilter = OrgHelper.getIdFilter(billNos, (String)"billno");
                BillHelper.invoiceQuery(qFilter, successInvIds, unSuccessInvIds);
                BillHelper.redInfoQuery(qFilter, successInvIds, redInfoIds, unSuccessInvIds);
                qFilter.or(OrgHelper.getIdFilter(tbillIdFilter, (String)"id"));
                BillHelper.redConfirmQuery(qFilter, successInvIds, redConfirmBillIds, unSuccessInvIds);
            }
            if (CollectionUtils.isNotEmpty((Collection)(array = QueryServiceHelper.query((String)"sim_bill_add_invoice", (String)"invoicecode,invoiceno,invoiceamount,totalamount,totaltax,invoicetype,serialno", (QFilter[])(addfilter = OrgHelper.getIdFilter(commonBillIds, (String)"originalbillid").and(BillHelper.notCancelFilter())).toArray())))) {
                for (DynamicObject addDynamicObject : array) {
                    QFilter qFilterNo;
                    QFilter qFilterCode = new QFilter("invoicecode", "=", (Object)addDynamicObject.getString("invoicecode"));
                    QFilter queryQFilter = qFilterCode.and(qFilterNo = new QFilter("invoiceno", "=", (Object)addDynamicObject.getString("invoiceno")));
                    DynamicObject invoice = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)"id", (QFilter[])queryQFilter.toArray());
                    if (invoice == null) continue;
                    successInvIds.add(invoice.get("id"));
                }
            }
        }
        if (!CollectionUtils.isEmpty(unSuccessInvIds)) {
            ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)"sim_invoice_wait", unSuccessInvIds);
        }
        if (!CollectionUtils.isEmpty(successInvIds)) {
            ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)"sim_vatinvoice", successInvIds);
        }
        if (!CollectionUtils.isEmpty(redInfoIds)) {
            ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)"sim_red_info", redInfoIds);
        }
        if (!CollectionUtils.isEmpty(redConfirmBillIds)) {
            ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)"sim_red_confirm_bill", redConfirmBillIds);
        }
        commonBillIds.addAll(matchBillIds);
        boolean isPushAr = BillHelper.isPushAr(commonBillIds);
        if (isPushAr) {
            that.getView().invokeOperation("trackdown");
        }
        QFilter billQfilter = OrgHelper.getIdFilter(commonBillIds, (String)"sbillid").and("relationtype", "=", (Object)"0");
        DynamicObjectCollection billRelations = QueryServiceHelper.query((String)"sim_bill_relation", (String)String.join((CharSequence)",", "tbillid"), (QFilter[])billQfilter.toArray());
        Set billIds = billRelations.stream().map(relation -> relation.get("tbillid")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(billIds)) {
            ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)"sim_original_bill", billIds);
        }
        return !CollectionUtils.isEmpty(unSuccessInvIds) || !CollectionUtils.isEmpty(successInvIds) || !CollectionUtils.isEmpty(redInfoIds) || !CollectionUtils.isEmpty(redConfirmBillIds) || !CollectionUtils.isEmpty(billIds) || !CollectionUtils.isEmpty(botpTBillIds);
    }

    public static void matchBillTrackDown(List<Object> matchBillIds, Set<Object> successInvIds, Set<Object> unSuccessInvIds, Set<Object> redInfoIds, Set<Object> redConfirmBillIds) {
        DynamicObjectCollection billRelations = QueryServiceHelper.query((String)"sim_matchbill_relation", (String)"tbillid", (QFilter[])OrgHelper.getIdFilter(matchBillIds, (String)"sbillid").toArray());
        if (CollectionUtils.isEmpty((Collection)billRelations)) {
            return;
        }
        DynamicObjectCollection matchBills = QueryServiceHelper.query((String)"sim_match_bill", (String)String.join((CharSequence)",", "invoicetype", "id"), (QFilter[])OrgHelper.getIdFilter((Collection)billRelations.stream().map(relation -> relation.getLong("tbillid")).collect(Collectors.toSet())).toArray());
        if (CollectionUtils.isEmpty((Collection)matchBills)) {
            return;
        }
        DynamicObjectCollection invRelations = QueryServiceHelper.query((String)"sim_match_inv_relation", (String)String.join((CharSequence)",", "sbillid", "tbillid"), (QFilter[])OrgHelper.getIdFilter((Collection)matchBills.stream().map(matchBill -> matchBill.get("id")).collect(Collectors.toSet()), (String)"sbillid").toArray());
        if (CollectionUtils.isEmpty((Collection)invRelations)) {
            return;
        }
        Map<Object, List<DynamicObject>> invRelationMap = invRelations.stream().collect(Collectors.groupingBy(relation -> relation.get("sbillid")));
        HashSet redConfirmId = new HashSet();
        HashSet redInfoId = new HashSet();
        HashSet invoiceId = new HashSet();
        for (DynamicObject matchBill2 : matchBills) {
            List<DynamicObject> relations = invRelationMap.get(matchBill2.get("id"));
            if (CollectionUtils.isEmpty(relations)) continue;
            if (InvoiceUtils.isAllEInvoice((Object)matchBill2.getString("invoicetype"))) {
                redConfirmId.addAll(relations.stream().map(relation -> relation.get("tbillid")).collect(Collectors.toSet()));
                continue;
            }
            if (InvoiceUtils.isSpecialInvoice((String)matchBill2.getString("invoicetype"))) {
                redInfoId.addAll(relations.stream().map(relation -> relation.get("tbillid")).collect(Collectors.toSet()));
                continue;
            }
            invoiceId.addAll(relations.stream().map(relation -> relation.get("tbillid")).collect(Collectors.toSet()));
        }
        if (!CollectionUtils.isEmpty(invoiceId)) {
            BillHelper.invoiceQuery(OrgHelper.getIdFilter(invoiceId), successInvIds, unSuccessInvIds);
        }
        if (!CollectionUtils.isEmpty(redInfoId)) {
            BillHelper.redInfoQuery(OrgHelper.getIdFilter(redInfoId), successInvIds, redInfoIds, unSuccessInvIds);
        }
        if (!CollectionUtils.isEmpty(redConfirmId)) {
            BillHelper.redConfirmQuery(OrgHelper.getIdFilter(redConfirmId), successInvIds, redConfirmBillIds, unSuccessInvIds);
        }
    }

    public static void invoiceQuery(QFilter qFilter, Set<Object> successInvIds, Set<Object> unSuccessInvIds) {
        DynamicObjectCollection invoiceList = QueryServiceHelper.query((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "id", "issuestatus"), (QFilter[])qFilter.toArray());
        for (DynamicObject invoice : invoiceList) {
            if (IssueStatusEnum.ok.getCode().equals(invoice.getString("issuestatus"))) {
                successInvIds.add(invoice.get("id"));
                continue;
            }
            unSuccessInvIds.add(invoice.get("id"));
        }
    }

    private static void redInfoQuery(QFilter qFilter, Set<Object> successInvIds, Set<Object> redInfoIds, Set<Object> unSuccessInvIds) {
        DynamicObjectCollection redInfos = QueryServiceHelper.query((String)"sim_red_info", (String)String.join((CharSequence)",", "id", "status", "infocode", "invoicecode", "invoiceno", "infosource"), (QFilter[])qFilter.toArray());
        for (DynamicObject redInfo : redInfos) {
            if ("4".equals(redInfo.getString("status"))) {
                DynamicObjectCollection invoices = QueryServiceHelper.query((String)"sim_vatinvoice", (String)"id", (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo(redInfo.getString("invoicecode"), redInfo.getString("invoiceno")).toArray());
                for (DynamicObject invoice : invoices) {
                    successInvIds.add(invoice.get("id"));
                }
                continue;
            }
            if (StringUtils.isBlank((CharSequence)redInfo.getString("infocode"))) {
                redInfoIds.add(redInfo.get("id"));
                continue;
            }
            DynamicObject invoice = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "id", "issuestatus"), (QFilter[])new QFilter("infocode", "=", (Object)redInfo.getString("infocode")).and("invoicestatus", "!=", (Object)"6").toArray());
            if (invoice == null) {
                redInfoIds.add(redInfo.get("id"));
                continue;
            }
            if (IssueStatusEnum.ok.getCode().equals(invoice.getString("issuestatus"))) {
                successInvIds.add(invoice.get("id"));
                continue;
            }
            unSuccessInvIds.add(invoice.get("id"));
        }
    }

    public static void redConfirmQuery(QFilter qFilter, Set<Object> successInvIds, Set<Object> redConfirmBillIds, Set<Object> unSuccessInvIds) {
        DynamicObjectCollection redConfirmBills = QueryServiceHelper.query((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "id", "orderno", "issuestatus", "number", "invoiceno"), (QFilter[])qFilter.toArray());
        for (DynamicObject redConfirmBill : redConfirmBills) {
            if ("0".equals(redConfirmBill.getString("issuestatus"))) {
                DynamicObjectCollection invoices = QueryServiceHelper.query((String)"sim_vatinvoice", (String)"id", (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo("", redConfirmBill.getString("invoiceno")).toArray());
                for (DynamicObject invoice : invoices) {
                    successInvIds.add(invoice.get("id"));
                }
                continue;
            }
            if (StringUtils.isBlank((CharSequence)redConfirmBill.getString("number"))) {
                redConfirmBillIds.add(redConfirmBill.get("id"));
                continue;
            }
            DynamicObject invoice = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "id", "issuestatus"), (QFilter[])new QFilter("orderno", "=", (Object)redConfirmBill.getString("orderno")).toArray());
            if (invoice == null) {
                redConfirmBillIds.add(redConfirmBill.get("id"));
                continue;
            }
            if (IssueStatusEnum.ok.getCode().equals(invoice.getString("issuestatus"))) {
                successInvIds.add(invoice.get("id"));
                continue;
            }
            unSuccessInvIds.add(invoice.get("id"));
        }
    }

    private static boolean isPushAr(List<Object> otherBillIds) {
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"sim_original_bill", (String)String.join((CharSequence)",", "closestatus", "pushamount"), (QFilter[])OrgHelper.getIdFilter(otherBillIds).toArray());
        boolean isPushAr = false;
        for (DynamicObject bill : bills) {
            String closeStatus = bill.getString("closestatus");
            BigDecimal pushAmount = bill.getBigDecimal("pushamount");
            if (!"1".equalsIgnoreCase(closeStatus) || BigDecimalUtil.compareZero((BigDecimal)pushAmount)) continue;
            isPushAr = true;
            break;
        }
        return isPushAr;
    }

    public static void originalBillTrackup(AbstractListPlugin that) {
        Object[] pk;
        ListSelectedRowCollection rows = ((IListView)that.getView()).getSelectedRows();
        String billFormId = ((IListView)that.getView()).getBillFormId();
        if (BillHelper.originalBillTrackup((AbstractFormPlugin)that, billFormId, pk = rows.getPrimaryKeyValues())) {
            that.getView().invokeOperation("trackup");
        }
    }

    public static boolean originalBillTrackup(AbstractFormPlugin that, String billFormId, Object[] pk) {
        QFilter qFilter = new QFilter("tbillid", "in", (Object)pk).and("relationtype", "=", (Object)"0");
        DynamicObjectCollection relations = QueryServiceHelper.query((String)"sim_bill_relation", (String)"sbillid", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)relations)) {
            ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)billFormId, (Collection)relations.stream().map(relation -> relation.get("sbillid")).collect(Collectors.toList()));
        }
        boolean hasXkBills = BillHelper.trackUpXk(that, pk);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)billFormId, (String)"id", (QFilter[])new QFilter("id", "in", (Object)pk).and("billsource", "in", (Object)new String[]{"3", "8"}).toArray());
        if (bills.size() != 0) {
            ArrayList pkList = new ArrayList(bills.size());
            bills.forEach(obj -> pkList.add(obj.getLong("id")));
            Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)"sim_original_bill", (Long[])pkList.toArray(new Long[0]));
            for (Map.Entry map : sourceBills.entrySet()) {
                String archEntity = BillArchiveHelper.getArchiveEnetity((String)((String)map.getKey()));
                if (StringUtils.isEmpty((CharSequence)archEntity)) continue;
                ArrayList list = new ArrayList(((HashSet)map.getValue()).size());
                list.addAll((Collection)map.getValue());
                DynamicObjectCollection collect = QueryServiceHelper.query((String)archEntity, (String)"id", (QFilter[])new QFilter("id", "in", list).toArray());
                ArrayList viewList = new ArrayList(collect.size());
                collect.forEach(obj -> viewList.add(obj.getLong("id")));
                if (!viewList.isEmpty()) {
                    ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)archEntity, viewList);
                    list.remove(viewList);
                }
                if (!list.isEmpty()) {
                    ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)((String)map.getKey()), list);
                }
                return false;
            }
            return true;
        }
        if (CollectionUtils.isEmpty((Collection)relations) && !hasXkBills) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e", (String)"BillHelper_0", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        return false;
    }

    private static boolean trackUpXk(AbstractFormPlugin that, Object[] pk) {
        if (!MetadataDao.checkNumber((String)"iv_salebill")) {
            return false;
        }
        DynamicObjectCollection xkBills = QueryServiceHelper.query((String)"sim_original_bill", (String)"orgid.id,billno", (QFilter[])new QFilter("id", "in", (Object)pk).and("systemsource", "=", (Object)"XKQJ").toArray());
        if (xkBills.size() == 0) {
            return false;
        }
        Map<Object, List<DynamicObject>> groupBills = xkBills.stream().collect(Collectors.groupingBy(k -> k.get("orgid.id")));
        Set<Map.Entry<Object, List<DynamicObject>>> entries = groupBills.entrySet();
        ArrayList pks = new ArrayList(xkBills.size());
        for (Map.Entry<Object, List<DynamicObject>> entry : entries) {
            QFilter qFilter = new QFilter("org", "=", entry.getKey()).and("billno", "in", (Object)entry.getValue().stream().map(bill -> bill.getString("billno")).toArray());
            DynamicObjectCollection bills = QueryServiceHelper.query((String)"iv_salebill", (String)"id", (QFilter[])qFilter.toArray());
            pks.addAll(bills.stream().map(bill -> bill.get("id")).collect(Collectors.toList()));
        }
        if (CollectionUtils.isEmpty(pks)) {
            return false;
        }
        if (pks.size() == 1) {
            BillShowParameter listParam = new BillShowParameter();
            listParam.setPkId(pks.get(0));
            listParam.setStatus(OperationStatus.VIEW);
            listParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            listParam.setFormId("iv_salebill");
            that.getView().showForm((FormShowParameter)listParam);
        } else {
            ViewUtil.openTrackListPage((AbstractFormPlugin)that, (String)"iv_salebill", pks);
        }
        return true;
    }

    public static void trackup(AbstractListPlugin that, String ttable, Object[] selectRowPks) {
        DynamicObject[] billRelations;
        DynamicObject[] relations;
        HashSet<String> tbillNos = new HashSet<String>(selectRowPks.length);
        HashSet<Object> tbillIds = new HashSet<Object>(selectRowPks.length);
        HashSet<Object> sbillIds = new HashSet<Object>(selectRowPks.length);
        HashSet<Object> matchInvIds = new HashSet<Object>(selectRowPks.length);
        if ("sim_vatinvoice".equals(ttable)) {
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "billno", "invoiceamount", "invoicetype", "infocode", "orgid", "contraststatus"), (QFilter[])new QFilter("id", "in", (Object)selectRowPks).toArray());
            CheckCurrentOrgHelper.checkSelectRowsCurrentAuthor((AbstractFormPlugin)that, ImcPermItemEnum.IMC_PRE_QUERY, invoices);
            BillHelper.invoiceTrackUp(invoices, tbillNos, tbillIds, sbillIds, matchInvIds);
        } else if ("sim_red_info".equals(ttable)) {
            DynamicObjectCollection redInfos = QueryServiceHelper.query((String)"sim_red_info", (String)String.join((CharSequence)",", "id", "billno", "org", "infosource"), (QFilter[])new QFilter("id", "in", (Object)selectRowPks).toArray());
            BillHelper.redInfoTrackUp(redInfos, tbillIds, tbillNos, matchInvIds);
        } else {
            DynamicObjectCollection redConfirmBills = QueryServiceHelper.query((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "source", "id"), (QFilter[])new QFilter("id", "in", (Object)selectRowPks).toArray());
            BillHelper.redConfirmTrackUp(redConfirmBills, matchInvIds, tbillIds);
        }
        if (tbillNos.size() != 0 || tbillIds.size() != 0) {
            QFilter qFilter = new QFilter("1", "=", (Object)-1);
            if (tbillNos.size() != 0) {
                qFilter.or(OrgHelper.getIdFilter(tbillNos, (String)"tbillno"));
            }
            if (tbillIds.size() != 0) {
                qFilter.or(OrgHelper.getIdFilter(tbillIds, (String)"tbillid"));
            }
            DynamicObjectCollection list = QueryServiceHelper.query((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])qFilter.toArray());
            sbillIds.addAll(list.stream().map(relation -> relation.get("sbillid")).collect(Collectors.toList()));
        }
        if (sbillIds.size() == 0 && matchInvIds.size() == 0) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e", (String)"BillHelper_0", (String)"imc-sim-common", (Object[])new Object[0]));
            return;
        }
        if (matchInvIds.size() != 0 && (relations = BusinessDataServiceHelper.load((String)"sim_match_inv_relation", (String)"sbillid", (QFilter[])OrgHelper.getIdFilter(matchInvIds, (String)"tbillid").toArray())).length != 0 && (billRelations = BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)"sbillid", (QFilter[])OrgHelper.getIdFilter((Collection)Arrays.stream(relations).map(relation -> relation.get("sbillid")).collect(Collectors.toSet()), (String)"tbillid").toArray())).length != 0) {
            sbillIds.addAll(Arrays.stream(billRelations).map(relation -> relation.get("sbillid")).collect(Collectors.toSet()));
        }
        BillHelper.trackupOriginalBill(that, "sim_original_bill", sbillIds);
    }

    public static void trackupOriginalBill(AbstractListPlugin plugin, String tableId, Set<Object> sbillIds) {
        if (sbillIds != null && !sbillIds.isEmpty()) {
            Set hisSbillIds;
            Map<String, Object> splitReuslt = BillHelper.splitOriginalBillSbillIds(tableId, sbillIds);
            Set newSbillIds = (Set)splitReuslt.get(tableId);
            if (newSbillIds != null && !newSbillIds.isEmpty()) {
                ViewUtil.openTrackListPage((AbstractFormPlugin)plugin, (String)tableId, (Collection)newSbillIds);
            }
            if ((hisSbillIds = (Set)splitReuslt.get("hisBillIds")) != null && !hisSbillIds.isEmpty()) {
                ViewUtil.openTrackListPage((AbstractFormPlugin)plugin, (String)((String)splitReuslt.get("hisTable")), (Collection)hisSbillIds);
            }
        }
    }

    private static Map<String, Object> splitOriginalBillSbillIds(String tableId, Set<Object> sbillIds) {
        String config = ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.ORIGINAL_BILL_BACKUP);
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        if (StringUtils.isEmpty((CharSequence)config)) {
            result.put(tableId, sbillIds);
        } else {
            DynamicObjectCollection collect = QueryServiceHelper.query((String)"sim_original_bill", (String)"id", (QFilter[])new QFilter("id", "in", sbillIds).toArray());
            HashSet<Long> newSbillIds = new HashSet<Long>(collect.size());
            for (DynamicObject object : collect) {
                newSbillIds.add(object.getLong("id"));
            }
            if (!newSbillIds.isEmpty()) {
                sbillIds.removeAll(newSbillIds);
            }
            result.put(tableId, newSbillIds);
            result.put("hisBillIds", sbillIds);
            result.put("hisTable", config);
        }
        return result;
    }

    private static void redInfoTrackUp(DynamicObjectCollection redInfos, Set<Object> tbillIds, Set<String> tbillNos, Set<Object> matchInvIds) {
        for (DynamicObject redInfo : redInfos) {
            if ("10".equals(redInfo.getString("infosource"))) {
                matchInvIds.add(redInfo.get("id"));
                continue;
            }
            tbillIds.add(redInfo.get("id"));
            String billNo = redInfo.getString("billno");
            if (!StringUtils.isNotBlank((CharSequence)billNo)) continue;
            tbillNos.add(billNo);
        }
    }

    private static void invoiceTrackUp(DynamicObject[] invoices, Set<String> tbillNos, Set<Object> tbillIds, Set<Object> sbillIds, Set<Object> matchInvIds) {
        ArrayList<String> infoCodes = new ArrayList<String>(invoices.length);
        ArrayList<String> redConfirmBillNos = new ArrayList<String>(invoices.length);
        for (DynamicObject invoice : invoices) {
            String billNo = invoice.getString("billno");
            if (StringUtils.isNotBlank((CharSequence)billNo)) {
                tbillNos.add(billNo);
            }
            if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) > 0) continue;
            String invoiceType = invoice.getString("invoicetype");
            if (InvoiceUtils.isNormalInvoice((String)invoice.getString("invoicetype"))) {
                if (!"10".equals(invoice.getString("contraststatus"))) continue;
                matchInvIds.add(invoice.getPkValue());
                tbillNos.remove(invoice.getString("billno"));
                continue;
            }
            String infoCode = invoice.getString("infocode");
            if (StringUtils.isBlank((CharSequence)infoCode)) continue;
            if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                redConfirmBillNos.add(infoCode);
                continue;
            }
            infoCodes.add(infoCode);
        }
        if (infoCodes.size() != 0) {
            DynamicObjectCollection redInfos = QueryServiceHelper.query((String)"sim_red_info", (String)String.join((CharSequence)",", "id", "billno", "org", "infosource"), (QFilter[])new QFilter("infocode", "in", infoCodes).toArray());
            BillHelper.redInfoTrackUp(redInfos, tbillIds, tbillNos, matchInvIds);
        }
        if (!CollectionUtils.isEmpty(redConfirmBillNos)) {
            DynamicObjectCollection redConfirmBills = QueryServiceHelper.query((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "id", "source"), (QFilter[])new QFilter("number", "in", redConfirmBillNos).toArray());
            BillHelper.redConfirmTrackUp(redConfirmBills, matchInvIds, tbillIds);
        }
        QFilter addfilter = new QFilter("invoiceid", "in", (Object)Stream.of(invoices).map(inv -> String.valueOf(inv.getPkValue().toString())).toArray()).and(BillHelper.notCancelFilter());
        DynamicObjectCollection array = QueryServiceHelper.query((String)"sim_bill_add_invoice", (String)"originalbillid", (QFilter[])addfilter.toArray());
        sbillIds.addAll(array.stream().map(add -> add.get("originalbillid")).collect(Collectors.toList()));
    }

    private static void redConfirmTrackUp(DynamicObjectCollection redConfirmBills, Set<Object> matchInvIds, Set<Object> tBillIds) {
        for (DynamicObject redConfirmBill : redConfirmBills) {
            if ("10".equals(redConfirmBill.getString("source"))) {
                matchInvIds.add(redConfirmBill.get("id"));
                continue;
            }
            tBillIds.add(redConfirmBill.get("id"));
        }
    }

    public static void clearWorkbench(ListSelectedRowCollection rows) {
        if (rows.size() == 0) {
            return;
        }
        BillHelper.clearWorkbench(rows.getPrimaryKeyValues());
    }

    public static void clearWorkbench(Object[] pks) {
        String currentUserId = RequestContext.get().getUserId();
        for (Object pk : pks) {
            String cacheUserId = CacheHelper.get((String)(pk + "workbench"));
            if (!currentUserId.equals(cacheUserId)) continue;
            CacheHelper.remove((String)(pk + "workbench"));
        }
    }

    @SdkDeprecated
    public static String getBillStatusByTableName(String tableName, String source) {
        String billStatusStr = ImcConfigUtil.getValue((String)"sim_not_approval_required", (String)tableName);
        if (StringUtils.isBlank((CharSequence)billStatusStr)) {
            return BillStatusEnum.NO_APPROVAL_REQUIRED.getCode();
        }
        try {
            if (billStatusStr.length() == 1) {
                return BillHelper.getBillStatus(billStatusStr);
            }
            if (StringUtils.isBlank((CharSequence)(billStatusStr = JSONObject.parseObject((String)billStatusStr).getString(source)))) {
                return BillStatusEnum.NO_APPROVAL_REQUIRED.getCode();
            }
            return BillHelper.getBillStatus(billStatusStr);
        }
        catch (Exception e) {
            return BillStatusEnum.NO_APPROVAL_REQUIRED.getCode();
        }
    }

    private static String getBillStatus(String billStatusStr) {
        if (Arrays.stream(BillStatusEnum.values()).anyMatch(status -> status.getCode().equals(billStatusStr))) {
            return billStatusStr;
        }
        return BillStatusEnum.NO_APPROVAL_REQUIRED.getCode();
    }

    public static String getComprehensiveStatusByBillStatus(String billStatus) {
        if (StringUtils.isBlank((CharSequence)billStatus)) {
            return "";
        }
        if (BillStatusEnum.TEMP_SAVE.getCode().equals(billStatus)) {
            return "11";
        }
        if (BillStatusEnum.IN_AUDIT.getCode().equals(billStatus)) {
            return "12";
        }
        if (BillStatusEnum.AUDIT_SUCCESS.getCode().equals(billStatus)) {
            return "01";
        }
        if (BillStatusEnum.NO_APPROVAL_REQUIRED.getCode().equals(billStatus)) {
            return "01";
        }
        return "";
    }

    public static String getBatchNumbersuffix(int index) {
        int digit;
        StringBuilder suffix = new StringBuilder(String.valueOf(index));
        for (int i = digit = suffix.toString().length(); i < 4; ++i) {
            suffix.insert(0, '0');
        }
        return suffix.toString();
    }

    @Deprecated
    public static ErrorMsgDTO checkInvoiceSpecialGoodCodeRemark(DynamicObject invoiceDynamicObject) {
        return null;
    }

    @Deprecated
    public static ErrorMsgDTO checkInvoiceListSpecialGoodCodeRemark(List<DynamicObject> batchSourceInvoiceList) {
        return null;
    }

    @Deprecated
    public static ErrorMsgDTO checkInvoiceSpecialGoodCodeRemark(ListSelectedRowCollection rows) {
        return null;
    }

    @Deprecated
    public static ErrorMsgDTO checkRedInfoSpecialGoodCodeRemark(ListSelectedRowCollection rows) {
        return null;
    }

    public static ErrorMsgDTO checkBillSpecialGoodCodeRemark(DynamicObject[] dynamicObjects) {
        return null;
    }

    @Deprecated
    public static ErrorMsgDTO checkSpecialGoodCodeRemark(AbstractFormPlugin that, JSONObject dataArr, String from) {
        return null;
    }

    public static ErrorMsgDTO checkSplitSpecialGoodCodeRemark(String ars, String from) {
        return null;
    }

    @SdkDeprecated
    public static void checkIssuePushSpecialCodeRemark(AbstractFormPlugin that, DynamicObject[] bills, HashSet<Object> typeSet) {
        BillHelper.issuePushBill(that, Stream.of(bills).map(DataEntityBase::getPkValue).toArray(), typeSet, bills[0].getString("drawer"));
    }

    @Deprecated
    public static void issuePushBill(AbstractFormPlugin that, Object[] pks, HashSet<Object> typeSet) {
        BillHelper.issuePushBill(that, pks, typeSet, null);
    }

    public static void issuePushBill(AbstractFormPlugin that, Object[] pks, HashSet<Object> typeSet, String drawer) {
        try {
            HashMap params = Maps.newHashMap();
            params.put("pks", pks);
            params.put("typeSet", typeSet);
            params.put("drawer", drawer);
            ViewUtil.openDialog((AbstractFormPlugin)that, (Map)params, (String)SIM_SELECT_DEVICE, (String)"btn_clickopeninvoice");
        }
        catch (Exception e) {
            that.getView().showTipNotification(e.getMessage());
        }
    }

    @SdkDeprecated
    public static int getBillLimitCount() {
        return BillHelper.getLimitCount(CacheKeyEnum.SIM_ORIGINAL_BILL_SUBMIT_LIMIT.getConfigType(), CacheKeyEnum.SIM_ORIGINAL_BILL_SUBMIT_LIMIT.getConfigKey(), Integer.parseInt(CacheKeyEnum.SIM_ORIGINAL_BILL_SUBMIT_LIMIT.getDefaultValue()));
    }

    public static int getBillItemLimitCount() {
        return BillHelper.getLimitCount("sim_originalbill_config", "submit_item_limit_count", 30000);
    }

    public static int getLimitCount(String configType, String configKey, int defaultCount) {
        try {
            defaultCount = Integer.parseInt(ImcConfigUtil.getValue((String)configType, (String)configKey));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (defaultCount < 0) {
            defaultCount = 0;
        }
        return defaultCount;
    }

    @SdkDeprecated
    public static void checkRelation(List<Object> relateOriginalBillPks, List<Object> relateInvoiceBillPks, List<Object> redConfirmBillPks) {
        if (!relateInvoiceBillPks.isEmpty()) {
            HashSet<Object> tBillPks = BillHelper.getRelatePks(relateInvoiceBillPks);
            QFilter issuedFilter = new QFilter("issuestatus", "=", (Object)IssueStatusEnum.ok.getCode());
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)"invoiceno", (QFilter[])new QFilter("id", "in", (Object)tBillPks.toArray()).and(issuedFilter).toArray());
            if (invoices.length != tBillPks.size()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5b58\u5728\u672a\u5f00\u5177\u7684\u53d1\u7968\uff0c\u4e0d\u652f\u6301\u5173\u95ed", (String)"BillHelper_10", (String)"imc-sim-common", (Object[])new Object[0]));
            }
        }
        if (!relateOriginalBillPks.isEmpty()) {
            DynamicObject[] redInfos;
            HashSet<Object> redInfoPks = BillHelper.getRelatePks(relateOriginalBillPks);
            for (DynamicObject redInfo : redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)"issuetime", (QFilter[])new QFilter("id", "in", (Object)redInfoPks.toArray()).toArray())) {
                Object issueTime = redInfo.get("issuetime");
                if (null != issueTime) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5b58\u5728\u672a\u5f00\u5177\u7684\u53d1\u7968\uff0c\u4e0d\u652f\u6301\u5173\u95ed", (String)"BillHelper_10", (String)"imc-sim-common", (Object[])new Object[0]));
            }
        }
        if (!redConfirmBillPks.isEmpty()) {
            DynamicObject[] redConfirms;
            HashSet<Object> redConfirmPks = BillHelper.getRelatePks(redConfirmBillPks);
            for (DynamicObject redConfirm : redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"invoiceno", (QFilter[])new QFilter("id", "in", (Object)redConfirmPks.toArray()).toArray())) {
                String invoiceNo = (String)redConfirm.get("invoiceno");
                if (!StringUtils.isBlank((CharSequence)invoiceNo)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5b58\u5728\u672a\u5f00\u5177\u7684\u53d1\u7968\uff0c\u4e0d\u652f\u6301\u5173\u95ed", (String)"BillHelper_10", (String)"imc-sim-common", (Object[])new Object[0]));
            }
        }
    }

    private static HashSet<Object> getRelatePks(List<Object> relateInvoicePks) {
        QFilter deleteFilter = new QFilter("isdelete", "!=", (Object)"Y");
        QFilter filter = new QFilter("sbillid", "in", (Object)relateInvoicePks.toArray()).and(deleteFilter);
        DynamicObject[] relations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"tbillid", (QFilter[])filter.toArray());
        HashSet<Object> tBillPks = new HashSet<Object>();
        for (DynamicObject relation : relations) {
            tBillPks.add(relation.get("tbillid"));
        }
        return tBillPks;
    }

    public static void clearRedInvoiceData(DynamicObject reIssueBill) {
        reIssueBill.set("blueinvoicecode", (Object)"");
        reIssueBill.set("blueinvoiceno", (Object)"");
        reIssueBill.set("originalissuetime", null);
        reIssueBill.set("blueinvoicetype", (Object)"");
        reIssueBill.set("redreason", (Object)"");
        reIssueBill.set("applicant", (Object)"");
        reIssueBill.set("infocode", (Object)"");
    }

    public static QFilter notCancelFilter() {
        return new QFilter("iscancel", "!=", (Object)BillRelateInvoicesConstant.IsCancelEnum.YES);
    }

    public static boolean isBillFromQrScan(String billSource) {
        return "7".equals(billSource) || "5".equals(billSource);
    }

    public static StringBuilder getNegativeBillDiffError(DynamicObject[] bills) {
        StringBuilder stringBuilder = new StringBuilder();
        for (DynamicObject bill : bills) {
            String error;
            BigDecimal redConfirmDiff;
            BigDecimal negativeBillDiff;
            DynamicObject redConfirm;
            if (!StringUtils.isNotEmpty((CharSequence)bill.getString("infocode")) || (redConfirm = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill"), (QFilter[])new QFilter("number", "=", (Object)bill.getString("infocode")).toArray())) == null || MathUtils.isZero(negativeBillDiff = SystemParameterHelper.getSimParameterBigDecimal((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("orgid")), (String)"negativebilldiff"))) continue;
            BigDecimal configDiff = negativeBillDiff.abs();
            if (configDiff.subtract(redConfirmDiff = redConfirm.getBigDecimal("totaltax").abs().subtract(bill.getBigDecimal("totaltax").abs()).abs()).compareTo(BigDecimal.ZERO) < 0) {
                error = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s,\u5408\u8ba1\u7a0e\u989d\u4e0e\u7ea2\u5b57\u786e\u8ba4\u5355\u7a0e\u989d\u5dee\u5f02\u5df2\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u5b58\u5728\u7a0e\u989d\u5dee\u5f02\u4e3a%2$s,\u5141\u8bb8\u5bb9\u5dee\u8303\u56f4\u00b1%3$s,\u5355\u636e\u7a0e\u989d%4$s,\u7ea2\u5b57\u786e\u8ba4\u5355\u7a0e\u989d%5$s", (String)"BillHelper_13", (String)"imc-sim-common", (Object[])new Object[0]), bill.getString("billno"), redConfirmDiff.stripTrailingZeros().toPlainString(), configDiff, bill.getBigDecimal("totaltax").stripTrailingZeros().toPlainString(), redConfirm.getBigDecimal("totaltax").stripTrailingZeros().toPlainString());
                throw new KDBizException(error);
            }
            if (redConfirmDiff.compareTo(BigDecimal.ZERO) == 0) continue;
            error = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s,\u5408\u8ba1\u7a0e\u989d\u4e0e\u7ea2\u5b57\u786e\u8ba4\u5355\u5b58\u5728\u7a0e\u989d\u5dee\u5f02\u4e3a%2$s,\u5141\u8bb8\u5bb9\u5dee\u8303\u56f4\u00b1%3$s,\u5355\u636e\u7a0e\u989d%4$s,\u7ea2\u5b57\u786e\u8ba4\u5355\u7a0e\u989d%5$s", (String)"BillHelper_12", (String)"imc-sim-common", (Object[])new Object[0]), bill.getString("billno"), redConfirmDiff.stripTrailingZeros().toPlainString(), configDiff.stripTrailingZeros().toPlainString(), bill.getBigDecimal("totaltax").stripTrailingZeros().toPlainString(), redConfirm.getBigDecimal("totaltax").stripTrailingZeros().toPlainString());
            stringBuilder.append(error).append("\n");
        }
        return stringBuilder;
    }

    public static StringBuilder getMatchNegativeBillDiffError(DynamicObjectCollection matchBills) {
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<Long> matchBillIds = new HashSet<Long>(1);
        for (DynamicObject matchBill : matchBills) {
            String error;
            BigDecimal redConfirmDiff;
            BigDecimal negativeBillDiff;
            DynamicObject redConfirm;
            String infoCode;
            if (matchBillIds.contains(matchBill.getLong("id"))) continue;
            matchBillIds.add(matchBill.getLong("id"));
            DynamicObjectCollection relationList = QueryServiceHelper.query((String)"sim_matchbill_relation", (String)"sbillid", (QFilter[])OrgHelper.getIdFilter((Collection)Lists.newArrayList((Object[])new Long[]{matchBill.getLong("id")}), (String)"tbillid").toArray());
            List billPks = relationList.stream().map(relation -> relation.getLong("sbillid")).distinct().collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", billPks);
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill"), (QFilter[])qFilter.toArray());
            if (null == bills || bills.length == 0 || !StringUtils.isNotEmpty((CharSequence)(infoCode = bills[0].getString("infocode"))) || (redConfirm = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill"), (QFilter[])new QFilter("number", "=", (Object)infoCode).toArray())) == null || MathUtils.isZero(negativeBillDiff = SystemParameterHelper.getSimParameterBigDecimal((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)matchBill.get("org")), (String)"negativebilldiff"))) continue;
            BigDecimal configDiff = negativeBillDiff.abs();
            if (configDiff.subtract(redConfirmDiff = redConfirm.getBigDecimal("totaltax").abs().subtract(matchBill.getBigDecimal("applytax").abs()).abs()).compareTo(BigDecimal.ZERO) < 0) {
                error = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s,\u5408\u8ba1\u7a0e\u989d\u4e0e\u7ea2\u5b57\u786e\u8ba4\u5355\u7a0e\u989d\u5dee\u5f02\u5df2\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u5b58\u5728\u7a0e\u989d\u5dee\u5f02\u4e3a%2$s,\u5141\u8bb8\u5bb9\u5dee\u8303\u56f4\u00b1%3$s,\u5355\u636e\u7a0e\u989d%4$s,\u7ea2\u5b57\u786e\u8ba4\u5355\u7a0e\u989d%5$s", (String)"BillHelper_13", (String)"imc-sim-common", (Object[])new Object[0]), matchBill.getString("billno"), redConfirmDiff.stripTrailingZeros().toPlainString(), configDiff, matchBill.getBigDecimal("applytax").stripTrailingZeros().toPlainString(), redConfirm.getBigDecimal("totaltax").stripTrailingZeros().toPlainString());
                throw new KDBizException(error);
            }
            if (redConfirmDiff.compareTo(BigDecimal.ZERO) == 0) continue;
            error = String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%1$s,\u5408\u8ba1\u7a0e\u989d\u4e0e\u7ea2\u5b57\u786e\u8ba4\u5355\u5b58\u5728\u7a0e\u989d\u5dee\u5f02\u4e3a%2$s,\u5141\u8bb8\u5bb9\u5dee\u8303\u56f4\u00b1%3$s,\u5355\u636e\u7a0e\u989d%4$s,\u7ea2\u5b57\u786e\u8ba4\u5355\u7a0e\u989d%5$s", (String)"BillHelper_12", (String)"imc-sim-common", (Object[])new Object[0]), matchBill.getString("billno"), redConfirmDiff.stripTrailingZeros().toPlainString(), configDiff.stripTrailingZeros().toPlainString(), matchBill.getBigDecimal("applytax").stripTrailingZeros().toPlainString(), redConfirm.getBigDecimal("totaltax").stripTrailingZeros().toPlainString());
            stringBuilder.append(error).append("\n");
        }
        return stringBuilder;
    }
}

