/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.constant.table.OriginalBillConstant;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.helper.log.AppLogInfoHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.ItemMerge2OneHelper;
import kd.imc.sim.common.helper.NegativeBillMatchHelper;
import org.apache.commons.lang3.StringUtils;

public class BillRollbackHelper {
    private static final Log LOG = LogFactory.getLog(BillRollbackHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(AbstractFormPlugin that, Object[] pks, String tTable) {
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("\u5f00\u59cb\u56de\u9000%s\uff0cid\u662f\uff1a[%s]", "sim_red_info".equals(tTable) ? "\u7ea2\u5b57\u4fe1\u606f\u8868" : "\u53d1\u7968", Stream.of(pks).map(String::valueOf).collect(Collectors.joining(","))));
        }
        if ((pks = ItemMerge2OneHelper.rollBackWaitInvoice(pks)).length == 0) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u5408\u5e76\u4e3a1\u56de\u9000\u6210\u529f");
            }
            that.getView().showSuccessNotification(ResManager.loadKDString((String)"\u56de\u9000\u6210\u529f", (String)"BillRollbackHelper_0", (String)"imc-sim-common", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        try (TXHandle tx = TX.required();){
            if ("sim_vatinvoice".equals(tTable)) {
                this.waitInvoiceRollback(that, pks);
                return;
            }
            this.doRollBack(that, pks, tTable);
        }
    }

    private void waitInvoiceRollback(AbstractFormPlugin that, Object[] pks) {
        if (LOG.isInfoEnabled()) {
            LOG.info("\u5f00\u59cb\u8fdb\u884c\u5f85\u5f00\u56de\u9000");
        }
        ArrayList<Object> rollbackIds = new ArrayList<Object>(Arrays.asList(pks));
        QFilter qFilter = new QFilter("id", "in", (Object)pks).and("invoiceamount", "<", (Object)BigDecimal.ZERO).and("contraststatus", "=", (Object)"10");
        DynamicObject[] userAddWaitInvoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "orderno", "invoicetype", "originalinvoicecode", "originalinvoiceno"), (QFilter[])qFilter.toArray());
        if (userAddWaitInvoices.length != 0) {
            DynamicObject[] rollbackMatchBillArr = (DynamicObject[])Arrays.stream(userAddWaitInvoices).filter(invoice -> InvoiceUtils.isNormalInvoice((String)invoice.getString("invoicetype"))).toArray(DynamicObject[]::new);
            this.rollbackMatchBill(rollbackMatchBillArr);
            this.deleteInvoiceWait(rollbackIds, userAddWaitInvoices);
        }
        qFilter = new QFilter("id", "in", rollbackIds).and("invoicetype", "in", (Object)InvoiceUtils.getSpecialInvoiceType()).and("invoiceamount", "<", (Object)BigDecimal.ZERO).and("contraststatus", "!=", (Object)"10");
        userAddWaitInvoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "infocode", "orgid", "orderno"), (QFilter[])qFilter.toArray());
        if (userAddWaitInvoices.length != 0) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u7ea2\u5b57\u4fe1\u606f\u8868\u751f\u6210\u7684\u5f85\u5f00\u8fdb\u884c\u56de\u9000, \u6d41\u6c34\u53f7\u662f[%s]", Arrays.stream(userAddWaitInvoices).map(inv -> inv.getString("orderno")).collect(Collectors.joining(","))));
            }
            this.deleteInvoiceWait(rollbackIds, userAddWaitInvoices);
            this.userAddredInfoRollback(userAddWaitInvoices);
        }
        qFilter = new QFilter("id", "in", rollbackIds).and("invoicetype", "in", (Object)InvoiceUtils.getAllEInvoiceType()).and("contraststatus", "!=", (Object)"10").and("invoiceamount", "<", (Object)BigDecimal.ZERO);
        userAddWaitInvoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "infocode", "orgid", "orderno"), (QFilter[])qFilter.toArray());
        if (userAddWaitInvoices.length != 0) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u7ea2\u5b57\u786e\u8ba4\u5355\u751f\u6210\u7684\u5f85\u5f00\u8fdb\u884c\u56de\u9000, \u6d41\u6c34\u53f7\u662f[%s]", Arrays.stream(userAddWaitInvoices).map(inv -> inv.getString("orderno")).collect(Collectors.joining(","))));
            }
            this.deleteInvoiceWait(rollbackIds, userAddWaitInvoices);
            this.redConfirmBillRollback(userAddWaitInvoices);
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(rollbackIds)) {
            that.getView().showSuccessNotification(ResManager.loadKDString((String)"\u56de\u9000\u6210\u529f", (String)"BillRollbackHelper_0", (String)"imc-sim-common", (Object[])new Object[0]));
            return;
        }
        this.doRollBack(that, rollbackIds.toArray(), "sim_vatinvoice");
    }

    private void rollbackMatchBill(DynamicObject[] userAddWaitInvoices) {
        if (userAddWaitInvoices == null || userAddWaitInvoices.length == 0) {
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("\u5339\u914d\u63a8\u9001\u7684\u5f85\u5f00\u56de\u9000, \u6d41\u6c34\u53f7\u662f[%s]", Arrays.stream(userAddWaitInvoices).map(inv -> inv.getString("orderno")).collect(Collectors.joining(","))));
        }
        HashSet<String> invoiceCodeNoSet = new HashSet<String>(userAddWaitInvoices.length);
        ArrayList<Object> invoicePks = new ArrayList<Object>(userAddWaitInvoices.length);
        for (DynamicObject invoice : userAddWaitInvoices) {
            invoiceCodeNoSet.add(invoice.getString("originalinvoicecode") + "\u25cf\u25c6\u25a0" + invoice.getString("originalinvoiceno"));
            invoicePks.add(invoice.getPkValue());
        }
        this.changeMatchBillPushStatus(new ArrayList<Object>(1), invoiceCodeNoSet, invoicePks);
        DeleteServiceHelper.delete((String)"sim_match_inv_relation", (QFilter[])OrgHelper.getIdFilter(invoicePks, (String)"tbillid").toArray());
    }

    private void deleteInvoiceWait(List<Object> rollbackIds, DynamicObject[] userAddWaitInvoices) {
        List userAddWaitInvoiceIds = Stream.of(userAddWaitInvoices).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        rollbackIds.removeIf(userAddWaitInvoiceIds::contains);
        if (LOG.isInfoEnabled()) {
            LOG.info("\u5220\u9664\u5f85\u5f00\u6570\u636e");
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"), (Object[])userAddWaitInvoiceIds.toArray());
    }

    public void userAddredInfoRollback(DynamicObject[] userAddWaitInvoices) {
        for (DynamicObject invoice2 : userAddWaitInvoices) {
            if (!StringUtils.isBlank((CharSequence)invoice2.getString("infocode"))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%s\u5bf9\u5e94\u7684\u7ea2\u5b57\u4fe1\u606f\u8868\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u56de\u9000", (String)"BillRollbackHelper_4", (String)"imc-sim-common", (Object[])new Object[0]), invoice2.getString("orderno")));
        }
        QFilter qFilter = new QFilter("infocode", "in", (Object)Stream.of(userAddWaitInvoices).map(invoice -> invoice.getString("infocode")).toArray()).and("org", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)userAddWaitInvoices[0].get("orgid")));
        DynamicObject[] userAddRedInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)String.format("%s, %s, %s, %s", "infosource", "systemsource", "billno", "batchbelong"), (QFilter[])qFilter.toArray());
        if (userAddRedInfos.length == 0) {
            return;
        }
        DynamicObject[] originalBillIdRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"sbillid", (QFilter[])new QFilter("tbillid", "in", (Object)Stream.of(userAddRedInfos).map(DataEntityBase::getPkValue).toArray()).and("isdelete", "!=", (Object)"Y").toArray());
        DynamicObject[] waitInvoiceIdRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)"tbillid", (QFilter[])new QFilter("sbillid", "in", (Object)Stream.of(originalBillIdRelations).map(relation -> relation.getLong("sbillid")).toArray()).and("isdelete", "!=", (Object)"Y").toArray());
        Object[] waitInvoiceIds = Stream.of(waitInvoiceIdRelations).map(relation -> relation.get("tbillid")).distinct().toArray();
        if (waitInvoiceIds.length != userAddRedInfos.length) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u6570\u636e\u5173\u8054\u5f00\u7968\u7533\u8bf7\u5355\u5173\u7cfb\u4e3a\u591a\u5bf9\u591a\uff0c\u9700\u8981\u4e00\u8d77\u56de\u9000", (String)"BillRollbackHelper_1", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        ArrayList<Object> deleteRedInfoIds = new ArrayList<Object>(userAddRedInfos.length);
        ArrayList<DynamicObject> updateRedInfoIds = new ArrayList<DynamicObject>(userAddRedInfos.length);
        for (DynamicObject userAddRedInfo : userAddRedInfos) {
            if ("6".equals(userAddRedInfo.getString("infosource"))) {
                deleteRedInfoIds.add(userAddRedInfo.getPkValue());
                continue;
            }
            userAddRedInfo.set("infosource", (Object)"2");
            userAddRedInfo.set("systemsource", (Object)"");
            userAddRedInfo.set("billno", (Object)"");
            userAddRedInfo.set("batchbelong", (Object)"");
            updateRedInfoIds.add(userAddRedInfo);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(deleteRedInfoIds)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u9700\u8981\u5220\u9664\u7684\u7ea2\u5b57\u4fe1\u606f\u8868id\uff1a[%s]", (Object)deleteRedInfoIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
            }
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_red_info"), (Object[])deleteRedInfoIds.toArray());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(updateRedInfoIds)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u9700\u8981\u66f4\u65b0\u7684\u7ea2\u5b57\u4fe1\u606f\u8868id\uff1a[%s]", (Object)updateRedInfoIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
            }
            ImcSaveServiceHelper.save(updateRedInfoIds);
        }
        this.deleteRelateAndRollbackOriginalbill(userAddRedInfos, "sim_red_info");
    }

    private void redConfirmBillRollback(DynamicObject[] userAddWaitInvoices) {
        for (DynamicObject invoice2 : userAddWaitInvoices) {
            if (!StringUtils.isBlank((CharSequence)invoice2.getString("infocode"))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7%s\u5bf9\u5e94\u7684\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u56de\u9000", (String)"BillRollbackHelper_3", (String)"imc-sim-common", (Object[])new Object[0]), invoice2.getString("orderno")));
        }
        QFilter qFilter = ImcBaseDataHelper.getRedConfirmFilter((Object)userAddWaitInvoices[0].get("orgid")).and("number", "in", (Object)Stream.of(userAddWaitInvoices).map(invoice -> invoice.getString("infocode")).toArray());
        DynamicObject[] redConfirmBills = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "source", "systemsource", "billno", "remark", "orderno"), (QFilter[])qFilter.toArray());
        if (redConfirmBills.length == 0) {
            return;
        }
        QFilter relationFilter = new QFilter("tbillid", "in", (Object)Stream.of(redConfirmBills).map(DataEntityBase::getPkValue).toArray()).and("ttable", "=", (Object)"sim_red_confirm_bill").and("isdelete", "!=", (Object)"Y");
        DynamicObject[] billInvRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation"), (QFilter[])relationFilter.toArray());
        Map<Long, String> billPkRemarkMap = null;
        HashMap<Long, Set> redConfirmPkBillPksMap = new HashMap<Long, Set>(16);
        if (billInvRelations.length != 0) {
            Object[] billPks = Arrays.stream(billInvRelations).map(o -> o.getLong("sbillid")).toArray();
            for (DynamicObject billInvRelation : billInvRelations) {
                Set billIds = redConfirmPkBillPksMap.computeIfAbsent(billInvRelation.getLong("tbillid"), k -> new HashSet());
                billIds.add(billInvRelation.getLong("sbillid"));
            }
            DynamicObject[] originalBills = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)"invoiceremark", (QFilter[])new QFilter("id", "in", (Object)billPks).toArray());
            billPkRemarkMap = Arrays.stream(originalBills).collect(Collectors.toMap(o -> o.getLong("id"), o -> o.getString("invoiceremark")));
        }
        ArrayList<DynamicObject> updateRedConfirms = new ArrayList<DynamicObject>(redConfirmBills.length);
        for (DynamicObject redConfirm : redConfirmBills) {
            String confirmBillRemark = redConfirm.getString("remark");
            long redConfirmPk = redConfirm.getLong("id");
            if (null != billPkRemarkMap) {
                Set sourceBillPks = (Set)redConfirmPkBillPksMap.get(redConfirmPk);
                for (Long sourceBillPk : sourceBillPks) {
                    String billRemark = billPkRemarkMap.get(sourceBillPk);
                    confirmBillRemark = confirmBillRemark.replace(billRemark, "");
                }
            }
            redConfirm.set("source", (Object)"1");
            redConfirm.set("remark", (Object)confirmBillRemark);
            updateRedConfirms.add(redConfirm);
        }
        ImcSaveServiceHelper.save(updateRedConfirms);
        this.deleteRelateAndRollbackOriginalbill(redConfirmBills, "sim_red_confirm_bill");
        this.deleteRelationAndMatchBill(redConfirmBills);
    }

    public void deleteRelationAndMatchBill(DynamicObject[] redConfirmBills) {
        List redConfirmIds = Arrays.stream(redConfirmBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObjectCollection invRelations = QueryServiceHelper.query((String)"sim_match_inv_relation", (String)"sbillid", (QFilter[])OrgHelper.getIdFilter(redConfirmIds, (String)"tbillid").toArray());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)invRelations)) {
            return;
        }
        Set matchBillIds = invRelations.stream().map(invRelation -> invRelation.getLong("sbillid")).collect(Collectors.toSet());
        DeleteServiceHelper.delete((String)"sim_matchbill_relation", (QFilter[])OrgHelper.getIdFilter(matchBillIds, (String)"tbillid").toArray());
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"), (Object[])matchBillIds.toArray());
        DeleteServiceHelper.delete((String)"sim_match_inv_relation", (QFilter[])OrgHelper.getIdFilter(redConfirmIds, (String)"tbillid").toArray());
        DeleteServiceHelper.delete((String)"sim_vatinvoice", (QFilter[])new QFilter("orderno", "in", (Object)Arrays.stream(redConfirmBills).map(confirm -> confirm.getString("orderno")).toArray()).toArray());
    }

    public void deleteRelateAndRollbackOriginalbill(DynamicObject[] userAddRedInfos, String tableId) {
        QFilter qFilter = new QFilter("tbillid", "in", (Object)Stream.of(userAddRedInfos).map(DataEntityBase::getPkValue).toArray()).and("ttable", "=", (Object)tableId).and("isdelete", "!=", (Object)"Y");
        DynamicObject[] billInvRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation"), (QFilter[])qFilter.toArray());
        if (billInvRelations.length == 0) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u56de\u9000\u67e5\u8be2\u5230\u5173\u7cfb\u8868\u6570\u636e\u4e3a\u7a7a\uff0c\u7ec8\u6b62\u56de\u9000");
            }
            return;
        }
        List<DynamicObject> originalBills = this.originalBillAllRollBack(Stream.of(billInvRelations).collect(Collectors.toList()));
        ImcSaveServiceHelper.save(originalBills);
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_bill_inv_relation"), (Object[])Stream.of(billInvRelations).map(DataEntityBase::getPkValue).toArray());
    }

    private void doRollBack(AbstractFormPlugin that, Object[] pks, String tTable) {
        ArrayList<Object> pushPks = new ArrayList<Object>(pks.length);
        HashSet<String> invoiceCodeNoSet = new HashSet<String>(pks.length);
        ArrayList<Object> redInfoMatchPk = new ArrayList<Object>(pks.length);
        ArrayList<Object> deleteIds = new ArrayList<Object>(pks.length);
        ArrayList<Object> deleteRelationNumbers = new ArrayList<Object>(pks.length);
        if ("sim_vatinvoice".equals(tTable)) {
            pushPks.addAll(Stream.of(pks).collect(Collectors.toList()));
        } else {
            DynamicObject[] redInfos;
            for (DynamicObject redInfo : redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)String.join((CharSequence)",", "infosource", "originalinvoicecode", "originalinvoiceno", "status", "infocode"), (QFilter[])new QFilter("id", "in", (Object)pks).toArray())) {
                if ("10".equals(redInfo.getString("infosource"))) {
                    redInfoMatchPk.add(redInfo.getPkValue());
                    invoiceCodeNoSet.add(redInfo.getString("originalinvoicecode") + "\u25cf\u25c6\u25a0" + redInfo.getString("originalinvoiceno"));
                    String uploadStatus = redInfo.getString("status");
                    if ("1".equals(uploadStatus)) {
                        deleteIds.add(redInfo.getPkValue());
                        continue;
                    }
                    deleteRelationNumbers.add(redInfo.getString("infocode"));
                    continue;
                }
                pushPks.add(redInfo.getPkValue());
            }
        }
        if (this.pushRollback(that, pushPks, tTable) && this.matchRollback(invoiceCodeNoSet, redInfoMatchPk, deleteIds, deleteRelationNumbers)) {
            that.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u5355\u636e\u6570\u636e\uff0c\u65e0\u6cd5\u56de\u9000", (String)"BillRollbackHelper_2", (String)"imc-sim-common", (Object[])new Object[0]));
            return;
        }
        that.getView().showSuccessNotification(ResManager.loadKDString((String)"\u56de\u9000\u6210\u529f", (String)"BillRollbackHelper_0", (String)"imc-sim-common", (Object[])new Object[0]));
    }

    private boolean matchRollback(Set<String> invoiceCodeNoSet, List<Object> redInfoMatchPk, List<Object> deleteIds, List<Object> deleteRelationNumbers) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(redInfoMatchPk)) {
            return true;
        }
        this.changeMatchBillPushStatus(deleteRelationNumbers, invoiceCodeNoSet, redInfoMatchPk);
        DeleteServiceHelper.delete((String)"sim_red_info", (QFilter[])OrgHelper.getIdFilter(deleteIds).toArray());
        DeleteServiceHelper.delete((String)"sim_match_inv_relation", (QFilter[])OrgHelper.getIdFilter(redInfoMatchPk, (String)"tbillid").toArray());
        return false;
    }

    private void changeMatchBillPushStatus(List<Object> deleteRelationNumbers, Set<String> invoiceCodeNoSet, List<Object> invoicePks) {
        DynamicObject[] matchBills;
        DynamicObject[] matchBillInvRelation = BusinessDataServiceHelper.load((String)"sim_match_inv_relation", (String)String.join((CharSequence)",", "ssubdetailid", "sbillid"), (QFilter[])OrgHelper.getIdFilter(invoicePks, (String)"tbillid").toArray());
        if (matchBillInvRelation.length == 0) {
            return;
        }
        HashSet<Object> redConfirm2MatchBillOriItemSet = new HashSet<Object>(16);
        for (DynamicObject relation2 : matchBillInvRelation) {
            redConfirm2MatchBillOriItemSet.add(relation2.get("ssubdetailid"));
        }
        for (DynamicObject matchBill : matchBills = BusinessDataServiceHelper.load((Object[])Arrays.stream(matchBillInvRelation).map(relation -> relation.get("sbillid")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"))) {
            DynamicObjectCollection items = matchBill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items) {
                DynamicObjectCollection oriItems = item.getDynamicObjectCollection("subentryentity");
                for (DynamicObject oriItem : oriItems) {
                    if (deleteRelationNumbers.contains(oriItem.getString("infocode"))) {
                        oriItem.set("infocode", (Object)"");
                    }
                    if ("3".equals(matchBill.getString("matchtarget"))) {
                        String invoiceCodeNo = oriItem.getString("oriinvoicecode") + "\u25cf\u25c6\u25a0" + oriItem.getString("oriinvoiceno");
                        if (!invoiceCodeNoSet.contains(invoiceCodeNo)) continue;
                        oriItem.set("pushstatus", (Object)"-1");
                        continue;
                    }
                    if (!redConfirm2MatchBillOriItemSet.contains(oriItem.getPkValue())) continue;
                    oriItem.set("pushstatus", (Object)"-1");
                }
            }
            NegativeBillMatchHelper.changePushStatus(matchBill);
        }
        ImcSaveServiceHelper.save((DynamicObject[])matchBills);
    }

    private boolean pushRollback(AbstractFormPlugin that, List<Object> redInfoMatchPk, String tTable) {
        QFilter qFilter = new QFilter("tbillid", "in", redInfoMatchPk).and("ttable", "=", (Object)tTable).and("isdelete", "!=", (Object)"Y");
        DynamicObject[] billInvRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation"), (QFilter[])qFilter.toArray());
        if (billInvRelations.length == 0) {
            return true;
        }
        ArrayList<DynamicObject> commonBillRelation = new ArrayList<DynamicObject>(billInvRelations.length);
        ArrayList<DynamicObject> editBillRelation = new ArrayList<DynamicObject>(billInvRelations.length);
        for (DynamicObject billInvRelation : billInvRelations) {
            if (billInvRelation.getLong("sdetailid") == 0L) {
                editBillRelation.add(billInvRelation);
                continue;
            }
            commonBillRelation.add(billInvRelation);
        }
        ArrayList<DynamicObject> originalBills = new ArrayList<DynamicObject>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(editBillRelation)) {
            originalBills.addAll(this.originalBillAllRollBack(editBillRelation));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commonBillRelation)) {
            originalBills.addAll(this.commonBillRelationRollBack(commonBillRelation));
        }
        Object[] deleteIds = Stream.of(billInvRelations).map(relation -> relation.getLong("tbillid")).toArray();
        if ("sim_vatinvoice".equals(tTable)) {
            this.rollbackMergeBill(deleteIds, commonBillRelation);
        }
        this.saveRollBackData(that, originalBills, deleteIds, tTable);
        return false;
    }

    private void rollbackMergeBill(Object[] waitInvoiceIds, List<DynamicObject> invRelations) {
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "id", "invoicetype", "invoiceamount"), (QFilter[])new QFilter("id", "in", (Object)waitInvoiceIds).toArray());
        ArrayList<Long> rollbackInvoiceIdList = new ArrayList<Long>(waitInvoiceIds.length);
        for (DynamicObject invoice : invoices) {
            if (!InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype")) || invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) continue;
            rollbackInvoiceIdList.add(invoice.getLong("id"));
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(rollbackInvoiceIdList)) {
            return;
        }
        DynamicObjectCollection splitRelations = QueryServiceHelper.query((String)"sim_merge_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_merge_inv_relation"), (QFilter[])new QFilter("tbillid", "in", rollbackInvoiceIdList).toArray());
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)splitRelations)) {
            return;
        }
        Object[] mergeBillIds = splitRelations.stream().map(relation -> relation.getLong("sbillid")).toArray();
        DynamicObject[] mergeBills = BusinessDataServiceHelper.load((String)"sim_merge_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_merge_bill", (boolean)true), (QFilter[])new QFilter("id", "in", (Object)mergeBillIds).toArray());
        if (mergeBills == null || mergeBills.length == 0) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_mergebill_relation"), (Object[])splitRelations.stream().map(relation -> relation.getLong("id")).toArray());
            return;
        }
        Map<Long, List<DynamicObject>> mergeItemId2SplitRelationMap = splitRelations.stream().collect(Collectors.groupingBy(k -> k.getLong("sdetailid")));
        DynamicObject[] mergeRelations = BusinessDataServiceHelper.load((String)"sim_mergebill_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_mergebill_relation"), (QFilter[])new QFilter("tbillid", "in", (Object)mergeBillIds).toArray());
        Map<Long, List<DynamicObject>> mergeItemId2MergeRelationMap = Arrays.stream(mergeRelations).collect(Collectors.groupingBy(k -> k.getLong("tdetailid")));
        Map<Long, List<DynamicObject>> billItemId2RelationMap = invRelations.stream().collect(Collectors.groupingBy(k -> k.getLong("sdetailid")));
        HashSet<Long> deleteMergeBillItemIds = new HashSet<Long>(mergeItemId2SplitRelationMap.size());
        HashSet<Long> deleteMergeBillIds = new HashSet<Long>(mergeItemId2SplitRelationMap.size());
        HashSet<Long> deleteMergeRelationIdSet = new HashSet<Long>(mergeItemId2SplitRelationMap.size());
        HashSet<DynamicObject> updateMergeRelationSet = new HashSet<DynamicObject>(mergeItemId2SplitRelationMap.size());
        ArrayList<DynamicObject> updateMergeBill = new ArrayList<DynamicObject>(mergeItemId2SplitRelationMap.size());
        for (DynamicObject mergeBill : mergeBills) {
            DynamicObjectCollection items = mergeBill.getDynamicObjectCollection("sim_original_bill_item");
            Iterator iterator = items.iterator();
            while (iterator.hasNext()) {
                DynamicObject mergeBillItem = (DynamicObject)iterator.next();
                List<DynamicObject> splitRelationList = mergeItemId2SplitRelationMap.get(mergeBillItem.getLong("id"));
                if (org.apache.commons.collections.CollectionUtils.isEmpty(splitRelationList)) continue;
                for (DynamicObject splitRelation : splitRelationList) {
                    BigDecimal splitAmount = splitRelation.getBigDecimal("amount");
                    BigDecimal splitTax = splitRelation.getBigDecimal("tax");
                    BigDecimal splitNum = splitRelation.getBigDecimal("num");
                    mergeBillItem.set("amount", (Object)mergeBillItem.getBigDecimal("amount").subtract(splitAmount));
                    mergeBillItem.set("tax", (Object)mergeBillItem.getBigDecimal("tax").subtract(splitTax));
                    mergeBillItem.set("num", (Object)mergeBillItem.getBigDecimal("num").subtract(splitNum));
                    mergeBillItem.set("taxamount", (Object)mergeBillItem.getBigDecimal("amount").add(mergeBillItem.getBigDecimal("tax")));
                    mergeBillItem.set("remainvalidamount", mergeBillItem.get("remainvalidamount"));
                    mergeBillItem.set("remainvalidtax", mergeBillItem.get("tax"));
                    mergeBillItem.set("remainvalidnum", mergeBillItem.get("num"));
                    mergeBill.set("invoiceamount", (Object)mergeBill.getBigDecimal("invoiceamount").subtract(splitAmount));
                    mergeBill.set("totaltax", (Object)mergeBill.getBigDecimal("totaltax").subtract(splitTax));
                }
                mergeBill.set("totalamount", (Object)mergeBill.getBigDecimal("invoiceamount").add(mergeBill.getBigDecimal("totaltax")));
                mergeBill.set("surplusamount", mergeBill.get("invoiceamount"));
                mergeBill.set("surplustax", mergeBill.get("totaltax"));
                if (mergeBillItem.getBigDecimal("taxamount").compareTo(BigDecimal.ZERO) == 0 || mergeBillItem.getBigDecimal("amount").compareTo(BigDecimal.ZERO) == 0) {
                    iterator.remove();
                    deleteMergeBillItemIds.add(mergeBillItem.getLong("id"));
                    continue;
                }
                List<DynamicObject> mergeRelationList = mergeItemId2MergeRelationMap.get(mergeBillItem.getLong("id"));
                if (org.apache.commons.collections.CollectionUtils.isEmpty(mergeRelationList)) continue;
                Iterator<DynamicObject> mergeRelationIterator = mergeRelationList.iterator();
                while (mergeRelationIterator.hasNext()) {
                    DynamicObject mergeRelation = mergeRelationIterator.next();
                    List<DynamicObject> invRelationList = billItemId2RelationMap.get(mergeRelation.getLong("sdetailid"));
                    if (org.apache.commons.collections.CollectionUtils.isEmpty(invRelationList)) continue;
                    Iterator<DynamicObject> invRelationIterator = invRelationList.iterator();
                    while (invRelationIterator.hasNext()) {
                        DynamicObject invRelation = invRelationIterator.next();
                        mergeRelation.set("amount", (Object)mergeRelation.getBigDecimal("amount").subtract(invRelation.getBigDecimal("amount")));
                        mergeRelation.set("tax", (Object)mergeRelation.getBigDecimal("tax").subtract(invRelation.getBigDecimal("tax")));
                        mergeRelation.set("num", (Object)mergeRelation.getBigDecimal("num").subtract(invRelation.getBigDecimal("num")));
                        invRelationIterator.remove();
                    }
                    if (mergeRelation.getBigDecimal("amount").compareTo(BigDecimal.ZERO) == 0 && mergeRelation.getBigDecimal("amount").add(mergeRelation.getBigDecimal("tax")).compareTo(BigDecimal.ZERO) == 0) {
                        mergeRelationIterator.remove();
                        deleteMergeRelationIdSet.add(mergeRelation.getLong("id"));
                        continue;
                    }
                    updateMergeRelationSet.add(mergeRelation);
                }
            }
            if (mergeBill.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) == 0 || mergeBill.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) == 0) {
                deleteMergeBillIds.add(mergeBill.getLong("id"));
                continue;
            }
            updateMergeBill.add(mergeBill);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(deleteMergeBillIds)) {
            DeleteServiceHelper.delete((String)"sim_merge_bill", (QFilter[])new QFilter("id", "in", deleteMergeBillIds).toArray());
            DeleteServiceHelper.delete((String)"sim_mergebill_relation", (QFilter[])new QFilter("tbillid", "in", deleteMergeBillIds).toArray());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(updateMergeBill)) {
            ImcSaveServiceHelper.save(updateMergeBill);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(deleteMergeRelationIdSet)) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_mergebill_relation"), (Object[])deleteMergeRelationIdSet.toArray());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(updateMergeRelationSet)) {
            ImcSaveServiceHelper.save((DynamicObject[])updateMergeRelationSet.toArray(new DynamicObject[0]));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(deleteMergeBillItemIds)) {
            DeleteServiceHelper.delete((String)"sim_mergebill_relation", (QFilter[])new QFilter("tdetailid", "in", deleteMergeBillItemIds).toArray());
        }
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_merge_inv_relation"), (Object[])splitRelations.stream().map(relation -> relation.getLong("id")).toArray());
    }

    private List<DynamicObject> commonBillRelationRollBack(List<DynamicObject> commonBillRelation) {
        if (LOG.isInfoEnabled()) {
            LOG.info("\u5f00\u59cb\u8fdb\u884c\u624b\u5de5\u5904\u7406\u7f16\u8f91\u7684\u56de\u9000");
        }
        DynamicObject[] originalBills = BusinessDataServiceHelper.load((Object[])commonBillRelation.stream().map(relation -> relation.getLong("sbillid")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
        Map<Long, List<DynamicObject>> relationMap = commonBillRelation.stream().collect(Collectors.groupingBy(relation -> relation.getLong("sdetailid")));
        for (DynamicObject originalBill : originalBills) {
            boolean isTax = "1".equals(originalBill.getString("hsbz"));
            DynamicObjectCollection items = originalBill.getDynamicObjectCollection("sim_original_bill_item");
            if (!OriginalBillConstant.isSpecialSourcType((Object)originalBill.getString("billsourcetype"))) {
                BillHelper.clearRedInvoiceData(originalBill);
            }
            BigDecimal amountSum = BigDecimal.ZERO;
            BigDecimal mainTaxdeviation = BigDecimal.ZERO;
            BigDecimal mainForeignTaxDiff = BigDecimal.ZERO;
            for (DynamicObject item : items) {
                List<DynamicObject> relationList = relationMap.get(item.getLong("id"));
                if (org.apache.commons.collections.CollectionUtils.isEmpty(relationList)) continue;
                BigDecimal amounts = BigDecimal.ZERO;
                BigDecimal taxs = BigDecimal.ZERO;
                BigDecimal nums = BigDecimal.ZERO;
                for (DynamicObject relation2 : relationList) {
                    amounts = amounts.add(relation2.getBigDecimal("amount"));
                    taxs = taxs.add(relation2.getBigDecimal("tax"));
                    nums = nums.add(relation2.getBigDecimal("num"));
                }
                BigDecimal taxdeviation = item.getBigDecimal("taxdeviation");
                mainTaxdeviation = mainTaxdeviation.add(taxdeviation);
                mainForeignTaxDiff = mainForeignTaxDiff.add(item.getBigDecimal("fromtaxdeviation"));
                item.set("remainvalidtax", (Object)item.getBigDecimal("remainvalidtax").add(taxs).add(taxdeviation));
                item.set("remainvalidnum", (Object)item.getBigDecimal("remainvalidnum").add(nums).add(item.getBigDecimal("numdeviation")));
                BigDecimal remainValidAmount = isTax ? amounts.add(taxs) : amounts;
                amountSum = amountSum.add(remainValidAmount);
                item.set("remainvalidamount", (Object)item.getBigDecimal("remainvalidamount").add(remainValidAmount));
                if (!isTax) {
                    item.set("remainvalidamount", (Object)item.getBigDecimal("remainvalidamount").subtract(taxdeviation));
                }
                if (!item.getBoolean("gift") && item.getBigDecimal("amount").compareTo(BigDecimal.ZERO) == 0) {
                    item.set("zeropushflag", (Object)"0");
                }
                item.set("taxdeviation", (Object)BigDecimal.ZERO);
                item.set("amountdeviation", (Object)BigDecimal.ZERO);
                item.set("numdeviation", (Object)BigDecimal.ZERO);
                item.set("fromtaxdeviation", (Object)BigDecimal.ZERO);
            }
            originalBill.set("confirmamount", (Object)originalBill.getBigDecimal("confirmamount").subtract(amountSum));
            originalBill.set("maintaxdeviation", (Object)originalBill.getBigDecimal("maintaxdeviation").subtract(mainTaxdeviation));
            originalBill.set("foreigntaxdifference", (Object)originalBill.getBigDecimal("foreigntaxdifference").subtract(mainForeignTaxDiff));
            if (originalBill.getBigDecimal("confirmamount").compareTo(BigDecimal.ZERO) == 0) {
                originalBill.set("confirmstate", (Object)"0");
                originalBill.set("comprehensivestatus", (Object)"01");
                originalBill.set("operatebatch", (Object)"");
                continue;
            }
            originalBill.set("confirmstate", (Object)"1");
        }
        return new ArrayList<DynamicObject>(Arrays.asList(originalBills));
    }

    public List<DynamicObject> originalBillAllRollBack(List<DynamicObject> editBillRelation) {
        DynamicObject[] originalBills = BusinessDataServiceHelper.load((Object[])editBillRelation.stream().map(relation -> relation.getLong("sbillid")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
        return this.originalBillAllRollBack(originalBills);
    }

    public List<DynamicObject> originalBillAllRollBack(DynamicObject[] originalBills) {
        for (DynamicObject originalBill : originalBills) {
            boolean isTax = "1".equals(originalBill.getString("hsbz"));
            originalBill.set("confirmamount", (Object)BigDecimal.ZERO);
            originalBill.set("maintaxdeviation", (Object)BigDecimal.ZERO);
            originalBill.set("confirmstate", (Object)"0");
            originalBill.set("validstate", (Object)"0");
            if (!OriginalBillConstant.isSpecialSourcType((Object)originalBill.getString("billsourcetype"))) {
                BillHelper.clearRedInvoiceData(originalBill);
            }
            originalBill.set("mainissuedamount", (Object)BigDecimal.ZERO);
            originalBill.set("mainissuedtax", (Object)BigDecimal.ZERO);
            originalBill.set("foreigntaxdifference", (Object)BigDecimal.ZERO);
            originalBill.set("surplusamount", originalBill.get("invoiceamount"));
            originalBill.set("surplustax", originalBill.get("totaltax"));
            originalBill.set("comprehensivestatus", (Object)"01");
            originalBill.set("operatebatch", (Object)"");
            DynamicObjectCollection items = originalBill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject item : items) {
                item.set("remainvalidtax", (Object)item.getBigDecimal("tax"));
                item.set("remainvalidnum", (Object)item.getBigDecimal("num"));
                item.set("remainvalidamount", (Object)item.getBigDecimal(isTax ? "taxamount" : "amount"));
                item.set("taxdeviation", (Object)BigDecimal.ZERO);
                item.set("amountdeviation", (Object)BigDecimal.ZERO);
                item.set("numdeviation", (Object)BigDecimal.ZERO);
                item.set("fromtaxdeviation", (Object)BigDecimal.ZERO);
                item.set("issuedamount", (Object)BigDecimal.ZERO);
                item.set("issuedtax", (Object)BigDecimal.ZERO);
                item.set("issuedtotaltaxamount", (Object)BigDecimal.ZERO);
            }
        }
        return new ArrayList<DynamicObject>(Arrays.asList(originalBills));
    }

    private void saveRollBackData(AbstractFormPlugin that, List<DynamicObject> originalBills, Object[] deleteIds, String tTable) {
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("\u4fdd\u5b58\u56de\u9000\u6570\u636e\uff0c\u5f00\u7968\u7533\u8bf7\u5355\u5355\u636e\u7f16\u53f7\uff1a[%s]", originalBills.stream().map(bill -> bill.getString("billno")).collect(Collectors.joining(","))));
        }
        ImcSaveServiceHelper.save(originalBills);
        if ("sim_red_info".equals(tTable)) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_red_info"), (Object[])deleteIds);
        } else {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"), (Object[])deleteIds);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("\u5220\u9664%s\u6570\u636e\uff0cid\uff1a[%s]", "sim_red_info".equals(tTable) ? "\u7ea2\u5b57\u4fe1\u606f\u8868" : "\u5f85\u5f00", Stream.of(deleteIds).map(String::valueOf).collect(Collectors.joining(","))));
        }
        QFilter deleteFilter = new QFilter("tbillid", "in", (Object)deleteIds).and("ttable", "=", (Object)tTable).and("isdelete", "!=", (Object)"Y");
        DeleteServiceHelper.delete((String)"sim_bill_inv_relation", (QFilter[])deleteFilter.toArray());
        BillRollbackHelper.saveAppLog(that, originalBills, "sim_invoice_wait");
    }

    public static void saveAppLog(AbstractFormPlugin that, List<DynamicObject> originalBills, String formId) {
        try {
            if (CollectionUtils.isEmpty(originalBills)) {
                return;
            }
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            String appNumber = that.getView().getFormShowParameter().getAppId();
            ArrayList<AppLogInfo> appLogInfos = new ArrayList<AppLogInfo>(originalBills.size());
            for (DynamicObject billObj : originalBills) {
                String msg;
                String opName;
                if ("sim_original_bill".equals(formId)) {
                    opName = "\u5f00\u7968\u7533\u8bf7\u5355\u56de\u64a4";
                    msg = String.format("\u56de\u9000\u4e0a\u6e38\u5355\u636e\u6210\u529f\uff0c\u56de\u64a4\u5355\u636e\uff1a%s", billObj.getString("billno"));
                } else {
                    opName = "\u5f85\u5f00\u56de\u64a4";
                    msg = String.format("\u9000\u56de\u5f00\u7968\u7533\u8bf7\u5355\u6210\u529f\uff0c\u56de\u64a4\u5355\u636e\uff1a%s", billObj.getString("billno"));
                }
                AppLogInfo logInfo = AppLogInfoHelper.buildLogInfo((String)opName, (String)msg, (Long)RequestContext.get().getOrgId(), (String)appNumber, (String)formId);
                appLogInfos.add(logInfo);
            }
            logService.addBatchLog(appLogInfos);
        }
        catch (Exception e) {
            LOG.error("\u5f85\u5f00\u70b9\u51fb\u9000\u56de\u5f00\u7968\u7533\u8bf7\u5355\u540e\uff0c\u589e\u52a0\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
        }
    }
}

