/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.imc.bdm.common.dto.ArBillRelationExtensionDTO;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.sim.common.dto.FillInInvoiceDTO;
import kd.imc.sim.common.dto.FillInInvoiceRequestDTO;
import kd.imc.sim.common.dto.FillInInvoiceResponseDTO;
import kd.imc.sim.common.service.impl.InvoiceFillinServiceImpl;

public class FillInInvoiceHelper {
    public static FillInInvoiceResponseDTO fillInvoice(FillInInvoiceRequestDTO request) {
        return new InvoiceFillinServiceImpl().fillInInvoice2Original(request);
    }

    public static FillInInvoiceRequestDTO generateInvoiceFillInRequest(DynamicObjectCollection entry, DynamicObject[] bills) {
        FillInInvoiceRequestDTO request = new FillInInvoiceRequestDTO();
        List billList = Arrays.stream(bills).collect(Collectors.toList());
        request.setBills(billList);
        ArrayList<FillInInvoiceDTO> invs = new ArrayList<FillInInvoiceDTO>();
        request.setInvs(invs);
        for (DynamicObject row : entry) {
            FillInInvoiceDTO fillInvDto = FillInInvoiceHelper.getFillInInvoiceDTO(row);
            invs.add(fillInvDto);
        }
        return request;
    }

    public static FillInInvoiceDTO getFillInInvoiceDTO(DynamicObject row) {
        FillInInvoiceDTO fillInvDto = new FillInInvoiceDTO();
        String invoiceType = row.getString("invoicetype");
        fillInvDto.setInvoiceType(invoiceType);
        String invoiceNo = row.getString("invoiceno");
        fillInvDto.setInvoiceNo(invoiceNo);
        String invoiceCode = row.getString("invoicecode");
        fillInvDto.setInvoiceCode(invoiceCode);
        BigDecimal totalTax = row.getBigDecimal("totaltax");
        if (null == totalTax) {
            totalTax = BigDecimal.ZERO;
        }
        fillInvDto.setTotalTax(totalTax);
        BigDecimal invoiceAmount = row.getBigDecimal("invoiceamount");
        fillInvDto.setInvoiceAmount(invoiceAmount);
        BigDecimal totalAmount = row.getBigDecimal("totalamount");
        fillInvDto.setTotalAmount(totalAmount);
        return fillInvDto;
    }

    public static FillInInvoiceResponseDTO getDetailFillInInvoiceResponse(DynamicObjectCollection entry, DynamicObject[] bills) {
        HashMap<String, DynamicObject> billPkMap = new HashMap<String, DynamicObject>();
        for (DynamicObject bill : bills) {
            billPkMap.put(bill.getString("billno"), bill);
        }
        HashMap<String, ArrayList<ArBillRelationExtensionDTO>> relationMap = new HashMap<String, ArrayList<ArBillRelationExtensionDTO>>();
        for (DynamicObject row : entry) {
            String billNo = row.getString("billno");
            DynamicObject bill = (DynamicObject)billPkMap.get(billNo);
            if (null == bill) continue;
            ArBillRelationExtensionDTO dto = FillInInvoiceHelper.getArBillRelationExtensionDTO(row, bill);
            String key = StringUtils.isBlank((CharSequence)row.getString("invoicecode")) ? row.getString("invoiceno") : row.getString("invoicecode") + row.getString("invoiceno");
            ArrayList<ArBillRelationExtensionDTO> relations = (ArrayList<ArBillRelationExtensionDTO>)relationMap.get(key);
            if (null == relations) {
                relations = new ArrayList<ArBillRelationExtensionDTO>();
                relationMap.put(key, relations);
            }
            relations.add(dto);
        }
        FillInInvoiceResponseDTO response = new FillInInvoiceResponseDTO();
        response.setRelationMap(relationMap);
        return response;
    }

    public static ArBillRelationExtensionDTO getArBillRelationExtensionDTO(DynamicObject row, DynamicObject bill) {
        DynamicObject fromCurr = bill.getDynamicObject("fromcurr");
        String billDetailId = row.getString("billdetailid");
        BigDecimal totalTax = row.getBigDecimal("totaltax");
        BigDecimal invoiceAmount = row.getBigDecimal("invoiceamount");
        String invoiceCode = row.getString("invoicecode");
        String invoiceNo = row.getString("invoiceno");
        String billNo = bill.getString("billno");
        ArBillRelationExtensionDTO dto = new ArBillRelationExtensionDTO();
        dto.setAmount(invoiceAmount);
        dto.setTax(totalTax);
        dto.setFrom(Boolean.valueOf(CurrencyHelper.isFrom((Object)fromCurr)));
        dto.setsBillId(Long.valueOf(bill.getLong("id")));
        if (StringUtils.isNotBlank((CharSequence)billDetailId)) {
            dto.setsDetailId(Long.valueOf(Long.parseLong(billDetailId)));
        }
        dto.setInvoiceCode(invoiceCode);
        dto.setInvoiceNo(invoiceNo);
        dto.setsBillNo(billNo);
        return dto;
    }
}

