/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper.allele;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.FileType;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseDTO;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.DownLoadCenterHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.ThreadPoolsHelper;
import kd.imc.bdm.common.util.EncrypteUtil;
import kd.imc.bdm.common.util.FileUploadUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.lqpt.service.schedule.DownLoadXmlScheduleService;
import kd.imc.sim.common.dto.allele.AllEleQueryInvoiceRequestDTO;
import kd.imc.sim.common.dto.allele.AllEleUpdateInvoiceStatusRequestDTO;
import kd.imc.sim.common.helper.allele.AllEleInvoiceFileHelper;
import org.apache.commons.lang3.StringUtils;

public class RpaInvoiceFileHelper {
    private static final Log LOGGER = LogFactory.getLog(RpaInvoiceFileHelper.class);

    public static void invokeRpaFileDown(DynamicObject invoice) {
        ThreadPoolsHelper.checkAllEInvoiceFileThreadPool.execute(() -> {
            try {
                if (!"12".equals(invoice.getString("issuesource"))) {
                    return;
                }
                String invoiceNo = invoice.getString("invoiceno");
                if (StringUtils.isBlank((CharSequence)invoiceNo)) {
                    return;
                }
                QFilter qFilter = new QFilter("invoiceno", "=", (Object)invoiceNo);
                DynamicObject[] invoiceFiles = BusinessDataServiceHelper.load((String)"sim_vatinvoice_file", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice_file"), (QFilter[])qFilter.toArray());
                if (invoiceFiles == null || invoiceFiles.length == 0) {
                    return;
                }
                if ("virtual".equals(invoiceFiles[0].getString("issuechannel"))) {
                    return;
                }
                Thread.sleep(5000L);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("\u53d1\u7968\u6d41\u6c34\u53f7[%s],\u53f7\u7801[%s]\u5f00\u7968\u5b8c\u6210\u540e\u67e5\u8be2\u6570\u7535\u7968\u6587\u4ef6\u751f\u6210\u72b6\u6001", invoice.getString("orderno"), invoice.getString("invoiceno")));
                }
                List<DynamicObject> invoiceFileList = Arrays.stream(invoiceFiles).collect(Collectors.toList());
                AllEleQueryInvoiceRequestDTO request = new AllEleQueryInvoiceRequestDTO();
                if ("rpa".equals(((DynamicObject)invoiceFileList.get(0)).getString("issuechannel"))) {
                    RpaInvoiceFileHelper.rpaFileBatchDownload(request, invoice, invoiceFileList);
                    ImcSaveServiceHelper.update((DynamicObject[])invoiceFiles);
                    DynamicObject updateInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "fileurl", "ofdstatus", "pdffileurl", "snapshoturl", "xmlfileurl"), (QFilter[])new QFilter("id", "=", invoice.getPkValue()).toArray());
                    if (updateInvoice != null) {
                        String fileUrl = invoice.getString("fileurl");
                        updateInvoice.set("fileurl", (Object)fileUrl);
                        updateInvoice.set("ofdstatus", invoice.get("ofdstatus"));
                        updateInvoice.set("pdffileurl", (Object)invoice.getString("pdffileurl"));
                        updateInvoice.set("snapshoturl", (Object)invoice.getString("snapshoturl"));
                        updateInvoice.set("xmlfileurl", (Object)invoice.getString("xmlfileurl"));
                        ImcSaveServiceHelper.update((DynamicObject)updateInvoice);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(String.format("\u53d1\u7968\u6d41\u6c34\u53f7[%s],\u53f7\u7801[%s]\u5f00\u7968\u5b8c\u6210\u540e\u67e5\u8be2\u6570\u7535\u7968\u6587\u4ef6\u5931\u8d25", invoice.getString("orderno"), invoice.getString("invoiceno")), (Throwable)e);
            }
        });
    }

    public static void rpaFileBatchDownload(AllEleQueryInvoiceRequestDTO request, DynamicObject invoice, List<DynamicObject> invoiceFileList) {
        String invoiceNo = invoice.getString("invoiceno");
        try (DLock lock = DLock.create((String)(invoiceNo + "checkFileExists"));){
            if (!lock.tryLock()) {
                return;
            }
            request.setSerialNo(invoice.getString("orderno"));
            request.setRequest_path(AllEleInterfaceTypeEnum.QUERY_INVOICE_BY_ORDERNO.getRequestPath());
            AllEleResponseDTO response = AllEleServiceHelper.doPost((String)invoice.getString("salertaxno"), (AllEleRequestDTO)request, AllEleUpdateInvoiceStatusRequestDTO.class);
            if (!response.getSuccess().booleanValue()) {
                return;
            }
            RpaInvoiceFileHelper.downloadFile((AllEleUpdateInvoiceStatusRequestDTO)response.getData(), invoice, invoiceFileList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(AllEleUpdateInvoiceStatusRequestDTO data, DynamicObject invoice, List<DynamicObject> invoiceFileList) {
        for (DynamicObject invoiceFile : invoiceFileList) {
            String fileType = invoiceFile.getString("filetype");
            boolean isCreate = false;
            switch (fileType) {
                case "ofd": {
                    isCreate = StringUtils.isNotBlank((CharSequence)data.getOfdUrl());
                    break;
                }
                case "pdf": {
                    isCreate = StringUtils.isNotBlank((CharSequence)data.getPdfUrl());
                    break;
                }
                case "xml": {
                    isCreate = StringUtils.isNotBlank((CharSequence)data.getXmlUrl());
                    break;
                }
                case "jpg": {
                    isCreate = StringUtils.isNotBlank((CharSequence)data.getPdfUrl());
                }
            }
            if (!isCreate) continue;
            invoiceFile.set("remotefilestatus", (Object)"1");
            if (RpaInvoiceFileHelper.remoteFileNotDownload(invoiceFile)) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info(String.format("\u53d1\u7968\u53f7\u7801[%s]rpa\u5f00\u7968\uff0c\u914d\u7f6e\u4e3a\u56de\u8c03\u8fdc\u7a0b\u5730\u5740\uff0c\u4e0d\u4e0b\u8f7d\u6587\u4ef6\u5230\u6587\u4ef6\u670d\u52a1\u5668", invoiceFile.getString("invoiceno")));
                continue;
            }
            InputStream inputStream = null;
            try {
                if (FileType.XML.getFileExtension().equals(fileType)) {
                    if (RpaInvoiceFileHelper.isZipFile(invoiceFile.getString("remotefileurl"))) {
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info(String.format("\u53d1\u7968\u53f7\u7801[%s]xml\u6587\u4ef6\u91cc\u9762\u662fzip\u554a", invoiceFile.getString("invoiceno")));
                        }
                        inputStream = RpaInvoiceFileHelper.getXmlInputStream(invoiceFile);
                    } else {
                        inputStream = DownLoadCenterHelper.getInputStream((String)invoiceFile.getString("remotefileurl"));
                    }
                } else {
                    inputStream = DownLoadCenterHelper.getInputStream((String)invoiceFile.getString("remotefileurl"));
                }
                String fileName = invoiceFile.getString("invoiceno") + "." + fileType;
                String localUrl = FileUploadUtils.upload((String)(FileUploadUtils.getInvoiceDir((String)"simeinv") + fileName), (String)fileName, (InputStream)inputStream);
                if (!StringUtils.isNotBlank((CharSequence)localUrl)) continue;
                invoiceFile.set("localfileurl", (Object)localUrl);
                invoiceFile.set("localfilestatus", (Object)"1");
                if (!"local".equals(invoiceFile.getString("callbacktype"))) continue;
                RpaInvoiceFileHelper.setInvocieFileUrl(fileType, localUrl, invoice);
            }
            catch (Exception e) {
                LOGGER.error(String.format("\u4eceRPA\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u5730\u5740\u662f%s", invoiceFile.getString("remotefileurl")), (Object)e.getMessage());
            }
            finally {
                try {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean remoteFileNotDownload(DynamicObject invoiceFile) {
        if (!"remote".equals(invoiceFile.getString("callbacktype"))) {
            return false;
        }
        String download2local = ImcConfigUtil.getValue((String)"invoicefile_config", (String)"download2local");
        if ("1".equals(download2local)) {
            return false;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u53d1\u7968\u53f7\u7801[%s]rpa\u5f00\u7968\uff0c\u914d\u7f6e\u4e3a\u56de\u8c03\u8fdc\u7a0b\u5730\u5740\uff0c\u4e0d\u4e0b\u8f7d\u6587\u4ef6\u5230\u6587\u4ef6\u670d\u52a1\u5668", invoiceFile.getString("invoiceno")));
        }
        return true;
    }

    private static void setInvocieFileUrl(String fileType, String localUrl, DynamicObject invoice) {
        switch (fileType) {
            case "ofd": {
                invoice.set("fileurl", (Object)localUrl);
                invoice.set("ofdstatus", (Object)"1");
                break;
            }
            case "pdf": {
                invoice.set("pdffileurl", (Object)localUrl);
                break;
            }
            case "xml": {
                invoice.set("xmlfileurl", (Object)localUrl);
                break;
            }
            case "jpg": {
                invoice.set("snapshoturl", (Object)localUrl);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InputStream getXmlInputStream(DynamicObject invoiceFile) {
        try (InputStream inputStream = DownLoadCenterHelper.getInputStream((String)invoiceFile.getString("remotefileurl"));){
            byte[] bytes = AllEleInvoiceFileHelper.inputStreamToByteArray(inputStream);
            Map decompress = new DownLoadXmlScheduleService().decompress(bytes);
            if (CollectionUtils.isEmpty((Map)decompress)) throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u53d1\u7968\u6587\u4ef6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (String)"SimVatInvoiceFileTask_0", (String)"imc-sim-common", (Object[])new Object[0]));
            ArrayList xmlFiles = new ArrayList(decompress.keySet());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])decompress.get(xmlFiles.get(0)));
            return byteArrayInputStream;
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u538b\u7f29\u6587\u4ef6\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u53d1\u7968\u6587\u4ef6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (String)"SimVatInvoiceFileTask_0", (String)"imc-sim-common", (Object[])new Object[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isZipFile(String fileUrl) {
        try (InputStream inputStream = DownLoadCenterHelper.getInputStream((String)fileUrl);){
            byte[] fileHeadByte = new byte[28];
            int read = inputStream.read(fileHeadByte, 0, 28);
            if (read == -1) {
                boolean bl = true;
                return bl;
            }
            String fileHead = EncrypteUtil.byte2hex((byte[])fileHeadByte);
            if (StringUtils.isBlank((CharSequence)fileHead)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = fileHead.toUpperCase(Locale.ENGLISH).startsWith("504B0304");
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u538b\u7f29\u6587\u4ef6\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return true;
        }
    }
}

