/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.helper.issueinvoice.writeback;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.dto.ArBillRelationExtensionDTO;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.issueinvoice.writeback.AbstractIssueInvoiceWriteBackHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.InvalidInvoiceWriteBackHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class MatchBillWriteBackHelper
extends AbstractIssueInvoiceWriteBackHelper {
    private static final Log LOG = LogFactory.getLog(InvalidInvoiceWriteBackHelper.class);

    static void issueWriteback(DynamicObject invoice, DynamicObject invoiceOrRedconfirm) {
        boolean isManualedInvOrConfirm;
        DynamicObject[] invRelations = BusinessDataServiceHelper.load((String)"sim_match_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_match_inv_relation"), (QFilter[])new QFilter("tbillid", "=", invoiceOrRedconfirm.getPkValue()).toArray());
        if (invRelations.length == 0) {
            return;
        }
        DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_matchbill_relation"), (QFilter[])new QFilter("tbillid", "in", (Object)Arrays.stream(invRelations).map(relation -> relation.get("sbillid")).toArray()).toArray());
        if (billRelations.length == 0) {
            return;
        }
        boolean bl = isManualedInvOrConfirm = "2".equals(invRelations[0].getString("matchtarget")) || "3".equals(invRelations[0].getString("matchtarget"));
        if (isManualedInvOrConfirm) {
            MatchBillWriteBackHelper.manualedInvOrConfirmWriteBack(invoice, invoiceOrRedconfirm, invRelations, billRelations);
            return;
        }
        MatchBillWriteBackHelper.autoMatchWriteBack(invoice, invoiceOrRedconfirm, invRelations, billRelations);
    }

    private static void manualedInvOrConfirmWriteBack(DynamicObject invoice, DynamicObject invoiceOrRedconfirm, DynamicObject[] invRelations, DynamicObject[] billRelations) {
        HashMap<Long, ArBillRelationExtensionDTO> arIssuedRelationMap = new HashMap<Long, ArBillRelationExtensionDTO>(16);
        ArrayList<DynamicObject> writeBackLogList = new ArrayList<DynamicObject>(16);
        Object[] matchIds = Arrays.stream(invRelations).map(o -> o.getLong("sbillid")).distinct().toArray();
        if (matchIds.length == 0) {
            return;
        }
        DynamicObject matchBill = BusinessDataServiceHelper.loadSingle((Object)matchIds[0], (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_match_bill"));
        if (matchBill == null) {
            return;
        }
        DynamicObjectCollection matchItems = matchBill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject item : matchItems) {
            DynamicObjectCollection confirmItems = item.getDynamicObjectCollection("confirmsubentryentity");
            for (DynamicObject confirmItem : confirmItems) {
                if (confirmItem.getLong("redconfirmpk") != invoiceOrRedconfirm.getLong("id")) continue;
                confirmItem.set("confirmissuestatus", (Object)"0");
            }
        }
        matchBill.set("mainissuedamount", (Object)matchBill.getBigDecimal("mainissuedamount").add(invoice.getBigDecimal("invoiceamount")));
        matchBill.set("mainissuedtax", (Object)matchBill.getBigDecimal("mainissuedtax").add(invoice.getBigDecimal("totaltax")));
        ImcSaveServiceHelper.save((DynamicObject)matchBill);
        DynamicObject[] bills = MatchBillWriteBackHelper.loadOriginalBill(Arrays.stream(billRelations).map(relation -> relation.getLong("sbillid")).distinct().toArray(), writeback_fields);
        DynamicObject redConfirm = QueryServiceHelper.queryOne((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "totalamount", "invoiceamount", "totaltax"), (QFilter[])new QFilter("id", "=", (Object)invoiceOrRedconfirm.getLong("id")).toArray());
        if (redConfirm == null) {
            return;
        }
        Pair<Map<Object, DynamicObject>, Map<Object, DynamicObject>> billItemIdAnditemId2BillMap = MatchBillWriteBackHelper.getBillItemIdAnditemId2BillMap(bills);
        BigDecimal totalAmount = redConfirm.getBigDecimal("totalamount");
        boolean isLastInvIssued = MatchBillWriteBackHelper.isManualedLastInvIssuedWriteBack(bills, matchBill, invoice);
        BigDecimal matchBillTotalAmount = matchBill.getBigDecimal("applytotalamount");
        BigDecimal issueProportion = totalAmount.divide(matchBillTotalAmount, 8, RoundingMode.HALF_UP);
        Map<Object, List<DynamicObject>> matchItemId2BillItemIdMap = Arrays.stream(billRelations).collect(Collectors.groupingBy(relation -> relation.get("tdetailid")));
        for (DynamicObject matchItem : matchItems) {
            List<DynamicObject> billItems = matchItemId2BillItemIdMap.get(matchItem.getLong("id"));
            for (DynamicObject bill2MatchBillRelation : billItems) {
                BigDecimal issuedNum;
                BigDecimal issuedTax;
                BigDecimal issuedAmount;
                DynamicObject bill = (DynamicObject)((Map)billItemIdAnditemId2BillMap.getValue()).get(bill2MatchBillRelation.getLong("sdetailid"));
                DynamicObject billItem = (DynamicObject)((Map)billItemIdAnditemId2BillMap.getKey()).get(bill2MatchBillRelation.getLong("sdetailid"));
                DynamicObject writeBackLog = MatchBillWriteBackHelper.createWriteBackLog(bill, invoice);
                JSONObject writeJson = new JSONObject();
                writeJson.put("sDetailId", (Object)billItem.getLong("id"));
                writeJson.put("desc", (Object)"\u8d1f\u6570\u5339\u84dd\u7968\u56de\u5199");
                MatchBillWriteBackHelper.updateBefore(writeJson, billItem);
                if (isLastInvIssued) {
                    issuedAmount = billItem.getBigDecimal("amount").subtract(billItem.getBigDecimal("issuedamount"));
                    issuedTax = billItem.getBigDecimal("tax").subtract(billItem.getBigDecimal("issuedtax"));
                    issuedNum = billItem.getBigDecimal("num").subtract(billItem.getBigDecimal("issuednum"));
                } else {
                    issuedAmount = billItem.getBigDecimal("amount").multiply(issueProportion).setScale(2, RoundingMode.HALF_UP);
                    issuedTax = billItem.getBigDecimal("tax").multiply(issueProportion).setScale(2, RoundingMode.HALF_UP);
                    issuedNum = billItem.getBigDecimal("num").multiply(issueProportion).setScale(2, RoundingMode.HALF_UP);
                }
                billItem.set("issuedamount", (Object)billItem.getBigDecimal("issuedamount").add(issuedAmount));
                billItem.set("issuedtax", (Object)billItem.getBigDecimal("issuedtax").add(issuedTax));
                billItem.set("issuednum", (Object)billItem.getBigDecimal("issuednum").add(issuedNum));
                billItem.set("issuedtotaltaxamount", (Object)billItem.getBigDecimal("issuedamount").add(billItem.getBigDecimal("issuedtax")));
                MatchBillWriteBackHelper.updateAfter(writeJson, billItem);
                writeBackLog.set("param", (Object)writeJson.toJSONString());
                writeBackLogList.add(writeBackLog);
                MatchBillWriteBackHelper.writeBillIssued(bill, issuedAmount, issuedTax);
                if (!BotpHelper.isFromAr((Object)bill.getString("systemsource"))) continue;
                MatchBillWriteBackHelper.addArIssuedRelation(bill, billItem, arIssuedRelationMap, issuedAmount, issuedTax, issuedNum);
            }
        }
        MatchBillWriteBackHelper.updateNegativeBillDiff(bills, redConfirm);
        MatchBillWriteBackHelper.updateBill(arIssuedRelationMap, writeBackLogList, bills, invoice);
    }

    private static void autoMatchWriteBack(DynamicObject invoice, DynamicObject invoiceOrRedconfirm, DynamicObject[] invRelations, DynamicObject[] billRelations) {
        DynamicObject[] dynamicObjectArray;
        BigDecimal billTotalAmount;
        HashMap<Long, ArBillRelationExtensionDTO> arIssuedRelationMap = new HashMap<Long, ArBillRelationExtensionDTO>(16);
        ArrayList<DynamicObject> writeBackLogList = new ArrayList<DynamicObject>(16);
        Map<Object, List<DynamicObject>> relationMap = Arrays.stream(invRelations).collect(Collectors.groupingBy(relation -> relation.get("tdetailid")));
        HashMap<Object, Triple> matchBillAmountMap = new HashMap<Object, Triple>(invRelations.length);
        DynamicObjectCollection redConfirmItems = invoiceOrRedconfirm.getDynamicObjectCollection("items");
        for (DynamicObject redConfirmItem : redConfirmItems) {
            List<DynamicObject> relations = relationMap.get(redConfirmItem.getPkValue());
            if (CollectionUtils.isEmpty(relations)) continue;
            for (DynamicObject relation2 : relations) {
                Triple amountTriple = matchBillAmountMap.computeIfAbsent(relation2.getLong("sdetailid"), k -> Triple.of((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO));
                Triple triple = Triple.of((Object)((BigDecimal)amountTriple.getLeft()).add(relation2.getBigDecimal("amount")), (Object)((BigDecimal)amountTriple.getMiddle()).add(relation2.getBigDecimal("tax")), (Object)((BigDecimal)amountTriple.getRight()).add(relation2.getBigDecimal("num")));
                matchBillAmountMap.put(relation2.getLong("sdetailid"), triple);
            }
        }
        Object[] pkArr = Arrays.stream(billRelations).filter(relation -> matchBillAmountMap.containsKey(relation.get("tdetailid"))).map(relation -> relation.get("sbillid")).distinct().toArray();
        DynamicObject[] bills = MatchBillWriteBackHelper.loadOriginalBill(pkArr, writeback_fields);
        Pair<Map<Object, DynamicObject>, Map<Object, DynamicObject>> billItemIdAnditemId2BillMap = MatchBillWriteBackHelper.getBillItemIdAnditemId2BillMap(bills);
        Map<Object, List<DynamicObject>> matchItemId2BillItemIdMap = Arrays.stream(billRelations).filter(relation -> matchBillAmountMap.containsKey(relation.get("tdetailid"))).collect(Collectors.groupingBy(relation -> relation.get("tdetailid")));
        Set entries = matchBillAmountMap.entrySet();
        block2: for (Map.Entry entry : entries) {
            Triple issueTriple = (Triple)entry.getValue();
            if (((BigDecimal)issueTriple.getLeft()).compareTo(BigDecimal.ZERO) == 0) continue;
            List<DynamicObject> billItemIds = matchItemId2BillItemIdMap.get(entry.getKey());
            for (DynamicObject relation3 : billItemIds) {
                BigDecimal num;
                BigDecimal tax;
                BigDecimal amount;
                if (((BigDecimal)issueTriple.getLeft()).compareTo(BigDecimal.ZERO) == 0) continue block2;
                DynamicObject billItem = (DynamicObject)((Map)billItemIdAnditemId2BillMap.getKey()).get(relation3.get("sdetailid"));
                BigDecimal remainIssuedAmount = billItem.getBigDecimal("amount").subtract(billItem.getBigDecimal("issuedamount"));
                if (remainIssuedAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
                DynamicObject bill2 = (DynamicObject)((Map)billItemIdAnditemId2BillMap.getValue()).get(billItem.getPkValue());
                DynamicObject writeBackLog = MatchBillWriteBackHelper.createWriteBackLog(bill2, invoice);
                JSONObject writeJson = new JSONObject();
                writeJson.put("sDetailId", (Object)relation3.getLong("sdetailid"));
                writeJson.put("desc", (Object)"\u8d1f\u6570\u5339\u84dd\u7968\u56de\u5199");
                MatchBillWriteBackHelper.updateBefore(writeJson, billItem);
                if (remainIssuedAmount.abs().compareTo(((BigDecimal)issueTriple.getLeft()).abs()) < 0) {
                    BigDecimal remainIssuedTax;
                    amount = remainIssuedAmount;
                    BigDecimal remainIssuedNum = billItem.getBigDecimal("num").subtract(billItem.getBigDecimal("issuednum"));
                    tax = remainIssuedTax = billItem.getBigDecimal("tax").subtract(billItem.getBigDecimal("issuedtax"));
                    num = remainIssuedNum;
                    issueTriple = Triple.of((Object)((BigDecimal)issueTriple.getLeft()).subtract(remainIssuedAmount), (Object)((BigDecimal)issueTriple.getMiddle()).subtract(remainIssuedTax), (Object)((BigDecimal)issueTriple.getRight()).subtract(remainIssuedNum));
                } else {
                    amount = (BigDecimal)issueTriple.getLeft();
                    tax = (BigDecimal)issueTriple.getMiddle();
                    num = (BigDecimal)issueTriple.getRight();
                    issueTriple = Triple.of((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO);
                }
                billItem.set("issuedamount", (Object)billItem.getBigDecimal("issuedamount").add(amount));
                billItem.set("issuedtax", (Object)billItem.getBigDecimal("issuedtax").add(tax));
                billItem.set("issuednum", (Object)billItem.getBigDecimal("issuednum").add(num));
                billItem.set("issuedtotaltaxamount", (Object)billItem.getBigDecimal("issuedamount").add(billItem.getBigDecimal("issuedtax")));
                MatchBillWriteBackHelper.updateAfter(writeJson, billItem);
                if (BotpHelper.isFromAr((Object)bill2.getString("systemsource"))) {
                    MatchBillWriteBackHelper.addArIssuedRelation(bill2, billItem, arIssuedRelationMap, amount, tax, num);
                }
                writeBackLog.set("param", (Object)writeJson.toJSONString());
                writeBackLogList.add(writeBackLog);
                MatchBillWriteBackHelper.writeBillIssued(bill2, amount, tax);
            }
        }
        DynamicObject matchBill = BusinessDataServiceHelper.loadSingle((String)"sim_match_bill", (String)String.join((CharSequence)",", "mainissuedamount", "mainissuedtax", "applyamount"), (QFilter[])new QFilter("id", "in", (Object)Arrays.stream(invRelations).map(relation -> relation.get("sbillid")).distinct().toArray()).toArray());
        matchBill.set("mainissuedamount", (Object)matchBill.getBigDecimal("mainissuedamount").add(invoice.getBigDecimal("invoiceamount")));
        matchBill.set("mainissuedtax", (Object)matchBill.getBigDecimal("mainissuedtax").add(invoice.getBigDecimal("totaltax")));
        ImcSaveServiceHelper.update((DynamicObject)matchBill);
        if (matchBill.getBigDecimal("applyamount").compareTo(matchBill.getBigDecimal("mainissuedamount")) == 0 && (billTotalAmount = Arrays.stream(dynamicObjectArray = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)String.join((CharSequence)",", "mainissuedamount", "mainissuedtax", "surplusamount", "surplustax", "validstate", "invoiceamount", "totaltax", "amount", "tax", "taxamount", "num", "issuedamount", "issuedtax", "issuedtotaltaxamount", "issuednum"), (QFilter[])new QFilter("id", "in", (Object)Arrays.stream(billRelations).map(relation -> relation.get("sbillid")).distinct().toArray()).toArray())).map(bill -> bill.getBigDecimal("invoiceamount")).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(matchBill.getBigDecimal("mainissuedamount")) == 0) {
            for (DynamicObject bill3 : dynamicObjectArray) {
                bill3.set("mainissuedamount", (Object)bill3.getBigDecimal("invoiceamount"));
                bill3.set("mainissuedtax", (Object)bill3.getBigDecimal("totaltax"));
                bill3.set("surplusamount", (Object)BigDecimal.ZERO);
                bill3.set("surplustax", (Object)BigDecimal.ZERO);
                bill3.set("validstate", (Object)"2");
                DynamicObjectCollection items = bill3.getDynamicObjectCollection("sim_original_bill_item");
                for (DynamicObject item : items) {
                    item.set("issuedamount", (Object)item.getBigDecimal("amount"));
                    item.set("issuedtax", (Object)item.getBigDecimal("tax"));
                    item.set("issuedtotaltaxamount", (Object)item.getBigDecimal("taxamount"));
                    item.set("issuednum", (Object)item.getBigDecimal("num"));
                }
            }
        }
        MatchBillWriteBackHelper.updateBill(arIssuedRelationMap, writeBackLogList, bills, invoice);
    }

    private static Pair<Map<Object, DynamicObject>, Map<Object, DynamicObject>> getBillItemIdAnditemId2BillMap(DynamicObject[] bills) {
        HashMap<Object, DynamicObject> billItemIdMaps = new HashMap<Object, DynamicObject>(bills.length);
        HashMap<Object, DynamicObject> itemId2Bill = new HashMap<Object, DynamicObject>(bills.length);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection billItems = bill.getDynamicObjectCollection("sim_original_bill_item");
            for (DynamicObject billItem : billItems) {
                billItemIdMaps.put(billItem.getPkValue(), billItem);
                itemId2Bill.put(billItem.getPkValue(), bill);
            }
        }
        return Pair.of(billItemIdMaps, itemId2Bill);
    }

    private static void updateBill(Map<Long, ArBillRelationExtensionDTO> arIssuedRelationMap, List<DynamicObject> writeBackLogList, DynamicObject[] bills, DynamicObject invoice) {
        try (TXHandle tx = TX.requiresNew();){
            ImcSaveServiceHelper.save(writeBackLogList);
        }
        catch (Exception e) {
            LOG.error("\u4fdd\u5b58\u5f00\u7968\u56de\u5199\u6570\u636e\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        MatchBillWriteBackHelper.updateBillState(bills, invoice, false, false, arIssuedRelationMap);
    }

    private static boolean isManualedLastInvIssuedWriteBack(DynamicObject[] bills, DynamicObject matchBill, DynamicObject invoice) {
        if ("no".equals(ImcConfigUtil.getValue((String)"isManualedLastInvIssuedWriteBack", (String)"isManualedLastInvIssuedWriteBack"))) {
            return false;
        }
        BigDecimal billTotalAmount = BigDecimal.ZERO;
        BigDecimal billIssuedTotalAmount = BigDecimal.ZERO;
        for (DynamicObject bill : bills) {
            billTotalAmount = billTotalAmount.add(bill.getBigDecimal("totalamount"));
            billIssuedTotalAmount = billIssuedTotalAmount.add(bill.getBigDecimal("mainissuedamount")).add(bill.getBigDecimal("mainissuedtax"));
        }
        BigDecimal matchBillTotalAmount = matchBill.getBigDecimal("applytotalamount");
        if (matchBillTotalAmount.compareTo(billTotalAmount) != 0) {
            LOG.info("matchBillTotalAmountNotEqualsAllRelateBillsTotalAmount");
            return false;
        }
        BigDecimal differ = billTotalAmount.subtract(billIssuedTotalAmount.add(invoice.getBigDecimal("totalamount"))).abs();
        if (BigDecimal.ONE.compareTo(differ) > 0) {
            LOG.info("billIssuedTotalAmountAddInvoiceTotalAmountNotEqualsBillTotalAmount");
            return false;
        }
        DynamicObject[] matchBillInvRelations = BusinessDataServiceHelper.load((String)"sim_match_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_match_inv_relation"), (QFilter[])new QFilter("sbillid", "=", matchBill.getPkValue()).toArray());
        Set redConfirmPks = Arrays.stream(matchBillInvRelations).map(o -> o.getLong("tbillid")).collect(Collectors.toSet());
        DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill"), (QFilter[])new QFilter("id", "in", redConfirmPks).toArray());
        if (redConfirms.length == 0) {
            LOG.info("noRedConfirms");
            return false;
        }
        BigDecimal redConfirmsTotalAmount = BigDecimal.ZERO;
        String redConfirmBillNumber = invoice.getString("infocode");
        for (DynamicObject redConfirm : redConfirms) {
            redConfirmsTotalAmount = redConfirmsTotalAmount.add(redConfirm.getBigDecimal("totalamount"));
            String number = redConfirm.getString("number");
            if (!StringUtils.isNotBlank((CharSequence)number) || number.equals(redConfirmBillNumber) || "0".equals(redConfirm.getString("issuestatus"))) continue;
            LOG.info("otherRedConfirmNotIssued");
            return false;
        }
        return redConfirmsTotalAmount.compareTo(matchBillTotalAmount) == 0;
    }

    private static void addArIssuedRelation(DynamicObject bill, DynamicObject billItem, Map<Long, ArBillRelationExtensionDTO> map, BigDecimal amount, BigDecimal tax, BigDecimal num) {
        ArBillRelationExtensionDTO arBillRelation;
        String closeStatus = bill.getString("closestatus");
        boolean isClosed = "1".equals(closeStatus);
        String rowType = billItem.getString("rowtype");
        DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
        DynamicObject lastRow = null;
        for (int i = 0; i < items.size(); ++i) {
            DynamicObject currentItem = (DynamicObject)items.get(i);
            if (billItem.getPkValue() != currentItem.getPkValue() || i == 0) continue;
            lastRow = (DynamicObject)items.get(i - 1);
            break;
        }
        Long sDetailPk = billItem.getLong("id");
        if ("1".equals(rowType) && null != lastRow) {
            sDetailPk = lastRow.getLong("id");
        }
        if (null == (arBillRelation = map.get(sDetailPk))) {
            arBillRelation = new ArBillRelationExtensionDTO();
            map.put(sDetailPk, arBillRelation);
            if ("1".equals(rowType) && null != lastRow) {
                arBillRelation.setDeducatedRow(Boolean.valueOf(true));
            }
            arBillRelation.setsDetailId(sDetailPk);
        }
        arBillRelation.setsBillId(Long.valueOf(bill.getLong("id")));
        arBillRelation.setAmount(arBillRelation.getAmount().add(amount));
        arBillRelation.setTax(arBillRelation.getTax().add(tax));
        BigDecimal beforeRateNum = BotpHelper.getNumBeforeNumRate((BigDecimal)num, (DynamicObject)billItem);
        arBillRelation.setNum(arBillRelation.getNum().add(beforeRateNum));
        arBillRelation.setClosed(Boolean.valueOf(isClosed));
        arBillRelation.setFrom(Boolean.valueOf(CurrencyHelper.isFrom((Object)bill.getDynamicObject("fromcurr"))));
    }
}

