/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.model.invoice;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public enum CoalTypeCodeEnum {
    GOVERNMENT_COAL("0100", "\u653f\u5e9c\u4fdd\u4f9b\u7164"),
    LONG_TERM_COAL_6("0201", "\u957f\u534f\u7164-\u534f\u8bae\u671f\u4e0d\u8db3\u534a\u5e74"),
    LONG_TERM_COAL_6_12("0202", "\u957f\u534f\u7164-\u534f\u8bae\u671f\u5728\u534a\u5e74\u81f3\u4e00\u5e74\u4e4b\u95f4"),
    LONG_TERM_COAL_12_24("0203", "\u957f\u534f\u7164-\u534f\u8bae\u671f\u5728\u4e00\u5e74\u81f3\u4e24\u5e74\u4e4b\u95f4"),
    LONG_TERM_COAL_24("0204", "\u957f\u534f\u7164-\u534f\u8bae\u671f\u5728\u4e24\u5e74\u4ee5\u4e0a"),
    MARKET_COAL("0300", "\u5e02\u573a\u7164");

    private String code;
    private String description;
    public static Set<String> coalTypeCodeSet;
    public static Set<String> coalTypeGoodsCode;

    private CoalTypeCodeEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static String getCodeByDesc(String description) {
        if (StringUtils.isEmpty((String)description)) {
            return null;
        }
        for (CoalTypeCodeEnum value : CoalTypeCodeEnum.values()) {
            if (!value.getDescription().equals(description)) continue;
            return value.getCode();
        }
        return null;
    }

    public static Set<String> getCoalTypeCodeSet() {
        HashSet<String> coalTypeCodeSet = new HashSet<String>(6);
        for (CoalTypeCodeEnum value : CoalTypeCodeEnum.values()) {
            coalTypeCodeSet.add(value.getCode());
        }
        return coalTypeCodeSet;
    }

    static {
        coalTypeCodeSet = Sets.newHashSet((Object[])new String[]{"0100", "0201", "0202", "0203", "0204", "0300"});
        coalTypeGoodsCode = Sets.newHashSet((Object[])new String[]{"1020101000000000000", "1020102000000000000", "1020199000000000000"});
    }
}

