/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.dto.BillFreightItemVo;
import kd.imc.bdm.common.dto.allelespecial.BillEstateSaleItemVo;
import kd.imc.bdm.common.dto.allelespecial.BillTravlerInfoVo;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.model.BaseInvoice;
import kd.imc.bdm.common.model.BaseInvoiceItem;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.service.ImcPushInvoiceToIsmcService;
import kd.imc.sim.common.service.InvoiceAddService;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.service.VehicleInvoiceAddService;
import kd.imc.sim.common.service.WideInvoiceSevice;
import kd.imc.sim.common.utils.MathUtils;
import org.apache.commons.collections4.CollectionUtils;

public class InvoiceAddServiceImpl
implements InvoiceAddService {
    private static final String SYSTEM_SOURCE_INCOME_DOWNLOAD = "INCOME_DOWNLOAD";
    private static final Log LOGGER = LogFactory.getLog(InvoiceAddServiceImpl.class);
    private static final String TXF = "15";
    private static final String JDC = "12";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String addInvoice(JSONObject inputJson) {
        long start = System.currentTimeMillis();
        MsgResponse response = new MsgResponse();
        LOGGER.info("InvoiceAddServiceImpladdInvoiceJSON:" + inputJson);
        String inputInvoiceType = inputJson.getString("invoiceType");
        if (JDC.equals(inputInvoiceType)) {
            MsgResponse msgResponse = VehicleInvoiceAddService.VehicleInvoiceAddService((JSONObject)inputJson);
            return JSONObject.toJSONString((Object)msgResponse);
        }
        try {
            DynamicObject saveInvoice;
            BaseInvoice baseInvoice;
            block29: {
                baseInvoice = this.jsonToBaseInvoice(inputJson, "9");
                if (baseInvoice == null) {
                    return JSONObject.toJSONString((Object)MsgResponse.valueOfError((String)ErrorType.FAIL.getCode(), (String)ResManager.loadKDString((String)"\u53d1\u7968\u8f6c\u6362\u4e3a\u7a7a", (String)"InvoiceAddServiceImpl_0", (String)"imc-sim-common", (Object[])new Object[0])));
                }
                if (!(!CollectionUtils.isEmpty((Collection)baseInvoice.getInvoiceItemList()) || baseInvoice.getInvoiceamount().compareTo(BigDecimal.ZERO) == 0 && "6".equals(baseInvoice.getInvoicestatus()) && InvoiceUtils.isPaperInvoice((String)baseInvoice.getInvoicetype()))) {
                    return JSONObject.toJSONString((Object)MsgResponse.valueOfError((String)ErrorType.FAIL.getCode(), (String)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801[%1$s],\u53f7\u7801[%2$s]\u53d1\u7968\u660e\u7ec6\u4e3a\u7a7a", (String)"InvoiceAddServiceImpl_1", (String)"imc-sim-common", (Object[])new Object[0]), baseInvoice.getInvoicecode(), baseInvoice.getInvoiceno())));
                }
                String errorMsg = this.checkBaseInvoice(baseInvoice);
                if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                    return JSONObject.toJSONString((Object)MsgResponse.valueOfError((String)ErrorType.FAIL.getCode(), (String)errorMsg));
                }
                String invoiceCode = baseInvoice.getInvoicecode();
                String invoiceNo = baseInvoice.getInvoiceno();
                String invoiceStatus = baseInvoice.getInvoicestatus();
                DynamicObject[] queryInvoiceList = this.queryInvoice(invoiceCode, invoiceNo, baseInvoice.getInvoicetype());
                boolean isDbInvSuccess = this.checkDbInvoiceSuccess(queryInvoiceList);
                this.setSpecialFields(queryInvoiceList, baseInvoice);
                if (queryInvoiceList.length == 0 || !isDbInvSuccess) {
                    try (TXHandle tx = TX.requiresNew();){
                        try {
                            saveInvoice = this.fillInfoAndSave(baseInvoice, inputInvoiceType);
                            WideInvoiceSevice.addInvoiceToWide(saveInvoice);
                            if (!isDbInvSuccess) {
                                this.deleteWrongDataAndWriteIssueAmount(saveInvoice, queryInvoiceList);
                            }
                            this.saveBlueInvoiceStatus(saveInvoice);
                            break block29;
                        }
                        catch (Throwable e) {
                            LOGGER.error("InvoiceAddServiceImplAddInvoiceFail:" + e.getMessage(), e);
                            tx.markRollback();
                            response.setErrorCode(ErrorType.FAIL.getCode());
                            response.setErrorMsg(String.valueOf(e.getMessage()));
                            String string = JSONObject.toJSONString((Object)response);
                            if (tx == null) return string;
                            if (var15_18 == null) {
                                tx.close();
                                return string;
                            }
                            try {
                                tx.close();
                                return string;
                            }
                            catch (Throwable throwable) {
                                var15_18.addSuppressed(throwable);
                                return string;
                            }
                        }
                    }
                }
                if (!String.valueOf(queryInvoiceList[0].getString("invoicestatus")).equals(invoiceStatus)) {
                    saveInvoice = this.updateLocalInvoiceStatus(baseInvoice);
                } else {
                    saveInvoice = queryInvoiceList[0];
                    IssueInvoiceService.updateTaxOrg(saveInvoice);
                    SaveServiceHelper.update((DynamicObject)saveInvoice);
                }
            }
            this.dealSetInvoiceRemarkMethod(saveInvoice, baseInvoice);
            response.setErrorCode(ErrorType.SUCCESS.getCode());
            response.setErrorMsg(ErrorType.SUCCESS.getName());
            response.setMsgId(saveInvoice.getString("orderno"));
            ImcPushInvoiceToIsmcService.componentInvoicePushToISMCRequest(saveInvoice, false);
        }
        catch (MsgException e) {
            LOGGER.error("InvoiceAddServiceImplAddInvoiceFail:" + e.getErrorMsg(), (Throwable)e);
            response.setErrorCode(ErrorType.FAIL.getCode());
            response.setErrorMsg(String.valueOf(e.getErrorMsg()));
        }
        catch (Exception e) {
            LOGGER.error("InvoiceAddServiceImplAddInvoiceFail:" + e.getMessage(), (Throwable)e);
            response.setErrorCode(ErrorType.FAIL.getCode());
            response.setErrorMsg(String.valueOf(e.getMessage()));
        }
        catch (Throwable t) {
            LOGGER.error("InvoiceAddServiceImplAddInvoiceFail:" + t.getMessage(), t);
            response.setErrorCode(ErrorType.FAIL.getCode());
            response.setErrorMsg(t.getMessage());
            throw t;
        }
        long end = System.currentTimeMillis();
        LOGGER.info("InvoiceAddServiceImplTime:" + (end - start));
        return JSONObject.toJSONString((Object)response);
    }

    private void setSpecialFields(DynamicObject[] queryInvoiceList, BaseInvoice baseInvoice) {
        if (queryInvoiceList.length == 0 || "00".equals(baseInvoice.getSpecialtype())) {
            return;
        }
        if (!"00".equals(queryInvoiceList[0].getString("specialtype"))) {
            return;
        }
        DynamicObject invoice = queryInvoiceList[0];
        if ("E03".equals(baseInvoice.getSpecialtype()) && StringUtils.isNotBlank((CharSequence)baseInvoice.getBuildingname())) {
            invoice.set("landtaxno", (Object)baseInvoice.getLandtaxno());
            invoice.set("crosscitysign", (Object)baseInvoice.getCrosscitysign());
            invoice.set("simpleaddress", (Object)baseInvoice.getSimpleaddress());
            invoice.set("buildingname", (Object)baseInvoice.getBuildingname());
        }
        if ("E04".equals(baseInvoice.getSpecialtype())) {
            DynamicObjectCollection freightItems = invoice.getDynamicObjectCollection("freights");
            List baseFreightItems = baseInvoice.getFreightItems();
            if (null != baseFreightItems && baseFreightItems.size() > 0) {
                freightItems.clear();
                for (BillFreightItemVo baseFreightItem : baseFreightItems) {
                    DynamicObject newFreightItem = freightItems.addNew();
                    DynamicObjectUtil.bean2DynamicObject((Object)baseFreightItem, (DynamicObject)newFreightItem);
                }
            }
        }
        if ("E06".equals(baseInvoice.getSpecialtype())) {
            DynamicObjectCollection estateItems = invoice.getDynamicObjectCollection("estatesales");
            List estateLeaseItems = baseInvoice.getEstateLeaseItems();
            if (null != estateLeaseItems && estateLeaseItems.size() > 0) {
                estateItems.clear();
                for (BillEstateSaleItemVo estateLeaseItem : estateLeaseItems) {
                    DynamicObject newLeaseItem = estateItems.addNew();
                    DynamicObjectUtil.bean2DynamicObject((Object)estateLeaseItem, (DynamicObject)newLeaseItem);
                }
            }
        }
        if ("E09".equals(baseInvoice.getSpecialtype())) {
            DynamicObjectCollection travelerItems = invoice.getDynamicObjectCollection("travelers");
            List travelerList = baseInvoice.getTravelerList();
            if (null != travelerList && travelerList.size() > 0) {
                travelerItems.clear();
                for (BillTravlerInfoVo billTravlerInfoVo : travelerList) {
                    DynamicObject newTravelerItem = travelerItems.addNew();
                    DynamicObjectUtil.bean2DynamicObject((Object)billTravlerInfoVo, (DynamicObject)newTravelerItem);
                }
            }
        }
    }

    private void deleteWrongDataAndWriteIssueAmount(DynamicObject saveInvoice, DynamicObject[] queryInvoiceList) {
        DeleteServiceHelper.delete((String)"sim_vatinvoice", (QFilter[])new QFilter("id", "=", queryInvoiceList[0].getPkValue()).toArray());
        ArrayList<Long> ids = new ArrayList<Long>(queryInvoiceList.length);
        ids.add(saveInvoice.getLong("id"));
        DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)true), (QFilter[])new QFilter("originalinvoicecode", "=", (Object)saveInvoice.getString("invoicecode")).and("originalinvoiceno", "=", (Object)saveInvoice.getString("invoiceno")).and("createtime", ">=", (Object)saveInvoice.getDate("issuetime")).and("issuestatus", "=", (Object)"0").toArray());
        if (redConfirms.length > 0) {
            for (DynamicObject redConfirm : redConfirms) {
                DynamicObjectCollection items = redConfirm.getDynamicObjectCollection("items");
                for (DynamicObject item : items) {
                    item.set("originalinvoiceitemid", (Object)0L);
                }
            }
            ImcSaveServiceHelper.save((DynamicObject[])redConfirms);
        }
        DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"RedConfirmAndInvoiceRepairServiceImpl", (String)"repairInvoiceRemainAmount", (Object[])new Object[]{ids});
    }

    private boolean checkDbInvoiceSuccess(DynamicObject[] queryInvoiceList) {
        if (queryInvoiceList.length == 0) {
            return true;
        }
        DynamicObject invoice = queryInvoiceList[0];
        String buyerType = invoice.getString("buyertype");
        if (!"9".equals(buyerType)) {
            return true;
        }
        DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (DynamicObject item : items) {
            totalAmount = totalAmount.add(item.getBigDecimal("taxamount"));
        }
        BigDecimal headTotalAmount = invoice.getBigDecimal("totalamount");
        return headTotalAmount.compareTo(totalAmount) == 0;
    }

    private String checkBaseInvoice(BaseInvoice baseInvoice) {
        String buyerType = baseInvoice.getBuyertype();
        BigDecimal totalamount = baseInvoice.getTotalamount();
        List list = baseInvoice.getInvoiceItemList();
        BigDecimal totalItemTaxAmount = BigDecimal.ZERO;
        for (BaseInvoiceItem baseInvoiceItem : list) {
            BigDecimal taxAmount = baseInvoiceItem.getTaxAmount();
            totalItemTaxAmount = totalItemTaxAmount.add(taxAmount);
        }
        if (totalamount.compareTo(totalItemTaxAmount) != 0) {
            return ResManager.loadKDString((String)"\u8fdb\u9879\u4e0b\u8f7d\u6570\u636e\u660e\u7ec6\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u7b49\u4e8e\u603b\u7684\u4ef7\u7a0e\u5408\u8ba1", (String)"InvoiceAddServiceImpl_2", (String)"imc-sim-common", (Object[])new Object[0]);
        }
        return null;
    }

    private void dealSetInvoiceRemarkMethod(DynamicObject invoiceObject, BaseInvoice baseInvoice) {
        String issueType = baseInvoice.getIssuetype();
        if (IssueType.RED_INVOICE.getTypeCode().equals(issueType)) {
            invoiceObject.set("remark", (Object)baseInvoice.getRemark());
            ImcSaveServiceHelper.update((DynamicObject)invoiceObject);
        }
    }

    public boolean saveAwsInvoice(JSONObject inputJson) {
        boolean saveSuccess = false;
        try {
            BaseInvoice baseInvoice = this.jsonToBaseInvoice(inputJson, "10");
            if (baseInvoice == null) {
                return false;
            }
            DynamicObject[] dbData = this.queryInvoice(baseInvoice.getInvoicecode(), baseInvoice.getInvoiceno(), baseInvoice.getInvoicetype());
            if (dbData.length == 0) {
                DynamicObject saveInvoice = this.fillInfoAndSave(baseInvoice, null);
                WideInvoiceSevice.addInvoiceToWide(saveInvoice);
                saveInvoice.set("buyertype", (Object)"10");
                saveInvoice.set("systemsource", (Object)"AWS_SYNC");
                ImcSaveServiceHelper.update((DynamicObject)saveInvoice);
                saveSuccess = true;
            } else if (!String.valueOf(dbData[0].getString("invoicestatus")).equals(baseInvoice.getInvoicestatus())) {
                this.updateLocalInvoiceStatus(baseInvoice);
                saveSuccess = true;
            }
        }
        catch (Exception e) {
            LOGGER.error("InvoiceAddServiceImplAddInvoiceFail:" + e.getMessage(), (Throwable)e);
        }
        return saveSuccess;
    }

    private BaseInvoice jsonToBaseInvoice(JSONObject invoiceJson, String buyerType) {
        String invoiceType = invoiceJson.getString("invoiceType");
        BaseInvoice baseInvoice = new BaseInvoice();
        baseInvoice.setInvoicecode(invoiceJson.getString("invoiceCode"));
        baseInvoice.setInvoiceno(invoiceJson.getString("invoiceNo"));
        baseInvoice.setSalername(invoiceJson.getString("salerName"));
        BigDecimal invoiceAmount = invoiceJson.getBigDecimal("invoiceAmount");
        baseInvoice.setInvoiceamount(invoiceAmount);
        baseInvoice.setRemark(GBKUtils.cutGBKString((String)invoiceJson.getString("remark"), (int)230));
        baseInvoice.setInvoicetype(InvoiceAddServiceImpl.convertRIMInvoiceType(invoiceJson.getString("invoiceType")));
        baseInvoice.setJqbh(invoiceJson.getString("machineNo"));
        baseInvoice.setPayee(invoiceJson.getString("payee"));
        baseInvoice.setSalertaxno(invoiceJson.getString("salerTaxNo"));
        baseInvoice.setTaxedtype("0");
        baseInvoice.setBuyeraddr(invoiceJson.getString("buyerAddressPhone"));
        baseInvoice.setSalerbank(invoiceJson.getString("salerAccount"));
        baseInvoice.setBuyertaxno(invoiceJson.getString("buyerTaxNo"));
        baseInvoice.setDrawer(invoiceJson.getString("drawer"));
        baseInvoice.setReviewer(invoiceJson.getString("reviewer"));
        baseInvoice.setBuyername(invoiceJson.getString("buyerName"));
        baseInvoice.setCheckcode(invoiceJson.getString("checkCode"));
        baseInvoice.setOrgid(invoiceJson.getString("orgid"));
        baseInvoice.setHsbz("0");
        baseInvoice.setTotalamount(invoiceJson.getBigDecimal("totalAmount"));
        baseInvoice.setSaleraddr(invoiceJson.getString("salerAddressPhone"));
        baseInvoice.setBuyerbank(invoiceJson.getString("buyerAccount"));
        baseInvoice.setInvoicestatus(InvoiceAddServiceImpl.matchStatus(invoiceJson.getString("invoiceStatus")));
        baseInvoice.setTotaltax(invoiceJson.getBigDecimal("totalTaxAmount"));
        baseInvoice.setIssuetime(invoiceJson.getDate("invoiceDate"));
        baseInvoice.setSkm(invoiceJson.getString("cipherArea"));
        baseInvoice.setIssuetype(invoiceJson.getString("type"));
        if (StringUtils.isBlank((CharSequence)baseInvoice.getIssuetype())) {
            BigDecimal totalAmount = baseInvoice.getTotalamount();
            String typeCode = BigDecimalUtil.greaterZero((BigDecimal)totalAmount) ? IssueType.BLUE_INVOICE.getTypeCode() : IssueType.RED_INVOICE.getTypeCode();
            baseInvoice.setIssuetype(typeCode);
        }
        baseInvoice.setAlletaxinvoiceno(invoiceJson.getString("etaxInvoiceNo"));
        if ("10".equals(buyerType)) {
            String fileUrl = invoiceJson.getString("kdorgpdfurl");
            if (StringUtils.isBlank((CharSequence)fileUrl)) {
                fileUrl = invoiceJson.getString("pdfurl");
            }
            baseInvoice.setFileurl(fileUrl);
            baseInvoice.setSnapshoturl(invoiceJson.getString("snapshotUrl"));
            baseInvoice.setBuyeremail(invoiceJson.getString("buyerEmail"));
            baseInvoice.setBuyerphone(invoiceJson.getString("buyerMobilePhone"));
        }
        String businessType = invoiceJson.getString("businessType");
        String specialType = this.convertSpecialType(businessType);
        baseInvoice.setSpecialtype(specialType);
        if (InvoiceUtils.isAllEInvoice((Object)baseInvoice.getInvoicetype())) {
            JSONArray travelerList;
            JSONArray estateList;
            JSONArray freightList;
            JSONObject buildInfo = invoiceJson.getJSONObject("buildInfo");
            if (null != buildInfo) {
                baseInvoice.setLandtaxno(buildInfo.getString("landTaxNo"));
                baseInvoice.setCrosscitysign(buildInfo.getString("crossCitySign"));
                baseInvoice.setSimpleaddress(buildInfo.getString("simpleAddress"));
                baseInvoice.setBuildingname(buildInfo.getString("buildingName"));
            }
            if (null != (freightList = invoiceJson.getJSONArray("freightList"))) {
                List freights = JSONObject.parseArray((String)freightList.toJSONString(), BillFreightItemVo.class);
                baseInvoice.setFreightItems(freights);
            }
            if (null != (estateList = invoiceJson.getJSONArray("estateLeaseInfoList"))) {
                List estateLeaseItems = JSONObject.parseArray((String)estateList.toJSONString(), BillEstateSaleItemVo.class);
                baseInvoice.setEstateLeaseItems(estateLeaseItems);
            }
            if (null != (travelerList = invoiceJson.getJSONArray("travelerList"))) {
                List travlers = JSONObject.parseArray((String)travelerList.toJSONString(), BillTravlerInfoVo.class);
                baseInvoice.setTravelerList(travlers);
            }
        }
        if (TXF.equals(invoiceType)) {
            baseInvoice.setSpecialtype("06");
        }
        boolean isHsbz = false;
        boolean isChae = false;
        BigDecimal duction = BigDecimal.ZERO;
        String listItemStr = "\u9500\u8d27\u6e05\u5355";
        if (StringUtils.isNotEmpty((CharSequence)invoiceJson.getString("items"))) {
            List items = JSONArray.parseArray((String)invoiceJson.getString("items"), Map.class);
            ArrayList<BaseInvoiceItem> baseInvoiceItems = new ArrayList<BaseInvoiceItem>(items.size());
            int seq = 0;
            int itemSize = items.size();
            boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)baseInvoice.getInvoicetype()) || AllEleAuthHelper.elePaperSetValue((Object)baseInvoice.getSalertaxno(), (Object)baseInvoice.getInvoicetype());
            for (Map item : items) {
                String goodsName = String.valueOf(item.get("goodsName"));
                if (goodsName.contains(listItemStr) && itemSize != 1) continue;
                BaseInvoiceItem baseInvoiceItem = new BaseInvoiceItem();
                if ("10".equals(buyerType)) {
                    baseInvoiceItem.setTaxrate(InvoiceAddServiceImpl.getBigDecimalVal(item.get("taxRate")).stripTrailingZeros());
                    if (new BigDecimal("0.1").compareTo(baseInvoiceItem.getTaxrate()) == 0) {
                        baseInvoiceItem.setTaxrate(new BigDecimal("0.10"));
                    }
                    BigDecimal unitPrice = InvoiceAddServiceImpl.getBigDecimalVal(item.get("unitPrice"));
                    baseInvoiceItem.setUnitprice(unitPrice);
                    BigDecimal num = InvoiceAddServiceImpl.getBigDecimalVal(item.get("num"));
                    baseInvoiceItem.setNum(num);
                    BigDecimal detailAmount = InvoiceAddServiceImpl.getBigDecimalVal(item.get("detailAmount"));
                    baseInvoiceItem.setAmount(detailAmount);
                    BigDecimal tax = InvoiceAddServiceImpl.getBigDecimalVal(item.get("taxAmount"));
                    baseInvoiceItem.setTax(tax);
                    BigDecimal itemDuction = InvoiceAddServiceImpl.getBigDecimalVal(item.get("deduction"));
                    if (BigDecimalUtil.greaterZero((BigDecimal)itemDuction)) {
                        duction = itemDuction;
                        isChae = true;
                    }
                    int itemTaxFlag = (Integer)item.get("taxFlag");
                    baseInvoiceItem.setTaxflag(String.valueOf(item.get("taxFlag")));
                    if (1 == itemTaxFlag) {
                        baseInvoiceItem.setTaxflag(String.valueOf(item.get("taxFlag")));
                        baseInvoiceItem.setTaxAmount(detailAmount);
                        baseInvoiceItem.setAmount(detailAmount.subtract(tax));
                        baseInvoiceItem.setTaxunitprice(unitPrice);
                        if (!MathUtils.isNullOrZero(num)) {
                            baseInvoiceItem.setUnitprice(PriceHelper.calcPriceOrNum(baseInvoiceItem.getAmount(), num, isAllEle));
                        }
                        isHsbz = true;
                    } else {
                        baseInvoiceItem.setTaxAmount(detailAmount.add(tax));
                        if (!MathUtils.isNullOrZero(num)) {
                            baseInvoiceItem.setTaxunitprice(PriceHelper.calcPriceOrNum(baseInvoiceItem.getTaxAmount(), num, isAllEle));
                        }
                    }
                } else if ("9".equals(buyerType)) {
                    baseInvoiceItem.setUnitprice(InvoiceAddServiceImpl.getBigDecimalVal(item.get("unitPrice")));
                    baseInvoiceItem.setTaxrate(new BigDecimal(StringUtils.isNotEmpty((CharSequence)((String)item.get("taxRate"))) ? (String)item.get("taxRate") : "0").stripTrailingZeros());
                    if (new BigDecimal("0.1").compareTo(baseInvoiceItem.getTaxrate()) == 0) {
                        baseInvoiceItem.setTaxrate(new BigDecimal("0.10"));
                    }
                    baseInvoiceItem.setNum(new BigDecimal(StringUtils.isNotEmpty((CharSequence)((String)item.get("num"))) ? (String)item.get("num") : "0"));
                    baseInvoiceItem.setAmount(InvoiceAddServiceImpl.getBigDecimalVal(item.get("detailAmount")));
                    baseInvoiceItem.setTax(InvoiceAddServiceImpl.getBigDecimalVal(item.get("taxAmount")));
                    baseInvoiceItem.setTaxAmount(baseInvoiceItem.getAmount().add(baseInvoiceItem.getTax()));
                    baseInvoiceItem.setTaxflag("0");
                }
                baseInvoiceItem.setUnit((String)item.get("unit"));
                baseInvoiceItem.setGoodscode((String)item.get("goodsCode"));
                baseInvoiceItem.setSpecification((String)item.get("specModel"));
                baseInvoiceItem.setGoodsname((String)item.get("goodsName"));
                baseInvoiceItem.setVehplate((String)item.get("vehPlate"));
                baseInvoiceItem.setStartdate(InvoiceAddServiceImpl.getDate((String)item.get("startDate")));
                baseInvoiceItem.setEnddate(InvoiceAddServiceImpl.getDate((String)item.get("endDate")));
                baseInvoiceItem.setSeq(String.valueOf(seq++));
                Object discountType = item.get("discountType");
                String discountTypeStr = null == discountType ? "0" : String.valueOf(discountType);
                baseInvoiceItem.setRowtype(discountTypeStr);
                baseInvoiceItems.add(baseInvoiceItem);
            }
            baseInvoice.setInvoiceItemList(baseInvoiceItems);
        }
        if ("10".equals(buyerType)) {
            specialType = "00";
            if (isHsbz) {
                baseInvoice.setHsbz("1");
            }
            if (isChae) {
                baseInvoice.setTaxedtype("2");
                baseInvoice.setDeduction(duction);
            }
            String qsbz = invoiceJson.getString("qsbz");
            String sgfp = invoiceJson.getString("sgfp");
            if (StringUtils.isNotBlank((CharSequence)qsbz) && "4".equals(qsbz)) {
                specialType = "08";
            }
            if (StringUtils.isNotBlank((CharSequence)sgfp) && "2".equals(sgfp)) {
                specialType = "02";
            }
            if (StringUtils.isNotBlank((CharSequence)sgfp) && "18".equals(sgfp)) {
                return null;
            }
            baseInvoice.setSpecialtype(specialType);
        }
        return baseInvoice;
    }

    private String convertSpecialType(String businessType) {
        if ("03".equals(businessType)) {
            return "E03";
        }
        if ("04".equals(businessType)) {
            return "E04";
        }
        if ("05".equals(businessType)) {
            return "E05";
        }
        if ("06".equals(businessType)) {
            return "E06";
        }
        if ("07".equals(businessType)) {
            return "E07";
        }
        if ("01".equals(businessType)) {
            return "E01";
        }
        if ("18".equals(businessType)) {
            return "E18";
        }
        return "00";
    }

    private static BigDecimal getBigDecimalVal(Object val) {
        if (val == null) {
            return BigDecimal.ZERO;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val instanceof String && StringUtils.isBlank((Object)val)) {
            return BigDecimal.ZERO;
        }
        try {
            return new BigDecimal(String.valueOf(val));
        }
        catch (Exception e) {
            LOGGER.error("\u8f6cBigDecimal\u62a5\u9519", (Throwable)e);
            return BigDecimal.ZERO;
        }
    }

    private static Date getDate(String dateStr) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        return DateUtils.stringToDate((String)dateStr, (String)"yyyyMMdd");
    }

    private static String matchStatus(String invoiceStatus) {
        if ("0".equals(invoiceStatus)) {
            return invoiceStatus;
        }
        if ("2".equals(invoiceStatus)) {
            return "6";
        }
        if ("7".equals(invoiceStatus)) {
            return "2";
        }
        return "3";
    }

    private static String convertRIMInvoiceType(String type) {
        String inputType = null;
        switch (type) {
            case "1": {
                inputType = "026";
                break;
            }
            case "2": {
                inputType = "028";
                break;
            }
            case "3": {
                inputType = "007";
                break;
            }
            case "4": {
                inputType = "004";
                break;
            }
            case "5": {
                inputType = "025";
                break;
            }
            case "12": {
                inputType = "006";
                break;
            }
            case "15": {
                inputType = "026";
                break;
            }
            case "26": {
                inputType = InvoiceType.ALL_E_NORMAL.getTypeCode();
                break;
            }
            case "27": {
                inputType = InvoiceType.ALL_E_SPECIAL.getTypeCode();
            }
        }
        return inputType;
    }

    private DynamicObject[] queryInvoice(String invoiceCode, String invoiceNo, String invoiceType) {
        return BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])this.getFilter(invoiceCode, invoiceNo, invoiceType).toArray());
    }

    public DynamicObject fillInfoAndSave(BaseInvoice baseInvoice, String inputInvoiceType) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
        DynamicObject invoice = DynamicObjectUtil.bean2DynamicObject((Object)baseInvoice, (DynamicObject)object);
        invoice.set("buyertype", (Object)"9");
        invoice.set("systemsource", (Object)SYSTEM_SOURCE_INCOME_DOWNLOAD);
        invoice.set("billstatus", (Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode());
        invoice.set("downloadflag", (Object)"0");
        invoice.set("printflag", (Object)"0");
        invoice.set("createtime", (Object)new Date());
        invoice.set("orderno", (Object)UUID.next());
        invoice.set("billdate", (Object)new Date());
        invoice.set("issuebillstatus", (Object)BillStatusEnum.NO_APPROVAL_REQUIRED.getCode());
        invoice.set("ofdstatus", (Object)"0");
        invoice.set("issuestatus", (Object)"0");
        invoice.set("pushstatus", (Object)"4");
        invoice.set("uploadismcstatus", (Object)"2");
        InvoiceUtils.filterOneInvoiceIllegalItems((DynamicObject)invoice);
        IssueInvoiceService.setBlueInvoiceRemainRedAmount(invoice);
        IssueInvoiceService.updateDiscountInfo(invoice);
        this.setOriBlueInvoiceData(baseInvoice, invoice);
        LOGGER.info("inputInvoiceType:" + inputInvoiceType);
        if (TXF.equals(inputInvoiceType)) {
            LOGGER.info("\u901a\u884c\u8d39\u5904\u7406");
            this.updateBaseInvoiceInvoiceType(inputInvoiceType, invoice);
        } else {
            LOGGER.info("\u975e\u901a\u884c\u8d39\u5904\u7406");
            IssueInvoiceService.updateBaseInvoiceType(invoice);
        }
        return (DynamicObject)SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invoice})[0];
    }

    public void updateBaseInvoiceInvoiceType(String baseCode, DynamicObject invoice) {
        try {
            String id = CacheHelper.get((String)("imc_base_invoice_type_id_" + baseCode));
            if (id == null || StringUtils.isEmpty((CharSequence)id)) {
                QFilter qFilter = new QFilter("number", "=", (Object)baseCode);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_invoicetype", (String)"id", (QFilter[])qFilter.toArray());
                id = String.valueOf(dynamicObject.getPkValue());
                CacheHelper.put((String)("imc_base_invoice_type_id_" + baseCode), (String)id);
            }
            invoice.set("baseinvoicetype", (Object)Long.parseLong(id));
            LOGGER.info("updateBaseInvoiceInvoiceTypeNew\u901a\u884c\u8d39\u8bbe\u7f6e\u53d1\u7968\u7c7b\u578b");
        }
        catch (Exception exception) {
            // empty catch block
        }
        IssueInvoiceService.updateTaxOrg(invoice);
    }

    private void setOriBlueInvoiceData(BaseInvoice baseInvoice, DynamicObject invoice) {
        if ("1".equals(baseInvoice.getIssuetype()) && StringUtils.isBlank((CharSequence)baseInvoice.getOriginalinvoiceno())) {
            String remark = baseInvoice.getRemark();
            int i = remark.indexOf("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801:");
            if (-1 == i) {
                return;
            }
            int codeIndex = remark.indexOf("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u4ee3\u7801");
            int startIndex = codeIndex + 9;
            String invoiceCode = InvoiceAddServiceImpl.getNumStr(remark, startIndex);
            String invoiceNo = InvoiceAddServiceImpl.getNumStr(remark, startIndex + invoiceCode.length());
            invoice.set("originalinvoicecode", (Object)invoiceCode);
            invoice.set("originalinvoiceno", (Object)invoiceNo);
        }
    }

    private static String getNumStr(String source, int startIndex) {
        StringBuilder resultBuilder = new StringBuilder();
        boolean isStart = false;
        for (int i = 0; i < 100 && source.length() > startIndex; ++i) {
            char value;
            if ('0' <= (value = source.charAt(startIndex++)) && value <= '9') {
                isStart = true;
                resultBuilder.append(value);
                continue;
            }
            if (isStart) break;
        }
        return resultBuilder.toString();
    }

    public DynamicObject updateLocalInvoiceStatus(BaseInvoice baseInvoice) {
        QFilter filter = this.getFilter(baseInvoice.getInvoicecode(), baseInvoice.getInvoiceno(), baseInvoice.getInvoicetype());
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])filter.toArray());
        Date issueTime = invoice.getDate("issuetime");
        Date issueTimeNew = baseInvoice.getIssuetime();
        if (DateUtils.isNullOrStartOfDay((Date)issueTime) && !DateUtils.isNullOrStartOfDay((Date)issueTimeNew)) {
            invoice.set("issuetime", (Object)issueTimeNew);
        }
        if (InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype"))) {
            if ("3".equals(baseInvoice.getInvoicestatus())) {
                invoice.set("invoicestatus", (Object)baseInvoice.getInvoicestatus());
            }
            if ("2".equals(baseInvoice.getInvoicestatus()) && "1".equals(ImcConfigUtil.getValue((String)"updatePartRed", (String)"updatePartRed"))) {
                invoice.set("invoicestatus", (Object)baseInvoice.getInvoicestatus());
            }
        } else if ("6".equals(baseInvoice.getInvoicestatus())) {
            invoice.set("invoicestatus", (Object)baseInvoice.getInvoicestatus());
        }
        if ("0".equals(baseInvoice.getInvoicestatus()) && StringUtils.isNotBlank((CharSequence)baseInvoice.getOriginalinvoiceno())) {
            QFilter redfilter = new QFilter("salertaxno", "=", (Object)baseInvoice.getSalertaxno()).and("originalinvoicecode", "=", (Object)baseInvoice.getOriginalinvoicecode()).and("originalinvoiceno", "=", (Object)baseInvoice.getOriginalinvoiceno());
            DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"invoicestatus", (QFilter[])redfilter.toArray());
            if (blueInvoice != null) {
                blueInvoice.set("invoicestatus", (Object)"3");
                SaveServiceHelper.update((DynamicObject)blueInvoice);
            }
            invoice.set("invoicestatus", (Object)baseInvoice.getInvoicestatus());
        }
        IssueInvoiceService.updateTaxOrg(invoice);
        SaveServiceHelper.update((DynamicObject)invoice);
        return invoice;
    }

    public void saveBlueInvoiceStatus(DynamicObject invoice) {
        if (InvoiceStatus.isNormalInvIncludePartRed((String)invoice.getString("invoicestatus")) && IssueType.RED_INVOICE.getTypeCode().equals(invoice.getString("issuetype"))) {
            QFilter allFilter = this.getFilter(invoice.getString("originalinvoicecode"), invoice.getString("originalinvoiceno"), invoice.getString("invoicetype"));
            DynamicObject oriInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "invoicestatus", "totalamount"), (QFilter[])allFilter.toArray());
            if (oriInvoice == null) {
                return;
            }
            BigDecimal redTotalAmount = invoice.getBigDecimal("totalamount");
            BigDecimal blueTotalAmount = oriInvoice.getBigDecimal("totalamount");
            if (redTotalAmount.abs().compareTo(blueTotalAmount) == 0) {
                oriInvoice.set("invoicestatus", (Object)"3");
            }
            SaveServiceHelper.update((DynamicObject)oriInvoice);
        }
    }

    private QFilter getFilter(String invoiceCode, String invoiceNo, String invoiceType) {
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            return new QFilter("invoiceno", "=", (Object)invoiceNo);
        }
        return new QFilter("invoicecode", "=", (Object)invoiceCode).and("invoiceno", "=", (Object)invoiceNo);
    }

    public JSONObject addInvoiceFile(JSONObject inputJson) {
        JSONObject result = new JSONObject();
        if (null == inputJson) {
            result.put("errorCode", (Object)ErrorType.EMPTY_PARAM.getCode());
            result.put("description", (Object)ErrorType.EMPTY_PARAM.getName());
            return result;
        }
        LOGGER.info("InvoiceAddFile.addInvoiceFileJson:" + inputJson);
        boolean isNeedAfterFileCreate = false;
        try {
            String rpaBatchNo = inputJson.getString("batchNo");
            String invoiceNo = inputJson.getString("invoiceNo");
            QFilter filter = new QFilter("invoiceno", "=", (Object)invoiceNo);
            String fields = String.join((CharSequence)",", "ofdstatus", "snapshoturl", "fileurl", "xmlfileurl", "pdffileurl");
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)fields, (QFilter[])filter.toArray());
            if (invoices.length == 0) {
                result.put("errorCode", (Object)ErrorType.SUCCESS.getCode());
                result.put("description", (Object)ErrorType.SUCCESS.getName());
                return result;
            }
            DynamicObject invoice = invoices[0];
            String xmlFile = inputJson.getString("xmlFile");
            String ofdFile = inputJson.getString("ofdFile");
            String pdfFile = inputJson.getString("pdfFile");
            String snapshotFile = inputJson.getString("snapshotFile");
            if (StringUtils.isBlank((CharSequence)invoice.getString("fileurl")) && StringUtils.isNotBlank((CharSequence)ofdFile)) {
                invoice.set("fileurl", (Object)ofdFile);
            }
            if (StringUtils.isBlank((CharSequence)invoice.getString("xmlfileurl")) && StringUtils.isNotBlank((CharSequence)xmlFile)) {
                invoice.set("xmlfileurl", (Object)xmlFile);
            }
            if (StringUtils.isBlank((CharSequence)invoice.getString("pdffileurl")) && StringUtils.isNotBlank((CharSequence)pdfFile)) {
                invoice.set("pdffileurl", (Object)pdfFile);
            }
            if (StringUtils.isBlank((CharSequence)invoice.getString("snapshoturl")) && StringUtils.isNotBlank((CharSequence)snapshotFile)) {
                invoice.set("snapshoturl", (Object)snapshotFile);
            }
            if (StringUtils.isNotBlank((CharSequence)invoice.getString("fileurl"))) {
                invoice.set("ofdstatus", (Object)"1");
            }
            ImcSaveServiceHelper.save((DynamicObject[])invoices);
            QFilter filter1 = new QFilter("rpabatchno", "=", (Object)rpaBatchNo);
            DynamicObject[] logs = BusinessDataServiceHelper.load((String)"sim_imp_rim_file", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_imp_rim_file", (boolean)true), (QFilter[])filter1.toArray());
            if (logs.length > 0) {
                logs[0].set("rpasuccesssize", (Object)(logs[0].getInt("rpasuccesssize") + 1));
                ImcSaveServiceHelper.update((DynamicObject[])logs);
                String historyBillNo = logs[0].getString("impbatchno");
                DynamicObject[] historyObjs = BusinessDataServiceHelper.load((String)"sim_his_inv_data_import", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_his_inv_data_import", (boolean)true), (QFilter[])new QFilter("billno", "=", (Object)historyBillNo).toArray());
                QFilter allLogFilter = new QFilter("impbatchno", "=", (Object)historyBillNo);
                DynamicObject[] allImportLogs = BusinessDataServiceHelper.load((String)"sim_imp_rim_file", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_imp_rim_file", (boolean)true), (QFilter[])allLogFilter.toArray());
                this.updateHistoryExcuteStatus(historyObjs[0], allImportLogs);
                ImcSaveServiceHelper.save((DynamicObject[])historyObjs);
            }
            result.put("errorCode", (Object)ErrorType.SUCCESS.getCode());
            result.put("description", (Object)ErrorType.SUCCESS.getName());
        }
        catch (Exception e) {
            LOGGER.error("addInvoiceFileError:" + e.getMessage());
            result.put("errorCode", (Object)ErrorType.FAIL.getCode());
            result.put("description", (Object)e.getMessage());
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject updateRpaFailReason(JSONObject inputJson) {
        JSONObject result = new JSONObject();
        LOGGER.info("InvoiceAddFile.updateRpaFailReason:" + inputJson);
        if (null == inputJson) {
            result.put("errorCode", (Object)ErrorType.EMPTY_PARAM.getCode());
            result.put("description", (Object)ErrorType.EMPTY_PARAM.getName());
            return result;
        }
        try {
            String lockKey = "InvoiceAddServiceImpl.updateRpaFileFailReason";
            try (DLock lock = DLock.create((String)lockKey);
                 TXHandle tx = TX.requiresNew();){
                JSONObject oneReason;
                result.put("errorCode", (Object)ErrorType.SUCCESS.getCode());
                result.put("description", (Object)ErrorType.SUCCESS.getName());
                String batchNo = inputJson.getString("batchNo");
                JSONArray failReasons = inputJson.getJSONArray("failReasons");
                JSONArray newJsonArray = new JSONArray();
                for (Object failReason : failReasons) {
                    oneReason = new JSONObject();
                    oneReason.put("description", failReason);
                    newJsonArray.add((Object)oneReason);
                }
                failReasons = newJsonArray;
                QFilter filter = new QFilter("rpabatchno", "=", (Object)batchNo);
                DynamicObject[] importCountLogs = BusinessDataServiceHelper.load((String)"sim_imp_rim_file", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_imp_rim_file", (boolean)true), (QFilter[])filter.toArray());
                if (importCountLogs.length == 0) {
                    oneReason = result;
                    return oneReason;
                }
                String historyBillNo = importCountLogs[0].getString("impbatchno");
                String detailTaskNo = importCountLogs[0].getString("detailtaskno");
                DynamicObject[] importLog = BusinessDataServiceHelper.load((String)"sim_his_inv_data_import", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_his_inv_data_import", (boolean)true), (QFilter[])new QFilter("billno", "=", (Object)historyBillNo).toArray());
                if (importLog.length > 0) {
                    DynamicObjectCollection items = importLog[0].getDynamicObjectCollection("entryentity");
                    for (DynamicObject item : items) {
                        String detailBatchNo = item.getString("detailtaskno");
                        if (!Objects.equals(detailTaskNo, detailBatchNo)) continue;
                        this.addItemFailReasons(failReasons, item);
                        break;
                    }
                }
                ImcSaveServiceHelper.update((DynamicObject[])importLog);
                return result;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            result.put("errorCode", (Object)ErrorType.FAIL.getCode());
            result.put("description", (Object)e.getMessage());
        }
        return result;
    }

    public Set<String> addItemFailReasons(JSONArray failInvoices, DynamicObject item) {
        JSONArray jsonArray;
        HashSet<String> currentQueryFailReason = new HashSet<String>();
        if (null == failInvoices) {
            return currentQueryFailReason;
        }
        String oldFailReason = item.getString("detailfailreason_tag");
        HashSet<String> allFailReason = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)oldFailReason) && null != (jsonArray = JSONObject.parseArray((String)oldFailReason))) {
            allFailReason.addAll((Collection<String>)jsonArray);
        }
        for (Object failInvoice : failInvoices) {
            JSONObject json = (JSONObject)failInvoice;
            String description = json.getString("description");
            currentQueryFailReason.add(description);
            if (allFailReason.size() > 10) break;
            allFailReason.add(description);
        }
        item.set("detailfailreason_tag", (Object)JSONObject.toJSONString(allFailReason));
        item.set("detailfailreason", (Object)ErrorType.FAIL.getName());
        return currentQueryFailReason;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject updateBatchSuccessSize(JSONObject inputJson) {
        JSONObject result = new JSONObject();
        try {
            block42: {
                if (null == inputJson) {
                    result.put("errorCode", (Object)ErrorType.EMPTY_PARAM.getCode());
                    result.put("description", (Object)ErrorType.EMPTY_PARAM.getName());
                    return result;
                }
                String lockKey = "InvoiceAddServiceImpl.updateSimFileBatchSuccessSize";
                try (DLock lock = DLock.create((String)lockKey);
                     TXHandle tx = TX.requiresNew();){
                    LOGGER.info("InvoiceAddFile.updateBatchSuccessSizeParam:" + inputJson);
                    String batchNo = inputJson.getString("batchNo");
                    int successNum = inputJson.getInteger("successNum");
                    QFilter filter = new QFilter("rpabatchno", "=", (Object)batchNo);
                    DynamicObject[] importCountLogs = BusinessDataServiceHelper.load((String)"sim_imp_rim_file", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_imp_rim_file", (boolean)true), (QFilter[])filter.toArray());
                    if (importCountLogs.length <= 0) break block42;
                    int oldSuccessSize = importCountLogs[0].getInt("rpasuccesssize");
                    String importBatchNo = importCountLogs[0].getString("impbatchno");
                    String detailBatchNo = importCountLogs[0].getString("detailtaskno");
                    if (successNum < oldSuccessSize) {
                        result.put("errorCode", (Object)ErrorType.SUCCESS.getCode());
                        result.put("description", (Object)ErrorType.SUCCESS.getName());
                        JSONObject jSONObject = result;
                        return jSONObject;
                    }
                    importCountLogs[0].set("rpasuccesssize", (Object)successNum);
                    importCountLogs[0].set("finish", (Object)"1");
                    importCountLogs[0].set("rowcomplete", (Object)"1");
                    ImcSaveServiceHelper.update((DynamicObject[])importCountLogs);
                    if (!lock.tryLock(30000L)) {
                        result.put("errorCode", (Object)ErrorType.FAIL.getCode());
                        result.put("description", (Object)ResManager.loadKDString((String)"\u6709\u5176\u4ed6\u8bf7\u6c42\u6b63\u5728\u5199\u5165\u66f4\u65b0\u6761\u6570\uff0c\u672a\u83b7\u53d6\u5230\u9501\u5bfc\u81f4\u5931\u8d25", (String)"InvoiceAddServiceImpl_3", (String)"imc-sim-common", (Object[])new Object[0]));
                        JSONObject jSONObject = result;
                        return jSONObject;
                    }
                    DynamicObject[] historys = BusinessDataServiceHelper.load((String)"sim_his_inv_data_import", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_his_inv_data_import", (boolean)true), (QFilter[])new QFilter("billno", "=", (Object)importBatchNo).toArray());
                    if (historys.length > 0) {
                        QFilter allLogFilter = new QFilter("impbatchno", "=", (Object)importBatchNo);
                        DynamicObject[] allImportLogs = BusinessDataServiceHelper.load((String)"sim_imp_rim_file", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_imp_rim_file", (boolean)true), (QFilter[])allLogFilter.toArray());
                        this.updateHistoryExcuteStatus(historys[0], allImportLogs);
                        ImcSaveServiceHelper.save((DynamicObject[])allImportLogs);
                        ImcSaveServiceHelper.save((DynamicObject[])historys);
                    }
                }
            }
            result.put("errorCode", (Object)ErrorType.SUCCESS.getCode());
            result.put("description", (Object)ErrorType.SUCCESS.getName());
            return result;
        }
        catch (Exception e) {
            LOGGER.error("updateBatchSuccessSizeError:" + e.getMessage(), (Throwable)e);
            result.put("errorCode", (Object)ErrorType.FAIL.getCode());
            result.put("description", (Object)e.getMessage());
            return result;
        }
    }

    public void updateHistoryExcuteStatus(DynamicObject dynamicObject, DynamicObject[] allImportLogs) {
        DynamicObjectCollection items = dynamicObject.getDynamicObjectCollection("entryentity");
        boolean isAllSuccess = true;
        boolean isProcessing = false;
        boolean isAllFail = true;
        int countTotalNum = 0;
        int countSuccessNum = 0;
        for (DynamicObject item : items) {
            String detailTaskNo = item.getString("detailtaskno");
            boolean isAllInvokeRim = this.isCurrentRowAllFinish(item, allImportLogs, detailTaskNo);
            boolean isInvokeFail = this.isCurrentRowInvokeFail(item, allImportLogs, detailTaskNo);
            boolean currentRowComplete = this.isCurrentRowAllComplete(item, allImportLogs, detailTaskNo);
            int totalNum = item.getInt("detailtotalnum");
            countTotalNum += totalNum;
            int successNum = item.getInt("detailsuccessnum");
            countSuccessNum += successNum;
            if (isAllInvokeRim) {
                if (totalNum == successNum && !isInvokeFail) {
                    item.set("detailexecutionstatus", (Object)"4");
                } else if (successNum > 0 && currentRowComplete) {
                    item.set("detailexecutionstatus", (Object)"3");
                } else if (currentRowComplete) {
                    item.set("detailexecutionstatus", (Object)"5");
                } else {
                    item.set("detailexecutionstatus", (Object)"2");
                    isProcessing = true;
                }
                isAllSuccess = isAllSuccess && "4".equals(item.getString("detailexecutionstatus"));
                isAllFail = isAllFail && "5".equals(item.getString("detailexecutionstatus"));
            } else {
                isProcessing = true;
            }
            if (!"4".equals(item.get("detailexecutionstatus"))) continue;
            item.set("detailfailreason", null);
            item.set("detailfailreason_tag", null);
        }
        if (isProcessing) {
            dynamicObject.set("executionstatus", (Object)"2");
        } else if (isAllSuccess) {
            dynamicObject.set("executionstatus", (Object)"4");
        } else if (isAllFail) {
            dynamicObject.set("executionstatus", (Object)"5");
        } else {
            dynamicObject.set("executionstatus", (Object)"3");
        }
        dynamicObject.set("totalnum", (Object)countTotalNum);
        dynamicObject.set("successnum", (Object)countSuccessNum);
    }

    private boolean isCurrentRowInvokeFail(DynamicObject item, DynamicObject[] allImportLogs, String detailTaskNo) {
        if (allImportLogs.length == 0) {
            return false;
        }
        for (DynamicObject allImportLog : allImportLogs) {
            String logDetailTaskNo = allImportLog.getString("detailtaskno");
            String finishStatus = allImportLog.getString("finish");
            if (!Objects.equals(detailTaskNo, logDetailTaskNo) || !"2".equals(finishStatus)) continue;
            return true;
        }
        return false;
    }

    private boolean isCurrentRowAllComplete(DynamicObject item, DynamicObject[] allImportLogs, String detailTaskNo) {
        boolean isComplete = true;
        for (DynamicObject allImportLog : allImportLogs) {
            String logDetailTaskNo = allImportLog.getString("detailtaskno");
            String rowComplete = allImportLog.getString("rowcomplete");
            if (!Objects.equals(detailTaskNo, logDetailTaskNo) || "1".equals(rowComplete)) continue;
            isComplete = false;
        }
        return isComplete;
    }

    private boolean isCurrentRowAllFinish(DynamicObject item, DynamicObject[] allImportLogs, String detailTaskNo) {
        if (allImportLogs.length == 0) {
            return false;
        }
        int rowTotalNum = 0;
        int rowTotalSuccessNum = 0;
        boolean isFinished = false;
        for (DynamicObject allImportLog : allImportLogs) {
            String logDetailTaskNo = allImportLog.getString("detailtaskno");
            String finishStatus = allImportLog.getString("finish");
            if (!Objects.equals(detailTaskNo, logDetailTaskNo)) continue;
            if ("1".equals(finishStatus) || "2".equals(finishStatus)) {
                isFinished = true;
            }
            rowTotalNum += allImportLog.getInt("beforerpasize");
            rowTotalSuccessNum += allImportLog.getInt("rpasuccesssize");
        }
        item.set("detailtotalnum", (Object)rowTotalNum);
        item.set("detailsuccessnum", (Object)rowTotalSuccessNum);
        if (rowTotalSuccessNum > rowTotalNum) {
            item.set("detailsuccessnum", (Object)rowTotalNum);
        }
        return isFinished;
    }
}

