/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.ComponentInterfaceTypeEnum;
import kd.imc.bdm.common.constant.InvoiceFormsEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.dto.CallBackProcessVo;
import kd.imc.bdm.common.dto.ComponentRequest;
import kd.imc.bdm.common.dto.ComponentResponse;
import kd.imc.bdm.common.dto.InvoiceMatchVo;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.CallBackLogTypeEnum;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.enums.PushStatusEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BatchPushMailSettingHelper;
import kd.imc.bdm.common.helper.ComponentServiceHelper;
import kd.imc.bdm.common.helper.ConfigCacheHelper;
import kd.imc.bdm.common.helper.DeviceHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.InvTitleSettingHelper;
import kd.imc.bdm.common.helper.IssuePolicyHelper;
import kd.imc.bdm.common.helper.MsgSendAuthHelper;
import kd.imc.bdm.common.helper.RedConfirmHelper;
import kd.imc.bdm.common.helper.RelationHelper;
import kd.imc.bdm.common.helper.ThreadPoolsHelper;
import kd.imc.bdm.common.helper.callback.CallBackLogHelper;
import kd.imc.bdm.common.helper.callback.SendCallBackHelper;
import kd.imc.bdm.common.invoicecallback.impl.InvoiceCallBackServiceImpl;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceQueryUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.bdm.common.util.RequestUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.common.constant.RedConfirmStatusEnum;
import kd.imc.sim.common.dto.allele.AllEleFullInvoiceItemDTO;
import kd.imc.sim.common.dto.allele.AllEleFullInvoiceResponseDTO;
import kd.imc.sim.common.dto.vehicle.VehicleInvoiceIssueRequestDTO;
import kd.imc.sim.common.dto.vehicle.VehicleInvoiceIssueResponseDTO;
import kd.imc.sim.common.dto.vehicle.VehicleInvoiceTaxCodeDTO;
import kd.imc.sim.common.helper.AccountCheckHelper;
import kd.imc.sim.common.helper.BillHelper;
import kd.imc.sim.common.helper.InvoiceMailTimingHelper;
import kd.imc.sim.common.helper.IssueInvoiceFailHelper;
import kd.imc.sim.common.helper.allele.RpaInvoiceFileHelper;
import kd.imc.sim.common.helper.eim.EimInvoiceCallBackHelper;
import kd.imc.sim.common.helper.goodsinfo.GoodsInfoEditHelp;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.writeback.IssuedInvoiceWriteBackHelper;
import kd.imc.sim.common.model.invoice.IssueTypeEnum;
import kd.imc.sim.common.service.ImcPushInvoiceToIsmcService;
import kd.imc.sim.common.service.InvoiceCheckService;
import kd.imc.sim.common.service.WideInvoiceSevice;
import kd.imc.sim.common.service.issueinvoice.IIssueInvoice;
import kd.imc.sim.common.service.issueinvoice.IssueInvoiceFactory;
import kd.imc.sim.common.service.issueinvoice.impl.AllEleIssueInvoiceImpl;
import kd.imc.sim.common.utils.DeviceUtil;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

@SdkDeprecated
public class IssueInvoiceService {
    private static final Log LOG = LogFactory.getLog(IssueInvoiceService.class);

    public static MsgResponse doIssueInvoice(DynamicObject invoice) {
        return IssueInvoiceService.doIssueInvoice(invoice, true, null);
    }

    public static MsgResponse doIssueInvoice(DynamicObject invoice, boolean alleQuickQuery) {
        return IssueInvoiceService.doIssueInvoice(invoice, alleQuickQuery, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MsgResponse doIssueInvoice(DynamicObject invoice, boolean alleQuickQuery, DLock mqIssueLock) {
        MsgResponse response = new MsgResponse();
        String key = "imc_doIssueInvoice_" + invoice.getString("orderno");
        DLock lock = mqIssueLock == null ? DLock.create((String)key) : mqIssueLock;
        try {
            String msgException;
            boolean isAllE;
            LOG.info(String.format("\u5f00\u59cb\u5f00\u7968,\u8bbe\u5907\u7f16\u53f7%s,\u6d41\u6c34\u53f7%s", invoice.get("jqbh"), invoice.get("orderno")));
            if (mqIssueLock == null && !lock.tryLock()) {
                throw new MsgException(ResManager.loadKDString((String)"\u8be5\u53d1\u7968\u6b63\u5728\u5f00\u7968\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"IssueInvoiceService_0", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            boolean bl = isAllE = InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)invoice.getString("iselepaper"));
            if (!(isAllE && invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0 || StringUtils.isEmpty((String)(msgException = InvoiceCheckService.checkParams(invoice, true))))) {
                MsgResponse msgResponse = MsgResponse.valueOfError((String)"9999", (String)msgException);
                return msgResponse;
            }
            IssueInvoiceService.warpInvoiceDynamicObject(invoice);
            IssuePolicyHelper.makeIssuePolicy((DynamicObject)invoice);
            IIssueInvoice issueInvoice = IssueInvoiceFactory.getIssueInvoice((DynamicObject)invoice);
            response = issueInvoice.issue(invoice);
            IssueInvoiceService.handleIssueResponse(invoice, response);
        }
        catch (MsgException e) {
            LOG.error("IssueInvoiceServiceissueFailed_" + e.getErrorMsg(), (Throwable)e);
            response.setErrorMsg(e.getErrorMsg());
            response.setErrorCode("9999");
            CallbackHelperUtil.sendErrorCallbackMessage((String)e.getErrorMsg(), (DynamicObject)invoice, (String)OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode());
        }
        catch (Exception e) {
            LOG.error("IssueInvoiceServiceissueFailed_" + e.getMessage(), (Throwable)e);
            response.setErrorMsg(String.format(ResManager.loadKDString((String)"\u5f00\u7968\u5f02\u5e38! %s", (String)"IssueInvoiceService_1", (String)"imc-sim-common", (Object[])new Object[0]), GBKUtils.cutGBKString((String)e.getMessage(), (int)200)));
            response.setErrorCode("9999");
            CallbackHelperUtil.sendErrorCallbackMessage((String)e.getMessage(), (DynamicObject)invoice, (String)OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode());
        }
        finally {
            if (mqIssueLock == null) {
                lock.unlock();
            }
        }
        if (alleQuickQuery && ErrorType.SUBMITED.getCode().equals(response.getErrorCode())) {
            IssueInvoiceService.updateRedConfirmStatus(invoice);
            if (InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype"))) {
                try {
                    DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"AsyncIssueInvoiceQueryImpl", (String)"queryAsyncIssueResult", (Object[])new Object[]{invoice.getString("orderno")});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return response;
    }

    public static void warpInvoiceDynamicObject(DynamicObject invoiceDynamicObject) {
        if (StringUtils.isEmpty((String)invoiceDynamicObject.getString("issuesource")) && !InvoiceUtils.isAllEInvoice((Object)invoiceDynamicObject.getString("invoicetype")) && !AllEleAuthHelper.isElePaper((Object)invoiceDynamicObject.getString("iselepaper"))) {
            DynamicObject equipmentDynamicObject = EquipmentUtil.getEquipmentDynamicObjectByDevNo((String)invoiceDynamicObject.getString("jqbh"), (String)invoiceDynamicObject.getString("salertaxno"));
            if (equipmentDynamicObject == null) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u9500\u65b9\u7a0e\u53f7\u4e0d\u5b58\u5728\u8bbe\u5907\u7f16\u53f7%s", (String)"IssueInvoiceService_2", (String)"imc-sim-common", (Object[])new Object[0]), invoiceDynamicObject.getString("jqbh")));
            }
            invoiceDynamicObject.set("issuesource", equipmentDynamicObject.get("equipmenttype"));
        }
        if (IssueType.RED_INVOICE.getTypeCode().equals(invoiceDynamicObject.getString("issuetype"))) {
            QFilter qFilter = new QFilter("invoicecode", "=", (Object)invoiceDynamicObject.getString("originalinvoicecode"));
            qFilter.and("invoiceno", "=", (Object)invoiceDynamicObject.getString("originalinvoiceno"));
            DynamicObject blueObj = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id,bizcontroltype", (QFilter[])qFilter.toArray());
            if (blueObj != null && blueObj.getDynamicObject("bizcontroltype") != null) {
                invoiceDynamicObject.set("bizcontroltype", (Object)blueObj.getDynamicObject("bizcontroltype"));
            }
        }
        if (!InvoiceUtils.isAllEInvoice((Object)invoiceDynamicObject.getString("invoicetype"))) {
            invoiceDynamicObject.set("invoicecode", (Object)"");
            invoiceDynamicObject.set("invoiceno", (Object)"");
        }
        invoiceDynamicObject.set("uploadismcstatus", (Object)"0");
    }

    public static void handleIssueResponse(DynamicObject invoice, MsgResponse msgResponse) {
        String errorCode = msgResponse.getErrorCode();
        LOG.info(String.format("handleIssueResponse errorCode: %s", errorCode));
        if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(errorCode)) {
            IssueInvoiceService.handlerIssueSuccess(invoice, msgResponse);
        } else if (ErrorType.SUBMITED.getCode().equals(errorCode)) {
            invoice.set("issuestatus", (Object)IssueStatusEnum.underway.getCode());
            invoice.set("result", (Object)msgResponse.getErrorMsg());
            try {
                ImcSaveServiceHelper.save((DynamicObject)invoice);
            }
            catch (Exception e) {
                LOG.error(String.format("\u53d1\u7968\u5165\u5e93\u5931\u8d25\uff0c\u53d1\u7968\u6d41\u6c34\u53f7\u4e3a[%s]\uff0c\u53d1\u7968\u53f7\u7801\u4e3a[%s]", invoice.getString("orderno"), invoice.getString("invoiceno")), (Throwable)e);
                if (!"13".equals(invoice.getString("issuesource"))) {
                    throw e;
                }
                if (StringUtils.isBlank((String)invoice.getString("invoiceno"))) {
                    throw e;
                }
                LOG.info(String.format("\u53d1\u7968\u53f7\u7801[%s]\u4e50\u4f01\u5f00\u7968\u5165\u5e93\u5931\u8d25\uff0c\u8d4b\u7801\u4fdd\u7559", invoice.getString("invoiceno")));
            }
            DeleteServiceHelper.delete((String)"sim_fail_auto_issue", (QFilter[])new QFilter("orderno", "=", (Object)invoice.getString("orderno")).toArray());
        } else {
            CallbackHelperUtil.sendErrorCallbackMessage((String)msgResponse.getErrorMsg(), (DynamicObject)invoice, (String)OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode());
            IssueInvoiceFailHelper.createFailAutoIssueRecord((DynamicObject)invoice, (String)msgResponse.getErrorMsg(), (String)errorCode);
        }
    }

    private static void updateRedConfirmStatus(DynamicObject invoiceDynamicObject) {
        long orgPk;
        QFilter filter;
        DynamicObject[] array;
        String invoiceType;
        String issueType = invoiceDynamicObject.getString("issuetype");
        if (!InvoiceUtils.isRedConfirmInvoice((String)issueType, (String)(invoiceType = invoiceDynamicObject.getString("invoicetype")))) {
            return;
        }
        String infoCode = invoiceDynamicObject.getString("infocode");
        if (StringUtils.isNotEmpty((String)infoCode) && (array = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)"issuestatus", (QFilter[])(filter = ImcBaseDataHelper.getRedConfirmFilter((Object)(orgPk = DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceDynamicObject.get("orgid")))).and("number", "=", (Object)infoCode)).toArray())).length > 0) {
            array[0].set("issuestatus", (Object)IssueStatusEnum.underway.getCode());
            ImcSaveServiceHelper.save((DynamicObject)array[0]);
        }
    }

    private static void handlerVehicleIssueResult(DynamicObject invoice) {
        if (!InvoiceUtils.isAllEVehicleInv((String)invoice.getString("invoicetype")) && !InvoiceUtils.isUsedCarInvoice((Object)invoice.getString("invoicetype"))) {
            return;
        }
        if (IssueStatusEnum.ok.getCode().equals(invoice.getString("issuestatus"))) {
            if (IssueType.RED_INVOICE.getTypeCode().equals(invoice.getString("issuetype"))) {
                QFilter qFilter = new QFilter("invoicecode", "=", (Object)invoice.getString("originalinvoicecode"));
                qFilter.and("invoiceno", "=", (Object)invoice.getString("originalinvoiceno"));
                DynamicObject blueVehicle = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice_vehicles", (String)"id,invoicestatus", (QFilter[])qFilter.toArray());
                blueVehicle.set("invoicestatus", (Object)"3");
                ImcSaveServiceHelper.save((DynamicObject)blueVehicle);
                qFilter = new QFilter("originalinvoicecode", "=", (Object)invoice.getString("originalinvoicecode"));
                qFilter.and("originalinvoiceno", "=", (Object)invoice.getString("originalinvoiceno"));
                DynamicObject redConfirm = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)"id,issuestatus,invoiceno,failreason,issuetime", (QFilter[])qFilter.toArray());
                if (redConfirm != null) {
                    redConfirm.set("issuestatus", (Object)"0");
                    redConfirm.set("invoiceno", invoice.get("invoiceno"));
                    redConfirm.set("failreason", (Object)"");
                    redConfirm.set("issuetime", invoice.get("issuetime"));
                    ImcSaveServiceHelper.save((DynamicObject)redConfirm);
                }
            }
            LOG.info("pushStatus:" + invoice.get("pushstatus"));
            if (InvoiceUtils.isAllEVehicleOrAllEUsedCar((String)invoice.getString("invoicetype")) && PushStatusEnum.underway.getCode().equals(invoice.get("pushstatus"))) {
                DynamicObject pushMailStrategy = BatchPushMailSettingHelper.matchBatchPushMailSetting((DynamicObject)invoice);
                InvoiceMailTimingHelper.sendSmsOrEmail(invoice, pushMailStrategy);
            }
            if ("1".equals(invoice.getString("ofdstatus")) || InvoiceType.ALL_E_VEHICLE_NORMAL.getTypeCode().equals(invoice.getString("invoicetype")) || InvoiceType.ALL_E_PAPER_USED_CAR.getTypeCode().equals(invoice.getString("invoicetype"))) {
                CallbackHelperUtil.sendVehicleCallbackMessage((DynamicObject)invoice, (String)invoice.getString("systemsource"), (String)OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode());
            }
        }
        if (IssueStatusEnum.failed.getCode().equals(invoice.getString("issuestatus")) && StringUtils.isNotEmpty((String)invoice.getString("systemsource"))) {
            if ("0".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.SIM_ERROR_CALLBACK))) {
                return;
            }
            CallbackHelperUtil.sendVehicleCallbackMessage((DynamicObject)invoice, (String)invoice.getString("systemsource"), (String)OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode(), (String)CallBackLogTypeEnum.invoiceError.getValue());
        }
    }

    public static MsgResponse handlerIssueSuccess(DynamicObject invoiceDynamicObject, MsgResponse msgResponse) {
        JSONObject responseJson = JSON.parseObject((String)msgResponse.getRespData());
        IssueInvoiceService.fillPreFileUrl(invoiceDynamicObject, responseJson, msgResponse);
        String invoiceCode = responseJson.getString("invoicecode");
        String invoiceNo = responseJson.getString("invoiceno");
        IssueInvoiceService.deleteIncomeDownloadInvoice(invoiceCode, invoiceNo);
        boolean invoiceExists = InvoiceCheckService.checkInvoiceExists(invoiceCode, invoiceNo);
        if (invoiceExists) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u6d41\u6c34\u53f7\uff1a[%s]\u53d1\u7968\u4ee3\u7801\uff1a[%s],\u53d1\u7968\u53f7\u7801\uff1a[%s]\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u66f4\u65b0\u53d1\u7968\u72b6\u6001", invoiceDynamicObject.getString("orderno"), responseJson.getString("invoicecode"), responseJson.getString("invoiceno")));
            }
            msgResponse.setErrorCode(ErrorType.SUCCESS.getCode());
            invoiceDynamicObject.set("invoicecode", (Object)responseJson.getString("invoicecode"));
            invoiceDynamicObject.set("invoiceno", (Object)responseJson.getString("invoiceno"));
            invoiceDynamicObject.set("alletaxinvoiceno", (Object)responseJson.getString("alletaxinvoiceno"));
            invoiceDynamicObject.set("invoicestatus", (Object)"0");
            invoiceDynamicObject.set("result", (Object)"");
            invoiceDynamicObject.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
            String fileUrl = responseJson.getString("fileurl");
            if (StringUtils.isBlank((String)invoiceDynamicObject.getString("fileurl")) && StringUtils.isNotEmpty((String)fileUrl)) {
                invoiceDynamicObject.set("fileurl", (Object)fileUrl);
            }
            DeleteServiceHelper.delete((String)"sim_fail_auto_issue", (QFilter[])new QFilter("orderno", "=", (Object)invoiceDynamicObject.getString("orderno")).toArray());
            RequestContext context = RequestContext.get();
            ThreadPoolsHelper.invokeRimSaveInvoiceThreadPool.execute(() -> {
                RequestContext.copyAndSet((RequestContext)context);
                IssueInvoiceService.invokeRimSaveInvoice(invoiceDynamicObject);
            });
            ImcSaveServiceHelper.save((DynamicObject)invoiceDynamicObject);
            return msgResponse;
        }
        IssueInvoiceService.beforeSaveInvoiceOperation(invoiceDynamicObject, responseJson);
        IssueInvoiceService.saveInvoice(invoiceDynamicObject);
        IssueInvoiceService.afterSaveInvoiceOperation(invoiceDynamicObject);
        return msgResponse;
    }

    public static void deleteIncomeDownloadInvoice(String invoiceCode, String invoiceNo) {
        QFilter invoiceFilter = InvoiceQFilterUtil.getInvoiceByCodeAndNo(invoiceCode, invoiceNo).and("buyertype", "in", (Object)new String[]{"9", "2", "10", "8"});
        DynamicObject invoice = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)"buyertype", (QFilter[])invoiceFilter.toArray());
        if (invoice != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("\u6570\u636e\u5e93\u5df2\u5b58\u5728\u6765\u6e90\u4e3a[%s]\uff0c\u53d1\u7968\u4ee3\u7801[%s]\uff0c\u53d1\u7968\u53f7\u7801\u4e3a[%s]\u7684\u53d1\u7968\uff0c\u6267\u884c\u5220\u9664", invoice.getString("buyertype"), invoiceCode, invoiceNo));
            }
            DeleteServiceHelper.delete((String)"sim_vatinvoice", (QFilter[])invoiceFilter.toArray());
        }
    }

    public static void invokeRimSaveInvoice(DynamicObject invoice) {
        try {
            String buyerTaxNo = invoice.getString("buyertaxno");
            if (StringUtils.isEmpty((String)buyerTaxNo)) {
                return;
            }
            QFilter qFilter = new QFilter("epinfo.number", "=", (Object)buyerTaxNo).and("enterprisemainorg", "=", (Object)"1");
            DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"", (QFilter[])qFilter.toArray());
            if (org == null) {
                return;
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("buyerOrgId", org.getPkValue());
            param.put("serialNo", invoice.getString("orderno"));
            if (LOG.isInfoEnabled()) {
                LOG.info("\u8c03\u7528rim\u4fdd\u5b58\u53d1\u7968\u4f20\u53c2\uff1a" + SerializationUtils.toJsonString(param));
            }
            Map response = (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"syncSimInvoice", (Object[])new Object[]{param});
            if (LOG.isInfoEnabled()) {
                LOG.info("\u8c03\u7528rim\u4fdd\u5b58\u53d1\u7968\u8fd4\u56de\uff1a" + SerializationUtils.toJsonString((Object)response));
            }
        }
        catch (Exception e) {
            LOG.error("\u8c03\u7528rim\u4fdd\u5b58\u53d1\u7968\u62a5\u9519", (Throwable)e);
        }
    }

    public static void fillPreFileUrl(DynamicObject invoice, JSONObject responseJson, MsgResponse response) {
        String fileUrl = responseJson.getString("fileurl");
        if (StringUtils.isNotEmpty((String)fileUrl) || "1".equals(invoice.getString("ofdstatus"))) {
            return;
        }
        String invoiceType = invoice.getString("invoicetype");
        if (InvoiceUtils.isEtcInvoice((String)invoiceType) && !InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            JSONObject prePdfJSONObject;
            String signType = IssueInvoiceService.fetchPdfNeedCreateFromISMC();
            String issueSource = invoice.getString("issuesource");
            if (!("3".equals(issueSource) || DeviceHelper.isOfdDevice((String)invoice.getString("issuesource")) || "1".equals(signType) || (prePdfJSONObject = IssueInvoiceService.fetchPreFileUrlFromISMC(invoice)) == null)) {
                invoice.set("fileurl", (Object)prePdfJSONObject.getString("fileurl"));
                invoice.set("snapshoturl", (Object)prePdfJSONObject.getString("snapshoturl"));
                responseJson.put("fileurl", (Object)prePdfJSONObject.getString("fileurl"));
                response.setRespData(SerializationUtils.toJsonString((Object)responseJson));
            }
        } else if (StringUtils.isBlank((String)CacheHelper.get((String)"paperNeedPdf")) && InvoiceUtils.isPaperInvoice((String)invoiceType)) {
            try {
                HashMap reqMap = new HashMap();
                MsgResponse msgResponse = RequestUtils.doRequest((String)UUID.next(), (String)"FetchSignType", reqMap);
                if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
                    String respData = msgResponse.getRespData();
                    JSONObject jsonObject = JSONObject.parseObject((String)respData);
                    CacheHelper.put((String)"paperNeedPdf", (String)jsonObject.getString("paperNeedPdf"), (int)3600);
                }
            }
            catch (Exception e) {
                LOG.info(String.format("fetchPaperCreateFail:%s", e.getMessage()), (Object)e);
            }
        }
    }

    public static JSONObject fetchPreFileUrlFromISMC(DynamicObject invoiceDynamicObject) {
        HashMap<String, String> reqMap = new HashMap<String, String>();
        try {
            String envType = ImcConfigUtil.getValue((String)"dim_imc_pdfurl_env", (String)"dim_imc_pdfurl_env_pro");
            if (StringUtils.isEmpty((String)envType)) {
                envType = "1";
            }
            reqMap.put("orderno", invoiceDynamicObject.getString("orderno"));
            reqMap.put("salertaxno", invoiceDynamicObject.getString("salertaxno"));
            reqMap.put("issuetime", DateUtils.format((Date)invoiceDynamicObject.getDate("issuetime"), (String)"yyyyMMdd"));
            reqMap.put("issuesource", invoiceDynamicObject.getString("issuesource"));
            reqMap.put("envtype", envType);
            MsgResponse msgResponse = RequestUtils.doRequest((String)UUID.next(), (String)"FetchPrePdfUrl", reqMap);
            if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
                return JSONObject.parseObject((String)msgResponse.getRespData());
            }
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6\u7a0e\u63a7\u7cfb\u7edf\u4e91\u9884\u751f\u6210pdf\u5730\u5740\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    private static void beforeSaveInvoiceOperation(DynamicObject invoiceDynamicObject, JSONObject responseJson) {
        IssueInvoiceService.updateInvoiceDB(invoiceDynamicObject, responseJson);
        IssueInvoiceService.updateInvoiceInvalidApproval(invoiceDynamicObject);
        IssueInvoiceService.setPaperInvoiceSheet(invoiceDynamicObject, responseJson);
        IssueInvoiceService.updateBaseInvoiceType(invoiceDynamicObject);
    }

    @SdkDeprecated
    public static void updateBaseInvoiceType(DynamicObject invoiceDynamicObject) {
        try {
            String baseCode = InvoiceType.getBaseCodeByInvoiceTypeCode((String)invoiceDynamicObject.getString("invoicetype"));
            String id = CacheHelper.get((String)("imc_base_invoice_type_id_" + baseCode));
            if (id == null || StringUtils.isEmpty((String)id)) {
                QFilter qFilter = new QFilter("number", "=", (Object)baseCode);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_invoicetype", (String)"id", (QFilter[])qFilter.toArray());
                id = String.valueOf(dynamicObject.getPkValue());
                CacheHelper.put((String)("imc_base_invoice_type_id_" + baseCode), (String)id);
            }
            invoiceDynamicObject.set("baseinvoicetype", (Object)Long.parseLong(id));
        }
        catch (Exception exception) {
            // empty catch block
        }
        IssueInvoiceService.updateTaxOrg(invoiceDynamicObject);
    }

    public static Long getBaseInvoiceType(String invoiceType) {
        try {
            String baseCode = InvoiceType.getBaseCodeByInvoiceTypeCode((String)invoiceType);
            String id = CacheHelper.get((String)("imc_base_invoice_type_id_" + baseCode));
            if (id == null || StringUtils.isEmpty((String)id)) {
                QFilter qFilter = new QFilter("number", "=", (Object)baseCode);
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bd_invoicetype", (String)"id", (QFilter[])qFilter.toArray());
                id = String.valueOf(dynamicObject.getPkValue());
                CacheHelper.put((String)("imc_base_invoice_type_id_" + baseCode), (String)id);
            }
            return Long.parseLong(id);
        }
        catch (Exception ignore) {
            LOG.error("getBaseInvoiceType", (Throwable)ignore);
            return 0L;
        }
    }

    public static void updateTaxOrg(DynamicObject dynamicObject) {
        try {
            QFilter qFilter = new QFilter("unifiedsocialcode", "=", (Object)dynamicObject.getString("salertaxno"));
            DynamicObject taxMain = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"org", (QFilter[])qFilter.toArray());
            if (taxMain != null) {
                dynamicObject.set("taxorg", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)taxMain.get("org")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Long getTaxOrgLongValue(String salerTaxNo) {
        try {
            QFilter qFilter = new QFilter("unifiedsocialcode", "=", (Object)salerTaxNo);
            DynamicObject taxMain = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"org", (QFilter[])qFilter.toArray());
            if (taxMain != null) {
                return DynamicObjectUtil.getDynamicObjectLongValue((Object)taxMain.get("org"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    public static void saveInvoice(DynamicObject invoiceDynamicObject) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                IssueInvoiceService.setRemainRedAmount(invoiceDynamicObject);
                IssueInvoiceService.setBlueInvoiceRemainDiscountAmount(invoiceDynamicObject);
                IssueInvoiceService.setInvoiceNo2Red(invoiceDynamicObject);
                ImcSaveServiceHelper.save((DynamicObject)invoiceDynamicObject);
                WideInvoiceSevice.addInvoiceToWide(invoiceDynamicObject);
                String configValue = ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.BDM_PRE_CREATE_CALLBACK_LOG);
                if (!"1".equals(configValue)) {
                    IssueInvoiceService.preCreateCallBackLog(invoiceDynamicObject);
                }
                IssuePolicyHelper.updateLogIssueSuccess((DynamicObject)invoiceDynamicObject);
            }
            catch (Throwable t) {
                tx.markRollback();
                throw t;
            }
        }
        try {
            OperationServiceHelper.executeOperate((String)"afterissue", (String)"sim_vatinvoice", (DynamicObject[])new DynamicObject[]{invoiceDynamicObject}, null);
        }
        catch (Exception e) {
            LOG.error(String.format("\u6267\u884c\u5f00\u7968\u540e\u64cd\u4f5c\u5931\u8d25\uff0c\u6d41\u6c34\u53f7%s", invoiceDynamicObject.getString("orderno")), (Throwable)e);
        }
    }

    private static void setBlueInvoiceRemainDiscountAmount(DynamicObject invoice) {
        if (!"0".equals(invoice.getString("invoicestatus"))) {
            return;
        }
        String issueType = invoice.getString("issuetype");
        if (IssueType.RED_INVOICE.getTypeCode().equals(issueType)) {
            return;
        }
        DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
        boolean isFromIssue = IssueInvoiceService.isFromIssue(invoice);
        BigDecimal discountRate = IssueInvoiceService.getDiscountRate();
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype")) || "1".equals(invoice.getString("iselepaper"));
        for (int i = 0; i < items.size(); ++i) {
            DynamicObject item = (DynamicObject)items.get(i);
            BigDecimal amount = item.getBigDecimal("amount");
            BigDecimal totalRemainDiscountAmount = amount.multiply(discountRate).setScale(2, RoundingMode.HALF_UP);
            BigDecimal remainRedAmount = item.getBigDecimal("itemremainredamount");
            BigDecimal remainNum = item.getBigDecimal("itemremainrednum");
            boolean numIsNotZero = !BigDecimalUtil.compareZero((BigDecimal)remainNum);
            BigDecimal price = item.getBigDecimal("unitprice");
            String rowType = item.getString("rowtype");
            if (isFromIssue) {
                if ("2".equals(rowType) && numIsNotZero) {
                    item.set("redprice", (Object)PriceHelper.calcPriceOrNum(remainRedAmount, remainNum, isAllEle));
                } else if ("0".equals(rowType)) {
                    item.set("redprice", item.get("unitprice"));
                }
            } else if ("2".equals(rowType) && numIsNotZero) {
                item.set("redprice", (Object)PriceHelper.calcPriceOrNum(remainRedAmount, remainNum, isAllEle));
            } else if ("0".equals(rowType)) {
                if (amount.compareTo(remainRedAmount) == 0) {
                    item.set("redprice", item.get("unitprice"));
                } else if (BigDecimalUtil.compareZero((BigDecimal)price)) {
                    item.set("redprice", (Object)BigDecimal.ZERO);
                } else {
                    BigDecimal differ = remainNum.multiply(price).setScale(2, RoundingMode.HALF_UP).subtract(remainRedAmount).abs();
                    if (differ.compareTo(BigDecimalUtil.POINT_ZERO_ONE) < 0) {
                        item.set("redprice", item.get("unitprice"));
                    } else if (numIsNotZero) {
                        item.set("redprice", (Object)PriceHelper.calcPriceOrNum(remainRedAmount, remainNum, isAllEle));
                    }
                }
            }
            if ("1".equals(rowType)) {
                DynamicObject lastRow = (DynamicObject)items.get(i - 1);
                BigDecimal lastRowRemainDisCountAmount = lastRow.getBigDecimal("remaindiscountamount");
                lastRow.set("remaindiscountamount", (Object)lastRowRemainDisCountAmount.add(amount).setScale(2, RoundingMode.HALF_UP));
                lastRow.set("discountedamount", (Object)amount.abs());
                continue;
            }
            item.set("remaindiscountamount", (Object)totalRemainDiscountAmount);
            item.set("discountedamount", (Object)BigDecimal.ZERO);
        }
    }

    public static BigDecimal getDiscountRate() {
        BigDecimal discountRate = BigDecimal.ONE;
        String discountRateStr = ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.INVOICE_DISCOUNT_RATE);
        if (StringUtils.isNotEmpty((String)discountRateStr)) {
            try {
                discountRate = new BigDecimal(discountRateStr);
                if (discountRate.compareTo(BigDecimal.ONE) > 0 || BigDecimal.ZERO.compareTo(discountRate) > 0) {
                    return BigDecimal.ONE;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return discountRate;
    }

    private static boolean isFromIssue(DynamicObject invoice) {
        String buyerType = invoice.getString("buyertype");
        String value = ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.INVOICE_NOT_FROM_ISSUE_BUYERTYPE);
        Set<Object> buyerTypeSet = new HashSet();
        Collections.addAll(buyerTypeSet, "9", "10");
        if (StringUtils.isNotEmpty((String)value)) {
            try {
                buyerTypeSet = Arrays.stream(value.split(",")).collect(Collectors.toSet());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return !"8".equals(buyerType) && !"2".equals(buyerType) && !buyerTypeSet.contains(buyerType);
    }

    private static void preCreateCallBackLog(DynamicObject invoice) {
        if (!CallbackHelperUtil.isNeedCallBack((DynamicObject)invoice)) {
            return;
        }
        String systemSourceCallbackType = ConfigCacheHelper.getCacheValue((String)"sim_system_source_callback_type");
        if (!CallbackHelperUtil.isIssuedCallBack((DynamicObject)invoice, (String)systemSourceCallbackType) && !"1".equals(invoice.getString("ofdstatus"))) {
            return;
        }
        String systemSource = invoice.getString("systemsource");
        if (StringUtils.isBlank((String)systemSource) && "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.INVOICE_SYSTEMSOURCE_FROM_BUYER_RED_INFO))) {
            systemSource = RelationHelper.getSystemSourceFromBuyerDownloadRedInfo((DynamicObject)invoice);
        }
        if (StringUtils.isBlank((String)systemSource)) {
            return;
        }
        String businessType = OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode();
        if (CallbackHelperUtil.isFromArIssueBill((String)systemSource)) {
            InvoiceMatchVo matchVo = RelationHelper.getInvoiceMatchVo((DynamicObject)invoice);
            if (matchVo.isFromRedMatchBill()) {
                return;
            }
            if (!CallbackHelperUtil.isAllInv((DynamicObject)invoice)) {
                return;
            }
            CallBackProcessVo vo = new CallBackProcessVo(invoice, systemSource, businessType, "\u5e94\u6536\u5f00\u7968\u5355");
            CallBackLogHelper.addCallbackLog((CallBackProcessVo)vo);
            return;
        }
        DynamicObject callBackConfig = BusinessDataServiceHelper.loadSingle((String)"invsm_callback_config", (String)"url", (QFilter[])new QFilter("business_system_code", "=", (Object)systemSource).toArray());
        if (callBackConfig != null) {
            CallBackProcessVo vo = new CallBackProcessVo(invoice, systemSource, businessType, "EAS\u63a8\u5355");
            CallBackLogHelper.addCallbackLog((CallBackProcessVo)vo);
            return;
        }
        List urlList = new ArrayList<String>(4);
        if ("XKQJ".equals(systemSource)) {
            urlList.add("\u661f\u7a7a\u65d7\u8230\u7248");
        } else {
            urlList = CallbackHelperUtil.getCallBackUrlList((String)systemSource);
        }
        if (urlList == null) {
            return;
        }
        for (String callbackUrl : urlList) {
            if (String.valueOf(systemSource).startsWith("3std1")) {
                DynamicObject[] relationObjs = RelationHelper.getRelationByInvoice((DynamicObject)invoice);
                if (relationObjs.length > 0) {
                    SendCallBackHelper.addBillCallBackLog((DynamicObject)invoice, (String)businessType, (String)callbackUrl, null, (DynamicObject)relationObjs[0]);
                    continue;
                }
                CallBackProcessVo vo = new CallBackProcessVo(invoice, invoice.getString("systemsource"), businessType, callbackUrl);
                CallBackLogHelper.addCallbackLog((CallBackProcessVo)vo);
                continue;
            }
            CallBackProcessVo vo = new CallBackProcessVo(invoice, systemSource, businessType, callbackUrl);
            CallBackLogHelper.addCallbackLog((CallBackProcessVo)vo);
        }
    }

    private static void setInvoiceNo2Red(DynamicObject invoice) {
        if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) > 0) {
            return;
        }
        String invoiceType = invoice.getString("invoicetype");
        if (InvoiceUtils.isSpecialInvoice((String)invoiceType) && !AllEleAuthHelper.isElePaper((Object)invoice.getString("iselepaper"))) {
            DynamicObject[] redInfoFromDBArr = BusinessDataServiceHelper.load((String)"sim_red_info", (String)String.join((CharSequence)",", "invoicecode", "invoiceno", "status", "issuetime"), (QFilter[])new QFilter("infocode", "=", invoice.get("infocode")).toArray());
            if (redInfoFromDBArr.length != 0) {
                for (DynamicObject redInfoFromDB : redInfoFromDBArr) {
                    redInfoFromDB.set("invoicecode", invoice.get("invoicecode"));
                    redInfoFromDB.set("invoiceno", invoice.get("invoiceno"));
                    redInfoFromDB.set("status", (Object)"4");
                    redInfoFromDB.set("issuetime", invoice.get("issuetime"));
                }
                ImcSaveServiceHelper.update((DynamicObject[])redInfoFromDBArr);
            }
        } else if (InvoiceUtils.isAllEInvoice((Object)invoiceType) || AllEleAuthHelper.isElePaper((Object)invoice.getString("iselepaper"))) {
            QFilter qFilter = StringUtils.isNotEmpty((String)invoice.getString("govuuid")) ? new QFilter("govuuid", "=", (Object)invoice.getString("govuuid")) : new QFilter("number", "=", (Object)invoice.getString("infocode"));
            DynamicObject[] redConfirmBills = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "issuetime", "invoiceno", "issuestatus", "invoicetype", "confirmstatus", "failreason", "remark"), (QFilter[])qFilter.toArray());
            if (redConfirmBills.length != 0) {
                for (DynamicObject redConfirmBill : redConfirmBills) {
                    redConfirmBill.set("invoiceno", invoice.get("invoiceno"));
                    redConfirmBill.set("failreason", (Object)"");
                    redConfirmBill.set("issuestatus", (Object)"0");
                    redConfirmBill.set("invoicetype", (Object)invoice.getString("invoicetype"));
                    redConfirmBill.set("issuetime", invoice.get("issuetime"));
                    if (RedConfirmStatusEnum.BUYER_CONFIRM.getBillCode().equals(redConfirmBill.getString("confirmstatus")) || RedConfirmStatusEnum.SELLER_CONFIRM.getBillCode().equals(redConfirmBill.getString("confirmstatus"))) {
                        redConfirmBill.set("confirmstatus", (Object)RedConfirmStatusEnum.ALL_CONFIRM.getBillCode());
                    }
                    redConfirmBill.set("remark", (Object)invoice.getString("remark"));
                }
                SaveServiceHelper.update((DynamicObject[])redConfirmBills);
            }
        }
    }

    public static void afterSaveInvoiceOperation(DynamicObject invoiceDynamicObject) {
        LOG.info("afterSaveInvoiceDB_" + invoiceDynamicObject.getString("orderno"));
        try {
            IssueInvoiceService.asyncBackTask(invoiceDynamicObject);
            IssueInvoiceService.writeBack2OriginalAndCallBack(invoiceDynamicObject);
            DeleteServiceHelper.delete((String)"sim_fail_auto_issue", (QFilter[])new QFilter("orderno", "=", (Object)invoiceDynamicObject.getString("orderno")).toArray());
            EimInvoiceCallBackHelper.callBackOrder((DynamicObject)invoiceDynamicObject);
            RpaInvoiceFileHelper.invokeRpaFileDown(invoiceDynamicObject);
        }
        catch (Exception e) {
            LOG.error("afterSaveInvoiceOperation_error ", (Throwable)e);
        }
    }

    private static void writeBack2OriginalAndCallBack(DynamicObject invoiceDynamicObject) {
        RequestContext context = RequestContext.get();
        ThreadPoolsHelper.issueEndWriteBackThreadPool.execute(() -> {
            try {
                RequestContext.copyAndSet((RequestContext)context);
                IssuedInvoiceWriteBackHelper.writeBackIssueAmount2OriginBill(invoiceDynamicObject);
                IssueInvoiceService.invokeRimSaveInvoice(invoiceDynamicObject);
                IssueInvoiceService.callBackApiOrFI(invoiceDynamicObject);
            }
            catch (Exception e) {
                LOG.error(String.format("writeBack2OriginalAndCallBack:%s", e.getMessage()), (Throwable)e);
            }
            catch (Throwable t) {
                LOG.error(String.format("writeBack2OriginalAndCallBack:%s", t.getMessage()), t);
                throw t;
            }
        });
    }

    public static void callBackApiOrFI(DynamicObject invoiceDynamicObject) {
        if (CallbackHelperUtil.isNeedCallBack((DynamicObject)invoiceDynamicObject) || "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.INVOICE_SYSTEMSOURCE_FROM_BUYER_RED_INFO))) {
            LOG.info(String.format("callBackApiOrFI orderNo:[%s],invoiceNo:[%s]invoiceDynamicObject:%s", invoiceDynamicObject.getString("orderno"), invoiceDynamicObject.getString("invoiceno"), SerializationUtils.toJsonString((Object)invoiceDynamicObject)));
            String systemSource = invoiceDynamicObject.getString("systemsource");
            if (StringUtils.isBlank((String)systemSource) && "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.INVOICE_SYSTEMSOURCE_FROM_BUYER_RED_INFO))) {
                systemSource = RelationHelper.getSystemSourceFromBuyerDownloadRedInfo((DynamicObject)invoiceDynamicObject);
            }
            if ("1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.VOLUME_INVOICE_CREATE_PDF)) && !"1".equals(invoiceDynamicObject.getString("ofdstatus")) && InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(invoiceDynamicObject.getString("invoicetype"))) {
                return;
            }
            String systemSourceCallbackType = ConfigCacheHelper.getCacheValue((String)"sim_system_source_callback_type");
            if (CallbackHelperUtil.isIssuedCallBack((DynamicObject)invoiceDynamicObject, (String)systemSourceCallbackType) || "1".equals(invoiceDynamicObject.getString("ofdstatus"))) {
                CallbackHelperUtil.sendCallbackMessage((DynamicObject)invoiceDynamicObject, (String)systemSource, (String)OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode());
            }
        }
    }

    public static void syncInvoiceCallback(DynamicObject invoice) {
        String systemSource = invoice.getString("systemsource");
        if (StringUtils.isBlank((String)systemSource)) {
            return;
        }
        if ("1".equals(ImcConfigUtil.getValue((String)"invsm_callback_log", (String)"clear"))) {
            Date issueTime = invoice.getDate("issuetime");
            if (issueTime == null) {
                return;
            }
            int day = 60;
            try {
                day = Integer.parseInt(ImcConfigUtil.getValue((String)"api_log", (String)"save_day"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (issueTime.before(DateUtils.addDay((Date)new Date(), (int)(-day - 30)))) {
                return;
            }
        }
        QFilter qFilter = new QFilter("business_type", "!=", (Object)OpenApiCallbackInterfaceCodeEnum.INVOICE_CANCEL.getCode()).and("org", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid"))).and("callbacktype", "not in", (Object)new String[]{CallBackLogTypeEnum.invoiceError.getValue(), CallBackLogTypeEnum.billError.getValue()});
        if (CallbackHelperUtil.isFromArIssueBill((String)systemSource)) {
            DynamicObject fiBillRelation = CallBackLogHelper.getFiBillRelation((DynamicObject)invoice);
            if (fiBillRelation == null) {
                return;
            }
            qFilter.and("business_fid", "=", (Object)fiBillRelation.getLong("sbillid"));
        } else if (systemSource.startsWith("3std1")) {
            DynamicObject[] relationObjs = RelationHelper.getRelationByInvoice((DynamicObject)invoice);
            if (relationObjs == null || relationObjs.length == 0) {
                return;
            }
            qFilter.and("business_fid", "=", (Object)relationObjs[0].getLong("sbillid"));
        } else {
            qFilter.and("business_fid", "=", invoice.getPkValue());
        }
        if (!QueryServiceHelper.exists((String)"invsm_callback_log", (QFilter[])qFilter.toArray())) {
            IssueInvoiceService.callBackApiOrFI(invoice);
        }
    }

    private static void asyncBackTask(DynamicObject invoiceDynamicObject) {
        RequestContext context = RequestContext.get();
        ThreadPoolsHelper.issueEndAsyncThreadPool.execute(() -> {
            RequestContext.copyAndSet((RequestContext)context);
            LOG.info(String.format("\u53d1\u7968\u53f7\u7801%s\u5f00\u59cb\u6267\u884c\u53d1\u7968\u5165\u5e93\u540e\u64cd\u4f5c", invoiceDynamicObject.getString("invoiceno")));
            try {
                boolean isRedMatchBill = "10".equals(invoiceDynamicObject.getString("contraststatus"));
                if ("1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.MATCH_RED_INV_SEND_MSG))) {
                    isRedMatchBill = false;
                }
                if (isRedMatchBill) {
                    invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.none.getCode());
                    ImcSaveServiceHelper.update((DynamicObject)invoiceDynamicObject);
                }
                LOG.info("pushStatus:" + invoiceDynamicObject.get("pushstatus"));
                if (InvoiceUtils.isAllEInvoice((Object)invoiceDynamicObject.getString("invoicetype")) && PushStatusEnum.underway.getCode().equals(invoiceDynamicObject.get("pushstatus")) && !isRedMatchBill) {
                    DynamicObject pushMailStrategy = BatchPushMailSettingHelper.matchBatchPushMailSetting((DynamicObject)invoiceDynamicObject);
                    InvoiceMailTimingHelper.sendSmsOrEmail(invoiceDynamicObject, pushMailStrategy);
                }
                IssueInvoiceService.updateInvalidInvoiceAlreadyIssue(invoiceDynamicObject);
                ImcPushInvoiceToIsmcService.componentInvoicePushToISMCRequest(invoiceDynamicObject, true);
                InvTitleSettingHelper.dealInvTitleBySetting((DynamicObject)invoiceDynamicObject);
                GoodsInfoEditHelp.dealGoodsInfoBySetting(invoiceDynamicObject);
                AccountCheckHelper.accountCheck((DynamicObject)invoiceDynamicObject);
            }
            catch (Throwable e) {
                LOG.error(String.format("\u53d1\u7968\u53f7\u7801%s\u6267\u884c\u53d1\u7968\u5165\u5e93\u540e\u64cd\u4f5c\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f[%s]", invoiceDynamicObject.getString("invoiceno"), e.getMessage()), e);
            }
        });
    }

    private static void updateInvoiceInvalidApproval(DynamicObject invoiceDynamicObject) {
        try {
            String billStatus = InvoiceUtils.isEtcInvoice((String)invoiceDynamicObject.getString("invoicetype")) ? BillStatusEnum.NO_APPROVAL_REQUIRED.getCode() : BillHelper.getBillStatusByTableName("sim_invoice_valid_list", invoiceDynamicObject.getString("buyertype"));
            invoiceDynamicObject.set("billstatus", (Object)billStatus);
        }
        catch (Exception e) {
            LOG.error("\u66f4\u65b0\u53d1\u7968\u4f5c\u5e9f\u5ba1\u6279\u72b6\u6001", (Throwable)e);
        }
    }

    private static void updateInvoiceDB(DynamicObject invoiceDynamicObject, JSONObject responseJson) {
        invoiceDynamicObject.set("invoicestatus", (Object)"0");
        invoiceDynamicObject.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
        invoiceDynamicObject.set("checkcode", responseJson.get((Object)"checkcode"));
        invoiceDynamicObject.set("createtime", (Object)new Date());
        String invoiceNo = responseJson.getString("invoiceno");
        String issueType = invoiceDynamicObject.getString("issuetype");
        if (IssueType.RED_INVOICE.getTypeCode().equals(issueType) && String.valueOf(invoiceNo).length() == 20 && AllEleAuthHelper.isElePaper((Object)invoiceDynamicObject.getString("iselepaper"))) {
            String invoiceType = invoiceDynamicObject.getString("invoicetype");
            if (InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode().equals(invoiceType)) {
                invoiceDynamicObject.set("invoicetype", (Object)InvoiceType.ALL_E_NORMAL.getTypeCode());
                invoiceDynamicObject.set("iselepaper", (Object)"0");
            }
            if (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType)) {
                invoiceDynamicObject.set("invoicetype", (Object)InvoiceType.ALL_E_SPECIAL.getTypeCode());
                invoiceDynamicObject.set("iselepaper", (Object)"0");
            }
        }
        if (InvoiceUtils.isAllEInvoice((Object)invoiceDynamicObject.getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)invoiceDynamicObject.getString("iselepaper"))) {
            invoiceDynamicObject.set("issuetime", (Object)DateUtils.stringToDate((String)responseJson.getString("issuetime"), (String)"yyyy-MM-dd HH:mm:ss"));
        } else {
            invoiceDynamicObject.set("issuetime", (Object)IssueInvoiceService.handleIssueTime(String.valueOf(responseJson.get((Object)"issuetime"))));
        }
        if (DynamicObjectUtil.checkDynamicObjectHasField((DynamicObject)invoiceDynamicObject, (String)"kptime")) {
            if (InvoiceUtils.isAllEInvoice((Object)invoiceDynamicObject.getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)invoiceDynamicObject.getString("iselepaper"))) {
                invoiceDynamicObject.set("kptime", invoiceDynamicObject.get("issuetime"));
            } else {
                invoiceDynamicObject.set("kptime", (Object)new Date());
            }
        }
        invoiceDynamicObject.set("invoicecode", responseJson.get((Object)"invoicecode"));
        invoiceDynamicObject.set("invoiceno", responseJson.get((Object)"invoiceno"));
        invoiceDynamicObject.set("skm", responseJson.get((Object)"skm"));
        if ("0".equals(invoiceDynamicObject.getString("issuesource"))) {
            invoiceDynamicObject.set("fileurl", responseJson.get((Object)"fileurl"));
            invoiceDynamicObject.set("snapshoturl", responseJson.get((Object)"snapshoturl"));
        }
        invoiceDynamicObject.set("result", (Object)"");
        IssueInvoiceService.warpPushStatus(invoiceDynamicObject);
        IssueInvoiceService.handleOfdStatus(invoiceDynamicObject);
        invoiceDynamicObject.set("downloadflag", (Object)"0");
        invoiceDynamicObject.set("printflag", (Object)"0");
        invoiceDynamicObject.set("reissuestatus", (Object)"0");
        IssueInvoiceService.reverseBuyerSellerByPurchase(invoiceDynamicObject);
    }

    private static void handleVehicleOfdStatus(DynamicObject invoice) {
        String ofdStatus = invoice.getString("ofdstatus");
        if (StringUtils.isEmpty((String)ofdStatus)) {
            invoice.set("ofdstatus", (Object)"0");
        }
        if (!InvoiceUtils.isAllEVehicleOrAllEUsedCar((String)invoice.getString("invoicetype"))) {
            invoice.set("ofdstatus", (Object)"3");
        }
        if (InvoiceUtils.isAllEVehicleOrAllEUsedCar((String)invoice.getString("invoicetype")) && StringUtils.isNotEmpty((String)invoice.getString("fileurl"))) {
            invoice.set("ofdstatus", (Object)"1");
        }
    }

    private static void handleOfdStatus(DynamicObject invoiceDynamicObject) {
        boolean isVolumnCreatePdf;
        String ofdStatus = invoiceDynamicObject.getString("ofdstatus");
        if (StringUtils.isEmpty((String)ofdStatus)) {
            invoiceDynamicObject.set("ofdstatus", (Object)"0");
        }
        if (InvoiceUtils.isPaperInvoice((String)invoiceDynamicObject.getString("invoicetype"))) {
            if ("1".equals(invoiceDynamicObject.getString("iselepaper"))) {
                invoiceDynamicObject.set("ofdstatus", (Object)"3");
            } else if (InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(invoiceDynamicObject.getString("invoicetype")) && "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.VOLUME_INVOICE_CREATE_PDF))) {
                invoiceDynamicObject.set("ofdstatus", (Object)"0");
            } else {
                String fileUrl = invoiceDynamicObject.getString("fileurl");
                if (StringUtils.isNotEmpty((String)fileUrl) && fileUrl.startsWith("http")) {
                    invoiceDynamicObject.set("ofdstatus", (Object)"1");
                } else if (!"1".equals(CacheHelper.get((String)"paperNeedPdf"))) {
                    invoiceDynamicObject.set("ofdstatus", (Object)"3");
                }
            }
        }
        if (InvoiceUtils.isAllEInvoice((Object)invoiceDynamicObject.getString("invoicetype")) && StringUtils.isNotEmpty((String)invoiceDynamicObject.getString("fileurl"))) {
            invoiceDynamicObject.set("ofdstatus", (Object)"1");
        }
        boolean bl = isVolumnCreatePdf = "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.VOLUME_INVOICE_CREATE_PDF)) && InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(invoiceDynamicObject.getString("invoicetype"));
        if (isVolumnCreatePdf) {
            invoiceDynamicObject.set("ofdstatus", (Object)"0");
        }
    }

    public static Date handleIssueTime(String issueTimeStr) {
        if (StringUtils.isBlank((String)issueTimeStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u4e3a\u7a7a", (String)"IssueInvoiceService_3", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        return DateUtils.handleDate((String)issueTimeStr);
    }

    public static void reverseBuyerSellerByPurchase(DynamicObject waitInvoice) {
        if ("02".equals(waitInvoice.getString("specialtype"))) {
            String buyerTaxNo = waitInvoice.getString("buyertaxno");
            String buyerName = waitInvoice.getString("buyername");
            String buyerAddr = waitInvoice.getString("buyeraddr");
            String buyerBank = waitInvoice.getString("buyerbank");
            waitInvoice.set("buyername", waitInvoice.get("salername"));
            waitInvoice.set("buyertaxno", waitInvoice.get("salertaxno"));
            waitInvoice.set("buyeraddr", waitInvoice.get("saleraddr"));
            waitInvoice.set("buyerbank", waitInvoice.get("salerbank"));
            waitInvoice.set("salername", (Object)buyerName);
            waitInvoice.set("salertaxno", (Object)buyerTaxNo);
            waitInvoice.set("saleraddr", (Object)buyerAddr);
            waitInvoice.set("salerbank", (Object)buyerBank);
        }
    }

    public static void warpVehiclePushStatus(DynamicObject invoiceDynamicObject) {
        String invoiceType = invoiceDynamicObject.getString("invoicetype");
        String invoiceNo = invoiceDynamicObject.getString("invoiceno");
        if (!InvoiceUtils.isAllEVehicleOrAllEUsedCar((String)invoiceType)) {
            invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.none.getCode());
            return;
        }
        if (!InvoiceCallBackServiceImpl.checkFileExists((Date)invoiceDynamicObject.getDate("issuetime"), (String)invoiceNo)) {
            invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.none.getCode());
            return;
        }
        if (!"1".equals(invoiceDynamicObject.getString("ofdstatus"))) {
            invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.none.getCode());
            return;
        }
        String fileUrl = invoiceDynamicObject.getString("fileurl");
        if (StringUtils.isBlank((String)fileUrl) || !fileUrl.startsWith("http")) {
            invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.none.getCode());
            return;
        }
        String notUploadS3 = ImcConfigUtil.getValue((String)"invoicefile_config", (String)"not_upload_s3");
        if ("notUploadS3".equals(notUploadS3)) {
            LOG.info(String.format("PushStatusPlace:%s,invoiceNo:%s,pushStatus:%s", 1, invoiceNo, invoiceDynamicObject.get("pushstatus")));
            invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.none.getCode());
            return;
        }
        boolean sendMsgAuth = MsgSendAuthHelper.msgSendAuthByOrgId((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceDynamicObject.get("orgid")));
        String email = invoiceDynamicObject.getString("buyeremail");
        String phone = "";
        int issueType = Integer.parseInt(invoiceDynamicObject.getString("issuetype"));
        if (IssueTypeEnum.red.getValue() == issueType) {
            if ("1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.RED_PUSH_SMS)) && (StringUtils.isNotEmpty((String)phone) && sendMsgAuth || StringUtils.isNotEmpty((String)email))) {
                invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.underway.getCode());
            }
            return;
        }
        if (StringUtils.isNotEmpty((String)email) || StringUtils.isNotEmpty((String)phone) && sendMsgAuth) {
            invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.underway.getCode());
        } else {
            invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.none.getCode());
        }
    }

    public static void warpPushStatus(DynamicObject invoiceDynamicObject) {
        String invoiceType = invoiceDynamicObject.getString("invoicetype");
        String invoiceNo = invoiceDynamicObject.getString("invoiceno");
        if (!InvoiceUtils.isEtcInvoice((String)invoiceType)) {
            boolean isContainsBuyerReceiveInfo;
            invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.none.getCode());
            boolean bl = isContainsBuyerReceiveInfo = StringUtils.isNotEmpty((String)invoiceDynamicObject.getString("buyeremail")) || StringUtils.isNotEmpty((String)invoiceDynamicObject.getString("buyerphone"));
            if (InvoiceUtils.isVolumeInvCreatePdf((DynamicObject)invoiceDynamicObject) && isContainsBuyerReceiveInfo) {
                invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.underway.getCode());
            }
            LOG.info(String.format("PushStatusPlace:%s,invoiceNo:%s,pushStatus:%s", 0, invoiceNo, invoiceDynamicObject.get("pushstatus")));
            return;
        }
        String notUploadS3 = ImcConfigUtil.getValue((String)"invoicefile_config", (String)"not_upload_s3");
        if ("notUploadS3".equals(notUploadS3)) {
            LOG.info(String.format("PushStatusPlace:%s,invoiceNo:%s,pushStatus:%s", 1, invoiceNo, invoiceDynamicObject.get("pushstatus")));
            invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.none.getCode());
            return;
        }
        int issueType = Integer.parseInt(invoiceDynamicObject.getString("issuetype"));
        if (IssueTypeEnum.red.getValue() == issueType && !"4".equals(invoiceDynamicObject.getString("buyertype"))) {
            invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.none.getCode());
            if ("1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.RED_PUSH_SMS))) {
                QFilter qFilter = InvoiceQueryUtil.getInvoiceByCodeAndNo((String)invoiceDynamicObject.getString("originalinvoicecode"), (String)invoiceDynamicObject.getString("originalinvoiceno"));
                DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id,buyeremail,buyerphone", (QFilter[])qFilter.toArray());
                if (blueInvoice != null && !InvoiceUtils.isRedConfirmInvoice((String)invoiceDynamicObject.getString("issuetype"), (String)invoiceDynamicObject.getString("invoicetype"))) {
                    invoiceDynamicObject.set("buyeremail", (Object)blueInvoice.getString("buyeremail"));
                    invoiceDynamicObject.set("buyerphone", (Object)blueInvoice.getString("buyerphone"));
                }
                invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.underway.getCode());
            }
            LOG.info(String.format("PushStatusPlace:%s,invoiceNo:%s,pushStatus:%s", 2, invoiceNo, invoiceDynamicObject.get("pushstatus")));
            return;
        }
        String email = invoiceDynamicObject.getString("buyeremail");
        String phone = invoiceDynamicObject.getString("buyerphone");
        if (StringUtils.isEmpty((String)email) && StringUtils.isEmpty((String)phone)) {
            invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.none.getCode());
            LOG.info(String.format("PushStatusPlace:%s,invoiceNo:%s,pushStatus:%s", 3, invoiceNo, invoiceDynamicObject.get("pushstatus")));
            return;
        }
        String fileUrl = invoiceDynamicObject.getString("fileurl");
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType) && StringUtils.isNotEmpty((String)fileUrl) && !fileUrl.startsWith("http")) {
            LOG.info(String.format("PushStatusPlace:%s,invoiceNo:%s,pushStatus:%s", 4, invoiceNo, invoiceDynamicObject.get("pushstatus")));
            invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.none.getCode());
            return;
        }
        boolean sendMsgAuth = MsgSendAuthHelper.msgSendAuthByOrgId((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoiceDynamicObject.get("orgid")));
        if (StringUtils.isNotEmpty((String)email) || StringUtils.isNotEmpty((String)phone) && sendMsgAuth) {
            if (!InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.underway.getCode());
                LOG.info(String.format("PushStatusPlace:%s,invoiceNo:%s,pushStatus:%s", 5, invoiceNo, invoiceDynamicObject.get("pushstatus")));
                return;
            }
            boolean isAllEleMockInvoice = StringUtils.isNotEmpty((String)ImcConfigUtil.getValue((String)"all_ele_mock_invoice", (String)invoiceDynamicObject.getString("salertaxno")));
            if (isAllEleMockInvoice || StringUtils.isNotEmpty((String)fileUrl)) {
                invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.underway.getCode());
                LOG.info(String.format("PushStatusPlace:%s,invoiceNo:%s,pushStatus:%s", 6, invoiceNo, invoiceDynamicObject.get("pushstatus")));
                return;
            }
        }
        invoiceDynamicObject.set("pushstatus", (Object)PushStatusEnum.none.getCode());
        LOG.info(String.format("PushStatusPlace:%s,invoiceNo:%s,pushStatus:%s", 7, invoiceNo, invoiceDynamicObject.get("pushstatus")));
    }

    private static void setPaperInvoiceSheet(DynamicObject invoiceDynamicObject, JSONObject json) {
        String desc = "-1";
        String invoiceType = String.valueOf(invoiceDynamicObject.get("invoicetype"));
        if (InvoiceUtils.isPaperInvoice((String)invoiceType) && StringUtils.isBlank((String)(desc = InvoiceUtils.getInvoiceFormsType((String)String.valueOf(json.get((Object)"invoicecode"))).getDesc()))) {
            desc = InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode().equals(invoiceType) ? InvoiceFormsEnum.TWOFORMS.getDesc() : (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType) ? InvoiceFormsEnum.THREEFORMS.getDesc() : "-1");
        }
        invoiceDynamicObject.set("invoicecopy", (Object)desc);
    }

    private static void updateInvalidInvoiceAlreadyIssue(DynamicObject invoiceObj) {
        String buyerType = invoiceObj.getString("buyertype");
        if ("5".equals(buyerType)) {
            String orderNo = invoiceObj.getString("orderno");
            QFilter qFilter = new QFilter("reorderno", "=", (Object)orderNo);
            DynamicObject originInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id,reissuestatus", (QFilter[])qFilter.toArray());
            originInvoice.set("reissuestatus", (Object)"1");
            ImcSaveServiceHelper.save((DynamicObject)originInvoice);
        }
    }

    public static void setRemainRedAmount(DynamicObject dynamicObject) {
        try {
            BigDecimal invoiceAmount = dynamicObject.getBigDecimal("invoiceamount").setScale(2, 4);
            if (invoiceAmount.compareTo(BigDecimal.ZERO) > 0) {
                IssueInvoiceService.setBlueInvoiceRemainRedAmount(dynamicObject);
                return;
            }
            IssueInvoiceService.setRedInvoiceZero(dynamicObject);
            String originalInvoiceCode = dynamicObject.getString("originalinvoicecode");
            String originalInvoiceNo = dynamicObject.getString("originalinvoiceno");
            DynamicObject originalInvoice = IssueInvoiceService.getOriInvoice(dynamicObject, originalInvoiceCode, originalInvoiceNo);
            if (originalInvoice == null) {
                return;
            }
            originalInvoice.set("occupystatus", (Object)"0");
            BigDecimal remainRedAmount = originalInvoice.getBigDecimal("remainredamount").add(invoiceAmount);
            BigDecimal canRedTaxAmount = originalInvoice.getBigDecimal("canredtaxamount").add(dynamicObject.getBigDecimal("totaltax").setScale(2, 4));
            originalInvoice.set("remainredamount", (Object)(remainRedAmount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : remainRedAmount));
            originalInvoice.set("canredtaxamount", (Object)(canRedTaxAmount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : canRedTaxAmount));
            DynamicObjectCollection oriInvoiceItems = originalInvoice.getDynamicObjectCollection("items");
            DynamicObject copyRedInvoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
            DynamicObjectUtil.copyDynamicObject((DynamicObject)dynamicObject, (DynamicObject)copyRedInvoice);
            DynamicObjectCollection copyRedInvoiceItems = copyRedInvoice.getDynamicObjectCollection("items");
            HashMap<Long, Long> blueItemSeqBlueItemPkMap = new HashMap<Long, Long>();
            long firstSeq = ((DynamicObject)oriInvoiceItems.get(0)).getLong("seq");
            int seqAddNum = firstSeq == 0L ? 1 : 0;
            for (DynamicObject oriInvoiceItem : oriInvoiceItems) {
                blueItemSeqBlueItemPkMap.put(oriInvoiceItem.getLong("seq") + (long)seqAddNum, oriInvoiceItem.getLong("id"));
            }
            HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
            Map<Long, DynamicObject> seqItemMap = IssueInvoiceService.getOriginalSeqMap(dynamicObject, copyRedInvoiceItems, blueItemSeqBlueItemPkMap);
            for (DynamicObject item : copyRedInvoiceItems) {
                long originalInvoiceItemId = item.getLong("originalinvoiceitemid");
                if (originalInvoiceItemId == 0L) continue;
                map.putIfAbsent(originalInvoiceItemId, item);
            }
            for (DynamicObject oriInvoiceItem : oriInvoiceItems) {
                DynamicObject redItem = (DynamicObject)map.get(oriInvoiceItem.getLong("id"));
                if (map.size() == 0 && seqItemMap.size() != 0) {
                    redItem = seqItemMap.get(oriInvoiceItem.getLong("seq") + (long)seqAddNum);
                }
                if (redItem != null) {
                    BigDecimal itemRemainRedAmount = oriInvoiceItem.getBigDecimal("itemremainredamount").add(redItem.getBigDecimal("amount"));
                    BigDecimal itemRemainRedTax = oriInvoiceItem.getBigDecimal("itemremainredtax").add(redItem.getBigDecimal("tax"));
                    BigDecimal redNum = redItem.getBigDecimal("num");
                    BigDecimal oriNum = oriInvoiceItem.getBigDecimal("num");
                    BigDecimal itemRemainRedNum = oriInvoiceItem.getBigDecimal("itemremainrednum");
                    if (MathUtils.isNullOrZero(itemRemainRedNum) && MathUtils.isNotZero(oriNum)) {
                        itemRemainRedNum = oriNum;
                    }
                    if (MathUtils.isNotZero(redNum)) {
                        itemRemainRedNum = itemRemainRedNum.add(redNum);
                    }
                    oriInvoiceItem.set("itemremainredamount", (Object)(itemRemainRedAmount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : itemRemainRedAmount));
                    oriInvoiceItem.set("itemremainredtax", (Object)(itemRemainRedTax.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : itemRemainRedTax));
                    oriInvoiceItem.set("itemremainrednum", (Object)(itemRemainRedNum.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : itemRemainRedNum));
                } else if (MathUtils.isZero(remainRedAmount)) {
                    oriInvoiceItem.set("itemremainredamount", (Object)BigDecimal.ZERO);
                    oriInvoiceItem.set("itemremainredtax", (Object)BigDecimal.ZERO);
                    oriInvoiceItem.set("itemremainrednum", (Object)BigDecimal.ZERO);
                }
                if (!BigDecimalUtil.compareZero((BigDecimal)oriInvoiceItem.getBigDecimal("itemremainredamount"))) continue;
                oriInvoiceItem.set("itemremainrednum", (Object)BigDecimal.ZERO);
            }
            DynamicObjectCollection items = dynamicObject.getDynamicObjectCollection("items");
            for (DynamicObject item : items) {
                long originalSeq = item.getLong("originseq");
                long origianlItemPk = item.getLong("originalinvoiceitemid");
                Long blueItemPk = (Long)blueItemSeqBlueItemPkMap.get(originalSeq);
                if (0L == originalSeq || 0L != origianlItemPk || 0L == blueItemPk) continue;
                item.set("originalinvoiceitemid", (Object)blueItemPk);
            }
            if (BigDecimalUtil.compareZero((BigDecimal)remainRedAmount)) {
                originalInvoice.set("invoicestatus", (Object)"3");
            } else {
                originalInvoice.set("invoicestatus", (Object)"2");
            }
            IssueInvoiceService.updateBlueInvoiceRemainDiscountAmount(dynamicObject, originalInvoice);
            SaveServiceHelper.update((DynamicObject)originalInvoice);
            WideInvoiceSevice.addInvoiceToWide(originalInvoice);
        }
        catch (Exception e) {
            LOG.error("\u5199\u5165\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d\u5931\u8d25", (Throwable)e);
        }
    }

    private static void updateBlueInvoiceRemainDiscountAmount(DynamicObject invoice, DynamicObject originalInvoice) {
        List relateItems;
        long blueItemPk;
        DynamicObject item;
        DynamicObjectCollection redItems = invoice.getDynamicObjectCollection("items");
        if (redItems.size() == 0 || ((DynamicObject)redItems.get(0)).getLong("originalinvoiceitemid") == 0L) {
            return;
        }
        BigDecimal discountRate = IssueInvoiceService.getDiscountRate();
        String redReason = invoice.getString("redreason");
        HashMap blueItemPkRedItemListMap = new HashMap();
        DynamicObjectCollection blueItems = originalInvoice.getDynamicObjectCollection("items");
        for (DynamicObject redItem : redItems) {
            long oriItemId = redItem.getLong("originalinvoiceitemid");
            List items = (List)blueItemPkRedItemListMap.get(oriItemId);
            if (null == items) {
                blueItemPkRedItemListMap.put(oriItemId, new ArrayList());
                items = (List)blueItemPkRedItemListMap.get(oriItemId);
            }
            items.add(redItem);
        }
        if (InvoiceUtils.isRedReasonDiscount((String)redReason)) {
            for (int i = 0; i < blueItems.size(); ++i) {
                BigDecimal remainDiscountAmount;
                item = (DynamicObject)blueItems.get(i);
                blueItemPk = item.getLong("id");
                relateItems = (List)blueItemPkRedItemListMap.get(blueItemPk);
                if (null == relateItems) continue;
                BigDecimal redAmount = relateItems.stream().map(o -> o.getBigDecimal("amount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal itemRemainNum = item.getBigDecimal("itemremainrednum");
                BigDecimal itemRemainAmount = item.getBigDecimal("itemremainredamount");
                BigDecimal discountedAmount = item.getBigDecimal("discountedamount");
                BigDecimal price = item.getBigDecimal("unitprice");
                if (BigDecimalUtil.compareZero((BigDecimal)price)) {
                    DynamicObject nextRow;
                    BigDecimal amount = item.getBigDecimal("amount");
                    if (i + 1 < blueItems.size() && "1".equals((nextRow = (DynamicObject)blueItems.get(i + 1)).getString("rowtype"))) {
                        amount = nextRow.getBigDecimal("amount").add(amount);
                    }
                    remainDiscountAmount = amount.multiply(discountRate).subtract(discountedAmount).subtract(redAmount.abs());
                } else {
                    remainDiscountAmount = itemRemainNum.multiply(item.getBigDecimal("unitprice")).multiply(discountRate).subtract(discountedAmount).subtract(redAmount.abs()).setScale(2, RoundingMode.HALF_UP);
                }
                if (remainDiscountAmount.compareTo(itemRemainAmount) > 0) {
                    remainDiscountAmount = itemRemainAmount;
                }
                item.set("remaindiscountamount", (Object)remainDiscountAmount);
                item.set("discountedamount", (Object)item.getBigDecimal("discountedamount").add(redAmount.abs()));
                item.set("redprice", (Object)PriceHelper.calcPriceOrNum(itemRemainAmount, itemRemainNum, true));
            }
        } else {
            for (int i = 0; i < blueItems.size(); ++i) {
                BigDecimal remainDiscountAmount;
                item = (DynamicObject)blueItems.get(i);
                blueItemPk = item.getLong("id");
                relateItems = (List)blueItemPkRedItemListMap.get(blueItemPk);
                if (null == relateItems) continue;
                BigDecimal itemRemainNum = item.getBigDecimal("itemremainrednum");
                BigDecimal price = item.getBigDecimal("unitprice");
                BigDecimal discountedAmount = item.getBigDecimal("discountedamount");
                if (BigDecimalUtil.compareZero((BigDecimal)price)) {
                    DynamicObject nextRow;
                    BigDecimal amount = item.getBigDecimal("amount");
                    if (i + 1 < blueItems.size() && "1".equals((nextRow = (DynamicObject)blueItems.get(i + 1)).getString("rowtype"))) {
                        amount = nextRow.getBigDecimal("amount").add(amount);
                    }
                    remainDiscountAmount = amount.multiply(discountRate).subtract(discountedAmount);
                } else {
                    remainDiscountAmount = itemRemainNum.multiply(price).multiply(discountRate).subtract(discountedAmount).setScale(2, RoundingMode.HALF_UP);
                }
                if (remainDiscountAmount.compareTo(item.getBigDecimal("itemremainredamount")) > 0) {
                    remainDiscountAmount = item.getBigDecimal("itemremainredamount");
                }
                item.set("remaindiscountamount", (Object)remainDiscountAmount);
            }
        }
    }

    private static Map<Long, DynamicObject> getOriginalSeqMap(DynamicObject dynamicObject, DynamicObjectCollection copyRedInvoiceItems, Map<Long, Long> blueItemSeqBlueItemPkMap) {
        HashMap<Long, DynamicObject> seqItemMap = new HashMap<Long, DynamicObject>(copyRedInvoiceItems.size());
        if (!InvoiceUtils.isAllEInvoice((Object)dynamicObject.getString("invoicetype")) || copyRedInvoiceItems.size() == 0 || ((DynamicObject)copyRedInvoiceItems.get(0)).getLong("originalinvoiceitemid") != 0L) {
            return seqItemMap;
        }
        QFilter filter = ImcBaseDataHelper.getRedConfirmFilter((Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject.get("orgid"))).and(new QFilter("number", "=", (Object)dynamicObject.getString("infocode")));
        DynamicObject redConfirm = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)true), (QFilter[])filter.toArray());
        if (redConfirm == null) {
            return seqItemMap;
        }
        DynamicObject copyRedConfirm = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_confirm_bill");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)redConfirm, (DynamicObject)copyRedConfirm);
        DynamicObjectCollection items = copyRedConfirm.getDynamicObjectCollection("items");
        for (DynamicObject item : items) {
            seqItemMap.putIfAbsent(item.getLong("originseq"), item);
        }
        DynamicObjectCollection redConfirmItems = redConfirm.getDynamicObjectCollection("items");
        boolean isOriginalInvoiceItemIdisNull = false;
        for (DynamicObject redConfirmItem : redConfirmItems) {
            long originalSeq = redConfirmItem.getLong("originseq");
            if (redConfirmItem.getLong("originalinvoiceitemid") != 0L) continue;
            isOriginalInvoiceItemIdisNull = true;
            Long blueItemPk = blueItemSeqBlueItemPkMap.get(originalSeq);
            redConfirmItem.set("originalinvoiceitemid", (Object)blueItemPk);
        }
        if (isOriginalInvoiceItemIdisNull) {
            SaveServiceHelper.update((DynamicObject)redConfirm);
        }
        return seqItemMap;
    }

    private static void setRedInvoiceZero(DynamicObject dynamicObject) {
        dynamicObject.set("remainredamount", (Object)BigDecimal.ZERO);
        dynamicObject.set("canredtaxamount", (Object)BigDecimal.ZERO);
        DynamicObjectCollection items = dynamicObject.getDynamicObjectCollection("items");
        for (DynamicObject item : items) {
            item.set("itemremainredamount", (Object)BigDecimal.ZERO);
            item.set("itemremainredtax", (Object)BigDecimal.ZERO);
            item.set("itemremainrednum", (Object)BigDecimal.ZERO);
        }
    }

    public static void setBlueInvoiceRemainRedAmount(DynamicObject invoice) {
        if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        String invoiceStatus = invoice.getString("invoicestatus");
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)invoiceStatus, (CharSequence)"3")) {
            invoice.set("remainredamount", (Object)BigDecimal.ZERO);
            invoice.set("canredtaxamount", (Object)BigDecimal.ZERO);
        } else {
            invoice.set("remainredamount", (Object)invoice.getBigDecimal("invoiceamount").setScale(2, 4));
            invoice.set("canredtaxamount", (Object)invoice.getBigDecimal("totaltax").setScale(2, 4));
        }
        DynamicObjectCollection items = IssueInvoiceService.updateErrorRowType(invoice);
        for (int i = 0; i < items.size(); ++i) {
            DynamicObject item = (DynamicObject)items.get(i);
            if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)invoiceStatus, (CharSequence)"3")) {
                item.set("itemremainredamount", (Object)BigDecimal.ZERO);
                item.set("itemremainredtax", (Object)BigDecimal.ZERO);
                item.set("itemremainrednum", (Object)BigDecimal.ZERO);
                continue;
            }
            if ("0".equals(item.getString("rowtype"))) {
                item.set("itemremainredamount", (Object)item.getBigDecimal("amount"));
                item.set("itemremainredtax", (Object)item.getBigDecimal("tax"));
                item.set("itemremainrednum", (Object)item.getBigDecimal("num"));
                continue;
            }
            if (!"2".equals(item.getString("rowtype"))) continue;
            DynamicObject discountItem = (DynamicObject)items.get(i + 1);
            item.set("itemremainredamount", (Object)item.getBigDecimal("amount").add(discountItem.getBigDecimal("amount")));
            item.set("itemremainredtax", (Object)item.getBigDecimal("tax").add(discountItem.getBigDecimal("tax")));
            item.set("itemremainrednum", (Object)item.getBigDecimal("num"));
        }
    }

    private static DynamicObjectCollection updateErrorRowType(DynamicObject invoice) {
        DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
        try {
            for (int i = 0; i < items.size(); ++i) {
                DynamicObject item = (DynamicObject)items.get(i);
                if (!"1".equals(item.getString("rowtype"))) continue;
                DynamicObject lastRow = (DynamicObject)items.get(i - 1);
                lastRow.set("rowtype", (Object)"2");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return items;
    }

    private static DynamicObject getOriInvoice(DynamicObject dynamicObject, String originalInvoiceCode, String originalInvoiceNo) {
        DynamicObject originalInvoice = null;
        if (StringUtils.isNotEmpty((String)originalInvoiceNo)) {
            return IssueInvoiceService.loadOriInvoice(dynamicObject, originalInvoiceCode, originalInvoiceNo);
        }
        if (InvoiceUtils.isAllEInvoice((Object)dynamicObject.getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)dynamicObject.getString("iselepaper"))) {
            QFilter filter = RedConfirmHelper.getFilter((String)dynamicObject.getString("infocode"), (Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)dynamicObject.getDynamicObject("orgid")));
            DynamicObject[] confirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_confirm_bill", (boolean)true), (QFilter[])filter.toArray());
            if (confirms.length > 0 && StringUtils.isNotEmpty((String)confirms[0].getString("originalinvoiceno"))) {
                originalInvoiceNo = confirms[0].getString("originalinvoiceno");
                originalInvoiceCode = confirms[0].getString("originalinvoicecode");
                originalInvoice = IssueInvoiceService.loadOriInvoice(dynamicObject, originalInvoiceCode, originalInvoiceNo);
            }
        }
        return originalInvoice;
    }

    private static DynamicObject loadOriInvoice(DynamicObject dynamicObject, String originalInvoiceCode, String originalInvoiceNo) {
        DynamicObject originalInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("invoicecode", "=", (Object)originalInvoiceCode).and("invoiceno", "=", (Object)originalInvoiceNo).toArray());
        return originalInvoice;
    }

    public static String fetchPdfNeedCreateFromISMC() {
        HashMap reqMap = new HashMap();
        String pdfSignType = "0";
        try {
            MsgResponse msgResponse = RequestUtils.doRequest((String)UUID.next(), (String)"FetchSignType", reqMap);
            if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
                String respData = msgResponse.getRespData();
                JSONObject jsonObject = JSONObject.parseObject((String)respData);
                pdfSignType = jsonObject.getString("pdfSignType");
                CacheHelper.put((String)"paperNeedPdf", (String)jsonObject.getString("paperNeedPdf"));
                CacheHelper.put((String)"pdfSignType", (String)pdfSignType, (int)3600);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("getFetchType pdfSignType=" + pdfSignType);
            }
        }
        catch (Exception e) {
            LOG.error("\u83b7\u53d6\u7a0e\u63a7\u7cfb\u7edf\u4e91\u7b7e\u7ae0\u5931\u8d25", (Throwable)e);
        }
        return pdfSignType;
    }

    public static MsgResponse doIssueEleVehicleInvoice(DynamicObject vehicle) {
        return new AllEleIssueInvoiceImpl().issue(vehicle);
    }

    public static ComponentResponse<VehicleInvoiceIssueResponseDTO> doIssueVehicleInvoice(DynamicObject vehicle) {
        String equipmentType = DeviceUtil.getDevType((String)vehicle.getString("jqbh"));
        String invoiceType = vehicle.getString("invoicetype");
        if (InvoiceUtils.isAllEVehicleInv((String)invoiceType)) {
            equipmentType = "12";
        }
        if (InvoiceUtils.isUsedCarInvoice((Object)invoiceType)) {
            equipmentType = "12";
        }
        vehicle.set("issuesource", (Object)equipmentType);
        if ("3".equals(equipmentType)) {
            VehicleInvoiceIssueResponseDTO response = new VehicleInvoiceIssueResponseDTO();
            response.setFpdm(RandomString.nextString((int)10, (boolean)true, (boolean)false));
            response.setFphm(RandomString.nextString((int)8, (boolean)true, (boolean)false));
            response.setKprq(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            response.setJym(UUID.next());
            return new ComponentResponse("0000", ResManager.loadKDString((String)"\u5f00\u5177\u6210\u529f", (String)"IssueInvoiceService_4", (String)"imc-sim-common", (Object[])new Object[0]), Integer.valueOf(0), (Object)response, null);
        }
        VehicleInvoiceIssueRequestDTO request = (VehicleInvoiceIssueRequestDTO)DynamicObjectUtil.dynamicObject2Bean(VehicleInvoiceIssueRequestDTO.class, (DynamicObject)vehicle);
        request.setTaxrate(Integer.valueOf(vehicle.getBigDecimal("taxrate").multiply(new BigDecimal("100")).intValue()));
        request.setTotal(vehicle.getBigDecimal("totalamount").setScale(2, 4).toString());
        if (vehicle.getBigDecimal("totalamount").compareTo(BigDecimal.ZERO) > 0) {
            request.setRemark("");
        }
        VehicleInvoiceTaxCodeDTO taxCode = new VehicleInvoiceTaxCodeDTO();
        taxCode.setCode(vehicle.getString("goodscode"));
        request.setTaxcode(taxCode);
        ComponentRequest componentRequest = new ComponentRequest(ComponentInterfaceTypeEnum.VEHICLE_INVOICE_OPEN.getCzlx(), (Object)request, null, null);
        String requestJson = JSONObject.toJSONString((Object)componentRequest);
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("\u5f00\u5177\u673a\u52a8\u8f66\u7968\u8bf7\u6c42\u6570\u636e\uff1a[%s]", requestJson));
        }
        ComponentResponse response = ComponentServiceHelper.doPost((String)ComponentServiceHelper.getComponentRequestUrl((String)vehicle.getString("jqbh")), (String)requestJson, VehicleInvoiceIssueResponseDTO.class);
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("\u5f00\u5177\u673a\u52a8\u8f66\u7968\u8fd4\u56de\u6570\u636e\uff1a[%s]", SerializationUtils.toJsonString((Object)response)));
        }
        return response;
    }

    public static void openPrintDialog(AbstractFormPlugin formPlugin, DynamicObject vehicles) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("invoicecode", vehicles.get("invoicecode"));
        customParams.put("invoiceno", vehicles.get("invoiceno"));
        customParams.put("invoicetype", vehicles.get("invoicetype"));
        customParams.put("jqbh", vehicles.get("jqbh"));
        customParams.put("orgid", DynamicObjectUtil.getDynamicObjectLongValue((Object)"orgid"));
        ViewUtil.openDialog((AbstractFormPlugin)formPlugin, customParams, (String)"sim_invoice_print_confirm", (String)"callback_sim_invoice_print_confirm");
    }

    public static JSONObject doRedVehicleInvoice(DynamicObject vehicle) {
        String equipmentType = DeviceUtil.getDevType((String)vehicle.getString("jqbh"));
        if ("3".equals(equipmentType)) {
            JSONObject json = new JSONObject();
            json.put("errcode", (Object)"0");
            JSONObject sjd = new JSONObject();
            sjd.put("fpdm", (Object)RandomString.nextString((int)10, (boolean)true, (boolean)false));
            sjd.put("fphm", (Object)RandomString.nextString((int)8, (boolean)true, (boolean)false));
            sjd.put("serialnum", (Object)UUID.next());
            sjd.put("jym", (Object)UUID.next());
            json.put("sjd", (Object)sjd.toString());
            return json;
        }
        HashMap request = Maps.newHashMap();
        request.put("fpdm", vehicle.getString("invoicecode"));
        request.put("fphm", vehicle.getString("invoiceno"));
        request.put("kpzl", vehicle.getString("issuetype"));
        ComponentRequest componentRequest = new ComponentRequest(ComponentInterfaceTypeEnum.VEHICLE_INVOICE_RED.getCzlx(), (Object)request, null, null);
        String requestJson = JSONObject.toJSONString((Object)componentRequest);
        if (LOG.isInfoEnabled()) {
            LOG.info(String.format("\u673a\u52a8\u8f66\u7968\u7ea2\u51b2\u8bf7\u6c42\u6570\u636e\uff1a[%s]", requestJson));
        }
        String url = ComponentServiceHelper.getComponentRequestUrl((String)vehicle.getString("jqbh"));
        return ComponentServiceHelper.doPost((String)url, (String)requestJson);
    }

    public static void handleVehicleInvoiceIssueResponse(VehicleInvoiceIssueResponseDTO response, DynamicObject vehicleInvoice) {
        if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
            IssueInvoiceService.fillData(response, vehicleInvoice);
        } else if (ErrorType.SUBMITED.getCode().equals(response.getErrorCode())) {
            vehicleInvoice.set("issuestatus", (Object)IssueStatusEnum.underway.getCode());
        } else {
            vehicleInvoice.set("issuestatus", (Object)IssueStatusEnum.failed.getCode());
            vehicleInvoice.set("result", (Object)GBKUtils.cutGBKString((String)response.getDescription(), (int)160));
        }
        ImcSaveServiceHelper.update((DynamicObject)vehicleInvoice);
        IssueInvoiceService.handlerVehicleIssueResult(vehicleInvoice);
        if (ErrorType.SUBMITED.getCode().equals(response.getErrorCode()) && (InvoiceUtils.isAllEVehicleInv((String)vehicleInvoice.getString("invoicetype")) || InvoiceUtils.isUsedCarInvoice((Object)vehicleInvoice.getString("invoicetype")))) {
            try {
                DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"AsyncIssueInvoiceQueryImpl", (String)"queryAsyncIssueResult", (Object[])new Object[]{vehicleInvoice.getString("orderno")});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void fillData(VehicleInvoiceIssueResponseDTO response, DynamicObject vehicleInvoice) {
        vehicleInvoice.set("invoicecode", (Object)response.getFpdm());
        vehicleInvoice.set("invoiceno", (Object)response.getFphm());
        vehicleInvoice.set("issuetime", (Object)DateUtils.stringToDate((String)response.getKprq(), (String)"yyyy-MM-dd HH:mm:ss"));
        vehicleInvoice.set("alletaxinvoiceno", (Object)response.getAlletaxinvoiceno());
        vehicleInvoice.set("invoicestatus", (Object)"0");
        vehicleInvoice.set("issuestatus", (Object)IssueStatusEnum.ok.getCode());
        vehicleInvoice.set("skm", (Object)response.getJym());
        vehicleInvoice.set("result", null);
        IssueInvoiceService.handleVehicleOfdStatus(vehicleInvoice);
        IssueInvoiceService.warpVehiclePushStatus(vehicleInvoice);
        IssueInvoiceService.updateTaxOrg(vehicleInvoice);
    }

    public static VehicleInvoiceIssueResponseDTO wrapMsgResponse(MsgResponse msgResponse) {
        String errorCode = msgResponse.getErrorCode();
        VehicleInvoiceIssueResponseDTO response = new VehicleInvoiceIssueResponseDTO();
        response.setErrorCode(errorCode);
        response.setDescription(msgResponse.getErrorMsg());
        if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(errorCode)) {
            JSONObject responseJson = JSON.parseObject((String)msgResponse.getRespData());
            response.setFpdm(responseJson.getString("invoicecode"));
            response.setFphm(responseJson.getString("invoiceno"));
            response.setAlletaxinvoiceno(responseJson.getString("alletaxinvoiceno"));
            response.setKprq(responseJson.getString("issuetime"));
        }
        return response;
    }

    public static void updateDiscountInfo(DynamicObject invoice) {
        IssueInvoiceService.setBlueInvoiceRemainDiscountAmount(invoice);
        String issueType = invoice.getString("issuetype");
        DynamicObject blueInvoice = null;
        if (IssueType.RED_INVOICE.getTypeCode().equals(issueType) && "0".equals(invoice.getString("invoicestatus"))) {
            String oriInvoiceCode = invoice.getString("originalinvoicecode");
            String oriInvoiceNo = invoice.getString("originalinvoiceno");
            if (StringUtils.isEmpty((String)oriInvoiceNo)) {
                return;
            }
            DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])InvoiceUtils.getInvoiceFilter((Object)oriInvoiceCode, (Object)oriInvoiceNo).toArray());
            if (invoices.length == 0) {
                return;
            }
            blueInvoice = invoices[0];
            IssueInvoiceService.updateBlueInvoiceRemainDiscountAmount(invoice, blueInvoice);
            ImcSaveServiceHelper.save((DynamicObject)blueInvoice);
            WideInvoiceSevice.addInvoiceToWide(blueInvoice);
        }
    }

    public static void dealInvoiceRemarkByIssueType(DynamicObject invoiceObj, AllEleFullInvoiceResponseDTO responseDTO) {
        String issueType = invoiceObj.getString("issuetype");
        if (IssueType.RED_INVOICE.getTypeCode().equals(issueType)) {
            invoiceObj.set("remark", (Object)responseDTO.getRemark());
        }
    }

    public static void setBlueInvoiceItemRedPrice(DynamicObject invoice, AllEleFullInvoiceResponseDTO responseDTO) {
        try {
            String issueType = invoice.getString("issuetype");
            if (IssueType.RED_INVOICE.getTypeCode().equals(issueType)) {
                return;
            }
            if (InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype")) || AllEleAuthHelper.isElePaper((Object)invoice.getString("iselepaper"))) {
                return;
            }
            DynamicObjectCollection oldItems = invoice.getDynamicObjectCollection("items");
            if (CollectionUtils.isEmpty((Collection)oldItems)) {
                return;
            }
            List<AllEleFullInvoiceItemDTO> rspItems = responseDTO.getItems();
            if (CollectionUtils.isEmpty(rspItems)) {
                return;
            }
            if (oldItems.size() != rspItems.size()) {
                return;
            }
            for (int i = 0; i < oldItems.size(); ++i) {
                if (((DynamicObject)oldItems.get(i)).getBigDecimal("amount").compareTo(new BigDecimal(rspItems.get(i).getDetailAmount())) != 0 || ((DynamicObject)oldItems.get(i)).getBigDecimal("tax").compareTo(new BigDecimal(rspItems.get(i).getTaxAmount())) != 0 || StringUtils.isEmpty((String)rspItems.get(i).getUnitPrice()) || StringUtils.isEmpty((String)rspItems.get(i).getNum()) || null == ((DynamicObject)oldItems.get(i)).getBigDecimal("num") || new BigDecimal(rspItems.get(i).getUnitPrice()).multiply(((DynamicObject)oldItems.get(i)).getBigDecimal("num")).subtract(((DynamicObject)oldItems.get(i)).getBigDecimal("amount")).abs().compareTo(new BigDecimal("0.01")) >= 0) continue;
                ((DynamicObject)oldItems.get(i)).set("unitprice", (Object)new BigDecimal(rspItems.get(i).getUnitPrice()));
                if (null == ((DynamicObject)oldItems.get(i)).getBigDecimal("redprice")) {
                    ((DynamicObject)oldItems.get(i)).set("redprice", (Object)new BigDecimal(rspItems.get(i).getUnitPrice()));
                    continue;
                }
                if (((DynamicObject)oldItems.get(i)).getBigDecimal("redprice").multiply(((DynamicObject)oldItems.get(i)).getBigDecimal("num")).subtract(((DynamicObject)oldItems.get(i)).getBigDecimal("amount")).abs().compareTo(new BigDecimal("0.01")) > 0) continue;
                ((DynamicObject)oldItems.get(i)).set("redprice", (Object)new BigDecimal(rspItems.get(i).getUnitPrice()));
            }
        }
        catch (Exception e) {
            LOG.error("setBlueInvoiceItemRedPrice error:", (Throwable)e);
        }
    }
}

