/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service.file;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.service.AwsFpyService;
import kd.imc.bdm.common.util.HttpUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.sim.common.service.file.InvoiceFileUploadService;
import org.apache.commons.lang3.tuple.Pair;

public class InvoiceFileUploadS3NewService
extends InvoiceFileUploadService {
    private static final Log log = LogFactory.getLog(InvoiceFileUploadS3NewService.class);

    @Override
    public Pair<String, String> upload(byte[] fileBytes, String localUrl, String orgTaxNo, String type, String fileName, boolean testFlag, String remoteUrl) {
        try {
            Map awsConfigMap = ImcConfigUtil.getValue((String)"dim_imc_config_fpy");
            String clientId = ImcConfigUtil.getValue((Map)awsConfigMap, (String[])new String[]{"clientid", "dim_imc_config_fpy_clientid"});
            String clientSecret = ImcConfigUtil.getValue((Map)awsConfigMap, (String[])new String[]{"clientsecret", "dim_imc_config_fpy_clientsecret"});
            AwsFpyService awsFpyService = AwsFpyService.newInstance();
            String accessToken = awsFpyService.getAccessToken(clientId, clientSecret);
            String url = awsFpyService.getBaseUrl() + "/doc/api/file/upload?access_token=" + accessToken + "&encry_type=GCM";
            String proxy = awsFpyService.getProxy();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("client-platform", "common");
            if (log.isInfoEnabled()) {
                log.info(String.format("\u4e0a\u4f20S3\u5f00\u59cb\uff0c\u8bf7\u6c42\u5730\u5740:[%s]", url));
            }
            JSONObject uploadResult = HttpUtil.uploadZipFile((String)url, (String)proxy, (InputStream)new ByteArrayInputStream(fileBytes), (String)fileName, headers, (String)clientId, (boolean)false);
            JSONObject json = uploadResult.getJSONObject("data");
            String snapShotUrl = "";
            JSONArray snapshotPreUrls = json.getJSONArray("snapshotUrlList");
            if (snapshotPreUrls != null && snapshotPreUrls.size() > 0) {
                snapShotUrl = snapshotPreUrls.getString(0);
            }
            return Pair.of((Object)json.getString("originalUrl"), (Object)snapShotUrl);
        }
        catch (Exception e) {
            log.error(String.format("\u4e0a\u4f20S3\u5931\u8d25\uff0c\u4f01\u4e1a\u7a0e\u53f7[%s]\uff0c\u53d1\u7968\u6570\u636e[%s]", orgTaxNo, fileName), (Throwable)e);
            return Pair.of((Object)"", (Object)"");
        }
    }
}

