/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service.issueinvoice.impl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.service.InvoiceIsmcSyncToImcService;
import kd.imc.sim.common.service.issueinvoice.IIssueInvoice;
import kd.imc.sim.common.utils.MathUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractTGIssueInvoiceImpl
implements IIssueInvoice {
    protected void rewriteInvoice(DynamicObject invoice) {
        invoice.set("thirdserialno", (Object)invoice.getString("orderno"));
        invoice.set("invoiceamount", (Object)invoice.getBigDecimal("invoiceamount").setScale(2, 4));
        invoice.set("totaltax", (Object)invoice.getBigDecimal("totaltax").setScale(2, 4));
        invoice.set("totalamount", (Object)invoice.getBigDecimal("totalamount").setScale(2, 4));
        String qdbz = invoice.getString("inventorymark");
        if (StringUtils.isBlank((String)qdbz)) {
            invoice.set("inventorymark", (Object)"0");
        }
        if (MathUtils.isNullOrZero(invoice.getBigDecimal("deduction"))) {
            invoice.set("deduction", null);
        }
        DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
        for (DynamicObject item : items) {
            item.set("amount", (Object)item.getBigDecimal("amount").setScale(2, 4));
            item.set("tax", (Object)item.getBigDecimal("tax").setScale(2, 4));
            BigDecimal num = item.getBigDecimal("num");
            if (MathUtils.isNullOrZero(num)) {
                item.set("unitprice", null);
                item.set("num", null);
                continue;
            }
            item.set("num", (Object)item.getBigDecimal("num").setScale(8, 4));
            item.set("unitprice", (Object)item.getBigDecimal("unitprice").setScale(8, 4));
        }
    }

    protected void warpResponseData(DynamicObject invoice, MsgResponse msgResponse, String issueChannel) {
        if (ErrorType.SUCCESS.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
            AbstractTGIssueInvoiceImpl.warpIssueSuccess(invoice, JSONObject.parseObject((String)msgResponse.getRespData()));
        } else if (ErrorType.SUBMITED.getCode().equalsIgnoreCase(msgResponse.getErrorCode())) {
            msgResponse.setErrorMsg(ErrorType.SUBMITED.getName());
            this.saveAsyncIssueInvoice(invoice, issueChannel);
        }
    }

    protected void saveAsyncIssueInvoice(DynamicObject invoice, String issueChannel) {
        if (!QueryServiceHelper.exists((String)"sim_async_issue_invoice", (QFilter[])new QFilter("orderno", "=", (Object)invoice.getString("orderno")).toArray())) {
            DynamicObject syncIssue = this.addAsyncInvoice(invoice, issueChannel);
            ImcSaveServiceHelper.save((DynamicObject)syncIssue);
        }
    }

    public DynamicObject addAsyncInvoice(DynamicObject invoice, String issueChannel) {
        String taxNo = invoice.getString("salertaxno");
        if (InvoiceUtils.isUsedCarInvoice((Object)invoice.getString("invoicetype"))) {
            taxNo = invoice.getString("issuetaxno");
        }
        DynamicObject syncIssue = BusinessDataServiceHelper.newDynamicObject((String)"sim_async_issue_invoice");
        syncIssue.set("orderno", invoice.get("orderno"));
        syncIssue.set("issuechannel", (Object)issueChannel);
        syncIssue.set("createdate", (Object)new Date());
        syncIssue.set("govorderno", invoice.get("govorderno"));
        syncIssue.set("salertaxno", (Object)taxNo);
        syncIssue.set("querycount", (Object)0);
        syncIssue.set("invoiceno", invoice.get("invoiceno"));
        syncIssue.set("issuetime", invoice.get("issuetime"));
        syncIssue.set("invoicetype", invoice.get("invoicetype"));
        return syncIssue;
    }

    public static void warpIssueSuccess(DynamicObject invoice, JSONObject resJson) {
        invoice.set("invoicecode", (Object)resJson.getString("invoicecode"));
        invoice.set("invoiceno", (Object)resJson.getString("invoiceno"));
        Date date = null == resJson.get((Object)"issuetime") ? new Date() : resJson.getDate("issuetime");
        invoice.set("issuetime", (Object)date);
        invoice.set("checkcode", (Object)resJson.getString("checkcode"));
        invoice.set("skm", (Object)resJson.getString("skm"));
        invoice.set("fileurl", (Object)resJson.getString("fileurl"));
        String fileUrl = resJson.getString("fileurl");
        if (!InvoiceUtils.isAllEInvoice((Object)invoice.getString("invoicetype")) && InvoiceUtils.isEtcInvoice((String)invoice.getString("invoicetype"))) {
            InvoiceIsmcSyncToImcService.fillPdfUrl(invoice, fileUrl);
        }
        invoice.set("snapshoturl", (Object)resJson.getString("snapshoturl"));
        invoice.set("ofdstatus", (Object)resJson.getString("ofdstatus"));
        String terminalNo = resJson.getString("terminalno");
        if (StringUtils.isNotBlank((String)terminalNo)) {
            invoice.set("terminalno", (Object)terminalNo);
        }
        DeleteServiceHelper.delete((String)"sim_async_issue_invoice", (QFilter[])new QFilter("orderno", "=", (Object)invoice.getString("orderno")).toArray());
    }

    protected static void copyBlueExtraItems(DynamicObject invoice, DynamicObjectCollection extraItems) {
        DynamicObjectCollection invExtraItems = invoice.getDynamicObjectCollection("extra");
        invExtraItems.clear();
        for (DynamicObject extraItem : extraItems) {
            DynamicObject invExtraItem = invExtraItems.addNew();
            DynamicObjectUtil.copyDynamicObject((DynamicObject)extraItem, (DynamicObject)invExtraItem);
        }
    }
}

