/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service.issueinvoice.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.constant.TaxRate;
import kd.imc.bdm.common.helper.AddressSplitHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.SystemParameterHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceQueryUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUpladDeducItem;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUploadBuildRequest;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUploadEstateLeaseOldRequest;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUploadEstateLeaseRequest;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUploadEstateSaleRequest;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUploadFarmProduceSaleRequest;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUploadFreightRequest;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUploadItem;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUploadOilRequest;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUploadPurchaseRequest;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUploadRareEarthRequest;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUploadRequest;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUploadTobaccoRequest;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUploadTravellerTransportationRequest;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.ElectInvoiceUploadVehicleVesselRequest;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.tdys.ElecInvoiceUploadBuildInfo;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.tdys.ElecInvoiceUploadEstateSaleCoPurchaser;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.tdys.ElecInvoiceUploadEstateSaleNew;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.tdys.ElecInvoiceUploadFreight;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.tdys.ElecInvoiceUploadTravellerTransportation;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.tdys.ElecInvoiceUploadVehicleVessel;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.tdys.ElectInvoiceUploadAddition;
import kd.imc.bdm.lqpt.model.request.base.electinvoiceupload.tdys.ElectInvoiceUploadEstateLease;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.base.electinvoiceupload.ElectInvoiceUploadResponse;
import kd.imc.bdm.lqpt.service.ElectInvoiceUploadService;
import kd.imc.bdm.lqpt.service.InvoiceNoService;
import kd.imc.bdm.lqpt.service.TaxpayerService;
import kd.imc.sim.common.model.invoice.InvoiceSpecialType;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.service.issueinvoice.impl.AbstractTGIssueInvoiceImpl;
import kd.imc.sim.common.service.issueinvoice.impl.AllEleIssueInvoiceImpl;
import kd.imc.sim.common.utils.AllEleLqAddressSplitUtil;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AllEleLqIssueInvoiceImpl
extends AbstractTGIssueInvoiceImpl {
    private static final Log LOG = LogFactory.getLog(AllEleLqIssueInvoiceImpl.class);
    public static final Map<String, String> PRIVILEGE_TYPE_MAP = new ImmutableMap.Builder().put((Object)"\u7b80\u6613\u5f81\u6536", (Object)"01").put((Object)"\u7a00\u571f\u4ea7\u54c1", (Object)"02").put((Object)"\u514d\u7a0e", (Object)"03").put((Object)"\u4e0d\u5f81\u7a0e", (Object)"04").put((Object)"\u5148\u5f81\u540e\u9000", (Object)"05").put((Object)"100%\u5148\u5f81\u540e\u9000", (Object)"06").put((Object)"50%\u5148\u5f81\u540e\u9000", (Object)"07").put((Object)"\u63093%\u7b80\u6613\u5f81\u6536", (Object)"08").put((Object)"\u63095%\u7b80\u6613\u5f81\u6536", (Object)"09").put((Object)"\u63095%\u7b80\u6613\u5f81\u6536\u51cf\u63091.5%\u8ba1\u5f81", (Object)"10").put((Object)"\u5373\u5f81\u5373\u900030%", (Object)"11").put((Object)"\u5373\u5f81\u5373\u900050%", (Object)"12").put((Object)"\u5373\u5f81\u5373\u900070%", (Object)"13").put((Object)"\u5373\u5f81\u5373\u9000100%", (Object)"14").put((Object)"\u8d85\u7a0e\u8d1f3%\u5373\u5f81\u5373\u9000", (Object)"15").put((Object)"\u8d85\u7a0e\u8d1f8%\u5373\u5f81\u5373\u9000", (Object)"16").put((Object)"\u8d85\u7a0e\u8d1f12%\u5373\u5f81\u5373\u9000", (Object)"17").put((Object)"\u8d85\u7a0e\u8d1f6%\u5373\u5f81\u5373\u9000", (Object)"18").build();

    public boolean support(DynamicObject invoice) {
        return false;
    }

    public MsgResponse issue(DynamicObject invoice) {
        invoice.set("issuesource", (Object)"13");
        this.dealCutRedInvoiceRemarkMethod(invoice);
        DynamicObject epInfo = this.checkLqInvoice(invoice);
        if (!"1".equals(ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"taxcheck"))) {
            Date today = DateUtils.trunc((Date)new Date());
            DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
            Map<BigDecimal, DynamicObject> taxRateMap = this.availableTaxRate(invoice.getString("salertaxno"));
            Map<String, DynamicObject> taxCodeMap = this.availableTaxCode(items);
            for (int i = 0; i < items.size(); ++i) {
                DynamicObject item = (DynamicObject)items.get(i);
                this.checkTaxCode(invoice, taxCodeMap, item, i, today);
                this.checkTaxRate(taxRateMap, item, i, today);
            }
        }
        MsgResponse msgResponse = new MsgResponse();
        msgResponse.setErrorCode(ErrorType.SUBMITED.getCode());
        String invoiceNo = invoice.getString("invoiceno");
        if (StringUtils.isNotBlank((CharSequence)invoiceNo) && QueryServiceHelper.exists((String)"sim_async_issue_invoice", (QFilter[])new QFilter("orderno", "=", (Object)invoice.getString("orderno")).toArray())) {
            this.warpResponseData(invoice, msgResponse, "lqpt");
            return msgResponse;
        }
        boolean subSxed = true;
        ElectInvoiceUploadRequest eleIssue = this.buildIssueInvoide(invoice, epInfo);
        String taxNo = InvoiceSpecialType.InvoiceSpecialTypeEnum.PURCHASE.getLqCode().equals(eleIssue.getTdys()) ? eleIssue.getGmfnsrsbh() : eleIssue.getXsfnsrsbh();
        InvoiceNoService invoiceNoService = new InvoiceNoService();
        if (StringUtils.isBlank((CharSequence)invoiceNo)) {
            invoiceNo = invoiceNoService.getInvoiceNo(taxNo, eleIssue.getKprq());
            if (StringUtils.isBlank((CharSequence)invoiceNo)) {
                return MsgResponse.valueOfError((String)ErrorType.FAIL.getCode(), (String)ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u53d1\u7968\u53f7\u7801\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"AllEleLqIssueInvoiceImpl_2", (String)"imc-sim-common", (Object[])new Object[0]));
            }
        } else {
            subSxed = false;
            LOG.info("\u4e50\u4f01\u53d1\u7968\u4e0a\u4f20\u53d1\u7968\u53f7\u7801\u5df2\u5728\u5f85\u5f00\uff0c\u975e\u7b2c\u4e00\u6b21\u4e0a\u4f20,\u53d1\u7968\u53f7\u7801\u4e3a " + invoiceNo);
        }
        eleIssue.setFphm(invoiceNo);
        LOG.info(String.format("\u4e50\u4f01\u53d1\u7968\u4e0a\u4f20 \u5f00\u7968\u65f6\u95f4: %s \u53d1\u7968\u53f7\u7801: %s", DateUtils.format((Date)eleIssue.getKprq(), (String)"yyyy-MM-dd HH:mm:ss"), eleIssue.getFphm()));
        invoice.set("issuetime", (Object)eleIssue.getKprq());
        if (DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.getPkValue()) != 0L) {
            DynamicObject updateInvoice = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
            updateInvoice.set("id", invoice.getPkValue());
            updateInvoice.set("issuetime", (Object)eleIssue.getKprq());
            updateInvoice.set("invoiceno", (Object)eleIssue.getFphm());
            SaveServiceHelper.update((DynamicObject)updateInvoice);
        } else {
            invoice.set("invoiceno", (Object)eleIssue.getFphm());
        }
        LqptResponse lqptResponse = new ElectInvoiceUploadService().uploadInvoiceData(eleIssue, subSxed);
        if (!lqptResponse.success()) {
            LOG.info(String.format("\u4e50\u4f01\u53d1\u7968\u4e0a\u4f20\u5931\u8d25\uff0c\u53d1\u7968\u6d41\u6c34\u53f7\u662f[%s]\uff0c\u53d1\u7968\u53f7\u7801\u662f[%s]", eleIssue.getOrderNo(), eleIssue.getFphm()));
            return MsgResponse.valueOfError((String)lqptResponse.getErrcode(), (String)lqptResponse.getDescription());
        }
        ElectInvoiceUploadResponse response = (ElectInvoiceUploadResponse)lqptResponse.getData();
        JSONObject json = new JSONObject();
        json.put("invoiceno", (Object)eleIssue.getFphm());
        msgResponse.setRespData(json.toJSONString());
        invoice.set("invoiceno", (Object)eleIssue.getFphm());
        invoice.set("govorderno", (Object)response.getSllsh());
        this.warpResponseData(invoice, msgResponse, "lqpt");
        return msgResponse;
    }

    private void dealCutRedInvoiceRemarkMethod(DynamicObject invoice) {
        String remark = invoice.getString("remark");
        if (StringUtils.isBlank((CharSequence)remark)) {
            return;
        }
        String issueType = invoice.getString("issuetype");
        if ("1".equals(issueType)) {
            String originalInvoiceType = invoice.getString("originalinvoicetype");
            long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid"));
            boolean isCutRemark = InvoiceUtils.isCutRemark((Long)orgId);
            if (InvoiceUtils.isAllEInvoice((Object)originalInvoiceType)) {
                if (isCutRemark) {
                    if (remark.length() > 382) {
                        remark = remark.substring(0, 382);
                        invoice.set("remark", (Object)remark);
                        log.info("dealCutRedInvoiceRemarkMethod, billNo:{}, issueType:{}, remark:{}", new Object[]{invoice.getString("billno"), issueType, remark});
                        ImcSaveServiceHelper.update((DynamicObject)invoice);
                    }
                } else if (remark.length() > 382) {
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u7ea2\u7968\u81ea\u5b9a\u4e49\u5907\u6ce8\uff08\u4e0d\u542b\u539f\u84dd\u7968\u53f7\u7801\u3001\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7\uff09\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u5b57\u7b26", (String)"AllEleLqIssueInvoiceImpl_14", (String)"imc-sim-common", (Object[])new Object[0]), 382);
                    throw new MsgException(errorMsg);
                }
            } else if (isCutRemark) {
                if (remark.length() > 377) {
                    remark = remark.substring(0, 377);
                    invoice.set("remark", (Object)remark);
                    log.info("dealCutRedInvoiceRemarkMethod, billNo:{}, issueType:{}, remark:{}", new Object[]{invoice.getString("billno"), issueType, remark});
                    ImcSaveServiceHelper.update((DynamicObject)invoice);
                }
            } else if (remark.length() > 377) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u7ea2\u7968\u81ea\u5b9a\u4e49\u5907\u6ce8\uff08\u4e0d\u542b\u539f\u84dd\u7968\u53f7\u7801\u3001\u539f\u84dd\u7968\u4ee3\u7801\u3001\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7\uff09\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a\u5b57\u7b26", (String)"AllEleLqIssueInvoiceImpl_15", (String)"imc-sim-common", (Object[])new Object[0]), 377);
                throw new MsgException(errorMsg);
            }
        }
    }

    private DynamicObject checkLqInvoice(DynamicObject invoice) {
        String specialType = invoice.getString("specialtype");
        if (StringUtils.isNotBlank((CharSequence)specialType) && !"00".equals(specialType) && !InvoiceSpecialType.allEleSpecialType(specialType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u7279\u6b8a\u884c\u4e1a\u6570\u7535\u7968\u5f00\u5177!", (String)"AllEleLqIssueInvoiceImpl_0", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        String sellerTaxNo = invoice.getString("salertaxno");
        DynamicObject epInfo = new TaxpayerService().isRiskTaxPayer(sellerTaxNo);
        if (StringUtils.isBlank((CharSequence)invoice.getString("drawer"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u7968\u4eba\u4e0d\u80fd\u4e3a\u7a7a!", (String)"AllEleLqIssueInvoiceImpl_1", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        return epInfo;
    }

    private ElectInvoiceUploadRequest buildIssueInvoide(DynamicObject invoice, DynamicObject epInfo) {
        List fjysList;
        String originalInvoiceNo;
        Date date = invoice.getDate("issuetime");
        if (date == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(14, 0);
            invoice.set("issuetime", (Object)calendar.getTime());
        }
        ElectInvoiceUploadRequest issueInvoice = this.getIssueInvoice(invoice);
        issueInvoice.setFpkjfsDm("5");
        issueInvoice.setNsrsbh(invoice.getString("salertaxno"));
        issueInvoice.setCkywsyzcDm(invoice.getString("applypolicy"));
        LOG.info("applyPolicy:" + invoice.getString("applypolicy"));
        issueInvoice.setFppz(InvoiceType.getLqptCodeByTypeCode((String)issueInvoice.getFppz()));
        this.setBuyerPerson(issueInvoice, invoice);
        issueInvoice.setQyDm(epInfo.getString("zgswskfjdm"));
        String taxedType = invoice.getString("taxedtype");
        if (TaxedTypeEnum.all_e_deduction_full.getValue().equals(taxedType)) {
            issueInvoice.setCezslxDm("01");
        } else if (TaxedTypeEnum.all_e_deduction.getValue().equals(taxedType)) {
            issueInvoice.setCezslxDm("02");
        } else {
            issueInvoice.setCezslxDm("");
        }
        issueInvoice.setZzsjzjtDm("");
        AllEleLqIssueInvoiceImpl.replaceAddrAndBank(issueInvoice);
        DynamicObject agent = invoice.getDynamicObject("operator");
        if (agent != null) {
            issueInvoice.setGmfjbr(agent.getString("name"));
            issueInvoice.setJbrsfzhm(agent.getString("certificatenumber"));
            issueInvoice.setGmfjbrlxdh("");
        }
        issueInvoice.setSkyhmc("");
        issueInvoice.setSkyhzh("");
        issueInvoice.setJsfs("01");
        issueInvoice.setYsxwfsd("");
        issueInvoice.setKprzjhm("");
        issueInvoice.setKprzjlx("");
        if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0 && StringUtils.isNotBlank((CharSequence)(originalInvoiceNo = invoice.getString("originalinvoiceno"))) && originalInvoiceNo.length() < 20) {
            issueInvoice.setDylzfphm(invoice.getString("originalinvoicecode") + originalInvoiceNo);
        }
        issueInvoice.setIp(this.getIp());
        issueInvoice.setMacdz(this.getMacAddress());
        issueInvoice.setCpuid("");
        issueInvoice.setZbxlh("");
        boolean goodsNameIsSame = false;
        if (issueInvoice.getHjje().compareTo(BigDecimal.ZERO) < 0) {
            if (StringUtils.isBlank((CharSequence)issueInvoice.getHzqrxxdbh())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u5177\u8d1f\u6570\u6570\u7535\u53d1\u7968\u65f6\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"AllEleLqIssueInvoiceImpl_13", (String)"imc-sim-common", (Object[])new Object[0]));
            }
            QFilter qFilter = new QFilter("number", "=", (Object)issueInvoice.getHzqrxxdbh());
            DynamicObject redConfirmBill = QueryServiceHelper.queryOne((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "govuuid", "goodsnamesame"), (QFilter[])qFilter.toArray());
            if (redConfirmBill != null) {
                goodsNameIsSame = "Y".equals(redConfirmBill.getString("goodsnamesame"));
                if (StringUtils.isBlank((CharSequence)issueInvoice.getHzqrduuid())) {
                    issueInvoice.setHzqrduuid(redConfirmBill.getString("govuuid"));
                }
            }
        }
        List fpmxList = issueInvoice.getFpmxList();
        for (int i = 0; i < fpmxList.size(); ++i) {
            ElectInvoiceUploadItem item = (ElectInvoiceUploadItem)fpmxList.get(i);
            item.setMxxh(Integer.valueOf(i + 1));
            if (issueInvoice.getHjje().compareTo(BigDecimal.ZERO) > 0) {
                item.setDylzfpmxxh(null);
            }
            if (StringUtils.isNotBlank((CharSequence)item.getDj()) && BigDecimal.ZERO.compareTo(new BigDecimal(item.getDj())) == 0) {
                item.setDj(null);
                item.setSl(null);
            }
            if (StringUtils.isNotBlank((CharSequence)item.getSl()) && BigDecimal.ZERO.compareTo(new BigDecimal(item.getSl())) == 0) {
                item.setDj(null);
                item.setSl(null);
            }
            if (i == 0) {
                if (TaxedTypeEnum.all_e_deduction_full.getValue().equals(taxedType)) {
                    item.setKce(BigDecimal.ZERO);
                } else if (TaxedTypeEnum.all_e_deduction.getValue().equals(taxedType) && !MathUtils.isNullOrZero(invoice.getBigDecimal("deduction"))) {
                    item.setKce(invoice.getBigDecimal("deduction").setScale(2, 4));
                }
            }
            this.replaceXmmc(item, goodsNameIsSame);
            item.setFphxz('0' + item.getFphxz());
            if (!StringUtils.isNotBlank((CharSequence)item.getYhzcbs())) continue;
            item.setYhzcbs(PRIVILEGE_TYPE_MAP.get(item.getYhzcbs()));
        }
        issueInvoice.setSgfplxDm("");
        if (InvoiceSpecialType.allEleSpecialType(issueInvoice.getTdys())) {
            this.buildSpecialType(invoice, issueInvoice);
        } else {
            issueInvoice.setTdys("");
        }
        this.setDedutionList(invoice, issueInvoice);
        this.setShowBankInfo(invoice, issueInvoice);
        if (IssueType.RED_INVOICE.getTypeCode().equals(invoice.getString("issuetype")) && CollectionUtils.isEmpty((Collection)issueInvoice.getFjysList()) && StringUtils.isNotBlank((CharSequence)invoice.getString("originalinvoiceno"))) {
            QFilter filter = InvoiceUtils.getInvoiceFilter((Object)invoice.getString("originalinvoicecode"), (Object)invoice.getString("originalinvoiceno"));
            DynamicObject blueInv = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])filter.toArray());
            if (null != blueInv && blueInv.getDynamicObjectCollection("extra").size() > 0) {
                DynamicObjectCollection extraItems = blueInv.getDynamicObjectCollection("extra");
                AllEleLqIssueInvoiceImpl.copyBlueExtraItems(invoice, extraItems);
                ArrayList<ElectInvoiceUploadAddition> fjysList2 = new ArrayList<ElectInvoiceUploadAddition>();
                issueInvoice.setFjysList(fjysList2);
                for (DynamicObject extraItem : extraItems) {
                    ElectInvoiceUploadAddition extraDTO = (ElectInvoiceUploadAddition)DynamicObjectUtil.dynamicObject2Bean(ElectInvoiceUploadAddition.class, (DynamicObject)extraItem);
                    fjysList2.add(extraDTO);
                }
            }
        }
        if (null != (fjysList = issueInvoice.getFjysList()) && fjysList.size() > 0) {
            for (ElectInvoiceUploadAddition addition : fjysList) {
                AllEleLqIssueInvoiceImpl.convertExtraInfoType(addition);
            }
        }
        return issueInvoice;
    }

    private static void convertExtraInfoType(ElectInvoiceUploadAddition extraDTO) {
        String convertStr = ImcConfigUtil.getValue((String)"convertExtraInfoType", (String)"convertRule");
        if (StringUtils.isNotBlank((CharSequence)convertStr)) {
            JSONObject convertRule = JSONObject.parseObject((String)convertStr);
            String fjyslx = extraDTO.getFjyslx();
            String fjyslxTarget = convertRule.getString(fjyslx);
            extraDTO.setFjyslx(fjyslxTarget);
            return;
        }
        if ("0".equals(extraDTO.getFjyslx())) {
            extraDTO.setFjyslx("string");
        }
        if ("2".equals(extraDTO.getFjyslx())) {
            extraDTO.setFjyslx("date");
        }
        if ("1".equals(extraDTO.getFjyslx())) {
            extraDTO.setFjyslx("number");
        }
    }

    private String getIp() {
        try {
            String ip = ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"ip");
            if (StringUtils.isNotBlank((CharSequence)ip)) {
                return ip;
            }
            InetAddress localhost = InetAddress.getLocalHost();
            return localhost.getHostAddress();
        }
        catch (Exception e) {
            return "127.0.0.1";
        }
    }

    private String getMacAddress() {
        try {
            String macAddress = ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"mac");
            if (StringUtils.isNotBlank((CharSequence)macAddress)) {
                return macAddress;
            }
            InetAddress ia = InetAddress.getLocalHost();
            byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                int temp;
                String str;
                if (i != 0) {
                    sb.append('-');
                }
                if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                    sb.append('0').append(str);
                    continue;
                }
                sb.append(str);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "unknow";
        }
    }

    private void setBuyerPerson(ElectInvoiceUploadRequest issueInvoice, DynamicObject invoice) {
        if ("02".equals(invoice.getString("specialtype"))) {
            return;
        }
        String buyerProperty = invoice.getString("buyerproperty");
        if (StringUtils.isBlank((CharSequence)buyerProperty) || !"1".equals(buyerProperty)) {
            issueInvoice.setGmfzrrbz("N");
            return;
        }
        issueInvoice.setGmfzrrbz("Y");
        if (issueInvoice instanceof ElectInvoiceUploadPurchaseRequest) {
            issueInvoice.setGmfzrrbz("N");
        }
        if (issueInvoice.getHjje().compareTo(BigDecimal.ZERO) > 0) {
            this.setPersonStr(issueInvoice, invoice);
            return;
        }
        String originalInvoiceNo = invoice.getString("originalinvoiceno");
        String originalInvoiceType = invoice.getString("originalinvoicetype");
        if (StringUtils.isBlank((CharSequence)originalInvoiceNo) && StringUtils.isBlank((CharSequence)originalInvoiceType)) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)originalInvoiceType) && InvoiceUtils.isAllEInvoice((Object)originalInvoiceType)) {
            this.setPersonStr(issueInvoice, invoice);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)originalInvoiceNo) && originalInvoiceNo.length() == 20) {
            this.setPersonStr(issueInvoice, invoice);
        }
    }

    private void setPersonStr(ElectInvoiceUploadRequest issueInvoice, DynamicObject invoice) {
        if (StringUtils.isNotBlank((CharSequence)issueInvoice.getGmfmc()) && !issueInvoice.getGmfmc().endsWith("\uff08\u4e2a\u4eba\uff09")) {
            String gmfmc = issueInvoice.getGmfmc().replaceAll("\uff08\u4e2a\u4eba\uff09", "");
            gmfmc = gmfmc.replaceAll("\\(\u4e2a\u4eba\\)", "") + "\uff08\u4e2a\u4eba\uff09";
            issueInvoice.setGmfmc(gmfmc);
            invoice.set("buyername", (Object)gmfmc);
        }
    }

    private void replaceXmmc(ElectInvoiceUploadItem item, boolean goodsNameIsSame) {
        if (StringUtils.isBlank((CharSequence)item.getSpfwjc())) {
            if (StringUtils.isNotBlank((CharSequence)item.getSphfwssflhbbm())) {
                DynamicObject taxCode = TaxClassCodeCheckHelper.geTaxCode((String)item.getSphfwssflhbbm());
                item.setSpfwjc(taxCode.getString("simplename"));
            }
        } else {
            String spfwjc = item.getSpfwjc();
            if (spfwjc.startsWith("*")) {
                item.setSpfwjc(spfwjc.substring(1, spfwjc.length() - 1));
            }
        }
        if (goodsNameIsSame) {
            if (StringUtils.isNotBlank((CharSequence)item.getSpfwjc())) {
                item.setHwhyslwfwmc('*' + item.getSpfwjc() + '*' + item.getXmmc());
            }
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)item.getSpfwjc())) {
            String simpleGoodsName;
            String goodsName = item.getHwhyslwfwmc();
            String string = simpleGoodsName = item.getSpfwjc().startsWith("*") ? item.getSpfwjc() : '*' + item.getSpfwjc() + '*';
            if (goodsName.startsWith(simpleGoodsName)) {
                item.setXmmc(goodsName.replace(simpleGoodsName, ""));
            } else {
                item.setHwhyslwfwmc(String.format("*%s*%s", item.getSpfwjc(), goodsName));
            }
        }
    }

    private void setDedutionList(DynamicObject invoice, ElectInvoiceUploadRequest issueInvoice) {
        if (!"openDeduction".equals(ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"openDeduction"))) {
            issueInvoice.setCekcList(null);
            return;
        }
        if (issueInvoice.getHjje().compareTo(BigDecimal.ZERO) < 0) {
            issueInvoice.setCekcList(null);
            DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "deduction", "taxedtype"), (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo(invoice.getString("originalinvoicecode"), invoice.getString("originalinvoiceno")).toArray());
            if (blueInvoice == null) {
                return;
            }
            String taxedType = blueInvoice.getString("taxedtype");
            if (TaxedTypeEnum.all_e_deduction_full.getValue().equals(taxedType) || TaxedTypeEnum.all_e_deduction.getValue().equals(taxedType)) {
                issueInvoice.setCezslxDm(taxedType);
                ((ElectInvoiceUploadItem)issueInvoice.getFpmxList().get(0)).setKce(blueInvoice.getBigDecimal("deduction").setScale(2, 4).negate());
            } else {
                issueInvoice.setCezslxDm("");
            }
            return;
        }
        if (!TaxedTypeEnum.all_e_deduction.getValue().equals(issueInvoice.getCezslxDm())) {
            issueInvoice.setCekcList(null);
            return;
        }
        DynamicObjectCollection deductions = invoice.getDynamicObjectCollection("deductions");
        ArrayList<ElectInvoiceUpladDeducItem> deductionList = new ArrayList<ElectInvoiceUpladDeducItem>(deductions.size());
        for (int i = 0; i < deductions.size(); ++i) {
            DynamicObject deductionItem = (DynamicObject)deductions.get(i);
            ElectInvoiceUpladDeducItem deductionRequest = (ElectInvoiceUpladDeducItem)DynamicObjectUtil.dynamicObject2Bean(ElectInvoiceUpladDeducItem.class, (DynamicObject)deductionItem);
            deductionRequest.setXh(Integer.valueOf(i + 1));
            deductionRequest.setKjrq(DateUtils.format((Date)deductionItem.getDate("invoicedate")));
            if ("01".equals(deductionRequest.getPzlx())) {
                deductionRequest.setFphm(deductionItem.getString("etaxinvoiceno"));
            }
            deductionList.add(deductionRequest);
        }
        issueInvoice.setCekcList(deductionList);
    }

    private void setShowBankInfo(DynamicObject invoice, ElectInvoiceUploadRequest issueInvoice) {
        boolean showSalerAddressTel;
        boolean showBuyerAddressTel;
        boolean showSalerBank;
        boolean showBuyerBank;
        boolean isInvoice = "sim_vatinvoice".equals(invoice.getDataEntityType().getName());
        if (!isInvoice) {
            return;
        }
        boolean bl = showBuyerBank = StringUtils.isNotEmpty((CharSequence)invoice.getString("showbuyerbank")) ? AllEleIssueInvoiceImpl.checkShowBank(invoice.getString("showbuyerbank")) : SystemParameterHelper.getBdmParameterBoolean((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid")), (String)"showbuyerbank");
        if (showBuyerBank) {
            invoice.set("showbuyerbank", (Object)"Y");
            issueInvoice.setSfzsgmfyhzhbq("Y");
        } else {
            invoice.set("showbuyerbank", (Object)"N");
            issueInvoice.setSfzsgmfyhzhbq("N");
        }
        boolean bl2 = showSalerBank = StringUtils.isNotEmpty((CharSequence)invoice.getString("showsalerbank")) ? AllEleIssueInvoiceImpl.checkShowBank(invoice.getString("showsalerbank")) : SystemParameterHelper.getBdmParameterBoolean((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid")), (String)"showsalerbank");
        if (showSalerBank) {
            invoice.set("showsalerbank", (Object)"Y");
            issueInvoice.setSfzsxsfyhzhbq("Y");
        } else {
            invoice.set("showsalerbank", (Object)"N");
            issueInvoice.setSfzsxsfyhzhbq("N");
        }
        boolean bl3 = showBuyerAddressTel = StringUtils.isNotEmpty((CharSequence)invoice.getString("showbuyeraddresstel")) ? AllEleIssueInvoiceImpl.checkShowBank(invoice.getString("showbuyeraddresstel")) : SystemParameterHelper.getBdmParameterBoolean((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid")), (String)"showbuyeraddresstel");
        if (showBuyerAddressTel) {
            invoice.set("showbuyeraddresstel", (Object)"Y");
            issueInvoice.setSfzsgmfdzdhbq("Y");
        } else {
            invoice.set("showbuyeraddresstel", (Object)"N");
            issueInvoice.setSfzsgmfdzdhbq("N");
        }
        boolean bl4 = showSalerAddressTel = StringUtils.isNotEmpty((CharSequence)invoice.getString("showsaleraddresstel")) ? AllEleIssueInvoiceImpl.checkShowBank(invoice.getString("showsaleraddresstel")) : SystemParameterHelper.getBdmParameterBoolean((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid")), (String)"showsaleraddresstel");
        if (showSalerAddressTel) {
            invoice.set("showsaleraddresstel", (Object)"Y");
            issueInvoice.setSfzsxsfdzdhbq("Y");
        } else {
            invoice.set("showsaleraddresstel", (Object)"N");
            issueInvoice.setSfzsxsfdzdhbq("N");
        }
    }

    private ElectInvoiceUploadRequest getIssueInvoice(DynamicObject invoice) {
        switch (invoice.getString("specialtype")) {
            case "E03": {
                return (ElectInvoiceUploadRequest)DynamicObjectUtil.dynamicObject2Bean(ElectInvoiceUploadBuildRequest.class, (DynamicObject)invoice);
            }
            case "E06": {
                if ("1".equals(ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"lease_version")) || DateUtils.compare((Date)new Date(), (Date)DateUtils.stringToDate((String)"2025-03-01")) >= 0) {
                    return (ElectInvoiceUploadRequest)DynamicObjectUtil.dynamicObject2Bean(ElectInvoiceUploadEstateLeaseRequest.class, (DynamicObject)invoice);
                }
                return (ElectInvoiceUploadRequest)DynamicObjectUtil.dynamicObject2Bean(ElectInvoiceUploadEstateLeaseOldRequest.class, (DynamicObject)invoice);
            }
            case "E05": {
                return (ElectInvoiceUploadRequest)DynamicObjectUtil.dynamicObject2Bean(ElectInvoiceUploadEstateSaleRequest.class, (DynamicObject)invoice);
            }
            case "E04": {
                return (ElectInvoiceUploadRequest)DynamicObjectUtil.dynamicObject2Bean(ElectInvoiceUploadFreightRequest.class, (DynamicObject)invoice);
            }
            case "E01": {
                return (ElectInvoiceUploadRequest)DynamicObjectUtil.dynamicObject2Bean(ElectInvoiceUploadOilRequest.class, (DynamicObject)invoice);
            }
            case "E18": {
                return (ElectInvoiceUploadRequest)DynamicObjectUtil.dynamicObject2Bean(ElectInvoiceUploadTobaccoRequest.class, (DynamicObject)invoice);
            }
            case "02": {
                ElectInvoiceUploadPurchaseRequest request = (ElectInvoiceUploadPurchaseRequest)DynamicObjectUtil.dynamicObject2Bean(ElectInvoiceUploadPurchaseRequest.class, (DynamicObject)invoice);
                request.setXsfzrrbz("Y");
                request.setGmfzrrbz(null);
                if (IssueType.BLUE_INVOICE.getTypeCode().equals(invoice.getString("issuetype"))) {
                    DynamicObject nation = invoice.getDynamicObject("nation");
                    if (null != nation) {
                        request.setXsfzrrgjDm(nation.getString("number"));
                    } else {
                        String buyerTaxNo;
                        String cardType = invoice.getString("cardtype");
                        nation = InvoiceUtils.getNation((String)cardType, (String)(buyerTaxNo = invoice.getString("buyertaxno")));
                        if (null != nation) {
                            request.setXsfzrrgjDm(nation.getString("number"));
                        }
                        throw new KDBizException(ResManager.loadKDString((String)"\u6536\u8d2d\u7968\u9500\u552e\u65b9\u81ea\u7136\u4eba\u56fd\u7c4d\uff08\u5730\u533a\uff09\u4fe1\u606f\u5fc5\u586b", (String)"AllEleLqIssueInvoiceImpl_16", (String)"imc-sim-common", (Object[])new Object[0]));
                    }
                }
                return request;
            }
            case "E07": {
                return (ElectInvoiceUploadRequest)DynamicObjectUtil.dynamicObject2Bean(ElectInvoiceUploadVehicleVesselRequest.class, (DynamicObject)invoice);
            }
            case "E09": {
                return (ElectInvoiceUploadRequest)DynamicObjectUtil.dynamicObject2Bean(ElectInvoiceUploadTravellerTransportationRequest.class, (DynamicObject)invoice);
            }
            case "E12": {
                return (ElectInvoiceUploadRequest)DynamicObjectUtil.dynamicObject2Bean(ElectInvoiceUploadFarmProduceSaleRequest.class, (DynamicObject)invoice);
            }
            case "E02": {
                return (ElectInvoiceUploadRequest)DynamicObjectUtil.dynamicObject2Bean(ElectInvoiceUploadRareEarthRequest.class, (DynamicObject)invoice);
            }
        }
        return (ElectInvoiceUploadRequest)DynamicObjectUtil.dynamicObject2Bean(ElectInvoiceUploadRequest.class, (DynamicObject)invoice);
    }

    private void reverseBuyer(ElectInvoiceUploadRequest invoice) {
        String buyerName = invoice.getGmfmc();
        String buyerTaxNo = invoice.getGmfnsrsbh();
        String buyerAddr = invoice.getGmfdz();
        String buyerTel = invoice.getGmfdh();
        String buyerBank = invoice.getGmfkhh();
        String buyerBankNumber = invoice.getGmfzh();
        invoice.setGmfmc(invoice.getXsfmc());
        invoice.setGmfnsrsbh(invoice.getXsfnsrsbh());
        invoice.setGmfdz(invoice.getXsfdz());
        invoice.setGmfdh(invoice.getXsfdh());
        invoice.setGmfkhh(invoice.getXsfkhh());
        invoice.setGmfzh(invoice.getXsfzh());
        invoice.setXsfmc(buyerName);
        invoice.setXsfnsrsbh(buyerTaxNo);
        invoice.setXsfdz(buyerAddr);
        invoice.setXsfdh(buyerTel);
        invoice.setXsfkhh(buyerBank);
        invoice.setXsfzh(buyerBankNumber);
    }

    private void buildSpecialType(DynamicObject invoice, ElectInvoiceUploadRequest issueInvoice) {
        String specialType;
        issueInvoice.setTdys(InvoiceSpecialType.InvoiceSpecialTypeEnum.getLqCodeBySpecialType(issueInvoice.getTdys()));
        DynamicObject simpleAddressObj = invoice.getDynamicObject("simpleaddress");
        String address = simpleAddressObj == null ? "" : simpleAddressObj.getString("name") + invoice.getString("detailaddress");
        Map<String, String> adrressMap = AllEleLqAddressSplitUtil.split(address);
        log.info("\u8be6\u7ec6\u5730\u5740{}\u63d0\u53d6\u7701\u5e02\u4e3a{}", (Object)address, (Object)JSONObject.toJSONString(adrressMap));
        String provinceName = adrressMap.get("province");
        String cityName = adrressMap.get("city");
        String detailAddress = simpleAddressObj == null ? "" : invoice.getString("detailaddress");
        String kdsbz = "1".equals(invoice.getString("crosscitysign")) ? "Y" : "N";
        String cqzsbh = StringUtils.isBlank((CharSequence)invoice.getString("estateid")) ? "\u65e0" : invoice.getString("estateid");
        ElectInvoiceUploadItem firstItem = (ElectInvoiceUploadItem)issueInvoice.getFpmxList().get(0);
        switch (specialType = invoice.getString("specialtype")) {
            case "E03": {
                ElecInvoiceUploadBuildInfo build = new ElecInvoiceUploadBuildInfo();
                build.setKdsbz(kdsbz);
                build.setTdzzsxmbh(invoice.getString("landtaxno"));
                if ("N".equals(kdsbz)) {
                    build.setKqysssxbyglbh("");
                } else {
                    build.setKqysssxbyglbh(invoice.getString("crosscitytaxverifyno"));
                }
                ((ElectInvoiceUploadBuildRequest)issueInvoice).setJzfwtdys(build);
                firstItem.setJzfwfsd(address);
                firstItem.setJzxmmc(invoice.getString("buildingname"));
                break;
            }
            case "E05": {
                AllEleLqIssueInvoiceImpl.buildSpecialTypeEsateSale(invoice, issueInvoice, firstItem, address, provinceName, cityName, detailAddress, kdsbz, cqzsbh);
                break;
            }
            case "E06": {
                AllEleLqIssueInvoiceImpl.buildSpecialTypeEsateLease(invoice, issueInvoice, firstItem, address, provinceName, cityName, detailAddress, kdsbz, cqzsbh);
                break;
            }
            case "E04": {
                DynamicObjectCollection freights = invoice.getDynamicObjectCollection("freights");
                ArrayList<ElecInvoiceUploadFreight> freightList = new ArrayList<ElecInvoiceUploadFreight>(freights.size());
                for (int i = 0; i < freights.size(); ++i) {
                    DynamicObject freight = (DynamicObject)freights.get(i);
                    ElecInvoiceUploadFreight elecInvoiceUploadFreight = (ElecInvoiceUploadFreight)DynamicObjectUtil.dynamicObject2Bean(ElecInvoiceUploadFreight.class, (DynamicObject)freight);
                    elecInvoiceUploadFreight.setYsmxxh(Integer.valueOf(i + 1));
                    freightList.add(elecInvoiceUploadFreight);
                }
                ((ElectInvoiceUploadFreightRequest)issueInvoice).setYsmxList(freightList);
                break;
            }
            case "02": {
                this.reverseBuyer(issueInvoice);
                issueInvoice.setSgfplxDm("01");
                break;
            }
            case "E07": {
                ElecInvoiceUploadVehicleVessel vehicleVessel = new ElecInvoiceUploadVehicleVessel();
                DynamicObjectCollection vehicleVesselCollection = invoice.getDynamicObjectCollection("vehichevesselships");
                this.createVehicleVesselMethod(vehicleVessel, vehicleVesselCollection);
                ((ElectInvoiceUploadVehicleVesselRequest)issueInvoice).setDsccstdys(vehicleVessel);
                break;
            }
            case "E09": {
                DynamicObjectCollection travelers = invoice.getDynamicObjectCollection("travelers");
                ArrayList<ElecInvoiceUploadTravellerTransportation> travellerTransportationList = new ArrayList<ElecInvoiceUploadTravellerTransportation>(travelers.size());
                for (int i = 0; i < travelers.size(); ++i) {
                    ElecInvoiceUploadTravellerTransportation travellerTransportation = (ElecInvoiceUploadTravellerTransportation)DynamicObjectUtil.dynamicObject2Bean(ElecInvoiceUploadTravellerTransportation.class, (DynamicObject)((DynamicObject)travelers.get(i)));
                    travellerTransportation.setChuxrq(DateUtils.format((Date)((DynamicObject)travelers.get(i)).getDate("traveldate"), (String)"yyyy-MM-dd"));
                    travellerTransportation.setCxrxh(i + 1);
                    travellerTransportationList.add(travellerTransportation);
                }
                ((ElectInvoiceUploadTravellerTransportationRequest)issueInvoice).setCxrxxList(travellerTransportationList);
            }
        }
    }

    private void createVehicleVesselMethod(ElecInvoiceUploadVehicleVessel vehicleVessel, DynamicObjectCollection vehicleVesselCollection) {
        if (CollectionUtils.isNotEmpty((Collection)vehicleVesselCollection)) {
            for (DynamicObject dynamicObject : vehicleVesselCollection) {
                vehicleVessel.setBxdh(dynamicObject.getString("policyno"));
                vehicleVessel.setCphcbdjh(dynamicObject.getString("shipsno"));
                vehicleVessel.setSkssq(dynamicObject.getString("perioddate"));
                vehicleVessel.setDsccsje(dynamicObject.getBigDecimal("vehiclevesselamount").setScale(2, RoundingMode.HALF_UP));
                vehicleVessel.setZnj(dynamicObject.getBigDecimal("vehiclelateamount").setScale(2, RoundingMode.HALF_UP));
                vehicleVessel.setJehj(dynamicObject.getBigDecimal("vehicletotalamount").setScale(2, RoundingMode.HALF_UP));
                vehicleVessel.setCjh(dynamicObject.getString("vehiclecode"));
            }
        }
    }

    private static void replaceAddrAndBank(ElectInvoiceUploadRequest issueInvoice) {
        if (StringUtils.isBlank((CharSequence)issueInvoice.getXsfdh())) {
            Pair salerAddressAndTel = AddressSplitHelper.splitAddressAndTel((String)issueInvoice.getXsfdz());
            issueInvoice.setXsfdz((String)salerAddressAndTel.getKey());
            issueInvoice.setXsfdh((String)salerAddressAndTel.getValue());
        }
        if (StringUtils.isBlank((CharSequence)issueInvoice.getXsfzh())) {
            Pair salerBankAndName = AddressSplitHelper.splitBankAndName((String)issueInvoice.getXsfkhh());
            issueInvoice.setXsfkhh((String)salerBankAndName.getKey());
            issueInvoice.setXsfzh((String)salerBankAndName.getValue());
        }
        if (StringUtils.isBlank((CharSequence)issueInvoice.getGmfdh())) {
            Pair buyerAddressAndTel = AddressSplitHelper.splitAddressAndTel((String)issueInvoice.getGmfdz());
            issueInvoice.setGmfdz((String)buyerAddressAndTel.getKey());
            issueInvoice.setGmfdh((String)buyerAddressAndTel.getValue());
        }
        if (StringUtils.isBlank((CharSequence)issueInvoice.getGmfzh())) {
            Pair buyerBankAndName = AddressSplitHelper.splitBankAndName((String)issueInvoice.getGmfkhh());
            issueInvoice.setGmfkhh((String)buyerBankAndName.getKey());
            issueInvoice.setGmfzh((String)buyerBankAndName.getValue());
        }
    }

    private Map<BigDecimal, DynamicObject> availableTaxRate(String taxNo) {
        DynamicObjectCollection availableTaxRateList = QueryServiceHelper.query((String)"bdm_lqpt_sl", (String)"slzsl, cszt, yxqq, yxqz, tyrq", (QFilter[])new QFilter("nsrsbh", "=", (Object)taxNo).toArray());
        return availableTaxRateList.stream().collect(Collectors.toMap(k -> new BigDecimal(k.getBigDecimal("slzsl").stripTrailingZeros().toPlainString()), v -> v, (v1, v2) -> v1));
    }

    private void checkTaxRate(Map<BigDecimal, DynamicObject> taxRateMap, DynamicObject item, int index, Date today) {
        String taxRateStr = item.getString("taxrate");
        if (StringUtils.isBlank((CharSequence)taxRateStr)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c\u7a0e\u7387\uff1a\u3010%2$s\u3011\u4e0d\u80fd\u4e3a\u7a7a", (String)"AllEleLqIssueInvoiceImpl_3", (String)"imc-sim-common", (Object[])new Object[0]), index + 1, taxRateStr));
        }
        BigDecimal taxRate = new BigDecimal(new BigDecimal(taxRateStr).stripTrailingZeros().toPlainString());
        if (taxRate.compareTo(TaxRate.ONE_PERCENT.getNumValue()) != 0) {
            DynamicObject taxRateObj = taxRateMap.get(taxRate);
            if (taxRateObj == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c\u7a0e\u7387\uff1a\u3010%2$s\u3011\u4e0d\u53ef\u7528", (String)"AllEleLqIssueInvoiceImpl_4", (String)"imc-sim-common", (Object[])new Object[0]), index + 1, taxRate));
            }
            if ("1".equals(taxRateObj.getString("cszt"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c\u7a0e\u7387\uff1a\u3010%2$s\u3011\u5df2\u505c\u7528", (String)"AllEleLqIssueInvoiceImpl_5", (String)"imc-sim-common", (Object[])new Object[0]), index + 1, taxRate));
            }
            Date startTime = taxRateObj.getDate("yxqq");
            Date endTime = taxRateObj.getDate("yxqz");
            Date disableTime = taxRateObj.getDate("tyrq");
            if (startTime != null && startTime.after(today) || endTime != null && endTime.before(today) || disableTime != null && disableTime.before(today)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c\u7a0e\u7387\uff1a\u3010%2$s\u3011\u4e0d\u5728\u6709\u6548\u671f\u5185\uff0c\u65e0\u6cd5\u5f00\u7968", (String)"AllEleLqIssueInvoiceImpl_6", (String)"imc-sim-common", (Object[])new Object[0]), index + 1, taxRate));
            }
        }
    }

    private Map<String, DynamicObject> availableTaxCode(DynamicObjectCollection items) {
        HashSet<String> taxCodeSet = new HashSet<String>(items.size());
        for (DynamicObject item : items) {
            taxCodeSet.add(item.getString("goodscode"));
        }
        DynamicObjectCollection taxCodeList = QueryServiceHelper.query((String)"bdm_lqpt_spbm", (String)"number, sfhzx, qyrq, tyrq, tdyslxdm", (QFilter[])new QFilter("number", "in", taxCodeSet).toArray());
        return taxCodeList.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v, (v1, v2) -> v1));
    }

    private void checkTaxCode(DynamicObject invoice, Map<String, DynamicObject> taxCodeMap, DynamicObject item, int index, Date today) {
        String tdyslxdm;
        String taxCode = item.getString("goodscode");
        if (StringUtils.isBlank((CharSequence)taxCode) && item.getString("goodsname").contains("\u8be6\u89c1\u9500\u8d27\u6e05\u5355")) {
            return;
        }
        DynamicObject taxCodeObj = taxCodeMap.get(taxCode);
        if (taxCodeObj == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\uff1a\u3010%2$s\u3011\u4e0d\u5b58\u5728", (String)"AllEleLqIssueInvoiceImpl_7", (String)"imc-sim-common", (Object[])new Object[0]), index + 1, taxCode));
        }
        if ("Y".equals(taxCodeObj.getString("sfhzx"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\uff1a\u3010%2$s\u3011\u4e3a\u6c47\u603b\u9879\uff0c\u65e0\u6cd5\u5f00\u7968", (String)"AllEleLqIssueInvoiceImpl_8", (String)"imc-sim-common", (Object[])new Object[0]), index + 1, taxCode));
        }
        Date enableTime = taxCodeObj.getDate("qyrq");
        Date disableTime = taxCodeObj.getDate("tyrq");
        if (enableTime != null && enableTime.after(today) || disableTime != null && disableTime.before(today)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\uff1a\u3010%2$s\u3011\u4e0d\u5728\u6709\u6548\u671f\u5185\uff0c\u65e0\u6cd5\u5f00\u7968", (String)"AllEleLqIssueInvoiceImpl_9", (String)"imc-sim-common", (Object[])new Object[0]), index + 1, taxCode));
        }
        String specialType = invoice.getString("specialtype");
        if ("02".equals(specialType) && !"11".equals(tdyslxdm = taxCodeObj.getString("tdyslxdm"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\uff1a\u3010%2$s\u3011\u6709\u8bef\uff0c\u5f00\u5177\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968\u65f6\uff0c\u53ea\u80fd\u4f7f\u7528\u7279\u5b9a\u8981\u7d20\u6807\u7b7e\u5f52\u7c7b\u4e3a\u201c11\uff08\u519c\u4ea7\u54c1\uff09\u201d\u7684\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\uff0c\u5f53\u524d\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u7279\u5b9a\u8981\u7d20\u6807\u7b7e\u5206\u7c7b\u4e3a\u3010%3$s\u3011", (String)"AllEleLqIssueInvoiceImpl_10", (String)"imc-sim-common", (Object[])new Object[0]), index + 1, taxCode, tdyslxdm));
        }
    }

    private static void buildSpecialTypeEsateSale(DynamicObject invoice, ElectInvoiceUploadRequest issueInvoice, ElectInvoiceUploadItem firstItem, String address, String provinceName, String cityName, String detailAddress, String kdsbz, String cqzsbh) {
        DynamicObject blueInvoice;
        DynamicObjectCollection estatesales = invoice.getDynamicObjectCollection("estatesales");
        String coBuyerFlag = invoice.getString("cobuyerflag");
        DynamicObjectCollection cobuyers = invoice.getDynamicObjectCollection("cobuyers");
        if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0 && (blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])InvoiceQueryUtil.getInvoiceByCodeAndNo((String)invoice.getString("originalinvoicecode"), (String)invoice.getString("originalinvoiceno")).toArray())) != null) {
            estatesales = blueInvoice.getDynamicObjectCollection("estatesales");
            coBuyerFlag = blueInvoice.getString("cobuyerflag");
            cobuyers = blueInvoice.getDynamicObjectCollection("cobuyers");
        }
        firstItem.setDw(invoice.getString("areaunit"));
        if (CollectionUtils.isEmpty((Collection)estatesales)) {
            DynamicObject dynamicObject = estatesales.addNew();
            dynamicObject.set("saleestatecode", (Object)invoice.getString("estatecode"));
            dynamicObject.set("onlinecontracteno", (Object)"");
            if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
                dynamicObject.set("saledetailaddress", (Object)address);
            } else {
                dynamicObject.set("saleprincename", (Object)provinceName);
                dynamicObject.set("salecityname", (Object)cityName);
                dynamicObject.set("saledetailaddress", (Object)detailAddress);
            }
            dynamicObject.set("salelandtaxno", (Object)invoice.getString("landtaxno"));
            dynamicObject.set("salecrosscitysign", (Object)kdsbz);
            dynamicObject.set("assessmenttaxamount", (Object)invoice.getBigDecimal("approvedprice"));
            dynamicObject.set("actualtotalamount", (Object)invoice.getBigDecimal("actualturnover"));
            dynamicObject.set("saleestateid", (Object)cqzsbh);
        }
        ArrayList<ElecInvoiceUploadEstateSaleNew> estateSales = new ArrayList<ElecInvoiceUploadEstateSaleNew>(estatesales.size());
        for (int i = 0; i < estatesales.size(); ++i) {
            ElecInvoiceUploadEstateSaleNew estateSaleNew = (ElecInvoiceUploadEstateSaleNew)DynamicObjectUtil.dynamicObject2Bean(ElecInvoiceUploadEstateSaleNew.class, (DynamicObject)((DynamicObject)estatesales.get(i)));
            if ("1".equals(((DynamicObject)estatesales.get(i)).getString("salecrosscitysign"))) {
                estateSaleNew.setKdsbz("Y");
            }
            if ("0".equals(((DynamicObject)estatesales.get(i)).getString("salecrosscitysign"))) {
                estateSaleNew.setKdsbz("N");
            }
            if (MathUtils.isNullOrZero(estateSaleNew.getHdjsjg())) {
                estateSaleNew.setHdjsjg(null);
            }
            if (MathUtils.isNullOrZero(estateSaleNew.getSjcjhsje())) {
                estateSaleNew.setSjcjhsje(null);
            }
            estateSaleNew.setXh(i + 1);
            estateSales.add(estateSaleNew);
        }
        if (StringUtils.isNotEmpty((CharSequence)coBuyerFlag) && "1".equals(coBuyerFlag)) {
            ((ElectInvoiceUploadEstateSaleRequest)issueInvoice).setDfgtgmbz("Y");
            ArrayList<ElecInvoiceUploadEstateSaleCoPurchaser> coPurchasers = new ArrayList<ElecInvoiceUploadEstateSaleCoPurchaser>(cobuyers.size());
            for (int i = 0; i < cobuyers.size(); ++i) {
                ElecInvoiceUploadEstateSaleCoPurchaser coPurchaser = (ElecInvoiceUploadEstateSaleCoPurchaser)DynamicObjectUtil.dynamicObject2Bean(ElecInvoiceUploadEstateSaleCoPurchaser.class, (DynamicObject)((DynamicObject)cobuyers.get(i)));
                coPurchasers.add(coPurchaser);
            }
            ((ElectInvoiceUploadEstateSaleRequest)issueInvoice).setGtgmfList(coPurchasers);
        } else {
            ((ElectInvoiceUploadEstateSaleRequest)issueInvoice).setDfgtgmbz("N");
            ((ElectInvoiceUploadEstateSaleRequest)issueInvoice).setGtgmfList(null);
        }
        List items = issueInvoice.getFpmxList();
        int estateXh = 0;
        for (int i = 0; i < items.size(); ++i) {
            if ("01".equals(((ElectInvoiceUploadItem)items.get(i)).getFphxz())) continue;
            if (StringUtils.isNotEmpty((CharSequence)((DynamicObject)estatesales.get(estateXh)).getString("saleunit"))) {
                ((ElectInvoiceUploadItem)items.get(i)).setDw(((DynamicObject)estatesales.get(estateXh)).getString("saleunit"));
            }
            ++estateXh;
        }
        ((ElectInvoiceUploadEstateSaleRequest)issueInvoice).setBdcxstdys(estateSales);
        invoice.set("lqversion", (Object)"1");
    }

    private static void buildSpecialTypeEsateLease(DynamicObject invoice, ElectInvoiceUploadRequest issueInvoice, ElectInvoiceUploadItem firstItem, String address, String provinceName, String cityName, String detailAddress, String kdsbz, String cqzsbh) {
        int i;
        DynamicObjectCollection estateLeases = invoice.getDynamicObjectCollection("estatesales");
        DynamicObjectCollection invoiceItems = invoice.getDynamicObjectCollection("items");
        String lqVersion = invoice.getString("lqversion");
        HashMap dateFormat = Maps.newHashMapWithExpectedSize((int)invoiceItems.size());
        for (int i2 = 0; i2 < invoiceItems.size(); ++i2) {
            if ("3040502020200000000".equals(((DynamicObject)invoiceItems.get(i2)).getString("goodscode"))) {
                dateFormat.put(i2, "yyyy-MM-dd HH:mm");
                continue;
            }
            dateFormat.put(i2, "yyyy-MM-dd");
        }
        if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
            DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])InvoiceQueryUtil.getInvoiceByCodeAndNo((String)invoice.getString("originalinvoicecode"), (String)invoice.getString("originalinvoiceno")).toArray());
            lqVersion = blueInvoice.getString("lqversion");
            boolean isInvoice = "sim_vatinvoice".equals(invoice.getDataEntityType().getName());
            if (CollectionUtils.isEmpty((Collection)estateLeases) && isInvoice) {
                estateLeases = blueInvoice.getDynamicObjectCollection("estatesales");
                DynamicObjectCollection redEstateLeases = invoice.getDynamicObjectCollection("estatesales");
                for (i = 0; i < estateLeases.size(); ++i) {
                    DynamicObject dynamicObject = redEstateLeases.addNew();
                    dynamicObject.set("saleestateid", ((DynamicObject)estateLeases.get(i)).get("saleestateid"));
                    dynamicObject.set("saleprincename", ((DynamicObject)estateLeases.get(i)).get("saleprincename"));
                    dynamicObject.set("salecityname", ((DynamicObject)estateLeases.get(i)).get("salecityname"));
                    dynamicObject.set("saledetailaddress", ((DynamicObject)estateLeases.get(i)).get("saledetailaddress"));
                    dynamicObject.set("salecrosscitysign", ((DynamicObject)estateLeases.get(i)).get("salecrosscitysign"));
                    dynamicObject.set("saleunit", ((DynamicObject)estateLeases.get(i)).get("saleunit"));
                    dynamicObject.set("leasestartdate", ((DynamicObject)estateLeases.get(i)).get("leasestartdate"));
                    dynamicObject.set("leaseenddate", ((DynamicObject)estateLeases.get(i)).get("leaseenddate"));
                    dynamicObject.set("carbrandno", ((DynamicObject)estateLeases.get(i)).get("carbrandno"));
                }
            }
        }
        if (CollectionUtils.isEmpty((Collection)estateLeases)) {
            DynamicObject leaseDynamicObject = estateLeases.addNew();
            leaseDynamicObject.set("saleestateid", (Object)invoice.getString("estatecode"));
            if (invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
                leaseDynamicObject.set("saledetailaddress", (Object)address);
            } else {
                leaseDynamicObject.set("saleprincename", (Object)provinceName);
                leaseDynamicObject.set("salecityname", (Object)cityName);
                leaseDynamicObject.set("saledetailaddress", (Object)detailAddress);
            }
            leaseDynamicObject.set("salecrosscitysign", (Object)kdsbz);
            leaseDynamicObject.set("saleestateid", (Object)cqzsbh);
            leaseDynamicObject.set("saleunit", (Object)invoice.getString("areaunit"));
            leaseDynamicObject.set("leasestartdate", (Object)invoice.getDate("startleasedate"));
            leaseDynamicObject.set("leaseenddate", (Object)invoice.getDate("endleasedate"));
        }
        firstItem.setDw(((DynamicObject)estateLeases.get(0)).getString("saleunit"));
        ArrayList<ElectInvoiceUploadEstateLease> lqEstateLeases = new ArrayList<ElectInvoiceUploadEstateLease>(estateLeases.size());
        for (int i3 = 0; i3 < estateLeases.size(); ++i3) {
            ElectInvoiceUploadEstateLease estateLease = (ElectInvoiceUploadEstateLease)DynamicObjectUtil.dynamicObject2Bean(ElectInvoiceUploadEstateLease.class, (DynamicObject)((DynamicObject)estateLeases.get(i3)));
            if (StringUtils.isEmpty((CharSequence)lqVersion) && invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) < 0) {
                estateLease.setBdczldzXxdz(address);
            } else {
                estateLease.setBdczldzS(((DynamicObject)estateLeases.get(i3)).getString("saleprincename"));
                estateLease.setBdczldzS1(((DynamicObject)estateLeases.get(i3)).getString("salecityname"));
                estateLease.setBdczldzXxdz(((DynamicObject)estateLeases.get(i3)).getString("saledetailaddress"));
            }
            estateLease.setZlqqz(DateUtils.format((Date)((DynamicObject)estateLeases.get(i3)).getDate("leasestartdate"), (String)((String)dateFormat.get(i3))) + " " + DateUtils.format((Date)((DynamicObject)estateLeases.get(i3)).getDate("leaseenddate"), (String)((String)dateFormat.get(i3))));
            estateLease.setKdsbz("1".equals(((DynamicObject)estateLeases.get(i3)).getString("salecrosscitysign")) ? "Y" : "N");
            estateLease.setCqzsbh(StringUtils.isBlank((CharSequence)((DynamicObject)estateLeases.get(i3)).getString("saleestateid")) ? "\u65e0" : ((DynamicObject)estateLeases.get(i3)).getString("saleestateid"));
            if (StringUtils.isEmpty((CharSequence)((DynamicObject)estateLeases.get(i3)).getString("carbrandno"))) {
                estateLease.setCph(null);
            } else {
                ArrayList<String> cphes = new ArrayList<String>(Arrays.asList(((DynamicObject)estateLeases.get(i3)).getString("carbrandno").split(",")));
                estateLease.setCph(cphes);
            }
            estateLease.setXh(i3 + 1);
            lqEstateLeases.add(estateLease);
        }
        ((ElectInvoiceUploadEstateLeaseRequest)issueInvoice).setBdcjyzltdys(lqEstateLeases);
        List items = issueInvoice.getFpmxList();
        int leaseXh = 0;
        for (i = 0; i < items.size(); ++i) {
            if ("01".equals(((ElectInvoiceUploadItem)items.get(i)).getFphxz())) continue;
            if (StringUtils.isNotEmpty((CharSequence)((DynamicObject)estateLeases.get(leaseXh)).getString("saleunit"))) {
                ((ElectInvoiceUploadItem)items.get(i)).setDw(((DynamicObject)estateLeases.get(leaseXh)).getString("saleunit"));
            }
            ++leaseXh;
        }
        invoice.set("lqversion", (Object)"1");
    }
}

