/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.common.service.issueinvoice.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.UnitTestHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RandomString;
import kd.imc.bdm.common.util.RequestUtils;
import kd.imc.sim.common.service.issueinvoice.impl.AbstractTGIssueInvoiceImpl;

public class HostModeIssueInvoiceImpl
extends AbstractTGIssueInvoiceImpl {
    public boolean support(DynamicObject invoice) {
        return EquipmentHelper.isHostModeDevice((String)invoice.getString("issuesource"));
    }

    public MsgResponse issue(DynamicObject invoice) {
        MsgResponse msgResponse = new MsgResponse();
        try {
            InvoiceUtils.cutTaxControlRemark((DynamicObject)invoice);
            this.initRequestData(invoice);
            JSONObject invoiceJSON = DynamicObjectUtil.dynamicObject2JsonContainItems((DynamicObject)invoice);
            String invoiceStr = SerializationUtils.toJsonString((Object)invoiceJSON);
            if (UnitTestHelper.isUnitTest()) {
                this.buildUnitTestData(msgResponse);
            } else {
                if (log.isInfoEnabled()) {
                    log.info(String.format("\u6d41\u6c34\u53f7\uff1a%s,\u7a0e\u53f7\uff1a%s,\u6cb3\u5317\u822a\u4fe1\u6258\u7ba1\u8bf7\u6c42\u5f00\u7968\u6570\u636e:%s", invoice.getString("orderno"), invoice.getString("salertaxno"), invoiceStr));
                }
                msgResponse = RequestUtils.doRequestTrusteeship((String)"HostModeOpenInvoice", (String)"openinvoice", (String)invoiceStr);
                if (log.isInfoEnabled()) {
                    log.info(String.format("\u6d41\u6c34\u53f7\uff1a%s,\u7a0e\u53f7\uff1a%s,\u6cb3\u5317\u822a\u4fe1\u6258\u7ba1\u5f00\u7968\u8fd4\u56de\u6570\u636e:%s", invoice.getString("orderno"), invoice.getString("salertaxno"), JSONObject.toJSONString((Object)msgResponse)));
                }
            }
            this.warpResponseData(invoice, msgResponse, "hbhx");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            msgResponse.setErrorCode("1111");
            msgResponse.setErrorMsg(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"HostModeIssueInvoiceImpl_0", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        return msgResponse;
    }

    private void initRequestData(DynamicObject invoice) {
        String area;
        String QD_BZ = invoice.getString("inventorymark");
        if ("08".equals(invoice.getString("specialtype"))) {
            QD_BZ = "4";
        }
        if ("hb".equals(area = ImcConfigUtil.getValue((String)"hotsmodeconfig", (String)"area"))) {
            boolean isRedInvoice = IssueType.RED_INVOICE.getTypeCode().equals(invoice.getString("issuetype"));
            if ("1".equals(QD_BZ)) {
                DynamicObjectCollection items = invoice.getDynamicObjectCollection("items");
                long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid"));
                boolean isRedInfo = InvoiceUtils.isRedInfo((DynamicObject)invoice);
                if (isRedInvoice) {
                    items.clear();
                    DynamicObjectCollection tempItems = isRedInfo ? this.getItemByRedInfo(invoice.getString("infocode"), orgId) : this.getItemByInvoice(invoice.getString("originalinvoicecode"), invoice.getString("originalinvoiceno"), orgId);
                    for (DynamicObject item : tempItems) {
                        DynamicObject dynamicObject = items.addNew();
                        DynamicObjectUtil.copyDynamicObject((DynamicObject)item, (DynamicObject)dynamicObject, (boolean)false);
                    }
                }
            }
        }
        invoice.set("inventorymark", (Object)QD_BZ);
        this.rewriteInvoice(invoice);
    }

    private DynamicObjectCollection getItemByInvoice(String invoiceCode, String invoiceNo, long orgId) {
        QFilter qFilter = new QFilter("invoicecode", "=", (Object)invoiceCode);
        qFilter.and("invoiceno", "=", (Object)invoiceNo);
        qFilter.and("orgid", "=", (Object)orgId);
        String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true);
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)selectProperties, (QFilter[])qFilter.toArray());
        if (null == invoice) {
            throw new KDBizException(ResManager.loadKDString((String)"\u539f\u53d1\u7968\u53d1\u7968\u4e91\u4e0d\u5b58\u5728", (String)"HostModeIssueInvoiceImpl_1", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        DynamicObjectCollection dynamicObjectCollection = invoice.getDynamicObjectCollection("items");
        for (DynamicObject item : dynamicObjectCollection) {
            item.set("tax", (Object)item.getBigDecimal("tax").negate());
            item.set("amount", (Object)item.getBigDecimal("amount").negate());
            item.set("num", (Object)item.getBigDecimal("num").negate());
            item.set("taxamount", (Object)item.getBigDecimal("taxamount").negate());
        }
        return dynamicObjectCollection;
    }

    private DynamicObjectCollection getItemByRedInfo(String infoCode, long orgId) {
        QFilter qFilter = new QFilter("infocode", "=", (Object)infoCode);
        qFilter.and("org", "=", (Object)orgId);
        String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_red_info", (boolean)true);
        DynamicObject redIfon = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)selectProperties, (QFilter[])qFilter.toArray());
        if (null == redIfon) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u53d1\u7968\u4e91\u4e0d\u5b58\u5728", (String)"HostModeIssueInvoiceImpl_2", (String)"imc-sim-common", (Object[])new Object[0]));
        }
        return redIfon.getDynamicObjectCollection("items");
    }

    private void buildUnitTestData(MsgResponse msgResponse) {
        JSONObject hostModeOpenInvoice = new JSONObject();
        hostModeOpenInvoice.put("invoicecode", (Object)RandomString.nextString((int)10, (boolean)true, (boolean)false));
        hostModeOpenInvoice.put("invoiceno", (Object)RandomString.nextString((int)8, (boolean)true, (boolean)false));
        hostModeOpenInvoice.put("issuetime", (Object)new Date());
        hostModeOpenInvoice.put("checkcode", (Object)("checkCode" + RandomString.nextString((int)10, (boolean)false, (boolean)false)));
        hostModeOpenInvoice.put("skm", (Object)("skm" + RandomString.nextString((int)10, (boolean)false, (boolean)false)));
        hostModeOpenInvoice.put("fileurl", (Object)("fileUrl" + RandomString.nextString((int)6, (boolean)false, (boolean)false)));
        hostModeOpenInvoice.put("jqbh", (Object)"661017057677");
        msgResponse.setErrorCode(ErrorType.SUCCESS.getCode());
        msgResponse.setRespData(hostModeOpenInvoice.toJSONString());
    }
}

