/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.mservice.bill.botp;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.dto.BillDetailVo;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.bdm.common.helper.CurrencyHelper;
import kd.imc.bdm.common.helper.DrawerStrategyHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.MaterialInfoUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.dto.goodsinfo.GoodsInfoBotpConfigDTO;
import kd.imc.sim.common.helper.InvTitleMatchHelper;
import kd.imc.sim.common.helper.MaterialToGoodsInfoHelp2;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.utils.TaxCalcUtil;
import kd.imc.sim.formplugin.bill.botp.MatchRulesEnum;
import kd.imc.sim.formplugin.match.BillMatchHelper;
import kd.imc.sim.mservice.bill.botp.BotpConvertService;
import kd.imc.sim.mservice.bill.botp.util.FiBill2OriginalBillCommonUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;

public class OBBotpConvertServiceImpl
implements BotpConvertService {
    private static Log LOGGER = LogFactory.getLog(OBBotpConvertServiceImpl.class);
    private static final String NOT_MATCH = "8";
    private static final String EMPTY_PRICE = "y";
    private static final String TRUE_CACHE = "1";
    private static final String FALSE_CACHE = "0";

    public Map<Object, DynamicObject> originalBillsBotpConvert(List<DynamicObject> originalBills) {
        if (CollectionUtils.isEmpty(originalBills)) {
            throw new KDBizException(ResManager.loadKDString((String)"botp\u4e0b\u63a8\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a", (String)"OBBotpConvertServiceImpl_0", (String)"imc-sim-mservice", (Object[])new Object[0]));
        }
        Map<Long, List<DynamicObject>> orgBills = originalBills.stream().collect(Collectors.groupingBy(k -> DynamicObjectUtil.getDynamicObjectLongValue((Object)k.get("orgid"))));
        orgBills.forEach((orgId, bills) -> this.originalBillBotpConvertBatch((Long)orgId, (List<DynamicObject>)bills, "OBBotpConvert" + UUID.randomUUID()));
        return originalBills.stream().collect(Collectors.toMap(k -> k.getString("billno"), v -> v, (v1, v2) -> v2));
    }

    public DynamicObject originalBillBotpConvert(DynamicObject originalBill) {
        ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(Collections.singletonList(originalBill));
        this.originalBillBotpConvertBatch(DynamicObjectUtil.getDynamicObjectLongValue((Object)originalBill.get("orgid")), bills, UUID.next());
        return originalBill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void originalBillBotpConvertBatch(Long orgId, List<DynamicObject> bills, String batchNo) {
        try {
            if (CollectionUtils.isEmpty(bills)) {
                throw new KDBizException(ResManager.loadKDString((String)"botp\u4e0b\u63a8\u53c2\u6570\u4e3a\u7a7a", (String)"OBBotpConvertServiceImpl_1", (String)"imc-sim-mservice", (Object[])new Object[0]));
            }
            if (orgId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u6570\u636e\u6ca1\u6709\u7ec4\u7ec7\uff0c\u8bf7\u5148\u914d\u7f6e\u7ec4\u7ec7", (String)"OBBotpConvertServiceImpl_2", (String)"imc-sim-mservice", (Object[])new Object[0]));
            }
            DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"epinfo", (QFilter[])new QFilter("id", "=", (Object)orgId).toArray());
            if (org == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u7684\u7ec4\u7ec7\u5728\u53d1\u7968\u4e91\u6ca1\u6709\u5f15\u5165\uff0c\u8bf7\u5148\u5f15\u5165", (String)"OBBotpConvertServiceImpl_3", (String)"imc-sim-mservice", (Object[])new Object[0]));
            }
            DynamicObject epInfo = org.getDynamicObject("epinfo");
            if (epInfo == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u7684\u7ec4\u7ec7\u8fd8\u672a\u5b8c\u5584\u4f01\u4e1a\u540d\u79f0\u3001\u7a0e\u53f7\u7b49\u4fe1\u606f\uff0c\u8bf7\u5148\u5230\u201c\u53d1\u7968\u4e91-\u57fa\u7840\u8d44\u6599-\u4f01\u4e1a\u7ba1\u7406\u201d\u5b8c\u5584\u8d44\u6599", (String)"OBBotpConvertServiceImpl_4", (String)"imc-sim-mservice", (Object[])new Object[0]));
            }
            BillMatchHelper billMatchHelper = new BillMatchHelper();
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            boolean needCalcute = BotpHelper.needReCalAmount();
            ArrayList<BillVo> billList = new ArrayList<BillVo>(bills.size());
            ArrayList<String> custNameList = new ArrayList<String>(bills.size());
            HashSet<Long> materialIdSet = new HashSet<Long>(bills.size());
            boolean isAllNoComplete = true;
            this.dealBuyerTaxNo(bills);
            for (DynamicObject bill : bills) {
                if (!CacheKeyEnum.JSON_LOG.getDefaultValue().equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.JSON_LOG))) {
                    LOGGER.info(String.format("billNo:%s,originalBillBotpConvertJson:%s", bill.getString("billno"), SerializationUtils.toJsonString((Object)bill)));
                }
                billList.add((BillVo)DynamicObjectUtil.dynamicObject2Bean(BillVo.class, (DynamicObject)bill));
                DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
                long seq = 0L;
                for (int i = 0; i < items.size(); ++i) {
                    DynamicObject item = (DynamicObject)items.get(i);
                    materialIdSet.add(DynamicObjectUtil.getDynamicObjectLongValue((Object)item.get("materielfield")));
                    if (i == 0) {
                        seq = item.getLong("seq");
                    }
                    item.set("seq", (Object)seq++);
                }
                custNameList.add(bill.getString("customname"));
                isAllNoComplete = isAllNoComplete && TRUE_CACHE.equals(bill.getString("billcomplete"));
            }
            HashMap<Long, List<DynamicObject>> multiUnitMap = new HashMap<Long, List<DynamicObject>>();
            this.initMaterialMap(materialIdSet, multiUnitMap);
            Map<String, DynamicObject> materialTypeMap = this.getMaterialTypeMap(materialIdSet, billList);
            stopWatch.split();
            LOGGER.info(String.format("botp\u67e5\u8be2\u7269\u6599\u8017\u65f6[%s]ms", stopWatch.getTime()));
            if (!isAllNoComplete) {
                MaterialToGoodsInfoHelp2.instanceMaterialInfoUtilByBillList2(billList, (long)orgId, (boolean)true);
                stopWatch.split();
                LOGGER.info(String.format("botp\u67e5\u8be2\u5f00\u7968\u9879\u8017\u65f6[%s]ms", stopWatch.getTime()));
            }
            Map<String, DynamicObject> buyerInfoMap = this.getBuyerInfoMap(custNameList, orgId);
            stopWatch.split();
            LOGGER.info(String.format("botp\u67e5\u8be2\u8d2d\u65b9\u8017\u65f6[%s]ms", stopWatch.getTime()));
            DynamicObject[] invoiceAddr = this.getInvoiceAddrArr(epInfo.getString("number"));
            stopWatch.split();
            LOGGER.info(String.format("botp\u67e5\u8be2\u9500\u65b9\u5730\u5740\u7535\u8bdd\u8017\u65f6[%s]ms", stopWatch.getTime()));
            DynamicObject[] remarkArr = billMatchHelper.getRemarkArr(orgId);
            Map remarkSchemeMap = billMatchHelper.getRemarkSchemeMap(remarkArr);
            stopWatch.split();
            LOGGER.info(String.format("botp\u67e5\u8be2\u5907\u6ce8\u8017\u65f6[%s]ms", stopWatch.getTime()));
            DynamicObject[] drawerStrategyArr = DrawerStrategyHelper.queryDrawerStrategyByOrg((Long)orgId);
            DynamicObject defaultDrawerStrategy = BusinessDataServiceHelper.newDynamicObject((String)"bdm_drawer_strategy");
            defaultDrawerStrategy.set("drawerstrategy", (Object)"1,1,1");
            stopWatch.split();
            LOGGER.info(String.format("botp\u67e5\u8be2\u5f00\u7968\u4eba\u8017\u65f6[%s]ms", stopWatch.getTime()));
            Map elePaperTaxNoMap = ImcConfigUtil.getValue((String)"elePaperInvoice");
            billMatchHelper.matchSplitOrMergeRule(orgId.longValue(), bills, "2");
            stopWatch.split();
            LOGGER.info(String.format("botp\u62c6\u5206\u5408\u5e76\u89c4\u5219\u5339\u914d\u8017\u65f6[%s]ms", stopWatch.getTime()));
            for (DynamicObject bill : bills) {
                this.setUnitExchangeRate(bill, multiUnitMap);
            }
            boolean isLogPushDetail = TRUE_CACHE.equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.LOG_BOTP_DETAIL));
            for (DynamicObject bill : bills) {
                boolean isDrawerMatch;
                boolean isBuyerMatch;
                boolean isGoodsMatch;
                String matchRules = bill.getString("botptype");
                GoodsInfoBotpConfigDTO botpConfigDTO = this.getGoodsInfoBotpConfigDTO(bill);
                this.setConstantData(bill);
                boolean bl = isGoodsMatch = null == botpConfigDTO || !NOT_MATCH.equals(botpConfigDTO.getGoodsConfig());
                if (!TRUE_CACHE.equals(bill.getString("billcomplete"))) {
                    if (needCalcute) {
                        this.calculate(bill, botpConfigDTO);
                    } else {
                        this.onlyCalculateCombineAmount(bill);
                    }
                    matchRules = this.getMatchRules(bill, matchRules, batchNo);
                    if (isGoodsMatch) {
                        DynamicObject fromCurr = bill.getDynamicObject("fromcurr");
                        DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
                        int precision = 2;
                        int pricePrecision = 8;
                        if (null != fromCurr) {
                            precision = fromCurr.getInt("amtprecision");
                            pricePrecision = fromCurr.getInt("priceprecision");
                        }
                        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)bill.getString("invoicetype")) || TRUE_CACHE.equals(bill.getString("iselepaper"));
                        ArrayList errMsgList = Lists.newArrayListWithCapacity((int)items.size());
                        for (int i = 0; i < items.size(); ++i) {
                            String msg;
                            DynamicObject item = (DynamicObject)items.get(i);
                            String itemName = item.getString("origoodsname");
                            String number = item.getString("spbm");
                            DynamicObject materialDO = materialTypeMap.get(itemName + ":" + number);
                            if (Objects.nonNull(materialDO)) {
                                if (isLogPushDetail) {
                                    LOGGER.info(String.format("OBBotpConvertServiceImpl originalBillBotpConvert goodsname:%s, goodscode:%s,materialDO:%s", itemName, item.getString("spbm"), SerializationUtils.toJsonString((Object)materialDO)));
                                }
                                item.set("materialtype", (Object)materialDO.getDynamicObject("group"));
                            }
                            if (StringUtils.isNotBlank((CharSequence)(msg = FiBill2OriginalBillCommonUtil.setDetailTax(bill, item, matchRules, botpConfigDTO, precision, pricePrecision, isLogPushDetail, isAllEle))) && "2".equals(item.getString("rowtype"))) {
                                errMsgList.add(msg);
                            }
                            if (i != 0 || !StringUtils.isBlank((CharSequence)bill.getString("specialtype"))) continue;
                            boolean isTobaccoGoods = TaxUtils.isTobaccoGoods((String)item.getString("goodscode"));
                            if (isTobaccoGoods) {
                                bill.set("specialtype", (Object)"11");
                                continue;
                            }
                            bill.set("specialtype", (Object)"00");
                        }
                        if (!CollectionUtils.isEmpty((Collection)errMsgList)) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7269\u6599/\u8d39\u7528\u9879\u76ee\u672a\u914d\u7f6e\u53d1\u7968\u4e91\u5f00\u7968\u9879\uff0c\u5339\u914d\u7c7b\u578b[%1$s]\uff0c\u8bf7\u524d\u5f80[\u53d1\u7968\u4e91] -[\u57fa\u7840\u8d44\u6599] -[\u5f00\u7968\u9879\u7ba1\u7406] \u914d\u7f6e%2$s%3$s", (String)"OBBotpConvertServiceImpl_5", (String)"imc-sim-mservice", (Object[])new Object[0]), MatchRulesEnum.getValueByCode((String)matchRules).getValue(), System.lineSeparator(), errMsgList.stream().distinct().collect(Collectors.joining(System.lineSeparator()))));
                        }
                    }
                }
                BotpHelper.dealBillPushFields((DynamicObject)bill, (boolean)BotpHelper.isFromArFiOrArInv((Object)bill.getString("systemsource")));
                if (MatchRulesEnum.MATCH_EXPENSE_ITEM.getCode().equals(matchRules)) {
                    bill.set("producttype", (Object)"3");
                } else {
                    bill.set("producttype", (Object)"2");
                }
                String systemSource = bill.getString("systemsource");
                boolean bl2 = isBuyerMatch = null == botpConfigDTO || !NOT_MATCH.equals(botpConfigDTO.getBuyerConfig());
                if (this.isNeedMatch(systemSource) && isBuyerMatch) {
                    if (StringUtils.equals((CharSequence)bill.getString("buyerproperty"), (CharSequence)TRUE_CACHE)) {
                        if (!InvTitleMatchHelper.checkBuyerInfoByPerson((Object)bill)) {
                            LOGGER.info("OBBotp\u63a8\u5355\u5339\u914d\u4e2a\u4eba\u4fe1\u606f...");
                            FiBill2OriginalBillCommonUtil.setBuyerInfoForPerson(orgId, bill.getString("customname"), bill, new BillVo());
                        }
                    } else {
                        DynamicObject buyer = buyerInfoMap.get(bill.getString("customname"));
                        if (buyer != null) {
                            bill.set("buyername", (Object)buyer.getString("name"));
                            bill.set("buyertaxno", (Object)buyer.getString("taxno"));
                            String buyerEmail = bill.getString("buyeremail");
                            String buyerPhone = bill.getString("buyerphone");
                            billMatchHelper.matchBuyerAddrAndBank(bill, buyer.getDynamicObjectCollection("items"));
                            if (StringUtils.isNotBlank((CharSequence)buyerPhone)) {
                                bill.set("buyerphone", (Object)buyerPhone);
                            }
                            if (StringUtils.isNotBlank((CharSequence)buyerEmail)) {
                                bill.set("buyeremail", (Object)buyerEmail);
                            }
                            if (StringUtils.isBlank((CharSequence)bill.getString("buyerproperty"))) {
                                if (StringUtils.isNotBlank((CharSequence)bill.getString("buyertaxno"))) {
                                    bill.set("buyerproperty", (Object)FALSE_CACHE);
                                } else {
                                    bill.set("buyerproperty", (Object)TRUE_CACHE);
                                }
                            }
                        }
                    }
                }
                if (null == botpConfigDTO || !NOT_MATCH.equals(botpConfigDTO.getSalerConfig())) {
                    bill.set("salertaxno", epInfo.get("number"));
                    bill.set("salername", epInfo.get("name"));
                    billMatchHelper.matchSalerAddrAndBank(bill, invoiceAddr);
                }
                this.setDefaultDev(bill, orgId, batchNo);
                boolean bl3 = isDrawerMatch = null == botpConfigDTO || !NOT_MATCH.equals(botpConfigDTO.getDrawerConfig());
                if (this.isNeedMatch(systemSource) && isDrawerMatch) {
                    String drawer = bill.getString("drawer");
                    String payee = bill.getString("payee");
                    String reviewer = bill.getString("reviewer");
                    billMatchHelper.matchDrawer(bill, drawerStrategyArr, defaultDrawerStrategy);
                    if (StringUtils.isNotBlank((CharSequence)drawer)) {
                        bill.set("drawer", (Object)drawer);
                    }
                    if (StringUtils.isNotBlank((CharSequence)payee)) {
                        bill.set("payee", (Object)payee);
                    }
                    if (StringUtils.isNotBlank((CharSequence)reviewer)) {
                        bill.set("reviewer", (Object)reviewer);
                    }
                }
                if (!(remarkArr.length == 0 || null != botpConfigDTO && NOT_MATCH.equals(botpConfigDTO.getRemarkConfig()))) {
                    billMatchHelper.matchRemark(bill, remarkArr, remarkSchemeMap);
                }
                if (InvoiceUtils.isPaperInvoice((String)bill.getString("invoicetype")) && TRUE_CACHE.equals(elePaperTaxNoMap.get(bill.getString("salertaxno")))) {
                    bill.set("iselepaper", (Object)TRUE_CACHE);
                    continue;
                }
                bill.set("iselepaper", (Object)FALSE_CACHE);
            }
            stopWatch.stop();
            LOGGER.info(String.format("botp\u67e5\u8be2\u5339\u914d\u603b\u8017\u65f6:[%s]ms", stopWatch.getTime()));
        }
        finally {
            MaterialInfoUtil.clear();
        }
    }

    private void dealBuyerTaxNo(List<DynamicObject> bills) {
        try {
            HashSet<Long> buyerPks = new HashSet<Long>();
            for (DynamicObject bill : bills) {
                String buyerTaxNo = bill.getString("buyertaxno");
                try {
                    long pk = Long.parseLong(buyerTaxNo);
                    buyerPks.add(pk);
                }
                catch (Exception pk) {}
            }
            if (buyerPks.size() == 0) {
                LOGGER.info("pkTaxNoMapSize:0");
                return;
            }
            HashMap<String, String> pkTaxNoMap = new HashMap<String, String>();
            this.getPkTaxNoMap(buyerPks, pkTaxNoMap);
            LOGGER.info("pkTaxNoMap" + JSONObject.toJSONString(pkTaxNoMap));
            for (DynamicObject bill : bills) {
                String buyerTaxNo = bill.getString("buyertaxno");
                if (!pkTaxNoMap.containsKey(buyerTaxNo)) continue;
                bill.set("buyertaxno", (Object)pkTaxNoMap.get(buyerTaxNo));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void getPkTaxNoMap(HashSet<Long> buyerPks, HashMap<String, String> pkTaxNoMap) {
        this.queryFromCustomers(buyerPks, pkTaxNoMap);
        Set<Long> filterdSet = buyerPks.stream().filter(o -> !pkTaxNoMap.containsKey(String.valueOf(o))).collect(Collectors.toSet());
        if (filterdSet.size() == 0) {
            return;
        }
        this.queryFromSupplier(pkTaxNoMap, filterdSet);
        filterdSet = buyerPks.stream().filter(o -> !pkTaxNoMap.containsKey(String.valueOf(o))).collect(Collectors.toSet());
        this.queryFromUsers(pkTaxNoMap, filterdSet);
    }

    private void queryFromUsers(HashMap<String, String> pkTaxNoMap, Set<Long> filterdSet) {
        if (filterdSet.size() > 0) {
            Map users = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id", (QFilter[])new QFilter("id", "in", filterdSet).toArray());
            for (Map.Entry entry : users.entrySet()) {
                pkTaxNoMap.put(String.valueOf(entry.getKey()), null);
            }
        }
    }

    private void queryFromCustomers(HashSet<Long> buyerPks, HashMap<String, String> pkTaxNoMap) {
        String customerKey = "tx_register_no,bizpartner_address,bizpartner_phone, entry_bank, entry_bank.bankaccount,societycreditcode, entry_bank.bank, entry_bank.isdefault_bank,invoicecustomerid,type";
        Map customers = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (String)customerKey, (QFilter[])new QFilter("id", "in", buyerPks).toArray());
        if (customers.size() > 0) {
            for (Map.Entry entry : customers.entrySet()) {
                DynamicObject asstact;
                DynamicObject customer = (DynamicObject)entry.getValue();
                DynamicObject invoiceCustomer = customer.getDynamicObject("invoicecustomerid");
                if (null == invoiceCustomer) {
                    asstact = customer;
                } else {
                    Object pkValue = invoiceCustomer.getPkValue();
                    if (customers.containsKey(pkValue)) {
                        asstact = (DynamicObject)customers.get(pkValue);
                    } else {
                        Map queryInvoiceCustomer = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (String)customerKey, (QFilter[])new QFilter("id", "=", pkValue).toArray());
                        asstact = (DynamicObject)queryInvoiceCustomer.get(pkValue);
                    }
                }
                String txRegisterNo = null;
                if (null != asstact && StringUtils.isBlank((CharSequence)(txRegisterNo = asstact.getString("tx_register_no")))) {
                    txRegisterNo = asstact.getString("societycreditcode");
                }
                pkTaxNoMap.put(String.valueOf(entry.getKey()), txRegisterNo);
            }
        }
    }

    private void queryFromSupplier(HashMap<String, String> pkTaxNoMap, Set<Long> filterdSet) {
        String supplierKeys = "tx_register_no,bizpartner_address,bizpartner_phone, entry_bank, entry_bank.bankaccount,societycreditcode, entry_bank.bank, entry_bank.isdefault_bank,invoicesupplierid,type";
        Map suppliers = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)supplierKeys, (QFilter[])new QFilter("id", "in", filterdSet).toArray());
        if (suppliers.size() > 0) {
            for (Map.Entry entry : suppliers.entrySet()) {
                DynamicObject asstact;
                DynamicObject customer = (DynamicObject)entry.getValue();
                DynamicObject invoiceCustomer = customer.getDynamicObject("invoicesupplierid");
                if (null == invoiceCustomer) {
                    asstact = customer;
                } else {
                    Object pkValue = invoiceCustomer.getPkValue();
                    if (suppliers.containsKey(pkValue)) {
                        asstact = (DynamicObject)suppliers.get(pkValue);
                    } else {
                        Map queryInvoiceCustomer = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)supplierKeys, (QFilter[])new QFilter("id", "=", pkValue).toArray());
                        asstact = (DynamicObject)queryInvoiceCustomer.get(pkValue);
                    }
                }
                String txRegisterNo = null;
                if (null != asstact && StringUtils.isBlank((CharSequence)(txRegisterNo = asstact.getString("tx_register_no")))) {
                    txRegisterNo = asstact.getString("societycreditcode");
                }
                pkTaxNoMap.put(String.valueOf(entry.getKey()), txRegisterNo);
            }
        }
    }

    private void initMaterialMap(Set<Long> materialIdSet, HashMap<Long, List<DynamicObject>> materialMap) {
        if (materialIdSet.size() == 0) {
            return;
        }
        QFilter qFilter = new QFilter("materialid", "in", (Object)materialIdSet.toArray());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_multimeasureunit", (String)"id,materialid,measureunitid,denominator,numerator", (QFilter[])qFilter.toArray());
        for (Map.Entry entry : map.entrySet()) {
            DynamicObject materialUnit = (DynamicObject)entry.getValue();
            long materialPk = materialUnit.getDynamicObject("materialid").getLong("id");
            if (!materialMap.containsKey(materialPk)) {
                materialMap.put(materialPk, new ArrayList());
            }
            List<DynamicObject> materialUnitlist = materialMap.get(materialPk);
            materialUnitlist.add(materialUnit);
        }
    }

    private void setUnitExchangeRate(DynamicObject bill, HashMap<Long, List<DynamicObject>> materialMap) {
        DynamicObjectCollection items = bill.getDynamicObjectCollection("sim_original_bill_item");
        for (DynamicObject tgtEntryRow : items) {
            if (TRUE_CACHE.equals(tgtEntryRow.getString("rowtype"))) {
                tgtEntryRow.set("unitfield", null);
                continue;
            }
            DynamicObject unit = tgtEntryRow.getDynamicObject("unitfield");
            DynamicObject material = tgtEntryRow.getDynamicObject("materielfield");
            tgtEntryRow.set("orimodelnumrate", (Object)1);
            tgtEntryRow.set("CURRENTMODELNUMRATE", (Object)1);
            if (null != unit && null != material) {
                Object unitPk = unit.getPkValue();
                DynamicObject matchedMeasureUnit = null;
                if (null != (matchedMeasureUnit = this.getDynamicObject(materialMap, material, unitPk, matchedMeasureUnit))) {
                    String modelNumRate = MaterialInfoUtil.getModelNumRate((DynamicObject)matchedMeasureUnit);
                    tgtEntryRow.set("orimodelnumrate", (Object)BigDecimalUtil.transDecimal((Object)modelNumRate));
                    tgtEntryRow.set("CURRENTMODELNUMRATE", (Object)BigDecimalUtil.transDecimal((Object)modelNumRate));
                }
            }
            tgtEntryRow.set("modelnumrate", (Object)1);
        }
    }

    private DynamicObject getDynamicObject(HashMap<Long, List<DynamicObject>> materialMap, DynamicObject material, Object unitPk, DynamicObject matchedMeasureUnit) {
        List<DynamicObject> units = materialMap.get(material.getLong("id"));
        if (units == null) {
            return null;
        }
        for (DynamicObject measureunit : units) {
            DynamicObject measureUnit;
            if (null == measureunit || null == (measureUnit = measureunit.getDynamicObject("measureunitid")) || !measureUnit.getPkValue().equals(unitPk)) continue;
            return measureunit;
        }
        return matchedMeasureUnit;
    }

    private void onlyCalculateCombineAmount(DynamicObject originalBill) {
        DynamicObjectCollection items = originalBill.getDynamicObjectCollection("sim_original_bill_item");
        DynamicObject fromCurrency = originalBill.getDynamicObject("fromcurr");
        boolean isFrom = CurrencyHelper.isFrom((Object)fromCurrency);
        int size = items.size();
        int amtPrecision = fromCurrency.getInt("amtprecision");
        boolean isNoTax = FALSE_CACHE.equals(originalBill.getString("hsbz"));
        boolean isRecalc = false;
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal totalFromAmount = BigDecimal.ZERO;
        BigDecimal totalFromTax = BigDecimal.ZERO;
        for (int i = 0; i < size; ++i) {
            DynamicObject item = (DynamicObject)items.get(i);
            String rowType = item.getString("rowtype");
            BigDecimal itemTaxAmount = item.getBigDecimal("taxamount");
            if (TRUE_CACHE.equals(rowType)) {
                BigDecimal calcTax;
                BigDecimal tax = item.getBigDecimal("tax");
                if (tax.subtract(calcTax = TaxCalcUtil.calTax((BigDecimal)itemTaxAmount, (BigDecimal)BigDecimal.ZERO, (String)item.getString("taxrate"), (boolean)true)).abs().compareTo(InvoiceConstant.DIFFF_06) >= 0) {
                    item.set("tax", (Object)calcTax);
                    item.set("amount", (Object)itemTaxAmount.subtract(calcTax));
                    item.set("remainvalidtax", (Object)calcTax);
                    if (isNoTax) {
                        item.set("remainvalidamount", item.get("amount"));
                    }
                    isRecalc = true;
                    if (isFrom) {
                        BigDecimal fromTaxAmount = item.getBigDecimal("fromtaxamount");
                        BigDecimal fromTax = TaxCalcUtil.calTax((BigDecimal)fromTaxAmount, (BigDecimal)BigDecimal.ZERO, (String)item.getString("taxrate"), (boolean)true, (int)amtPrecision);
                        BigDecimal fromAmount = fromTaxAmount.subtract(fromTax);
                        item.set("fromamount", (Object)fromAmount);
                        item.set("fromtax", (Object)fromTax);
                    }
                }
                item.set("combinenum", (Object)BigDecimal.ZERO);
                item.set("combineamount", (Object)BigDecimal.ZERO);
                item.set("combinelocalamount", (Object)BigDecimal.ZERO);
            }
            BigDecimal combineAmount = item.getBigDecimal("combineamount");
            if (!isFrom) {
                this.resetCombineAmount(items, size, i, item, rowType, itemTaxAmount, combineAmount);
                item.set("combinelocalamount", item.get("combineamount"));
            }
            invoiceAmount = invoiceAmount.add(item.getBigDecimal("amount"));
            totalTax = totalTax.add(item.getBigDecimal("tax"));
            totalFromAmount = totalFromAmount.add(item.getBigDecimal("fromamount"));
            totalFromTax = totalFromTax.add(item.getBigDecimal("fromtax"));
        }
        if (isRecalc) {
            originalBill.set("totaltax", (Object)totalTax);
            originalBill.set("surplustax", (Object)totalTax);
            originalBill.set("invoiceamount", (Object)invoiceAmount);
            originalBill.set("surplusamount", (Object)invoiceAmount);
            originalBill.set("foreigntax", (Object)totalFromTax);
            originalBill.set("foreigninvoiceamount", (Object)totalFromAmount);
            originalBill.set("foreigntotalamount", (Object)totalFromTax.add(totalFromAmount));
        }
    }

    private Map<String, DynamicObject> getMaterialTypeMap(Set<Long> materialIdSet, List<BillVo> billList) {
        QFilter idFilter = OrgHelper.getIdFilter(materialIdSet);
        Map materialMap = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"number,name,group", (QFilter[])idFilter.toArray());
        HashMap<String, DynamicObject> materialTypeMap = new HashMap<String, DynamicObject>(materialMap.size());
        HashMap<String, DynamicObject> materialNumberMap = new HashMap<String, DynamicObject>(materialMap.size());
        for (Map.Entry entry : materialMap.entrySet()) {
            DynamicObject material = (DynamicObject)entry.getValue();
            String number = material.getString("number");
            String name = material.getString("name");
            materialTypeMap.put(name + ':' + number, material);
            materialNumberMap.put(number, material);
        }
        for (BillVo billVo : billList) {
            List billDetailVos = billVo.getBillDetail();
            for (BillDetailVo item : billDetailVos) {
                DynamicObject group;
                DynamicObject material = (DynamicObject)materialTypeMap.get(item.getGoodsName() + ":" + item.getGoodsCode());
                DynamicObject goodsCodeMaterial = (DynamicObject)materialNumberMap.get(item.getGoodsCode());
                if (material != null) {
                    group = material.getDynamicObject("group");
                    if (group == null) continue;
                    item.setMaterialType(group.getString("number"));
                    continue;
                }
                if (goodsCodeMaterial == null || (group = goodsCodeMaterial.getDynamicObject("group")) == null) continue;
                item.setMaterialType(group.getString("number"));
            }
        }
        return materialTypeMap;
    }

    private Map<String, DynamicObject> getBuyerInfoMap(List<String> custNameList, Long orgId) {
        DynamicObject[] buyerInfoItemArr;
        QFilter baseDataFilter = ImcBaseDataHelper.getInvTitleFilter((Object)orgId);
        QFilter epNameFilter = new QFilter("name", "in", custNameList);
        QFilter custNameQfilter = new QFilter("cust.customername", "in", custNameList);
        DynamicObject[] buyerInfoArr = BusinessDataServiceHelper.load((String)"bdm_invice_title_strate", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_invice_title_strate", (boolean)true), (QFilter[])new QFilter[]{baseDataFilter, epNameFilter});
        Map<String, DynamicObject> buyerInfoMap = Arrays.stream(buyerInfoArr).collect(Collectors.toMap(k -> k.getString("name"), v -> v, (v1, v2) -> v1));
        for (DynamicObject buyerInfoItem : buyerInfoItemArr = BusinessDataServiceHelper.load((String)"bdm_invice_title_strate", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_invice_title_strate", (boolean)true), (QFilter[])new QFilter[]{baseDataFilter, custNameQfilter})) {
            DynamicObjectCollection items = buyerInfoItem.getDynamicObjectCollection("cust");
            for (DynamicObject item : items) {
                String custName = item.getString("customername");
                buyerInfoMap.putIfAbsent(custName, buyerInfoItem);
            }
        }
        return buyerInfoMap;
    }

    private DynamicObject[] getInvoiceAddrArr(String taxno) {
        QFilter qFilter = new QFilter("taxno", "=", (Object)taxno);
        return BusinessDataServiceHelper.load((String)"sim_invoice_setting", (String)String.join((CharSequence)",", "taxno", "invoiceaddr", "openuserbank", "filter_tag", "ischeck", "shop_no"), (QFilter[])qFilter.toArray());
    }

    private String getMatchRules(DynamicObject originalBill, String matchRules, String batchNo) {
        boolean exists;
        if (MatchRulesEnum.DEFAULT.getCode().equals(matchRules) || MatchRulesEnum.MATCH_TYPE_NAME.getCode().equals(matchRules) || MatchRulesEnum.MATCH_TYPE_SOURCE.getCode().equals(matchRules)) {
            return matchRules;
        }
        DynamicObjectCollection items = originalBill.getDynamicObjectCollection("sim_original_bill_item");
        if (items.size() > 0) {
            try {
                DynamicObject firstRow = (DynamicObject)items.get(0);
                Object expense = firstRow.get("expenseitem");
                Object material = firstRow.get("materielfield");
                if (null != expense && null == material) {
                    LOGGER.info("getMatchRulesfromItem");
                    originalBill.set("botptype", (Object)MatchRulesEnum.MATCH_EXPENSE_ITEM.getCode());
                    return MatchRulesEnum.MATCH_EXPENSE_ITEM.getCode();
                }
                if (null == expense && null != material) {
                    LOGGER.info("getMatchRulesfromItem2");
                    return matchRules;
                }
            }
            catch (Exception e) {
                LOGGER.error("getMatchRules" + e.getMessage(), (Throwable)e);
            }
        }
        if (exists = this.isExpenseBillExist(originalBill, batchNo)) {
            originalBill.set("botptype", (Object)MatchRulesEnum.MATCH_EXPENSE_ITEM.getCode());
            matchRules = MatchRulesEnum.MATCH_EXPENSE_ITEM.getCode();
        }
        return matchRules;
    }

    private boolean isExpenseBillExist(DynamicObject originalBill, String batchNo) {
        QFilter filter;
        boolean exists;
        String pushBillName = originalBill.getString("pushbillname");
        String cacheKey = batchNo + pushBillName + "judgeItemType";
        String cacheValue = CacheHelper.get((String)cacheKey);
        if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
            if (TRUE_CACHE.equalsIgnoreCase(cacheValue)) {
                return true;
            }
            if (FALSE_CACHE.equalsIgnoreCase(cacheValue)) {
                return false;
            }
        }
        CacheHelper.put((String)cacheKey, (String)((exists = QueryServiceHelper.exists((String)"sim_bill_type", (QFilter[])(filter = new QFilter("billname", "=", (Object)pushBillName).and("goodstype", "=", (Object)TRUE_CACHE)).toArray())) ? TRUE_CACHE : FALSE_CACHE), (int)60);
        return exists;
    }

    private void setDefaultDev(DynamicObject originalBill, Long orgId, String batchNo) {
        if (StringUtils.isNotBlank((CharSequence)originalBill.getString("jqbh"))) {
            return;
        }
        String cacheKey = "setDefaultDev" + batchNo + orgId;
        String cacheDefaultDev = CacheHelper.get((String)cacheKey);
        if (StringUtils.isBlank((CharSequence)cacheDefaultDev)) {
            boolean isDevEnable;
            String devNo = OrgHelper.getDefaultDevFromCache((Long)orgId, (String)batchNo);
            String salerTaxNo = originalBill.getString("salertaxno");
            if (StringUtils.isNotBlank((CharSequence)devNo) && (isDevEnable = EquipmentHelper.isBatchEnablefromCache((String)salerTaxNo, (String)devNo, (String)batchNo))) {
                originalBill.set("jqbh", (Object)devNo);
                CacheHelper.put((String)cacheKey, (String)devNo, (int)300);
            }
        } else {
            originalBill.set("jqbh", (Object)cacheDefaultDev);
        }
    }

    private void calculate(DynamicObject originalBill, GoodsInfoBotpConfigDTO botpConfigDTO) {
        DynamicObjectCollection items = originalBill.getDynamicObjectCollection("sim_original_bill_item");
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal totalFromAmount = BigDecimal.ZERO;
        BigDecimal totalFromTax = BigDecimal.ZERO;
        String hsbz = originalBill.getString("hsbz");
        DynamicObject fromCurrency = originalBill.getDynamicObject("fromcurr");
        boolean isFrom = CurrencyHelper.isFrom((Object)fromCurrency);
        int amtPrecision = fromCurrency.getInt("amtprecision");
        int pricePrecision = fromCurrency.getInt("priceprecision");
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)originalBill.getString("invoicetype")) || TRUE_CACHE.equals(originalBill.getString("iselepaper"));
        int size = items.size();
        for (int i = 0; i < items.size(); ++i) {
            DynamicObject item = (DynamicObject)items.get(i);
            BigDecimal fromPrice = BigDecimal.ZERO;
            BigDecimal fromTaxPrice = BigDecimal.ZERO;
            BigDecimal taxUnitPrice = BigDecimal.ZERO;
            BigDecimal unitPrice = BigDecimal.ZERO;
            String rowType = item.getString("rowtype");
            String benchMark = item.getString("benchmark");
            if (!TRUE_CACHE.equals(benchMark) && !FALSE_CACHE.equals(benchMark)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u57fa\u51c6\u7c7b\u578b\u672a\u4f20\u503c", (String)"OBBotpConvertServiceImpl_6", (String)"imc-sim-mservice", (Object[])new Object[0]));
            }
            BigDecimal itemTaxAmount = item.getBigDecimal("taxamount");
            String rateStr = item.getString("taxrate");
            BigDecimal num = TRUE_CACHE.equals(item.get("benchmark")) ? (itemTaxAmount.compareTo(BigDecimal.ZERO) >= 0 ? BigDecimal.ONE : BigDecimal.ONE.negate()) : item.getBigDecimal("num");
            BigDecimal combineAmount = item.getBigDecimal("combineamount");
            if (!isFrom) {
                this.resetCombineAmount(items, size, i, item, rowType, itemTaxAmount, combineAmount);
            }
            BigDecimal taxRateValue = new BigDecimal(rateStr);
            BigDecimal addTaxRate = BigDecimal.ONE.add(taxRateValue);
            BigDecimal itemAmount = itemTaxAmount.divide(addTaxRate, 2, RoundingMode.HALF_UP);
            BigDecimal itemTax = itemTaxAmount.subtract(itemAmount);
            if (this.isUsefulNum(num)) {
                unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)itemAmount, (BigDecimal)num, (boolean)isAllEle);
                taxUnitPrice = PriceHelper.calcPriceOrNum((BigDecimal)itemTaxAmount, (BigDecimal)num, (boolean)isAllEle);
                fromPrice = unitPrice;
                fromTaxPrice = taxUnitPrice;
            }
            BigDecimal fromAmount = itemAmount;
            BigDecimal fromTaxAmount = itemTaxAmount;
            BigDecimal fromTax = itemTax;
            if (isFrom) {
                fromTaxAmount = item.getBigDecimal("fromtaxamount");
                fromAmount = fromTaxAmount.divide(addTaxRate, amtPrecision, RoundingMode.HALF_UP);
                fromTax = fromTaxAmount.subtract(fromAmount);
                if (this.isUsefulNum(num)) {
                    fromPrice = fromAmount.divide(num, pricePrecision, RoundingMode.HALF_UP);
                    fromTaxPrice = fromTaxAmount.divide(num, pricePrecision, RoundingMode.HALF_UP);
                }
            }
            item.set("amount", (Object)itemAmount);
            item.set("tax", (Object)itemTax);
            item.set("orifromtaxamount", (Object)fromTaxAmount);
            item.set("oritaxamount", (Object)itemAmount);
            item.set("fromamount", (Object)fromAmount);
            item.set("fromtax", (Object)fromTax);
            item.set("fromtaxamount", (Object)fromTaxAmount);
            if (!TRUE_CACHE.equals(rowType)) {
                item.set("taxunitprice", (Object)taxUnitPrice);
                item.set("unitprice", (Object)unitPrice);
                item.set("fromprice", (Object)fromPrice);
                item.set("fromtaxprice", (Object)fromTaxPrice);
            }
            if (TRUE_CACHE.equals(hsbz)) {
                item.set("remainvalidamount", (Object)itemTaxAmount);
            } else {
                item.set("remainvalidamount", (Object)itemAmount);
            }
            item.set("remainvalidtax", (Object)itemTax);
            if (EMPTY_PRICE.equalsIgnoreCase(botpConfigDTO.getEmptyPrice())) {
                this.emptyPriceAndNum(item);
            }
            if (TRUE_CACHE.equals(rowType)) {
                item.set("combinenum", (Object)BigDecimal.ZERO);
            }
            invoiceAmount = invoiceAmount.add(item.getBigDecimal("amount"));
            totalTax = totalTax.add(item.getBigDecimal("tax"));
            totalFromAmount = totalFromAmount.add(item.getBigDecimal("fromamount"));
            totalFromTax = totalFromTax.add(item.getBigDecimal("fromtax"));
            if (isFrom) continue;
            item.set("combinelocalamount", item.get("combineamount"));
        }
        BigDecimal totalAmount = invoiceAmount.add(totalTax);
        originalBill.set("totalamount", (Object)totalAmount);
        originalBill.set("oldtotalamount", (Object)totalAmount);
        originalBill.set("totaltax", (Object)totalTax);
        originalBill.set("surplustax", (Object)totalTax);
        originalBill.set("invoiceamount", (Object)invoiceAmount);
        originalBill.set("surplusamount", (Object)invoiceAmount);
        originalBill.set("foreigntax", (Object)totalFromTax);
        originalBill.set("foreigninvoiceamount", (Object)totalFromAmount);
        originalBill.set("foreigntotalamount", (Object)totalFromTax.add(totalFromAmount));
    }

    private void resetCombineAmount(DynamicObjectCollection items, int size, int i, DynamicObject item, String rowType, BigDecimal itemTaxAmount, BigDecimal combineAmount) {
        boolean isCurrentNormalRow = "2".equals(rowType);
        if (isCurrentNormalRow && i + 1 < size && TRUE_CACHE.equals(((DynamicObject)items.get(i + 1)).getString("rowtype"))) {
            DynamicObject nextRow = (DynamicObject)items.get(i + 1);
            BigDecimal nextTaxAmount = nextRow.getBigDecimal("taxamount");
            if (combineAmount.subtract(nextTaxAmount.add(itemTaxAmount)).abs().compareTo(new BigDecimal("0.02")) > 0) {
                item.set("combineamount", (Object)nextTaxAmount.add(itemTaxAmount));
            }
        } else if (isCurrentNormalRow && combineAmount.subtract(itemTaxAmount).abs().compareTo(new BigDecimal("0.02")) > 0) {
            item.set("combineamount", (Object)item.getBigDecimal("taxamount"));
        }
    }

    private boolean isUsefulNum(BigDecimal num) {
        return null != num && BigDecimal.ZERO.compareTo(num) != 0;
    }

    public void setConstantData(DynamicObject originalBill) {
        FiBill2OriginalBillCommonUtil.setConstantData(originalBill);
    }

    private void emptyPriceAndNum(DynamicObject item) {
        item.set("taxunitprice", (Object)BigDecimal.ZERO);
        item.set("unitprice", (Object)BigDecimal.ZERO);
        item.set("num", (Object)BigDecimal.ZERO);
        item.set("remainvalidnum", (Object)BigDecimal.ZERO);
        item.set("fromprice", (Object)BigDecimal.ZERO);
        item.set("fromtaxprice", (Object)BigDecimal.ZERO);
    }

    private GoodsInfoBotpConfigDTO getGoodsInfoBotpConfigDTO(DynamicObject originalBill) {
        String jsonStr = originalBill.getString("botpparamconfig");
        try {
            if (StringUtils.isBlank((CharSequence)jsonStr)) {
                return null;
            }
            jsonStr = '{' + jsonStr.replace("and", ",").replace('=', ':') + '}';
            return (GoodsInfoBotpConfigDTO)JSONObject.parseObject((String)jsonStr, GoodsInfoBotpConfigDTO.class);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"BOTP\u53d6\u503c\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5Botp\u4e0b\u63a8\u53c2\u6570\u914d\u7f6e", (String)"OBBotpConvertServiceImpl_7", (String)"imc-sim-mservice", (Object[])new Object[0]));
        }
    }

    private boolean isNeedMatch(String systemCode) {
        return !"OCPOS_SALEORDER".equals(systemCode) && !"OCPOS_SALEORDER_RETURN".equals(systemCode);
    }
}

