/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.mservice.bill.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.IssueType;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import org.apache.commons.lang3.StringUtils;

public class SimBillRelationInvoiceImpl {
    private static Log logger = LogFactory.getLog(SimBillRelationInvoiceImpl.class);

    public String queryBillInvRelation(List<String> serialNoList) {
        return this.queryBillInvRelation(serialNoList, 0);
    }

    public String queryBillInvRelation(List<String> serialNoList, int dealType) {
        boolean logSwitch = "1".equals(ImcConfigUtil.getValue((String)"Query_Bill_Inv_Relation", (String)"Print_Log_Switch"));
        JSONObject returnObject = new JSONObject();
        returnObject.put("code", (Object)ApiErrCodeEnum.ERROR.getCode());
        if (CollectionUtils.isEmpty(serialNoList)) {
            returnObject.put("msg", (Object)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"BillRelationInvoiceImpl_0", (String)"imc-sim-mservice", (Object[])new Object[0]));
            return returnObject.toJSONString();
        }
        int count = 0;
        for (String serialNo : serialNoList) {
            if (!StringUtils.isBlank((CharSequence)serialNo)) continue;
            ++count;
        }
        if (count > 0) {
            returnObject.put("msg", (Object)String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u7684\u6d41\u6c34\u53f7\u96c6\u5408\u4e2d\u6709:%s\u4e2a\u4e3a\u7a7a!", (String)"BillRelationInvoiceImpl_4", (String)"imc-sim-mservice", (Object[])new Object[0]), count));
            return returnObject.toJSONString();
        }
        int maxNum = this.getQueryMaxNum();
        if (serialNoList.size() > this.getQueryMaxNum()) {
            returnObject.put("msg", (Object)String.format(ResManager.loadKDString((String)"\u8bf7\u6c42\u7684\u6d41\u6c34\u53f7\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7:%s", (String)"BillRelationInvoiceImpl_1", (String)"imc-sim-mservice", (Object[])new Object[0]), maxNum));
            return returnObject.toJSONString();
        }
        QFilter qFilter = new QFilter("orderno", "in", serialNoList);
        String selectProperties = String.join((CharSequence)",", "id", "billno", "issuetype", "invoicetype", "infocode", "invoiceno", "invoicecode", "buyertype", "originalinvoiceno", "originalinvoicecode", "items.id");
        DynamicObject[] invoiceObjects = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)selectProperties, (QFilter[])qFilter.toArray());
        if (invoiceObjects == null || invoiceObjects.length == 0) {
            returnObject.put("msg", (Object)ResManager.loadKDString((String)"\u5f53\u524d\u6d41\u6c34\u53f7\u672a\u5339\u914d\u5230\u4efb\u4f55\u6570\u636e!", (String)"BillRelationInvoiceImpl_2", (String)"imc-sim-mservice", (Object[])new Object[0]));
            return returnObject.toJSONString();
        }
        JSONArray jsonArray = new JSONArray();
        for (DynamicObject invoiceObject : invoiceObjects) {
            String billNo = invoiceObject.getString("billno");
            String issueType = invoiceObject.getString("issuetype");
            DynamicObject[] billInvoiceRelations = IssueType.BLUE_INVOICE.getTypeCode().equals(issueType) ? this.getBlueInvoiceRelationBillMethod(invoiceObject, logSwitch) : this.getRedInvoiceRelationBillMethod(invoiceObject, logSwitch);
            if (logSwitch) {
                logger.info("\u53d1\u7968\u5355\u636e\u53f7:{}\uff0c\u5bf9\u5e94\u7684\u5355\u636e\u53d1\u7968\u5173\u7cfb\u7684\u6570\u91cf\uff1a{}", (Object)billNo, (Object)(billInvoiceRelations == null ? 0 : billInvoiceRelations.length));
            }
            boolean isExist = true;
            if (!(billInvoiceRelations != null && billInvoiceRelations.length != 0 || (billInvoiceRelations = this.getInvoiceRelationBillByFillIn(invoiceObject, logSwitch)) != null && billInvoiceRelations.length != 0)) {
                isExist = false;
            }
            if (dealType == 0) {
                if (isExist) {
                    this.createBillRelationInvoiceDataMethod(jsonArray, billInvoiceRelations);
                    continue;
                }
                this.createInvoiceDataMethod(jsonArray, invoiceObject);
                continue;
            }
            if (dealType != 1) continue;
            if (isExist) {
                this.createBillRelationInvoiceHeaderMethod(jsonArray, billInvoiceRelations);
                continue;
            }
            this.createInvoiceDataHeaderMethod(jsonArray, invoiceObject);
        }
        if (logSwitch) {
            logger.info("\u67e5\u8be2\u7684\u6570\u636e\u5185\u5bb9data:{}", (Object)jsonArray.toJSONString());
        }
        returnObject.put("code", (Object)ApiErrCodeEnum.OK.getCode());
        returnObject.put("msg", (Object)ResManager.loadKDString((String)"\u6210\u529f", (String)"BillRelationInvoiceImpl_3", (String)"imc-sim-mservice", (Object[])new Object[0]));
        returnObject.put("data", (Object)jsonArray);
        return returnObject.toJSONString();
    }

    private int getQueryMaxNum() {
        String queryMaxNum = ImcConfigUtil.getValue((String)"Query_Bill_Inv_Relation_Max", (String)"Query_Bill_Inv_Relation_Max");
        int maxNum = 100;
        if (StringUtils.isNotBlank((CharSequence)queryMaxNum)) {
            maxNum = Integer.parseInt(queryMaxNum);
        }
        return maxNum;
    }

    private void createInvoiceDataHeaderMethod(JSONArray jsonArray, DynamicObject invoiceObject) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("invoiceId", invoiceObject.getPkValue());
        JSONArray subArray = new JSONArray();
        JSONObject subObject = new JSONObject();
        subObject.put("simOriginalBillId", (Object)0L);
        subArray.add((Object)subObject);
        jsonObject.put("billInvoiceRelations", (Object)subArray);
        jsonArray.add((Object)jsonObject);
    }

    private void createBillRelationInvoiceHeaderMethod(JSONArray jsonArray, DynamicObject[] billInvoiceRelations) {
        ConcurrentHashMap<Long, ArrayList<DynamicObject>> billInvoiceRelationMap = new ConcurrentHashMap<Long, ArrayList<DynamicObject>>(billInvoiceRelations.length);
        for (DynamicObject billInvoiceRelation : billInvoiceRelations) {
            ArrayList<DynamicObject> subList;
            Long invoiceId = billInvoiceRelation.getLong("tbillid");
            if (billInvoiceRelationMap.containsKey(invoiceId)) {
                subList = (ArrayList<DynamicObject>)billInvoiceRelationMap.get(invoiceId);
                subList.add(billInvoiceRelation);
                continue;
            }
            subList = new ArrayList<DynamicObject>(billInvoiceRelations.length);
            subList.add(billInvoiceRelation);
            billInvoiceRelationMap.put(invoiceId, subList);
        }
        for (Map.Entry entry : billInvoiceRelationMap.entrySet()) {
            Long invoiceId = (Long)entry.getKey();
            List subList = (List)entry.getValue();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("invoiceId", (Object)invoiceId);
            HashSet<Long> simOriginalBillIdSet = new HashSet<Long>(subList.size());
            for (DynamicObject billInvoiceRelation : subList) {
                Long simOriginalBillId = billInvoiceRelation.getLong("sbillid");
                simOriginalBillIdSet.add(simOriginalBillId);
            }
            JSONArray subArray = new JSONArray();
            for (Long aLong : simOriginalBillIdSet) {
                JSONObject subObject = new JSONObject();
                subObject.put("simOriginalBillId", (Object)aLong);
                subArray.add((Object)subObject);
            }
            jsonObject.put("billInvoiceRelations", (Object)subArray);
            jsonArray.add((Object)jsonObject);
        }
    }

    private void createInvoiceDataMethod(JSONArray jsonArray, DynamicObject invoiceObject) {
        DynamicObjectCollection invoiceItemCollection = invoiceObject.getDynamicObjectCollection("items");
        for (DynamicObject invoiceItem : invoiceItemCollection) {
            JSONObject jsonObject = new JSONObject();
            Long invoiceEntryId = invoiceItem.getLong("id");
            jsonObject.put("invoiceEntryId", (Object)invoiceEntryId);
            JSONArray subArray = new JSONArray();
            JSONObject subObject = new JSONObject();
            subObject.put("invoiceId", (Object)String.valueOf(invoiceObject.getPkValue()));
            subObject.put("simOriginalBillEntryId", (Object)0L);
            subObject.put("simOriginalBillId", (Object)0L);
            subObject.put("simOriginalBillEntryPriceTax", (Object)BigDecimal.ZERO);
            subArray.add((Object)subObject);
            jsonObject.put("billInvoiceRelations", (Object)subArray);
            jsonArray.add((Object)jsonObject);
        }
    }

    private void createBillRelationInvoiceDataMethod(JSONArray jsonArray, DynamicObject[] billInvoiceRelations) {
        ConcurrentHashMap<Long, List<DynamicObject>> billInvoiceRelationMap = new ConcurrentHashMap<Long, List<DynamicObject>>(billInvoiceRelations.length);
        this.dealGroupBillInvoiceRelationMethod(billInvoiceRelationMap, billInvoiceRelations);
        for (Map.Entry entryObject : billInvoiceRelationMap.entrySet()) {
            JSONObject jsonObject = new JSONObject();
            Long invoiceEntryId = (Long)entryObject.getKey();
            jsonObject.put("invoiceEntryId", (Object)invoiceEntryId);
            JSONArray subArray = new JSONArray();
            List subList = (List)entryObject.getValue();
            for (DynamicObject billInvoiceRelation : subList) {
                JSONObject subObject = new JSONObject();
                Long invoiceId = billInvoiceRelation.getLong("tbillid");
                Long simOriginalBillEntryId = billInvoiceRelation.getLong("sdetailid");
                Long simOriginalBillId = billInvoiceRelation.getLong("sbillid");
                BigDecimal simOriginalBillEntryPriceTax = billInvoiceRelation.getBigDecimal("amount").add(billInvoiceRelation.getBigDecimal("tax"));
                subObject.put("invoiceId", (Object)String.valueOf(invoiceId));
                subObject.put("simOriginalBillEntryId", (Object)String.valueOf(simOriginalBillEntryId));
                subObject.put("simOriginalBillId", (Object)String.valueOf(simOriginalBillId));
                subObject.put("simOriginalBillEntryPriceTax", (Object)simOriginalBillEntryPriceTax.setScale(2, 4));
                subArray.add((Object)subObject);
            }
            jsonObject.put("billInvoiceRelations", (Object)subArray);
            jsonArray.add((Object)jsonObject);
        }
    }

    private DynamicObject[] getInvoiceRelationBillByFillIn(DynamicObject invoiceObject, boolean logSwitch) {
        Long invoiceId = invoiceObject.getLong("id");
        String invoiceNo = invoiceObject.getString("invoiceno");
        if (logSwitch) {
            logger.info("getInvoiceRelationBillByFillIn, invoiceId:{}, invoiceNo:{}", (Object)invoiceId, (Object)invoiceNo);
        }
        QFilter qFilter = new QFilter("invoiceid", "=", (Object)String.valueOf(invoiceId)).and("invoiceno", "=", (Object)invoiceNo);
        String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_add_invoice");
        DynamicObject[] billAddInvoices = BusinessDataServiceHelper.load((String)"sim_bill_add_invoice", (String)selectProperties, (QFilter[])qFilter.toArray());
        if (billAddInvoices != null && billAddInvoices.length > 0) {
            DynamicObjectCollection billInvoiceRelationCollection = new DynamicObjectCollection();
            for (DynamicObject billAddInvoice : billAddInvoices) {
                DynamicObjectCollection invoiceItemCollection = invoiceObject.getDynamicObjectCollection("items");
                for (DynamicObject invoiceItem : invoiceItemCollection) {
                    DynamicObject billInvoiceRelation = BusinessDataServiceHelper.newDynamicObject((String)"sim_bill_inv_relation");
                    billInvoiceRelation.set("tdetailid", (Object)invoiceItem.getLong("id"));
                    billInvoiceRelation.set("tbillid", (Object)billAddInvoice.getString("invoiceid"));
                    billInvoiceRelation.set("sbillid", (Object)billAddInvoice.getString("originalbillid"));
                    billInvoiceRelation.set("sdetailid", (Object)billAddInvoice.getString("billdetailid"));
                    billInvoiceRelation.set("amount", (Object)billAddInvoice.getBigDecimal("invoiceamount"));
                    billInvoiceRelation.set("tax", (Object)billAddInvoice.getBigDecimal("totaltax"));
                    billInvoiceRelationCollection.add((Object)billInvoiceRelation);
                }
            }
            if (logSwitch) {
                logger.info("getInvoiceRelationBillByFillIn, \u53d1\u7968\u56de\u586b\u5199\u6a21\u5f0f, billInvoiceRelations\u5927\u5c0f:{}", (Object)billInvoiceRelationCollection.size());
            }
            return (DynamicObject[])billInvoiceRelationCollection.toArray((Object[])new DynamicObject[0]);
        }
        return null;
    }

    private void dealGroupBillInvoiceRelationMethod(Map<Long, List<DynamicObject>> billInvoiceRelationMap, DynamicObject[] billInvoiceRelations) {
        for (DynamicObject billInvoiceRelation : billInvoiceRelations) {
            List<DynamicObject> subList;
            Long tDetailId = billInvoiceRelation.getLong("tdetailid");
            if (billInvoiceRelationMap.containsKey(tDetailId)) {
                subList = billInvoiceRelationMap.get(tDetailId);
                subList.add(billInvoiceRelation);
                continue;
            }
            subList = new ArrayList<DynamicObject>(billInvoiceRelations.length);
            subList.add(billInvoiceRelation);
            billInvoiceRelationMap.put(tDetailId, subList);
        }
    }

    private DynamicObject[] getRedInvoiceRelationBillMethod(DynamicObject invoiceObject, boolean logSwitch) {
        String invoiceType = invoiceObject.getString("invoicetype");
        DynamicObject[] billInvoiceRelations = InvoiceUtils.isAllEInvoice((Object)invoiceType) ? this.getRedInvoiceRelationBillByRedConfirm(invoiceObject, logSwitch) : (InvoiceUtils.isSpecialInvoice((String)invoiceType) ? this.getRedInvoiceRelationBillByRedInfo(invoiceObject, logSwitch) : this.getRedInvoiceRelationBillByPaper(invoiceObject, logSwitch));
        return billInvoiceRelations;
    }

    private DynamicObject[] getRedInvoiceRelationBillByPaper(DynamicObject invoiceObject, boolean logSwitch) {
        DynamicObject[] billInvoiceRelations = null;
        String buyerType = invoiceObject.getString("buyertype");
        if ("0".equals(buyerType)) {
            String originalInvoiceNo = invoiceObject.getString("originalinvoiceno");
            String originalInvoiceCode = invoiceObject.getString("originalinvoicecode");
            if (StringUtils.isBlank((CharSequence)originalInvoiceNo)) {
                return new DynamicObject[0];
            }
            QFilter qFilter = new QFilter("invoiceno", "=", (Object)originalInvoiceNo).and("invoicecode", "=", (Object)originalInvoiceCode);
            DynamicObject blueInvoiceObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id", (QFilter[])qFilter.toArray());
            if (blueInvoiceObject != null) {
                Long blueInvoiceId = blueInvoiceObject.getLong("id");
                QFilter billRelationInvFilter = new QFilter("tbillid", "=", (Object)blueInvoiceId);
                String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation", (boolean)true);
                billInvoiceRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)selectProperties, (QFilter[])billRelationInvFilter.toArray());
                this.dealConvertBillRelationInvoiceMethod(invoiceObject, billInvoiceRelations);
            }
            if (logSwitch) {
                logger.info("getRedInvoiceRelationBillByPaper, \u5355\u5f20\u5f00\u7968\u6a21\u5f0f, billInvoiceRelations\u5927\u5c0f:{}", (Object)(billInvoiceRelations == null ? 0 : billInvoiceRelations.length));
            }
        } else if ("4".equals(buyerType)) {
            Long invoiceId = invoiceObject.getLong("id");
            QFilter billRelationInvFilter = new QFilter("tbillid", "=", (Object)invoiceId);
            String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation", (boolean)true);
            billInvoiceRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)selectProperties, (QFilter[])billRelationInvFilter.toArray());
            if (logSwitch) {
                logger.info("getRedInvoiceRelationBillByPaper, \u5355\u636e\u62c6\u5206\u6a21\u5f0f, billInvoiceRelations\u5927\u5c0f:{}", (Object)(billInvoiceRelations == null ? 0 : billInvoiceRelations.length));
            }
        }
        return billInvoiceRelations;
    }

    private DynamicObject[] getRedInvoiceRelationBillByRedInfo(DynamicObject invoiceObject, boolean logSwitch) {
        DynamicObject[] billInvoiceRelations = new DynamicObject[]{};
        String infoCode = invoiceObject.getString("infocode");
        if (StringUtils.isBlank((CharSequence)infoCode)) {
            return billInvoiceRelations;
        }
        QFilter redInfoFilter = new QFilter("infocode", "=", (Object)infoCode);
        String selectProperties = String.join((CharSequence)",", "id", "infosource", "originalinvoicecode", "originalinvoiceno");
        DynamicObject redInfoObject = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)selectProperties, (QFilter[])redInfoFilter.toArray());
        if (redInfoObject != null) {
            String infoSource = redInfoObject.getString("infosource");
            if ("1".equals(infoSource)) {
                String originalInvoiceCode = redInfoObject.getString("originalinvoicecode");
                String originalInvoiceNo = redInfoObject.getString("originalinvoiceno");
                QFilter blueInvoiceFilter = new QFilter("invoiceno", "=", (Object)originalInvoiceNo).and("invoicecode", "=", (Object)originalInvoiceCode);
                DynamicObject blueInvoiceObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id", (QFilter[])blueInvoiceFilter.toArray());
                if (blueInvoiceObject != null) {
                    Long blueInvoiceId = blueInvoiceObject.getLong("id");
                    QFilter billRelationInvFilter = new QFilter("tbillid", "=", (Object)blueInvoiceId);
                    selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation", (boolean)true);
                    billInvoiceRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)selectProperties, (QFilter[])billRelationInvFilter.toArray());
                    this.dealConvertBillRelationInvoiceMethod(invoiceObject, billInvoiceRelations);
                }
                if (logSwitch) {
                    logger.info("getRedInvoiceRelationBillByRedInfo, \u624b\u5de5\u5f00\u7968\u6a21\u5f0f, billInvoiceRelations\u5927\u5c0f:{}", (Object)(billInvoiceRelations == null ? 0 : billInvoiceRelations.length));
                }
            } else if ("5".equals(infoSource)) {
                Long redInfoId = redInfoObject.getLong("id");
                QFilter billRelationInvFilter = new QFilter("tbillid", "=", (Object)redInfoId);
                selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation", (boolean)true);
                billInvoiceRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)selectProperties, (QFilter[])billRelationInvFilter.toArray());
                if (logSwitch) {
                    logger.info("getRedInvoiceRelationBillByRedInfo, \u5355\u636e\u5f00\u7968\u6a21\u5f0f, billInvoiceRelations\u5927\u5c0f:{}", (Object)(billInvoiceRelations == null ? 0 : billInvoiceRelations.length));
                }
            }
        }
        return billInvoiceRelations;
    }

    private DynamicObject[] getRedInvoiceRelationBillByRedConfirm(DynamicObject invoiceObject, boolean logSwitch) {
        String infoCode = invoiceObject.getString("infocode");
        if (logSwitch) {
            logger.info("getRedInvoiceRelationBillByRedConfirm, infoCode:{}", (Object)infoCode);
        }
        DynamicObject[] billInvoiceRelations = new DynamicObject[]{};
        if (StringUtils.isBlank((CharSequence)infoCode)) {
            return billInvoiceRelations;
        }
        QFilter redConfirmFilter = new QFilter("number", "=", (Object)infoCode);
        String selectProperties = String.join((CharSequence)",", "id", "source", "originalinvoiceno", "items.originalinvoiceitemid");
        DynamicObject redConfirmObject = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)selectProperties, (QFilter[])redConfirmFilter.toArray());
        if (redConfirmObject != null) {
            String source = redConfirmObject.getString("source");
            if (logSwitch) {
                logger.info("getRedInvoiceRelationBillByRedConfirm, source:{}", (Object)source);
            }
            if ("1".equals(source)) {
                String originalInvoiceNo = redConfirmObject.getString("originalinvoiceno");
                QFilter blueInvoiceFilter = new QFilter("invoiceno", "=", (Object)originalInvoiceNo);
                DynamicObject blueInvoiceObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id", (QFilter[])blueInvoiceFilter.toArray());
                if (blueInvoiceObject != null) {
                    List<Long> originalDetailIdList = this.getOriginalDetailIdMethod(redConfirmObject);
                    Long blueInvoiceId = blueInvoiceObject.getLong("id");
                    QFilter billRelationInvFilter = new QFilter("tbillid", "=", (Object)blueInvoiceId).and("tdetailid", "in", originalDetailIdList);
                    selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation", (boolean)true);
                    billInvoiceRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)selectProperties, (QFilter[])billRelationInvFilter.toArray());
                    this.dealConvertBillRelationInvoiceMethod(invoiceObject, billInvoiceRelations);
                }
                if (logSwitch) {
                    logger.info("getRedInvoiceRelationBillByRedConfirm, \u624b\u5de5\u65b0\u589e\u6a21\u5f0f, billInvoiceRelations\u5927\u5c0f:{}", (Object)(billInvoiceRelations == null ? 0 : billInvoiceRelations.length));
                }
            } else if ("5".equals(source)) {
                Long redConfirmId = (Long)redConfirmObject.getPkValue();
                QFilter billRelationInvFilter = new QFilter("tbillid", "=", (Object)redConfirmId);
                selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation", (boolean)true);
                billInvoiceRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)selectProperties, (QFilter[])billRelationInvFilter.toArray());
                if (billInvoiceRelations != null && billInvoiceRelations.length > 0) {
                    boolean flag = false;
                    for (DynamicObject billInvoiceRelation : billInvoiceRelations) {
                        String targetTableType = billInvoiceRelation.getString("ttable");
                        if (!"sim_red_confirm_bill".equals(targetTableType)) continue;
                        flag = true;
                        break;
                    }
                    if (flag) {
                        billInvoiceRelations = this.dealRedInvoiceRelationMethodByBill(invoiceObject, billInvoiceRelations, logSwitch);
                    }
                }
                if (logSwitch) {
                    logger.info("getRedInvoiceRelationBillByRedConfirm, \u5355\u636e\u62c6\u5408\u6a21\u5f0f, billInvoiceRelations\u5927\u5c0f:{}", (Object)(billInvoiceRelations == null ? 0 : billInvoiceRelations.length));
                }
            } else if ("10".equals(source)) {
                QFilter invRelationFilter = new QFilter("tbillid", "=", redConfirmObject.getPkValue());
                String properties = String.join((CharSequence)",", "sbillid", "tbillid", "sdetailid", "tdetailid", "ssubdetailid");
                DynamicObject[] invRelations = BusinessDataServiceHelper.load((String)"sim_match_inv_relation", (String)properties, (QFilter[])invRelationFilter.toArray());
                if (invRelations != null && invRelations.length > 0) {
                    if (logSwitch) {
                        logger.info("getRedInvoiceRelationBillByRedConfirm, \u5339\u914d\u7ed3\u679c\u5927\u5c0f:{}", (Object)invRelations.length);
                    }
                    billInvoiceRelations = this.dealGetBillInvoiceRelationMethod(invRelations, invoiceObject, logSwitch);
                }
                if (logSwitch) {
                    logger.info("getRedInvoiceRelationBillByRedConfirm, \u5339\u914d\u7ed3\u679c\u6a21\u5f0f, billInvoiceRelations\u5927\u5c0f:{}", (Object)(billInvoiceRelations == null ? 0 : billInvoiceRelations.length));
                }
            }
        }
        return billInvoiceRelations;
    }

    private void dealConvertBillRelationInvoiceMethod(DynamicObject redInvoiceObject, DynamicObject[] billInvoiceRelations) {
        DynamicObjectCollection invoiceItemCollection;
        HashMap<Long, ArrayList<DynamicObject>> billInvoiceRelationMap = new HashMap<Long, ArrayList<DynamicObject>>(billInvoiceRelations.length);
        if (billInvoiceRelations != null && billInvoiceRelations.length > 0) {
            for (DynamicObject billInvoiceRelation : billInvoiceRelations) {
                ArrayList<DynamicObject> subList;
                Long tDetailId = billInvoiceRelation.getLong("tdetailid");
                if (billInvoiceRelationMap.containsKey(tDetailId)) {
                    subList = (ArrayList<DynamicObject>)billInvoiceRelationMap.get(tDetailId);
                    subList.add(billInvoiceRelation);
                    continue;
                }
                subList = new ArrayList<DynamicObject>(billInvoiceRelations.length);
                subList.add(billInvoiceRelation);
                billInvoiceRelationMap.put(tDetailId, subList);
            }
        }
        if ((invoiceItemCollection = redInvoiceObject.getDynamicObjectCollection("items")).size() == billInvoiceRelationMap.size()) {
            int idx = 0;
            for (Map.Entry entryObject : billInvoiceRelationMap.entrySet()) {
                List subList = (List)entryObject.getValue();
                for (DynamicObject billInvoiceRelation : subList) {
                    DynamicObject invoiceItem = (DynamicObject)invoiceItemCollection.get(idx);
                    billInvoiceRelation.set("tbillid", redInvoiceObject.getPkValue());
                    billInvoiceRelation.set("tdetailid", invoiceItem.getPkValue());
                }
                ++idx;
            }
        }
    }

    private DynamicObject[] dealGetBillInvoiceRelationMethod(DynamicObject[] invRelations, DynamicObject invoiceObject, boolean logSwitch) {
        DynamicObjectCollection billInvoiceRelationMatchCollection = new DynamicObjectCollection();
        DynamicObjectCollection billInvoiceRelationNoMatchCollection = new DynamicObjectCollection();
        HashSet<String> invRelationSet = new HashSet<String>(invRelations.length);
        for (DynamicObject invRelation : invRelations) {
            Long sourceBillId = invRelation.getLong("sbillid");
            Long sourceDetailId = invRelation.getLong("sdetailid");
            Long sourceSubDetailId = invRelation.getLong("ssubdetailid");
            String key = sourceBillId + "-" + sourceDetailId + "-" + sourceSubDetailId;
            invRelationSet.add(key);
        }
        for (String key : invRelationSet) {
            DynamicObject billInvoiceRelation;
            DynamicObject[] billMatchRelations;
            String[] array = key.split("-");
            Long sourceBillId = Long.parseLong(array[0]);
            Long sourceDetailId = Long.parseLong(array[1]);
            Long sourceSubDetailId = Long.parseLong(array[2]);
            QFilter matchFilter = new QFilter("id", "=", (Object)sourceBillId);
            DynamicObject matchBillObject = BusinessDataServiceHelper.loadSingle((String)"sim_match_bill", (String)"=", (QFilter[])matchFilter.toArray());
            if (matchBillObject == null) continue;
            Long matchBillId = (Long)matchBillObject.getPkValue();
            String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_matchbill_relation");
            QFilter matchBillFilter = new QFilter("tbillid", "=", (Object)matchBillId);
            if (sourceSubDetailId != null && sourceSubDetailId > 0L) {
                billMatchRelations = BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)selectProperties, (QFilter[])(matchBillFilter = matchBillFilter.and("tdetailid", "=", (Object)sourceDetailId)).toArray());
                if (billMatchRelations == null || billMatchRelations.length <= 0) continue;
                for (DynamicObject billMatchRelation : billMatchRelations) {
                    billInvoiceRelation = BusinessDataServiceHelper.newDynamicObject((String)"sim_bill_inv_relation");
                    billInvoiceRelation.set("tdetailid", (Object)billMatchRelation.getLong("tdetailid"));
                    billInvoiceRelation.set("tbillid", (Object)billMatchRelation.getString("tbillid"));
                    billInvoiceRelation.set("sbillid", (Object)billMatchRelation.getString("sbillid"));
                    billInvoiceRelation.set("sdetailid", (Object)billMatchRelation.getString("sdetailid"));
                    billInvoiceRelation.set("amount", (Object)billMatchRelation.getBigDecimal("amount"));
                    billInvoiceRelation.set("tax", (Object)billMatchRelation.getBigDecimal("tax"));
                    billInvoiceRelationMatchCollection.add((Object)billInvoiceRelation);
                }
                continue;
            }
            billMatchRelations = BusinessDataServiceHelper.load((String)"sim_matchbill_relation", (String)selectProperties, (QFilter[])matchBillFilter.toArray());
            if (billMatchRelations == null || billMatchRelations.length <= 0) continue;
            for (DynamicObject billMatchRelation : billMatchRelations) {
                billInvoiceRelation = BusinessDataServiceHelper.newDynamicObject((String)"sim_bill_inv_relation");
                billInvoiceRelation.set("tdetailid", (Object)0L);
                billInvoiceRelation.set("tbillid", (Object)billMatchRelation.getString("tbillid"));
                billInvoiceRelation.set("sbillid", (Object)billMatchRelation.getString("sbillid"));
                billInvoiceRelation.set("sdetailid", (Object)0L);
                billInvoiceRelation.set("amount", (Object)BigDecimal.ZERO);
                billInvoiceRelation.set("tax", (Object)BigDecimal.ZERO);
                billInvoiceRelationNoMatchCollection.add((Object)billInvoiceRelation);
            }
        }
        if (logSwitch) {
            logger.info("dealGetBillInvoiceRelationMethod, billInvoiceRelationMatchCollection:{}, billInvoiceRelationNoMatchCollection:{}", (Object)billInvoiceRelationMatchCollection.size(), (Object)billInvoiceRelationNoMatchCollection.size());
        }
        if (!billInvoiceRelationMatchCollection.isEmpty()) {
            return this.getBillInvoiceRelationByMatch(billInvoiceRelationMatchCollection, invoiceObject, logSwitch);
        }
        if (!billInvoiceRelationNoMatchCollection.isEmpty()) {
            return this.getBillInvoiceRelationByNoMatch(billInvoiceRelationNoMatchCollection, invoiceObject, logSwitch);
        }
        return null;
    }

    private DynamicObject[] getBillInvoiceRelationByNoMatch(DynamicObjectCollection billInvoiceRelationNoMatchCollection, DynamicObject invoiceObject, boolean logSwitch) {
        DynamicObject[] billInvoiceRelations;
        DynamicObjectCollection invoiceItemCollection = invoiceObject.getDynamicObjectCollection("items");
        if (invoiceItemCollection == null || invoiceItemCollection.isEmpty()) {
            return null;
        }
        if (logSwitch) {
            logger.info("getBillInvoiceRelationByNoMatch, invoiceItemCollection\u5927\u5c0f:{}", (Object)invoiceItemCollection.size());
        }
        for (DynamicObject billInvoiceRelation : billInvoiceRelations = (DynamicObject[])billInvoiceRelationNoMatchCollection.toArray((Object[])new DynamicObject[0])) {
            billInvoiceRelation.set("tbillid", invoiceObject.getPkValue());
        }
        return billInvoiceRelations;
    }

    private DynamicObject[] getBillInvoiceRelationByMatch(DynamicObjectCollection billInvoiceRelationCollection, DynamicObject invoiceObject, boolean logSwitch) {
        if (!billInvoiceRelationCollection.isEmpty()) {
            DynamicObjectCollection invoiceItemCollection = invoiceObject.getDynamicObjectCollection("items");
            if (invoiceItemCollection == null || invoiceItemCollection.isEmpty()) {
                return null;
            }
            if (logSwitch) {
                logger.info("getBillInvoiceRelationByMatch, invoiceItemCollection\u5927\u5c0f:{}", (Object)invoiceItemCollection.size());
            }
            Long[] invoiceEntryIds = new Long[invoiceItemCollection.size()];
            int idx = 0;
            for (DynamicObject invoiceItem : invoiceItemCollection) {
                Long invoiceEntryId;
                invoiceEntryIds[idx] = invoiceEntryId = Long.valueOf(invoiceItem.getLong("id"));
                ++idx;
            }
            DynamicObject[] billInvoiceRelations = (DynamicObject[])billInvoiceRelationCollection.toArray((Object[])new DynamicObject[0]);
            if (invoiceItemCollection.size() == billInvoiceRelations.length) {
                Long invoiceId = invoiceObject.getLong("id");
                int index = 0;
                for (DynamicObject billInvoiceRelation : billInvoiceRelations) {
                    billInvoiceRelation.set("tdetailid", (Object)invoiceEntryIds[index]);
                    billInvoiceRelation.set("tbillid", (Object)invoiceId);
                    ++index;
                }
            } else {
                HashMap<Long, ArrayList<DynamicObject>> billInvoiceRelationMap = new HashMap<Long, ArrayList<DynamicObject>>(billInvoiceRelations.length);
                for (DynamicObject billInvoiceRelation : billInvoiceRelations) {
                    Object subList;
                    Long tDetailId = billInvoiceRelation.getLong("tdetailid");
                    if (billInvoiceRelationMap.containsKey(tDetailId)) {
                        subList = (ArrayList<DynamicObject>)billInvoiceRelationMap.get(tDetailId);
                        subList.add(billInvoiceRelation);
                        continue;
                    }
                    subList = new ArrayList<DynamicObject>(billInvoiceRelations.length);
                    subList.add(billInvoiceRelation);
                    billInvoiceRelationMap.put(tDetailId, (ArrayList<DynamicObject>)subList);
                }
                if (logSwitch) {
                    logger.info("getBillInvoiceRelationByMatch, billInvoiceRelationMap\u5927\u5c0f:{}", (Object)billInvoiceRelationMap.size());
                }
                Long invoiceId = invoiceObject.getLong("id");
                if (invoiceItemCollection.size() == billInvoiceRelationMap.size()) {
                    int index = 0;
                    for (Map.Entry entryObject : billInvoiceRelationMap.entrySet()) {
                        List subList = (List)entryObject.getValue();
                        for (DynamicObject billInvoiceRelation : subList) {
                            billInvoiceRelation.set("tdetailid", (Object)invoiceEntryIds[index]);
                            billInvoiceRelation.set("tbillid", (Object)invoiceId);
                        }
                        ++index;
                    }
                }
                for (Map.Entry entryObject : billInvoiceRelationMap.entrySet()) {
                    List subList = (List)entryObject.getValue();
                    for (DynamicObject billInvoiceRelation : subList) {
                        billInvoiceRelation.set("tbillid", (Object)invoiceId);
                    }
                }
            }
            return billInvoiceRelations;
        }
        return null;
    }

    private DynamicObject[] dealRedInvoiceRelationMethodByBill(DynamicObject invoiceObject, DynamicObject[] billInvoiceRelations, boolean logSwitch) {
        DynamicObjectCollection invoiceItemCollection = invoiceObject.getDynamicObjectCollection("items");
        if (invoiceItemCollection == null || invoiceItemCollection.isEmpty()) {
            return null;
        }
        if (logSwitch) {
            logger.info("dealRedInvoiceRelationMethodByBill, billInvoiceRelations\u5927\u5c0f:{}, invoiceItemCollection\u5927\u5c0f:{}", (Object)billInvoiceRelations.length, (Object)invoiceItemCollection.size());
        }
        if (billInvoiceRelations.length == invoiceItemCollection.size()) {
            for (int i = 0; i < billInvoiceRelations.length; ++i) {
                DynamicObject billInvoiceRelation = billInvoiceRelations[i];
                billInvoiceRelation.set("tbillid", invoiceObject.getPkValue());
                billInvoiceRelation.set("tdetailid", ((DynamicObject)invoiceItemCollection.get(i)).getPkValue());
            }
            return billInvoiceRelations;
        }
        DynamicObject[] newBillInvoiceRelations = new DynamicObject[invoiceItemCollection.size()];
        int idx = 0;
        for (DynamicObject invoiceItem : invoiceItemCollection) {
            DynamicObject newBillInvoiceRelation = BusinessDataServiceHelper.newDynamicObject((String)"sim_bill_inv_relation");
            newBillInvoiceRelation.set("tbillid", invoiceObject.getPkValue());
            newBillInvoiceRelation.set("tdetailid", invoiceItem.getPkValue());
            newBillInvoiceRelation.set("sbillid", (Object)billInvoiceRelations[0].getLong("sbillid"));
            newBillInvoiceRelation.set("sdetailid", (Object)billInvoiceRelations[0].getLong("sdetailid"));
            newBillInvoiceRelation.set("amount", (Object)billInvoiceRelations[0].getBigDecimal("amount"));
            newBillInvoiceRelation.set("tax", (Object)billInvoiceRelations[0].getBigDecimal("tax"));
            newBillInvoiceRelations[idx] = newBillInvoiceRelation;
            ++idx;
        }
        return newBillInvoiceRelations;
    }

    private List<Long> getOriginalDetailIdMethod(DynamicObject redConfirmObject) {
        ArrayList<Long> originalDetailIdList = new ArrayList<Long>(10);
        if (redConfirmObject != null) {
            DynamicObjectCollection dynamicObjectCollection = redConfirmObject.getDynamicObjectCollection("items");
            for (DynamicObject redConfirmItem : dynamicObjectCollection) {
                Long originalInvoiceItemId = redConfirmItem.getLong("originalinvoiceitemid");
                if (originalInvoiceItemId == null) continue;
                originalDetailIdList.add(originalInvoiceItemId);
            }
        }
        return originalDetailIdList;
    }

    private DynamicObject[] getBlueInvoiceRelationBillMethod(DynamicObject invoiceObject, boolean logSwitch) {
        Long invoiceId = (Long)invoiceObject.getPkValue();
        String billNo = invoiceObject.getString("billno");
        QFilter billRelationInvFilter = new QFilter("tbillno", "=", (Object)billNo).and("tbillid", "=", (Object)invoiceId);
        String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_inv_relation", (boolean)true);
        DynamicObject[] billInvoiceRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)selectProperties, (QFilter[])billRelationInvFilter.toArray());
        if (logSwitch) {
            logger.info("getBlueInvoiceRelationBillMethod, billInvoiceRelations\u5927\u5c0f:{}", (Object)(billInvoiceRelations == null ? 0 : billInvoiceRelations.length));
        }
        return billInvoiceRelations;
    }
}

