/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billcenter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import kd.imc.sim.billcenter.issuecallback.BillCenterCallBackServiceImpl;
import kd.imc.sim.billcenter.sys.ExternalSystemDataHandler;
import kd.imc.sim.common.constant.BillCenterSystemEnum;
import kd.imc.sim.common.model.billcenter.BillErrorVo;
import kd.imc.sim.common.model.billcenter.BillWarnVo;
import kd.imc.sim.common.service.SimGetBillDataService;
import kd.imc.sim.formplugin.billcenter.SimCommonGetDataLogic;
import org.apache.commons.lang3.StringUtils;

public class SimPopBoxPushStatusPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static Log logger = LogFactory.getLog(SimPopBoxPushStatusPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        this.addBeforeAndAfterF7SelectListener("front_system");
    }

    public void afterCreateNewData(EventObject e) {
        Map customParamsMap = this.getView().getFormShowParameter().getCustomParams();
        if (customParamsMap.containsKey("opType")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bill_no"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"invoice_no"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"push_type"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"scan_content"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bill_no"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"invoice_no"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"push_type"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"scan_content"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
        }
    }

    private void addBeforeAndAfterF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(key);
            if (null == basedataEdit) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            basedataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if ("front_system".equals(fieldKey)) {
            QFilter qFilter = new QFilter("number", "!=", (Object)"DaoKong");
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void afterF7Select(AfterF7SelectEvent event) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"scan_content", (CharSequence)name)) {
            boolean flag;
            String scanContent = (String)this.getModel().getValue("scan_content");
            if (StringUtils.isEmpty((CharSequence)scanContent)) {
                return;
            }
            boolean bl = flag = scanContent.startsWith("https") || scanContent.startsWith("http");
            if (StringUtils.isNotEmpty((CharSequence)scanContent) && flag) {
                logger.info("\u626b\u63cf\u67aa\u7684\u5185\u5bb9\u662f:{}", (Object)scanContent);
                SimGetBillDataService simGetBillDataService = new SimGetBillDataService();
                String responseMsg = simGetBillDataService.dealSplitScanInfoMethod(scanContent);
                logger.info("\u626b\u63cf\u67aa\u89e3\u5bc6\u8fd4\u56de\u7684\u5185\u5bb9\u662f:{}", (Object)responseMsg);
                if (StringUtils.isNotEmpty((CharSequence)responseMsg)) {
                    JSONObject jsonObject = JSONObject.parseObject((String)responseMsg);
                    this.dealSetFieldValueMethod(jsonObject);
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u626b\u63cf\u4e8c\u7ef4\u7801\u51fa\u6765\u7684\u8bf7\u6c42\u5730\u5740\u4e0d\u5408\u6cd5\uff01", (String)"BillCenterScanQrcode_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
                return;
            }
        }
    }

    private void dealGetScanBillDataMethod() {
        String systemCode = (String)this.getView().getModel().getValue("system_code");
        if (StringUtils.isEmpty((CharSequence)systemCode)) {
            String errorMsg = ResManager.loadKDString((String)"\u7cfb\u7edf\u7f16\u7801\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u591f\u62c9\u53d6\u8ba2\u5355\u6570\u636e\uff01", (String)"BillCenterScanQrcode_2", (String)"imc-sim-webapi", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        JSONObject paramObject = new JSONObject();
        SimCommonGetDataLogic simCommonGetDataLogic = new SimCommonGetDataLogic();
        String systemSource = simCommonGetDataLogic.dealSpecialSystemCodeMethod(systemCode);
        paramObject.put("systemCode", (Object)systemSource);
        JSONObject paramContent = this.getParamContentMethod(systemCode);
        paramObject.put("paramContent", (Object)paramContent);
        logger.info("\u626b\u7801\u62c9\u5355\u64cd\u4f5c\uff0c\u8bf7\u6c42\u53c2\u6570\u5185\u5bb9\u662f:{}", (Object)SerializationUtils.toJsonString((Object)paramObject));
        List applyBillList = ExternalSystemDataHandler.getExternalSystemData((JSONObject)paramObject);
        logger.info("\u626b\u7801\u62c9\u5355\u64cd\u4f5c\uff0c\u8fd4\u56de\u7ed3\u679c\u5185\u5bb9\u662f\uff1a{}", (Object)applyBillList.size());
        String block_code = (String)this.getModel().getValue("block_code");
        if (StringUtils.isNotEmpty((CharSequence)block_code)) {
            String tipMsg = ResManager.loadKDString((String)"\u6b63\u5728\u540c\u6b65\u4f1a\u8bae\u56e2\u8ba2\u5355\u6570\u636e\uff0c\u7a0d\u5019\u53ef\u5728\u8d26\u5355\u4e2d\u5fc3\u6570\u636e\u2014\u2014\u300b\u7cfb\u7edf\u4ea4\u4e92\u65e5\u5fd7\u83dc\u5355\u4e2d\u67e5\u770b\u540c\u6b65\u7ed3\u679c\uff01", (String)"SimPopBoxGetBillDataPlugin_11", (String)"imc-sim-webapi", (Object[])new Object[0]);
            this.getView().showSuccessNotification(tipMsg);
            return;
        }
        if (applyBillList == null || applyBillList.isEmpty()) {
            String tipMsg = ResManager.loadKDString((String)"\u672a\u67e5\u5230\u5f85\u5f00\u7968\u6570\u636e\uff01", (String)"SimPopBoxGetBillDataPlugin_12", (String)"imc-sim-webapi", (Object[])new Object[0]);
            this.getView().showErrorNotification(tipMsg);
        } else {
            this.dealGetDataResultMethod(applyBillList);
        }
    }

    private void dealGetDataResultMethod(List<BillVo> applyBillList) {
        String tipMsg;
        Object tipMsg2;
        int successNum = 0;
        int failNum = 0;
        int warnNum = 0;
        ArrayList<BillErrorVo> errorArray = new ArrayList<BillErrorVo>(applyBillList.size());
        ArrayList<BillWarnVo> warnArray = new ArrayList<BillWarnVo>(applyBillList.size());
        for (BillVo billVo : applyBillList) {
            if (billVo instanceof BillErrorVo) {
                BillErrorVo billErrorVo = (BillErrorVo)billVo;
                if (billErrorVo != null) {
                    successNum += billErrorVo.getSuccessNum();
                    failNum += billErrorVo.getFailNum();
                }
                logger.error("\u6253\u5370\u9519\u8bef\u5185\u5bb9\uff1a{}", (Object)billErrorVo.getErrorMsg());
                if (!StringUtils.isNotEmpty((CharSequence)billErrorVo.getErrorMsg())) continue;
                errorArray.add(billErrorVo);
                continue;
            }
            if (billVo instanceof BillWarnVo) {
                BillWarnVo billWarnVo = (BillWarnVo)billVo;
                if (billWarnVo != null) {
                    warnNum += billWarnVo.getWarnNum();
                }
                logger.error("\u6253\u5370\u8b66\u544a\u5185\u5bb9\uff1a{}", (Object)billWarnVo.getWarnMsg());
                if (!StringUtils.isNotEmpty((CharSequence)billWarnVo.getWarnMsg())) continue;
                warnArray.add(billWarnVo);
                continue;
            }
            logger.info("\u62c9\u53d6\u5230\u6210\u529f\u7684\u8ba2\u5355\u6570\u636e\uff01");
            ++successNum;
        }
        logger.info("\u62c9\u53d6\u8ba2\u5355\u6210\u529f\u7684\u6570\u91cf\u662f:{}\uff0c \u5931\u8d25\u7684\u6570\u91cf\u662f:{}", (Object)successNum, (Object)failNum);
        if (successNum > 0 && failNum == 0) {
            tipMsg2 = String.format(ResManager.loadKDString((String)"\u62c9\u53d6\u8ba2\u5355\u5904\u7406\uff0c\u6210\u529f\u6570\u91cf\u662f\uff1a%1$s", (String)"SimPopBoxGetBillDataPlugin_10", (String)"imc-sim-webapi", (Object[])new Object[0]), successNum);
            this.getView().showSuccessNotification((String)tipMsg2);
        } else if (successNum == 0 && failNum > 0) {
            for (BillErrorVo billErrorVo : errorArray) {
                tipMsg = String.format(ResManager.loadKDString((String)"\u62c9\u53d6\u8ba2\u5355\u5904\u7406\uff0c\u5931\u8d25\u6570\u91cf\u662f\uff1a%1$s\uff0c\u9519\u8bef\u5185\u5bb9\uff1a%2$s", (String)"SimPopBoxGetBillDataPlugin_20", (String)"imc-sim-webapi", (Object[])new Object[0]), failNum, billErrorVo.getErrorMsg());
                this.getView().showErrorNotification(tipMsg);
            }
        } else if (successNum > 0 && failNum > 0) {
            tipMsg2 = String.format(ResManager.loadKDString((String)"\u62c9\u53d6\u8ba2\u5355\u5904\u7406\uff0c\u6210\u529f\u6570\u91cf\u662f\uff1a%1$s\uff0c\u5931\u8d25\u6570\u91cf\u662f\uff1a%2$s", (String)"SimPopBoxGetBillDataPlugin_21", (String)"imc-sim-webapi", (Object[])new Object[0]), successNum, failNum);
            this.getView().showSuccessNotification((String)tipMsg2);
        } else if (warnNum > 0) {
            for (BillWarnVo billWarnVo : warnArray) {
                tipMsg = String.format(ResManager.loadKDString((String)"\u62c9\u53d6\u8ba2\u5355\u5904\u7406\uff0c\u6570\u91cf\u662f\uff1a%1$s\uff0c\u8b66\u544a\u5185\u5bb9\uff1a%2$s", (String)"SimPopBoxGetBillDataPlugin_22", (String)"imc-sim-webapi", (Object[])new Object[0]), warnNum, billWarnVo.getWarnMsg());
                this.getView().showTipNotification(tipMsg);
            }
        } else {
            String errorMsg = ResManager.loadKDString((String)"\u6682\u672a\u5339\u914d\u5230\u76f8\u5173\u7684\u8ba2\u5355\u6570\u636e\uff01", (String)"SimPopBoxGetBillDataPlugin_23", (String)"imc-sim-webapi", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
        }
    }

    private JSONObject getParamContentMethod(String systemCode) {
        JSONObject jsonObject = new JSONObject();
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_OPERA_GZCLXJH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_CHIMEL.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_PANDAH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_HQBH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_PH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_CH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_YH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_MSH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_QYH.getCode()})) {
            jsonObject = this.getParamContentByOpera();
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_FU_SHI_IMAGE.getCode(), BillCenterSystemEnum.SYSTEM_JIE_SHUN.getCode(), BillCenterSystemEnum.SYSTEM_JIE_SHUN_GZPK.getCode(), BillCenterSystemEnum.SYSTEM_JIE_SHUN_ZHPK.getCode(), BillCenterSystemEnum.SYSTEM_NEW_TAX.getCode(), BillCenterSystemEnum.SYSTEM_NEW_GZPWN.getCode(), BillCenterSystemEnum.SYSTEM_NEW_ZHPWN.getCode()})) {
            jsonObject = this.getParamContentByJieShun();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)systemCode, (CharSequence)BillCenterSystemEnum.SYSTEM_CENTER_ELECTRONICS_9999.getCode())) {
            jsonObject = this.getParamContentBy9999();
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_GALA_GZPW.getCode(), BillCenterSystemEnum.SYSTEM_GALA_ZHPW.getCode(), BillCenterSystemEnum.SYSTEM_GALA_GZCY.getCode(), BillCenterSystemEnum.SYSTEM_GALA_ZHCY.getCode(), BillCenterSystemEnum.SYSTEM_GALA_QYCY.getCode()})) {
            jsonObject = this.getParamContentByGala();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)systemCode, (CharSequence)BillCenterSystemEnum.SYSTEM_FU_JI.getCode())) {
            jsonObject = this.getParamContentByFuJi();
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_HERO_GZCLXJH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_PANDAH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_MSH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_QYCLGC1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_CHIMEL1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_HQBH1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_PH1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_CH1.getCode()})) {
            jsonObject = this.getParamContentByHeroGourmet();
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_DAO_KONG.getCode(), BillCenterSystemEnum.SYSTEM_DAO_KONG_GZ.getCode(), BillCenterSystemEnum.SYSTEM_DAO_KONG_ZH.getCode(), BillCenterSystemEnum.SYSTEM_DAO_KONG_QY.getCode()})) {
            jsonObject = this.getParamContentByDaoKong();
        }
        return jsonObject;
    }

    private JSONObject getParamContentByDaoKong() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String daokong_order_no = dynamicObject.getString("daokong_order_no");
            String daokong_area_code = dynamicObject.getString("daokong_area_code");
            String daokong_order_source = dynamicObject.getString("daokong_order_source");
            JSONObject subObject = new JSONObject();
            subObject.put("OrderNO", (Object)daokong_order_no);
            subObject.put("DistrictCode", (Object)daokong_area_code);
            subObject.put("OrderSource", (Object)daokong_order_source);
            jsonArray.add((Object)subObject);
        }
        jsonObject.put("opKey", (Object)"PC");
        jsonObject.put("billNo", (Object)SerializationUtils.toJsonString((Object)jsonArray));
        return jsonObject;
    }

    private JSONObject getParamContentByHeroGourmet() {
        String orderNo = (String)this.getModel().getValue("order_no");
        Date businessDate = (Date)this.getModel().getValue("date");
        String location = (String)this.getModel().getValue("location");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("location", (Object)location);
        jsonObject.put("businessDate", (Object)DateUtils.format((Date)businessDate, (String)"yyyy-MM-dd"));
        jsonObject.put("checkNumber", (Object)orderNo);
        jsonObject.put("opKey", (Object)"PC");
        return jsonObject;
    }

    private JSONObject getParamContentByFuJi() {
        String syjh = (String)this.getModel().getValue("syjh");
        String fphm = (String)this.getModel().getValue("fphm");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("SYJH", (Object)syjh);
        jsonObject.put("FPHM", (Object)fphm);
        return jsonObject;
    }

    private JSONObject getParamContentByGala() {
        String orderNo = (String)this.getModel().getValue("order_no");
        Date date = (Date)this.getModel().getValue("date");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("codeNo", (Object)orderNo);
        jsonObject.put("date", (Object)DateUtils.format((Date)date, (String)"yyyy-MM-dd"));
        return jsonObject;
    }

    private JSONObject getParamContentBy9999() {
        String[] orderNos;
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        String orderNoStr = (String)this.getModel().getValue("order_no");
        for (String orderNo : orderNos = orderNoStr.split(";")) {
            JSONObject subObject = new JSONObject();
            subObject.put("billNo", (Object)orderNo);
            jsonArray.add((Object)subObject);
        }
        jsonObject.put("billNoList", (Object)jsonArray);
        return jsonObject;
    }

    private JSONObject getParamContentByJieShun() {
        String orderNo = (String)this.getModel().getValue("order_no");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("billNo", (Object)orderNo);
        return jsonObject;
    }

    private JSONObject getParamContentByOpera() {
        String orderNo = (String)this.getModel().getValue("order_no");
        String phoneNo = (String)this.getModel().getValue("phone_no");
        String blockCode = (String)this.getModel().getValue("block_code");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("billNo", (Object)orderNo);
        jsonObject.put("phoneNumber", (Object)phoneNo);
        jsonObject.put("opKey", (Object)"PC");
        if (StringUtils.isNotEmpty((CharSequence)blockCode)) {
            jsonObject.put("blockCode", (Object)blockCode);
            jsonObject.put("opKey", (Object)"PC_BLOCK");
        }
        return jsonObject;
    }

    private String getTestDemo() {
        String msg = "{\"sysSource\":\"DaoKong\", \"ddh\":[{\"OrderNO\":\"1000011\",\"DistrictCode\":\"1000\",\"OrderSource\":\"1\"},{\"OrderNO\":\"1000012\",\"DistrictCode\":\"1200\",\"OrderSource\":\"2\"}]}";
        return msg;
    }

    private void dealSetFieldValueMethod(JSONObject jsonObject) {
        String ddh;
        StringBuilder builder = new StringBuilder();
        String systemCode = jsonObject.getString("sysSource");
        if (StringUtils.isEmpty((CharSequence)systemCode)) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u6765\u6e90\u4e0d\u5b58\u5728\uff01", (String)"BillCenterScanQrcode_3", (String)"imc-sim-webapi", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        String systemTitle = ResManager.loadKDString((String)"\u7cfb\u7edf\u6765\u6e90\uff1a", (String)"BillCenterScanQrcode_4", (String)"imc-sim-webapi", (Object[])new Object[0]);
        builder.append(systemTitle).append(systemCode);
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        DynamicObject dynamicObject = billCenterOrgMappingService.loadSingleBySystemCode(systemCode);
        if (dynamicObject != null) {
            String nameTitle = ResManager.loadKDString((String)"\u7cfb\u7edf\u540d\u79f0\uff1a", (String)"BillCenterScanQrcode_5", (String)"imc-sim-webapi", (Object[])new Object[0]);
            builder.append("\t").append(nameTitle).append(dynamicObject.getString("name"));
        }
        this.getModel().setValue("system_code", (Object)systemCode);
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_OPERA_GZCLXJH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_CHIMEL.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_PANDAH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_HQBH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_PH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_CH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_YH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_MSH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_QYH.getCode()})) {
            ddh = jsonObject.getString("ddh");
            builder.append("\n").append(ResManager.loadKDString((String)"\u8d26\u5355\u7f16\u53f7\uff1a", (String)"BillCenterScanQrcode_6", (String)"imc-sim-webapi", (Object[])new Object[0])).append(ddh);
            this.getModel().setValue("order_no", (Object)ddh);
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_GALA_GZPW.getCode(), BillCenterSystemEnum.SYSTEM_GALA_ZHPW.getCode(), BillCenterSystemEnum.SYSTEM_GALA_GZCY.getCode(), BillCenterSystemEnum.SYSTEM_GALA_ZHCY.getCode(), BillCenterSystemEnum.SYSTEM_GALA_QYCY.getCode()})) {
            ddh = jsonObject.getString("ddh");
            builder.append("\n").append(ResManager.loadKDString((String)"\u63d0\u53d6\u7801\uff1a", (String)"BillCenterScanQrcode_7", (String)"imc-sim-webapi", (Object[])new Object[0])).append(ddh);
            this.getModel().setValue("order_no", (Object)ddh);
            String date = jsonObject.getString("date");
            if (StringUtils.isEmpty((CharSequence)date)) {
                date = DateUtils.format((Date)new Date());
            }
            builder.append("\t").append(ResManager.loadKDString((String)"\u63d0\u53d6\u7801\u65e5\u671f\uff1a", (String)"BillCenterScanQrcode_8", (String)"imc-sim-webapi", (Object[])new Object[0])).append(date);
            this.getModel().setValue("date", (Object)date);
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_HERO_GZCLXJH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_PANDAH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_MSH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_QYCLGC1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_CHIMEL1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_HQBH1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_PH1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_CH1.getCode()})) {
            builder.append("\n").append(ResManager.loadKDString((String)"\u8d26\u5355\u7f16\u53f7\uff1a", (String)"BillCenterScanQrcode_6", (String)"imc-sim-webapi", (Object[])new Object[0])).append(jsonObject.getString("checkNumber"));
            this.getModel().setValue("order_no", (Object)jsonObject.getString("checkNumber"));
            builder.append("\t").append(ResManager.loadKDString((String)"\u8d26\u5355\u65e5\u671f\uff1a", (String)"BillCenterScanQrcode_9", (String)"imc-sim-webapi", (Object[])new Object[0])).append(jsonObject.getString("businessDate"));
            this.getModel().setValue("date", (Object)jsonObject.getString("businessDate"));
            builder.append("\t").append(ResManager.loadKDString((String)"\u8425\u4e1a\u5385\u4ee3\u7801\uff1a", (String)"BillCenterScanQrcode_10", (String)"imc-sim-webapi", (Object[])new Object[0])).append(jsonObject.getString("location"));
            this.getModel().setValue("location", (Object)jsonObject.getString("location"));
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_NEW_TAX.getCode(), BillCenterSystemEnum.SYSTEM_NEW_GZPWN.getCode(), BillCenterSystemEnum.SYSTEM_NEW_ZHPWN.getCode()})) {
            ddh = jsonObject.getString("ddh");
            builder.append("\n").append(ResManager.loadKDString((String)"\u8d26\u5355\u7f16\u53f7\uff1a", (String)"BillCenterScanQrcode_6", (String)"imc-sim-webapi", (Object[])new Object[0])).append(ddh);
            this.getModel().setValue("order_no", (Object)ddh);
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_FU_JI.getCode()})) {
            String syjh = jsonObject.getString("SYJH");
            String fphm = jsonObject.getString("FPHM");
            this.getModel().setValue("syjh", (Object)syjh);
            this.getModel().setValue("fphm", (Object)fphm);
            builder.append("\t").append(ResManager.loadKDString((String)"\u6536\u94f6\u673a\u53f7\uff1a", (String)"BillCenterScanQrcode_11", (String)"imc-sim-webapi", (Object[])new Object[0])).append(syjh);
            builder.append("\t").append(ResManager.loadKDString((String)"\u5c0f\u7968\u53f7\u7801\uff1a", (String)"BillCenterScanQrcode_12", (String)"imc-sim-webapi", (Object[])new Object[0])).append(fphm);
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_DAO_KONG.getCode(), BillCenterSystemEnum.SYSTEM_DAO_KONG_GZ.getCode(), BillCenterSystemEnum.SYSTEM_DAO_KONG_ZH.getCode(), BillCenterSystemEnum.SYSTEM_DAO_KONG_QY.getCode()})) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap"});
            JSONArray jsonArray = jsonObject.getJSONArray("ddh");
            this.dealSetDaoKongParamMethod(jsonArray);
        }
        Label textLabel = (Label)this.getView().getControl("scan_label");
        textLabel.setText(builder.toString());
    }

    private void dealSetDaoKongParamMethod(JSONArray jsonArray) {
        if (jsonArray != null && jsonArray.size() > 0) {
            this.getView().getModel().beginInit();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String OrderNO = jsonObject.getString("OrderNO");
                String DistrictCode = jsonObject.getString("DistrictCode");
                String OrderSource = jsonObject.getString("OrderSource");
                int row = this.getView().getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("daokong_order_source", (Object)OrderSource, row);
                this.getModel().setValue("daokong_area_code", (Object)DistrictCode, row);
                this.getModel().setValue("daokong_order_no", (Object)OrderNO, row);
                this.getView().setEnable(Boolean.valueOf(false), row, new String[]{"daokong_order_source", "daokong_area_code", "daokong_order_no"});
            }
            this.getView().getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if ("btnok".equals(source.getKey())) {
            Map customParamsMap = this.getView().getFormShowParameter().getCustomParams();
            if (customParamsMap.containsKey("opType")) {
                this.dealGetScanBillDataMethod();
                this.dealClearPopBoxFieldMethod();
            } else {
                String bill_no = (String)this.getView().getModel().getValue("bill_no");
                String invoice_no = (String)this.getView().getModel().getValue("invoice_no");
                if (StringUtils.isEmpty((CharSequence)bill_no) && StringUtils.isEmpty((CharSequence)invoice_no)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u8ba2\u5355\u7f16\u53f7\u6216\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"BillCenterScanQrcode_13", (String)"imc-sim-webapi", (Object[])new Object[0]));
                    return;
                }
                String[] invoiceNoArray = invoice_no.split(";");
                if (invoiceNoArray.length > 100) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u591f\u8d85\u8fc7100\uff01", (String)"BillCenterScanQrcode_15", (String)"imc-sim-webapi", (Object[])new Object[0]));
                    return;
                }
                String pushType = (String)this.getModel().getValue("push_type");
                ThreadPools.executeOnceIncludeRequestContext((String)"sync_block_opera_bill_data", () -> {
                    BillCenterCallBackServiceImpl billCenterCallBackService = new BillCenterCallBackServiceImpl();
                    long startTime = System.currentTimeMillis();
                    for (String invoiceNo : invoiceNoArray) {
                        billCenterCallBackService.callbackToSystem(bill_no, invoiceNo, pushType);
                    }
                    long endTime = System.currentTimeMillis();
                    logger.info("\u6267\u884c\u7684\u65f6\u95f4\u5dee\u662f:{}", (Object)(endTime - startTime));
                });
                String tipMsg = ResManager.loadKDString((String)"\u624b\u5de5\u63a8\u9001\u56de\u8c03\u64cd\u4f5c\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u67e5\u8be2\u4ea4\u4e92\u7ba1\u7406\u65e5\u5fd7\uff01", (String)"BillCenterScanQrcode_14", (String)"imc-sim-webapi", (Object[])new Object[0]);
                this.getView().showSuccessNotification(tipMsg);
            }
        } else if ("btncancel".equals(source.getKey())) {
            this.getView().close();
        }
    }

    private void dealClearPopBoxFieldMethod() {
        this.getView().getModel().setValue("scan_content", null);
        Label textLabel = (Label)this.getView().getControl("scan_label");
        textLabel.setText(null);
        this.getModel().setValue("order_no", null);
        this.getModel().setValue("system_code", null);
        this.getModel().setValue("block_code", null);
        this.getModel().setValue("phone_no", null);
        this.getModel().setValue("location", null);
        this.getModel().setValue("fphm", null);
        this.getModel().setValue("syjh", null);
        this.getModel().setValue("date", null);
        this.getView().getModel().deleteEntryData("entryentity");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
        logger.info("dealClearPopBoxFieldMethod\uff0c \u6e05\u7a7a\u76f8\u5173\u7684\u5b57\u6bb5\u503c\u3002");
    }
}

