/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.invoice.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.helper.allele.RedConfirmOriginalSeqHelper;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.service.WideInvoiceSevice;
import org.apache.commons.collections.CollectionUtils;

public class RedConfirmAndInvoiceRepairHelper {
    private static final Log log = LogFactory.getLog(RedConfirmAndInvoiceRepairHelper.class);

    public boolean repairInvoiceRemainAmount(Long id) {
        DynamicObject invoice = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)String.join((CharSequence)",", "id", "invoiceamount", "remainredamount"), (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        if (invoice == null || invoice.getBigDecimal("invoiceamount").compareTo(BigDecimal.ZERO) <= 0 || invoice.getBigDecimal("remainredamount").compareTo(BigDecimal.ZERO) <= 0) {
            log.info("\u672a\u67e5\u8be2\u5230\u53d1\u7968\u6216\u53d1\u7968\u4e3a\u7ea2\u7968\u6216\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d\u4e3a0\uff0c\u4e0d\u4fee\u590d\uff0c\u53d1\u7968id:{}", (Object)id);
            return false;
        }
        invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.get("id"), (String)"sim_vatinvoice");
        DynamicObjectCollection invoiceItems = invoice.getDynamicObjectCollection("items");
        Map originalSeqMap = RedConfirmOriginalSeqHelper.getOriginalSeqItemIdMap((DynamicObjectCollection)invoiceItems);
        DynamicObjectCollection redConfirms = QueryServiceHelper.query((String)"sim_red_confirm_bill", (String)"id", (QFilter[])new QFilter("originalinvoicecode", "=", (Object)invoice.getString("invoicecode")).and("originalinvoiceno", "=", (Object)invoice.getString("invoiceno")).and("createtime", ">=", (Object)invoice.getDate("issuetime")).and("issuestatus", "=", (Object)"0").toArray());
        HashMap<Long, InvoiceRepair> itemId2InvoiceMap = new HashMap<Long, InvoiceRepair>(redConfirms.size());
        if (CollectionUtils.isNotEmpty((Collection)redConfirms)) {
            DynamicObject[] redConfirmArr;
            log.info("\u672a\u67e5\u8be2\u5230\u7ea2\u5b57\u786e\u8ba4\u5355\uff0c\u53d1\u7968\u4ee3\u7801:{}\uff0c\u53d1\u7968\u53f7\u7801:{}", (Object)invoice.getString("invoicecode"), (Object)invoice.getString("invoiceno"));
            boolean updateRedConfirm = false;
            for (DynamicObject redConfirm2 : redConfirmArr = BusinessDataServiceHelper.load((Object[])redConfirms.stream().map(redConfirm -> redConfirm.get("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_red_confirm_bill"))) {
                DynamicObjectCollection redConfirmItems = redConfirm2.getDynamicObjectCollection("items");
                for (DynamicObject redConfirmItem : redConfirmItems) {
                    Long originalItemId = redConfirmItem.getLong("originalinvoiceitemid");
                    Long originalSeqItemId = (Long)originalSeqMap.get(redConfirmItem.getInt("originseq"));
                    if (originalItemId == 0L) {
                        if (originalSeqItemId == null || originalSeqItemId == 0L) continue;
                        updateRedConfirm = true;
                        redConfirmItem.set("originalinvoiceitemid", (Object)originalSeqItemId);
                    } else if (originalSeqItemId != null && originalSeqItemId != 0L && !originalItemId.equals(originalSeqItemId)) {
                        updateRedConfirm = true;
                        redConfirmItem.set("originalinvoiceitemid", (Object)originalSeqItemId);
                    }
                    InvoiceRepair invoiceRepair = itemId2InvoiceMap.computeIfAbsent(redConfirmItem.getLong("originalinvoiceitemid"), k -> new InvoiceRepair());
                    invoiceRepair.setAmount(invoiceRepair.getAmount().add(redConfirmItem.getBigDecimal("amount").setScale(2, 4)));
                    invoiceRepair.setTax(invoiceRepair.getTax().add(redConfirmItem.getBigDecimal("tax").setScale(2, 4)));
                    invoiceRepair.setNum(invoiceRepair.getNum().add(redConfirmItem.getBigDecimal("num")));
                    boolean isSalesDiscount = RedConfirmBillRedReasonEnum.SALES_DISCOUNTS.getCode().equals(redConfirm2.getString("redreason"));
                    invoiceRepair.setSalesDiscount(invoiceRepair.getSalesDiscount() != false || isSalesDiscount);
                    if (!isSalesDiscount) continue;
                    invoiceRepair.setSalesDiscountAmount(invoiceRepair.getSalesDiscountAmount().add(redConfirmItem.getBigDecimal("amount").setScale(2, 4)));
                }
            }
            if (updateRedConfirm) {
                log.info("\u7ea2\u5b57\u786e\u8ba4\u5355\u660e\u7ec6\u5bf9\u5e94\u539f\u84dd\u7968\u660e\u7ec6id\u4fee\u590d\u5b8c\u6210\uff0c\u53d1\u7968\u4ee3\u7801:{}\uff0c\u53d1\u7968\u53f7\u7801:{}\uff0c\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7:{}", new Object[]{invoice.getString("invoicecode"), invoice.getString("invoiceno"), Arrays.stream(redConfirmArr).map(redConfirm -> redConfirm.getString("number")).collect(Collectors.joining(","))});
                ImcSaveServiceHelper.save((DynamicObject[])redConfirmArr);
            }
        }
        if (invoice.getBigDecimal("invoiceamount").compareTo(invoice.getBigDecimal("remainredamount")) == 0) {
            IssueInvoiceService.setBlueInvoiceRemainRedAmount((DynamicObject)invoice);
        }
        invoice.set("remainredamount", (Object)BigDecimal.ZERO);
        invoice.set("canredtaxamount", (Object)BigDecimal.ZERO);
        BigDecimal discountRate = IssueInvoiceService.getDiscountRate();
        for (int i = 0; i < invoiceItems.size(); ++i) {
            boolean isBeDiscount;
            DynamicObject invoiceItem = (DynamicObject)invoiceItems.get(i);
            InvoiceRepair invoiceRepair = (InvoiceRepair)itemId2InvoiceMap.get(invoiceItem.getLong("id"));
            if (invoiceRepair == null) {
                this.repairInvoiceRemainDiscountAmount(invoiceItems, i, discountRate);
                this.setInvoiceRemainRedAmount(invoice, invoiceItem);
                continue;
            }
            BigDecimal remainRedAmount = invoiceItem.getBigDecimal("amount");
            boolean bl = isBeDiscount = "2".equals(invoiceItem.getString("rowtype")) && i != invoiceItems.size() - 1;
            if (isBeDiscount) {
                remainRedAmount = remainRedAmount.add(((DynamicObject)invoiceItems.get(i + 1)).getBigDecimal("amount")).setScale(2, 4);
            }
            remainRedAmount = remainRedAmount.add(invoiceRepair.getAmount()).setScale(2, 4);
            if (invoiceItem.getBigDecimal("itemremainredamount").setScale(2, 4).compareTo(remainRedAmount) < 0) {
                this.setRemainDiscountAmount(invoiceItems, i, invoiceRepair, discountRate);
                this.setItemRedPrice(invoiceItems, i, invoiceRepair);
                this.setInvoiceRemainRedAmount(invoice, invoiceItem);
                continue;
            }
            invoiceItem.set("itemremainredamount", (Object)remainRedAmount);
            BigDecimal remainRedTax = invoiceItem.getBigDecimal("tax");
            if (isBeDiscount) {
                remainRedTax = remainRedTax.add(((DynamicObject)invoiceItems.get(i + 1)).getBigDecimal("tax")).setScale(2, 4);
            }
            invoiceItem.set("itemremainredtax", (Object)remainRedTax.add(invoiceRepair.getTax()).setScale(2, 4));
            invoiceItem.set("itemremainrednum", (Object)invoiceItem.getBigDecimal("num").add(invoiceRepair.getNum()));
            this.setRemainDiscountAmount(invoiceItems, i, invoiceRepair, discountRate);
            this.setItemRedPrice(invoiceItems, i, invoiceRepair);
            this.setInvoiceRemainRedAmount(invoice, invoiceItem);
        }
        this.setInvoiceStatus(invoice);
        log.info("\u53d1\u7968\u4fee\u590d\u6210\u529f\uff0c\u53d1\u7968\u4ee3\u7801:{}\uff0c\u53d1\u7968\u53f7\u7801:{}", (Object)invoice.getString("invoicecode"), (Object)invoice.getString("invoiceno"));
        ImcSaveServiceHelper.save((DynamicObject)invoice);
        WideInvoiceSevice.addInvoiceToWide((DynamicObject)invoice);
        return true;
    }

    private void setItemRedPrice(DynamicObjectCollection invoiceItems, int i, InvoiceRepair invoiceRepair) {
        DynamicObject invoiceItem = (DynamicObject)invoiceItems.get(i);
        if (!invoiceRepair.getSalesDiscount().booleanValue()) {
            this.setRedPriceByBediscount(invoiceItems, i);
            return;
        }
        BigDecimal remainRedNum = invoiceItem.getBigDecimal("itemremainrednum");
        if (remainRedNum.compareTo(BigDecimal.ZERO) != 0) {
            invoiceItem.set("redprice", (Object)invoiceItem.getBigDecimal("itemremainredamount").divide(remainRedNum, 13, 4));
            return;
        }
        BigDecimal num = invoiceItem.getBigDecimal("num");
        if (num.compareTo(BigDecimal.ZERO) == 0) {
            invoiceItem.set("redprice", (Object)BigDecimal.ZERO);
        } else {
            invoiceItem.set("redprice", (Object)invoiceItem.getBigDecimal("itemremainredamount").divide(num, 13, 4));
        }
    }

    private void repairInvoiceRemainDiscountAmount(DynamicObjectCollection invoiceItems, int i, BigDecimal discountRate) {
        DynamicObject invoiceItem = (DynamicObject)invoiceItems.get(i);
        if ("1".equals(invoiceItem.getString("rowtype"))) {
            return;
        }
        if (invoiceItem.getBigDecimal("redprice").compareTo(BigDecimal.ZERO) == 0) {
            this.setRedPriceByBediscount(invoiceItems, i);
        }
        if (invoiceItem.getBigDecimal("discountedamount").compareTo(BigDecimal.ZERO) == 0 && "2".equals(invoiceItem.getString("rowtype")) && i != invoiceItems.size() - 1) {
            invoiceItem.set("discountedamount", (Object)((DynamicObject)invoiceItems.get(i + 1)).getBigDecimal("amount").abs());
        }
        if (invoiceItem.getBigDecimal("remaindiscountamount").compareTo(BigDecimal.ZERO) == 0) {
            if (discountRate.compareTo(BigDecimal.ONE) == 0) {
                invoiceItem.set("remaindiscountamount", (Object)invoiceItem.getBigDecimal("amount").subtract(invoiceItem.getBigDecimal("discountedamount")));
                return;
            }
            BigDecimal remainDiscountAmount = invoiceItem.getBigDecimal("amount").multiply(discountRate).subtract(invoiceItem.getBigDecimal("discountedamount")).setScale(2, 4);
            invoiceItem.set("remaindiscountamount", (Object)remainDiscountAmount);
        }
    }

    private void setRedPriceByBediscount(DynamicObjectCollection invoiceItems, int i) {
        boolean isBeDiscount;
        DynamicObject invoiceItem = (DynamicObject)invoiceItems.get(i);
        boolean bl = isBeDiscount = "2".equals(invoiceItem.getString("rowtype")) && i != invoiceItems.size() - 1;
        if (!isBeDiscount) {
            invoiceItem.set("redprice", invoiceItem.get("unitprice"));
            return;
        }
        if (invoiceItem.getBigDecimal("num").compareTo(BigDecimal.ZERO) == 0) {
            invoiceItem.set("redprice", (Object)BigDecimal.ZERO);
            return;
        }
        BigDecimal amount = invoiceItem.getBigDecimal("amount").add(((DynamicObject)invoiceItems.get(i + 1)).getBigDecimal("amount"));
        invoiceItem.set("redprice", (Object)amount.divide(invoiceItem.getBigDecimal("num"), 13, 4));
    }

    private void setRemainDiscountAmount(DynamicObjectCollection invoiceItems, int i, InvoiceRepair invoiceRepair, BigDecimal discountRate) {
        DynamicObject invoiceItem = (DynamicObject)invoiceItems.get(i);
        boolean isBeDiscount = "2".equals(invoiceItem.getString("rowtype")) && i != invoiceItems.size() - 1;
        BigDecimal salesDiscountAmount = invoiceRepair.getSalesDiscountAmount();
        if (isBeDiscount) {
            salesDiscountAmount = salesDiscountAmount.add(((DynamicObject)invoiceItems.get(i + 1)).getBigDecimal("amount")).setScale(2, 4);
        }
        invoiceItem.set("discountedamount", (Object)salesDiscountAmount.abs());
        BigDecimal remainAmount = invoiceItem.getBigDecimal("itemremainredamount");
        if (discountRate.compareTo(BigDecimal.ONE) == 0) {
            invoiceItem.set("remaindiscountamount", (Object)remainAmount);
            return;
        }
        BigDecimal notSalesDiscountAmount = invoiceItem.getBigDecimal("amount").add(invoiceRepair.getAmount().subtract(invoiceRepair.getSalesDiscountAmount()));
        BigDecimal remainDiscountAmount = notSalesDiscountAmount.multiply(discountRate).setScale(2, 4).subtract(salesDiscountAmount.abs());
        if (remainDiscountAmount.compareTo(remainAmount) > 0) {
            remainDiscountAmount = remainAmount;
        }
        invoiceItem.set("remaindiscountamount", (Object)remainDiscountAmount);
    }

    private void setInvoiceRemainRedAmount(DynamicObject invoice, DynamicObject invoiceItem) {
        invoice.set("remainredamount", (Object)invoice.getBigDecimal("remainredamount").add(invoiceItem.getBigDecimal("itemremainredamount").setScale(2, 4)));
        invoice.set("canredtaxamount", (Object)invoice.getBigDecimal("canredtaxamount").add(invoiceItem.getBigDecimal("itemremainredtax").setScale(2, 4)));
    }

    private void setInvoiceStatus(DynamicObject invoice) {
        if (invoice.getBigDecimal("remainredamount").compareTo(BigDecimal.ZERO) == 0) {
            invoice.set("invoicestatus", (Object)"3");
        } else if (invoice.getBigDecimal("invoiceamount").compareTo(invoice.getBigDecimal("remainredamount")) == 0) {
            invoice.set("invoicestatus", (Object)"0");
        } else if (invoice.getBigDecimal("invoiceamount").compareTo(invoice.getBigDecimal("remainredamount")) > 0) {
            invoice.set("invoicestatus", (Object)"2");
        }
    }

    static class InvoiceRepair {
        private BigDecimal amount;
        private BigDecimal salesDiscountAmount;
        private BigDecimal tax;
        private BigDecimal num;
        private Boolean salesDiscount;

        InvoiceRepair() {
        }

        public BigDecimal getAmount() {
            return this.amount == null ? BigDecimal.ZERO : this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public BigDecimal getSalesDiscountAmount() {
            return this.salesDiscountAmount == null ? BigDecimal.ZERO : this.salesDiscountAmount;
        }

        public void setSalesDiscountAmount(BigDecimal salesDiscountAmount) {
            this.salesDiscountAmount = salesDiscountAmount;
        }

        public BigDecimal getTax() {
            return this.tax == null ? BigDecimal.ZERO : this.tax;
        }

        public void setTax(BigDecimal tax) {
            this.tax = tax;
        }

        public BigDecimal getNum() {
            return this.num == null ? BigDecimal.ZERO : this.num;
        }

        public void setNum(BigDecimal num) {
            this.num = num;
        }

        public Boolean getSalesDiscount() {
            return this.salesDiscount == null ? Boolean.FALSE : this.salesDiscount;
        }

        public void setSalesDiscount(Boolean salesDiscount) {
            this.salesDiscount = salesDiscount;
        }
    }
}

