/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.invoice.op;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.check.CheckInvoiceResponse;
import kd.imc.bdm.lqpt.model.response.check.CheckResponse;
import kd.imc.sim.async.LqAsyncIssueHandlerImpl;
import kd.imc.sim.common.helper.RimLqptQueryHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class InvoiceAsyncIssueSuccessOp
extends AbstractOperationServicePlugIn {
    protected static final Log LOGGER = LogFactory.getLog(InvoiceAsyncIssueSuccessOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(PropertieUtil.addFieldKey((String)"sim_async_issue_invoice"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] asyncInvoices = e.getDataEntities();
        LqAsyncIssueHandlerImpl lqAsyncIssueHandler = new LqAsyncIssueHandlerImpl();
        for (DynamicObject asyncInvoice : asyncInvoices) {
            DynamicObject invoice = lqAsyncIssueHandler.checkInvoiceIssue(asyncInvoice);
            if (invoice == null) continue;
            Pair<Boolean, String> checkFlag = this.checkInvoiceIssue(asyncInvoice, invoice, true);
            if (((Boolean)checkFlag.getKey()).booleanValue()) {
                lqAsyncIssueHandler.handleLqptInvoiceSuccess(invoice, asyncInvoice);
                continue;
            }
            throw new KDBizException((String)checkFlag.getValue());
        }
    }

    Pair<Boolean, String> checkInvoiceIssue(DynamicObject asyncInvoice, DynamicObject invoice, boolean forceSuccess) {
        String invoiceNo = asyncInvoice.getString("invoiceno");
        try {
            if ("1".equals(ImcConfigUtil.getValue((String)"bdm_lqpt", (String)"close_fpcy"))) {
                return Pair.of((Object)Boolean.TRUE, (Object)"");
            }
            if (asyncInvoice.getDate("issuetime") == null || StringUtils.isBlank((CharSequence)invoiceNo)) {
                return Pair.of((Object)(!forceSuccess ? 1 : 0), (Object)String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7[%s]\u5f00\u7968\u65e5\u671f\u6216\u53d1\u7968\u53f7\u7801\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5f3a\u5236\u6210\u529f\uff01", (String)"InvoiceAsyncIssueSuccessOp_0", (String)"imc-sim-webapi", (Object[])new Object[0]), asyncInvoice.getString("orderno")));
            }
            invoice.set("issuetime", asyncInvoice.get("issuetime"));
            invoice.set("invoiceno", (Object)invoiceNo);
            LqptResponse lqptResponse = new RimLqptQueryHelper().allEInvoiceInspection(invoice);
            CheckResponse checkResponse = (CheckResponse)lqptResponse.getData();
            if (checkResponse == null) {
                if (RimLqptQueryHelper.NO_CHECK_ABILITY_CODE.contains((Object)lqptResponse.getErrcode())) {
                    return Pair.of((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801[%s]\u65e0\u67e5\u9a8c\u80fd\u529b\uff0c\u65e0\u6cd5\u5f3a\u5236\u64cd\u4f5c\uff01", (String)"InvoiceAsyncIssueSuccessOp_1", (String)"imc-sim-webapi", (Object[])new Object[0]), invoiceNo));
                }
                return Pair.of((Object)Boolean.FALSE, (Object)lqptResponse.getDescription());
            }
            CheckInvoiceResponse checkInvoice = checkResponse.getInvoice();
            if (checkInvoice == null) {
                if ("02".equals(checkResponse.getReturncode())) {
                    return Pair.of((Object)(!forceSuccess ? 1 : 0), (Object)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801[%s]\u67e5\u65e0\u6570\u636e\uff0c\u65e0\u6cd5\u5f3a\u5236\u6210\u529f\uff01", (String)"InvoiceAsyncIssueSuccessOp_2", (String)"imc-sim-webapi", (Object[])new Object[0]), invoiceNo));
                }
                return Pair.of((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801[%1$s]\uff0c\u9519\u8bef\u4fe1\u606f[%2$s]\u65e0\u6cd5\u5f3a\u5236\u64cd\u4f5c\uff01", (String)"InvoiceAsyncIssueSuccessOp_3", (String)"imc-sim-webapi", (Object[])new Object[0]), invoiceNo, lqptResponse.getDescription()));
            }
            String compareMsg = new LqAsyncIssueHandlerImpl().compareInvoice(invoice.getPkValue(), checkInvoice);
            if (StringUtils.isBlank((CharSequence)compareMsg)) {
                return Pair.of((Object)forceSuccess, (Object)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801[%s]\u6bd4\u5bf9\u6210\u529f\uff0c\u65e0\u6cd5\u5f3a\u5236\u5931\u8d25\uff01", (String)"InvoiceAsyncIssueSuccessOp_4", (String)"imc-sim-webapi", (Object[])new Object[0]), invoiceNo));
            }
            return Pair.of((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801[%1$s]\u6bd4\u5bf9\u5931\u8d25\uff0c\u6bd4\u5bf9\u4fe1\u606f[%2$s]\uff0c\u65e0\u6cd5\u5f3a\u5236\u64cd\u4f5c\uff01", (String)"InvoiceAsyncIssueSuccessOp_5", (String)"imc-sim-webapi", (Object[])new Object[0]), invoiceNo, compareMsg));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u9a8c\u62a5\u9519" + e.getMessage(), (Throwable)e);
            return Pair.of((Object)Boolean.FALSE, (Object)String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7[%1$s]\u67e5\u9a8c\u62a5\u9519\uff0c\u62a5\u9519\u4fe1\u606f[%2$s]\uff0c\u65e0\u6cd5\u5f3a\u5236\u64cd\u4f5c\uff01", (String)"InvoiceAsyncIssueSuccessOp_6", (String)"imc-sim-webapi", (Object[])new Object[0]), asyncInvoice.getString("orderno"), e.getMessage()));
        }
    }
}

