/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.openapi.CallbackResponseVo;
import kd.imc.bdm.common.service.ApiLogService;
import kd.imc.bdm.common.util.AesUtil;
import kd.imc.bdm.common.util.Base64Util;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.sim.common.constant.OpenApiInterfaceCodeEnum;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import kd.sdk.annotation.SdkDeprecated;

public class OpenApiPlugin
implements IBillWebApiPlugin {
    private static final Log LOG = LogFactory.getLog(OpenApiPlugin.class);
    public static final String IGNORE_SYS = "IMAC_QR";
    public static final String KINGDEE_CLOUD = "KINGDEECLOUD";
    public static final String KINGDEE_EAS = "EAS";
    public static final String XK = "XKQJ";
    private static final ImmutableSet<String> NOT_CHECK_BUSINESS_SYSTEM = ImmutableSet.of((Object)"IMAC_QR", (Object)"KINGDEECLOUD", (Object)"XKQJ");

    @SdkDeprecated
    public ApiResult doCustomService(Map<String, Object> params) {
        OpenApiInterfaceCodeEnum apiCode;
        if (null == params) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u65e0\u6548\uff0c\u8bf7\u6838\u5bf9!", (String)"OpenApiPlugin_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        RequestVo requestVo = (RequestVo)JSON.parseObject((String)JSON.toJSONString(params), RequestVo.class);
        LOG.info("SimOpenApi\u8bf7\u6c42id:" + requestVo.getRequestId());
        ApiResult apiResult = this.apiCommonCheckValid(requestVo);
        if (!apiResult.getSuccess()) {
            return apiResult;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("openApi\u539f\u59cb\u4f20\u5165\u53c2\u6570" + JSON.toJSONString((Object)requestVo));
        }
        DynamicObject businessSys = null;
        if (this.isNotCheckSystem(requestVo)) {
            if (!IGNORE_SYS.equals(requestVo.getBusinessSystemCode())) {
                String businessData;
                try {
                    businessData = Base64Util.decodeToString((String)requestVo.getData(), (String)"UTF-8");
                }
                catch (Exception e) {
                    LOG.error("openApi\u6570\u636e\u52a0\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
                    return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u89e3\u5bc6\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\u52a0\u5bc6\u65b9\u5f0f", (String)"OpenApiPlugin_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                if (StringUtils.isEmpty((CharSequence)businessData)) {
                    return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u89e3\u5bc6\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\u52a0\u5bc6\u65b9\u5f0f", (String)"OpenApiPlugin_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
                requestVo.setData(businessData);
                if (LOG.isInfoEnabled()) {
                    LOG.info("openApi\u89e3\u5bc6\u540e\u6570\u636e " + requestVo.getInterfaceCode() + " == " + businessData);
                }
            }
        } else {
            try {
                businessSys = this.decryptData(requestVo);
            }
            catch (MsgException e) {
                return ResponseVo.fail((String)e.getErrorCode(), (String)e.getErrorMsg());
            }
        }
        if (null == (apiCode = OpenApiInterfaceCodeEnum.getInterfaceByCode((String)requestVo.getInterfaceCode())) || StringUtils.isEmpty((CharSequence)apiCode.getImpl())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u63a5\u53e3[%s]", (String)"OpenApiPlugin_2", (String)"imc-sim-webapi", (Object[])new Object[0]), requestVo.getInterfaceCode()));
        }
        try {
            String response;
            ApiLogService apiLogService = new ApiLogService(requestVo.getInterfaceCode(), "openApi", JSONObject.toJSONString((Object)requestVo));
            Class<?> clazz = Class.forName(apiCode.getImpl());
            OpenApiService openApiService = (OpenApiService)clazz.newInstance();
            ApiResult result = openApiService.processer(requestVo);
            String string = response = result.getData() == null ? "" : result.getData().toString();
            if (LOG.isInfoEnabled()) {
                LOG.info("openApi\u539f\u59cb\u8fd4\u56de\u53c2\u6570" + SerializationUtils.toJsonString((Object)result));
            }
            if ((result.getSuccess() || ApiErrCodeEnum.ALLE_NOT_LOGIN.getCode().equals(result.getErrorCode()) || ErrorType.RPA_CONFIRM_STATUS_ERROR.getCode().equals(result.getErrorCode()) || ApiErrCodeEnum.BILL_RISK_CONTROL.getCode().equals(result.getErrorCode()) || ApiErrCodeEnum.BILL_RISK_UNLOCK_FAIL.getCode().equals(result.getErrorCode())) && null != result.getData() && StringUtils.isNotBlank((CharSequence)response)) {
                if (this.isNotCheckSystem(requestVo)) {
                    if (!IGNORE_SYS.equals(requestVo.getBusinessSystemCode())) {
                        result.setData((Object)Base64Util.encode((String)response, (String)"UTF-8"));
                    }
                } else {
                    result.setData((Object)AesUtil.getData((DynamicObject)businessSys, (int)0, (String)response));
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("openApi\u52a0\u5bc6\u540e\u8fd4\u56de\u53c2\u6570" + SerializationUtils.toJsonString((Object)result));
            }
            apiLogService.saveLog(StringUtils.isBlank((CharSequence)response) ? result.getMessage() : response);
            return result;
        }
        catch (Exception e) {
            LOG.error("openApi\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
            if (e instanceof MsgException) {
                MsgException e1 = (MsgException)((Object)e);
                String errorCode = StringUtils.isBlank((CharSequence)e1.getErrorCode()) ? ErrorType.EXCEPTION.getCode() : e1.getErrorCode();
                return ResponseVo.fail((String)errorCode, (String)(StringUtils.isEmpty((CharSequence)e1.getErrorMsg()) ? ResManager.loadKDString((String)"\u7cfb\u7edf\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!", (String)"OpenApiPlugin_3", (String)"imc-sim-webapi", (Object[])new Object[0]) : e1.getErrorMsg()));
            }
            if (e instanceof JSONException) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u63a5\u6536\u7684\u6570\u636e\u8f6c\u6362\u5f02\u5e38:%s", (String)"OpenApiPlugin_8", (String)"imc-sim-webapi", (Object[])new Object[0]), e.getMessage());
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)errorMsg);
            }
            String errorMsg = e.getMessage();
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)(StringUtils.isEmpty((CharSequence)errorMsg) ? ResManager.loadKDString((String)"\u7cfb\u7edf\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5!", (String)"OpenApiPlugin_3", (String)"imc-sim-webapi", (Object[])new Object[0]) : errorMsg));
        }
    }

    private DynamicObject decryptData(RequestVo requestVo) {
        String businessData;
        DynamicObject businessSys = BusinessDataServiceHelper.loadSingleFromCache((String)"invsm_app_access_config", (String)"code,name,encryption_type, aes_pwds, is_valid", (QFilter[])new QFilter("code", "=", (Object)requestVo.getBusinessSystemCode()).toArray());
        if (null == businessSys) {
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), String.format(ResManager.loadKDString((String)"\u672a\u77e5\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801%s", (String)"OpenApiPlugin_4", (String)"imc-sim-webapi", (Object[])new Object[0]), requestVo.getBusinessSystemCode()));
        }
        CallbackResponseVo response = CallbackHelperUtil.checkBusinessSystemValid((DynamicObject)businessSys);
        if (!ApiErrCodeEnum.OK.getCode().equals(response.getCode())) {
            throw new MsgException(response.getCode(), response.getMessage());
        }
        try {
            businessData = AesUtil.getData((DynamicObject)businessSys, (int)1, (String)requestVo.getData());
        }
        catch (Exception e) {
            LOG.error("openApi\u6570\u636e\u52a0\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u6570\u636e\u89e3\u5bc6\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\u52a0\u5bc6\u65b9\u5f0f", (String)"OpenApiPlugin_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)businessData)) {
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u6570\u636e\u89e3\u5bc6\u5931\u8d25\uff0c\u8bf7\u6838\u5bf9\u6570\u636e\u52a0\u5bc6\u65b9\u5f0f", (String)"OpenApiPlugin_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("openApi\u89e3\u5bc6\u540e\u6570\u636e " + requestVo.getInterfaceCode() + " == " + businessData);
        }
        requestVo.setData(businessData);
        return businessSys;
    }

    private boolean isNotCheckSystem(RequestVo requestVo) {
        if (NOT_CHECK_BUSINESS_SYSTEM.contains((Object)requestVo.getBusinessSystemCode())) {
            return true;
        }
        return OpenApiInterfaceCodeEnum.EAS_CALLBACK_CONFIG_INIT.getCode().equals(requestVo.getInterfaceCode()) && KINGDEE_EAS.equals(requestVo.getBusinessSystemCode());
    }

    protected ApiResult apiCommonCheckValid(RequestVo requestVo) {
        if (null == requestVo) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u4f20\u5165\u53c2\u6570\u65e0\u6548\uff0c\u8bf7\u6838\u5bf9!", (String)"OpenApiPlugin_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)requestVo.getInterfaceCode())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570interfaceCode\u672a\u4f20\u5165\u503c", (String)"OpenApiPlugin_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)requestVo.getBusinessSystemCode())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570businessSystemCode\u672a\u4f20\u5165\u503c", (String)"OpenApiPlugin_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((CharSequence)requestVo.getData())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u63a5\u53e3\u53c2\u6570data\u672a\u4f20\u5165\u503c", (String)"OpenApiPlugin_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        return ResponseVo.success((String)"");
    }
}

