/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.check;

import kd.bos.dataentity.resource.ResManager;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.CheckPhoneEnum;
import kd.imc.bdm.common.helper.InvoiceValidHelper;
import kd.imc.bdm.common.helper.cache.MsgAuthSettingCacheHelper;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.utils.ApiVerifyUtil;
import kd.imc.sim.common.vo.openapi.BuyerVo;
import kd.imc.sim.formplugin.openapi.check.VerifyResult;
import org.apache.commons.lang3.StringUtils;

public class ScanVerifyUtil {
    public static VerifyResult checkBuyerData(BuyerVo vo) {
        if (StringUtils.isBlank((CharSequence)vo.getBuyerName())) {
            VerifyResult.error((String)ApiErrCodeEnum.QR_CHECK_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (String)"ScanVerifyUtil_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!GBKUtils.checkValidGbk((String)vo.getBuyerName())) {
            VerifyResult.error((String)ApiErrCodeEnum.QR_CHECK_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u540d\u79f0\u5305\u542b\u975eGBK\u7f16\u7801\u5b57\u7b26", (String)"ScanVerifyUtil_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (GBKUtils.getGBKLength((String)vo.getBuyerName()) > 100) {
            VerifyResult.error((String)ApiErrCodeEnum.QR_CHECK_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u540d\u79f0[%1$s]\u8d85\u8fc7\u53d1\u7968\u53ef\u5f00\u5177\u6700\u5927\u957f\u5ea6[%2$s]\u5b57\u8282", (String)"ScanVerifyUtil_2", (String)"imc-sim-webapi", (Object[])new Object[0]), vo.getBuyerName(), 100));
        }
        int buyerProperty = vo.getBuyerProperty();
        if (StringUtils.isNotBlank((CharSequence)vo.getBuyerTaxNo()) && vo.getBuyerTaxNo().length() > 20) {
            VerifyResult.error((String)ApiErrCodeEnum.QR_CHECK_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u8d2d\u65b9\u7a0e\u53f7[%1$s]\u8d85\u8fc7\u6700\u5927\u957f\u5ea6[%2$s]", (String)"ScanVerifyUtil_3", (String)"imc-sim-webapi", (Object[])new Object[0]), vo.getBuyerTaxNo(), 20));
        } else if (StringUtils.isBlank((CharSequence)vo.getBuyerTaxNo()) && buyerProperty == 0) {
            VerifyResult.error((String)ApiErrCodeEnum.QR_CHECK_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"ScanVerifyUtil_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getCustomMsg()) && GBKUtils.getGBKLength((String)vo.getCustomMsg()) > 230) {
            VerifyResult.error((String)ApiErrCodeEnum.QR_CHECK_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u5ba2\u6237\u7559\u8a00\u8d85\u8fc7\u6700\u5927\u957f\u5ea6(GBK [%s])", (String)"ScanVerifyUtil_5", (String)"imc-sim-webapi", (Object[])new Object[0]), 230));
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getAddress()) && GBKUtils.getGBKLength((String)vo.getAddress()) > 230) {
            VerifyResult.error((String)ApiErrCodeEnum.QR_CHECK_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u516c\u53f8\u5730\u5740\u8d85\u8fc7\u6700\u5927\u957f\u5ea6(GBK [%s])", (String)"ScanVerifyUtil_6", (String)"imc-sim-webapi", (Object[])new Object[0]), 230));
        }
        if ("028".equals(vo.getInvoiceType()) || "026".equals(vo.getInvoiceType())) {
            String checkPhone = MsgAuthSettingCacheHelper.getCacheCheckPhoneByOrgId((long)Long.parseLong(vo.getOrg()));
            if (CheckPhoneEnum.DEFAULT.getCode().equals(checkPhone) && StringUtils.isBlank((CharSequence)vo.getMail()) && StringUtils.isBlank((CharSequence)vo.getMobileNumber())) {
                VerifyResult.error((String)ApiErrCodeEnum.INVOICE_OPEN_EMAIL_OR_PHONE_NEW.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_EMAIL_OR_PHONE_NEW.getMsg());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getMail())) {
            if (ApiVerifyUtil.checkLength((String)vo.getMail(), (int)300)) {
                VerifyResult.error((String)ApiErrCodeEnum.QR_CHECK_ERROR.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_EMAIL.getMsg());
            } else {
                String[] emails = vo.getMail().split(";");
                if (emails.length > 10) {
                    VerifyResult.error((String)ApiErrCodeEnum.QR_CHECK_ERROR.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_EMAIL.getMsg());
                }
                for (String email : emails) {
                    if (RegexUtil.isEmail((String)email)) continue;
                    VerifyResult.error((String)ApiErrCodeEnum.QR_CHECK_ERROR.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_EMAIL.getMsg());
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getMobileNumber()) && !InvoiceValidHelper.isMobile((String)vo.getMobileNumber())) {
            VerifyResult.error((String)ApiErrCodeEnum.QR_CHECK_ERROR.getCode(), (String)ApiErrCodeEnum.INVOICE_OPEN_PHONE.getMsg());
        }
        if (StringUtils.isEmpty((CharSequence)vo.getQrKey())) {
            if (StringUtils.isEmpty((CharSequence)vo.getOrg())) {
                VerifyResult.error((String)ApiErrCodeEnum.QR_CHECK_ERROR.getCode(), (String)ResManager.loadKDString((String)"org\u5fc5\u4f20", (String)"ScanVerifyUtil_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            try {
                TaxUtils.getOrgDynamicObject((Long)Long.parseLong(vo.getOrg()));
            }
            catch (Exception e) {
                VerifyResult.error((String)ApiErrCodeEnum.QR_CHECK_ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7id %s \u4e0d\u5b58\u5728", (String)"ScanVerifyUtil_8", (String)"imc-sim-webapi", (Object[])new Object[0]), vo.getOrg()));
            }
        }
        return VerifyResult.succeed();
    }

    public static VerifyResult checkQrKeyPushTitle(BuyerVo vo) {
        if (StringUtils.isEmpty((CharSequence)vo.getQrKey()) || StringUtils.isEmpty((CharSequence)vo.getBillNo())) {
            VerifyResult.error((String)ApiErrCodeEnum.QR_DATE_ISNULL.getCode(), (String)ResManager.loadKDString((String)"qrKey\u6216\u5355\u636e\u7f16\u53f7\u4e0d\u5b58\u5728", (String)"ScanVerifyUtil_9", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        return VerifyResult.succeed();
    }
}

