/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.alle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllECrossCityTaxVerifyNoQueryDTO;
import kd.imc.bdm.common.dto.allele.AllECrossCityTaxVerifyNoQueryVO;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseListDTO;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.file.util.Handle;
import kd.imc.bdm.lqpt.model.request.LqptRequest;
import kd.imc.bdm.lqpt.model.request.base.build.CrossCityTaxVerifyNoBatchQueryRequest;
import kd.imc.bdm.lqpt.model.request.base.build.CrossCityTaxVerifyNoQueryRequest;
import kd.imc.bdm.lqpt.model.response.LqptResponse;
import kd.imc.bdm.lqpt.model.response.base.build.CrossCityTaxVerifyNoBatchQueryResponse;
import kd.imc.bdm.lqpt.model.response.base.build.CrossCityTaxVerifyNoQueryResponse;
import kd.imc.bdm.lqpt.service.LqptService;
import kd.imc.sim.common.dto.allele.AllEleQueryCrossCityTaxVerifyNoDTO;
import kd.imc.sim.common.dto.allele.AllEleQueryCrossCityTaxVerifyNoResponseDTO;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;

public class AllECrossCityTaxVerifyNoQueryServiceImpl
implements OpenApiService {
    protected static final Log LOGGER = LogFactory.getLog(AllECrossCityTaxVerifyNoQueryServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        Boolean isLqpt;
        if (null == requestVo || StringUtils.isBlank((CharSequence)requestVo.getData())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"AllECrossCityTaxVerifyNoQueryServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        AllECrossCityTaxVerifyNoQueryVO queryVO = (AllECrossCityTaxVerifyNoQueryVO)JSON.parseObject((String)requestVo.getData(), AllECrossCityTaxVerifyNoQueryVO.class);
        if (queryVO == null) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"AllECrossCityTaxVerifyNoQueryServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (Handle.isEmpty((Object)queryVO.getOrgCode()) && Handle.isEmpty((Object)queryVO.getTaxNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u53f7\u548c\u4f01\u4e1a\u7a0e\u53f7\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (String)"AllECrossCityTaxVerifyNoQueryServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        String taxNo = queryVO.getTaxNo();
        if (Handle.isNotEmpty((Object)queryVO.getOrgCode())) {
            DynamicObject orgDynamicObject = TaxUtils.getOrgDynamicObjectByOrgNumber((String)queryVO.getOrgCode());
            SaleInfo saleInfo = TaxUtils.getSaleInfoByOrgDynamicObject((DynamicObject)orgDynamicObject);
            if (StringUtils.isEmpty((CharSequence)queryVO.getTaxNo())) {
                taxNo = saleInfo.getSaleTaxNo();
            } else if (!saleInfo.getSaleTaxNo().equals(queryVO.getTaxNo())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u53f7%s\u4e0e\u4f20\u5165\u7684\u9500\u65b9\u7a0e\u53f7\u4e0d\u5339\u914d", (String)"AllECrossCityTaxVerifyNoQueryServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]), queryVO.getOrgCode()));
            }
        }
        if (!(isLqpt = Boolean.valueOf(EnterpriseHelper.isLqptChannel((String)taxNo))).booleanValue() || StringUtils.isBlank((CharSequence)queryVO.getCrossCityTaxVerifyNo())) {
            if (StringUtils.isBlank((CharSequence)queryVO.getReportIssueStartDate())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u62a5\u544a\u5f00\u5177\u671f\u9650\u8d77\u5fc5\u586b", (String)"AllECrossCityTaxVerifyNoQueryServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)queryVO.getReportIssueEndDate())) {
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u62a5\u544a\u5f00\u5177\u671f\u9650\u6b62\u5fc5\u586b", (String)"AllECrossCityTaxVerifyNoQueryServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
        }
        if (queryVO.getPageSize() == 0) {
            queryVO.setPageSize(50);
        }
        if (queryVO.getPageSize() > 50) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6\u6bcf\u9875\u6570\u91cf\u6700\u5927\u4e3a50", (String)"AllECrossCityTaxVerifyNoQueryServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        queryVO.setReportIssueStartDate(this.checkDateFormat(queryVO.getReportIssueStartDate()));
        queryVO.setReportIssueEndDate(this.checkDateFormat(queryVO.getReportIssueEndDate()));
        queryVO.setTaxValidityStartDate(this.checkDateFormat(queryVO.getTaxValidityStartDate()));
        queryVO.setTaxValidityEndDate(this.checkDateFormat(queryVO.getTaxValidityEndDate()));
        if (isLqpt.booleanValue()) {
            return this.queryCrossCityTaxVerifyNoFromLQ(queryVO, taxNo);
        }
        if (Handle.isEmpty((Object)queryVO.getAccount())) {
            queryVO.setAccount(AllEleAuthHelper.getEleAccount((String)taxNo, (boolean)true));
        }
        return this.queryCrossCityTaxVerifyNoFromRPA(queryVO, taxNo);
    }

    private ApiResult queryCrossCityTaxVerifyNoFromRPA(AllECrossCityTaxVerifyNoQueryVO queryVO, String taxNo) {
        AllEleQueryCrossCityTaxVerifyNoDTO request = (AllEleQueryCrossCityTaxVerifyNoDTO)JSON.parseObject((String)JSONObject.toJSONString((Object)queryVO), AllEleQueryCrossCityTaxVerifyNoDTO.class);
        request.setStartDate(queryVO.getTaxValidityStartDate());
        request.setEndDate(queryVO.getTaxValidityEndDate());
        request.setRequest_path(AllEleInterfaceTypeEnum.QUERY_CROSSCITY_TAXVERIFYNO_INFO.getRequestPath());
        AllEleResponseListDTO response = AllEleServiceHelper.doPostList((String)taxNo, (AllEleRequestDTO)request, AllEleQueryCrossCityTaxVerifyNoResponseDTO.class);
        if (!response.getSuccess().booleanValue()) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u8de8\u533a\u57df\u6d89\u7a0e\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"AllECrossCityTaxVerifyNoQueryServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]), response.getDescription()));
        }
        return this.convertRPAResponse((AllEleResponseListDTO<AllEleQueryCrossCityTaxVerifyNoResponseDTO>)response);
    }

    private ApiResult queryCrossCityTaxVerifyNoFromLQ(AllECrossCityTaxVerifyNoQueryVO queryVO, String taxNo) {
        CrossCityTaxVerifyNoQueryRequest request;
        if (StringUtils.isNotBlank((CharSequence)queryVO.getCrossCityTaxVerifyNo())) {
            request = new CrossCityTaxVerifyNoQueryRequest();
            request.setNsrsbh(taxNo);
            request.setKqysssxbyglbh(queryVO.getCrossCityTaxVerifyNo());
        } else {
            request = new CrossCityTaxVerifyNoBatchQueryRequest();
            request.setNsrsbh(taxNo);
            ((CrossCityTaxVerifyNoBatchQueryRequest)request).setHtdfnsrsbh(queryVO.getConOtherSideTaxNo());
            ((CrossCityTaxVerifyNoBatchQueryRequest)request).setHtdfnsrmc(queryVO.getConOtherSideTaxName());
            ((CrossCityTaxVerifyNoBatchQueryRequest)request).setKqyjyxzqh(queryVO.getCrossCityAreaCode());
            ((CrossCityTaxVerifyNoBatchQueryRequest)request).setKqysssxyxqq(queryVO.getTaxValidityStartDate());
            ((CrossCityTaxVerifyNoBatchQueryRequest)request).setKqysssxyxqz(queryVO.getTaxValidityEndDate());
            ((CrossCityTaxVerifyNoBatchQueryRequest)request).setBgkjqxq(queryVO.getReportIssueStartDate());
            ((CrossCityTaxVerifyNoBatchQueryRequest)request).setBgkjqxz(queryVO.getReportIssueEndDate());
            ((CrossCityTaxVerifyNoBatchQueryRequest)request).setPageNumber(Integer.valueOf(queryVO.getPage()));
            ((CrossCityTaxVerifyNoBatchQueryRequest)request).setPageSize(Integer.valueOf(queryVO.getPageSize()));
        }
        LqptService service = new LqptService();
        LqptResponse response = service.send((LqptRequest)request);
        if (response.success()) {
            CrossCityTaxVerifyNoBatchQueryResponse batchData;
            if (response.getData() instanceof CrossCityTaxVerifyNoQueryResponse) {
                CrossCityTaxVerifyNoQueryResponse data = (CrossCityTaxVerifyNoQueryResponse)response.getData();
                ArrayList<CrossCityTaxVerifyNoQueryResponse> kqysssxsjList = new ArrayList<CrossCityTaxVerifyNoQueryResponse>(1);
                kqysssxsjList.add(data);
                batchData = new CrossCityTaxVerifyNoBatchQueryResponse();
                batchData.setTotal(Integer.valueOf(1));
                batchData.setPageNumber(Integer.valueOf(1));
                batchData.setKqysssxsjList(kqysssxsjList);
            } else {
                batchData = (CrossCityTaxVerifyNoBatchQueryResponse)response.getData();
            }
            return this.convertLQResponse(batchData);
        }
        return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u8de8\u533a\u57df\u6d89\u7a0e\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"AllECrossCityTaxVerifyNoQueryServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]), response.getDescription()));
    }

    private ApiResult convertLQResponse(CrossCityTaxVerifyNoBatchQueryResponse batchData) {
        HashMap<String, Serializable> data = new HashMap<String, Serializable>(1);
        data.put("toatl", batchData.getTotal());
        data.put("page", batchData.getPageNumber());
        ArrayList<AllECrossCityTaxVerifyNoQueryDTO> dtoList = new ArrayList<AllECrossCityTaxVerifyNoQueryDTO>(batchData.getKqysssxsjList().size());
        for (CrossCityTaxVerifyNoQueryResponse response : batchData.getKqysssxsjList()) {
            AllECrossCityTaxVerifyNoQueryDTO dto = new AllECrossCityTaxVerifyNoQueryDTO();
            dto.setCrossCityTaxVerifyNo(response.getKqysssxbyglbh());
            dto.setProjectName(response.getGcxmmc());
            dto.setCrossCityAreaCode(response.getKqyjyxzqh());
            dto.setCrossCityStreet(response.getKqyjyxzjd());
            dto.setCrossCityAddress(response.getKqyjydz());
            dto.setTaxValidityStartDate(response.getKqysssxyxqq());
            dto.setTaxValidityEndDate(response.getKqysssxyxqz());
            dtoList.add(dto);
        }
        data.put("list", dtoList);
        return ResponseVo.success((String)JSON.toJSONString(data));
    }

    private ApiResult convertRPAResponse(AllEleResponseListDTO<AllEleQueryCrossCityTaxVerifyNoResponseDTO> batchData) {
        if (null == batchData.getData()) {
            return ResponseVo.success(null);
        }
        HashMap<String, Serializable> data = new HashMap<String, Serializable>(1);
        data.put("toatl", Integer.valueOf(batchData.getTotalElement()));
        data.put("page", Integer.valueOf(batchData.getPageNo()));
        ArrayList<AllECrossCityTaxVerifyNoQueryDTO> dtoList = new ArrayList<AllECrossCityTaxVerifyNoQueryDTO>(batchData.getData().size());
        for (AllEleQueryCrossCityTaxVerifyNoResponseDTO response : batchData.getData()) {
            AllECrossCityTaxVerifyNoQueryDTO dto = (AllECrossCityTaxVerifyNoQueryDTO)JSON.parseObject((String)JSONObject.toJSONString((Object)response), AllECrossCityTaxVerifyNoQueryDTO.class);
            dtoList.add(dto);
        }
        data.put("list", dtoList);
        return ResponseVo.success((String)JSON.toJSONString(data));
    }

    private String checkDateFormat(String dateStr) {
        if (Handle.isEmpty((Object)dateStr)) {
            return null;
        }
        try {
            Date date = DateUtils.stringToDate((String)dateStr);
            return DateUtils.format((Date)date);
        }
        catch (Exception e) {
            throw new MsgException(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\u4e3ayyyy-MM-dd", (String)"AllECrossCityTaxVerifyNoQueryServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
    }
}

