/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.bill;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import kd.imc.sim.billcenter.sys.ExternalApprovalService;
import kd.imc.sim.billcenter.sys.OperaCommonLogicService;
import kd.imc.sim.common.constant.BillCenterLogEnum;
import kd.imc.sim.common.constant.BillCenterSystemEnum;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.issuing.helper.IssueInvoiceControlHelper;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import org.apache.commons.lang3.StringUtils;

public class BillCreateServiceImpl
implements OpenApiService {
    private static final Log LOG = LogFactory.getLog(BillCreateServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        DynamicObject[] dynamicObjects;
        if (null == requestVo || StringUtils.isBlank((CharSequence)requestVo.getData())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"BillCreateServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        JSONObject paramObject = JSONObject.parseObject((String)requestVo.getData());
        LOG.info("\u5355\u636e\u5f00\u7968\u8bf7\u6c42\u53c2\u6570:{}", (Object)paramObject);
        JSONArray billNos = paramObject.getJSONArray("billNos");
        if (billNos == null || billNos.isEmpty()) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"BillCreateServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        ArrayList<String> billList = new ArrayList<String>(billNos.size());
        for (int i = 0; i < billNos.size(); ++i) {
            billList.add(billNos.getString(i));
        }
        String systemCode = paramObject.getString("sysSource");
        LOG.info("\u7cfb\u7edf\u7f16\u7801:{}, \u8ba2\u5355\u53f7\u5217\u8868:{}", (Object)systemCode, (Object)billList.toArray());
        String buyerRecipientPhone = paramObject.getString("buyerRecipientPhone");
        String buyerRecipientMail = paramObject.getString("buyerRecipientMail");
        LOG.info("buyerRecipientPhone:{}, buyerRecipientMail:{}", (Object)buyerRecipientPhone, (Object)buyerRecipientMail);
        if (StringUtils.isEmpty((CharSequence)buyerRecipientPhone) && StringUtils.isEmpty((CharSequence)buyerRecipientMail)) {
            String errorMsg = ResManager.loadKDString((String)"\u90ae\u7bb1\u548c\u77ed\u4fe1\u5fc5\u987b\u586b\u5199\u5176\u4e2d\u4e00\u9879!", (String)"BillCreateServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]);
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)errorMsg);
        }
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        QFilter qFilter = new QFilter("billno", "in", billList);
        QFilter qFilter2 = this.getSystemCodeQFilter(systemCode);
        if (qFilter2 != null) {
            qFilter = qFilter.and(qFilter2);
        }
        if ((dynamicObjects = billCenterInvoiceCommonService.getBillCenterData(qFilter)).length < 1) {
            String errorMsg = ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u76f8\u5173\u7684\u8d26\u5355\u4e2d\u5fc3\u6570\u636e\uff01", (String)"BillCreateServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]);
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)errorMsg);
        }
        String errorMsg = this.dealCheckBillCenterDataMethod(dynamicObjects);
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)errorMsg);
        }
        errorMsg = this.dealCheckBillCenterDataIsException(dynamicObjects);
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)errorMsg);
        }
        ArrayList<DynamicObject> unPushBillList = new ArrayList<DynamicObject>();
        HashMap<String, HashSet<Long>> hasPushTargetBillMap = new HashMap<String, HashSet<Long>>();
        HashSet<String> invoicedStatusSet = new HashSet<String>();
        for (DynamicObject billCenterObject : dynamicObjects) {
            long billCenterId = billCenterObject.getLong("id");
            String invoiceStatus = billCenterObject.getString("invoice_status");
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"sim_isomerism_bill_data", (Long[])new Long[]{billCenterId});
            if (targetBills.isEmpty()) {
                unPushBillList.add(billCenterObject);
                continue;
            }
            hasPushTargetBillMap.putAll(targetBills);
            invoicedStatusSet.add(invoiceStatus);
        }
        if (!unPushBillList.isEmpty()) {
            LOG.info("BillCreateServiceImpl \u8d26\u5355\u4e2d\u5fc3\u672a\u4e0b\u63a8:{}", (Object)unPushBillList.size());
            this.dealUpdateBillItemOpenInvoiceMethod(unPushBillList.toArray(new DynamicObject[0]), paramObject);
            String actual_invoiceType = this.warpInvoiceType(paramObject);
            LOG.info("BillCreateServiceImpl, actual_invoiceType:{}", (Object)actual_invoiceType);
            boolean flag = this.dealCheckPaperSpecialInvoiceData(actual_invoiceType, paramObject);
            if (flag) {
                String tipMsg = ResManager.loadKDString((String)"\u5f00\u5177\u7eb8\u8d28\u6216\u7535\u5b50\u4e13\u7968\u65f6\uff0c\u94f6\u884c\u8d26\u53f7\u3001\u5730\u5740\u4fe1\u606f\u5fc5\u586b\uff01", (String)"BillCreateServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]);
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)tipMsg);
            }
            billCenterInvoiceCommonService.dealUpdateBillInvoiceDataMethod(unPushBillList.toArray(new DynamicObject[0]), paramObject, actual_invoiceType);
            if (hasPushTargetBillMap.isEmpty()) {
                return this.dealPushOpenInvoiceMethod(unPushBillList.toArray(new DynamicObject[0]), paramObject, actual_invoiceType);
            }
        }
        boolean hasPushUnOpened = false;
        if (!hasPushTargetBillMap.isEmpty()) {
            LOG.info("BillCreateServiceImpl \u8d26\u5355\u4e2d\u5fc3\u5df2\u4e0b\u63a8:{}", (Object)hasPushTargetBillMap.size());
            boolean allInvoiced = this.dealCheckBillCenterDataAllInvoiced(invoicedStatusSet);
            boolean flag = this.dealCheckApplyBillIsFinishMethod(hasPushTargetBillMap);
            LOG.info("BillCreateServiceImpl, allInvoiced:{}, flag:{}", (Object)allInvoiced, (Object)flag);
            if (allInvoiced && flag) {
                String tipMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u6570\u636e\u5173\u8054\u7684\u5f00\u7968\u7533\u8bf7\u5355\u5df2\u7ecf\u5b8c\u6210\u5f00\u7968\uff0c\u8bf7\u52ff\u91cd\u65b0\u63d0\u4ea4\u5f00\u7968\uff01", (String)"BillCreateServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]);
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)tipMsg);
            }
            List<DynamicObject> partInvoicedList = this.dealCheckBillCenterDataPartInvoiced(dynamicObjects);
            LOG.info("BillCreateServiceImpl \u8d26\u5355\u4e2d\u5fc3\u90e8\u5206\u4e0b\u63a8\u7684\u8ba2\u5355\u5217\u8868\u96c6\u5408:{}", (Object)partInvoicedList.size());
            if (partInvoicedList != null && partInvoicedList.size() > 0) {
                this.dealUpdateBillItemOpenInvoiceMethod(partInvoicedList.toArray(new DynamicObject[0]), paramObject);
                String actual_invoiceType = this.warpInvoiceType(paramObject);
                this.dealPushOpenInvoiceMethod(partInvoicedList.toArray(new DynamicObject[0]), paramObject, actual_invoiceType);
            } else {
                hasPushUnOpened = true;
            }
        }
        LOG.info("BillCreateServiceImpl, hasPushUnOpened:{}", (Object)hasPushUnOpened);
        if (hasPushUnOpened) {
            HashSet hashSet = (HashSet)hasPushTargetBillMap.get("sim_original_bill");
            ArrayList billDds = new ArrayList(hashSet);
            DynamicObject[] originalBillList = BusinessDataServiceHelper.load((Object[])billDds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
            ArrayList<Object> commonBillIds = new ArrayList<Object>(originalBillList.length);
            for (DynamicObject dynamicObject : originalBillList) {
                commonBillIds.add(dynamicObject.getPkValue());
            }
            DynamicObjectCollection relations = QueryServiceHelper.query((String)"sim_bill_inv_relation", (String)String.join((CharSequence)",", "tbillid", "ttable", "tbillno"), (QFilter[])OrgHelper.getIdFilter(commonBillIds, (String)"sbillid").toArray());
            if (relations.isEmpty()) {
                IssueInvoiceControlHelper.issueInvoice((DynamicObject[])originalBillList, (Integer)1, (boolean)true, (boolean)true, (String)"IMAC");
            } else {
                DynamicObject[] invoiceDynamicArray = BusinessDataServiceHelper.load((Object[])relations.stream().map(r -> r.get("tbillid")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"));
                ArrayList<DynamicObject> unIssueList = new ArrayList<DynamicObject>();
                for (DynamicObject dynamicObject : invoiceDynamicArray) {
                    if (!StringUtils.isEmpty((CharSequence)dynamicObject.getString("invoiceno"))) continue;
                    unIssueList.add(dynamicObject);
                }
                IssueInvoiceMqHelper.submitInvoice2MQ((DynamicObject[])unIssueList.toArray(new DynamicObject[0]));
            }
        }
        return ResponseVo.success((String)ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"BillCreateServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
    }

    private QFilter getSystemCodeQFilter(String sysSource) {
        if (!StringUtils.isEmpty((CharSequence)sysSource)) {
            String config = ImcConfigUtil.getValue((String)"sim_billsysource_mapping", (String)sysSource);
            if ("NULL".equals(config)) {
                return null;
            }
            if (!StringUtils.isEmpty((CharSequence)config)) {
                String[] array = config.split(",");
                return new QFilter("system_code", "in", (Object)array);
            }
            if ("PW".equalsIgnoreCase(sysSource)) {
                return new QFilter("system_code", "in", (Object)new String[]{BillCenterSystemEnum.SYSTEM_GALA_GZPW.getCode(), BillCenterSystemEnum.SYSTEM_GALA_ZHPW.getCode(), BillCenterSystemEnum.SYSTEM_NEW_TAX.getCode(), BillCenterSystemEnum.SYSTEM_NEW_GZPWN.getCode(), BillCenterSystemEnum.SYSTEM_NEW_ZHPWN.getCode()});
            }
            return new QFilter("system_code", "=", (Object)sysSource);
        }
        return null;
    }

    private void dealClearBillCenterRejectMethod(JSONObject paramObject) {
        String wxOpenId = paramObject.getString("userId");
        String rejectId = paramObject.getString("rejectId");
        LOG.info("dealClearBillCenterRejectMethod, wxOpenId:{}, rejectId:{}", (Object)wxOpenId, (Object)rejectId);
        if (StringUtils.isEmpty((CharSequence)wxOpenId) || StringUtils.isEmpty((CharSequence)rejectId)) {
            return;
        }
        String opType = BillCenterLogEnum.APPROVAL_RESULT_OP_TYPE.getBillStatus();
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(rejectId)).and("operate_type", "=", (Object)opType);
        DynamicObject[] billLogArray = BusinessDataServiceHelper.load((String)"sim_bill_log", (String)"id", (QFilter[])qFilter.toArray());
        if (billLogArray == null || billLogArray.length == 0) {
            LOG.error("\u672a\u52a0\u8f7d\u5230\u76f8\u5173\u7684\u9a73\u56de\u8bb0\u5f55\u6570\u636e\u3002");
            return;
        }
        ArrayList<Long> billLogIdList = new ArrayList<Long>(billLogArray.length);
        for (DynamicObject billLogObject : billLogArray) {
            billLogIdList.add(billLogObject.getLong("id"));
        }
        LOG.info("dealClearBillCenterRejectMethod, billLogIdList\u5927\u5c0f:{}", (Object)billLogIdList.size());
        QFilter billLogFilter = new QFilter("id", "in", billLogIdList);
        DeleteServiceHelper.delete((String)"sim_bill_log", (QFilter[])billLogFilter.toArray());
        LOG.info("dealClearBillCenterRejectMethod, \u6e05\u7406\u9a73\u56de\u6570\u636e\u6210\u529f\uff01");
    }

    private List<DynamicObject> dealCheckBillCenterDataPartInvoiced(DynamicObject[] dynamicObjects) {
        ArrayList<DynamicObject> partInvoicedList = new ArrayList<DynamicObject>(dynamicObjects.length);
        for (DynamicObject billCenterObject : dynamicObjects) {
            boolean isExist = false;
            String billNo = billCenterObject.getString("billno");
            String invoiceStatus = billCenterObject.getString("invoice_status");
            String pushStatus = billCenterObject.getString("pushstatus");
            LOG.info("dealCheckBillCenterDataPartInvoiced, billNo:{}, invoiceStatus:{}, pushStatus:{}", new Object[]{billNo, invoiceStatus, pushStatus});
            if ("2".equals(invoiceStatus) && ("0".equals(pushStatus) || "-1".equals(pushStatus))) {
                DynamicObjectCollection itemObjectCollection = billCenterObject.getDynamicObjectCollection("sim_isomerism_item_data");
                for (DynamicObject itemObject : itemObjectCollection) {
                    String rowpushstatus = itemObject.getString("rowpushstatus");
                    String invoicable_switch = itemObject.getString("invoicable_switch");
                    LOG.info("dealCheckBillCenterDataPartInvoiced, rowpushstatus:{}, invoicable_switch:{}", (Object)rowpushstatus, (Object)invoicable_switch);
                    if (!"1".equals(invoicable_switch) || !"-1".equals(rowpushstatus)) continue;
                    isExist = true;
                    break;
                }
            }
            if (!isExist) continue;
            partInvoicedList.add(billCenterObject);
        }
        return partInvoicedList;
    }

    private boolean dealCheckBillCenterDataAllInvoiced(Set<String> invoicedStatusSet) {
        if (invoicedStatusSet.isEmpty()) {
            String tipMsg = ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u5355\u4e2d\u5fc3\u7684\u5f00\u7968\u72b6\u6001\u4e3a\u7a7a\uff01", (String)"BillCreateServiceImpl_13", (String)"imc-sim-webapi", (Object[])new Object[0]);
            throw new KDBizException(tipMsg);
        }
        for (String invoiceStatus : invoicedStatusSet) {
            if (!"2".equals(invoiceStatus)) continue;
            return false;
        }
        return true;
    }

    private void dealUpdateBillItemOpenInvoiceMethod(DynamicObject[] billDataCollection, JSONObject paramObject) {
        String invoiceType = paramObject.getString("invoiceType");
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        if ("02".equals(invoiceType)) {
            billCenterInvoiceCommonService.dealUpdateBillItemOpenInvoiceMethod(billDataCollection);
        }
    }

    private boolean dealCheckApplyBillIsFinishMethod(Map<String, HashSet<Long>> hasPushTargetBillMap) {
        DynamicObject[] originalBillList;
        HashSet<Long> hashSet = hasPushTargetBillMap.get("sim_original_bill");
        ArrayList<Long> billDds = new ArrayList<Long>(hashSet);
        for (DynamicObject dynamicObject : originalBillList = BusinessDataServiceHelper.load((Object[])billDds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"))) {
            Object pkId = dynamicObject.getPkValue();
            DynamicObject originalBill = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"sim_original_bill");
            if (originalBill == null) continue;
            String billNo = originalBill.getString("billno");
            String validState = originalBill.getString("validstate");
            LOG.info("dealCheckApplyBillIsFinishMethod, billNo:{}, validState:{}, pkId:{}", new Object[]{billNo, validState, pkId});
            if (!"2".equals(validState)) continue;
            return true;
        }
        return false;
    }

    private String dealCheckBillCenterDataIsException(DynamicObject[] dynamicObjects) {
        OperaCommonLogicService operaCommonLogicService = new OperaCommonLogicService();
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String systemCode;
            boolean isOpera;
            if (dynamicObject == null || !(isOpera = billCenterOrgMappingService.dealCheckSystemCodeIsOpera(systemCode = dynamicObject.getString("system_code")))) continue;
            String billNo = dynamicObject.getString("billno");
            boolean flag = operaCommonLogicService.dealCheckItemPaymentAmountMethod(dynamicObject);
            if (!flag) {
                String tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u7f16\u53f7:%1$s\uff0c\u5bf9\u5e94\u7684\u6d88\u8d39\u9879\u603b\u91d1\u989d\u4e0e\u652f\u4ed8\u9879\u603b\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u4e0d\u652f\u6301\u81ea\u52a9\u5f00\u7968\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u624b\u5de5\u5f00\u7968\uff01", (String)"BillCreateServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), billNo);
                return tipMsg;
            }
            boolean isEqualFlag = operaCommonLogicService.dealComparedAmountIsEqualMethod(dynamicObject);
            if (isEqualFlag) continue;
            String tipMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u7f16\u53f7:%1$s\uff0c\u4e2dFOLIO_NO\u5185\u660e\u7ec6\u9879\u603b\u989d\u548c\u652f\u4ed8\u9879\u603b\u989d\u4e0d\u7b49\uff0c\u4e0d\u652f\u6301\u81ea\u52a9\u5f00\u7968\uff0c\u8bf7\u624b\u5de5\u5904\u7406\u5f00\u7968\uff01", (String)"BillCreateServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]), billNo);
            return tipMsg;
        }
        return null;
    }

    private boolean dealCheckPaperSpecialInvoiceData(String invoiceType, JSONObject paramObject) {
        if (StringUtils.isNotEmpty((CharSequence)invoiceType) && (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(invoiceType) || InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(invoiceType))) {
            String buyerBankAndAccount = paramObject.getString("buyerBankAndAccount");
            LOG.info("dealCheckPaperSpecialInvoiceData, invoiceType:{}, buyerBankAndAccount:{}", (Object)invoiceType, (Object)buyerBankAndAccount);
            if (StringUtils.isEmpty((CharSequence)buyerBankAndAccount)) {
                return true;
            }
            String[] bankAndAccountArray = buyerBankAndAccount.split(",");
            if (bankAndAccountArray == null || bankAndAccountArray.length == 0) {
                return true;
            }
            if (bankAndAccountArray.length == 1) {
                return true;
            }
            String buyerbank = bankAndAccountArray[0];
            String buyerbankacc = bankAndAccountArray[1];
            if (StringUtils.isEmpty((CharSequence)buyerbank) || "NULL".equals(buyerbankacc) || StringUtils.isEmpty((CharSequence)buyerbankacc) || "NULL".equals(buyerbankacc)) {
                return true;
            }
        }
        return false;
    }

    private String dealCheckBillCenterDataMethod(DynamicObject[] dynamicObjects) {
        HashMap<String, Integer> billCenterMap = new HashMap<String, Integer>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String systemCode = dynamicObject.getString("system_code");
            String billNo = dynamicObject.getString("billno");
            LOG.info("dealCheckBillCenterDataMethod, systemCode:{}, billNo:{}", (Object)systemCode, (Object)billNo);
            String key = systemCode + "-" + billNo;
            if (billCenterMap.containsKey(key)) {
                Integer num = (Integer)billCenterMap.get(key);
                billCenterMap.put(key, num + 1);
                continue;
            }
            billCenterMap.put(key, 1);
        }
        LOG.info("dealCheckBillCenterDataMethod, billCenterMap\u5927\u5c0f:{}", (Object)billCenterMap.size());
        for (Map.Entry entry : billCenterMap.entrySet()) {
            String key = (String)entry.getKey();
            Integer num = (Integer)entry.getValue();
            if (num == null || num <= 1) continue;
            String billNo = key.split("-")[1];
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u5355\u53f7:%1$s\uff0c\u5728\u8d26\u5355\u4e2d\u5fc3\u51fa\u73b0\u591a\u7b14\u76f8\u540c\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u591f\u63d0\u4ea4\u5f00\u7968\u7533\u8bf7\uff01", (String)"BillCreateServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]), billNo);
            return errorMsg;
        }
        return null;
    }

    private String warpInvoiceType(JSONObject paramObject) {
        String invoiceType = paramObject.getString("invoiceType");
        String value = ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.SCII_INVOICE_TYPE);
        if ("01".equals(invoiceType)) {
            invoiceType = "1".equals(value) ? InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode() : ("2".equals(value) ? InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode() : InvoiceType.ALL_E_SPECIAL.getTypeCode());
        } else if ("02".equals(invoiceType)) {
            invoiceType = "1".equals(value) ? InvoiceType.PAPER_NOMAL_INVOICE.getTypeCode() : ("2".equals(value) ? InvoiceType.ELECTRICAL_NORMAL_INVOICE.getTypeCode() : InvoiceType.ALL_E_NORMAL.getTypeCode());
        } else {
            if (StringUtils.isNotEmpty((CharSequence)InvoiceType.getBaseCodeByInvoiceTypeCode((String)invoiceType))) {
                return invoiceType;
            }
            String errorMsg = ResManager.loadKDString((String)"\u4e0d\u5408\u6cd5\u7684\u7968\u79cd\u7c7b\u578b\uff01", (String)"BillCreateServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        return invoiceType;
    }

    private ApiResult dealPushOpenInvoiceMethod(DynamicObject[] dynamicObjects, JSONObject paramObject, String actual_invoiceType) {
        try {
            DynamicObject[] originalBillList;
            String invoiceType = paramObject.getString("invoiceType");
            LOG.info("dealPushOpenInvoiceMethod, \u5c0f\u7a0b\u5e8finvoiceType:{}, actual_invoiceType:{}", (Object)invoiceType, (Object)actual_invoiceType);
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"pushandsave", (String)"sim_isomerism_bill_data", (DynamicObject[])dynamicObjects, null);
            if (operationResult.isSuccess()) {
                List successPkIds = operationResult.getSuccessPkIds();
                Long[] longs = new Long[successPkIds.size()];
                for (int i = 0; i < longs.length; ++i) {
                    longs[i] = (Long)successPkIds.get(i);
                }
                Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"sim_isomerism_bill_data", (Long[])longs);
                HashSet hashSet = (HashSet)targetBills.get("sim_original_bill");
                ArrayList billDds = new ArrayList(hashSet);
                originalBillList = BusinessDataServiceHelper.load((Object[])billDds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
                if ("02".equals(invoiceType)) {
                    for (DynamicObject dynamicObject : originalBillList) {
                        dynamicObject.set("invoicetype", (Object)actual_invoiceType);
                    }
                    ImcSaveServiceHelper.update((DynamicObject[])originalBillList);
                }
            } else {
                String message = ((IOperateInfo)operationResult.getAllErrorOrValidateInfo().get(0)).getMessage();
                String errorMsg = StringUtils.isNotEmpty((CharSequence)message) && message.contains("\uff1a") ? message.split("\uff1a")[1] : message;
                return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)errorMsg);
            }
            this.dealOpenApprovalWorkFlowMethod(originalBillList);
            this.dealClearBillCenterRejectMethod(paramObject);
        }
        catch (Exception e) {
            LOG.error("dealPushOpenInvoiceMethod error", (Throwable)e);
            String errorMsg = e.getMessage();
            return ResponseVo.fail((String)ApiErrCodeEnum.ERROR.getCode(), (String)String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u5f00\u7968\u7533\u8bf7\u5355\u5931\u8d25\uff0c\u9519\u8bef\u5185\u5bb9:%1$s", (String)"BillCreateServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]), errorMsg));
        }
        return ResponseVo.success((String)ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"BillCreateServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
    }

    private void dealOpenApprovalWorkFlowMethod(DynamicObject[] originalBillList) {
        String approval_switch_cfg = ImcConfigUtil.getValue((String)CacheKeyEnum.APPROVAL_WORK_FLOW_SWITCH.getConfigType(), (String)CacheKeyEnum.APPROVAL_WORK_FLOW_SWITCH.getConfigKey());
        if (StringUtils.isBlank((CharSequence)approval_switch_cfg)) {
            IssueInvoiceControlHelper.issueInvoice((DynamicObject[])originalBillList, (Integer)1, (boolean)true, (boolean)true, (String)"IMAC");
        } else if ("Y".equals(approval_switch_cfg)) {
            for (DynamicObject originalBillObject : originalBillList) {
                originalBillObject.set("validstate", (Object)"0");
            }
            ImcSaveServiceHelper.update((DynamicObject[])originalBillList);
            String sub_work_flow_class = ImcConfigUtil.getValue((String)CacheKeyEnum.APPROVAL_WORK_FLOW_CLASS.getConfigType(), (String)CacheKeyEnum.APPROVAL_WORK_FLOW_CLASS.getConfigKey());
            if (StringUtils.isBlank((CharSequence)sub_work_flow_class)) {
                String errorMsg = ResManager.loadKDString((String)"\u5f00\u542f\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a\u672a\u914d\u7f6e\u76f8\u5173\u7684\u5b9e\u73b0\u5b50\u7c7b\uff01", (String)"BillCreateServiceImpl_11", (String)"imc-sim-webapi", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            try {
                Class<?> clazz = Class.forName(sub_work_flow_class);
                ExternalApprovalService externalApprovalService = (ExternalApprovalService)clazz.newInstance();
                externalApprovalService.dealOpenApprovalWorkFlowMethod(new JSONObject(), originalBillList);
                LOG.info("dealOpenApprovalWorkFlowMethod, \u5f00\u542f\u6d41\u7a0b\u6210\u529f\uff01");
            }
            catch (Exception e) {
                String errorMsg = ResManager.loadKDString((String)"\u5f00\u542f\u5de5\u4f5c\u6d41\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a\u672a\u5339\u914d\u5230\u76f8\u5173\u7684\u5b9e\u73b0\u5b50\u7c7b\uff01", (String)"BillCreateServiceImpl_12", (String)"imc-sim-webapi", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
        } else {
            IssueInvoiceControlHelper.issueInvoice((DynamicObject[])originalBillList, (Integer)1, (boolean)true, (boolean)true, (String)"IMAC");
        }
    }
}

