/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.bill;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.OperationConstant;
import kd.imc.bdm.common.constant.table.RedReasonEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.service.WideInvoiceSevice;
import kd.imc.sim.common.vo.BillReverseCreateRequestItemVo;
import kd.imc.sim.common.vo.BillReverseCreateRequestVo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.bill.originalbill.workbenchreverse.dto.ReverseBillRelationDTO;
import kd.imc.sim.formplugin.bill.originalbill.workbenchreverse.helper.WorkbenchReverseHelper;
import kd.imc.sim.formplugin.openapi.service.impl.AbstractBillReverseServiceImpl;
import org.apache.commons.lang3.tuple.Pair;

public class BillReverseCreateServiceImpl
extends AbstractBillReverseServiceImpl {
    private static final Log log = LogFactory.getLog(BillReverseCreateServiceImpl.class);

    public ApiResult processer(RequestVo requestVo) {
        BillReverseCreateRequestVo reverseBillRequest = (BillReverseCreateRequestVo)JSONObject.parseObject((String)requestVo.getData(), BillReverseCreateRequestVo.class);
        if (log.isInfoEnabled()) {
            log.info(String.format("\u4e1a\u52a1\u7cfb\u7edf[%s]\u521b\u5efa\u9006\u5411\u5355\u636e\u4f20\u5165\u53c2\u6570[%s]", requestVo.getBusinessSystemCode(), requestVo.getData()));
        }
        if (!"B".equals(reverseBillRequest.getType()) && !"C".equals(reverseBillRequest.getType())) {
            throw new MsgException(ResManager.loadKDString((String)"\u9006\u5411\u5355\u7c7b\u578b\u9519\u8bef", (String)"BillReverseCreateServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        Pair invoiceRelationPair = this.checkInvoiceNoExsit(reverseBillRequest, true);
        DynamicObject invoice = (DynamicObject)invoiceRelationPair.getKey();
        Object[] billIds = (Object[])invoiceRelationPair.getValue();
        this.checkCreateReverseBill(reverseBillRequest, invoice);
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])billIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"));
        DynamicObject reverseBill = WorkbenchReverseHelper.createReverseBill((DynamicObject)bills[0], (DynamicObject)invoice, (String)("B".equals(reverseBillRequest.getType()) ? "bill_red" : "bill_invalid"));
        WorkbenchReverseHelper.overrideJson2Dynamic((JSONObject)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reverseBillRequest.getReverseBill())), (DynamicObject)reverseBill, (boolean)false);
        if (StringUtils.isNotBlank((CharSequence)reverseBillRequest.getReverseBill().getReverseBillNo())) {
            reverseBill.set("billno", (Object)reverseBillRequest.getReverseBill().getReverseBillNo());
        }
        reverseBill.set("billsource", (Object)"2");
        Throwable throwable = null;
        try (TXHandle tx = TX.required();){
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"sim_original_bill", (DynamicObject[])new DynamicObject[]{reverseBill}, null);
            if (!operationResult.isSuccess()) {
                ApiResult apiResult = ResponseVo.fail((String)ApiErrCodeEnum.VEHICLE_INVOICE_OPEN_ERROR.getCode(), (String)OperationConstant.getErrorMsg((OperationResult)operationResult));
                return apiResult;
            }
            this.setInvoiceOccupy(reverseBillRequest.getType(), invoice);
            this.saveBillRelation(reverseBill, billIds);
            JSONObject json = new JSONObject();
            json.put("billNo", (Object)reverseBill.getString("billno"));
            ApiResult apiResult = ResponseVo.success((String)json.toJSONString());
            return apiResult;
        }
        catch (Exception e) {
            tx.markRollback();
            ApiResult apiResult = ResponseVo.fail((String)ApiErrCodeEnum.VEHICLE_INVOICE_OPEN_ERROR.getCode(), (String)"");
            return apiResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private void checkCreateReverseBill(BillReverseCreateRequestVo reverseBillRequest, DynamicObject invoice) {
        boolean isCancel = "C".equals(reverseBillRequest.getType());
        String invoiceType = invoice.getString("invoicetype");
        BillReverseCreateRequestItemVo reverseBill = reverseBillRequest.getReverseBill();
        if (reverseBill == null) {
            reverseBill = new BillReverseCreateRequestItemVo();
            reverseBillRequest.setReverseBill(reverseBill);
        }
        if (isCancel) {
            if (!InvoiceUtils.isPaperInvoice((String)invoiceType)) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801%1$s,\u53d1\u7968\u53f7\u7801%2$s\u4e3a%3$s\uff0c\u65e0\u6cd5\u521b\u5efa\u4f5c\u5e9f\u5355\u636e", (String)"BillReverseCreateServiceImpl_10", (String)"imc-sim-webapi", (Object[])new Object[0]), invoice.getString("invoicecode"), invoice.getString("invoiceno"), InvoiceType.getDescription((String)invoiceType)));
            }
            reverseBill.setRedReason("");
            reverseBill.setApplicant("");
            reverseBill.setInfoCode("");
            return;
        }
        reverseBill.setAbolishReason("");
        if (InvoiceUtils.isNormalInvoice((String)invoiceType)) {
            if (StringUtils.isBlank((CharSequence)reverseBill.getRedReason())) {
                reverseBill.setRedReason(RedReasonEnum.SALES_RETURN.getTypeCode());
            }
        } else if (InvoiceUtils.isSpecialInvoice((String)invoiceType)) {
            if (StringUtils.isBlank((CharSequence)reverseBill.getApplicant())) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801%1$s,\u53d1\u7968\u53f7\u7801%2$s\u7533\u8bf7\u65b9\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillReverseCreateServiceImpl_11", (String)"imc-sim-webapi", (Object[])new Object[0]), invoice.getString("invoicecode"), invoice.getString("invoiceno")));
            }
            if (StringUtils.isBlank((CharSequence)reverseBill.getInfoCode())) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801%1$s,\u53d1\u7968\u53f7\u7801%2$s\u4fe1\u606f\u8868\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillReverseCreateServiceImpl_12", (String)"imc-sim-webapi", (Object[])new Object[0]), invoice.getString("invoicecode"), invoice.getString("invoiceno")));
            }
            QFilter qFilter = new QFilter("infocode", "=", (Object)reverseBill.getInfoCode()).and("org", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)invoice.get("orgid")));
            DynamicObject redInfo = BusinessDataServiceHelper.loadSingle((String)"sim_red_info", (String)String.join((CharSequence)",", "status"), (QFilter[])qFilter.toArray());
            if (redInfo == null) {
                throw new MsgException(String.format(ResManager.loadKDString((String)"\u4fe1\u606f\u8868\u7f16\u53f7%s\u4e0d\u5b58\u5728", (String)"BillReverseCreateServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]), reverseBill.getInfoCode()));
            }
            if ("4".equals(redInfo.getString("status"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fe1\u606f\u8868\u7f16\u53f7%s\u5df2\u5f00\u7968\uff0c\u65e0\u6cd5\u91cd\u590d\u5f00\u7968", (String)"BillReverseCreateServiceImpl_8", (String)"imc-sim-webapi", (Object[])new Object[0]), reverseBill.getInfoCode()));
            }
            if (!"3".equals(redInfo.getString("status"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fe1\u606f\u8868\u7f16\u53f7%s\u672a\u5ba1\u6838\u6210\u529f\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ea2\u51b2", (String)"BillReverseCreateServiceImpl_9", (String)"imc-sim-webapi", (Object[])new Object[0]), reverseBill.getInfoCode()));
            }
        }
    }

    private void setInvoiceOccupy(String type, DynamicObject invoice) {
        invoice.set("occupystatus", (Object)"1");
        WideInvoiceSevice.dealOneWideInvoiceOccupyStatus((DynamicObject)invoice);
        if ("B".equals(type)) {
            DynamicObjectCollection items2 = invoice.getDynamicObjectCollection("items");
            for (DynamicObject item : items2) {
                item.set("itemremainredamount", (Object)BigDecimal.ZERO);
                item.set("itemremainredtax", (Object)BigDecimal.ZERO);
            }
        }
        ImcSaveServiceHelper.save((DynamicObject)invoice);
    }

    private void saveBillRelation(DynamicObject reverseBill, Object[] billIds) {
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)reverseBill.get("orgid"));
        ArrayList<DynamicObject> billRelationList = new ArrayList<DynamicObject>(billIds.length);
        for (Object billId : billIds) {
            ReverseBillRelationDTO billRelationDTO = new ReverseBillRelationDTO((Long)billId, (Long)reverseBill.getPkValue(), Long.valueOf(orgId), "0");
            billRelationList.add(this.createBillRelation(billRelationDTO));
        }
        ImcSaveServiceHelper.save(billRelationList);
    }
}

