/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.bill;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.table.OriginalBillConstant;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.helper.ThirdOrgHelper;
import kd.imc.sim.common.constant.OpenApiInterfaceCodeEnum;
import kd.imc.sim.common.constant.RedConfirmStatusEnum;
import kd.imc.sim.common.helper.OriginalBillHelper;
import kd.imc.sim.common.vo.openapi.BillWithdrawRequestVo;
import kd.imc.sim.common.vo.openapi.ExceptionBillNo;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.invoicebatch.control.WaitInvoiceControl;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import kd.imc.sim.formplugin.redconfirm.op.RedConfirmBillRollbackOp;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BillWithdrawImpl
implements OpenApiService {
    private static final Log LOGGER = LogFactory.getLog(BillWithdrawImpl.class);
    public static final ImmutableSet<String> reverseBill = ImmutableSet.of((Object)"C", (Object)"B");
    private static final Integer OK_MARK = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo) {
            return ApiResult.fail((String)ApiErrCodeEnum.BILL_WITHDRAW_ILLEGAL_PARAM.getMsg(), (String)ApiErrCodeEnum.BILL_WITHDRAW_ILLEGAL_PARAM.getCode());
        }
        BillWithdrawRequestVo withdrawRequestVo = (BillWithdrawRequestVo)JSON.parseObject((String)requestVo.getData(), BillWithdrawRequestVo.class);
        Object orgId = this.getOrgId(requestVo, withdrawRequestVo);
        Map<String, String> rMap = this.check(withdrawRequestVo);
        if (!ApiErrCodeEnum.OK.getCode().equals(rMap.get("code"))) {
            return ApiResult.fail((String)rMap.get("msg"), (String)rMap.get("code"));
        }
        List<Object> exceptionBillNoList = this.filterOkBillNo(withdrawRequestVo.getSerialNos(), orgId);
        for (ExceptionBillNo exceptionBillNo : exceptionBillNoList) {
            if (exceptionBillNo.getMark() == 1) continue;
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s%2$s", (String)"BillWithdrawImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]), exceptionBillNo.getBillNo(), exceptionBillNo.getMessage()), (String)exceptionBillNo.getErrorCode());
        }
        List<ExceptionBillNo> allBIllNos = exceptionBillNoList;
        exceptionBillNoList = exceptionBillNoList.stream().filter(f -> OK_MARK.equals(f.getMark())).collect(Collectors.toList());
        for (ExceptionBillNo exceptionBillNo : exceptionBillNoList) {
            try (TXHandle tx = TX.requiresNew();){
                this.deleteWaitAndRelation(exceptionBillNo);
                this.deleteReverseBill(exceptionBillNo);
                DeleteServiceHelper.delete((String)"sim_original_bill", (QFilter[])new QFilter("id", "=", (Object)exceptionBillNo.getBillId()).toArray());
                exceptionBillNo.setMessage(ApiErrCodeEnum.BILL_WITHDRAW_OK.getMsg());
                exceptionBillNo.setErrorCode(ApiErrCodeEnum.BILL_WITHDRAW_OK.getCode());
            }
        }
        return ResponseVo.success((String)JSON.toJSONString(allBIllNos));
    }

    private void deleteWaitAndRelation(ExceptionBillNo checkOverBill) {
        List backInvoiceIds;
        Set redConfirms = checkOverBill.getRedConfirms();
        if (CollectionUtils.isNotEmpty((Collection)redConfirms)) {
            RedConfirmBillRollbackOp redconfirmOp = new RedConfirmBillRollbackOp();
            DynamicObject[] redConfirmArray = redConfirms.toArray(new DynamicObject[0]);
            redconfirmOp.rollBackRedConfirms(redConfirmArray);
            redConfirms.clear();
        }
        DeleteServiceHelper.delete((String)"sim_bill_inv_relation", (QFilter[])new QFilter("sbillid", "=", (Object)checkOverBill.getBillId()).toArray());
        Set redInfos = checkOverBill.getRedInfos();
        if (CollectionUtils.isNotEmpty((Collection)redInfos)) {
            for (DynamicObject redInfo : redInfos) {
                redInfo.set("infosource", (Object)"1");
            }
            SaveServiceHelper.update((DynamicObject[])redInfos.toArray(new DynamicObject[0]));
        }
        if (CollectionUtils.isEmpty((Collection)(backInvoiceIds = checkOverBill.getFailInvoiceIds()))) {
            return;
        }
        LOGGER.info(String.format("\u56de\u9000\u7684\u5f85\u5f00\u53d1\u7968\u7f16\u53f7\u4e3a\uff1a%s", SerializationUtils.toJsonString((Object)backInvoiceIds)));
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"sim_vatinvoice"), (Object[])backInvoiceIds.toArray());
    }

    private void deleteReverseBill(ExceptionBillNo checkOverBill) {
        String billSourceType = checkOverBill.getBillSourceType();
        if (!OriginalBillConstant.isSpecialSourcType((Object)billSourceType)) {
            return;
        }
        DynamicObject originalBill = BusinessDataServiceHelper.loadSingle((Object)checkOverBill.getBillId(), (String)"sim_original_bill");
        if ("C".equals(billSourceType) || "B".equals(billSourceType)) {
            ArrayList<Pair> invalidInvoiceCodeNo = new ArrayList<Pair>(4);
            ArrayList<DynamicObject> redBills = new ArrayList<DynamicObject>(4);
            if ("C".equals(billSourceType)) {
                invalidInvoiceCodeNo.add(Pair.of((Object)originalBill.getString("invoicecode"), (Object)originalBill.getString("invoiceno")));
            } else {
                redBills.add(originalBill);
            }
            OriginalBillHelper.invalidBillDelete(invalidInvoiceCodeNo);
            OriginalBillHelper.redBillDelete(redBills, invalidInvoiceCodeNo);
        }
        DeleteServiceHelper.delete((String)"sim_bill_relation", (QFilter[])new QFilter("tbillid", "in", (Object)Stream.of(originalBill).map(DataEntityBase::getPkValue).toArray()).toArray());
    }

    private Object getOrgId(RequestVo requestVo, BillWithdrawRequestVo withdrawRequestVo) {
        if (StringUtils.isNotBlank((CharSequence)withdrawRequestVo.getOrgCode())) {
            if ("KINGDEECLOUD".equals(requestVo.getBusinessSystemCode())) {
                withdrawRequestVo.setOrgCode(ThirdOrgHelper.getOrgNumberByThirdOrgNumber((String)withdrawRequestVo.getOrgCode()));
            }
            DynamicObject orgDynamicObject = TaxUtils.getOrgDynamicObjectByOrgNumber((String)withdrawRequestVo.getOrgCode());
            SaleInfo saleInfoByOrg = TaxUtils.getSaleInfoByOrgDynamicObject((DynamicObject)orgDynamicObject);
            if (StringUtils.isBlank((CharSequence)withdrawRequestVo.getSellerTaxpayerId())) {
                withdrawRequestVo.setSellerTaxpayerId(saleInfoByOrg.getSaleTaxNo());
            } else if (!saleInfoByOrg.getSaleTaxNo().equals(withdrawRequestVo.getSellerTaxpayerId())) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u53f7\u4e0e\u4f20\u5165\u7684\u9500\u65b9\u7a0e\u53f7\u4e0d\u5339\u914d", (String)"BillWithdrawImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            return orgDynamicObject.getPkValue();
        }
        DynamicObject epInfoObj = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)"", (QFilter[])new QFilter("number", "=", (Object)withdrawRequestVo.getSellerTaxpayerId()).toArray());
        if (null == epInfoObj) {
            return ApiResult.fail((String)ApiErrCodeEnum.BILL_WITHDRAW_NON_EPINFO.getMsg(), (String)ApiErrCodeEnum.BILL_WITHDRAW_NON_EPINFO.getCode());
        }
        QFilter qFilter = new QFilter("epinfo", "=", epInfoObj.getPkValue());
        qFilter.and("enterprisemainorg", "=", (Object)"1");
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"", (QFilter[])qFilter.toArray());
        return org.getPkValue();
    }

    private Map<String, String> check(BillWithdrawRequestVo rVo) {
        String sellerTaxpayerId;
        HashMap<String, String> rMap = new HashMap<String, String>(2);
        rMap.put("code", ApiErrCodeEnum.OK.getCode());
        rMap.put("msg", ApiErrCodeEnum.OK.getMsg());
        String string = sellerTaxpayerId = StringUtils.isBlank((CharSequence)rVo.getSellerTaxpayerId()) ? "" : rVo.getSellerTaxpayerId();
        if (!RegexUtil.isNsrsbh((String)sellerTaxpayerId)) {
            rMap.put("code", ApiErrCodeEnum.BILL_WITHDRAW_ILLEGAL_TAX_NO.getCode());
            rMap.put("msg", ApiErrCodeEnum.BILL_WITHDRAW_ILLEGAL_TAX_NO.getMsg());
            return rMap;
        }
        if (null == rVo.getSerialNos() || rVo.getSerialNos().isEmpty()) {
            rMap.put("code", ApiErrCodeEnum.BILL_WITHDRAW_NON_BILL_NO.getCode());
            rMap.put("msg", ApiErrCodeEnum.BILL_WITHDRAW_NON_BILL_NO.getMsg());
            return rMap;
        }
        if (rVo.getSerialNos().size() > 50) {
            rMap.put("code", ApiErrCodeEnum.BILL_WITHDRAW_LIMIT.getCode());
            rMap.put("msg", ApiErrCodeEnum.BILL_WITHDRAW_LIMIT.getMsg());
        }
        return rMap;
    }

    private List<ExceptionBillNo> filterOkBillNo(List<String> billNoList, Object orgId) {
        ArrayList<ExceptionBillNo> filterBillList = new ArrayList<ExceptionBillNo>(billNoList.size());
        for (String billNo : billNoList) {
            DynamicObject[] billRelations;
            QFilter billFilter = new QFilter("billno", "=", (Object)billNo).and("orgid", "=", orgId);
            DynamicObject billObj = BusinessDataServiceHelper.loadSingle((String)"sim_original_bill", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill", (boolean)false), (QFilter[])billFilter.toArray());
            ExceptionBillNo bill = new ExceptionBillNo();
            bill.setBillNo(billNo);
            if (null == billObj) {
                bill.setMessage(ApiErrCodeEnum.BILL_WITHDRAW_NON_BILL.getMsg());
                bill.setErrorCode(ApiErrCodeEnum.BILL_WITHDRAW_NON_BILL.getCode());
                bill.setMark(Integer.valueOf(0));
                filterBillList.add(bill);
                continue;
            }
            bill.setBillId(Long.valueOf(billObj.getLong("id")));
            bill.setBillSourceType(billObj.getString("billsourcetype"));
            String billSource = billObj.getString("billsource");
            if (!"2".equals(billSource) && !"5".equals(billSource)) {
                bill.setMessage(ApiErrCodeEnum.BILL_WITHDRAW_SYSTEMSOURCE_NULL.getMsg());
                bill.setErrorCode(ApiErrCodeEnum.BILL_WITHDRAW_SYSTEMSOURCE_NULL.getCode());
                bill.setMark(Integer.valueOf(0));
                filterBillList.add(bill);
                continue;
            }
            if ("2".equals(billObj.getString("validstate"))) {
                bill.setMessage(ApiErrCodeEnum.BILL_WITHDRAW_VALID_STATES_ERROR.getMsg());
                bill.setErrorCode(ApiErrCodeEnum.BILL_WITHDRAW_VALID_STATES_ERROR.getCode());
                bill.setMark(Integer.valueOf(0));
                filterBillList.add(bill);
                continue;
            }
            if (reverseBill.contains((Object)billObj.getString("billsourcetype")) && (billRelations = BusinessDataServiceHelper.load((String)"sim_bill_relation", (String)String.join((CharSequence)",", "sbillid", "tbillid"), (QFilter[])new QFilter("sbillid", "in", billObj.getPkValue()).toArray())).length > 0) {
                bill.setMessage(ApiErrCodeEnum.BILL_WITHDRAW_EXIST_REPLAY_NULL.getMsg());
                bill.setErrorCode(ApiErrCodeEnum.BILL_WITHDRAW_EXIST_REPLAY_NULL.getCode());
                bill.setMark(Integer.valueOf(0));
                filterBillList.add(bill);
                continue;
            }
            String issueCacheKey = CacheHelper.get((String)(DynamicObjectUtil.getDynamicObjectLongValue((Object)billObj.get("orgid")) + "!!!" + billObj.getString("billno")));
            String processCacheKey = CacheHelper.get((String)(billObj.getPkValue() + "workbench"));
            if (StringUtils.isNotBlank((CharSequence)issueCacheKey) || StringUtils.isNotBlank((CharSequence)processCacheKey)) {
                bill.setMessage(ApiErrCodeEnum.BILL_WITHDRAW_PROCESS_NULL.getMsg());
                bill.setErrorCode(ApiErrCodeEnum.BILL_WITHDRAW_PROCESS_NULL.getCode());
                bill.setMark(Integer.valueOf(0));
                filterBillList.add(bill);
                continue;
            }
            if ("0".equals(billObj.getString("confirmstate")) && "1".equals(ImcConfigUtil.getValue((String)"sim_original_bill", (String)OpenApiInterfaceCodeEnum.BILL_WITHDRAW.getCode().replace(".", "_").toLowerCase()))) {
                bill.setMark(Integer.valueOf(1));
                filterBillList.add(bill);
                continue;
            }
            this.checkRelationInvoices(bill, billObj);
            String errCode = bill.getErrorCode();
            if (!StringUtils.equals((CharSequence)errCode, (CharSequence)ErrorType.SUCCESS.getCode())) {
                StringBuilder tipMsg = new StringBuilder();
                for (String failMsg : bill.getFailMessageList()) {
                    tipMsg.append(failMsg).append(';');
                }
                bill.setMessage(tipMsg.toString());
                bill.setErrorCode(ApiErrCodeEnum.BILL_WITHDRAW_IRREVOCABLE.getCode());
                bill.setMark(Integer.valueOf(0));
                filterBillList.add(bill);
                continue;
            }
            bill.setMark(Integer.valueOf(1));
            filterBillList.add(bill);
        }
        return filterBillList;
    }

    private void checkRelationInvoices(ExceptionBillNo exceptionResult, DynamicObject originalBill) {
        LOGGER.info(String.format("checkRelationInvoices\uff1a%s", originalBill.getString("billno")));
        DynamicObject[] billRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)String.join((CharSequence)",", "tbillid", "ttable", "tbillno"), (QFilter[])new QFilter("sbillid", "=", originalBill.getPkValue()).toArray());
        if (billRelations == null || billRelations.length == 0) {
            if (!"0".equals(originalBill.getString("confirmstate")) && QueryServiceHelper.exists((String)"sim_matchbill_relation", (QFilter[])new QFilter("sbillid", "=", originalBill.getPkValue()).toArray())) {
                exceptionResult.setErrorCode(ErrorType.FAIL.getCode());
                exceptionResult.setFailMessageList(Collections.singletonList(String.format(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5173\u8054\u5339\u914d\u5355\uff0c\u65e0\u6cd5\u56de\u9000\uff0c\u5355\u636e\u7f16\u53f7[%s]", (String)"BillWithdrawImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]), originalBill.getString("billno"))));
                return;
            }
            exceptionResult.setErrorCode(ErrorType.SUCCESS.getCode());
            return;
        }
        if ("0".equals(originalBill.getString("confirmstate"))) {
            exceptionResult.setErrorCode(ErrorType.FAIL.getCode());
            exceptionResult.setFailMessageList(Collections.singletonList(String.format(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5173\u8054\u53d1\u7968\uff0c\u65e0\u6cd5\u56de\u9000\uff0c\u5355\u636e\u7f16\u53f7[%s]", (String)"BillWithdrawImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]), originalBill.getString("billno"))));
            return;
        }
        HashSet<Object> invoieIdSet = new HashSet<Object>(billRelations.length);
        HashMap<DynamicObject[], Object> red2InvoiceIdMap = new HashMap<DynamicObject[], Object>(billRelations.length);
        ArrayList<String> tipMessageList = new ArrayList<String>(billRelations.length);
        for (DynamicObject billRelation : billRelations) {
            DynamicObject waitInvoice;
            DynamicObject[] tBillId = billRelation.get("tbillid");
            if (red2InvoiceIdMap.containsKey(tBillId)) continue;
            String tTable = billRelation.getString("ttable");
            if ("sim_red_confirm_bill".equals(tTable)) {
                DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "orderno", "uploadstatus", "confirmstatus", "number", "govuuid", "salertaxno", "source", "uploaddate", "originalinvoicecode", "originalinvoiceno", "occupystatus", "applicant", "uploadbatchno"), (QFilter[])new QFilter("id", "=", (Object)tBillId).toArray());
                if (redConfirms.length == 0) continue;
                for (DynamicObject redConfirm : redConfirms) {
                    boolean isBack;
                    boolean bl = isBack = "0".equals(redConfirm.getString("uploadstatus")) || RedConfirmStatusEnum.validConfirmStatus.contains((Object)redConfirm.getString("confirmstatus"));
                    if ("2".equals(redConfirm.getString("uploadstatus")) && !(isBack = RedConfirmBillHelper.isAllowDelFailRedComfrimBill((Object)redConfirm.getPkValue()))) {
                        tipMessageList.add(String.format(ResManager.loadKDString((String)"\u7a0e\u5c40\u67e5\u8be2\u7ea2\u5b57\u786e\u8ba4\u5355\u72b6\u6001\u4e3a\u5df2\u5f55\u5165\uff0c\u8bf7\u5148\u66f4\u65b0\u7ea2\u5b57\u786e\u8ba4\u5355\u72b6\u6001", (String)"BillWithdrawImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]), new Object[0]));
                        exceptionResult.setErrorCode(ErrorType.FAIL.getCode());
                        exceptionResult.setFailMessageList(tipMessageList);
                        return;
                    }
                    if (!isBack) {
                        tipMessageList.add(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u4e0d\u6ee1\u8db3\u56de\u9000\u6761\u4ef6,\u786e\u8ba4\u72b6\u6001\u4e3a%s", (String)"BillWithdrawImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]), RedConfirmStatusEnum.getBillCodeByDesc((String)redConfirm.getString("confirmstatus"))));
                        exceptionResult.setErrorCode(ErrorType.FAIL.getCode());
                        exceptionResult.setFailMessageList(tipMessageList);
                        return;
                    }
                    if (exceptionResult.getRedConfirms() == null) {
                        exceptionResult.setRedConfirms(new HashSet(redConfirms.length));
                    }
                    exceptionResult.getRedConfirms().add(redConfirm);
                    waitInvoice = RedConfirmBillHelper.getInvoiceFromRedConfirm((DynamicObject)redConfirm);
                    if (waitInvoice == null) continue;
                    red2InvoiceIdMap.put(tBillId, waitInvoice.getPkValue());
                    invoieIdSet.add(waitInvoice.getPkValue());
                }
                continue;
            }
            if ("sim_red_info".equals(tTable)) {
                DynamicObject[] redInfos = BusinessDataServiceHelper.load((String)"sim_red_info", (String)String.join((CharSequence)",", "infocode", "org", "infosource"), (QFilter[])new QFilter("id", "=", (Object)tBillId).toArray());
                if (redInfos.length == 0) continue;
                for (DynamicObject redInfo : redInfos) {
                    QFilter qFilter = new QFilter("orgid", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)redInfo.get("org"))).and("infocode", "=", (Object)redInfo.getString("infocode")).and("invoicestatus", "!=", (Object)"6");
                    waitInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"", (QFilter[])qFilter.toArray());
                    if (waitInvoice == null) continue;
                    if (exceptionResult.getRedInfos() == null) {
                        exceptionResult.setRedInfos(new HashSet(redInfos.length));
                    }
                    exceptionResult.getRedInfos().add(redInfo);
                    red2InvoiceIdMap.put(tBillId, waitInvoice.getPkValue());
                    invoieIdSet.add(waitInvoice.getPkValue());
                }
                continue;
            }
            invoieIdSet.add(tBillId);
        }
        QFilter invoiceFilter = new QFilter("orgid", "=", originalBill.getDynamicObject("orgid").getPkValue());
        invoiceFilter.and("id", "in", invoieIdSet);
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)WaitInvoiceControl.checkAllEIssueField, (QFilter[])invoiceFilter.toArray());
        if (invoices == null || invoices.length == 0) {
            exceptionResult.setErrorCode(ErrorType.SUCCESS.getCode());
            return;
        }
        int noneCount = 0;
        ArrayList<DynamicObject> failInvoices = new ArrayList<DynamicObject>(invoices.length);
        for (DynamicObject invoice2 : invoices) {
            String issueStatus = invoice2.getString("issuestatus");
            if (!IssueStatusEnum.none.getCode().equals(issueStatus) && !IssueStatusEnum.failed.getCode().equals(issueStatus)) {
                tipMessageList.add(String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7\u4e3a%s\u53d1\u7968\u5f00\u7968\u72b6\u6001\u4e0d\u652f\u6301\u56de\u64a4\uff0c\u4ec5\u652f\u6301\u3010\u672a\u5f00\u7968\u3001\u5f00\u7968\u5931\u8d25\u3011\u56de\u64a4", (String)"BillWithdrawImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]), invoice2.getString("orderno")));
            }
            if (IssueStatusEnum.none.getCode().equals(issueStatus)) {
                ++noneCount;
                continue;
            }
            if (!IssueStatusEnum.failed.getCode().equals(issueStatus)) continue;
            failInvoices.add(invoice2);
        }
        if (!CollectionUtils.isEmpty(tipMessageList)) {
            exceptionResult.setErrorCode(ErrorType.FAIL.getCode());
            exceptionResult.setFailMessageList(tipMessageList);
            return;
        }
        if (noneCount == invoices.length) {
            exceptionResult.setErrorCode(ErrorType.SUCCESS.getCode());
            exceptionResult.setFailInvoiceIds(Arrays.stream(invoices).map(invoice -> invoice.getLong("id")).collect(Collectors.toList()));
            return;
        }
        try {
            List issuedInvoiceList = new WaitInvoiceControl().getIssuedInvoiceList(failInvoices.toArray(new DynamicObject[0]));
            if (CollectionUtils.isEmpty((Collection)issuedInvoiceList)) {
                LOGGER.info("\u5f85\u5f00\u90fd\u6ca1\u6709\u5f00\u5177\u6210\u529f");
            } else {
                for (JSONObject invoiceJson : issuedInvoiceList) {
                    String description = invoiceJson.getString("description");
                    if (StringUtils.isNotBlank((CharSequence)description)) {
                        tipMessageList.add(description);
                        continue;
                    }
                    tipMessageList.add(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u6d41\u6c34\u53f7%1$s\u5b58\u5728\u5df2\u5f00\u53d1\u7968\uff0c\u53d1\u7968\u4ee3\u7801%2$s\uff0c\u53d1\u7968\u53f7\u7801%3$s\uff1b", (String)"BillWithdrawImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]), invoiceJson.getString("fplsh"), invoiceJson.getString("fpdm"), invoiceJson.getString("fphm")));
                }
            }
        }
        catch (KDBizException e) {
            LOGGER.error("getIssuedInvoiceList\u5f02\u5e38", (Throwable)e);
            tipMessageList.add(e.getMessage());
        }
        if (CollectionUtils.isEmpty(tipMessageList)) {
            exceptionResult.setFailInvoiceIds(Arrays.stream(invoices).map(invoice -> invoice.getLong("id")).collect(Collectors.toList()));
            exceptionResult.setErrorCode(ErrorType.SUCCESS.getCode());
            return;
        }
        exceptionResult.setErrorCode(ErrorType.FAIL.getCode());
        exceptionResult.setFailMessageList(tipMessageList);
    }
}

