/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.redconfirm;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.RedConfirmHelper;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.common.vo.redconfirm.RedConfirmRevokeRequestDTO;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillMailHelper;
import kd.imc.sim.formplugin.redconfirm.op.RedConfirmBillRevokeOp;

public class RedConfirmBillRevokeServiceImpl
implements OpenApiService {
    private static final Log log = LogFactory.getLog(RedConfirmBillRevokeServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        String msg;
        RedConfirmRevokeRequestDTO invoiceDto;
        if (log.isInfoEnabled()) {
            log.info(String.format("\u4e1a\u52a1\u7cfb\u7edf[%s]\u64a4\u9500\u7ea2\u5b57\u786e\u8ba4\u5355\u4f20\u5165\u53c2\u6570[%s]", requestVo.getBusinessSystemCode(), requestVo.getData()));
        }
        if ((invoiceDto = (RedConfirmRevokeRequestDTO)JSONObject.parseObject((String)requestVo.getData(), RedConfirmRevokeRequestDTO.class)) == null || StringUtils.isBlank((CharSequence)invoiceDto.getNumber())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_EMPTY_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (String)"RedConfirmBillRevokeServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!StringUtils.equals((CharSequence)invoiceDto.getEnteridentity(), (CharSequence)"0") && !StringUtils.equals((CharSequence)invoiceDto.getEnteridentity(), (CharSequence)"1")) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_ENTERIDENTITY_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u5f55\u5165\u65b9\u9519\u8bef", (String)"RedConfirmBillRevokeServiceImpl_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)invoiceDto.getTaxNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_TAXPAYERID_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u7a0e\u53f7\u4f20\u5165\u4e0d\u5408\u6cd5", (String)"RedConfirmBillRevokeServiceImpl_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)invoiceDto.getQrlx()) || !StringUtils.equalsIgnoreCase((CharSequence)invoiceDto.getQrlx(), (CharSequence)"C")) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_EMPTY_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u4f20\u5165\u4e0d\u5408\u6cd5", (String)"RedConfirmBillRevokeServiceImpl_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        DynamicObject redConfirmBill = RedConfirmBillRevokeServiceImpl.redConfirmBillQuery(invoiceDto);
        if (redConfirmBill == null) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_EMPTY_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u7ea2\u5b57\u786e\u8ba4\u5355", (String)"RedConfirmBillRevokeServiceImpl_6", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        String revokeTaxNo = RedConfirmHelper.getRedConfirmRevokeTaxNo((DynamicObject)redConfirmBill);
        if (StringUtils.isBlank((CharSequence)revokeTaxNo)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_EMPTY_ERROR.getCode(), (String)ResManager.loadKDString((String)"\u8be5\u7ea2\u5b57\u786e\u8ba4\u5355\u72b6\u6001\u4e0d\u7b26\u5408\u64a4\u9500\u6761\u4ef6\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500", (String)"RedConfirmBillRevokeServiceImpl_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!revokeTaxNo.equals(invoiceDto.getTaxNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_BILL_REVOKE_TAXNO_FAIL.getCode(), (String)String.format(ApiErrCodeEnum.REDCONFIRMBILL_BILL_REVOKE_TAXNO_FAIL.getMsg(), invoiceDto.getTaxNo(), revokeTaxNo));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)redConfirmBill.getString("salertaxno"), (CharSequence)invoiceDto.getTaxNo()) && !StringUtils.equalsIgnoreCase((CharSequence)redConfirmBill.getString("buyertaxno"), (CharSequence)invoiceDto.getTaxNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.NOT_FIND_INV_BY_SELLER_TAX_NO.getCode(), (String)ResManager.loadKDString((String)"\u7a0e\u53f7\u4e0e\u7ea2\u5b57\u786e\u8ba4\u5355\u4e0d\u5339\u914d", (String)"RedConfirmBillRevokeServiceImpl_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (EnterpriseHelper.isLqptChannel((String)invoiceDto.getTaxNo())) {
            return this.redConfirmBillDetermine(redConfirmBill, invoiceDto);
        }
        String account = invoiceDto.getAccount();
        String taxNo = invoiceDto.getTaxNo();
        if (StringUtils.isNotBlank((CharSequence)account) && StringUtils.isNotBlank((CharSequence)(msg = AllEleAuthHelper.checkIssueAccount((String)taxNo, (String)account)))) {
            return ResponseVo.fail((String)ApiErrCodeEnum.BILL_PUSH_BILL_ERROR.getCode(), (String)msg);
        }
        return this.redConfirmBillDetermine(redConfirmBill, invoiceDto);
    }

    public static DynamicObject redConfirmBillQuery(RedConfirmRevokeRequestDTO invoiceDto) {
        QFilter filter = new QFilter("number", "=", (Object)invoiceDto.getNumber());
        filter.and("enteridentity", "=", (Object)invoiceDto.getEnteridentity());
        DynamicObject redConfirmBill = BusinessDataServiceHelper.loadSingle((String)"sim_red_confirm_bill", (String)"id", (QFilter[])new QFilter[]{filter});
        if (redConfirmBill != null) {
            redConfirmBill = BusinessDataServiceHelper.loadSingle((Object)redConfirmBill.getPkValue(), (String)"sim_red_confirm_bill");
        }
        return redConfirmBill;
    }

    public ApiResult redConfirmBillGoRevoke(DynamicObject redConfirmBill, String account) {
        String confirmStatus = redConfirmBill.getString("confirmstatus");
        RedConfirmBillRevokeOp.redConfirmBillRevokeMethod((DynamicObject)redConfirmBill, (String)account);
        if (StringUtils.equals((CharSequence)redConfirmBill.getString("confirmstatus"), (CharSequence)confirmStatus)) {
            return ResponseVo.fail((String)ApiErrCodeEnum.REDCONFIRMBILL_REVOKE_FAIL.getCode(), (String)redConfirmBill.getString("failreason"));
        }
        ImcSaveServiceHelper.save((DynamicObject)redConfirmBill);
        RedConfirmBillMailHelper.deletePushRecord((List)Lists.newArrayList((Object[])new Object[]{redConfirmBill.getPkValue()}));
        return ResponseVo.success((String)ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f", (String)"RedConfirmBillRevokeServiceImpl_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
    }

    public ApiResult redConfirmBillDetermine(DynamicObject redConfirmBill, RedConfirmRevokeRequestDTO invoiceDto) {
        return this.redConfirmBillGoRevoke(redConfirmBill, invoiceDto.getAccount());
    }
}

