/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.service.impl.vehicle;

import com.alibaba.fastjson.JSONObject;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.dto.VehicleInvoicePrintDTO;
import kd.imc.sim.formplugin.openapi.service.OpenApiService;

public class VehicleInvoicePrintPageServiceImpl
implements OpenApiService {
    private static Log LOGGER = LogFactory.getLog(VehicleInvoicePrintPageServiceImpl.class);

    @Override
    public ApiResult processer(RequestVo requestVo) {
        DynamicObject[] invoiceList;
        String data = requestVo.getData();
        VehicleInvoicePrintDTO vehicleInvoice = (VehicleInvoicePrintDTO)((Object)JSONObject.parseObject((String)data, VehicleInvoicePrintDTO.class));
        if (StringUtils.isBlank((CharSequence)vehicleInvoice.getInvoiceNo())) {
            return ResponseVo.fail((String)ApiErrCodeEnum.VEHICLE_INVOICE_EMPTY_INVOICE.getCode(), (String)ApiErrCodeEnum.VEHICLE_INVOICE_EMPTY_INVOICE.getMsg());
        }
        QFilter invoiceNoFilter = new QFilter("invoiceno", "=", (Object)vehicleInvoice.getInvoiceNo());
        if (StringUtils.isBlank((CharSequence)vehicleInvoice.getInvoiceCode())) {
            invoiceNoFilter = new QFilter("invoicecode", "=", (Object)vehicleInvoice.getInvoiceCode()).and(invoiceNoFilter);
        }
        if ((invoiceList = BusinessDataServiceHelper.load((String)"sim_vatinvoice_vehicles", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice_vehicles", (boolean)true), (QFilter[])invoiceNoFilter.toArray())).length == 0) {
            return ResponseVo.fail((ApiErrCodeEnum)ApiErrCodeEnum.VEHICLE_INVOICE_PRINT_NO_INVOICE);
        }
        String pkValue = String.valueOf(invoiceList[0].getPkValue());
        String uuid = UUID.randomUUID();
        CacheHelper.put((String)uuid, (String)pkValue, (int)600);
        String systemBaseUrl = ImcConfigUtil.getValue((String)"ImcSystemBaseUrl", (String)"ImcSystemBaseUrl");
        if (StringUtils.isBlank((CharSequence)systemBaseUrl)) {
            return ResponseVo.fail((String)ErrorType.FAIL.getCode(), (String)ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u673a\u52a8\u8f66\u6253\u5370\u9875baseUrl,\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u914d\u7f6e", (String)"VehicleInvoicePrintPageServiceImpl_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        String url = systemBaseUrl + "/index.html?userId=Guest&formId=sim_vatinvoice_vehicles&vechiclePrint=" + uuid + "&accountId=" + RequestContext.get().getAccountId();
        JSONObject resultData = new JSONObject();
        resultData.put("url", (Object)url);
        return ResponseVo.success((String)resultData.toJSONString());
    }
}

