/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.split.service;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.imc.sim.split.dto.BillDealResultDto;
import kd.imc.sim.split.dto.BillDetailDto;
import kd.imc.sim.split.dto.BillSubjectDto;
import kd.imc.sim.split.dto.SmruleConfigDto;
import kd.imc.sim.split.methods.BillCheckMethods;

public class BillsCheckService {
    private static BillCheckMethods billCheckMethods = new BillCheckMethods();

    public static void billItemsCheck(BillSubjectDto billSubjectDto, SmruleConfigDto configDto) {
        List<BillDetailDto> billDetailDtoList = billSubjectDto.getBillDList();
        for (int i = 0; i < billDetailDtoList.size(); ++i) {
            BillDetailDto detailDto = billDetailDtoList.get(i);
            Integer lineProperty = detailDto.getLineProperty();
            String billDetailNO = detailDto.getBillDetailNO();
            BigDecimal taxRate = detailDto.getTaxRate();
            BigDecimal amount = detailDto.getAmounts();
            BigDecimal price = detailDto.getPrice();
            BigDecimal dec = detailDto.getTaxDeduction();
            if (price == null || price.compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u4ef7\u4e0d\u5141\u8bb8\u5c0f\u4e8e0", (String)"BillsCheckService_0", (String)"imc-sim-split", (Object[])new Object[0]));
            }
            if (taxRate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillsCheckService_1", (String)"imc-sim-split", (Object[])new Object[0]));
            }
            billCheckMethods.checkNull(billDetailNO, detailDto, i + 1, ResManager.loadKDString((String)"\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u672a\u4f20\u5165", (String)"BillsCheckService_2", (String)"imc-sim-split", (Object[])new Object[0]));
            billCheckMethods.specilNo0TaxRate(taxRate, billSubjectDto.getInvKind(), detailDto, i + 1, ResManager.loadKDString((String)"\u7a0e\u7387\u4e3a0\u4e0d\u5141\u8bb8\u5f00\u4e13\u7968", (String)"BillsCheckService_3", (String)"imc-sim-split", (Object[])new Object[0]));
            billCheckMethods.verfTaxRateNew(taxRate, detailDto, i + 1, ResManager.loadKDString((String)"\u7a0e\u7387\u4e0d\u5408\u6cd5", (String)"BillsCheckService_4", (String)"imc-sim-split", (Object[])new Object[0]));
            billCheckMethods.taxRate15NotMultiTax(billDetailDtoList, taxRate, detailDto, i + 1, ResManager.loadKDString((String)"\u51cf\u514d1.5\u8ba1\u7a0e\u65f6\u4e0d\u5141\u8bb8\u5f00\u5177\u591a\u7a0e\u7387", (String)"BillsCheckService_5", (String)"imc-sim-split", (Object[])new Object[0]));
            billCheckMethods.decNottaxRate15(dec, taxRate, detailDto, i + 1, ResManager.loadKDString((String)"\u5dee\u989d\u53d1\u7968\u4e0d\u80fd\u5f00\u51771.5\u7a0e\u7387", (String)"BillsCheckService_6", (String)"imc-sim-split", (Object[])new Object[0]));
            billCheckMethods.disLineMoneyNotGt0(amount, lineProperty, detailDto, i + 1, ResManager.loadKDString((String)"\u6298\u6263\u884c\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e0", (String)"BillsCheckService_7", (String)"imc-sim-split", (Object[])new Object[0]));
            billCheckMethods.discount1LineNotExist(billDetailDtoList, detailDto, i + 1);
            billCheckMethods.discountNLineNotExist(billDetailDtoList, detailDto, i + 1);
            billCheckMethods.checkDisRows(detailDto, i + 1, ResManager.loadKDString((String)"\u6298\u6263\u884c\u6570\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e-1", (String)"BillsCheckService_8", (String)"imc-sim-split", (Object[])new Object[0]));
            billCheckMethods.checkNDline(detailDto, i + 1);
        }
        billCheckMethods.checkBillTotal(billSubjectDto);
    }

    public static BillDealResultDto getBDR(String billNO, boolean success, String errorMsg) {
        BillDealResultDto bdr = new BillDealResultDto();
        bdr.setBillNO(billNO);
        bdr.setSuccess(success);
        bdr.setErrorMsg(errorMsg);
        return bdr;
    }
}

