var CamareJs = function(){
    console.log('泛微的拍照系统');
};
CamareJs.prototype = {
    constructor : CamareJs,
    init: function(opt, flexKey, fileType, cback){
        var arr = flexKey.split(',');
		var farrs = fileType.split('|'); //可上传的文件类型
		for(var i = 0; i < arr.length; i++) {
			var flexName = arr[i];
			console.log('flexName的值', flexName);
			const fileOuterBox = document.getElementById(flexName);
			if (fileOuterBox.querySelector('.photoBox')) {
				console.log('input file已经存在，不需要新增', flexName);
				continue;
			}
			const outEl = document.createElement('div');
			outEl.className = 'photoBox';
			const inputEl = document.createElement('div');
			inputEl.className = 'inputFile';
			inputEl.setAttribute('flexName', flexName);
			outEl.appendChild(inputEl);
			document.getElementById(flexName).appendChild(outEl);

            if(flexName == 'imageap_upload_file' || flexName == 'imageap_attach_file') {
                inputEl.onclick = function(e) {
                    const curFlexName = e.target.getAttribute('flexName');
                    console.log('点击按钮', curFlexName);
                    cback({ errcode: '0000', flexName: curFlexName, inputObj: e });
                };
            } else {
                inputEl.onclick = function(e) {
                    const curFlexName = e.target.getAttribute('flexName');
                    console.log('点击按钮', curFlexName);
                    try {
                        em.ready(function() {
                            if (em.checkJsApi("chooseImage")) {
                                console.log('em.chooseImage', em);
                                em.chooseImage({
                                    count: opt.multiple ? 9 : 1, // 默认9 int
                                    sourceType: ['album', 'camera'], // 可以指定来源是相册还是相机，默认二者都有
                                    shotAlbum: 1,  //连拍是否可以选相册，1可以
                                    watermark: 0,  //是否添加地理位置水印
                                    noSaveImageToPhotoLibrary: false,  //拍照是是否保存到相册，true不保存，false保存
                                    cameraDevice:'front', //调用相机时指定前置摄像头
                                    compression: true, // 是否压缩
                                    ratio: 0.98, // float  压缩比例
                                    success: function(res) {
                                        console.log('泛微success', res);
                                        cback({ errcode: '0000', ...res, flexName: curFlexName, inputObj: e });
                                    },
                                    fail: function(err) {
                                        console.log('泛微fail', err);
                                        cback({ errcode: '0001', description: err.errMsg, ...err, flexName: curFlexName });
                                    }
                                });
                            } else {
                                console.log('没找到chooseImage方法')
                            }
                        });
                    } catch (error) {
                        console.log("处理异常: " + error);
                    }
                };
            }
		}
    },
    updateFile: function(model ,opt, result) { 
        if (result.errcode === '0000') {
			var _this = this;
            if (result.flexName == 'imageap_upload_file' || result.flexName == 'imageap_attach_file') {
				console.log('文件上传---', result.flexName);
				em.ready(function() {
                    if (em.checkJsApi("uploadFile2Doc")) {
						console.log('em.uploadFile2Doc');
                        em.uploadFile2Doc({
                            fileUploadUrl: opt.url,
                            maxFilesNumber: '9',
                            maxUploadSize: '20',
                            totalMaxUploadSize: '50',
                            limitType: 'pdf,ofd,png,jpg,jpeg',
                            formData: {"appId":"rim","fId":opt.fid},
                            //其他参数
                            header:{},
                            //请求头
                            multipleFile: 1,
                            uploadParams: {},
                            success: function(res) {
                                console.log('success---', res)
                                // res.result: []
								const successArr = [];
								if (!res.success || !res.success.length) {
                                    return;
                                }
                                model.invoke('cameraUploadStart', result.flexName);
								for(let i = 0; i < res.success.length; i++) {
									successArr.push({"errcode":'0000',"status":'success',"name":res.success[i].fileName,"url":res.success[i].url});
								}
								console.log('文件上传---', successArr);
								result.inputObj.target.value = '';
								const successDatas = {
									"flex": result.flexName,
									"fileArray": successArr
								};
								console.log('全部文件上传完成', successDatas);
								model.invoke('cameraUpload', successDatas);
                            },
                            fail: function(error) {
                                console.log('文件上传失败---', error);
                            }
                        })
                    } else {
                        console.log('没找到uploadFile2Doc方法');
                    }
                });
            } else {
                // formats: ['jpeg'], localIds: [], localPaths: [], sizes: []
                console.log('getLocalImgData');
                em.getLocalImgData({
                    localId: result.localIds, // 图片的localID（由chooseImage获取，支持单个字符串或数组）
                    success: function (res) {
                        console.log('getLocalImgData---', res);
                        let localData = res.localData; // localData是图片的base64数据（如果localId为数组，则localData为base64数组），可以用img标签显示，另外返回的base64数据不带data:image/jpeg;base64,前缀，请自行添加
                        let fileList = [];
                        if (!Array.isArray(localData)) {
                            localData = JSON.parse(res.localData);
                        }
    
                        for(let i = 0; i < localData.length; i++) { 
                            const item = localData[i];
                            let filename = result.localPaths[i].split('/').pop();
                            const fileformats = result.formats[i].split('.').pop();
    
                            const fdStart = filename.indexOf(".");
                            if(fdStart == 0){
                                filename = new Date().getTime() + filename;
                            }
                            console.log('filename---', filename);
                            console.log('fileformats---', fileformats);
                            const fileSuffixObj = {
                                png: 'image/png',
                                jpg: 'image/jpg',
                                jpeg: 'image/jpeg'
                            };
                            const type = fileSuffixObj[fileformats];
                            const file = type ? 'data:'+ type +';base64, ' + item : item;
                            const blob = _this.base64ToBlob(file);
                            const dataFile = new File([blob], filename, { type: blob.type });
                            fileList.push(dataFile);
                        }
                        console.log('fileList---', fileList);
    
                        model.invoke('cameraUploadStart', result.flexName);
                        console.log('model---', model);
                        const successArr = [];
                        UploadFiles.upload(opt.url, fileList, {
                            uploadData:{"appId":"rim","fId":opt.fid},
                            fileLimitSize: 3, // 大于3M才压缩
                            fileQuality: 0.98, // 清晰度
                            fileLimitPixel: 1500, // 原始像素小于该值则不处理
                            stepUploadFinish: function(val) { 
                                console.log('单个文件上传结束', val);
                                const file = val.file;
                                successArr.push({"errcode":val.errcode,"status":val.status,"size":file.size,"type":file.type,"name":file.name,"url":val.url});
                            },
                            uploadFinish: function() {
                                result.inputObj.target.value = '';
                                const successDatas = {
                                    "flex": result.flexName,
                                    "fileArray": successArr
                                };
                                console.log('全部文件上传完成', successDatas);
                                console.log('model2---', model);
                                try {
                                    model.invoke('cameraUpload', successDatas);	
                                } catch (error) {
                                    console.log('error---', error);
                                }						
                            }
                        });
                    }
                });
            }
        } else {
			console.log('上传失败----', result);
        }
    },
    base64ToBlob: function(base64, mimeType = 'image/jpeg') {
        let arr;
        let mime;
        let bstr;

        // 检查是否包含 data: 前缀
        if (base64.startsWith('data:')) {
            arr = base64.split(',');
            mime = arr[0].match(/:(.*?);/)[1];
            bstr = atob(arr[1]);
        } else {
            // 如果没有 data: 前缀，直接解码 base64 字符串
            bstr = atob(base64);
            mime = mimeType; // 使用传入的 MIME 类型，默认为 'image/jpeg'
        }

        let n = bstr.length;
        const u8arr = new Uint8Array(n);

        while (n--) {
            u8arr[n] = bstr.charCodeAt(n);
        }

        return new Blob([u8arr], { type: mime });
    }
}