(function (KDApi, $, _) {
    function MyComponent(model) {
        this._setModel(model);
    }

    var isUpdate = false;
    var model;

    MyComponent.prototype = {
        _setModel: function (model) {
            this.model = model;
        },
        init: function (props) {
            isUpdate = false;
            model = this.model;
        },
        update: function (props) {
            isUpdate = true;
            model = this.model;
            updateHtml(this.model, props);
        },
        destoryed: function () {

        }
    };

    var updateHtml = function (model, props) {
        var popsData = {};
        if (props != null && props.data != null) {
            popsData = props.data;
        }
        var eventKey = popsData['eventKey'];
        switch (eventKey) {
            case "download":
                downloadFile(popsData.url);
                break;
        }
    };

    // const buttonId = "down_button";
    // function downloadFile3(url) {
    //     let button = document.getElementById(buttonId);
    //     if (!button) {
    //         button = document.createElement("button");
    //         button.id = buttonId;
    //         document.body.appendChild(button);
    //     }
    //     button.onclick = function () {
    //         window.open(url, '_self');
    //     };
    //     button.click();
    // }

    function downloadFile(url) {
        let isIOS = /iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;
        if (isIOS) {
            window.location.href = url;
        } else {
            androidDownloadFile(url);
        }
    }

    const iframeId = "down_iframe";
    const linkId = "down_a";
    function androidDownloadFile(url) {
        let iframe = document.getElementById(iframeId);
        if (!iframe) {
            iframe = document.createElement("iframe");
            iframe.setAttribute("hidden", "hidden");
            iframe.name = "downloadFile";
            iframe.id = iframeId;
            document.body.appendChild(iframe);
        }

        let link = document.getElementById(linkId);
        if (!link) {
            link = document.createElement("a");
            link.id = linkId;
            link.target = "downloadFile";
            document.body.appendChild(link);
        }
        link.href = url;
        link.click();
    }

    KDApi.register('filedownload', MyComponent)
})(window.KDApi);
