
(function(KDApi,$,_){ 
    function MyComponent(model){
        this._setModel(model);
    }

    var isUpdate = false;
	var boxWidth = 0;
	var boxHeight = 0;
	var isLoadLibs = false;
	var docEditor =null;
    MyComponent.prototype = {
        _setModel: function(model) {
            this.model = model;
        },
        init:function(props){
          console.log('-----init',this.model,props)
          isUpdate = false; 
          setHtml(this.model,props,isUpdate);
        },
        update:function(props){
		if(docEditor){
			docEditor.destroyEditor();
		}
		//const onlyOfficeDom = document.getElementById("imcplaceholder");
		//if (onlyOfficeDom) {
		//	onlyOfficeDom.remove();
		//}
          console.log('-----update',this.model,props)
          isUpdate = true;  
          setHtml(this.model,props,isUpdate);
        },
        destoryed:function(){
            console.log('-----destoryed',this.model)
        }
    }     	
	var setHtml = function(model,props,isUpdate){   
		var data={};   
		var pageId;
		var flexKey;
		var list=[];
		var areaInfo=[];
		var displayFlag;
		var currentIndex=0;
		var previewType=0;
		var showBtn=true;
		let loadFileArray=['../common/pwyPolyfill.js','./fullScanImages.js'];
		let httpResource=null;
		var wpsView;
		var wpsDomain;
		var wpsAppId;
		var wpsTokenType;
		var accountId;
		if(props!=null&&props.data!=null){
			var popsData=props.data; 
			pageId=popsData['pageId'];  
			flexKey=popsData['flexKey'];  
			displayFlag=popsData['displayFlag'];  
			previewType=popsData['previewType'];  
			list=popsData.list;
			if (popsData.currentIndex != null){
				currentIndex=popsData.currentIndex;
			}
			showBtn=popsData['showBtn'];  
			wpsView=popsData['wpsView'];
			wpsDomain=popsData['wpsDomain'];
			wpsAppId=popsData['wpsAppId'];
			wpsTokenType=popsData['wpsTokenType'];
			accountId=popsData['accountId'];
			if(showBtn==null){
				showBtn=true;
			}
			if (popsData['customjs']) {
				customjs = popsData['customjs']; 
				customjs = customjs.split(",");
				for(const cameraJsFile of customjs){
					// 使用示例
					if(cameraJsFile.startsWith("http")){
						loadScript(cameraJsFile, function() {
							console.log(cameraJsFile);
						});
					}else{ 
						loadFileArray.push(cameraJsFile);
					}
				} 
			}
			if(list && list.length>0 && list[0].customjs){
				var cameraJsFile=list[0].customjs;
				// 使用示例
				if(cameraJsFile && cameraJsFile.startsWith("http")){
					httpResource=cameraJsFile; 
				}else if(cameraJsFile){ 
					loadFileArray.push(cameraJsFile);
				}
				 
			}
		}  
		
		var uploadImgShow = function() {
			var curRef=React.createRef();
			var boxSelect = '';
			if(flexKey.indexOf('#') != -1) {
				boxSelect = flexKey.substr(1);
			} else {
				boxSelect = flexKey;
			}			
			
			var selectorStr = '[data-page-id="' + pageId + '_' + boxSelect + '"]';	
			var domEl = $(selectorStr)[0];
			if (domEl.clientWidth > 0 && domEl.clientHeight > 0) {
				boxWidth = domEl.clientWidth;
				boxHeight = domEl.clientHeight;
			}	
			var itemUrl;
			var token = "";
			var wpsFlag = false;
			var anyOffice = false;
			var reqAyax = false;
			var fileType;
			var fileKey;
			var fileName;
			var fileDocumentType;
			const scanImages  = React.createElement(ScanImages, {
				index: currentIndex,
				style: { width: boxWidth, height: boxHeight, background: '#ccc' },
				// 图片位置的回调
				onChangeIndex: function(index, type){
					console.log('imageIndex', index, type);
					model.invoke('imageIndex', {"index":index,"type":type});
					return true;
				},
				disabledHandlerIcon: true,
				ref: curRef,
				disabledDots: true,
				children: list.map(function(item){
					// 兼容旧版单个文件的查看
					if (item.displayFlag != null){
						displayFlag = item.displayFlag;
					}
					if (item.areaInfo != null){
						areaInfo = item.areaInfo;
					} else {
						areaInfo = list;
					}
					fileType=item.fileType;
					fileKey=item.fileKey;
					fileName=item.fileName;
					fileDocumentType=item.fileDocumentType;
					if(fileDocumentType){
						
					}else{
						fileDocumentType="word";
					}
					itemUrl=item.url;
					var formData;
					var contentType = false;
					var processData = false;
					if(item.previewType && item.previewType!='0'){
						reqAyax=true;
					}

					if(item.previewType=='3'){
						if("jpg"==fileType||"png"==fileType||"jpeg"==fileType){
							reqAyax=false;
							anyOffice=false;
						}else{
							anyOffice=true;
							reqAyax=true;
							processData = true;
							contentType = "application/x-www-form-urlencoded;charset=UTF-8;";
							formData={'onlyOfficeData': JSON.stringify({
								"document": {
									"key": fileKey,
									"fileType": fileType,
									"title": fileName,
									"url": item.downloadUrl,
									"permissions": {
										"comment": false,
										"commentGroups": {"edit": [""],"remove": [""],"view": ""},
										"copy": true,
										"deleteCommentAuthorOnly": false,
										"download": false,
										"edit": false,
										"editCommentAuthorOnly": false,
										"fillForms": false,
										"modifyContentControl": false,
										"modifyFilter": false,
										"print": false,
										"review": false,
										"reviewGroups": [""]
									}
								},
								"documentType": fileDocumentType,
								"editorConfig": {
									"mode": "view", "lang": "zh",
									"customization": {
										"anonymous": {
											"request": false
										},
										"plugins": false,
										"toolbarHideFileName": true,
										"toolbarNoTabs": true,
                                        "download": false,
                                        "print": false
									}
								}
							})}; 
						}
					}
					if(reqAyax){
						var ajaxResult;
						$.ajax({ 
							type : "POST",  
							dataType: 'json',
							url : item.url, 
							data:formData,
							async : false,
							contentType: contentType, // 防止jQuery修改contentType
							processData: processData, // 防止jQuery处理data成字符串
							success : function(result) {
								console.log(result.url+'  '+result.status);
								if(result.url){
									ajaxResult=result.url; 
								}
								if(!ajaxResult && result.fileId){
									if(item.wpsDomain){
										ajaxResult=item.wpsDomain + result.fileId + '?_w_appid='+ item.wpsAppId +'&_w_tokentype=' + item.wpsTokenType + '&accountId='+ item.accountId +'&sdkId=1';
									}
								}
								token=result.token;
							},
							error : function(e){
								console.log(e.status);
								//console.log(e.responseText);
							}
						}); 
						if(ajaxResult){
							wpsFlag = true;
							itemUrl=ajaxResult;
						  //预览地址不是图片
							displayFlag='showOther';
							if( item.replaceurl && item.contextPath ){
								var arr=item.replaceurl.split("|");
								for(var i=0;i<arr.length;i++) {  
									itemUrl = itemUrl.replace(arr[i],item.contextPath); 
								}
							}
						}
						
					}
					if(anyOffice){
						itemUrl=item.downloadUrl;
						var imgCom = React.createElement('div', {
							width: boxWidth,
							height: boxHeight,
							id: 'imcplaceholder'+boxSelect,
						}); 
						return imgCom;
					}
					if(wpsView && wpsFlag){
						var imgCom = React.createElement('div', {
							width: boxWidth,
							height: boxHeight,
							class: 'office-url',
						}); 
						return imgCom;
					}else{ 
						var imgCom = React.createElement(ScanImage, {
							id: 0,
							width: boxWidth,
							height: boxHeight,
							rotateDeg: item.rotateDeg,
							areaInfo: areaInfo,
							displayFlag: displayFlag || 'markImage',
							visible: true,
							renderInBody: false,
							imgSrc: itemUrl,
							disabledBtns: false,
							showNewBtns: true,
							// emptyFillStyle: 'rgba(0, 0, 0, 0.5)',
							showChangePageBtn: showBtn,
							changeIndex: function(type) {
								console.log('changeIndex', type, curRef);
								curRef.current.onChangeIndexOutSide(type);
								// model.invoke('keyboardOpera', {"type":type});
							}
						});	
						return imgCom; 
					}
				})
			});			
			if ($(selectorStr + ' .showImageBox').length > 0 && domEl) {
				try {
					ReactDOM.unmountComponentAtNode(domEl);
				} catch(e) {
					console.log('unmountComponentAtNode');
				}					
			}
			try{
				ReactDOM.render(scanImages, domEl);
				console.log("wpstoken",token);
			}catch(error){
				console.log("error",error);
				ReactDOM.render(scanImages, domEl);
			}
			if(wpsView && wpsFlag){
				const jssdk = WebOfficeSDK.config({
					url: itemUrl,
					mount: document.querySelector('.office-url'),
					refreshToken: token
				});
				jssdk.setToken({
					token,
					timeout: 10 * 60 * 1000
				});
				jssdk.on('fileOpen', (data) => {
					$(".web-office-iframe").css("height",boxHeight);
					console.log('打开文档成功: ', data)
				});
			}
			if(anyOffice){
				loadScript(httpResource, function() {		
					docEditor = new DocsAPI.DocEditor("imcplaceholder"+boxSelect, {
						document: {
							fileType: fileType,
							key: fileKey,
							title: fileName,
							url: itemUrl,
							permissions: {
                                download: false,
                                print: false,
                                edit: false
                            }
						},
						documentType: fileDocumentType,
						editorConfig: {
                            mode: "view",
                            customization: {
                                download: false,
                                print: false,
                                toolbarHideFileName: true
                            }
                        },
						token: token,
					});
				});
				
			}
		}
		if(isUpdate&&pageId&&list){
			if (!isLoadLibs) { 
				KDApi.loadFile(loadFileArray, model, function(){
					console.log('ScanImage', ScanImage); 
					var obj = ''; 				
					if(flexKey.indexOf('#') != -1) {
						obj = flexKey.substr(1);
					} else {
						obj = flexKey;
					}
					isLoadLibs = true;	
					uploadImgShow();
				}); 
			} else {
				uploadImgShow();
			}			
		}
    }
	
	function loadScript(url, callback) { 
		if(window.DocsAPI && window.DocsAPI.DocEditor){
			if (callback) {
				callback();
			}
			return;
		} 
		// 创建 script 元素
		var script = document.createElement('script'); 
		// 设置 script 的类型
		script.type = 'text/javascript';
		// 设置 script 的 src 属性为要加载的文件地址
		script.src = url;

		// 检查是否支持 onload 事件
		if (script.readyState) {  // 对于 IE 浏览器
			script.onreadystatechange = function() {
				if (script.readyState == 'loaded' || script.readyState == 'complete') {
					script.onreadystatechange = null;
					if (callback) {
						setTimeout(function(){callback();},500);
						
					}
				}
			};
		} else {  // 对于其他现代浏览器
			script.onload = function() {
				if (callback) {
					setTimeout(function(){callback();},500);
				}
			};
		}

		// 将 script 元素添加到文档的 head 中
		document.head.appendChild(script);
	} 
	
	KDApi.register('viewinvoice', MyComponent);
})(window.KDApi,jQuery);
