/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.imsc.dmw.engine.eas.MigrateActionProcessor;
import kd.imsc.dmw.engine.eas.action.impl.MigrateCheckItemAction;
import kd.imsc.dmw.engine.eas.action.impl.MigrateExecAction;
import kd.imsc.dmw.engine.eas.action.impl.MigrateRepairAction;
import kd.imsc.dmw.engine.eas.action.impl.ReportPushAction;
import kd.imsc.dmw.engine.eas.core.context.MigrateContext;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.param.CheckItemRequestParam;
import kd.imsc.dmw.engine.eas.core.param.MigrateRequestParam;
import kd.imsc.dmw.engine.eas.core.param.RepairRequestParam;
import kd.imsc.dmw.engine.eas.core.param.ReportPushRequestParam;
import kd.imsc.dmw.engine.eas.core.progress.ActionProgress;
import kd.imsc.dmw.engine.eas.core.progress.MigrateProgress;
import kd.imsc.dmw.utils.StringUtil;

public class MigrateActionFactory {
    public static MigrateActionProcessor getCheckItemProcessor(Map<String, Object> paramMap, String taskId) {
        List checkItemIds = (List)paramMap.get("checkitemids");
        Long dbLinkId = Long.valueOf(String.valueOf(paramMap.get("dblinkid")));
        MigrateProgress progressController = new MigrateProgress(taskId, 20);
        CheckItemRequestParam param = new CheckItemRequestParam(checkItemIds, dbLinkId);
        MigrateContext migrateContext = new MigrateContext();
        migrateContext.setBatch((String)paramMap.get("batch"));
        migrateContext.setProjectId(Long.parseLong(String.valueOf(paramMap.get("projectid"))));
        migrateContext.setDbLinkId(dbLinkId);
        migrateContext.setTaskId(taskId);
        migrateContext.setProgressController(progressController);
        String projectFormId = (String)paramMap.get("projectFormId");
        if (StringUtil.isEmpty(projectFormId)) {
            projectFormId = "dmw_migrateproject_eas";
        }
        migrateContext.setProjectFormId(projectFormId);
        String checkitemFormId = (String)paramMap.get("checkitemFormId");
        if (StringUtil.isEmpty(checkitemFormId)) {
            checkitemFormId = "dmw_migratecheckitem_eas";
        }
        migrateContext.setCheckitemFormId(checkitemFormId);
        MigrateActionFactory.setRepairlogFormId(migrateContext, checkitemFormId);
        ArrayList<MigrateCheckItemAction> actions = new ArrayList<MigrateCheckItemAction>(4);
        actions.add(new MigrateCheckItemAction(migrateContext, param, new ActionProgress(80, progressController, checkItemIds.size())));
        return MigrateActionProcessor.build(actions, (MigrateContext)migrateContext);
    }

    public static MigrateActionProcessor getRePairProcessor(Map<String, Object> params) {
        Long dbLinkId = Long.valueOf(String.valueOf(params.get("dblinkid")));
        List repairIds = (List)params.get("repairIds");
        MigrateProgress progressController = new MigrateProgress((String)params.get("taskId"), 20);
        CheckItemLog checkItemLog = (CheckItemLog)JSONObject.parseObject((String)((String)params.get("checkItemLog")), CheckItemLog.class);
        RepairRequestParam repairParam = new RepairRequestParam(repairIds, dbLinkId, (String)params.get("checkresult"), (String)params.get("checkdetail"), checkItemLog);
        MigrateContext migrateContext = new MigrateContext();
        String batch = UUID.randomUUID().toString().replace("-", "");
        migrateContext.setBatch(batch);
        migrateContext.setDbLinkId(dbLinkId);
        String projectId = String.valueOf(params.get("projectid"));
        migrateContext.setProjectId(Long.parseLong(projectId));
        migrateContext.setTaskId((String)params.get("taskId"));
        migrateContext.setProgressController(progressController);
        String checkitemFormId = (String)params.get("checkitemFormId");
        if (StringUtil.isEmpty(checkitemFormId)) {
            checkitemFormId = "dmw_migratecheckitem_eas";
        }
        migrateContext.setCheckitemFormId(checkitemFormId);
        MigrateActionFactory.setRepairlogFormId(migrateContext, checkitemFormId);
        ArrayList<MigrateRepairAction> actions = new ArrayList<MigrateRepairAction>(4);
        actions.add(new MigrateRepairAction(migrateContext, repairParam, new ActionProgress(80, progressController, repairIds.size())));
        return MigrateActionProcessor.build(actions, (MigrateContext)migrateContext);
    }

    public static MigrateActionProcessor getMigrateProcessor(Map<String, Object> map, String taskId) {
        Long dbLinkId = Long.valueOf(String.valueOf(map.get("dblinkid")));
        List migrateEntryIds = (List)map.get("migrateEntryIds");
        Map migOldStatus = (Map)map.get("migOldStatus");
        MigrateProgress migrateProgress = new MigrateProgress(taskId, 20);
        MigrateContext context = new MigrateContext();
        context.setProjectId(Long.parseLong(String.valueOf(map.get("projectid"))));
        context.setProgressController(migrateProgress);
        context.setDbLinkId(dbLinkId);
        context.setTaskId(taskId);
        context.setCompanyNumber((String)map.get("companyNumber"));
        context.setCompanyNumberArray((String)map.get("companyNumberArray"));
        context.setFromDateNumber((String)map.get("fromBillDate"));
        context.setFromPeriodNumber((String)map.get("fromPeriodNumber"));
        String projectFormId = (String)map.get("projectFormId");
        if (StringUtil.isEmpty(projectFormId)) {
            projectFormId = "dmw_migrateproject_eas";
        }
        context.setProjectFormId(projectFormId);
        switch (projectFormId) {
            case "dmw_migrateproject_nc": {
                context.setRepairlogFormId("dmw_migraterepairlog_nc");
                break;
            }
            case "dmw_migrateproject_eas": {
                context.setRepairlogFormId("dmw_migraterepairlog_eas");
                break;
            }
            case "dmw_migrateproject_ecc": {
                context.setRepairlogFormId("dmw_migraterepairlog_ecc");
                break;
            }
        }
        MigrateRequestParam param = new MigrateRequestParam(migrateEntryIds, dbLinkId, migOldStatus);
        ArrayList<MigrateExecAction> actions = new ArrayList<MigrateExecAction>(16);
        actions.add(new MigrateExecAction(context, param, new ActionProgress(80, migrateProgress, migrateEntryIds.size())));
        return MigrateActionProcessor.build(actions, (MigrateContext)context);
    }

    public static MigrateActionProcessor getReportPushProcessor(Map<String, Object> paramMap, String taskId) {
        long pushRecordId = Long.parseLong(String.valueOf(paramMap.get("pushRecordId")));
        List pushRecordEntryIdList = (List)paramMap.get("pushRecordEntryIdList");
        MigrateContext migrateContext = new MigrateContext();
        migrateContext.setBatch((String)paramMap.get("batch"));
        migrateContext.setTaskId(taskId);
        MigrateProgress progressController = new MigrateProgress(taskId, 20);
        migrateContext.setProgressController(progressController);
        ReportPushRequestParam param = new ReportPushRequestParam(pushRecordId, pushRecordEntryIdList);
        ArrayList<ReportPushAction> actions = new ArrayList<ReportPushAction>(1);
        actions.add(new ReportPushAction(migrateContext, param, new ActionProgress(80, progressController, pushRecordEntryIdList.size())));
        return MigrateActionProcessor.build(actions, (MigrateContext)migrateContext);
    }

    private static void setRepairlogFormId(MigrateContext migrateContext, String checkitemFormId) {
        switch (checkitemFormId) {
            case "dmw_migratecheckitem_nc": {
                migrateContext.setRepairlogFormId("dmw_migraterepairlog_nc");
                break;
            }
            case "dmw_migratecheckitem_eas": {
                migrateContext.setRepairlogFormId("dmw_migraterepairlog_eas");
                break;
            }
            case "dmw_migratecheckitem_ecc": {
                migrateContext.setRepairlogFormId("dmw_migraterepairlog_ecc");
                break;
            }
        }
    }
}

