/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.action.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imsc.dmw.engine.eas.action.AbstractMigrateAction;
import kd.imsc.dmw.engine.eas.action.impl.checkitem.MigrateCheckItemTask;
import kd.imsc.dmw.engine.eas.core.config.MigrateCheckItemConfig;
import kd.imsc.dmw.engine.eas.core.context.MigrateContext;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.param.CheckItemRequestParam;
import kd.imsc.dmw.engine.eas.core.progress.ActionProgress;
import kd.imsc.dmw.helper.lock.BizLocker;
import kd.imsc.dmw.utils.StringUtils;

public class MigrateCheckItemAction
extends AbstractMigrateAction {
    private static final ThreadPool POOL = ThreadPools.newCachedThreadPool((String)"CheckItemAsyncValidator", (int)8, (int)16);
    private CheckItemRequestParam requestParam;

    public MigrateCheckItemAction(MigrateContext executeContext, CheckItemRequestParam requestParam, ActionProgress progress) {
        super.setExecuteContext(executeContext);
        super.setProgress(progress);
        this.requestParam = requestParam;
        this.getCheckConfMap();
    }

    public void doExec() {
        try (BizLocker bizLocker = BizLocker.create().doLock(this.requestParam.getMigrateCheckItem(), this.getExecuteContext().getCheckitemFormId());){
            this.doCheck();
        }
    }

    private void doCheck() {
        List<MigrateCheckItemConfig> checkItemConfigMap = this.getCheckConfMap();
        ArrayList<Future> futures = new ArrayList<Future>(16);
        for (MigrateCheckItemConfig checkItemConfig : checkItemConfigMap) {
            MigrateCheckItemTask task = new MigrateCheckItemTask(checkItemConfig, this.getExecuteContext());
            Future checkResult = POOL.submit((Callable)task);
            futures.add(checkResult);
        }
        int complete = 0;
        while (complete != futures.size()) {
            int endCount = Math.toIntExact(futures.stream().filter(Future::isDone).count());
            if (endCount <= complete) continue;
            complete = endCount;
            this.getProgress().updateComplete(complete);
        }
        boolean isAllSuccess = futures.stream().allMatch(f -> {
            try {
                return ((CheckItemLog)f.get()).isSuccess();
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u51fa\u9519\uff1a", (Throwable)e);
                return true;
            }
        });
        if (this.getExecuteContext().getProjectId() == 0L) {
            this.getProgress().complete();
            return;
        }
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)this.getExecuteContext().getProjectId(), (String)this.getExecuteContext().getProjectFormId());
        DynamicObjectCollection checkEntryList = project.getDynamicObjectCollection("checktreeentryentity");
        boolean isAll = true;
        for (DynamicObject checkEntry : checkEntryList) {
            String status = checkEntry.getString("checkstatus");
            if ("D".equals(status) || "E".equals(status)) continue;
            isAll = false;
            break;
        }
        if (project != null) {
            if (isAllSuccess && isAll) {
                project.set("projectstatus", (Object)"D");
            } else {
                project.set("projectstatus", (Object)"C");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{project});
        }
        this.getProgress().complete();
    }

    private List<MigrateCheckItemConfig> getCheckConfMap() {
        ArrayList<MigrateCheckItemConfig> checkItemConfigMap = new ArrayList<MigrateCheckItemConfig>(16);
        List migrateCheckItem = this.requestParam.getMigrateCheckItem();
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)this.getExecuteContext().getCheckitemFormId());
        DynamicObject[] checkItemDynObjArray = BusinessDataServiceHelper.load((Object[])migrateCheckItem.toArray(), (DynamicObjectType)type);
        Map<Long, Map<String, Object>> migProjectParams = this.getMigProjectParams();
        for (DynamicObject obj : checkItemDynObjArray) {
            MigrateCheckItemConfig build = MigrateCheckItemConfig.build(obj);
            if (this.getExecuteContext().getProjectId() != 0L) {
                Map<String, Object> checkParam = migProjectParams.get((Long)obj.getPkValue());
                build.setVarMap(checkParam);
            }
            checkItemConfigMap.add(build);
        }
        return checkItemConfigMap;
    }

    private Map<Long, Map<String, Object>> getMigProjectParams() {
        HashMap<Long, Map<String, Object>> checkParamMap = new HashMap<Long, Map<String, Object>>(16);
        if (this.getExecuteContext().getProjectId() != 0L) {
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)this.getExecuteContext().getProjectId(), (String)this.getExecuteContext().getProjectFormId());
            DynamicObjectCollection checkParams = project.getDynamicObjectCollection("checkparamentry");
            for (DynamicObject checkParam : checkParams) {
                DynamicObject checkItem = checkParam.getDynamicObject("checkitemvar");
                HashMap<String, ArrayList<String>> checkParamData = new HashMap<String, ArrayList<String>>(16);
                String checkParamTag = checkParam.getString("autoparam_tag");
                Map autoParamMaps = (Map)JSONObject.parseObject((String)checkParamTag, Map.class);
                for (Map.Entry map : autoParamMaps.entrySet()) {
                    if ("autoFieldMessage".equals(map.getKey())) continue;
                    String key = (String)map.getKey();
                    String value = (String)map.getValue();
                    if (!StringUtils.isNotEmpty(value)) continue;
                    String[] values = value.split(",");
                    ArrayList<String> valueList = new ArrayList<String>(Arrays.asList(values));
                    if (key.contains("imscdmw_")) {
                        String substring = key.substring("imscdmw_".length());
                        checkParamData.put(substring, valueList);
                        continue;
                    }
                    checkParamData.put((String)map.getKey(), valueList);
                }
                checkParamMap.put((Long)checkItem.getPkValue(), checkParamData);
            }
        }
        return checkParamMap;
    }
}

