/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.action.impl.checkitem.exec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.dmw.engine.eas.action.impl.checkitem.exec.ICheckItemExec;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.param.CheckItemServiceFlowParam;
import kd.imsc.dmw.helper.BalanceCheckDataHelper;
import kd.imsc.dmw.helper.tpl.MigrateCheckItemHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.IscUtils;

public class CheckItemExecServiceFlowImpl
implements ICheckItemExec {
    private static final Log logger = LogFactory.getLog(CheckItemExecServiceFlowImpl.class);
    private CheckItemServiceFlowParam serviceFlowParam;
    private static final String STATUS_SUCCESS = "A";
    private static final String STATUS_FAIL = "B";
    private static final String STATUS = "status";
    private static final String SRCERRORDATA = "srcErrorData";
    private static final String DESTERRORDATA = "destErrorData";
    private static final String PARAMMAP = "paramMap";
    private static final String ERRORTYPE = "errortype";

    public CheckItemExecServiceFlowImpl(CheckItemServiceFlowParam serviceFlowParam) {
        this.serviceFlowParam = serviceFlowParam;
    }

    public CheckItemLog doCheck() {
        long serviceFlowId = this.serviceFlowParam.getServiceFlowId();
        DynamicObject flowDynObj = BusinessDataServiceHelper.loadSingle((String)"isc_service_flow", (String)"id,name,is_released,enable,var_category,var_type,var_name,is_output_param", (QFilter[])new QFilter("id", "=", (Object)serviceFlowId).toArray());
        Map<Long, String> releasedErrorMsgMap = MigrateCheckItemHelper.verifyServiceFlowByStart(this.serviceFlowParam.getCheckitemFormId(), serviceFlowId, flowDynObj);
        if (releasedErrorMsgMap.containsKey(serviceFlowId)) {
            return this.buildFailCheckItemLog(releasedErrorMsgMap.get(serviceFlowId));
        }
        if (this.serviceFlowParam.getDbLinkId() > 0L) {
            IscUtils.updateDatasource(this.serviceFlowParam.getDbLinkId(), this.serviceFlowParam.getProjectFormId());
        }
        HashMap paramMap = new HashMap(8);
        Object invokeResult = DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"start2", (Object[])new Object[]{DynamicObjectUtils.getString((DynamicObject)flowDynObj, (String)"number"), paramMap});
        long instanceId = Long.parseLong(invokeResult.toString());
        Tuple<String, Object> resultTuple = this.waitServiceFlowEnd(instanceId);
        if ("D".equals(resultTuple.item1)) {
            if (resultTuple.item2 != null) {
                Map checkResult = (Map)resultTuple.item2;
                return this.buildCheckItemLog(checkResult);
            }
            CheckItemLog checkItemLog = new CheckItemLog();
            checkItemLog.setStatus(STATUS_FAIL);
            checkItemLog.setValidateInfo(ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u4e2d\u7684\u53d8\u91cf\u3010checkResult\u3011\u672a\u8bbe\u7f6e\u503c\u8fd4\u56de\u3002", (String)"CheckItemExecServiceFlowImpl_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            return checkItemLog;
        }
        CheckItemLog checkItemLog = new CheckItemLog();
        checkItemLog.setStatus(STATUS_FAIL);
        checkItemLog.setValidateInfo(resultTuple.item2.toString());
        return checkItemLog;
    }

    private CheckItemLog buildFailCheckItemLog(String errorMsg) {
        CheckItemLog log = new CheckItemLog();
        log.setStatus(STATUS_FAIL);
        log.setValidateInfo(errorMsg);
        return log;
    }

    private CheckItemLog buildCheckItemLog(Map<Object, Object> checkResult) {
        List destErrorDataList;
        ArrayList idList;
        String errortype;
        CheckItemLog checkItemLog = new CheckItemLog();
        String status = Boolean.parseBoolean(String.valueOf(checkResult.get(STATUS))) ? STATUS_SUCCESS : STATUS_FAIL;
        checkItemLog.setStatus(status);
        ArrayList<String> errorTypeList = new ArrayList<String>(16);
        List srcErrorDataList = (List)checkResult.get(SRCERRORDATA);
        if (!CommonUtils.isNull(srcErrorDataList)) {
            ArrayList<Map<String, Object>> fixSrcSysDataList = new ArrayList<Map<String, Object>>(16);
            HashMap<String, List<Object>> errorSrcSysIdMap = new HashMap<String, List<Object>>(16);
            int srcCount = 0;
            for (Map srcErrorDataMap : srcErrorDataList) {
                if (srcCount >= 1000) break;
                fixSrcSysDataList.add(srcErrorDataMap);
                errortype = String.valueOf(srcErrorDataMap.get(ERRORTYPE));
                idList = (List)errorSrcSysIdMap.get(errortype);
                if (CommonUtils.isNull(idList)) {
                    idList = new ArrayList(16);
                }
                idList.add(srcErrorDataMap.get("id"));
                errorSrcSysIdMap.put(errortype, idList);
                ++srcCount;
                if (errorTypeList.contains(errortype)) continue;
                errorTypeList.add(errortype);
            }
            checkItemLog.setErrorSrcSysIdMap(errorSrcSysIdMap);
            checkItemLog.setFixSrcSysDataList(fixSrcSysDataList);
        }
        if (!CommonUtils.isNull(destErrorDataList = (List)checkResult.get(DESTERRORDATA))) {
            HashMap<String, List<Object>> errorXhIdMap = new HashMap<String, List<Object>>(16);
            int destCount = 0;
            for (Map destErrorDataMap : destErrorDataList) {
                if (destCount >= 1000) break;
                errortype = String.valueOf(destErrorDataMap.get(ERRORTYPE));
                idList = (ArrayList)errorXhIdMap.get(errortype);
                if (CommonUtils.isNull(idList)) {
                    idList = new ArrayList(16);
                }
                idList.add(destErrorDataMap.get("id"));
                errorXhIdMap.put(errortype, idList);
                ++destCount;
                if (errorTypeList.contains(errortype)) continue;
                errorTypeList.add(errortype);
            }
            checkItemLog.setErrorXhIdMap(errorXhIdMap);
            checkItemLog.setFixXhSysDataList(destErrorDataList);
        }
        StringBuilder validateInfoBuilder = new StringBuilder();
        for (String errorType : errorTypeList) {
            validateInfoBuilder.append(errorType);
        }
        checkItemLog.setValidateInfo(validateInfoBuilder.toString());
        checkItemLog.setParamMap((Map)checkResult.get(PARAMMAP));
        return checkItemLog;
    }

    private Tuple<String, Object> waitServiceFlowEnd(long instanceId) {
        int sleepSecond = 500;
        long startTime = System.currentTimeMillis();
        int interruptedCount = 0;
        while (!this.checkTerminate(instanceId)) {
            Map<String, Object> execution = this.getFlowServiceState(instanceId);
            String state = (String)execution.get("state");
            if ("Created".equals(state) || "Waiting".equals(state)) {
                if (System.currentTimeMillis() - startTime > (long)BalanceCheckDataHelper.getDeafultTimeOut()) {
                    String message = String.format(ResManager.loadKDString((String)"%s\u670d\u52a1\u6d41\u7a0b\u957f\u65f6\u95f4\u7b49\u5f85\u540e\u4ecd\u5904\u4e8e\u521b\u5efa\u72b6\u6001\u800c\u672a\u5f00\u59cb\u6267\u884c\uff0c\u8bf7\u5230\u6d41\u7a0b\u5b9e\u4f8b\u4e2d\u67e5\u770b\u6267\u884c\u72b6\u6001\u3002", (String)"CheckItemExecServiceFlowImpl_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), instanceId);
                    return new Tuple((Object)"C", (Object)message);
                }
            } else {
                if ("Terminated".equals(state) || "Failed".equals(state)) {
                    String errorMsg = "Terminated".equals(state) ? ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u88ab\u7ec8\u6b62", (String)"CheckItemExecServiceFlowImpl_3", (String)"imsc-dmw-platform", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u5931\u8d25", (String)"CheckItemExecServiceFlowImpl_4", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                    String type = "Terminated".equals(state) ? "CONTROL" : "ERROR";
                    QFilter[] qFilters = new QFilter[]{new QFilter("type", "=", (Object)type), new QFilter("proc_inst", "=", (Object)instanceId)};
                    DynamicObjectCollection logObjs = QueryServiceHelper.query((String)"isc_sf_proc_log", (String)"id, content,content_tag", (QFilter[])qFilters, (String)"created_time desc", (int)1);
                    if (!logObjs.isEmpty()) {
                        errorMsg = ((DynamicObject)logObjs.get(0)).getString("content_tag");
                    }
                    return new Tuple((Object)"C", (Object)errorMsg);
                }
                if ("Complete".equals(state)) {
                    Map outputMap = (Map)execution.get("output");
                    Object result = null;
                    if (outputMap.containsKey("checkResult")) {
                        result = outputMap.get("checkResult");
                    }
                    return new Tuple((Object)"D", result);
                }
            }
            try {
                BalanceCheckDataHelper.sleep(sleepSecond);
            }
            catch (InterruptedException e) {
                int n = interruptedCount;
                interruptedCount = (byte)(interruptedCount + 1);
                if (n > BalanceCheckDataHelper.getIndexThree()) {
                    String message = ResManager.loadKDString((String)"%1$s\u670d\u52a1\u6d41\u7a0b\u5df2\u7ecf\u88ab\u591a\u6b21\u4e2d\u65ad\uff0c\u65e0\u6cd5\u7ee7\u7eed\u6267\u884c\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5 %2$s", (String)"CheckItemExecServiceFlowImpl_5", (String)"imsc-dmw-platform", (Object[])new Object[0]);
                    KDBizException exception = new KDBizException(String.format(message, instanceId, e.getMessage()));
                    exception.addSuppressed((Throwable)e);
                    throw exception;
                }
                Thread.currentThread().interrupt();
            }
            sleepSecond = this.getSleepSecond(sleepSecond, 5000);
        }
        return new Tuple((Object)"C", (Object)ResManager.loadKDString((String)"\u5df2\u7ec8\u6b62", (String)"CheckItemExecServiceFlowImpl_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
    }

    private boolean checkTerminate(long instanceId) {
        boolean success;
        boolean isTerminate = BalanceCheckDataHelper.isStop(this.serviceFlowParam.getTaskId());
        if (isTerminate && instanceId != 0L && !(success = ((Boolean)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"terminate", (Object[])new Object[]{instanceId})).booleanValue())) {
            logger.warn(String.format("\u6d41\u7a0b\u5b9e\u4f8b[%1$s]\u5df2\u7ecf\u7ed3\u675f\u6216\u7ec8\u6b62\uff0c\u65e0\u6cd5\u518d\u6267\u884c\u7ec8\u6b62", instanceId));
        }
        return isTerminate;
    }

    private Map<String, Object> getFlowServiceState(long instanceId) {
        return (Map)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"getState", (Object[])new Object[]{instanceId});
    }

    private int getSleepSecond(int beginSecond, int maxSecond) {
        if (beginSecond >= maxSecond) {
            return maxSecond;
        }
        return beginSecond * 13 / 10;
    }

    private static class IscFlowStatus {
        public static final String CREATED = "Created";
        public static final String WAITING = "Waiting";
        public static final String FAILED = "Failed";
        public static final String COMPLETE = "Complete";
        public static final String TERMINATED = "Terminated";

        private IscFlowStatus() {
        }
    }
}

