/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.ext.eas.checkitems.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.imsc.dmw.engine.eas.core.config.isc.impl.IscServiceImpl;
import kd.imsc.dmw.engine.eas.core.ext.checkitems.AbstractCheckPlugin;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.param.CheckItemPluginParam;

public class CurrencyPrecisionCheckPlugin
extends AbstractCheckPlugin {
    private static final String PRICE_PRECISION = "priceprecision";
    private static final String AMT_PRECISION = "amtprecision";

    public CurrencyPrecisionCheckPlugin() {
        super("bd_currency", "");
    }

    public CheckItemLog doExecute(CheckItemPluginParam param) {
        CheckItemLog checkItemLog = new CheckItemLog();
        String sql = "select a.fid,a.fnumber,a.fname_l2,a.FPRECISION from T_BD_Currency as a where a.fnumber in ('BB01','BB02','BB03')";
        IscServiceImpl service = new IscServiceImpl(param.getDbLinkId());
        List<Map<String, Object>> resultList = this.executePageQuery(service, sql);
        HashSet<String> fieldList = new HashSet<String>(2);
        fieldList.add("id");
        fieldList.add("number");
        fieldList.add("name");
        fieldList.add(PRICE_PRECISION);
        fieldList.add(AMT_PRECISION);
        QFilter filter = new QFilter("number", "in", (Object)new String[]{"CNY", "USD", "HKD"});
        Map<String, List<Object>> map = this.queryXhData(fieldList, filter.toArray());
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        for (Map<String, Object> result : resultList) {
            String easNum;
            switch (easNum = (String)result.get("fnumber")) {
                case "BB01": {
                    this.judgeIfEqual(result, map, paramMap, "CNY");
                    break;
                }
                case "BB02": {
                    this.judgeIfEqual(result, map, paramMap, "USD");
                    break;
                }
                case "BB03": {
                    this.judgeIfEqual(result, map, paramMap, "HKD");
                    break;
                }
            }
        }
        HashMap<String, List<Object>> errorXhIdMap = new HashMap<String, List<Object>>(8);
        ArrayList<Long> repairIdList = new ArrayList<Long>(2);
        repairIdList.add(2194203034853076992L);
        repairIdList.add(718026423818011648L);
        errorXhIdMap.put("isc_value_conver_rule", repairIdList);
        this.setErrorXhIdMap(errorXhIdMap);
        this.setParamMap(paramMap);
        this.buildCheckItemLog(checkItemLog);
        return checkItemLog;
    }

    private void judgeIfEqual(Map<String, Object> result, Map<String, List<Object>> map, Map<String, Object> paramMap, String xhNumber) {
        Object easId = result.get("fid");
        Object easName = result.get("fname_l2");
        Object easNum = result.get("fnumber");
        String tempPrecision = result.get("fprecision").toString();
        int easPrecision = Integer.parseInt(tempPrecision);
        List<Object> idListXh = map.get("id");
        List<Object> numListXh = map.get("number");
        List<Object> nameListXh = map.get("name");
        List<Object> precisionListXh = map.get(PRICE_PRECISION);
        List<Object> amtPrecisionListXh = map.get(AMT_PRECISION);
        int index = numListXh.indexOf(xhNumber);
        if (index == -1) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u661f\u701a\u4e2d\u7f3a\u5c11\u7f16\u7801\u4e3a%s\u7684\u5e01\u79cd", (String)"CurrencyPrecisionCheckPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), xhNumber);
            this.buildErrMsg(errMsg);
            paramMap.put("isSupportRepair", "no");
            return;
        }
        int xhPrecision = Integer.parseInt((String)precisionListXh.get(index));
        int xhAmtPrecision = Integer.parseInt((String)amtPrecisionListXh.get(index));
        if (easPrecision > xhPrecision || easPrecision > xhAmtPrecision) {
            Map precisionMap;
            String errMsg = String.format(ResManager.loadKDString((String)"EAS\u7f16\u7801\u4e3a%s\u7684\u5e01\u79cd\u7cbe\u5ea6\u4e0e\u661f\u701a\u4e0d\u540c", (String)"CurrencyPrecisionCheckPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), easNum);
            Object temp = paramMap.get(xhNumber);
            Map map2 = precisionMap = temp != null ? (Map)temp : new HashMap(2);
            if (easPrecision > xhPrecision) {
                precisionMap.put("price", easPrecision);
            }
            if (easPrecision > xhAmtPrecision) {
                precisionMap.put("amt", easPrecision);
            }
            paramMap.put(xhNumber, precisionMap);
            this.buildErrMsg(errMsg);
            this.buildFixDataList("A", easId, easNum, easName, errMsg);
            this.buildFixDataList("B", idListXh.get(index), xhNumber, nameListXh.get(index), errMsg);
        }
    }
}

