/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.ext.eas.repairitems.base;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.model.RepairResponse;
import kd.imsc.dmw.engine.eas.core.param.RepairPluginParam;
import kd.imsc.dmw.engine.eas.core.plugin.ICheckRepairPlugin;
import kd.imsc.dmw.utils.CommonUtils;

public class CurrencyPrecisionRepairPlugin
implements ICheckRepairPlugin {
    private static final Log logger = LogFactory.getLog(CurrencyPrecisionRepairPlugin.class);
    private static final String PRICE_PRECISION = "priceprecision";

    public RepairResponse doExecute(RepairPluginParam param) {
        RepairResponse repairResponse = new RepairResponse();
        CheckItemLog checkItemLog = param.getCheckItemLog();
        Map<String, Object> paramMap = checkItemLog.getParamMap();
        String isSupport = (String)paramMap.get("isSupportRepair");
        String errMsg = "";
        if ("no".equals(isSupport)) {
            errMsg = ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u4e00\u952e\u4fee\u590d\uff0c\u8bf7\u5148\u521b\u5efa\u5e01\u79cd", (String)"CurrencyPrecisionRepairPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            repairResponse.setDetail(errMsg);
            repairResponse.setFailCount(Long.valueOf(1L));
            repairResponse.setStauts("B");
            return repairResponse;
        }
        QFilter filter = new QFilter("number", "in", (Object)new String[]{"CNY", "USD", "HKD"});
        DynamicObject[] currencyArray = BusinessDataServiceHelper.load((String)"bd_currency", (String)"id,number,name,priceprecision", (QFilter[])filter.toArray());
        int sum = 0;
        for (DynamicObject currency : currencyArray) {
            String num = currency.getString("number");
            Map precisionMap = (Map)paramMap.get(num);
            if (CommonUtils.isNull(precisionMap)) continue;
            if (precisionMap.get("price") != null) {
                currency.set(PRICE_PRECISION, precisionMap.get("price"));
            }
            if (precisionMap.get("amt") != null) {
                currency.set("amtprecision", precisionMap.get("amt"));
            }
            ++sum;
        }
        try {
            OperationResult result = SaveServiceHelper.saveOperate((String)"bd_currency", (DynamicObject[])currencyArray, (OperateOption)OperateOption.create());
            if (result.isSuccess()) {
                repairResponse.setStauts("A");
                repairResponse.setSuccessCount(Long.valueOf(sum));
            } else {
                List errInfoList = result.getAllErrorOrValidateInfo();
                logger.error(errInfoList.toString());
                repairResponse.setStauts("B");
                repairResponse.setDetail(errInfoList.toString());
                repairResponse.setSuccessCount(Long.valueOf(sum - errInfoList.size()));
                repairResponse.setFailCount(Long.valueOf(errInfoList.size()));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            repairResponse.setStauts("B");
            repairResponse.setDetail(e.getMessage());
        }
        return repairResponse;
    }
}

