/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.eas.core.ext.eas.repairitems.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.engine.eas.core.model.RepairResponse;
import kd.imsc.dmw.engine.eas.core.param.RepairPluginParam;
import kd.imsc.dmw.engine.eas.core.plugin.ICheckRepairPlugin;
import kd.imsc.dmw.utils.DateUtils;

public class TaxRateRepairPlugin
implements ICheckRepairPlugin {
    private static final String TABLE_NAME = "bd_taxrate";
    private static final Log logger = LogFactory.getLog(TaxRateRepairPlugin.class);

    public RepairResponse doExecute(RepairPluginParam param) {
        RepairResponse repairResponse = new RepairResponse();
        CheckItemLog checkItemLog = param.getCheckItemLog();
        Map<String, Object> paramMap = checkItemLog.getParamMap();
        if (paramMap == null) {
            String errMsg = ResManager.loadKDString((String)"\u68c0\u67e5\u63d2\u4ef6\u6784\u5efa\u7684\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u68c0\u67e5\u63d2\u4ef6", (String)"TaxRateRepairPlugin_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
            repairResponse.setDetail(errMsg);
            repairResponse.setFailCount(Long.valueOf(1L));
            repairResponse.setStauts("B");
            return repairResponse;
        }
        List lackTax = (List)paramMap.get("lack_tax");
        String nameTemp = ResManager.loadKDString((String)"\u589e\u503c\u7a0e", (String)"TaxRateRepairPlugin_1", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        long currentUserId = UserServiceHelper.getCurrentUserId();
        long mainOrgId = RequestContext.get().getOrgId();
        String dateStr = "2000-01-01 00:00:00";
        String dateStr1 = "2099-12-31 23:59:59";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        Date startDate = DateUtils.parseDate((String)dateStr, (SimpleDateFormat)sdf);
        Date endDate = DateUtils.parseDate((String)dateStr1, (SimpleDateFormat)sdf);
        DynamicObject[] taxArray = new DynamicObject[lackTax.size()];
        long[] idArray = DB.genLongIds((String)TABLE_NAME, (int)lackTax.size());
        for (int i = 0; i < lackTax.size(); ++i) {
            BigDecimal tax = new BigDecimal(String.valueOf(lackTax.get(i))).setScale(10, RoundingMode.HALF_UP);
            DynamicObject dy = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TABLE_NAME));
            String taxValue = tax.stripTrailingZeros().toPlainString();
            long id = idArray[i];
            dy.set("id", (Object)id);
            dy.set("masterid", (Object)id);
            dy.set("number", (Object)("V" + taxValue));
            dy.set("name", (Object)(nameTemp + taxValue + "%"));
            dy.set("taxationsys_id", (Object)1L);
            dy.set("taxcategoryid_id", (Object)1L);
            dy.set("taxratetype_id", (Object)1434013999825010688L);
            dy.set("valuetype", (Object)"1");
            dy.set("taxrate", (Object)tax);
            dy.set("ctrlstrategy", (Object)"5");
            dy.set("createorg", (Object)mainOrgId);
            dy.set("createorg_id", (Object)mainOrgId);
            dy.set("org_id", (Object)mainOrgId);
            dy.set("useorg_id", (Object)mainOrgId);
            dy.set("srccreateorg_id", (Object)mainOrgId);
            dy.set("issystem", (Object)"0");
            dy.set("enable", (Object)"1");
            dy.set("status", (Object)"C");
            dy.set("activedate", (Object)startDate);
            dy.set("expdate", (Object)endDate);
            dy.set("createtime", (Object)startDate);
            dy.set("modifytime", (Object)startDate);
            dy.set("creator", (Object)currentUserId);
            taxArray[i] = dy;
        }
        try {
            OperationResult result = SaveServiceHelper.saveOperate((String)TABLE_NAME, (DynamicObject[])taxArray);
            if (result.isSuccess()) {
                repairResponse.setSuccessCount(Long.valueOf(taxArray.length));
                repairResponse.setStauts("A");
            } else {
                List errInfoList = result.getAllErrorOrValidateInfo();
                logger.error(errInfoList.toString());
                repairResponse.setStauts("B");
                repairResponse.setDetail(errInfoList.toString());
                repairResponse.setSuccessCount(Long.valueOf(taxArray.length - errInfoList.size()));
                repairResponse.setFailCount(Long.valueOf(errInfoList.size()));
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            repairResponse.setStauts("B");
            repairResponse.setDetail(e.getMessage());
        }
        return repairResponse;
    }
}

