/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.engine.multiimport.helper;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.mvc.SessionManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imsc.dmw.engine.multiimport.helper.StdImportLoggerHelper;
import kd.imsc.dmw.engine.multiimport.install.FileUploadTask;
import kd.imsc.dmw.engine.multiimport.install.ImportParamAdapterProxy;
import kd.imsc.dmw.engine.multiimport.model.SubDataInstallResult;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.utils.FileUtils;

public class StdImportHelper {
    private static final ThreadPool threadPool = ThreadPools.newCachedThreadPool((String)StdImportHelper.class.getSimpleName(), (int)8, (int)16);
    private static final Log logger = LogFactory.getLog(StdImportHelper.class);
    public static final String FILE_NAME = "fileName";
    public static final String URL = "url";

    private StdImportHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static List<Map<String, String>> handleSimpleExcelIntoFileService(File xlsxFile, String formId) throws DmwImptException {
        if (xlsxFile == null || !xlsxFile.exists()) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u6570\u636e\u5305\u6587\u4ef6\u4e0d\u5b58\u5728", (String)"StdImportHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), 1001);
        }
        ArrayList<Map<String, String>> fileInfoList = new ArrayList<Map<String, String>>();
        String appId = (String)DispatchServiceHelper.invokeBOSService((String)"FormService", (String)"getAppId", (Object[])new Object[]{formId});
        Future uploadTask = threadPool.submit((Callable)new FileUploadTask(appId, formId, xlsxFile.getName(), xlsxFile));
        try {
            HashMap fileInfo = new HashMap(2);
            fileInfo.put(URL, uploadTask.get(2L, TimeUnit.MINUTES));
            fileInfo.put(FILE_NAME, xlsxFile.getName());
            fileInfoList.add(fileInfo);
            return fileInfoList;
        }
        catch (TimeoutException e1) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u6807\u51c6\u5bfc\u5165\u4e0a\u4f20\u4e34\u65f6\u6587\u4ef6\u8d85\u65f6", (String)"StdImportHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), (Throwable)e1, 2002);
        }
        catch (Exception e2) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u6807\u51c6\u5bfc\u5165\u4e0a\u4f20\u4e34\u65f6\u6587\u4ef6\u5f02\u5e38", (String)"StdImportHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), (Throwable)e2, 2002);
        }
    }

    public static SubDataInstallResult batchExecuteExcelImport(Map<String, String> fileInfoList, String formId, String pageType, Map<String, String> excelParams, boolean waitResult) {
        SubDataInstallResult sumResult = new SubDataInstallResult(ResManager.loadKDString((String)"\u6279\u91cf\u5bfc\u5165\u7ed3\u679c", (String)"StdImportHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        if (fileInfoList == null || fileInfoList.isEmpty()) {
            return sumResult.setError(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5185\u5bb9\u4e3a\u7a7a", (String)"StdImportHelper_4", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        FormShowParameter showParameter = ImportParamAdapterProxy.createFormShowParamForImport((String)formId, (String)pageType, excelParams);
        if (showParameter == null) {
            return sumResult.setError(ResManager.loadKDString((String)"\u521b\u5efa\u5bfc\u5165\u8df3\u8f6c\u9875\u9762\u5f02\u5e38", (String)"StdImportHelper_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        }
        return StdImportHelper.executeExcelImport(fileInfoList.get(URL), fileInfoList.get(FILE_NAME), showParameter, waitResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SubDataInstallResult executeExcelImport(String fileUrl, String fileName, FormShowParameter showParameter, boolean waitResult) {
        SubDataInstallResult result = new SubDataInstallResult(fileName);
        String formId = (String)showParameter.getCustomParam("BillFormId");
        String serviceAppId = (String)showParameter.getCustomParam("ServiceAppId");
        String entityDisplayName = (String)showParameter.getCustomParam("ListName");
        Object logId = StdImportLoggerHelper.createImportLog((String)entityDisplayName, (String)formId);
        result.setLogId(logId);
        showParameter.setCustomParam("Url", (Object)FileUtils.checkUrl((String)fileUrl));
        showParameter.setCustomParam("logId", logId);
        HashMap<String, String> customMap = new HashMap<String, String>();
        customMap.put("importProcess", "imsc");
        showParameter.setCustomParam("customParamMap", customMap);
        String pageId = null;
        try {
            pageId = ImportParamAdapterProxy.openFormView((String)formId, (FormShowParameter)showParameter);
            IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
            if (view == null) {
                DynamicObject logDy = BusinessDataServiceHelper.loadSingle((Object)logId, (String)"bos_importlog");
                if (logDy != null) {
                    logDy.set("importstatus", (Object)1);
                    SaveServiceHelper.update((DynamicObject)logDy);
                }
                SubDataInstallResult subDataInstallResult = result.setError(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u7528\u6237\u6ca1\u6709\u5bf9\u5e94\u9875\u9762\u7684\u6743\u9650\uff0c\u8bf7\u5c1d\u8bd5\u66f4\u6362\u767b\u5f55\u7528\u6237", (String)"StdImportHelper_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                return subDataInstallResult;
            }
            DispatchServiceHelper.invokeBOSServiceByAppId((String)serviceAppId, (String)"importService", (String)"startImport", (Object[])new Object[]{pageId, logId.toString()});
            if (waitResult) {
                String msg = StdImportLoggerHelper.wait2ImportEnd((Object)logId, (String)formId, (String)pageId);
                if (!StringUtils.isEmpty((CharSequence)msg)) {
                    result.setError(msg);
                    SubDataInstallResult subDataInstallResult = result;
                    return subDataInstallResult;
                }
                StdImportLoggerHelper.parseExcelImportResult((Object)logId, (SubDataInstallResult)result);
            }
        }
        catch (Exception e) {
            if (((DmwImptException)e).getCode() == 30001) {
                result.setTotal(-1);
            }
            logger.error("StdImportHelper->executeExcelImport:", (Throwable)e);
            SubDataInstallResult subDataInstallResult = result.setError(ResManager.loadKDString((String)"\u5bfc\u5165\u51fa\u73b0\u672a\u77e5\u5f02\u5e38: ", (String)"StdImportHelper_7", (String)"imsc-dmw-platform", (Object[])new Object[0])).append(FileUtils.getExceptionDetailInfo((Throwable)e));
            return subDataInstallResult;
        }
        finally {
            if (StringUtils.isNotEmpty((CharSequence)pageId)) {
                ImportParamAdapterProxy.closeFormView((String)formId, (String)pageId);
            }
        }
        return result;
    }

    public static String getPageTypeWithFormId(String formId) {
        if (StringUtils.isEmpty((CharSequence)formId)) {
            return null;
        }
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)formId);
        if (formConfig == null) {
            return null;
        }
        return formConfig.getListFormId();
    }
}

