/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.util.AppUtils;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.engine.multiimport.model.BizOperationResult;
import kd.imsc.dmw.engine.multiimport.model.ImportTargetSchemeInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ImportTemplateReadInfoModel;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.helper.ExcelReader;
import kd.imsc.dmw.helper.ImportExcelReadHelper;
import kd.imsc.dmw.helper.MultiImpAttachmentHelper;
import kd.imsc.dmw.helper.ReadSheetHeadRowHandler;
import kd.imsc.dmw.helper.alerter.DataAlerterFactory;
import kd.imsc.dmw.helper.alerter.FieldModifyAlerter;
import kd.imsc.dmw.helper.alerter.IDataAlerter;
import kd.imsc.dmw.helper.checker.DataCheckerBuilderFactory;
import kd.imsc.dmw.helper.checker.DataTemplatePostChecker;
import kd.imsc.dmw.helper.checker.FieldMustMidChecker;
import kd.imsc.dmw.helper.checker.FieldValuePreChecker;
import kd.imsc.dmw.helper.checker.IDataChecker;
import kd.imsc.dmw.helper.checker.ImportFieldMidChecker;
import kd.imsc.dmw.utils.FileUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class MulImportCheckerProxy {
    private static final Log logger = LogFactory.getLog(MulImportCheckerProxy.class);
    private static final List<String> preDataCheckList = new ArrayList<String>();
    private static final List<String> midDataCheckList = new ArrayList<String>();
    private static final List<String> postDataCheckList = new ArrayList<String>();
    private static final List<String> dataAlertList = new ArrayList<String>();

    private MulImportCheckerProxy() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImportTemplateReadInfoModel parseTemplateInfoByUrlWithTempFileCache(String url, int rowIndex) throws DmwImptException {
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        try (InputStream inputStream = MultiImpAttachmentHelper.getAttachmentInputStreamFromUrl((String)url);){
            ImportTemplateReadInfoModel importTemplateReadInfoModel = MulImportCheckerProxy.getImportTemplateReadInfoModel(rowIndex, inputStream);
            return importTemplateReadInfoModel;
        }
        catch (IOException e) {
            throw new DmwImptException(String.format("Download [%1s] exception [%2s]", url, e.getMessage()), (Throwable)e, 2001);
        }
    }

    public static ImportTemplateReadInfoModel parseTemplateInfoByUrlWithAttachFileCache(String url, int rowIndex) throws DmwImptException {
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        return MulImportCheckerProxy.parseTemplateInfoByUrlWithTempFileCache(url, rowIndex);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ImportTemplateReadInfoModel getImportTemplateReadInfoModel(int rowIndex, InputStream inputStream) throws DmwImptException {
        String templatePath = FileUtils.generateLocalPath();
        File tempFile = FileUtils.checkAndCreateDir((String)templatePath);
        String fileUrlPath = templatePath + File.separator + "template.xlsx";
        FileInputStream inStream = null;
        FileOutputStream oStream = null;
        ImportTemplateReadInfoModel infoModel = new ImportTemplateReadInfoModel();
        try (SXSSFWorkbook xssfWorkbook = new SXSSFWorkbook(1);){
            ExcelReader excelReader = new ExcelReader();
            excelReader.read(inputStream, (SheetHandler)new ReadSheetHeadRowHandler(xssfWorkbook));
            oStream = new FileOutputStream(fileUrlPath);
            xssfWorkbook.write((OutputStream)oStream);
            inStream = new FileInputStream(fileUrlPath);
            Tuple allSheetInfo = ImportExcelReadHelper.getAllSheetInfo((InputStream)inStream, (int)rowIndex, (boolean)false);
            StringBuilder checkResult = new StringBuilder();
            for (String checker : preDataCheckList) {
                try {
                    IDataChecker preChecker = DataCheckerBuilderFactory.getDataCheckerWithClassName((String)checker);
                    preChecker.dataCheck(allSheetInfo.item2);
                }
                catch (DmwImptException e) {
                    checkResult.append(e.getMessage());
                }
            }
            String checkMsg = checkResult.toString();
            if (StringUtils.isNotEmpty((String)checkMsg)) {
                throw new DmwImptException(checkMsg, 2001);
            }
            infoModel.setSheetNameList((List)allSheetInfo.item1);
            infoModel.setSheetTemplateMap((Map)allSheetInfo.item2);
        }
        catch (Exception e) {
            try {
                throw new DmwImptException(ResManager.loadKDString((String)"\u6587\u4ef6\u4f20\u5165\u5f02\u5e38\uff0c\u9875\u7b7e\u4e3a\u7a7a\u6216\u8005\u5f02\u5e38\u3002", (String)"MulImportCheckerProxy_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), (Throwable)e, 1001);
            }
            catch (Throwable throwable) {
                try {
                    if (tempFile.exists()) {
                        AppUtils.deleteKd((File)tempFile);
                    }
                }
                catch (Exception e2) {
                    logger.error((Throwable)e2);
                }
                if (oStream != null) {
                    MulImportCheckerProxy.safeClose(oStream);
                }
                if (inStream == null) throw throwable;
                MulImportCheckerProxy.safeClose(inStream);
                throw throwable;
            }
        }
        try {
            if (tempFile.exists()) {
                AppUtils.deleteKd((File)tempFile);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (oStream != null) {
            MulImportCheckerProxy.safeClose(oStream);
        }
        if (inStream == null) return infoModel;
        MulImportCheckerProxy.safeClose(inStream);
        return infoModel;
    }

    public static void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static void safeClose(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static BizOperationResult invokeSchemeMidDataCheck(String tarObj, DynamicObject fieldMappingObj) {
        BizOperationResult result = new BizOperationResult(true);
        StringBuilder checkMsg = new StringBuilder();
        for (String checkerName : midDataCheckList) {
            try {
                IDataChecker midChecker = DataCheckerBuilderFactory.getDataCheckerWithClassName((String)checkerName);
                midChecker.dataCheck((Object)fieldMappingObj);
            }
            catch (DmwImptException e) {
                result.setSuccess(false);
                checkMsg.append(tarObj).append(": ").append(e.getMessage()).append("\r\n");
            }
        }
        result.setErrorDesc(checkMsg.toString());
        return result;
    }

    public static BizOperationResult invokePostDataChecker(InputStream inputStream, String temInfo) {
        BizOperationResult result = new BizOperationResult(true);
        StringBuilder checkMsg = new StringBuilder();
        for (String checkerName : postDataCheckList) {
            try {
                Tuple tuple = Tuple.create((Object)inputStream, (Object)temInfo);
                IDataChecker postChecker = DataCheckerBuilderFactory.getDataCheckerWithClassName((String)checkerName);
                postChecker.dataCheck((Object)tuple);
            }
            catch (DmwImptException e) {
                result.setSuccess(false);
                checkMsg.append(e.getMessage()).append("\r\n");
            }
        }
        result.setErrorDesc(checkMsg.toString());
        return result;
    }

    public static BizOperationResult invokeDataAlerter(List<ImportTargetSchemeInfoModel> infoModelList) {
        BizOperationResult result = new BizOperationResult(true);
        if (infoModelList == null || infoModelList.isEmpty()) {
            return result;
        }
        HashMap<String, List> alertResultMap = new HashMap<String, List>(1);
        for (ImportTargetSchemeInfoModel infoModel : infoModelList) {
            for (String alerterName : dataAlertList) {
                IDataAlerter dataAlerter = DataAlerterFactory.getDataAlerterWithClassName((String)alerterName);
                Object resp = dataAlerter.dataAlert((Object)infoModel);
                if (resp == null || StringUtils.isEmpty((String)((String)resp))) continue;
                List alertList = alertResultMap.getOrDefault(alerterName, new ArrayList());
                alertList.add(String.format("%1$s#%2$s", infoModel.getFormName(), resp));
                alertResultMap.put(alerterName, alertList);
                result.setSuccess(false);
            }
        }
        if (result.getSuccess()) {
            return result;
        }
        StringBuilder checkMsg = new StringBuilder();
        for (String alerterName : dataAlertList) {
            IDataAlerter dataAlerter = DataAlerterFactory.getDataAlerterWithClassName((String)alerterName);
            String msgFormat = dataAlerter.alertFormat((List)alertResultMap.get(alerterName));
            if (StringUtils.isEmpty((String)msgFormat)) continue;
            if (checkMsg.length() > 0) {
                checkMsg.append("\r\n");
            }
            checkMsg.append(msgFormat);
        }
        result.setErrorDesc(checkMsg.toString());
        return result;
    }

    static {
        preDataCheckList.add(FieldValuePreChecker.class.getName());
        midDataCheckList.add(ImportFieldMidChecker.class.getName());
        midDataCheckList.add(FieldMustMidChecker.class.getName());
        postDataCheckList.add(DataTemplatePostChecker.class.getName());
        dataAlertList.add(FieldModifyAlerter.class.getName());
    }
}

