/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.checker;

import com.alibaba.fastjson.JSON;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.imsc.dmw.consts.AppConst;
import kd.imsc.dmw.engine.multiimport.model.ExcelFieldInfoModel;
import kd.imsc.dmw.engine.multiimport.model.ImportTemplateReadInfoModel;
import kd.imsc.dmw.errorcode.DmwImptException;
import kd.imsc.dmw.helper.ExcelReader;
import kd.imsc.dmw.helper.ImportExcelReadHelper;
import kd.imsc.dmw.helper.ReadSheetHeadRowHandler;
import kd.imsc.dmw.helper.checker.IDataChecker;
import org.apache.commons.io.FileUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class DataTemplatePostChecker
implements IDataChecker<Tuple<InputStream, String>> {
    private static final Log logger = LogFactory.getLog(DataTemplatePostChecker.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataCheck(Tuple<InputStream, String> tuple) throws DmwImptException {
        if (tuple == null) {
            throw new DmwImptException(ResManager.loadKDString((String)"tuple\u53c2\u6570\u4e3a\u7a7a", (String)"DataTemplatePostChecker_0", (String)"imsc-dmw-platform", (Object[])new Object[0]), 1001);
        }
        if (tuple.item1 == null) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u4efb\u52a1\u4e0a\u4f20\u7684\u5f85\u6570\u636eExcel\u8f93\u5165\u6d41\u5f02\u5e38", (String)"DataTemplatePostChecker_1", (String)"imsc-dmw-platform", (Object[])new Object[0]), 1001);
        }
        if (StringUtils.isEmpty((String)((String)tuple.item2))) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u65b9\u6848\u6a21\u677f\u6570\u636e\u5f02\u5e38", (String)"DataTemplatePostChecker_2", (String)"imsc-dmw-platform", (Object[])new Object[0]), 1001);
        }
        String appNumberPath = String.join((CharSequence)"", AppConst.USER_HOME, File.separator, "KINGDEEDOWNLOAD", File.separator, "dmw");
        String traceIdHash = Hashing.sha256().hashString((CharSequence)RequestContext.get().getTraceId(), StandardCharsets.UTF_8).toString();
        String templatePath = String.join((CharSequence)File.separator, appNumberPath, traceIdHash, "template");
        String fileUrlPath = templatePath + File.separator + "template.xlsx";
        File templateFile = new File(templatePath);
        if (!templateFile.exists()) {
            templateFile.mkdirs();
        }
        FileInputStream inStream = null;
        OutputStream oStream = null;
        try (SXSSFWorkbook xssfWorkbook = new SXSSFWorkbook(1);){
            ExcelReader excelReader = new ExcelReader();
            excelReader.read((InputStream)tuple.item1, (SheetHandler)new ReadSheetHeadRowHandler(xssfWorkbook));
            oStream = new FileOutputStream(fileUrlPath);
            xssfWorkbook.write(oStream);
            inStream = new FileInputStream(fileUrlPath);
        }
        catch (Exception e) {
            throw new DmwImptException(ResManager.loadKDString((String)"\u6587\u4ef6\u4f20\u5165\u5f02\u5e38\uff0c\u9875\u7b7e\u4e3a\u7a7a\u6216\u8005\u5f02\u5e38\u3002", (String)"DataTemplatePostChecker_5", (String)"imsc-dmw-platform", (Object[])new Object[0]), (Throwable)e, 1001);
        }
        finally {
            try {
                if (templateFile.exists()) {
                    FileUtils.deleteDirectory((File)templateFile);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            try {
                if (oStream != null) {
                    oStream.close();
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
        try {
            if (inStream != null) {
                Tuple sheetInfo = ImportExcelReadHelper.getAllSheetInfo((InputStream)inStream, (int)0, (boolean)false);
                ImportTemplateReadInfoModel infoModel = (ImportTemplateReadInfoModel)JSON.parseObject((String)((String)tuple.item2), ImportTemplateReadInfoModel.class);
                List sheetNameList = (List)sheetInfo.item1;
                boolean isSheetSame = this.checkSheetName(infoModel.getSheetNameList(), sheetNameList);
                if (!isSheetSame) {
                    throw new DmwImptException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u9875\u7b7e\u540d\u79f0\u4e0e\u6a21\u677f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u66f4\u6b63\u540e\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"DataTemplatePostChecker_3", (String)"imsc-dmw-platform", (Object[])new Object[0]), 1001);
                }
                boolean isSimpleName = this.checkSimpleSheetColumn(infoModel.getSheetTemplateMap(), (Map)sheetInfo.item2);
                if (!isSimpleName) {
                    throw new DmwImptException(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u9996\u884c\u5b57\u6bb5\u4e0e\u6a21\u677f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u66f4\u6b63\u540e\u91cd\u65b0\u4e0a\u4f20\u6587\u4ef6\u3002", (String)"DataTemplatePostChecker_4", (String)"imsc-dmw-platform", (Object[])new Object[0]), 1001);
                }
            }
        }
        finally {
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
        }
    }

    private boolean checkSheetName(List<String> srcSheetList, List<String> dataSheetList) {
        if (srcSheetList.size() != dataSheetList.size()) {
            return false;
        }
        int size = srcSheetList.size();
        for (int i = 0; i < size; ++i) {
            if (srcSheetList.get(i).equals(dataSheetList.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean checkSimpleSheetColumn(Map<String, List<ExcelFieldInfoModel>> srcSheetList, Map<String, List<ExcelFieldInfoModel>> dataSheetList) {
        if (srcSheetList.size() != dataSheetList.size()) {
            return false;
        }
        Set<Map.Entry<String, List<ExcelFieldInfoModel>>> entries = srcSheetList.entrySet();
        for (Map.Entry<String, List<ExcelFieldInfoModel>> entry : entries) {
            String key = entry.getKey();
            List<ExcelFieldInfoModel> value = entry.getValue();
            List dataValues = dataSheetList.getOrDefault(key, new ArrayList());
            if (value.size() != dataValues.size()) {
                return false;
            }
            for (int i = 0; i < value.size(); ++i) {
                if (value.get(i).toString().equals(((ExcelFieldInfoModel)dataValues.get(i)).toString())) continue;
                return false;
            }
        }
        return true;
    }
}

