/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.tpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.QFilterUtils;

public class MigrateSchemeHelper {
    private static final String TREE_VIEWAP = "treeviewap";
    private static final String TREE_ENTRYENTITY = "treeentryentity";
    private static final String PARENT_ID = "parentid";
    private Set<String> nodeIds = new HashSet<String>(16);
    private IFormView view;

    public MigrateSchemeHelper(IFormView view) {
        this.view = view;
    }

    public void sortSchemeEntryByDefault(DynamicObjectCollection entryEntity) {
        List<DynamicObject> sortEntryList = entryEntity.stream().sorted(Comparator.comparing(n -> new BigDecimal(n.getString("sortnumdefault")))).collect(Collectors.toList());
        ((DynamicObject)sortEntryList.get(0)).set("sortnumexec", (Object)1);
        for (int i = 1; i < sortEntryList.size(); ++i) {
            String numPre;
            DynamicObject entryNow = (DynamicObject)sortEntryList.get(i);
            DynamicObject entryPre = sortEntryList.get(i - 1);
            String numNow = entryNow.getString("sortnumdefault");
            if (numNow.equals(numPre = entryPre.getString("sortnumdefault"))) {
                sortEntryList.get(i).set("sortnumexec", (Object)entryPre.getInt("sortnumexec"));
                continue;
            }
            sortEntryList.get(i).set("sortnumexec", (Object)(entryPre.getInt("sortnumexec") + 1));
        }
        this.buildSchemeEntryBySortEntryList(sortEntryList);
    }

    public void buildSchemeEntryBySortEntryList(List<DynamicObject> sortEntryList) {
        IDataModel model = this.view.getModel();
        model.deleteEntryData(TREE_ENTRYENTITY);
        DynamicObjectCollection entryEntities = model.getEntryEntity(TREE_ENTRYENTITY);
        for (DynamicObject entry : sortEntryList) {
            DynamicObject row = entryEntities.addNew();
            row.set("id", entry.getPkValue());
            row.set("migrateobject", entry.get("migrateobject"));
            row.set("sortnumexec", entry.get("sortnumexec"));
            row.set("sortnumdefault", entry.get("sortnumdefault"));
        }
        model.updateEntryCache(entryEntities);
        this.view.updateView(TREE_ENTRYENTITY);
    }

    public void updateSchemeSequence(DynamicObjectCollection entryEntity, int selectRow, int sortNumExec) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry;
            int preSortNum;
            if (i == selectRow || (preSortNum = (entry = (DynamicObject)entryEntity.get(i)).getInt("sortnumexec")) < sortNumExec) continue;
            entry.set("sortnumexec", (Object)(preSortNum + 1));
        }
        this.view.getModel().updateEntryCache(entryEntity);
        this.view.updateView(TREE_ENTRYENTITY);
    }

    public void checkNodeByDmwObject(Collection<String> nodeIds, Collection<String> lockIds, String focusNode) {
        TreeView treeView = (TreeView)this.getControl(TREE_VIEWAP);
        TreeNode rootNode = (TreeNode)JSON.parseObject((String)this.getPageCache().get(TREE_VIEWAP), TreeNode.class);
        ArrayList<TreeNode> selectNodes = new ArrayList<TreeNode>(16);
        for (String id : nodeIds) {
            TreeNode node = rootNode.getTreeNode(id);
            if (node == null) continue;
            selectNodes.add(node);
        }
        ArrayList<TreeNode> lockNodes = new ArrayList<TreeNode>(16);
        for (String lockId : lockIds) {
            TreeNode node = rootNode.getTreeNode(lockId);
            if (node == null) continue;
            node.setDisabled(true);
            lockNodes.add(node);
        }
        treeView.updateNodes(lockNodes);
        treeView.checkNodesWithoutChild(selectNodes);
        treeView.expand(focusNode == null ? rootNode.getId() : focusNode);
    }

    public void lockAllNode() {
        TreeView treeView = (TreeView)this.getControl(TREE_VIEWAP);
        TreeNode rootNode = (TreeNode)JSON.parseObject((String)this.getPageCache().get(TREE_VIEWAP), TreeNode.class);
        ArrayList<TreeNode> lockNodes = new ArrayList<TreeNode>(16);
        this.setNodeLock(rootNode, lockNodes);
        treeView.updateNodes(lockNodes);
        treeView.expand(rootNode.getId());
    }

    private void setNodeLock(TreeNode treeNode, List<TreeNode> lockNodes) {
        treeNode.setDisabled(true);
        lockNodes.add(treeNode);
        List childrens = treeNode.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)childrens)) {
            for (TreeNode children : childrens) {
                this.setNodeLock(children, lockNodes);
            }
        }
    }

    private List<DynamicObject> queryDefaultDmwObject(String billFormId) {
        String migrateModel = (String)this.getModel().getValue("migrationmodel");
        Set mulcomboSet = DynamicObjectUtils.getMulcomboSet((String)migrateModel);
        QFilter migrateObjFilter = QFilterUtils.getEnableQFilter().and(QFilterUtils.getAuditedQfilter());
        if (mulcomboSet.contains("A") && mulcomboSet.contains("B")) {
            migrateObjFilter.and("issupportinit", "=", (Object)Boolean.TRUE);
            migrateObjFilter.and("issupportall", "=", (Object)Boolean.TRUE);
        } else if (mulcomboSet.contains("A")) {
            migrateObjFilter.and("issupportinit", "=", (Object)Boolean.TRUE);
        } else if (mulcomboSet.contains("B")) {
            migrateObjFilter.and("issupportall", "=", (Object)Boolean.TRUE);
        } else {
            migrateObjFilter.and("1", "!=", (Object)1);
        }
        ArrayList<DynamicObject> defaultDmwObjList = new ArrayList<DynamicObject>(16);
        String objSelectFields = "id,name,number,group parentid,sortnum";
        String moduleSelectFields = "id,name,number,parent parentid,sortnum";
        switch (billFormId) {
            case "dmw_migratescheme_eas": 
            case "dmw_migratescheme_nc": 
            case "dmw_migratescheme_ecc": {
                DynamicObjectCollection ncMigrateModuleColl;
                String moduleFormId;
                DynamicObjectCollection ncMigrateObjColl;
                String objectFormId;
                String string = objectFormId = "dmw_migratescheme_eas".equals(billFormId) ? "dmw_migrateobject_eas" : "dmw_migrateobject_nc";
                if ("dmw_migratescheme_ecc".equals(billFormId)) {
                    objectFormId = "dmw_migrateobject_ecc";
                }
                if (!CommonUtils.isNull(ncMigrateObjColl = QueryServiceHelper.query((String)objectFormId, (String)objSelectFields, (QFilter[])migrateObjFilter.toArray()))) {
                    defaultDmwObjList.addAll((Collection<DynamicObject>)ncMigrateObjColl);
                }
                String string2 = moduleFormId = "dmw_migratescheme_eas".equals(billFormId) ? "dmw_migratemodule_eas" : "dmw_migratemodule_nc";
                if ("dmw_migratescheme_ecc".equals(billFormId)) {
                    moduleFormId = "dmw_migratemodule_ecc";
                }
                if (CommonUtils.isNull(ncMigrateModuleColl = QueryServiceHelper.query((String)moduleFormId, (String)moduleSelectFields, (QFilter[])QFilterUtils.getEnableQFilter().toArray()))) break;
                defaultDmwObjList.addAll((Collection<DynamicObject>)ncMigrateModuleColl);
                break;
            }
        }
        return defaultDmwObjList;
    }

    public TreeView initTree() {
        TreeView tree = (TreeView)this.getControl(TREE_VIEWAP);
        tree.deleteAllNodes();
        String billFormId = this.getModel().getDataEntity().getDataEntityType().getName();
        List<DynamicObject> modelList = this.queryDefaultDmwObject(billFormId);
        List<DynamicObject> treeObjects = modelList.stream().sorted(Comparator.comparing(n -> n.getInt("sortnum"))).collect(Collectors.toList());
        String topId = "0";
        TreeNode rootNode = new TreeNode("", topId, ResManager.loadKDString((String)"\u5168\u90e8", (String)"MigrateSchemeHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        this.nodeIds.add(topId);
        tree.addNode(rootNode);
        for (DynamicObject model : treeObjects) {
            Long parentId = model.getLong(PARENT_ID);
            this.nodeIds.add(model.getString("id"));
            if (parentId != null && parentId != 0L) continue;
            TreeNode treeNode = new TreeNode(rootNode.getId(), model.getString("id"), model.getString("name"));
            this.recursiveAddChild(treeNode, treeObjects, model);
            rootNode.addChild(treeNode);
        }
        this.getPageCache().put(TREE_VIEWAP, JSONObject.toJSONString((Object)rootNode));
        return tree;
    }

    private void recursiveAddChild(TreeNode treeNode, List<DynamicObject> modelList, DynamicObject curObject) {
        String id = curObject.getString("id");
        List childrenAreas = modelList.stream().filter(n -> id.equals(n.getString(PARENT_ID))).collect(Collectors.toList());
        for (DynamicObject childClass : childrenAreas) {
            ArrayList<TreeNode> children = new ArrayList<TreeNode>(16);
            TreeNode treeNodeTmp = new TreeNode(treeNode.getId(), childClass.getString("id"), childClass.getString("name"));
            this.recursiveAddChild(treeNodeTmp, modelList, childClass);
            children.add(treeNodeTmp);
            treeNode.addChildren(children);
        }
    }

    public void buildTreeEntityByNode(List<String> nodeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(nodeList)) {
            return;
        }
        Set nodeIdSet = nodeList.stream().map(o -> Long.parseLong(o)).collect(Collectors.toSet());
        ArrayList<Long> migObjIdList = new ArrayList<Long>(16);
        ArrayList<DynamicObject> migDynObjList = new ArrayList<DynamicObject>(16);
        QFilter qFilter = new QFilter("id", "in", nodeIdSet);
        String billFormId = this.getModel().getDataEntity().getDataEntityType().getName();
        String migSelectFields = "id,sortnum,group,number,name";
        switch (billFormId) {
            case "dmw_migratescheme_eas": 
            case "dmw_migratescheme_nc": 
            case "dmw_migratescheme_ecc": {
                DynamicObjectCollection ncMigObjColl;
                String objectFormId;
                String string = objectFormId = "dmw_migratescheme_eas".equals(billFormId) ? "dmw_migrateobject_eas" : "dmw_migrateobject_nc";
                if ("dmw_migratescheme_ecc".equals(billFormId)) {
                    objectFormId = "dmw_migrateobject_ecc";
                }
                if (CommonUtils.isNull(ncMigObjColl = QueryServiceHelper.query((String)objectFormId, (String)migSelectFields, (QFilter[])qFilter.toArray(), (String)"sortnum"))) break;
                migObjIdList.addAll(ncMigObjColl.stream().map(o -> o.getLong("id")).collect(Collectors.toList()));
                migDynObjList.addAll((Collection<DynamicObject>)ncMigObjColl);
                break;
            }
        }
        DynamicObjectCollection entryEntityOld = this.getModel().getEntryEntity(TREE_ENTRYENTITY);
        List<Long> existIdList = this.getExistIds(entryEntityOld);
        List<Long> addIdList = this.getAddIds(migObjIdList, existIdList);
        List<Long> subIdList = this.getSubIds(migObjIdList, existIdList);
        if (!subIdList.isEmpty()) {
            this.deleteRowsBySubIds(subIdList, entryEntityOld);
        }
        if (addIdList.isEmpty()) {
            return;
        }
        int[] newIndexs = this.getModel().batchCreateNewEntryRow(TREE_ENTRYENTITY, addIdList.size());
        Map<Long, String> sortnumDefaultMap = this.getObjIdDefaultMap(billFormId, migDynObjList);
        int count = 0;
        for (int index : newIndexs) {
            Long objId = addIdList.get(count);
            this.getModel().setItemValueByID("migrateobject", (Object)objId, index);
            this.getModel().setValue("sortnumexec", (Object)0, index);
            this.getModel().setValue("sortnumdefault", (Object)sortnumDefaultMap.get(objId), index);
            ++count;
        }
        this.getModel().setEntryRowTop(TREE_ENTRYENTITY, newIndexs);
    }

    private List<Long> getExistIds(DynamicObjectCollection entryEntity) {
        ArrayList<Long> existIds = new ArrayList<Long>();
        for (DynamicObject item : entryEntity) {
            DynamicObject migObj = item.getDynamicObject("migrateobject");
            if (migObj == null) continue;
            existIds.add(migObj.getLong("id"));
        }
        return existIds;
    }

    private List<Long> getAddIds(List<Long> migObjIdList, List<Long> existIdList) {
        ArrayList<Long> addIdList = new ArrayList<Long>();
        for (Long item : migObjIdList) {
            if (existIdList.contains(item)) continue;
            addIdList.add(item);
        }
        return addIdList;
    }

    private List<Long> getSubIds(List<Long> migObjIdList, List<Long> existIdList) {
        ArrayList<Long> subIdList = new ArrayList<Long>();
        for (Long item : existIdList) {
            if (migObjIdList.contains(item)) continue;
            subIdList.add(item);
        }
        return subIdList;
    }

    public int getIndex(DynamicObjectCollection entryEntity) {
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject item = ((DynamicObject)entryEntity.get(i)).getDynamicObject("migrateobject");
            if (item != null) continue;
            return i;
        }
        return 0;
    }

    private void deleteRowsBySubIds(List<Long> subIdList, DynamicObjectCollection entryEntityOld) {
        int[] subRows = new int[subIdList.size()];
        int index = 0;
        for (int i = 0; i < entryEntityOld.size(); ++i) {
            DynamicObject item = (DynamicObject)entryEntityOld.get(i);
            DynamicObject migObj = item.getDynamicObject("migrateobject");
            if (migObj == null || !subIdList.contains(migObj.getLong("id"))) continue;
            subRows[index++] = i;
        }
        this.getModel().deleteEntryRows(TREE_ENTRYENTITY, subRows);
    }

    private Map<Long, String> getObjIdDefaultMap(String billFormId, List<DynamicObject> migDynObjList) {
        ArrayList<DynamicObject> moduleObjList = new ArrayList<DynamicObject>(16);
        QFilter moduleFilter = QFilterUtils.getEnableQFilter();
        String moduleSelectFields = "id,sortnum";
        switch (billFormId) {
            case "dmw_migratescheme_eas": 
            case "dmw_migratescheme_nc": 
            case "dmw_migratescheme_ecc": {
                String moduleFormId;
                String string = moduleFormId = "dmw_migratescheme_eas".equals(billFormId) ? "dmw_migratemodule_eas" : "dmw_migratemodule_nc";
                if ("dmw_migratescheme_ecc".equals(billFormId)) {
                    moduleFormId = "dmw_migratemodule_ecc";
                }
                DynamicObject[] ncModuleObjs = BusinessDataServiceHelper.load((String)moduleFormId, (String)moduleSelectFields, (QFilter[])moduleFilter.toArray());
                moduleObjList.addAll(Arrays.asList(ncModuleObjs));
                break;
            }
        }
        HashMap<Long, String> moduleSortnumMap = new HashMap<Long, String>(16);
        for (DynamicObject item : moduleObjList) {
            moduleSortnumMap.put(item.getLong("id"), item.getString("sortnum"));
        }
        HashMap<Long, String> idSortnumMap = new HashMap<Long, String>(16);
        for (DynamicObject item : migDynObjList) {
            if (item.getLong("group") == 0L || StringUtils.isBlank((CharSequence)((CharSequence)moduleSortnumMap.get(item.getLong("group"))))) {
                this.view.showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u8fc1\u79fb\u5bf9\u8c61\u627e\u4e0d\u5230\u5bf9\u5e94\u8fc1\u79fb\u6a21\u5757\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"MigrateSchemeHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[]{item.getString("number")}));
                return idSortnumMap;
            }
            StringBuilder moduleSortnum = new StringBuilder((String)moduleSortnumMap.get(item.getLong("group")));
            StringBuilder objSortnum = new StringBuilder(item.getString("sortnum"));
            StringBuilder sortnumDefault = moduleSortnum.append('.').append(this.getThreeDigit(objSortnum));
            idSortnumMap.put(item.getLong("id"), sortnumDefault.toString());
        }
        return idSortnumMap;
    }

    public String getThreeDigit(StringBuilder objSortNum) {
        switch (objSortNum.length()) {
            case 1: {
                objSortNum.insert(0, "00");
                break;
            }
            case 2: {
                objSortNum.insert(0, "0");
                break;
            }
        }
        return String.valueOf(objSortNum);
    }

    public void setTreeEnable(TreeNode rootNode) {
        rootNode.setDisabled(true);
        List children = rootNode.getChildren();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)children)) {
            for (TreeNode child : children) {
                this.setTreeEnable(child);
            }
        }
    }

    public void serch(String searchText) {
        List treeNodes;
        boolean search;
        TreeNode rootNode = (TreeNode)JSON.parseObject((String)this.getPageCache().get(TREE_VIEWAP), TreeNode.class);
        IPageCache pageCache = (IPageCache)this.view.getService(IPageCache.class);
        String searchNodesCacheKey = this.view.getPageId() + "_searchNodes";
        String matchNodesCacheKey = this.view.getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = this.view.getPageId() + "_oldSearchText";
        String searchIndexCacheKey = this.view.getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        boolean bl = search = oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache);
        if (search) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 100);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 100);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"MigrateSchemeHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        } else {
            TreeView treeView = (TreeView)this.getControl(TREE_VIEWAP);
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache == treeNodes.size()) {
                    indexCache = 0;
                }
                this.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(indexCache));
                pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
            } else {
                this.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    private void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        this.expandParents(treeView, rootNode, treeNode);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        TreeNode p;
        String parentid = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentid) && (p = rootNode.getTreeNode(parentid)) != null) {
            this.expandParents(treeView, rootNode, p);
            treeView.expand(parentid);
        }
    }

    private IPageCache getPageCache() {
        return this.view.getPageCache();
    }

    private IDataModel getModel() {
        return this.view.getModel();
    }

    private <T extends Control> T getControl(String value) {
        return (T)this.view.getControl(value);
    }

    public Set<String> getNodeIds() {
        return this.nodeIds;
    }

    public static String getSchemeFormIdByMigrateObject(String objectFormId) {
        String billFormId = "";
        switch (objectFormId) {
            case "dmw_migrateobject_eas": {
                billFormId = "dmw_migratescheme_eas";
                break;
            }
            case "dmw_migrateobject_nc": {
                billFormId = "dmw_migratescheme_nc";
                break;
            }
            case "dmw_migrateobject_ecc": {
                billFormId = "dmw_migratescheme_ecc";
                break;
            }
        }
        return billFormId;
    }
}

