/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.tpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imsc.dmw.helper.tpl.MigrateSchemeHelper;
import kd.imsc.dmw.helper.tpl.MigrateUserGuideProjectHelper;
import kd.imsc.dmw.utils.StringUtils;

public class MigrateSortNumExecHelper {
    private IFormView view;

    public MigrateSortNumExecHelper(IFormView view) {
        this.view = view;
    }

    public void sortByDefault(DynamicObjectCollection entryEntity, String type) {
        if (entryEntity.isEmpty()) {
            return;
        }
        if ("dmw_migrateproject".equals(type)) {
            MigrateUserGuideProjectHelper.clearExecNumberRecord(this.view);
            MigrateUserGuideProjectHelper.sortScopeEntryByDefault(this.view, entryEntity);
        } else if ("dmw_migratescheme".equals(type)) {
            new MigrateSchemeHelper(this.view).sortSchemeEntryByDefault(entryEntity);
        }
    }

    public void sortByExecNum(DynamicObjectCollection entryEntity, String type) {
        if (entryEntity.isEmpty()) {
            return;
        }
        if ("dmw_migrateproject".equals(type)) {
            List<Object> migObjIdList = MigrateUserGuideProjectHelper.getMigObjIdList(entryEntity);
            String projectId = this.view.getPageCache().get("existProject");
            String schemeIsChanged = this.view.getPageCache().get("schemeIsChanged");
            if (!StringUtils.isEmpty(projectId) && !"yes".equals(schemeIsChanged)) {
                String objectMapMapStr = this.view.getPageCache().get("changeDataMark");
                String formId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(this.view);
                DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)formId);
                DynamicObjectCollection migrateExecEntries = MigrateUserGuideProjectHelper.buildMigObjFromProject(this.view, project, !StringUtils.isEmpty(objectMapMapStr));
                List<DynamicObject> sortEntryList = migrateExecEntries.stream().filter(n -> {
                    String value = n.getString("sortnumexec");
                    return value != null && !value.isEmpty();
                }).sorted(Comparator.comparing(n -> new BigDecimal(n.getString("sortnumexec")))).collect(Collectors.toList());
                MigrateUserGuideProjectHelper.buildScopeEntryBySortEntryList(this.view, sortEntryList, migObjIdList, "dmw_migrateproject");
            } else {
                DynamicObjectCollection schemeEntries = MigrateUserGuideProjectHelper.buildMigObjFromMulScheme(this.view, true);
                MigrateUserGuideProjectHelper.buildScopeEntry(this.view, schemeEntries, migObjIdList, "dmw_migratescheme");
            }
        } else if ("dmw_migratescheme".equals(type)) {
            List<DynamicObject> sortEntryList = entryEntity.stream().sorted(Comparator.comparing(n -> n.getInt("sortnumexec"))).collect(Collectors.toList());
            new MigrateSchemeHelper(this.view).buildSchemeEntryBySortEntryList(sortEntryList);
        }
    }

    public void updateSequence(DynamicObjectCollection entryEntity, int selectRow, int sortNumExec, String type) {
        if ("dmw_migrateproject".equals(type)) {
            Object selectedMigObjId = 0;
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject migObj = ((DynamicObject)entryEntity.get(i)).getDynamicObject("migrateobject");
                if (migObj == null || i != selectRow) continue;
                selectedMigObjId = migObj.getPkValue();
                break;
            }
            MigrateUserGuideProjectHelper.updateProjectSequence(this.view, entryEntity, selectedMigObjId, sortNumExec);
        } else if ("dmw_migratescheme".equals(type)) {
            new MigrateSchemeHelper(this.view).updateSchemeSequence(entryEntity, selectRow, sortNumExec);
        }
    }

    public static Map<String, List<String>> getErrorSequenceMap(DynamicObjectCollection entryentity, String type) {
        String migOjectKey = "";
        String sortnumberKey = "";
        if ("dmw_migrateproject".equals(type)) {
            migOjectKey = "migrateobject";
            sortnumberKey = "sortnumexec";
        } else if ("dmw_migratescheme".equals(type)) {
            migOjectKey = "migrateobject";
            sortnumberKey = "sortnumexec";
        }
        HashMap<String, List<String>> errorSequenceMap = new HashMap<String, List<String>>(8);
        if (StringUtils.isEmpty(migOjectKey)) {
            return errorSequenceMap;
        }
        Map<String, Integer> idSortnumMap = MigrateSortNumExecHelper.getObjIdSequenceMap(entryentity, migOjectKey, sortnumberKey);
        Map<String, String> objIdNameMap = MigrateSortNumExecHelper.getObjIdNameMap(entryentity, migOjectKey);
        Map<String, List<String>> relyObjIdMap = MigrateSortNumExecHelper.getRelyObjIdMap(entryentity, migOjectKey);
        for (DynamicObject item : entryentity) {
            String migObjId;
            List<String> relyObjIdList;
            DynamicObject migObj = item.getDynamicObject(migOjectKey);
            if (migObj == null || (relyObjIdList = relyObjIdMap.get(migObjId = migObj.getString("id"))) == null) continue;
            Integer migObjNum = idSortnumMap.get(migObjId);
            String migObjName = objIdNameMap.get(migObjId);
            ArrayList<String> relyObjNameList = new ArrayList<String>(8);
            for (String relyId : relyObjIdList) {
                String relyName = objIdNameMap.get(relyId);
                Integer relyNum = idSortnumMap.get(relyId);
                if (!idSortnumMap.containsKey(relyId) || relyNum <= migObjNum) continue;
                relyObjNameList.add(relyName);
            }
            if (relyObjNameList.isEmpty()) continue;
            List tempList = (List)errorSequenceMap.get(migObjName);
            if (tempList != null) {
                relyObjNameList.addAll(tempList);
            }
            errorSequenceMap.put(migObjName, relyObjNameList);
        }
        return errorSequenceMap;
    }

    private static Map<String, Integer> getObjIdSequenceMap(DynamicObjectCollection entryentity, String migOjectKey, String sortnumberKey) {
        HashMap<String, Integer> idSortnumMap = new HashMap<String, Integer>(8);
        if (StringUtils.isNotEmpty(migOjectKey)) {
            for (DynamicObject item : entryentity) {
                DynamicObject migObj = item.getDynamicObject(migOjectKey);
                if (migObj == null) continue;
                String id = migObj.getString("id");
                Integer sortnumExec = item.getInt(sortnumberKey);
                idSortnumMap.put(id, sortnumExec);
            }
        }
        return idSortnumMap;
    }

    private static Map<String, List<String>> getRelyObjIdMap(DynamicObjectCollection entryentity, String migOjectKey) {
        HashMap<String, List<String>> relyObjIdMap = new HashMap<String, List<String>>(8);
        if (StringUtils.isNotEmpty(migOjectKey)) {
            for (DynamicObject item : entryentity) {
                DynamicObjectCollection relyObjList;
                DynamicObject migObj = (DynamicObject)item.get(migOjectKey);
                if (migObj == null || (relyObjList = (DynamicObjectCollection)migObj.get("easobjectrelys")).isEmpty()) continue;
                ArrayList<String> relyObjIdList = new ArrayList<String>(8);
                for (int j = 0; j < relyObjList.size(); ++j) {
                    DynamicObject relyObj = ((DynamicObject)relyObjList.get(j)).getDynamicObject("fbasedataid");
                    if (relyObj == null) continue;
                    String relyObjId = relyObj.getString("id");
                    relyObjIdList.add(relyObjId);
                }
                String id = migObj.getString("id");
                relyObjIdMap.put(id, relyObjIdList);
            }
        }
        return relyObjIdMap;
    }

    private static Map<String, String> getObjIdNameMap(DynamicObjectCollection entryentity, String migOjectKey) {
        HashMap<String, String> idNameMap = new HashMap<String, String>(8);
        if (StringUtils.isNotEmpty(migOjectKey)) {
            for (DynamicObject item : entryentity) {
                DynamicObject migObj = item.getDynamicObject(migOjectKey);
                if (migObj == null) continue;
                String id = migObj.getString("id");
                String name = migObj.getString("name");
                idNameMap.put(id, name);
            }
        }
        return idNameMap;
    }
}

