/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.dmw.helper.tpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imsc.dmw.common.pagemodel.DmwMigrateuserguide;
import kd.imsc.dmw.engine.eas.core.log.CheckItemLog;
import kd.imsc.dmw.helper.eas.EasQueryHelper;
import kd.imsc.dmw.helper.tpl.MigrateUserGuideRelationHelper;
import kd.imsc.dmw.utils.CommonUtils;
import kd.imsc.dmw.utils.DynamicObjectUtils;
import kd.imsc.dmw.utils.FormUtil;
import kd.imsc.dmw.utils.QFilterUtils;
import kd.imsc.dmw.utils.StringUtil;
import org.apache.commons.collections.MapUtils;

public class MigrateUserGuideProjectHelper {
    private static final Log logger = LogFactory.getLog(MigrateUserGuideProjectHelper.class);
    private static final String PARENT_ID = "parentid";
    private static final String ADD_NODE = "A";
    private static final String ADD_NONE = "B";
    private static final String ADD_PARENT = "C";

    private MigrateUserGuideProjectHelper() {
    }

    public static void initTree(IFormView view, String treeView) {
        TreeView tree = (TreeView)view.getControl(treeView);
        tree.deleteAllNodes();
        TreeNode rootNode = MigrateUserGuideProjectHelper.buildLeftTree(view, tree);
        view.getPageCache().put(treeView, JSON.toJSONString((Object)rootNode));
    }

    private static TreeNode buildLeftTree(IFormView view, TreeView tree) {
        Object[] schemeIds = MigrateUserGuideProjectHelper.getMulMigSchemeIds(view);
        DynamicObjectCollection migrateObjectList = MigrateUserGuideProjectHelper.queryMigrationObject(view, schemeIds);
        List<DynamicObject> treeObjects = migrateObjectList.stream().sorted(Comparator.comparing(n -> n.getInt("sortnum"))).collect(Collectors.toList());
        String name = ResManager.loadKDString((String)"\u5168\u90e8", (String)"MigrateUserGuideProjectHelper_0", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        TreeNode rootNode = new TreeNode("", "0", name);
        TreeNode rootNodeLeafLess = new TreeNode("", "0", name);
        tree.addNode(rootNodeLeafLess);
        Set<Long> migObjIds = MigrateUserGuideProjectHelper.getMigObjIds(view, schemeIds);
        for (DynamicObject treeObj : treeObjects) {
            long parentId = treeObj.getLong(PARENT_ID);
            if (parentId != 0L) continue;
            TreeNode treeNode = new TreeNode(rootNode.getId(), treeObj.getString("id"), treeObj.getString("name"));
            MigrateUserGuideProjectHelper.recursiveAddChildLeaf(treeNode, treeObjects, treeObj, migObjIds);
            rootNode.addChild(treeNode);
            TreeNode treeNodeLeafLess = new TreeNode(rootNodeLeafLess.getId(), treeObj.getString("id"), treeObj.getString("name"));
            MigrateUserGuideProjectHelper.recursiveAddChildLeafLess(treeNodeLeafLess, treeObjects, treeObj, migObjIds);
            if (treeNodeLeafLess.getChildren() == null) continue;
            rootNodeLeafLess.addChild(treeNodeLeafLess);
        }
        return rootNode;
    }

    private static Object[] getMulMigSchemeIds(IFormView view) {
        DynamicObjectCollection mulSchemeData = (DynamicObjectCollection)view.getModel().getValue("mulmigratescheme");
        int size = 0;
        if (!CommonUtils.isNull(mulSchemeData)) {
            size = mulSchemeData.size();
        }
        Object[] pkArray = new Object[size];
        for (int i = 0; i < size; ++i) {
            DynamicObject scheme = ((DynamicObject)mulSchemeData.get(i)).getDynamicObject("fbasedataid");
            pkArray[i] = scheme.getPkValue();
        }
        return pkArray;
    }

    private static DynamicObjectCollection queryMigrationObject(IFormView view, Object[] schemeIds) {
        String objectFormId = MigrateUserGuideProjectHelper.getObjectFormIdByUserGuide(view);
        if (StringUtil.isEmpty(objectFormId)) {
            return new DynamicObjectCollection();
        }
        Set<Long> migObjIds = MigrateUserGuideProjectHelper.getMigObjIds(view, schemeIds);
        QFilter selectMigrateObjFilter = new QFilter("id", "in", migObjIds);
        DynamicObjectCollection queryList = QueryServiceHelper.query((String)objectFormId, (String)"id,name,number,group parentid,sortnum", (QFilter[])new QFilter[]{selectMigrateObjFilter});
        DynamicObjectCollection modelList = QueryServiceHelper.query((String)MigrateUserGuideProjectHelper.getModuleFormIdByUserGuide(view), (String)"id,parent parentid,name,number,sortnum", (QFilter[])QFilterUtils.getEnableQFilter().toArray());
        modelList.addAll((Collection)queryList);
        return modelList;
    }

    private static Set<Long> getMigObjIds(IFormView view, Object[] schemeIds) {
        HashSet<Long> migObjIds;
        block4: {
            long migrateProjectId;
            block3: {
                DynamicObject[] migSchemes;
                migObjIds = new HashSet<Long>(8);
                migrateProjectId = MigrateUserGuideProjectHelper.getCurrentMigrationProjectId(view);
                String schemeIsChanged = view.getPageCache().get("schemeIsChanged");
                if (migrateProjectId != 0L && !"yes".equals(schemeIsChanged)) break block3;
                String schemeFormId = MigrateUserGuideProjectHelper.getSchemeFormIdByUserGuide(view);
                if (!StringUtil.isNotEmpty(schemeFormId)) break block4;
                QFilter qFilter = new QFilter("id", "in", (Object)schemeIds);
                for (DynamicObject migScheme : migSchemes = BusinessDataServiceHelper.load((String)schemeFormId, (String)"id,treeentryentity,treeentryentity.migrateobject", (QFilter[])qFilter.toArray())) {
                    DynamicObjectCollection schemeEntry = migScheme.getDynamicObjectCollection("treeentryentity");
                    for (DynamicObject obj : schemeEntry) {
                        DynamicObject migrateObject = (DynamicObject)obj.get("migrateobject");
                        if (migrateObject == null) continue;
                        migObjIds.add((Long)migrateObject.getPkValue());
                    }
                }
                break block4;
            }
            String projectFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(view);
            QFilter qFilter = new QFilter("id", "=", (Object)migrateProjectId);
            DynamicObjectCollection projectEntry = QueryServiceHelper.query((String)projectFormId, (String)"id,number,treeentryentity.migrateobject", (QFilter[])qFilter.toArray());
            for (DynamicObject entry : projectEntry) {
                long objectId = entry.getLong("treeentryentity.migrateobject");
                migObjIds.add(objectId);
            }
        }
        return migObjIds;
    }

    private static boolean recursiveAddChildLeaf(TreeNode treeNode, List<DynamicObject> migrateObjList, DynamicObject treeObject, Set<Long> migObjIds) {
        String id = treeObject.getString("id");
        List childrenAreas = migrateObjList.stream().filter(n -> id.equals(n.getString(PARENT_ID))).collect(Collectors.toList());
        if (childrenAreas.isEmpty() && !migObjIds.contains(treeObject.get("id"))) {
            return false;
        }
        for (DynamicObject childClass : childrenAreas) {
            ArrayList<TreeNode> children = new ArrayList<TreeNode>(8);
            TreeNode treeNodeTmp = new TreeNode(treeNode.getId(), childClass.getString("id"), childClass.getString("name"));
            if (!MigrateUserGuideProjectHelper.recursiveAddChildLeaf(treeNodeTmp, migrateObjList, childClass, migObjIds)) continue;
            children.add(treeNodeTmp);
            treeNode.addChildren(children);
        }
        return true;
    }

    private static String recursiveAddChildLeafLess(TreeNode treeNode, List<DynamicObject> migrateObjList, DynamicObject migrateObj, Set<Long> migObjIds) {
        String id = migrateObj.getString("id");
        String status = ADD_NODE;
        List childrenAreas = migrateObjList.stream().filter(n -> id.equals(n.getString(PARENT_ID))).collect(Collectors.toList());
        if (childrenAreas.isEmpty() && !migObjIds.contains(migrateObj.get("id"))) {
            return ADD_NONE;
        }
        if (migObjIds.contains(migrateObj.get("id"))) {
            return ADD_PARENT;
        }
        for (DynamicObject childClass : childrenAreas) {
            ArrayList<TreeNode> children = new ArrayList<TreeNode>(8);
            TreeNode treeNodeTmp = new TreeNode(treeNode.getId(), childClass.getString("id"), childClass.getString("name"));
            switch (status = MigrateUserGuideProjectHelper.recursiveAddChildLeafLess(treeNodeTmp, migrateObjList, childClass, migObjIds)) {
                case "A": {
                    children.add(treeNodeTmp);
                    treeNode.addChildren(children);
                    status = ADD_NODE;
                    break;
                }
                case "B": {
                    status = ADD_NONE;
                    break;
                }
                case "C": {
                    status = ADD_NODE;
                    break;
                }
            }
        }
        return status;
    }

    public static long getCurrentMigrationProjectId(IFormView view) {
        String projectFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(view);
        if (StringUtil.isNotEmpty(projectFormId)) {
            String projectNumber = (String)view.getModel().getValue("projectnumber");
            QFilter migrateNumFilter = new QFilter("number", "=", (Object)projectNumber);
            DynamicObject migrateProject = QueryServiceHelper.queryOne((String)projectFormId, (String)"id", (QFilter[])new QFilter[]{migrateNumFilter});
            if (migrateProject != null) {
                return migrateProject.getLong("id");
            }
        }
        return 0L;
    }

    public static void clearExecNumberRecord(IFormView view) {
        String objectMapMapStr = view.getPageCache().get("changeDataMark");
        Map objectMapMap = (Map)JSON.parseObject((String)objectMapMapStr, Map.class);
        if (!CommonUtils.isNull(objectMapMap)) {
            for (Map objectMap : objectMapMap.values()) {
                objectMap.remove("sortnumexec");
            }
        }
        view.getPageCache().put("changeDataMark", JSON.toJSONString((Object)objectMapMap));
    }

    public static DynamicObjectCollection buildMigObjFromMulScheme(IFormView view, boolean fromCache) {
        DynamicObjectCollection schemeEntries = new DynamicObjectCollection();
        String schemeFormId = MigrateUserGuideProjectHelper.getSchemeFormIdByUserGuide(view);
        if (StringUtil.isEmpty(schemeFormId)) {
            return schemeEntries;
        }
        Object[] schemeIds = MigrateUserGuideProjectHelper.getMulMigSchemeIds(view);
        boolean isMul = schemeIds.length > 1;
        DynamicObject[] schemes = BusinessDataServiceHelper.load((Object[])schemeIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)schemeFormId));
        DynamicObjectCollection schemeEntriesDup = new DynamicObjectCollection();
        for (DynamicObject scheme : schemes) {
            schemeEntriesDup.addAll((Collection)scheme.getDynamicObjectCollection("treeentryentity"));
        }
        ArrayList entryList = isMul ? schemeEntriesDup.stream().sorted(Comparator.comparing(n -> new BigDecimal(n.getString("sortnumdefault")))).collect(Collectors.toList()) : new ArrayList(schemeEntriesDup);
        HashMap schemeObjMap = new HashMap(8);
        HashSet<Object> idSet = new HashSet<Object>(8);
        int sortNum = 1;
        for (int i = 0; i < entryList.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryList.get(i);
            DynamicObject migObj = entry.getDynamicObject("migrateobject");
            DynamicObject scheme = (DynamicObject)entry.getParent();
            List<Object> tempList = new ArrayList(2);
            if (migObj == null) continue;
            if (!idSet.contains(migObj.getPkValue())) {
                if (isMul) {
                    if (i - 1 >= 0) {
                        DynamicObject entryPre = (DynamicObject)entryList.get(i - 1);
                        if (entryPre.getString("sortnumdefault").equals(entry.getString("sortnumdefault"))) {
                            entry.set("sortnumexec", (Object)sortNum);
                        } else {
                            entry.set("sortnumexec", (Object)(++sortNum));
                        }
                    } else {
                        entry.set("sortnumexec", (Object)sortNum);
                    }
                }
                schemeEntries.add((Object)entry);
                tempList.add(scheme.getPkValue());
            } else {
                tempList = (List)schemeObjMap.get(migObj.getPkValue());
                tempList.add(scheme.getPkValue());
            }
            schemeObjMap.put(migObj.getPkValue(), tempList);
            idSet.add(migObj.getPkValue());
        }
        String belongSchemeStr = JSON.toJSONString(schemeObjMap);
        view.getPageCache().put("belongSchemeCache", belongSchemeStr);
        if (fromCache) {
            MigrateUserGuideProjectHelper.updateEntryFromCache(view, schemeEntries);
        }
        return schemeEntries;
    }

    public static DynamicObjectCollection buildMigObjFromProject(IFormView view, DynamicObject project, boolean fromCache) {
        DynamicObjectCollection migrateEntries = project.getDynamicObjectCollection("treeentryentity");
        if (fromCache) {
            MigrateUserGuideProjectHelper.updateProjectEntriesFromCache(view, migrateEntries);
        }
        return migrateEntries;
    }

    public static void updateEntryFromCache(IFormView view, DynamicObjectCollection schemeEntries) {
        String objectMapMapStr = view.getPageCache().get("changeDataMark");
        Map objectMapMap = (Map)JSON.parseObject((String)objectMapMapStr, Map.class);
        for (DynamicObject scheme : schemeEntries) {
            Map dataMap;
            DynamicObject migObj = scheme.getDynamicObject("migrateobject");
            if (migObj == null) continue;
            Long migObjId = migObj.getLong("id");
            if (objectMapMap == null || CommonUtils.isNull(objectMapMap.get(migObjId)) || (dataMap = (Map)objectMapMap.get(migObjId)).get("sortnumexec") == null) continue;
            scheme.set("sortnumexec", dataMap.get("sortnumexec"));
        }
        List entryList = schemeEntries.stream().sorted(Comparator.comparing(n -> new BigDecimal(n.getString("sortnumexec")))).collect(Collectors.toList());
        schemeEntries.clear();
        schemeEntries.addAll(entryList);
    }

    public static void updateProjectEntriesFromCache(IFormView view, DynamicObjectCollection projectEntries) {
        String objectMapMapStr = view.getPageCache().get("changeDataMark");
        Map objectMapMap = (Map)JSON.parseObject((String)objectMapMapStr, Map.class);
        for (DynamicObject entry : projectEntries) {
            DynamicObject migObj = entry.getDynamicObject("migrateobject");
            if (migObj == null) continue;
            Long migObjId = migObj.getLong("id");
            if (objectMapMap == null || CommonUtils.isNull(objectMapMap.get(migObjId))) continue;
            Map dataMap = (Map)objectMapMap.get(migObjId);
            entry.set("migbotp", dataMap.get("migbotp"));
            entry.set("migdap", dataMap.get("migdap"));
            entry.set("migrecord", dataMap.get("migrecord"));
            entry.set("enableinvaliddata", dataMap.get("enableinvaliddata"));
            entry.set("disableinvaliddata", dataMap.get("disableinvaliddata"));
            if (dataMap.get("sortnumexec") == null) continue;
            entry.set("sortnumexec", dataMap.get("sortnumexec"));
        }
    }

    public static boolean isEntryChanged(IFormView view, long migrateProjectId) {
        String objectMapMapStr;
        String projectFormId;
        ArrayList<Object> nowIdList = new ArrayList<Object>(8);
        ArrayList<Object> preIdList = new ArrayList<Object>(8);
        if (migrateProjectId > 0L && StringUtil.isNotEmpty(projectFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(view))) {
            DynamicObject migProject = BusinessDataServiceHelper.loadSingle((Object)migrateProjectId, (String)projectFormId);
            DynamicObjectCollection preSchemes = migProject.getDynamicObjectCollection("mulmigratescheme");
            DynamicObjectCollection nowSchemes = (DynamicObjectCollection)view.getModel().getValue("mulmigratescheme");
            for (DynamicObject entry : preSchemes) {
                DynamicObject preScheme = entry.getDynamicObject("fbasedataid");
                if (preScheme == null) continue;
                preIdList.add(preScheme.getPkValue());
            }
            for (DynamicObject entry : nowSchemes) {
                DynamicObject nowScheme = entry.getDynamicObject("fbasedataid");
                if (nowScheme == null) continue;
                nowIdList.add(nowScheme.getPkValue());
            }
        }
        boolean isMark = (CommonUtils.isNull(objectMapMapStr = view.getPageCache().get("changeDataMark")) || "null".equals(objectMapMapStr)) && nowIdList.equals(preIdList);
        return !isMark;
    }

    public static void buildScopeEntry(IFormView view, DynamicObjectCollection entryColl, List<Object> migObjIdList, String type) {
        String projectFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(view);
        if (StringUtil.isEmpty(projectFormId)) {
            return;
        }
        switch (type) {
            case "dmw_migratescheme": {
                DynamicObject newDynObj = BusinessDataServiceHelper.newDynamicObject((String)projectFormId);
                String tableName = newDynObj.getDynamicObjectCollection("treeentryentity").getDynamicObjectType().getAlias();
                Map<Long, Object> idMappingMap = MigrateUserGuideProjectHelper.getIdMappingMap(entryColl, tableName);
                MigrateUserGuideProjectHelper.buildScopeEntryByScheme(view, entryColl, migObjIdList, idMappingMap);
                break;
            }
            case "dmw_migrateproject": {
                MigrateUserGuideProjectHelper.buildScopeEntryByProject(view, entryColl, migObjIdList);
                break;
            }
        }
    }

    public static void sortScopeEntryByDefault(IFormView view, DynamicObjectCollection entryEntity) {
        List<DynamicObject> sortEntryList = entryEntity.stream().sorted(Comparator.comparing(n -> new BigDecimal(n.getString("sortnumdefault")))).collect(Collectors.toList());
        List<Object> migObjIdList = entryEntity.stream().map(n -> n.getDynamicObject("migrateobject").getPkValue()).collect(Collectors.toList());
        ((DynamicObject)sortEntryList.get(0)).set("sortnumexec", (Object)1);
        for (int i = 1; i < sortEntryList.size(); ++i) {
            DynamicObject entryNow = (DynamicObject)sortEntryList.get(i);
            DynamicObject entryPre = sortEntryList.get(i - 1);
            String numNow = entryNow.getString("sortnumdefault");
            String numPre = entryPre.getString("sortnumdefault");
            int sortNumber = entryPre.getInt("sortnumexec");
            if (!numNow.equals(numPre)) {
                ++sortNumber;
            }
            sortEntryList.get(i).set("sortnumexec", (Object)sortNumber);
        }
        MigrateUserGuideProjectHelper.buildScopeEntryBySortEntryList(view, sortEntryList, migObjIdList, "dmw_migrateuserguide");
        DynamicObjectCollection schemeEntries = MigrateUserGuideProjectHelper.buildMigObjFromMulScheme(view, false);
        int[] rows = new int[schemeEntries.size()];
        for (int i = 0; i < schemeEntries.size(); ++i) {
            rows[i] = i;
        }
        MigrateUserGuideRelationHelper.recordChangeData(view, schemeEntries, rows, true);
    }

    public static void buildScopeEntryBySortEntryList(IFormView view, List<DynamicObject> sortEntryList, List<Object> migObjIdList, String type) {
        IDataModel model = view.getModel();
        model.deleteEntryData("treeentryentity");
        DynamicObjectCollection entryEntities = model.getEntryEntity("treeentryentity");
        int j = 1;
        for (int i = 0; i < sortEntryList.size(); ++i) {
            DynamicObject entry = sortEntryList.get(i);
            DynamicObject migObj = entry.getDynamicObject("migrateobject");
            if (migObj == null || !migObjIdList.contains(migObj.getPkValue())) continue;
            DynamicObject row = entryEntities.addNew();
            row.set("id", entry.getPkValue());
            row.set("seq", (Object)j++);
            row.set("executetype", (Object)entry.getString("executetype"));
            row.set("migrateobject", (Object)migObj);
            row.set("sortnumexec", entry.get("sortnumexec"));
            row.set("sortnumdefault", entry.get("sortnumdefault"));
            row.set("belongschemes", entry.get("belongschemes"));
            row.set("integrattype", (Object)entry.getString("integrattype"));
            if ("dmw_migrateuserguide".equals(type)) {
                row.set("scheme", entry.get("scheme"));
            } else if ("dmw_migrateproject".equals(type)) {
                row.set("scheme", entry.get("startscheme"));
            }
            row.set("migbotp", entry.get("migbotp"));
            row.set("migdap", entry.get("migdap"));
            row.set("migrecord", entry.get("migrecord"));
            row.set("enableinvaliddata", entry.get("enableinvaliddata"));
            row.set("disableinvaliddata", entry.get("disableinvaliddata"));
        }
        model.updateEntryCache(entryEntities);
        view.updateView("treeentryentity");
    }

    private static void buildScopeEntryByScheme(IFormView view, DynamicObjectCollection schemeEntries, List<Object> migObjIdList, Map<Long, Object> idMappingMap) {
        DynamicObjectCollection entryEntries = view.getModel().getEntryEntity("treeentryentity");
        entryEntries.clear();
        String schemeObjMapStr = view.getPageCache().get("belongSchemeCache");
        Map schemeObjMap = (Map)JSON.parseObject((String)schemeObjMapStr, Map.class);
        String intiType = "initintegrattype";
        String scheme = "initschemeid";
        String migBotp = "migbotpini";
        String migDap = "migdapini";
        String migRecord = "migrecordini";
        String migrateModel = (String)view.getModel().getValue("migrationmodel");
        if (ADD_NONE.equals(migrateModel)) {
            intiType = "allintegrattype";
            scheme = "allschemeid";
            migBotp = "migbotpall";
            migDap = "migdapall";
            migRecord = "migrecordall";
        }
        String guideFormId = view.getModel().getDataEntityType().getName();
        Map<Long, DynamicObject> migObjMap = MigrateUserGuideProjectHelper.getEntryMigObjMap(schemeEntries, MigrateUserGuideProjectHelper.getMigObjFormIdByUserGuide(guideFormId), "migrateobject_id");
        int j = 0;
        for (int i = 0; i < schemeEntries.size(); ++i) {
            DynamicObject entry = (DynamicObject)schemeEntries.get(i);
            DynamicObject migObj = entry.getDynamicObject("migrateobject");
            DynamicObject migObjOtherAttr = migObjMap.get(migObj.getLong("id"));
            if (!migObjIdList.contains(migObj.getPkValue())) continue;
            DynamicObject row = entryEntries.addNew();
            row.set("id", idMappingMap.get(entry.getLong("id")));
            row.set("migrateobject", (Object)migObj);
            row.set("sortnumdefault", entry.get("sortnumdefault"));
            row.set("sortnumexec", entry.get("sortnumexec"));
            DynamicObjectCollection belongSchemes = row.getDynamicObjectCollection("belongschemes");
            List schemeObjList = (List)schemeObjMap.get(migObj.getPkValue());
            for (Object belongSchemeId : schemeObjList) {
                DynamicObject tempSchemes = new DynamicObject(belongSchemes.getDynamicObjectType());
                tempSchemes.set("fbasedataid_id", belongSchemeId);
                belongSchemes.add((Object)tempSchemes);
            }
            row.set("integrattype", (Object)migObj.getString(intiType));
            row.set(String.join((CharSequence)"_", "scheme", "id"), migObj.get(scheme));
            boolean supportBotp = Boolean.parseBoolean(MigrateUserGuideRelationHelper.getModifyRecord(view, migObj, migBotp));
            boolean supportDap = Boolean.parseBoolean(MigrateUserGuideRelationHelper.getModifyRecord(view, migObj, migDap));
            boolean supportRecord = Boolean.parseBoolean(MigrateUserGuideRelationHelper.getModifyRecord(view, migObj, migRecord));
            boolean supportEnable = Boolean.parseBoolean(MigrateUserGuideRelationHelper.getModifyRecord(view, migObj, "enableinvaliddata"));
            boolean supportDisable = Boolean.parseBoolean(MigrateUserGuideRelationHelper.getModifyRecord(view, migObj, "disableinvaliddata"));
            view.setEnable(Boolean.valueOf(supportBotp), j, new String[]{"migbotp"});
            view.setEnable(Boolean.valueOf(supportDap), j, new String[]{"migdap"});
            view.setEnable(Boolean.valueOf(supportRecord), j++, new String[]{"migrecord"});
            row.set("migbotp", (Object)supportBotp);
            row.set("migdap", (Object)supportDap);
            row.set("migrecord", (Object)supportRecord);
            row.set("enableinvaliddata", (Object)supportEnable);
            row.set("disableinvaliddata", (Object)supportDisable);
            row.set("supportorgmig", migObjOtherAttr.get("supportorgmig"));
            row.set("supportperiodmig", migObjOtherAttr.get("supportperiodmig"));
            row.set("executetype", migObj.get("executetype"));
        }
        if (!entryEntries.isEmpty()) {
            BusinessDataServiceHelper.loadRefence((Object[])entryEntries.toArray(), (IDataEntityType)((DynamicObject)entryEntries.get(0)).getDynamicObjectType());
        }
        view.getModel().updateEntryCache(entryEntries);
        view.updateView("treeentryentity");
    }

    private static void buildScopeEntryByProject(IFormView view, DynamicObjectCollection projectEntries, List<Object> migObjIdList) {
        view.getModel().deleteEntryData("treeentryentity");
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("treeentryentity");
        int j = 0;
        for (int i = 0; i < projectEntries.size(); ++i) {
            Object migObjId;
            DynamicObject projectEntry = (DynamicObject)projectEntries.get(i);
            projectEntry.getDataEntityType().getProperties();
            DynamicObject migObj = projectEntry.getDynamicObject("migrateobject");
            if (migObj == null || !migObjIdList.contains(migObjId = migObj.getPkValue())) continue;
            DynamicObject row = entryEntity.addNew();
            row.set("id", projectEntry.get("id"));
            row.set("seq", (Object)(j + 1));
            row.set("migrateobject", (Object)migObj);
            row.set("integrattype", projectEntry.get("integrattype"));
            row.set("scheme", projectEntry.get("startscheme"));
            row.set("belongschemes", projectEntry.get("belongschemes"));
            boolean supportBotp = projectEntry.getBoolean("migbotp");
            boolean supportDap = projectEntry.getBoolean("migdap");
            boolean supportRecord = projectEntry.getBoolean("migrecord");
            view.setEnable(Boolean.valueOf(supportBotp), j, new String[]{"migbotp"});
            view.setEnable(Boolean.valueOf(supportDap), j, new String[]{"migdap"});
            view.setEnable(Boolean.valueOf(supportRecord), j++, new String[]{"migrecord"});
            row.set("migbotp", (Object)supportBotp);
            row.set("migdap", (Object)supportDap);
            row.set("migrecord", (Object)supportRecord);
            row.set("sortnumdefault", projectEntry.get("sortnumdefault"));
            row.set("sortnumexec", projectEntry.get("sortnumexec"));
            row.set("disableinvaliddata", projectEntry.get("disableinvaliddata"));
            row.set("enableinvaliddata", projectEntry.get("enableinvaliddata"));
            row.set("supportorgmig", projectEntry.get("supportorgmig"));
            row.set("supportperiodmig", projectEntry.get("supportperiodmig"));
            row.set("executetype", projectEntry.get("executetype"));
        }
        view.getModel().updateEntryCache(entryEntity);
        view.updateView("treeentryentity");
    }

    public static void updateProjectSequence(IFormView view, DynamicObjectCollection entryEntity, Object selectedObjId, int sortNumExec) {
        DynamicObject migObj;
        DynamicObjectCollection schemeEntries = MigrateUserGuideProjectHelper.buildMigObjFromMulScheme(view, true);
        HashMap<Object, Integer> migObjSortNumMap = new HashMap<Object, Integer>(8);
        for (Object entry : schemeEntries) {
            int currentSortNum = entry.getInt("sortnumexec");
            migObj = entry.getDynamicObject("migrateobject");
            if (currentSortNum >= sortNumExec && !migObj.getPkValue().equals(selectedObjId)) {
                entry.set("sortnumexec", (Object)(++currentSortNum));
            }
            migObjSortNumMap.put(migObj.getPkValue(), currentSortNum);
        }
        int[] rows = new int[schemeEntries.size()];
        for (DynamicObject entry : entryEntity) {
            migObj = entry.getDynamicObject("migrateobject");
            if (!migObjSortNumMap.containsKey(migObj.getPkValue())) continue;
            entry.set("sortnumexec", migObjSortNumMap.get(migObj.getPkValue()));
        }
        for (int i = 0; i < schemeEntries.size(); ++i) {
            rows[i] = i;
        }
        MigrateUserGuideRelationHelper.recordChangeData(view, schemeEntries, rows, true);
        view.getModel().updateEntryCache(entryEntity);
        view.updateView("treeentryentity");
    }

    public static void setProjectValue(IFormView view) {
        Object id = view.getFormShowParameter().getCustomParam("projectid");
        IDataModel model = view.getModel();
        String billFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(view);
        if (StringUtil.isEmpty(billFormId)) {
            return;
        }
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)id, (String)billFormId);
        view.getPageCache().put("existProject", String.valueOf(id));
        String name = project.getString("name");
        String number = project.getString("number");
        model.setValue("projectnumber", (Object)number);
        model.setValue("projectname", (Object)name);
        model.setValue("migrationmodel", project.get("migrationmodel"));
        model.setValue("dblink", project.get("dblink"));
        model.setValue("confirmxhbackup", project.get("confirmxhbackup"));
        String easOrgIds = project.getString("easorgrange_tag");
        model.setValue("easorgrangef7", (Object)MigrateUserGuideProjectHelper.getEasOrgIds(easOrgIds));
        model.setValue("begindate", project.get("begindate"));
        model.setValue("migrateillustrate", project.get("migrateillustrate"));
        model.setValue("checktaskid", project.get("checktaskid"));
        model.setValue("exectaskid", project.get("exectaskid"));
        model.setValue("advancedset", project.get("advancedset"));
        FormUtil.setLabValue(view, "projectnumlab", number);
        FormUtil.setLabValue(view, "projectnamelab", name);
        view.setVisible(Boolean.TRUE, new String[]{"projectinfoap"});
        String status = project.getString("projectstatus");
        MigrateUserGuideProjectHelper.setProjectStatus(view, status);
        MigrateUserGuideProjectHelper.setMigrateRangeData(view, project);
        MigrateUserGuideProjectHelper.setMigrateCheckData(view, project);
        MigrateUserGuideProjectHelper.setMigrateExecData(view, project);
    }

    public static void setCopyProjectValue(IFormView view) {
        Object id = view.getFormShowParameter().getCustomParam("projectid");
        IDataModel model = view.getModel();
        if (id != null) {
            String billFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(view);
            if (StringUtil.isEmpty(billFormId)) {
                return;
            }
            DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)id, (String)billFormId);
            model.setValue("migrationmodel", project.get("migrationmodel"));
            MigrateUserGuideProjectHelper.handleCopyMulScheme(view, project);
            String easOrgIds = project.getString("easorgrange_tag");
            model.setValue("easorgrangef7", (Object)MigrateUserGuideProjectHelper.getEasOrgIds(easOrgIds));
            model.setValue("begindate", project.get("begindate"));
            model.setValue("advancedset", project.get("advancedset"));
            model.setValue("dblink", project.get("dblink"));
            MigrateUserGuideProjectHelper.handleEntries(view);
        }
    }

    public static void handleEntries(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObjectCollection schemeEntryColl = MigrateUserGuideProjectHelper.buildMigObjFromMulScheme(view, false);
        List<Object> migObjIdList = MigrateUserGuideProjectHelper.getMigObjIdList(schemeEntryColl);
        MigrateUserGuideProjectHelper.buildScopeEntry(view, schemeEntryColl, migObjIdList, "dmw_migratescheme");
        DynamicObjectCollection scopeEntries = model.getEntryEntity("treeentryentity");
        int[] rows = new int[scopeEntries.size()];
        for (int i = 0; i < scopeEntries.size(); ++i) {
            rows[i] = i;
        }
        MigrateUserGuideRelationHelper.recordChangeData(view, scopeEntries, rows, false);
        MigrateUserGuideProjectHelper.setMigCheckEntry(view, schemeEntryColl, "dmw_migratescheme", null);
        MigrateUserGuideProjectHelper.setMigCheckParamEntry(view, schemeEntryColl, "dmw_migratescheme", null);
        String projectFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(view);
        if (StringUtil.isEmpty(projectFormId)) {
            return;
        }
        DynamicObject newDynObj = BusinessDataServiceHelper.newDynamicObject((String)projectFormId);
        String tableName = newDynObj.getDynamicObjectCollection("treeentryentity").getDynamicObjectType().getAlias();
        Map<Long, Object> idMappingMap = MigrateUserGuideProjectHelper.getIdMappingMap(schemeEntryColl, tableName);
        MigrateUserGuideProjectHelper.setMigExecEntry(view, schemeEntryColl, idMappingMap, "dmw_migratescheme");
    }

    public static List<Object> getMigObjIdList(DynamicObjectCollection entryEntity) {
        ArrayList<Object> migObjIdList = new ArrayList<Object>(8);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject migObj = ((DynamicObject)entryEntity.get(i)).getDynamicObject("migrateobject");
            if (migObj == null) continue;
            migObjIdList.add(migObj.getPkValue());
        }
        return migObjIdList;
    }

    public static void setMigCheckEntry(IFormView view, DynamicObjectCollection entryColl, String type, DynamicObject project) {
        IDataModel model = view.getModel();
        model.deleteEntryData("checktreeentryentity");
        DynamicObjectCollection guideCheckEntryColl = model.getEntryEntity("checktreeentryentity");
        if ("dmw_migratescheme".equals(type)) {
            MigrateUserGuideProjectHelper.buildCheckEntryByScheme(view, guideCheckEntryColl, entryColl);
        } else if ("dmw_migrateproject".equals(type)) {
            MigrateUserGuideProjectHelper.buildCheckEntryByProject(view, guideCheckEntryColl, entryColl, project);
        }
        view.getModel().updateEntryCache(guideCheckEntryColl);
        view.updateView("checktreeentryentity");
    }

    public static void setMigCheckParamEntry(IFormView view, DynamicObjectCollection entryColl, String type, DynamicObject project) {
        IDataModel model = view.getModel();
        HashMap<Long, Map<String, Object>> checkParamFields = new HashMap<Long, Map<String, Object>>(16);
        model.deleteEntryData("checkparamentry");
        DynamicObjectCollection checkParamEntry = model.getEntryEntity("checkparamentry");
        Set<Object> useFields = new HashSet(16);
        if ("dmw_migratescheme".equals(type)) {
            useFields = MigrateUserGuideProjectHelper.buildParamEntryByScheme(view, checkParamEntry, entryColl, checkParamFields);
        } else if ("dmw_migrateproject".equals(type)) {
            useFields = MigrateUserGuideProjectHelper.buildParamEntryByProject(checkParamEntry, entryColl, project, checkParamFields);
        }
        if (CollectionUtils.isNotEmpty(useFields)) {
            String guideFormId = view.getModel().getDataEntityType().getName();
            Map<String, String> autoFields = MigrateUserGuideProjectHelper.autoFields(guideFormId, MigrateUserGuideProjectHelper.getProjectId(view));
            Set<String> allFields = autoFields.keySet();
            for (String allField : allFields) {
                if (useFields.contains(allField)) continue;
                view.setVisible(Boolean.FALSE, new String[]{allField});
            }
            view.setVisible(Boolean.TRUE, useFields.toArray(new String[0]));
        }
        view.getPageCache().put("checkParamMapping", JSONObject.toJSONString(checkParamFields));
        MigrateUserGuideProjectHelper.dealFieldLock(view);
        view.getModel().updateEntryCache(checkParamEntry);
        view.updateView("checkparamentry");
    }

    public static void dealFieldLock(IFormView view) {
        IDataModel model = view.getModel();
        String name = model.getDataEntity().getDataEntityType().getName();
        Map<String, String> autoFields = MigrateUserGuideProjectHelper.autoFields(name, MigrateUserGuideProjectHelper.getProjectId(view));
        DynamicObjectCollection entryEntity = model.getEntryEntity("checkparamentry");
        List checkItemIds = entryEntity.stream().map(n -> n.getDynamicObject("checkitemvar").getPkValue()).collect(Collectors.toList());
        Map checkItems = new HashMap(16);
        if (CollectionUtils.isNotEmpty(checkItemIds)) {
            QFilter qFilter = new QFilter("id", "in", checkItemIds);
            String formId = MigrateUserGuideProjectHelper.getCheckItemFormIdByUserGuide(view);
            checkItems = BusinessDataServiceHelper.loadFromCache((String)formId, (QFilter[])qFilter.toArray());
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            HashSet<String> checkFields = new HashSet<String>(16);
            DynamicObject checkItemvar = entry.getDynamicObject("checkitemvar");
            DynamicObject checkItemDb = (DynamicObject)checkItems.get(checkItemvar.getPkValue());
            DynamicObjectCollection paramEntrys = checkItemDb.getDynamicObjectCollection("paramentry");
            for (DynamicObject paramEntry : paramEntrys) {
                DynamicObject varSign = paramEntry.getDynamicObject("varsign");
                if (varSign == null) continue;
                String number = varSign.getString("number");
                String key = "imscdmw_" + number;
                checkFields.add(key);
            }
            for (String field : autoFields.keySet()) {
                if (!checkFields.contains(field)) {
                    view.setEnable(Boolean.FALSE, i, new String[]{field});
                    continue;
                }
                view.setEnable(Boolean.TRUE, i, new String[]{field});
            }
        }
        view.updateView("checkparamentry");
    }

    public static void buildCheckEntryByScheme(IFormView view, DynamicObjectCollection guideCheckEntryColl, DynamicObjectCollection schemeEntryColl) {
        List<DynamicObject> hasMigObjs = schemeEntryColl.stream().filter(n -> n.getDynamicObject("migrateobject") != null).map(n -> n.getDynamicObject("migrateobject")).collect(Collectors.toList());
        List<Map<String, Object>> checkItemDataList = MigrateUserGuideProjectHelper.buildCheckItem(hasMigObjs, view);
        if (CollectionUtils.isEmpty(checkItemDataList)) {
            return;
        }
        for (int i = 0; i < checkItemDataList.size(); ++i) {
            DynamicObject row = guideCheckEntryColl.addNew();
            row.set("seq", (Object)(i + 1));
            Map<String, Object> checkItemData = checkItemDataList.get(i);
            view.setEnable(Boolean.FALSE, i, new String[]{"checkdetail_show"});
            boolean mustCheck = (Boolean)checkItemData.get("mustcheck");
            row.set("mustcheck", (Object)mustCheck);
            String must = mustCheck ? "must" : "notmust";
            row.set("mustcheck_show", (Object)must);
            List mulMigrateObjs = (List)checkItemData.get("migrateobjectcheck");
            DynamicObjectCollection rowObjs = row.getDynamicObjectCollection("mulmigrateobjectcheck");
            if (mulMigrateObjs != null) {
                for (DynamicObject obj : mulMigrateObjs) {
                    DynamicObject temp = new DynamicObject(rowObjs.getDynamicObjectType());
                    temp.set("fbasedataid_id", obj.getPkValue());
                    rowObjs.add((Object)temp);
                }
            }
            row.set("checkitem", checkItemData.get("checkitem"));
            row.set("checkstatus", (Object)ADD_NODE);
        }
    }

    public static Set<Object> buildParamEntryByScheme(IFormView view, DynamicObjectCollection guideCheckEntryColl, DynamicObjectCollection schemeEntryColl, Map<Long, Map<String, Object>> checkParamFields) {
        List<DynamicObject> hasMigObjs = schemeEntryColl.stream().filter(n -> n.getDynamicObject("migrateobject") != null).map(n -> n.getDynamicObject("migrateobject")).collect(Collectors.toList());
        List<Map<String, Object>> checkItemDataList = MigrateUserGuideProjectHelper.buildCheckItem(hasMigObjs, view);
        if (CollectionUtils.isEmpty(checkItemDataList)) {
            return Collections.emptySet();
        }
        String guideFormId = view.getModel().getDataEntityType().getName();
        Map<String, String> autoFields = MigrateUserGuideProjectHelper.autoFields(guideFormId, MigrateUserGuideProjectHelper.getProjectId(view));
        HashSet<Object> useFields = new HashSet<Object>(16);
        int seq = 1;
        for (int i = 0; i < checkItemDataList.size(); ++i) {
            Map<String, Object> checkItemData = checkItemDataList.get(i);
            DynamicObject checkItem = (DynamicObject)checkItemData.get("checkitem");
            DynamicObjectCollection paramEntry = checkItem.getDynamicObjectCollection("paramentry");
            if (CollectionUtils.isEmpty((Collection)paramEntry)) continue;
            DynamicObject row = guideCheckEntryColl.addNew();
            row.set("seq", (Object)seq);
            row.set("checkitemvar", (Object)checkItem);
            List mulMigrateObjs = (List)checkItemData.get("migrateobjectcheck");
            DynamicObjectCollection rowObjs = row.getDynamicObjectCollection("mulmigrateobjectvar");
            if (mulMigrateObjs != null) {
                for (DynamicObject obj : mulMigrateObjs) {
                    DynamicObject temp = new DynamicObject(rowObjs.getDynamicObjectType());
                    temp.set("fbasedataid_id", obj.getPkValue());
                    rowObjs.add((Object)temp);
                }
            }
            row.set("checkstatusvar", (Object)ADD_NODE);
            HashMap<String, String> map = new HashMap<String, String>(16);
            HashMap<String, String> fieldMessages = new HashMap<String, String>(16);
            for (DynamicObject entry : paramEntry) {
                String key = entry.getString("varsign.number");
                String name = entry.getString("varsign.name");
                String defaultValue = entry.getString("defaultvalue");
                map.put("imscdmw_" + key, defaultValue);
                fieldMessages.put(key, name);
                useFields.add("imscdmw_" + key);
            }
            checkParamFields.put((Long)checkItem.getPkValue(), fieldMessages);
            for (String field : autoFields.keySet()) {
                if (map.containsKey(field)) {
                    Object defaultValue = map.get(field);
                    row.set(field, defaultValue);
                    continue;
                }
                row.set(field, (Object)"-");
            }
            ++seq;
        }
        return useFields;
    }

    public static void buildCheckEntryByProject(IFormView view, DynamicObjectCollection entryEntity, DynamicObjectCollection projectCheckEntryColl, DynamicObject project) {
        DynamicObjectCollection scopeEntryEntity = project.getDynamicObjectCollection("treeentryentity");
        List hasMigObjIdList = scopeEntryEntity.stream().filter(n -> n.getDynamicObject("migrateobject") != null).map(n -> n.getDynamicObject("migrateobject").getLong("id")).collect(Collectors.toList());
        for (int i = 0; i < projectCheckEntryColl.size(); ++i) {
            DynamicObject entry = (DynamicObject)projectCheckEntryColl.get(i);
            DynamicObject row = entryEntity.addNew();
            row.set("id", entry.getPkValue());
            row.set("seq", (Object)(i + 1));
            DynamicObject checkItem = entry.getDynamicObject("checkitem");
            row.set("checkitem", (Object)checkItem);
            if (checkItem != null) {
                boolean mustCheck = checkItem.getBoolean("isrequired");
                row.set("repairids", entry.get("repairids"));
                row.set("mustcheck", (Object)mustCheck);
                String must = mustCheck ? "must" : "notmust";
                row.set("mustcheck_show", (Object)must);
                DynamicObjectCollection mulCheckObj = checkItem.getDynamicObjectCollection("mulmigrationobject");
                DynamicObjectCollection checkMigrateObj = row.getDynamicObjectCollection("mulmigrateobjectcheck");
                if (mulCheckObj == null || mulCheckObj.isEmpty()) {
                    DynamicObject obj = checkItem.getDynamicObject("migrationobject");
                    Object objId = obj != null ? obj.getPkValue() : Long.valueOf(0L);
                    DynamicObject tempSchemes = new DynamicObject(checkMigrateObj.getDynamicObjectType());
                    tempSchemes.set("fbasedataid_id", objId);
                    tempSchemes.set("fbasedataid", (Object)obj);
                    checkMigrateObj.add((Object)tempSchemes);
                } else {
                    for (DynamicObject mulCheck : mulCheckObj) {
                        DynamicObject checkObj = mulCheck.getDynamicObject("fbasedataid");
                        if (checkObj == null || !hasMigObjIdList.contains(checkObj.getLong("id"))) continue;
                        DynamicObject tempSchemes = new DynamicObject(checkMigrateObj.getDynamicObjectType());
                        tempSchemes.set("fbasedataid_id", checkObj.getPkValue());
                        tempSchemes.set("fbasedataid", (Object)checkObj);
                        checkMigrateObj.add((Object)tempSchemes);
                    }
                }
                String checkStatus = entry.getString("checkstatus");
                if (checkStatus.equals(ADD_PARENT)) {
                    MigrateUserGuideProjectHelper.buildRepairillust(checkItem, entry, row);
                    boolean supportOneClick = row.getBoolean("issupportrepair");
                    if (supportOneClick) {
                        row.set("repaircolumn_show", (Object)ResManager.loadKDString((String)"\u4e00\u952e\u4fee\u590d", (String)"MigrateUserGuideProjectHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                        row.set("repaircolumn", (Object)"oneKeyRepair");
                    } else {
                        String repairPage = (String)row.get("repairpage");
                        String repairType = (String)row.get("checkrepairtype");
                        if (ADD_NONE.equals(repairType) || ADD_NODE.equals(repairType) && StringUtil.isNotEmpty(repairPage)) {
                            row.set("repaircolumn_show", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u4fee\u590d", (String)"MigrateUserGuideProjectHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                            row.set("repaircolumn", (Object)"handleRepair");
                        }
                    }
                }
            }
            String repairStatus = (String)entry.get("repairstatus");
            row.set("repairstatus", (Object)repairStatus);
            if (!repairStatus.isEmpty()) {
                row.set("repairlog_show", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"MigrateUserGuideProjectHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
            row.set("checkstatus", entry.get("checkstatus"));
            row.set("checkdetail", entry.get("checkdetail"));
            row.set("checkdetail_show", entry.get("checkdetail_tag"));
            view.setEnable(Boolean.valueOf(!StringUtil.isEmpty(entry.get("checkdetail_tag"))), i, new String[]{"checkdetail_show"});
            row.set("checkdetail_tag", entry.get("checkdetail_tag"));
        }
    }

    public static void buildRepairillust(DynamicObject checkItem, DynamicObject entry, DynamicObject row) {
        String community;
        DynamicObjectCollection itemEntryEntity = checkItem.getDynamicObjectCollection("entryentity");
        DynamicObject rightEntry = entry;
        if (CollectionUtils.isNotEmpty((Collection)itemEntryEntity) && StringUtil.isEmpty(entry.getString("checkrepairtype"))) {
            Object entryMark;
            Map<String, Object> paramMap;
            rightEntry = (DynamicObject)itemEntryEntity.get(0);
            String entyrMarkStr = "";
            CheckItemLog checkItemLog = (CheckItemLog)JSON.parseObject((String)entry.getString("checkresultresponse_tag"), CheckItemLog.class);
            if (!(CommonUtils.isNull(checkItemLog) || CommonUtils.isNull(paramMap = checkItemLog.getParamMap()) || CommonUtils.isNull(entryMark = paramMap.get("checkEntryMark")))) {
                entyrMarkStr = entryMark.toString();
            }
            for (DynamicObject itemEntry : itemEntryEntity) {
                boolean isIdMatch = true;
                try {
                    isIdMatch = entyrMarkStr.equals(itemEntry.getString("rowindex"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                boolean isDefaultRepair = itemEntry.getBoolean("isdefaultrepair");
                if (isDefaultRepair) {
                    rightEntry = itemEntry;
                    break;
                }
                if (!isIdMatch) continue;
                rightEntry = itemEntry;
            }
        }
        String communityShow = StringUtils.isNotEmpty((CharSequence)(community = rightEntry.getString("community"))) ? ResManager.loadKDString((String)"\u67e5\u770b", (String)"MigrateUserGuideProjectHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]) : "";
        row.set("repairids", rightEntry.getPkValue());
        row.set("community", (Object)community);
        row.set("community_show", (Object)communityShow);
        row.set("repairpage", (Object)rightEntry.getString("repairpage"));
        row.set("issupportrepair", (Object)rightEntry.getString("issupportrepair"));
        row.set("checkrepairtype", (Object)rightEntry.getString("checkrepairtype"));
        row.set("repairillust", (Object)rightEntry.getString("repairillust"));
    }

    public static Set<Object> buildParamEntryByProject(DynamicObjectCollection entryEntity, DynamicObjectCollection projectCheckEntryColl, DynamicObject project, Map<Long, Map<String, Object>> checkParamFields) {
        DynamicObjectCollection scopeEntryEntity = project.getDynamicObjectCollection("treeentryentity");
        List hasMigObjIdList = scopeEntryEntity.stream().filter(n -> n.getDynamicObject("migrateobject") != null).map(n -> n.getDynamicObject("migrateobject").getLong("id")).collect(Collectors.toList());
        HashSet<Object> useFields = new HashSet<Object>(16);
        for (int i = 0; i < projectCheckEntryColl.size(); ++i) {
            DynamicObject entry = (DynamicObject)projectCheckEntryColl.get(i);
            DynamicObject row = entryEntity.addNew();
            row.set("id", entry.getPkValue());
            row.set("seq", (Object)(i + 1));
            DynamicObject checkItem = entry.getDynamicObject("checkitemvar");
            row.set("checkitemvar", (Object)checkItem);
            if (checkItem == null) continue;
            DynamicObjectCollection mulCheckObj = checkItem.getDynamicObjectCollection("mulmigrationobject");
            DynamicObjectCollection checkMigrateObj = row.getDynamicObjectCollection("mulmigrateobjectvar");
            for (DynamicObject mulCheck : mulCheckObj) {
                DynamicObject checkObj = mulCheck.getDynamicObject("fbasedataid");
                if (checkObj == null || !hasMigObjIdList.contains(checkObj.getLong("id"))) continue;
                DynamicObject tempSchemes = new DynamicObject(checkMigrateObj.getDynamicObjectType());
                tempSchemes.set("fbasedataid_id", checkObj.getPkValue());
                tempSchemes.set("fbasedataid", (Object)checkObj);
                checkMigrateObj.add((Object)tempSchemes);
            }
            row.set("checkstatusvar", entry.get("checkstatusvar"));
            String paramTag = entry.getString("autoparam_tag");
            if (!StringUtil.isNotEmpty(paramTag)) continue;
            Map paramMap = (Map)JSONObject.parseObject((String)paramTag, Map.class);
            for (Map.Entry map : paramMap.entrySet()) {
                HashMap fieldMessages = new HashMap(16);
                if ("autoFieldMessage".equals(map.getKey())) {
                    Map fieldMaps = (Map)map.getValue();
                    for (Map.Entry fieldMap : fieldMaps.entrySet()) {
                        String substring = ((String)fieldMap.getKey()).substring("imscdmw_".length());
                        fieldMessages.put(substring, fieldMap.getValue());
                    }
                    checkParamFields.put((Long)checkItem.getPkValue(), fieldMessages);
                    continue;
                }
                row.set((String)map.getKey(), map.getValue());
                useFields.add(map.getKey());
            }
        }
        return useFields;
    }

    public static List<Map<String, Object>> buildCheckItem(List<DynamicObject> hasMigObjs, IFormView view) {
        DynamicObject[] load;
        if (CollectionUtils.isEmpty(hasMigObjs)) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(16);
        List<Object> migObjIdList = hasMigObjs.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter qfilter = QFilterUtils.getEnableQFilter().and("mulmigrationobject.fbasedataid.id", "in", migObjIdList).or(QFilter.isNull((String)"mulmigrationobject.fbasedataid.id")).and("enable", "=", (Object)"1");
        String selectors = "id,number,migrationobject,mulmigrationobject,isrequired,plugin,issupportall,issupportinit,entryentity,entryentity.isdefaultrepair,entryentity.checkrepairtype,entryentity.repairillust,entryentity.issupportrepair,entryentity.repairmethod,entryentity.repairplugin,entryentity.repairmicro,entryentity.repairpage,entryentity.community,paramentry.varsign,paramentry.defaultvalue";
        DynamicObject[] tempLoad = BusinessDataServiceHelper.load((String)MigrateUserGuideProjectHelper.getCheckItemFormIdByUserGuide(view), (String)selectors, (QFilter[])qfilter.toArray(), (String)"id");
        for (DynamicObject check : load = MigrateUserGuideProjectHelper.sortCheckItem(view, tempLoad, migObjIdList)) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            DynamicObjectCollection mulMigrateObj = check.getDynamicObjectCollection("mulmigrationobject");
            if (mulMigrateObj == null || mulMigrateObj.isEmpty()) {
                DynamicObject migObj = check.getDynamicObject("migrationobject");
                if (migObj != null) {
                    map.put("migrateobjectcheck", Collections.singletonList(migObj));
                }
            } else {
                ArrayList<DynamicObject> migObjList = new ArrayList<DynamicObject>(mulMigrateObj.size());
                for (int i = 0; i < mulMigrateObj.size(); ++i) {
                    DynamicObject migObj = ((DynamicObject)mulMigrateObj.get(i)).getDynamicObject("fbasedataid");
                    if (!migObjIdList.contains(migObj.getPkValue())) continue;
                    migObjList.add(migObj);
                }
                map.put("migrateobjectcheck", migObjList);
            }
            map.put("checkitem", check);
            map.put("mustcheck", check.get("isrequired"));
            list.add(map);
        }
        return list;
    }

    private static DynamicObject[] sortCheckItem(IFormView view, DynamicObject[] checkItemArray, List<Object> migObjIdList) {
        HashMap objectMapMap;
        LinkedHashMap<DynamicObject, Integer> linkedMap = new LinkedHashMap<DynamicObject, Integer>(checkItemArray.length);
        String objectMapMapStr = view.getPageCache().get("changeDataMark");
        Map map = objectMapMap = CommonUtils.isNull(objectMapMapStr) || "null".equals(objectMapMapStr) ? new HashMap(8) : (Map)JSON.parseObject((String)objectMapMapStr, Map.class);
        if (CommonUtils.isNull(objectMapMap)) {
            return checkItemArray;
        }
        for (DynamicObject checkItem : checkItemArray) {
            DynamicObjectCollection mulObject = checkItem.getDynamicObjectCollection("mulmigrationobject");
            int defaultSort = 0;
            if (mulObject != null) {
                for (DynamicObject obj : mulObject) {
                    Long tempId = obj.getLong("fbasedataid_id");
                    if (!migObjIdList.contains(tempId)) continue;
                    DynamicObject migObj = obj.getDynamicObject("fbasedataid");
                    Map tempMap = (Map)objectMapMap.get(migObj.getPkValue());
                    String tempNum = (String)tempMap.get("sortnumexec");
                    defaultSort = Integer.parseInt(tempNum);
                    break;
                }
            }
            linkedMap.put(checkItem, defaultSort);
        }
        ArrayList entryList = new ArrayList(linkedMap.entrySet());
        entryList.sort(Map.Entry.comparingByValue());
        DynamicObject[] sortedArray = new DynamicObject[checkItemArray.length];
        for (int i = 0; i < entryList.size(); ++i) {
            sortedArray[i] = (DynamicObject)((Map.Entry)entryList.get(i)).getKey();
        }
        return sortedArray;
    }

    public static void setMigExecEntry(IFormView view, DynamicObjectCollection entryColl, Map<Long, Object> idMappingMap, String type) {
        IDataModel model = view.getModel();
        if (CommonUtils.isNull(entryColl)) {
            return;
        }
        model.deleteEntryData("migtreeentryentity");
        DynamicObjectCollection guideExeEntryColl = model.getEntryEntity("migtreeentryentity");
        switch (type) {
            case "dmw_migratescheme": {
                MigrateUserGuideProjectHelper.setMigExecEntryByScheme(view, entryColl, guideExeEntryColl, idMappingMap);
                break;
            }
            case "dmw_migrateproject": {
                MigrateUserGuideProjectHelper.setMigExecEntryByProject(entryColl, guideExeEntryColl);
                break;
            }
        }
        view.getModel().updateEntryCache(guideExeEntryColl);
        view.updateView("migtreeentryentity");
    }

    private static void setMigExecEntryByScheme(IFormView view, DynamicObjectCollection schemeEntryColl, DynamicObjectCollection guideExeEntryColl, Map<Long, Object> idMappingMap) {
        IDataModel model = view.getModel();
        String guideFormId = view.getModel().getDataEntityType().getName();
        String tempName = ResManager.loadKDString((String)"\u5931\u6548\u6570\u636e\u542f\u7528", (String)"MigrateUserGuideRelationHelper_7", (String)"imsc-dmw-platform", (Object[])new Object[0]);
        Map<Long, DynamicObject> migObjMap = MigrateUserGuideProjectHelper.getEntryMigObjMap(schemeEntryColl, MigrateUserGuideProjectHelper.getMigObjFormIdByUserGuide(guideFormId), "migrateobject_id");
        int i = 0;
        int j = 1;
        while (i < schemeEntryColl.size()) {
            DynamicObject entry = (DynamicObject)schemeEntryColl.get(i);
            DynamicObject migObj = entry.getDynamicObject("migrateobject");
            if (migObj != null) {
                DynamicObject migObjOtherAttr = migObjMap.get(migObj.getLong("id"));
                DynamicObject row = guideExeEntryColl.addNew();
                if (Boolean.parseBoolean(MigrateUserGuideRelationHelper.getModifyRecord(view, migObj, "enableinvaliddata")) && "1".equals(migObj.getString("executetype"))) {
                    DynamicObject enableRow = guideExeEntryColl.addNew();
                    enableRow.set("id", (Object)DB.genGlobalLongId());
                    enableRow.set("seq", (Object)j++);
                    enableRow.set("parentmigobj", (Object)migObj);
                    enableRow.set("migrateobjname", (Object)(migObj.get("name") + tempName));
                    enableRow.set("migratestatus", (Object)ADD_NODE);
                    enableRow.set("schemetype", (Object)"isc_service_flow");
                    enableRow.set("invalidatastatus", (Object)"1");
                    enableRow.set(String.join((CharSequence)"_", "startscheme", "id"), (Object)DmwMigrateuserguide.ENABLE_SCHEME_ID);
                    enableRow.set("migrateexecutetype", (Object)"1");
                }
                row.set("id", idMappingMap.get(entry.getLong("id")));
                row.set("seq", (Object)j);
                row.set("migrateobjectexec", (Object)migObj);
                row.set("migrateobjname", (Object)migObj.getString("name"));
                row.set("migratestatus", (Object)ADD_NODE);
                String migrateModel = (String)model.getValue("migrationmodel");
                if (ADD_NONE.equals(migrateModel)) {
                    row.set("schemetype", (Object)migObj.getString("allintegrattype"));
                    row.set(String.join((CharSequence)"_", "startscheme", "id"), migObj.get("allschemeid"));
                } else {
                    row.set("schemetype", (Object)migObj.getString("initintegrattype"));
                    row.set(String.join((CharSequence)"_", "startscheme", "id"), migObj.get("initschemeid"));
                }
                String executeType = migObj.getString("executetype");
                row.set("migrateexecutetype", (Object)executeType);
                if ("2".equals(executeType)) {
                    row.set("migratedeatil", migObjOtherAttr.get("illustrate"));
                }
                row.set("migratemanualpage", migObj.get("manualpage"));
                row.set("migratemanualpageparam", migObj.get("manualpageparam"));
                row.set("migratecommunity", migObj.get("community"));
                row.set("supportperiodmigexe", migObjOtherAttr.get("supportperiodmig"));
                row.set("supportorgmigexe", migObjOtherAttr.get("supportorgmig"));
            }
            ++i;
            ++j;
        }
    }

    private static void setMigExecEntryByProject(DynamicObjectCollection projectEntryColl, DynamicObjectCollection guideExeEntryColl) {
        for (int i = 0; i < projectEntryColl.size(); ++i) {
            DynamicObject entry = (DynamicObject)projectEntryColl.get(i);
            DynamicObject migObj = entry.getDynamicObject("migrateobject");
            DynamicObject row = guideExeEntryColl.addNew();
            row.set("id", entry.getPkValue());
            row.set("seq", (Object)(i + 1));
            row.set("migrateobjectexec", (Object)migObj);
            String migObjName = entry.getString("migrateobjectname");
            if (migObj != null && StringUtil.isEmpty(migObjName)) {
                migObjName = migObj.getString("name");
            }
            row.set("parentmigobj", entry.get("parentmigobj"));
            row.set("migrateobjname", (Object)migObjName);
            row.set("schemetype", entry.get("integrattype"));
            row.set("startscheme", entry.get("startscheme"));
            row.set("migratestatus", entry.get("migratestatus"));
            row.set("migratelog", entry.get("migratelog"));
            row.set("iscexcutionid", entry.get("iscexcutionid"));
            String executeType = entry.getString("executetype");
            row.set("migrateexecutetype", (Object)executeType);
            if ("2".equals(executeType)) {
                row.set("migratedeatil", (Object)DynamicObjectUtils.getString((DynamicObject)migObj, (String)"illustrate"));
            }
            row.set("invalidatastatus", entry.get("invalidatastatus"));
            row.set("migratemanualpage", entry.get("manualpage"));
            row.set("migratemanualpageparam", entry.get("manualpageparam"));
            row.set("migratecommunity", entry.get("migratecommunity"));
            row.set("isignoreexistdata", entry.get("isignoreexistdata"));
            row.set("supportperiodmigexe", entry.get("supportperiodmig"));
            row.set("supportorgmigexe", entry.get("supportorgmig"));
        }
    }

    private static void setMigrateExecData(IFormView view, DynamicObject projectDynObj) {
        DynamicObjectCollection projectEntryColl = projectDynObj.getDynamicObjectCollection("treeentryentity");
        if (!projectEntryColl.isEmpty()) {
            MigrateUserGuideProjectHelper.setMigExecEntry(view, projectEntryColl, null, "dmw_migrateproject");
        }
        MigrateUserGuideProjectHelper.setEntryMigrateDetail(projectEntryColl, view.getModel());
        view.updateView("migtreeentryentity");
    }

    private static void setEntryMigrateDetail(DynamicObjectCollection projectEntryColl, IDataModel model) {
        ArrayList<Object> excutionIds = new ArrayList<Object>();
        for (DynamicObject e : projectEntryColl) {
            String idStr;
            if (!"isc_data_copy_trigger".equals(e.get("integrattype")) || !StringUtils.isNotBlank((CharSequence)(idStr = (String)e.get("iscexcutionid")))) continue;
            Long parseLong = Long.parseLong(idStr);
            excutionIds.add(parseLong);
        }
        QFilter filter = new QFilter("id", "in", excutionIds);
        DynamicObjectCollection excutions = QueryServiceHelper.query((String)"isc_data_copy_execution", (String)"id, total_count, success_count, failed_count, ignored_count", (QFilter[])filter.toArray());
        HashMap<String, DynamicObject> excutionMap = new HashMap<String, DynamicObject>(excutions.size());
        for (DynamicObject excution : excutions) {
            excutionMap.put(excution.getString("id"), excution);
        }
        for (int i = 0; i < projectEntryColl.size(); ++i) {
            DynamicObject entry = (DynamicObject)projectEntryColl.get(i);
            String excutionId = (String)entry.get("iscexcutionid");
            String executeType = entry.getString("executetype");
            if ("1".equals(executeType)) {
                if (!StringUtils.isNotBlank((CharSequence)excutionId)) continue;
                DynamicObject excution = (DynamicObject)excutionMap.get(excutionId);
                String dataExecLog = "";
                if (excution != null) {
                    int total = excution.getInt("total_count");
                    int success = excution.getInt("success_count");
                    int failed = excution.getInt("failed_count");
                    int ignored = excution.getInt("ignored_count");
                    dataExecLog = String.format(ResManager.loadKDString((String)"\u5171%1$d\u884c\uff0c\u6210\u529f%2$d\u884c\uff0c\u5931\u8d25%3$d\u884c\uff0c\u5ffd\u7565%4$d\u884c\u3002", (String)"MigrateUserGuideProjectHelper_4", (String)"imsc-dmw-platform", (Object[])new Object[0]), total, success, failed, ignored);
                }
                model.setValue("migratedeatil", (Object)dataExecLog, i);
                continue;
            }
            model.setValue("migratedeatil", (Object)DynamicObjectUtils.getString((DynamicObject)entry.getDynamicObject("migrateobject"), (String)"illustrate"), i);
        }
    }

    public static void updateMigrateExecData(IFormView view, DynamicObject project) {
        DynamicObjectCollection projectEntryColl = project.getDynamicObjectCollection("treeentryentity");
        if (!projectEntryColl.isEmpty()) {
            HashMap<Long, DynamicObject> entryMap = new HashMap<Long, DynamicObject>(16);
            for (DynamicObject entry : projectEntryColl) {
                Object pkValue = entry.getPkValue();
                entryMap.put((Long)pkValue, entry);
            }
            IDataModel model = view.getModel();
            DynamicObjectCollection guideExeEntryColl = model.getEntryEntity("migtreeentryentity");
            MigrateUserGuideProjectHelper.setEntryMigrateDetail(projectEntryColl, model);
            for (int i = 0; i < guideExeEntryColl.size(); ++i) {
                DynamicObject entryObj = (DynamicObject)guideExeEntryColl.get(i);
                String value = entryObj.getString("migratestatus");
                Object pkValue = entryObj.getPkValue();
                if (ADD_PARENT.equals(value)) continue;
                DynamicObject projectEntry = (DynamicObject)entryMap.get((Long)pkValue);
                model.setValue("migratelog", projectEntry.get("migratelog"), i);
                model.setValue("iscexcutionid", projectEntry.get("iscexcutionid"), i);
                model.setValue("migratestatus", projectEntry.get("migratestatus"), i);
                view.updateView("migratelog", i);
                view.updateView("iscexcutionid", i);
                view.updateView("migratestatus", i);
                view.updateView("migratedeatil", i);
            }
        }
    }

    public static void setMigrateCheckData(IFormView view, DynamicObject project) {
        IDataModel model = view.getModel();
        model.setValue("checktaskid", project.get("checktaskid"));
        DynamicObjectCollection projectCheckEntryColl = project.getDynamicObjectCollection("checktreeentryentity");
        MigrateUserGuideProjectHelper.setMigCheckEntry(view, projectCheckEntryColl, "dmw_migrateproject", project);
        DynamicObjectCollection projectParamEntryColl = project.getDynamicObjectCollection("checkparamentry");
        MigrateUserGuideProjectHelper.setMigCheckParamEntry(view, projectParamEntryColl, "dmw_migrateproject", project);
    }

    public static void setCommnuity(IFormView view, int row, String community) {
        view.getModel().setValue("community", (Object)community, row);
        if (!community.isEmpty()) {
            view.getModel().setValue("community_show", (Object)ResManager.loadKDString((String)"\u67e5\u770b", (String)"MigrateUserGuideProjectHelper_1", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        } else {
            view.getModel().setValue("community_show", (Object)"");
        }
    }

    public static void setRepairColumn(IFormView view, int row, boolean supportOneClick, String checkStatus, String repairPage, String repairType) {
        IDataModel model = view.getModel();
        if (supportOneClick) {
            if (checkStatus.equals(ADD_PARENT)) {
                model.setValue("repaircolumn_show", (Object)ResManager.loadKDString((String)"\u4e00\u952e\u4fee\u590d", (String)"MigrateUserGuideProjectHelper_2", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                model.setValue("repaircolumn", (Object)"oneKeyRepair");
            }
            model.setValue("issupportrepair", (Object)Boolean.TRUE);
        } else if (ADD_NONE.equalsIgnoreCase(repairType) || ADD_NODE.equalsIgnoreCase(repairType) && StringUtils.isNotEmpty((CharSequence)repairPage)) {
            if (checkStatus.equals(ADD_PARENT)) {
                model.setValue("repaircolumn_show", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u4fee\u590d", (String)"MigrateUserGuideProjectHelper_3", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                model.setValue("repaircolumn", (Object)"handleRepair");
            }
            model.setValue("repairpage", (Object)repairPage);
            model.setValue("issupportrepair", (Object)Boolean.FALSE);
        } else {
            model.setValue("repaircolumn_show", (Object)"");
            model.setValue("repaircolumn", (Object)"");
            model.setValue("issupportrepair", (Object)Boolean.FALSE);
        }
    }

    private static void setMigrateRangeData(IFormView view, DynamicObject migrationProject) {
        IDataModel model = view.getModel();
        model.setValue("begindate", migrationProject.get("begindate"));
        model.setValue("beginperiodyear", migrationProject.get("beginperiodyear"));
        model.setValue("beginperiodmonth", migrationProject.get("beginperiodmonth"));
        model.initValue("mulmigratescheme", migrationProject.get("mulmigratescheme"));
        DynamicObjectCollection scopeEntries = migrationProject.getDynamicObjectCollection("treeentryentity");
        List<Object> migObjIdList = MigrateUserGuideProjectHelper.getMigObjIdList(scopeEntries);
        MigrateUserGuideProjectHelper.buildScopeEntry(view, scopeEntries, migObjIdList, "dmw_migrateproject");
    }

    public static void setProjectStatus(IFormView view, String status) {
        Label checkStatusLabel = (Label)view.getControl("checkstatuslab");
        Label execStatusLabel = (Label)view.getControl("execstatuslab");
        view.setVisible(Boolean.FALSE, new String[]{"startcheck", "retrycheck", "interruptcheck", "checkbackground", "startmigrate", "interruptmigrate", "retrymigrate", "migratebackground", "gocheckparam", "gocheck", "saveparamvalue"});
        view.setEnable(Boolean.FALSE, new String[]{"checkbackground", "migratebackground"});
        DynamicObjectCollection check = view.getModel().getDataEntity(true).getDynamicObjectCollection("checkparamentry");
        Tab tab = (Tab)view.getControl("guidecontent");
        Tab checkTab = (Tab)view.getControl("tabap");
        String nowTab = tab.getCurrentTab();
        String nowCheckTab = checkTab.getCurrentTab();
        switch (status) {
            case "A": {
                FormUtil.setLabelStyle(view, "statuslabel", ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"MigrateUserGuideProjectHelper_5", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#B2B2B2", "white");
                checkStatusLabel.setText(ResManager.loadKDString((String)"\u672a\u5f00\u59cb", (String)"MigrateUserGuideProjectHelper_5", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                if (!nowTab.equals("tabpageap3")) break;
                if ("tabpageap5".equals(nowCheckTab)) {
                    view.setVisible(Boolean.TRUE, new String[]{"startcheck", "checkbackground"});
                    if (!CollectionUtils.isNotEmpty((Collection)check)) break;
                    view.setVisible(Boolean.TRUE, new String[]{"gocheckparam"});
                    break;
                }
                view.setVisible(Boolean.TRUE, new String[]{"gocheck", "saveparamvalue"});
                break;
            }
            case "B": {
                if (nowTab.equals("tabpageap3")) {
                    if ("tabpageap5".equals(nowCheckTab)) {
                        view.setVisible(Boolean.TRUE, new String[]{"checkbackground", "interruptcheck"});
                        view.setEnable(Boolean.TRUE, new String[]{"checkbackground"});
                        if (CollectionUtils.isNotEmpty((Collection)check)) {
                            view.setVisible(Boolean.TRUE, new String[]{"gocheckparam"});
                        }
                    } else {
                        view.setVisible(Boolean.TRUE, new String[]{"gocheck", "saveparamvalue"});
                    }
                }
                FormUtil.setLabelStyle(view, "statuslabel", ResManager.loadKDString((String)"\u68c0\u67e5\u4e2d", (String)"MigrateUserGuideProjectHelper_6", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#276FF5", "white");
                checkStatusLabel.setText(ResManager.loadKDString((String)"\u68c0\u67e5\u4e2d", (String)"MigrateUserGuideProjectHelper_6", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "C": {
                if (nowTab.equals("tabpageap3")) {
                    if ("tabpageap5".equals(nowCheckTab)) {
                        view.setVisible(Boolean.TRUE, new String[]{"retrycheck", "checkbackground"});
                        if (CollectionUtils.isNotEmpty((Collection)check)) {
                            view.setVisible(Boolean.TRUE, new String[]{"gocheckparam"});
                        }
                    } else {
                        view.setVisible(Boolean.TRUE, new String[]{"gocheck", "saveparamvalue"});
                    }
                }
                FormUtil.setLabelStyle(view, "statuslabel", ResManager.loadKDString((String)"\u68c0\u67e5\u4e0d\u901a\u8fc7", (String)"MigrateUserGuideProjectHelper_7", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#FB2323", "white");
                checkStatusLabel.setText(ResManager.loadKDString((String)"\u68c0\u67e5\u4e0d\u901a\u8fc7", (String)"MigrateUserGuideProjectHelper_7", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "D": {
                if (nowTab.equals("tabpageap3")) {
                    if ("tabpageap5".equals(nowCheckTab)) {
                        view.setVisible(Boolean.TRUE, new String[]{"startcheck", "checkbackground"});
                        if (CollectionUtils.isNotEmpty((Collection)check)) {
                            view.setVisible(Boolean.TRUE, new String[]{"gocheckparam"});
                        }
                        view.setEnable(Boolean.FALSE, new String[]{"startcheck"});
                    } else {
                        view.setVisible(Boolean.TRUE, new String[]{"gocheck", "saveparamvalue"});
                    }
                }
                FormUtil.setLabelStyle(view, "statuslabel", ResManager.loadKDString((String)"\u68c0\u67e5\u901a\u8fc7", (String)"MigrateUserGuideProjectHelper_8", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#1BA854", "white");
                checkStatusLabel.setText(ResManager.loadKDString((String)"\u68c0\u67e5\u901a\u8fc7", (String)"MigrateUserGuideProjectHelper_8", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "E": {
                if (nowTab.equals("tabpageap4")) {
                    view.setEnable(Boolean.TRUE, new String[]{"migratebackground"});
                    view.setVisible(Boolean.TRUE, new String[]{"interruptmigrate", "migratebackground"});
                    boolean isExist = MigrateUserGuideProjectHelper.verifyManualEntryMigrateStatus(view);
                    if (isExist) {
                        view.setEnable(Boolean.FALSE, new String[]{"migratebackground"});
                        view.setVisible(Boolean.FALSE, new String[]{"interruptmigrate"});
                        view.setEnable(Boolean.TRUE, new String[]{"retrymigrate"});
                        view.setVisible(Boolean.TRUE, new String[]{"retrymigrate"});
                    }
                }
                FormUtil.setLabelStyle(view, "statuslabel", ResManager.loadKDString((String)"\u8fc1\u79fb\u4e2d", (String)"MigrateUserGuideProjectHelper_9", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#276FF5", "white");
                execStatusLabel.setText(ResManager.loadKDString((String)"\u8fc1\u79fb\u4e2d", (String)"MigrateUserGuideProjectHelper_9", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "F": {
                if (nowTab.equals("tabpageap4")) {
                    view.setVisible(Boolean.TRUE, new String[]{"retrymigrate", "migratebackground"});
                }
                FormUtil.setLabelStyle(view, "statuslabel", ResManager.loadKDString((String)"\u8fc1\u79fb\u5931\u8d25", (String)"MigrateUserGuideProjectHelper_10", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#FB2323", "white");
                execStatusLabel.setText(ResManager.loadKDString((String)"\u8fc1\u79fb\u5931\u8d25", (String)"MigrateUserGuideProjectHelper_10", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "G": {
                if (nowTab.equals("tabpageap4")) {
                    view.setEnable(Boolean.FALSE, new String[]{"startmigrate"});
                    view.setVisible(Boolean.TRUE, new String[]{"startmigrate", "migratebackground"});
                }
                FormUtil.setLabelStyle(view, "statuslabel", ResManager.loadKDString((String)"\u8fc1\u79fb\u5b8c\u6210", (String)"MigrateUserGuideProjectHelper_11", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#1BA854", "white");
                execStatusLabel.setText(ResManager.loadKDString((String)"\u8fc1\u79fb\u5b8c\u6210", (String)"MigrateUserGuideProjectHelper_11", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
            case "H": {
                if (nowTab.equals("tabpageap4")) {
                    view.setVisible(Boolean.TRUE, new String[]{"retrymigrate", "migratebackground"});
                }
                FormUtil.setLabelStyle(view, "statuslabel", ResManager.loadKDString((String)"\u8fc1\u79fb\u90e8\u5206\u5b8c\u6210", (String)"MigrateUserGuideProjectHelper_12", (String)"imsc-dmw-platform", (Object[])new Object[0]), "#FF991C", "white");
                execStatusLabel.setText(ResManager.loadKDString((String)"\u8fc1\u79fb\u90e8\u5206\u5b8c\u6210", (String)"MigrateUserGuideProjectHelper_12", (String)"imsc-dmw-platform", (Object[])new Object[0]));
                break;
            }
        }
        MigrateUserGuideProjectHelper.checkItemParamPageDeal(view);
        view.getPageCache().put("projectstatus", status);
    }

    public static void checkItemParamPageDeal(IFormView view) {
        DynamicObjectCollection params = view.getModel().getDataEntity(true).getDynamicObjectCollection("checkparamentry");
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)params)) {
            String guideFormId = view.getModel().getDataEntityType().getName();
            Map<String, String> autoFields = MigrateUserGuideProjectHelper.autoFields(guideFormId, MigrateUserGuideProjectHelper.getProjectId(view));
            for (int i = 0; i < params.size(); ++i) {
                DynamicObject param = (DynamicObject)params.get(i);
                String checkStatus = param.getString("checkstatusvar");
                if (!"D".equals(checkStatus)) continue;
                Set<String> fields = autoFields.keySet();
                view.setEnable(Boolean.FALSE, i, fields.toArray(new String[0]));
            }
        }
    }

    public static boolean saveProject(IFormView view) {
        DynamicObject project;
        IDataModel model = view.getModel();
        String billFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(view);
        if (StringUtil.isEmpty(billFormId)) {
            return false;
        }
        if (MigrateUserGuideProjectHelper.isExistProject(view)) {
            Long pk = Long.valueOf(view.getPageCache().get("existProject"));
            project = BusinessDataServiceHelper.loadSingle((Object)pk, (String)billFormId);
        } else {
            project = BusinessDataServiceHelper.newDynamicObject((String)billFormId);
            long projectId = DB.genLongId((String)project.getDataEntityType().getAlias());
            project.set("id", (Object)projectId);
            String pageId = projectId + view.getFormShowParameter().getParentPageId();
            view.getFormShowParameter().setPageId(pageId);
            project.set("creator", (Object)RequestContext.get().getCurrUserId());
        }
        project.set("number", model.getValue("projectnumber"));
        project.set("name", model.getValue("projectname"));
        project.set("projectstatus", (Object)MigrateUserGuideProjectHelper.getProjectStatus(view));
        String migrateModel = (String)model.getValue("migrationmodel");
        project.set("migrationmodel", (Object)migrateModel);
        project.set("mulmigratescheme", model.getValue("mulmigratescheme"));
        project.set("dblink", model.getValue("dblink"));
        MulBasedataDynamicObjectCollection easOrges = (MulBasedataDynamicObjectCollection)model.getValue("easorgrangef7");
        if (Objects.nonNull(easOrges)) {
            StringBuilder easOrgIds = new StringBuilder();
            easOrges.forEach(l -> easOrgIds.append(l.get("fbasedataid_id")).append(','));
            int filterDescLimit = 1000;
            String limitString = easOrgIds.toString();
            if (easOrgIds.length() > filterDescLimit) {
                limitString = easOrgIds.substring(0, filterDescLimit);
            }
            project.set("easorgrange", (Object)limitString);
            project.set("easorgrange_tag", (Object)easOrgIds);
        }
        project.set("begindate", model.getValue("begindate"));
        project.set("beginperiodyear", model.getValue("beginperiodyear"));
        project.set("beginperiodmonth", model.getValue("beginperiodmonth"));
        project.set("confirmxhbackup", model.getValue("confirmxhbackup"));
        project.set("migrateillustrate", model.getValue("migrateillustrate"));
        project.set("advancedset", model.getValue("advancedset"));
        if (project.get("confirmpeople") == null) {
            project.set("confirmpeople", (Object)RequestContext.get().getCurrUserId());
            project.set("confirmdate", (Object)new Date());
        }
        DynamicObjectCollection migEntries = model.getEntryEntity("migtreeentryentity");
        DynamicObjectCollection scopeEntries = MigrateUserGuideProjectHelper.buildMigObjFromMulScheme(view, true);
        DynamicObjectCollection projectMigrateEntryColl = project.getDynamicObjectCollection("treeentryentity");
        projectMigrateEntryColl.clear();
        String migBotp = "migbotpini";
        String migDap = "migdapini";
        String migRecord = "migrecordini";
        if (ADD_NONE.equals(migrateModel)) {
            migBotp = "migbotpall";
            migDap = "migdapall";
            migRecord = "migrecordall";
        }
        String schemeObjMapStr = view.getPageCache().get("belongSchemeCache");
        Map schemeObjMap = (Map)JSON.parseObject((String)schemeObjMapStr, Map.class);
        int scopeIndex = 0;
        for (DynamicObject entry : migEntries) {
            DynamicObject parentMigObj;
            DynamicObject row = projectMigrateEntryColl.addNew();
            row.set("id", entry.getPkValue());
            row.set("seq", entry.get("seq"));
            DynamicObject execMigObj = (DynamicObject)entry.get("migrateobjectexec");
            row.set("migrateobject", (Object)execMigObj);
            row.set("migrateobjectname", entry.get("migrateobjname"));
            row.set("integrattype", entry.get("schemetype"));
            row.set("startscheme", entry.get("startscheme"));
            row.set("migratestatus", entry.get("migratestatus"));
            row.set("executetype", entry.get("migrateexecutetype"));
            row.set("invalidatastatus", entry.get("invalidatastatus"));
            if (execMigObj != null) {
                MulBasedataDynamicObjectCollection starvastObj = (MulBasedataDynamicObjectCollection)execMigObj.get("starvastobject");
                starvastObj.forEach(n -> n.set("pkid", null));
                row.set("sourceobject", (Object)starvastObj);
                DynamicObject scopeEntry = (DynamicObject)scopeEntries.get(scopeIndex++);
                DynamicObject migObj = scopeEntry.getDynamicObject("migrateobject");
                row.set("migbotp", (Object)Boolean.parseBoolean(MigrateUserGuideRelationHelper.getModifyRecord(view, migObj, migBotp)));
                row.set("migdap", (Object)Boolean.parseBoolean(MigrateUserGuideRelationHelper.getModifyRecord(view, migObj, migDap)));
                row.set("migrecord", (Object)Boolean.parseBoolean(MigrateUserGuideRelationHelper.getModifyRecord(view, migObj, migRecord)));
                row.set("disableinvaliddata", (Object)Boolean.parseBoolean(MigrateUserGuideRelationHelper.getModifyRecord(view, migObj, "disableinvaliddata")));
                row.set("enableinvaliddata", (Object)Boolean.parseBoolean(MigrateUserGuideRelationHelper.getModifyRecord(view, migObj, "enableinvaliddata")));
                row.set("sortnumdefault", scopeEntry.get("sortnumdefault"));
                row.set("sortnumexec", scopeEntry.get("sortnumexec"));
                row.set("supportorgmig", entry.get("supportorgmigexe"));
                row.set("supportperiodmig", entry.get("supportperiodmigexe"));
                DynamicObjectCollection belongSchemes = row.getDynamicObjectCollection("belongschemes");
                List schemeObjList = (List)schemeObjMap.get(migObj.getPkValue());
                for (Object belongSchemeId : schemeObjList) {
                    DynamicObject tempSchemes = new DynamicObject(belongSchemes.getDynamicObjectType());
                    tempSchemes.set("fbasedataid_id", belongSchemeId);
                    belongSchemes.add((Object)tempSchemes);
                }
                row.set("manualpage", execMigObj.get("manualpage"));
                row.set("manualpageparam", execMigObj.get("manualpageparam"));
                row.set("migratecommunity", execMigObj.get("community"));
            }
            if ((parentMigObj = (DynamicObject)entry.get("parentmigobj")) == null) continue;
            row.set("parentmigobj", (Object)parentMigObj);
        }
        DynamicObjectCollection checkTreeEntry = model.getEntryEntity("checktreeentryentity");
        DynamicObjectCollection checkEntrys = project.getDynamicObjectCollection("checktreeentryentity");
        checkEntrys.clear();
        for (DynamicObject entry : checkTreeEntry) {
            DynamicObject migrateEntry = checkEntrys.addNew();
            migrateEntry.set("seq", entry.get("seq"));
            migrateEntry.set("checkitem", entry.get("checkitem"));
            migrateEntry.set("repairids", entry.get("repairids"));
            migrateEntry.set("checkstatus", entry.get("checkstatus"));
            migrateEntry.set("checkdetail", entry.get("checkdetail"));
            migrateEntry.set("checkdetail_tag", entry.get("checkdetail_tag"));
            migrateEntry.set("checkrepairtype", entry.get("checkrepairtype"));
            migrateEntry.set("repairillust", entry.get("repairillust"));
            migrateEntry.set("community", entry.get("community"));
            migrateEntry.set("repairstatus", entry.get("repairstatus"));
            migrateEntry.set("issupportrepair", entry.get("issupportrepair"));
            migrateEntry.set("repairpage", entry.get("repairpage"));
        }
        MigrateUserGuideProjectHelper.setCheckParamEntry(view, model, project);
        OperateOption option = OperateOption.create();
        option.setVariableValue("importtag_of_datasource", String.valueOf(true));
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        OperationResult result = SaveServiceHelper.saveOperate((String)billFormId, (DynamicObject[])new DynamicObject[]{project}, (OperateOption)option);
        if (result.isSuccess()) {
            view.getPageCache().put("existProject", String.valueOf(project.getPkValue()));
            FormUtil.setLabValue(view, "projectnumlab", (String)model.getValue("projectnumber"));
            view.setVisible(Boolean.TRUE, new String[]{"flexapprojectname"});
            FormUtil.setLabValue(view, "projectnamelab", (String)model.getValue("projectname"));
            view.setVisible(Boolean.TRUE, new String[]{"projectinfoap"});
            view.getPageCache().remove("isupdatedata");
            view.showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u9879\u76ee\u6210\u529f\u3002", (String)"MigrateUserGuideProjectHelper_13", (String)"imsc-dmw-platform", (Object[])new Object[0]));
        } else {
            List allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
            StringBuilder builder = new StringBuilder();
            for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                builder.append(iOperateInfo.getMessage());
            }
            view.showErrorNotification(builder.toString());
        }
        return result.isSuccess();
    }

    private static void setCheckParamEntry(IFormView view, IDataModel model, DynamicObject project) {
        DynamicObjectCollection checkParamEntry = model.getEntryEntity("checkparamentry");
        DynamicObjectCollection checkParamEntrys = project.getDynamicObjectCollection("checkparamentry");
        checkParamEntrys.clear();
        HashMap<Long, Object> checkMap = new HashMap<Long, Object>(16);
        LinkedHashMap<String, List<Integer>> errorMsgs = new LinkedHashMap<String, List<Integer>>(16);
        MigrateUserGuideProjectHelper.checkParamData(view, checkParamEntry, checkMap, errorMsgs);
        if (MapUtils.isNotEmpty(errorMsgs)) {
            return;
        }
        for (DynamicObject entry : checkParamEntry) {
            DynamicObject migrateParamEntry = checkParamEntrys.addNew();
            migrateParamEntry.set("seq", entry.get("seq"));
            migrateParamEntry.set("checkitemvar", entry.get("checkitemvar"));
            migrateParamEntry.set("checkstatusvar", entry.get("checkstatusvar"));
            DynamicObject check = entry.getDynamicObject("checkitemvar");
            Object value = checkMap.get(check.getPkValue());
            if (value == null) continue;
            migrateParamEntry.set("autoparam_tag", value);
        }
    }

    public static void checkParamData(IFormView view, DynamicObjectCollection checkParamEntry, Map<Long, Object> checkMap, Map<String, List<Integer>> errorMsgs) {
        String guideFormId = view.getModel().getDataEntityType().getName();
        Map<String, String> autoFields = MigrateUserGuideProjectHelper.autoFields(guideFormId, MigrateUserGuideProjectHelper.getProjectId(view));
        ArrayList<String> list = new ArrayList<String>(16);
        for (String autoFiledNum : autoFields.keySet()) {
            if (!autoFiledNum.contains("imscdmw_")) continue;
            String substring = autoFiledNum.substring("imscdmw_".length(), autoFiledNum.length());
            list.add(substring);
        }
        QFilter numbers = QFilterUtils.getAllDataQFilter().and("number", "in", list);
        String checkParamForm = MigrateUserGuideProjectHelper.getCheckParamFormIdByUserGuide(view);
        DynamicObjectCollection dataTypes = QueryServiceHelper.query((String)checkParamForm, (String)"number,datatype", (QFilter[])numbers.toArray());
        HashMap<String, String> dataTypeMap = new HashMap<String, String>(16);
        for (DynamicObject dataType : dataTypes) {
            dataTypeMap.put("imscdmw_" + dataType.getString("number"), dataType.getString("datatype"));
        }
        Set checkItems = checkParamEntry.stream().map(n -> (Long)n.getDynamicObject("checkitemvar").getPkValue()).collect(Collectors.toSet());
        for (int i = 0; i < checkParamEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)checkParamEntry.get(i);
            DynamicObject check = entry.getDynamicObject("checkitemvar");
            String paramMapping = view.getPageCache().get("checkParamMapping");
            Map paramFieldMap = (Map)JSONObject.parseObject((String)paramMapping, Map.class);
            Map fieldMaps = (Map)paramFieldMap.get(check.getPkValue());
            Set checkItemVar = fieldMaps.keySet();
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            HashMap<String, String> fieldMessage = new HashMap<String, String>(16);
            for (Map.Entry<String, String> entrySet : autoFields.entrySet()) {
                String[] valuesSplit;
                String autoField = entrySet.getKey();
                String substring = autoField.substring("imscdmw_".length());
                if (!checkItemVar.contains(substring)) continue;
                String paramValue = (String)entry.get(autoField);
                paramMap.put(autoField, paramValue);
                String fieldName = entrySet.getValue();
                fieldMessage.put(autoField, fieldName);
                String datatype = (String)dataTypeMap.get(autoField);
                int seq = i + 1;
                block14: for (String value : valuesSplit = paramValue.split(";")) {
                    if (StringUtil.isEmpty(value)) continue;
                    switch (datatype) {
                        case "A": {
                            if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) continue block14;
                            errorMsgs.putIfAbsent(autoField, new ArrayList(16));
                            List<Integer> integers = errorMsgs.get(autoField);
                            integers.add(seq);
                            continue block14;
                        }
                        case "B": {
                            if (MigrateUserGuideProjectHelper.isNumeric(value)) continue block14;
                            errorMsgs.putIfAbsent(autoField, new ArrayList(16));
                            List<Integer> integers = errorMsgs.get(autoField);
                            integers.add(seq);
                            continue block14;
                        }
                        case "C": {
                            if (MigrateUserGuideProjectHelper.isDateFormatValid(value)) continue block14;
                            errorMsgs.putIfAbsent(autoField, new ArrayList(16));
                            List<Integer> integers = errorMsgs.get(autoField);
                            integers.add(seq);
                            continue block14;
                        }
                    }
                }
            }
            paramMap.put("autoFieldMessage", fieldMessage);
            checkMap.put(check.getLong("id"), JSONObject.toJSONString(paramMap));
        }
        if (MapUtils.isNotEmpty(errorMsgs)) {
            StringBuilder errorMsgString = new StringBuilder();
            errorMsgString.append(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c", (String)"MigrateUserGuideFormPlugin_44", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            for (Map.Entry<String, List<Integer>> error : errorMsgs.entrySet()) {
                String msg;
                String key = error.getKey();
                List<Integer> value = error.getValue();
                String join = StringUtil.join(value, ",");
                String datatype = (String)dataTypeMap.get(key);
                String fieldName = autoFields.get(key);
                if (ADD_NODE.equals(datatype)) {
                    msg = String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u8303\u56f4\u53d8\u91cf\u8bbe\u7f6e\u5b57\u6bb5\u201c%1$s\u201d,\u7b2c%2$s\u884c\u8f93\u5165\u53c2\u6570\u9ed8\u8ba4\u503c\u9519\u8bef,\u53ea\u80fd\u8f93\u5165\u201ctrue\u201d\u6216\u201cfalse\u201d\u3002", (String)"MigrateUserGuideFormPlugin_41", (String)"imsc-dmw-platform", (Object[])new Object[0]), fieldName, join);
                    errorMsgString.append(msg);
                    continue;
                }
                if (ADD_NONE.equals(datatype)) {
                    msg = String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u8303\u56f4\u53d8\u91cf\u8bbe\u7f6e\u5b57\u6bb5\u201c%1$s\u201d,\u7b2c%2$s\u884c\u8f93\u5165\u53c2\u6570\u9ed8\u8ba4\u503c\u683c\u5f0f\u9519\u8bef\uff0c\u53ea\u80fd\u8f93\u5165\u6570\u5b57\u7c7b\u578b\u3002", (String)"MigrateUserGuideFormPlugin_42", (String)"imsc-dmw-platform", (Object[])new Object[0]), fieldName, join);
                    errorMsgString.append(msg);
                    continue;
                }
                if (!ADD_PARENT.equals(datatype)) continue;
                msg = String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u8303\u56f4\u53d8\u91cf\u8bbe\u7f6e\u5b57\u6bb5\u201c%1$s\u201d,\u7b2c%2$s\u884c\u8f93\u5165\u53c2\u6570\u9ed8\u8ba4\u503c\u683c\u5f0f\u9519\u8bef\uff0c\u53ea\u80fd\u6309\uff08\u5e74/\u6708/\u65e5\uff09\u683c\u5f0f\u586b\u5199\u3002", (String)"MigrateUserGuideFormPlugin_43", (String)"imsc-dmw-platform", (Object[])new Object[0]), fieldName, join);
                errorMsgString.append(msg);
            }
            view.showTipNotification(errorMsgString.toString());
        }
    }

    public static Map<String, String> autoFields(String form, Object projectId) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(16);
        if (StringUtil.isEmpty(form)) {
            return map;
        }
        String checkForm = MigrateUserGuideProjectHelper.getCheckItemFormIdByUserGuide(form);
        if (StringUtil.isEmpty(checkForm)) {
            return map;
        }
        DynamicObjectCollection checkItems = QueryServiceHelper.query((String)checkForm, (String)"paramentry.varsign", (QFilter[])QFilterUtils.getAllDataQFilter().toArray());
        Set varSignSet = checkItems.stream().map(n -> n.getLong("paramentry.varsign")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "in", varSignSet);
        String checkParamForm = MigrateUserGuideProjectHelper.getCheckParamFormIdByUserGuide(form);
        DynamicObjectCollection params = QueryServiceHelper.query((String)checkParamForm, (String)"name,number", (QFilter[])qFilter.toArray(), (String)"number");
        for (DynamicObject param : params) {
            String number = param.getString("number");
            String key = "imscdmw_" + number;
            String name = param.getString("name");
            map.put(key, name);
        }
        if (projectId != null && Long.parseLong(projectId.toString()) != 0L) {
            String migProject = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(form);
            QFilter qFilterProject = new QFilter("id", "=", (Object)Long.valueOf(projectId.toString()));
            DynamicObjectCollection querys = QueryServiceHelper.query((String)migProject, (String)"id,checkparamentry.autoparam_tag", (QFilter[])qFilterProject.toArray());
            for (DynamicObject query : querys) {
                String autoParamTag = query.getString("checkparamentry.autoparam_tag");
                if (!StringUtil.isNotEmpty(autoParamTag)) continue;
                Map paramMaps = (Map)JSONObject.parseObject((String)autoParamTag, Map.class);
                for (Map.Entry param : paramMaps.entrySet()) {
                    String key = (String)param.getKey();
                    String s = (String)map.get(key);
                    if ("autoFieldMessage".equals(key) || s != null) continue;
                    map.put(key, key);
                }
                Map fieldMessages = (Map)paramMaps.get("autoFieldMessage");
                if (!MapUtils.isNotEmpty((Map)fieldMessages)) continue;
                for (Map.Entry fieldMessage : fieldMessages.entrySet()) {
                    map.put((String)fieldMessage.getKey(), (String)fieldMessage.getValue());
                }
            }
        }
        LinkedHashMap sortedLinkedMap = map.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        return sortedLinkedMap;
    }

    public static Map<Long, Object> getIdMappingMap(DynamicObjectCollection entries, String table) {
        HashMap<Long, Object> idMappings = new HashMap<Long, Object>(16);
        List allTreeIds = entries.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        long[] ids = DB.genLongIds((String)table, (int)allTreeIds.size());
        for (int i = 0; i < allTreeIds.size(); ++i) {
            idMappings.put((Long)allTreeIds.get(i), ids[i]);
        }
        return idMappings;
    }

    public static Map<Long, Object> getIscObjMapping(DynamicObjectCollection guideScopeEntryColl, String migrationModel) {
        HashMap<Long, Object> iscObjMappings = new HashMap<Long, Object>(16);
        HashMap iscMaps = new HashMap(16);
        HashMap<String, Long> migrateObjMapping = new HashMap<String, Long>(16);
        for (DynamicObject schemeEntry : guideScopeEntryColl) {
            DynamicObject migObj = schemeEntry.getDynamicObject("migrateobject");
            String initType = migObj.getString("initintegrattype");
            if (StringUtil.isEmpty(initType)) continue;
            if (migrationModel.equals(ADD_NODE)) {
                Long initSchemeId = migObj.getLong("initschemeid");
                iscMaps.putIfAbsent(initType, new ArrayList(4));
                List initschemeList = (List)iscMaps.get(initType);
                String key = initType + "&&" + initSchemeId;
                migrateObjMapping.put(key, (Long)migObj.getPkValue());
                initschemeList.add(initSchemeId);
                continue;
            }
            String allType = migObj.getString("allintegrattype");
            Long allSchemeId = migObj.getLong("allschemeid");
            iscMaps.putIfAbsent(allType, new ArrayList(4));
            List allSchemeList = (List)iscMaps.get(allType);
            allSchemeList.add(allSchemeId);
            String value = allType + "&&" + allSchemeId;
            migrateObjMapping.put(value, (Long)migObj.getPkValue());
        }
        for (Map.Entry map : iscMaps.entrySet()) {
            String type = (String)map.getKey();
            List schemeId = (List)map.getValue();
            Map iscSchemeMap = new HashMap(2);
            try {
                iscSchemeMap = BusinessDataServiceHelper.loadFromCache((Object[])schemeId.toArray(), (String)type);
            }
            catch (KDException e) {
                logger.error((Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u8fc1\u79fb\u65b9\u6848\u627e\u4e0d\u5230\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"MigrateUserGuideProjectHelper_14", (String)"imsc-dmw-platform", (Object[])new Object[0]));
            }
            for (Map.Entry iscScheme : iscSchemeMap.entrySet()) {
                String key = type + "&&" + iscScheme.getKey();
                Long migrateObj = (Long)migrateObjMapping.get(key);
                iscObjMappings.put(migrateObj, iscScheme.getValue());
            }
        }
        return iscObjMappings;
    }

    public static boolean isExistProject(IFormView view) {
        String value = view.getPageCache().get("existProject");
        return StringUtils.isNotEmpty((CharSequence)value);
    }

    public static String getProjectStatus(IFormView view) {
        String status = view.getPageCache().get("projectstatus");
        if (StringUtils.isEmpty((CharSequence)status)) {
            return ADD_NODE;
        }
        return status;
    }

    private static Long[] getEasOrgIds(String easOrgIds) {
        String[] easOrgIdStr = StringUtils.isBlank((CharSequence)easOrgIds) ? new String[]{} : easOrgIds.split(",");
        Long[] easOrgIdLong = new Long[easOrgIdStr.length];
        for (int i = 0; i < easOrgIdStr.length; ++i) {
            try {
                easOrgIdLong[i] = Long.valueOf(easOrgIdStr[i]);
                continue;
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                return new Long[0];
            }
        }
        return easOrgIdLong;
    }

    public static String getProjectFormIdByUserGuide(IFormView view) {
        String guideFormId = view.getModel().getDataEntityType().getName();
        String billFormId = "";
        switch (guideFormId) {
            case "dmw_migrateuserguide_eas": {
                billFormId = "dmw_migrateproject_eas";
                break;
            }
            case "dmw_migrateuserguide_nc": {
                billFormId = "dmw_migrateproject_nc";
                break;
            }
            case "dmw_migrateuserguide_ecc": {
                billFormId = "dmw_migrateproject_ecc";
                break;
            }
        }
        return billFormId;
    }

    public static String getProjectFormIdByUserGuide(String form) {
        String billFormId = "";
        switch (form) {
            case "dmw_migrateuserguide_eas": {
                billFormId = "dmw_migrateproject_eas";
                break;
            }
            case "dmw_migrateuserguide_nc": {
                billFormId = "dmw_migrateproject_nc";
                break;
            }
            case "dmw_migrateuserguide_ecc": {
                billFormId = "dmw_migrateproject_ecc";
                break;
            }
        }
        return billFormId;
    }

    public static String getObjectFormIdByUserGuide(IFormView view) {
        String guideFormId = view.getModel().getDataEntityType().getName();
        String billFormId = "";
        switch (guideFormId) {
            case "dmw_migrateuserguide_eas": {
                billFormId = "dmw_migrateobject_eas";
                break;
            }
            case "dmw_migrateuserguide_nc": {
                billFormId = "dmw_migrateobject_nc";
                break;
            }
            case "dmw_migrateuserguide_ecc": {
                billFormId = "dmw_migrateobject_ecc";
                break;
            }
        }
        return billFormId;
    }

    public static String getCheckParamFormIdByUserGuide(IFormView view) {
        String guideFormId = view.getModel().getDataEntityType().getName();
        String billFormId = "";
        switch (guideFormId) {
            case "dmw_migrateuserguide_eas": {
                billFormId = "dmw_checkitem_param_eas";
                break;
            }
            case "dmw_migrateuserguide_nc": {
                billFormId = "dmw_checkitem_param_nc";
                break;
            }
            case "dmw_migrateuserguide_ecc": {
                billFormId = "dmw_checkitem_param_ecc";
                break;
            }
        }
        return billFormId;
    }

    public static String getCheckParamFormIdByUserGuide(String form) {
        String billFormId = "";
        switch (form) {
            case "dmw_migrateuserguide_eas": {
                billFormId = "dmw_checkitem_param_eas";
                break;
            }
            case "dmw_migrateuserguide_nc": {
                billFormId = "dmw_checkitem_param_nc";
                break;
            }
            case "dmw_migrateuserguide_ecc": {
                billFormId = "dmw_checkitem_param_ecc";
                break;
            }
        }
        return billFormId;
    }

    public static String getMigModuleFormIdByUserGuide(IFormView view) {
        String guideFormId = view.getModel().getDataEntityType().getName();
        String billFormId = "";
        switch (guideFormId) {
            case "dmw_migrateuserguide_eas": {
                billFormId = "dmw_migratemodule_eas";
                break;
            }
            case "dmw_migrateuserguide_nc": {
                billFormId = "dmw_migratemodule_nc";
                break;
            }
            case "dmw_migrateuserguide_ecc": {
                billFormId = "dmw_migratemodule_ecc";
                break;
            }
        }
        return billFormId;
    }

    public static String getMigObjFormIdByUserGuide(String form) {
        String billFormId = "";
        switch (form) {
            case "dmw_migrateuserguide_eas": {
                billFormId = "dmw_migrateobject_eas";
                break;
            }
            case "dmw_migrateuserguide_nc": {
                billFormId = "dmw_migrateobject_nc";
                break;
            }
            case "dmw_migrateuserguide_ecc": {
                billFormId = "dmw_migrateobject_ecc";
                break;
            }
        }
        return billFormId;
    }

    public static String getModuleFormIdByUserGuide(IFormView view) {
        String guideFormId = view.getModel().getDataEntityType().getName();
        String billFormId = "";
        switch (guideFormId) {
            case "dmw_migrateuserguide_eas": {
                billFormId = "dmw_migratemodule_eas";
                break;
            }
            case "dmw_migrateuserguide_nc": {
                billFormId = "dmw_migratemodule_nc";
                break;
            }
            case "dmw_migrateuserguide_ecc": {
                billFormId = "dmw_migratemodule_ecc";
                break;
            }
        }
        return billFormId;
    }

    public static String getCheckItemFormIdByUserGuide(IFormView view) {
        String guideFormId = view.getModel().getDataEntityType().getName();
        String billFormId = "";
        switch (guideFormId) {
            case "dmw_migrateuserguide_eas": {
                billFormId = "dmw_migratecheckitem_eas";
                break;
            }
            case "dmw_migrateuserguide_nc": {
                billFormId = "dmw_migratecheckitem_nc";
                break;
            }
            case "dmw_migrateuserguide_ecc": {
                billFormId = "dmw_migratecheckitem_ecc";
                break;
            }
        }
        return billFormId;
    }

    public static String getCheckItemFormIdByUserGuide(String form) {
        String billFormId = "";
        switch (form) {
            case "dmw_migrateuserguide_eas": {
                billFormId = "dmw_migratecheckitem_eas";
                break;
            }
            case "dmw_migrateuserguide_nc": {
                billFormId = "dmw_migratecheckitem_nc";
                break;
            }
            case "dmw_migrateuserguide_ecc": {
                billFormId = "dmw_migratecheckitem_ecc";
                break;
            }
        }
        return billFormId;
    }

    public static String getIgnoreLogFormIdByUserGuide(IFormView view) {
        String guideFormId = view.getModel().getDataEntityType().getName();
        String billFormId = "";
        switch (guideFormId) {
            case "dmw_migrateuserguide_eas": {
                billFormId = "dmw_ignorelog_eas";
                break;
            }
            case "dmw_migrateuserguide_nc": {
                billFormId = "dmw_ignorelog_nc";
                break;
            }
            case "dmw_migrateuserguide_ecc": {
                billFormId = "dmw_ignorelog_ecc";
                break;
            }
        }
        return billFormId;
    }

    public static String getIgnoreLogFormIdByUserGuide(String form) {
        String billFormId = "";
        switch (form) {
            case "dmw_migrateuserguide_eas": {
                billFormId = "dmw_ignorelog_eas";
                break;
            }
            case "dmw_migrateuserguide_nc": {
                billFormId = "dmw_ignorelog_nc";
                break;
            }
            case "dmw_migrateuserguide_ecc": {
                billFormId = "dmw_ignorelog_ecc";
                break;
            }
        }
        return billFormId;
    }

    public static String getSchemeFormIdByUserGuide(IFormView view) {
        String guideFormId = view.getModel().getDataEntityType().getName();
        String billFormId = "";
        switch (guideFormId) {
            case "dmw_migrateuserguide_eas": {
                billFormId = "dmw_migratescheme_eas";
                break;
            }
            case "dmw_migrateuserguide_nc": {
                billFormId = "dmw_migratescheme_nc";
                break;
            }
            case "dmw_migrateuserguide_ecc": {
                billFormId = "dmw_migratescheme_ecc";
                break;
            }
        }
        return billFormId;
    }

    public static String getRepairLogFormIdByUserGuide(IFormView view) {
        String guideFormId = view.getModel().getDataEntityType().getName();
        String billFormId = "";
        switch (guideFormId) {
            case "dmw_migrateuserguide_eas": {
                billFormId = "dmw_migraterepairlog_eas";
                break;
            }
            case "dmw_migrateuserguide_nc": {
                billFormId = "dmw_migraterepairlog_nc";
                break;
            }
            case "dmw_migrateuserguide_ecc": {
                billFormId = "dmw_migraterepairlog_ecc";
                break;
            }
        }
        return billFormId;
    }

    public static String getMigObjectTableNameByUserGuide(IFormView view) {
        String projectFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(view);
        if (StringUtil.isEmpty(projectFormId)) {
            return "";
        }
        return MigrateUserGuideProjectHelper.getMigObjectTableNameByProjectFormId(projectFormId);
    }

    public static String getMigCheckTableNameByUserGuide(IFormView view) {
        String projectFormId = MigrateUserGuideProjectHelper.getProjectFormIdByUserGuide(view);
        if (StringUtil.isEmpty(projectFormId)) {
            return "";
        }
        return MigrateUserGuideProjectHelper.getMigCheckTableNameByProjectFormId(projectFormId);
    }

    public static String getMigObjectTableNameByProjectFormId(String projectFormId) {
        DynamicObject newDynObj = BusinessDataServiceHelper.newDynamicObject((String)projectFormId);
        return newDynObj.getDynamicObjectCollection("treeentryentity").getDynamicObjectType().getAlias();
    }

    public static String getMigCheckTableNameByProjectFormId(String projectFormId) {
        DynamicObject newDynObj = BusinessDataServiceHelper.newDynamicObject((String)projectFormId);
        return newDynObj.getDynamicObjectCollection("checktreeentryentity").getDynamicObjectType().getAlias();
    }

    public static String getMigCheckParamTableNameByProjectFormId(String projectFormId) {
        DynamicObject newDynObj = BusinessDataServiceHelper.newDynamicObject((String)projectFormId);
        return newDynObj.getDynamicObjectCollection("checkparamentry").getDynamicObjectType().getAlias();
    }

    public static boolean verifyManualEntryMigrateStatus(IFormView view) {
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("migtreeentryentity");
        boolean isExist = false;
        for (DynamicObject migrateItemEntry : entryEntity) {
            if (!"2".equals(migrateItemEntry.getString("migrateexecutetype")) || !ADD_NONE.equals(migrateItemEntry.getString("migratestatus"))) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    public static void handleCopyMulScheme(IFormView view, DynamicObject project) {
        IDataModel model = view.getModel();
        model.beginInit();
        DynamicObjectCollection schemes = project.getDynamicObjectCollection("mulmigratescheme");
        DynamicObjectCollection belongSchemes = (DynamicObjectCollection)model.getValue("mulmigratescheme");
        for (int i = 0; i < schemes.size(); ++i) {
            DynamicObject mulScheme = (DynamicObject)schemes.get(i);
            DynamicObject scheme = mulScheme.getDynamicObject("fbasedataid");
            if (CommonUtils.isNull(scheme)) continue;
            String status = scheme.getString("status");
            String enable = scheme.getString("enable");
            if (!ADD_PARENT.equals(status) || !"1".equals(enable)) continue;
            DynamicObject tempSchemes = new DynamicObject(belongSchemes.getDynamicObjectType());
            tempSchemes.set("fbasedataid_id", scheme.getPkValue());
            tempSchemes.set("fbasedataid", (Object)scheme);
            belongSchemes.add((Object)tempSchemes);
        }
        model.endInit();
    }

    public static Map<Long, DynamicObject> getEntryMigObjMap(DynamicObjectCollection entryEntities, String tableName, String objField) {
        HashMap<Long, DynamicObject> migObjMap = new HashMap<Long, DynamicObject>(8);
        if (entryEntities != null) {
            List idList = entryEntities.stream().map(n -> n.getLong(objField)).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", idList);
            DynamicObjectCollection migObjList = QueryServiceHelper.query((String)tableName, (String)"id,number,name,illustrate,supportorgmig,supportperiodmig", (QFilter[])qFilter.toArray());
            for (DynamicObject migObj : migObjList) {
                migObjMap.put(migObj.getLong("id"), migObj);
            }
        }
        return migObjMap;
    }

    public static String getOrgNumber(IFormView view) {
        DynamicObjectCollection easOrges = view.getModel().getEntryEntity("easorgrangef7");
        if (CommonUtils.isNull(easOrges)) {
            return "*";
        }
        StringBuilder orgNumber = new StringBuilder();
        for (DynamicObject mulOrg : easOrges) {
            DynamicObject scheme = mulOrg.getDynamicObject("fbasedataid");
            orgNumber.append(scheme.getString("number")).append(';');
        }
        orgNumber.deleteCharAt(orgNumber.length() - 1);
        return orgNumber.toString();
    }

    public static String getOrgNumberArray(IFormView view) {
        DynamicObjectCollection easOrges = view.getModel().getEntryEntity("easorgrangef7");
        if (CommonUtils.isNull(easOrges)) {
            return "*";
        }
        StringBuilder orgNumber = new StringBuilder("[");
        for (DynamicObject mulOrg : easOrges) {
            DynamicObject scheme = mulOrg.getDynamicObject("fbasedataid");
            orgNumber.append('\'').append(scheme.getString("number")).append("',");
        }
        orgNumber.deleteCharAt(orgNumber.length() - 1);
        orgNumber.append(']');
        return orgNumber.toString();
    }

    public static String getStartPeriod(IFormView view) {
        List<Map<String, Object>> resultList = MigrateUserGuideProjectHelper.getAllPeriodResult(view);
        if (resultList.isEmpty()) {
            return "*";
        }
        return resultList.get(0).get("periodnumber").toString();
    }

    public static List<Map<String, Object>> getAllPeriodResult(IFormView view) {
        String sql;
        IDataModel model = view.getModel();
        Date date = (Date)model.getValue("begindate");
        List<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(8);
        if (CommonUtils.isNull(date)) {
            return resultList;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = "{ts'" + dateFormat.format(date) + "'}";
        DynamicObjectCollection easOrgMul = (DynamicObjectCollection)model.getValue("easorgrangef7");
        ArrayList<Long> easOrgIdList = new ArrayList<Long>(8);
        for (DynamicObject easOrg : easOrgMul) {
            if (easOrg == null) continue;
            easOrgIdList.add(easOrg.getLong("fbasedataid_id"));
        }
        QFilter filter = new QFilter("id", "in", easOrgIdList);
        DynamicObjectCollection easOrgArray = QueryServiceHelper.query((String)"dmw_eas_org", (String)"id,number,easfid", (QFilter[])filter.toArray());
        StringBuilder easOrgNum = new StringBuilder();
        StringBuilder easOrgFid = new StringBuilder();
        for (DynamicObject easOrg : easOrgArray) {
            String tempNum = easOrg.getString("number");
            String tempFid = easOrg.getString("easfid");
            easOrgNum.append('\'').append(tempNum).append('\'').append(',');
            easOrgFid.append('\'').append(tempFid).append('\'').append(',');
        }
        if (easOrgNum.length() == 0 || easOrgFid.length() == 0) {
            sql = "select a.fid,a.fnumber,a.fname_l2,a.FACCOUNTPERIODID,c.fnumber as periodnumber,c.FPERIODYEAR ,c.FPERIODQUARTER,c.FPERIODNUMBER ,c.FBEGINDATE ,c.FENDDATE   from T_ORG_COMPANY as a left join t_bd_periodType as b on a.FACCOUNTPERIODID = b.fid left join t_bd_period as c on c.FTYPEID  = b.fid where c.FISADJUSTPERIOD = '0' and c.FBEGINDATE <= " + dateStr + " and c.FENDDATE >= " + dateStr;
        } else {
            easOrgNum.deleteCharAt(easOrgNum.length() - 1);
            easOrgFid.deleteCharAt(easOrgFid.length() - 1);
            sql = "select a.fid,a.fnumber,a.fname_l2,a.FACCOUNTPERIODID,c.fnumber as periodnumber,c.FPERIODYEAR ,c.FPERIODQUARTER,c.FPERIODNUMBER ,c.FBEGINDATE ,c.FENDDATE   from T_ORG_COMPANY as a left join t_bd_periodType as b on a.FACCOUNTPERIODID = b.fid left join t_bd_period as c on c.FTYPEID  = b.fid where c.FISADJUSTPERIOD = '0' and (a.fnumber in (" + easOrgNum + ") or a.fid in (" + easOrgFid + ")) and c.FBEGINDATE <= " + dateStr + " and c.FENDDATE >= " + dateStr;
        }
        DynamicObject dbLink = (DynamicObject)model.getValue("dblink");
        Long dbLinkId = (Long)dbLink.getPkValue();
        resultList = EasQueryHelper.queryEasData(dbLinkId, sql);
        return resultList;
    }

    public static String getStartDate(IFormView view) {
        Date date = (Date)view.getModel().getValue("begindate");
        if (CommonUtils.isNull(date)) {
            return "*";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat.format(date);
    }

    private static Long getProjectId(IFormView view) {
        String project = view.getPageCache().get("existProject");
        if (StringUtils.isEmpty((CharSequence)project)) {
            return 0L;
        }
        return Long.parseLong(project);
    }

    public static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }

    public static boolean isDateFormatValid(String date) {
        String regex = "^\\d{4}/\\d{1,2}/\\d{1,2}$";
        return Pattern.matches(regex, date);
    }
}

